8       SUBROUTINE PLOT_DEVICE_CM(IMON1,IOUT1,IMON2,IOUT2,8      #                          PAGES,MODE,IBIT,*,*,*,*)H C***********************************************************************H C                                                                      *H C    Reqd. KOSTL: routines - HCOPYRANG, MONITRANG, MONIT2RNG           *H C                                                                      *H C    This routine calls HARDCOPY_RANGE, MONITOR_RANGE, and             *H C    MONITOR2_RANGE setting up the user units for plotting in          *H C    centimeters.  The PRINTRONIX hardcopy will always be one page     *H C    while the ZETA pen plotter hardcopy will be PAGES long.           *H C                                                                      *H C    NOTE:  PAGES may be changed, if outside the valid range, so       *H C           do NOT use a literal for this parameter!!!                 *H C                                                                      *H C    Two modes are allowed: LANDSCAPE and PORTRAIT.                    *H C    The viewport will have the correct aspect ratio (i.e. circles     *H C    will be circles on the screen and on the pen plotter).  If the    *H C    plotter is the HP plotter or the QMS Lasergrafix, then only one   *H C    page of hardcopy is allowed.                                      *H C      In LANDSCAPE mode, the user units range will be:                *H C                                                                      *H C   ZETA::     0. <= X <= 27.94           0. <= Y <= 21.59*PAGES       *H C     HP::     0. <= X <= 25.36           0. <= Y <= 19.07             *H C    QMS::     0. <= X <= 27.94           0. <= Y <= 21.59             *H C                                                                      *H C      In PORTRAIT mode,  the user units range will be:                *H C                                                                      *H C   ZETA::     0. <= X <= 21.59*PAGES     0. <= Y <= 27.94             *H C     HP::     0. <= X <= 19.07           0. <= Y <= 25.36             *H C    QMS::     0. <= X <= 21.59           0. <= Y <= 27.94             *H C                                                                      *H C      where PAGES is restricted to be 1., 2., 3., ..., 10.            *H C      for the ZETA plotter and restricted to be only 1. for the HP    *H C      and the QMS plotters                                            *H C                                                                      *H C     Input:                                                           *H C                                                                      *H C INTEGER*4     IMON1 = 0: no monitor                                  *H C                     = 1: VT640                                       *H C                     = 2: Tektronix 4010/12                           *H C                     = 3: VS11                                        *H C                     = 6: CIT-467                                     *H C                     = 7: TEK4107                                     *H C                     = 8: VT241                                       *H C                     = 9: PT100G                                      *H C    "          IOUT1 = screen output unit (usually 6)                 *H C    "          IMON2 = 4: ZETA plotter                                *H C                     = 5: HP plotter                                  *H C                     =10: QMS Lasergrafix                             *H C    "          IOUT2 = plotter output unit (usually 7)                *H C    "          IBIT  =  1 ->  700 x  785,          PRINTRONIX         *H C                "       2 -> 1000 x  750, 100 dpi, HP Laserjet        *H C                "       3 ->  853 x  640, 96 dpi,  HP Thinkjet        *H C                "       4 -> 1055 x  433,          LA100              *H C                                                                      *H C REAL*4        PAGES = Number of pages of plotter hardcopy            *H C                       restricted to be between 1 and 10 (for ZETA)   *H C                              "   "  "     1 only (for HP or QMS)     *H C CHARACTER*(*)  MODE = 'LANDSCAPE' or 'PORTRAIT'                      *H C                       only the first character of MODE is tested     *H C                                                                      *H C           RETURN1   if MODE(1:1) is neither 'P' nor 'L'              *H C           RETURN2   if IMON1 is not 0,1,2,3,6,7, or 8                *H C           RETURN3   if IMON2 is not 4 or 5 or 10                     *H C           RETURN4   if IBIT is not valid                             *H C                                                                      *H C                                       Joe Chuma                      *H C                                       January, 1985                  *H C       Revised December, 1985                                         *H C                                                                      *H C***********************************************************************       CHARACTER*(*) MODEH C                                                                      *H C    Restrict number of pages to be an integer between 1 and 10        *H C                                                                      *?        XPAGES = FLOAT( MAX(1, MIN( IFIX( PAGES+0.99 ), 10 ) ) ) H C                                                                      *       IF(IMON2 .EQ. 4)THEN         PAGES = XPAGES         XMAX = 21.59         YMAX = 27.94       ELSE IF(IMON2 .EQ. 5)THEN(         PAGES = 1.         XMAX = 19.07         YMAX = 25.36        ELSE IF(IMON2 .EQ. 10)THEN         PAGES = 1.         XMAX = 21.59         YMAX = 27.94
       ELSE7         RETURN3                   ! INVALID 2nd MONITOR       END IF       SCALE = XMAX / YMAXB       IORHC  = -1        FACTOR = 1.0.       IF(IBIT .EQ. 1)THEN         ! PRINTRONIX         FACTOR = 1.2         YMAXHC = 784.         XMAXHC = 699. /       ELSE IF(IBIT .EQ. 2)THEN    ! HP Laserjet          XMAXHC = 749.          YMAXHC = 999. /       ELSE IF(IBIT .EQ. 3)THEN    ! HP Thinkjet          XMAXHC = 639.          YMAXHC = 852. )       ELSE IF(IBIT .EQ. 4)THEN    ! LA100          XMAXHC = 432.          YMAXHC = 1054.
       ELSE9         RETURN 4                  ! Invalid bitmap device        END IF        IF(MODE(1:1) .EQ. 'L')THENH C                                                                      *H C    Set up the correct aspect ratio for the terminal screen           *H C    and centre the viewport on the screen                             *H C    for the LANDSCAPE mode case                                       *H C                                                                      *         IF(IMON1 .EQ. 6)THENH C                                                                      *H C    CIT467                                                            *H C                                                                      *0           XMN = 571. / 2. * (PAGES - 1.) / PAGES0           XMX = 571. / 2. * (PAGES + 1.) / PAGES*           YMN = (479. - 571. * SCALE) / 2.$           YMX =  YMN  + 571. * SCALEE        ELSE IF((IMON1 .EQ. 1).OR.(IMON1 .EQ. 7).OR.(IMON1 .EQ. 8).OR. #      #         (IMON1 .EQ. 9)) THEN H C                                                                      *H C    VT640 or TK4107 or VT241 or PT100G                                *H C                                                                      *2           XMN = (639. - 479. / SCALE / PAGES) / 2.2           XMX = (639. + 479. / SCALE / PAGES) / 2.           YMN = 0.           YMX = 479.!         ELSE IF(IMON1 .EQ. 3)THEN H C                                                                      *H C    VS11                                                              *H C                                                                      *0           XMN = 511. / 2. * (PAGES - 1.) / PAGES0           XMX = 511. / 2. * (PAGES + 1.) / PAGES*           YMN = (479. - 511. * SCALE) / 2.$           YMX =  YMN  + 511. * SCALE!         ELSE IF(IMON1 .EQ. 2)THEN H C                                                                      *H C    Tektronix 4010/12                                                 *H C                                                                      *3           XMN = (1023. - 779. / SCALE / PAGES) / 2. 3           XMX = (1023. + 779. / SCALE / PAGES) / 2.            YMN = 0.           YMX = 779.!         ELSE IF(IMON1 .EQ. 0)THEN H C                                                                      *H C    VT100                                                             *H C                                                                      *           XMN = 0.           XMX = 639.           YMN = 0.           YMX = 479.         ELSE@           RETURN2                        ! INVALID FIRST MONITOR         END IF         YMINP = 0.'         YMAXP = XMAXHC / SCALE / FACTOR          XMINP = 0.         XMAXP = XMAXHC;         CALL HARDCOPY_RANGE(XMINP, XMAXP, YMINP,     YMAXP, ?      #                         0.,  YMAX,    0.,PAGES*XMAX, -1) ?         CALL MONITOR_RANGE(IMON1,IOUT1,XMINP,XMAXP,YMINP,YMAXP, <      #                                 XMN,XMX, YMN,YMX, -1)8         IF(IMON2 .EQ. 4)CALL MONITOR2_RANGE(IMON2,IOUT2,H      #               XMINP,XMAXP,YMINP,YMAXP,0.,PAGES*21.59,0.,27.94,+1)8         IF(IMON2 .EQ. 5)CALL MONITOR2_RANGE(IMON2,IOUT2,E      #                  XMINP,XMAXP,YMINP,YMAXP,0.,25.36,0.,19.07,-1) 8         IF(IMON2 .EQ.10)CALL MONITOR2_RANGE(IMON2,IOUT2,C      #                XMINP,XMAXP,YMINP,YMAXP,0.,3299.,2549.,0.,+1) H C                                                                      *%       ELSE IF(MODE(1:1) .EQ. 'P')THEN H C                                                                      *H C    Set up the correct aspect ratio for the terminal screen           *H C    and centre the viewport on the screen                             *H C    for the PORTRAIT mode case                                        *H C                                                                      *         IF(IMON1 .EQ. 6)THENH C                                                                      *H C    CIT467                                                            *H C                                                                      *           IF(PAGES .EQ. 1.)THEN +             XMN = (571. - 479. * SCALE) / 2 &             XMX =   XMN + 479. * SCALE             YMN =   0.             YMX = 479.           ELSE             XMN =   0.             XMX = 571.4             YMN = (479. - 571. / SCALE / PAGES) / 2.4             YMX = (479. + 571. / SCALE / PAGES) / 2.           END IFF         ELSE IF((IMON1 .EQ. 1).OR.(IMON1 .EQ. 7).OR.(IMON1 .EQ. 8).OR.$      #          (IMON1 .EQ. 9)) THENH C                                                                      *H C    VT640 or TK4107 or VT241 or PT100G                                *H C                                                                      *           IF(PAGES .EQ. 1.)THEN +             XMN = (639. - 479. * SCALE) / 2 &             XMX =   XMN + 479. * SCALE             YMN = 0.             YMX = 479.           ELSE             XMN =   0.             XMX = 639.4             YMN = (479. - 639. / SCALE / PAGES) / 2.4             YMX = (479. + 639. / SCALE / PAGES) / 2.           END IF!         ELSE IF(IMON1 .EQ. 3)THEN H C                                                                      *H C    VS11                                                              *H C                                                                      *           IF(PAGES .EQ. 1)THEN+             XMN = (511. - 479. * SCALE) / 2 &             XMX =   XMN + 479. * SCALE             YMN =   0.             YMX = 479.           ELSE             XMN =   0.             XMX = 511.4             YMN = (479. - 511. / SCALE / PAGES) / 2.4             YMX = (479. + 511. / SCALE / PAGES) / 2.           END IF!         ELSE IF(IMON1 .EQ. 2)THEN H C                                                                      *H C    Tektronix 4010/12                                                 *H C                                                                      *           IF(PAGES .EQ. 1)THEN,             XMN = (1023. - 779. * SCALE) / 2'             XMX =    XMN + 779. * SCALE              YMN =   0.             YMX = 779.           ELSE             XMN =    0.              XMX = 1023. 5             YMN = (779. - 1023. / SCALE / PAGES) / 2. 5             YMX = (779. + 1023. / SCALE / PAGES) / 2.            END IF!         ELSE IF(IMON1 .EQ. 0)THEN H C                                                                      *H C    VT100                                                             *H C                                                                      *           XMN =   0.           XMX = 639.           YMN =   0.           YMX = 479.         ELSE;           RETURN2                   ! INVALID FIRST MONITOR          END IF         YMINP = 0.'         YMAXP = XMAXHC * SCALE / FACTOR          XMINP = 0.         XMAXP = XMAXHC<         CALL HARDCOPY_RANGE(XMINP,      XMAXP, YMINP, YMAXP,@      #                         0., PAGES*XMAX,    0.,  YMAX, -1)?         CALL MONITOR_RANGE(IMON1,IOUT1,XMINP,XMAXP,YMINP,YMAXP, 0      #                       XMN,XMX,YMN,YMX,-1)8         IF(IMON2 .EQ. 4)CALL MONITOR2_RANGE(IMON2,IOUT2,H      #               XMINP,XMAXP,YMINP,YMAXP,0.,PAGES*21.59,0.,27.94,-1)8         IF(IMON2 .EQ. 5)CALL MONITOR2_RANGE(IMON2,IOUT2,E      #                  XMINP,XMAXP,YMINP,YMAXP,0.,25.36,0.,19.07,+1) 8         IF(IMON2 .EQ.10)CALL MONITOR2_RANGE(IMON2,IOUT2,C      #                XMINP,XMAXP,YMINP,YMAXP,0.,3299.,2549.,0.,-1) 
       ELSE'         RETURN 1         ! INVALID MODE        END IF       RETURN	       END 