7       SUBROUTINE PSYM(X,Y,HEIGHT,STRING,ANGLE,LENGTH,*)  C     > C  reqd. KOSTL: routines - ASCEBC,EQCMP,EQUC,FINDC,MOVEC,PLOTR C A C================================================================ A C==   PSYM package (Version 2.0)    copyright  1988   R. Lee   == A C==   Including the following routines:                        == A C==    PSYM, PALPHA, TRANSF, SPLITE, PSYMLC, PSALPH            == A C==                                                            == A C==   This subroutine produces text on a plot. Any character   == A C==   sets can be used as long as they are set up appropriately.= A C==   Note that this subroutine tries to simulate the 'PSYM' of== A C==   UBC Computer Centre, which is written in ASSEMBLER.      == A C==   It is hoped that this version is more portable and easier== A C==   to be modified.                                          == A C==                                                            == A C==   The following documentation is adapted from UBC PLOT     == A C==   (April 1981).                                            == A C==                                                            == A C==  PURPOSE:                                                  == A C==                                                            == A C==     PSYM produces text on a plot. This routine is used for == A C==     all character sets. See the description of PALPHA  for == A C==     information on alternative character sets.             == A C==                                                            == A C==  HOW TO USE:                                               == A C==                                                            == A C==           CALL PSYM(X,Y,HEIGHT,STRING,ANGLE,LENGTH,&RC4)   == A C==                                                            == A C==     where:                                                 == A C==           X,Y     are    the    floating-point    (REAL*4) == A C==                   coordinates of the first character to be == A C==                   drawn.   For   most   character    sets, == A C==                   including  the standard one, this is the == A C==                   lower-left   corner   of    the    first == A C==                   character.                               == A C==                                                            == A C==           HEIGHT  is the floating-point (REAL*4) height in == @ C==                   user units at which the string is drawn.==A C==                                                            == A C==           STRING  is the character string to be drawn.     == A C==                                                            == A C==           ANGLE   is the floating-point (REAL*4) angle  in == A C==                   degrees of the character string (using a == A C==                   positive counterclockwise convention).   == A C==                                                            == A C==           LENGTH  is   the   fullword-integer  (INTEGER*4) == A C==                   number of characters in STRING.          == A C==                                                            == A C==           &RC4    is the exit taken  for  an  unsuccessful == A C==                   return;  STRING is not drawn.  There  is == A C==                   probably  an  error  in  a  user-defined == A C==                   character set.                           == A C==                                                            == A C==  METHOD:                                                   == A C==                                                            == A C==     PSYM draws STRING with the HEIGHT specified, beginning == A C==     at (X,Y), with the angle ANGLE.                        == A C==                                                            == A C==     There   are  six   special  characters  which  produce == A C==     carriage   returns,   backspaces,   subscripts,    and == A C==     superscripts. The first character shown for each is    == A C==     used if ASIS=.TRUE. in the /MODE/ common block, i.e.   == A C==     if the input STRING is in EBCDIC code (the native      == A C==     code of the PSYM font structure). The second character == A C==     shown is used if ASIS=.FALSE. (default) in the /MODE/  == A C==     common block, i.e. if the input STRING is in ASCII     == A C==     code. In this case the STRING will be converted to     == A C==     EBCDIC code by the translation subroutine ASCEBC.      == A C==                                                            == A C== X'15':  Carriage return. This causes an immediate carriage == A C== X'0A'   return  as on a  typewriter,  where the  margin is == A C==         defined  by the  last  previous  carriage  return, == A C==         or the last explicit X, Y pair.                    == A C==                                                            == A C== X'16':  Backspace.   This  produces  a one-character back- == A C== X'08'   space.  If the alphabet currently being  used  has == A C==         letterspacing  on,  this  may  be farther than one == A C==         character back.  See the description of PALPHA for == A C==         details.                                           == A C==                                                            == A C== X'09':  Up.  If encountered while drawing  text  normally, == A C== X'09'   succeeding  text  is  drawn  as  superscripts.  If == A C==         encountered while drawing  superscripts,  text  is == A C==         drawn  at  the  next higher superscript level.  If == A C==         encountered while drawing subscripts, drawing con- == A C==         tinues at the next higher level of subscripts  (or == A C==         back  to  normal  if  there  was only one level of == A C==         subscripts).                                       == A C==                                                            == A C== X'38':  Down.  If encountered while drawing text normally, == A C== X'01'   succeeding  text  is  drawn  as  subscripts.    If == A C==         encountered  while  drawing  subscripts,  text  is == A C==         drawn at  the  next  lower  subscript  level.   If == A C==         encountered while drawing superscripts, succeeding == A C==         text  is  drawn  at the next lower level of super- == A C==         scripts (or back to normal if there was  only  one == A C==         level of superscripts).                            == A C==                                                            == A C== X'0A':  Up. It is similar to X'09',  but  the  height   is == A C== X'03'   always changed.                                    == A C==                                                            == A C== X'39':  Down. It is similar to X'38', but the  height   is == A C== X'02'   always changed.                                    == A C==                                                            == A C==        The  exact  location  and  height of subscripts and == A C==        superscripts   are  determined  by  the  particular == A C==        alphabet.   Multiple    levels  of  subscripts  and == A C==        superscripts are permitted; all  levels  are  drawn == A C==        with the same height for X'09' and X'38',  and they == A C==        are drawn with different height for X'0A' and X'39'.== A C==        When change of size occurs, it is always a fraction == A C==        of  HEIGHT.  See  the  description  of  PALPHA  for == A C==        details.                                            == A C==                                                            == A C================================================================ A C==                                                            == A C==   WRITTEN BY RICHARD T. LEE,  TRIUMF, UBC.                 == A C==                               JULY 3, 1981.                == H C                                                                      CH C  Modified April 3, 1984 by F.W. Jones to allow output to EDGR        CH C  drawing files.  Modified Sept 27/84 to encode colour.  Modified     CH C  May 15/86 to allow only positive text heights in drawing files.     CH C======================================================================C       LOGICAL ASIS       COMMON /MODE/ASIS        DATA ASIS/.FALSE./       REAL*4 X,Y,HEIGHT,ANGLE        LOGICAL EQUC&       LOGICAL*1 STRING(1),STRINGB(256)       LOGICAL*1 LINE1(56)        INTEGER*2 LINE2(256)       LOGICAL*1 LINE3(25000)>       INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,%      *          REFX,REFY,SWITC,LSPAC        LOGICAL*1 NAME(16)!       REAL*4 SHGT,SCAL,SSCAL,ANGL '       EQUIVALENCE (LINE1( 1),    SIZE), '      *            (LINE1( 3),    GRID), '      *            (LINE1( 5),   HSPAC), '      *            (LINE1( 7),   VSPAC), '      *            (LINE1( 9),   PSUPX), '      *            (LINE1(11),   PSUPY), '      *            (LINE1(13),   PSUBX), '      *            (LINE1(15),   PSUBY), '      *            (LINE1(17),    SHGT), '      *            (LINE1(21),    SCAL), '      *            (LINE1(25),   SSCAL), '      *            (LINE1(29),    ANGL), '      *            (LINE1(33),    REFX), '      *            (LINE1(35),    REFY), '      *            (LINE1(37),   SWITC), '      *            (LINE1(39),   LSPAC), &      *            (LINE1(41), NAME(1))       LOGICAL GRID16,LISPON 9       COMMON /FONT/ LINE1,LINE2,LINE3,GRID16,LISPON,MGRID A C================================================================ A C==   The following indicates that PALPHA and PSYM have never  == A C==   been called.                                             == A C================================================================ )       COMMON /CALLED/ PALPCD,PSYMCD,XC,YC        LOGICAL PALPCD,PSYMCD F       DATA PALPCD/.FALSE./,PSYMCD/.FALSE./,XC/Z80000000/,YC/Z80000000/9       COMMON /LOTRAN/ L11,L21,L31,L12,L22,L32,L13,L23,L33 .       REAL L11,L12,L13,L21,L22,L23,L31,L32,L339       COMMON /GOTRAN/ G11,G21,G31,G12,G22,G32,G13,G23,G33 9       COMMON /TOTRAN/ T11,T21,T31,T12,T22,T32,T13,T23,T33        LOGICAL*1 LOC(2),LOCL        INTEGER*2 LOCATN/Z0000/ !       EQUIVALENCE (LOC(1),LOCATN)        EQUIVALENCE (LOC(1),LOCL)        LOGICAL*1 LENCHZ(2)        INTEGER*2 LENCHA/Z0000/ $       EQUIVALENCE (LENCHZ(1),LENCHA)       LOGICAL*1 WIDTHL(2)        INTEGER*2 WIDTHC/Z0000/ $       EQUIVALENCE (WIDTHL(1),WIDTHC)0       LOGICAL*1 CTRL(6)/Z15,Z16,Z09,Z38,Z0A,Z39/1       LOGICAL*1 CTRL2(6)/Z15,Z16,Z05,Z01,Z03,Z02/        INTEGER NCTRL/6/       LOGICAL*1 FIRST,MOVETO       DATA RADE/1.745329E-2/       DATA ZM0/Z80000000/  C  C Graphics Editor COMMON: ;       COMMON/CDWG/DWGON,DWGTXT,LDWG,LDWT,IRECG,IRECT,STROKE !       LOGICAL DWGON,DWGTXT,STROKE  C        IF(LENGTH.LE.0)RETURN  C ( C Encode text into drawing file if open:#       IF(DWGON.AND..NOT.STROKE)THEN F         DWGTXT=.TRUE.      !inhibit output from PLOT_R to drawing file5         CALL PSYM_DWG(X,Y,HEIGHT,STRING,ANGLE,LENGTH) H       ENDIF                                                              C  3     LENG=MIN(LENGTH,256)       IF (PSYMCD) GO TO 5 6       IF (.NOT. PALPCD) CALL PALPHA('STANDARD ',0,&99)       PSYMCD=.TRUE. 1 C      IF (EQUC(X,ZM0) .OR. EQUC(Y,ZM0)) GO TO 99      5 CONTINUE0 C      IF (EQUC(X,ZM0) .OR. EQUC(Y,ZM0)) GO TO 7
       XC=X
       YC=Y     7 CONTINUE c  set the left margin.        XMARG=XC       YMARG=YC       LEVELS=0       LEVELV=0       DSUBX=PSUBX-REFX       DSUBY=PSUBY-REFY       DSUPX=PSUPX-REFX       DSUPY=PSUPY-REFY       SHGTD=1./SHGT A C================================================================ A C==   HERE THE GLOBAL TRANSFORMATION IS CALCULATED.            == A C==                                                            == A C================================================================        ANGLER=ANGLE*RADE        COSA=COS(ANGLER)       SINA=SIN(ANGLER)       G11=HEIGHT*COSA        G12=HEIGHT*SINA        G21=-G12
       G22=G11        G13=0.       G23=0.       G31=0.       G32=0.       G33=1.       T11=L11*G11        T12=L11*G12        T13=0.       T21=L21*G11+L22*G21        T22=L21*G12+L22*G22        T23=0.       T31=L31*G11+L32*G21        T32=L31*G12+L32*G22        T33=1.A C================================================================ A C==   EXTRACT INFORMATION FROM 'STRING'.                       == A C================================================================ ' C==     ASIS = .FALSE.  FOR CONVERSION. %       CALL MOVEC(LENG,STRING,STRINGB) 7       IF (.NOT.ASIS) CALL PASCEBC(STRINGB,STRINGB,LENG)        DO 500 I=1,LENG           LOCL=STRINGB(I)          DO 10 J=1,NCTRL          IF(ASIS)THEN -             IF (EQUC(LOCL,CTRL(J))) GO TO 400 
          ELSE -             IF(EQUC(LOCL,CTRL2(J))) GO TO 400           ENDIF    10    CONTINUE !          IFIRST=LINE2(LOCATN+1)+1 ) C         WRITE(6,1313)LOCATN,IFIRST,SIZE  1313     FORMAT(1X,3I10)'          IF (IFIRST .GT. SIZE) GO TO 99            LENCHZ(1)=LINE3(IFIRST)"          WIDTHL(1)=LINE3(IFIRST+1)          LCHARA=LENCHA    *          IF (.NOT. GRID16) LCHARA=LCHARA*2          LCHARA=LCHARA+2          FIRST=.TRUE.           IPT=3   100    CONTINUE A C================================================================ A C==   THE FOLLOWING LOOP PLOTS A COMPLETE CHARACTER.           == A C================================================================ H          CALL SPLITE(LINE3(IFIRST),LCHARA,IPT,INX,INY,MGRID,MOVETO,&110)#          XIN=XC+INX*T11+INY*T21+T31 #          YIN=YC+INX*T12+INY*T22+T32 #          IF (.NOT. FIRST) GO TO 105           CALL PLOT_R(XIN,YIN,3)           FIRST=.FALSE.          GO TO 100+   105    IF (MOVETO) CALL PLOT_R(XIN,YIN,3) 1          IF (.NOT. MOVETO) CALL PLOT_R(XIN,YIN,2)           GO TO 100   110    CONTINUE A C================================================================ A C==   LETTERSPACING IS CONSIDERED HERE.                        == A C================================================================           WIDTHH=HSPAC+GRID(          IF (LISPON) WIDTHH=LSPAC+WIDTHC          XC=XC+WIDTHH*T11           YC=YC+WIDTHH*T12           GO TO 500   400    CONTINUE (       GO TO (410,420,430,440,450,460), J       GO TO 500    410 CONTINUEA C================================================================ A C==   CARRIAGE RETURN.                                         == A C================================================================        XP=-(VSPAC+GRID)*L21       YP=-(VSPAC+GRID)*L22       XC=XMARG+XP*G11+YP*G21       YC=YMARG+XP*G12+YP*G22       XMARG=XC       YMARG=YC       GO TO 500    420 CONTINUEA C================================================================ A C==   BACKSPACE.                                               == A C================================================================        WIDTHH=HSPAC+GRID        XC=XC-WIDTHH*T11       YC=YC-WIDTHH*T12       GO TO 500    430 CONTINUEA C================================================================ A C==   UP.                                                      == A C================================================================        LEVELS=LEVELS+1        IF (LEVELS) 432,434,436    432 CONTINUE!       XC=XC-(PSUBX*T11+PSUBY*T21) !       YC=YC-(PSUBX*T12+PSUBY*T22)        GO TO 500    434 CONTINUE       XC=XC-(REFX*T11+REFY*T21)        YC=YC-(REFY*T12+REFY*T22)        CALL TRANSF(SHGTD)!       XC=XC-(DSUBX*T11+DSUBY*T21) !       YC=YC-(DSUBX*T12+DSUBY*T22)        GO TO 500    436 CONTINUE!       XC=XC+(DSUPX*T11+DSUPY*T21) !       YC=YC+(DSUPX*T12+DSUPY*T22) *       IF (LEVELS .EQ. 1) CALL TRANSF(SHGT)       XC=XC+(REFX*T11+REFY*T21)        YC=YC+(REFX*T12+REFY*T22)        GO TO 500    440 CONTINUEA C================================================================ A C==   DOWN.                                                    == A C================================================================        LEVELS=LEVELS-1        IF (LEVELS) 442,444,446    442 CONTINUE!       XC=XC+(DSUBX*T11+DSUBY*T21) !       YC=YC+(DSUBX*T12+DSUBY*T22) +       IF (LEVELS .EQ. -1) CALL TRANSF(SHGT)        XC=XC+(REFX*T11+REFY*T21)        YC=YC+(REFX*T12+REFY*T22)        GO TO 500    444 CONTINUE       XC=XC-(REFX*T11+REFY*T21)R       YC=YC-(REFX*T12+REFY*T22)r       CALL TRANSF(SHGTD)!       XC=XC-(DSUPX*T11+DSUPY*T21) !       YC=YC-(DSUPX*T12+DSUPY*T22)=       GO TO 500=   446 CONTINUE!       XC=XC-(PSUPX*T11+PSUPY*T21) !       YC=YC-(PSUPX*T12+PSUPY*T22)        GO TO 500o   450 CONTINUEA C================================================================PA C==   UP. The size of the character always changes.            == A C================================================================n       LEVELV=LEVELV+1        IF (LEVELV) 454,454,456    454 CONTINUE       XC=XC-(REFX*T11+REFY*T21)o       YC=YC-(REFY*T12+REFY*T22)s       CALL TRANSF(SHGTD)!       XC=XC-(DSUBX*T11+DSUBY*T21) !       YC=YC-(DSUBX*T12+DSUBY*T22)        GO TO 500t   456 CONTINUE!       XC=XC+(DSUPX*T11+DSUPY*T21) !       YC=YC+(DSUPX*T12+DSUPY*T22)        CALL TRANSF(SHGT)        XC=XC+(REFX*T11+REFY*T21)        YC=YC+(REFX*T12+REFY*T22)        GO TO 500n   460 CONTINUEA C================================================================ A C==   DOWN. The size of the character always changes.          == A C================================================================        LEVELV=LEVELV-1        IF (LEVELV) 462,464,464    462 CONTINUE!       XC=XC+(DSUBX*T11+DSUBY*T21) !       YC=YC+(DSUBX*T12+DSUBY*T22)s       CALL TRANSF(SHGT)        XC=XC+(REFX*T11+REFY*T21)h       YC=YC+(REFX*T12+REFY*T22)        GO TO 500o   464 CONTINUE       XC=XC-(REFX*T11+REFY*T21)        YC=YC-(REFX*T12+REFY*T22)        CALL TRANSF(SHGTD)!       XC=XC-(DSUPX*T11+DSUPY*T21) !       YC=YC-(DSUPX*T12+DSUPY*T22)=       GO TO 500    500 CONTINUE       CALL FLUSH_PLOT  C @       DWGTXT=.FALSE.      !restore PLOT_R output to drawing file C)       RETURN
    99 RETURN1 	       END            SUBROUTINE TRANSF(FACTOR) A C================================================================ A C==   SUBROUTINE TRANSF.                                       == A C==   THIS SUBROUTINE MULTIPLY THE MATRIX 'T' BY 'FACTOR'.     == A C================================================================        REAL T(3,3)n       COMMON /TOTRAN/ T,       DATA NDIM/3/       DO 50 I=1,NDIM          DO 40 J=1,NDIM               T(I,J)=T(I,J)*FACTOR    40    CONTINUE     50 CONTINUE       RETURN	       END       $       SUBROUTINE PALPHA(NAME,WHAT,*)A C================================================================hA C==                                                            ==iA C==   The following documentation is adapted from UBC PLOT     == A C==   (April 1981).                                            ==wA C==                                                            == A C==  PURPOSE:                                                  ==gA C==                                                            ==uA C==     PALPHA  changes  the  character  set  used by PSYM. In ==iA C==     addition  to  the  standard  character  set,   several == A C==     library  sets are provided, and user-defined character ==EA C==     set are permitted.                                     == A C==                                                            == A C==  HOW TO USE:                                               ==cA C==                                                            ==eA C==     The calling sequence for PALPHA is                     ==dA C==                                                            == A C==           CALL PALPHA(NAME,WHAT,&RC4)                      == A C==                                                            == A C==     where                                                  == A C==                                                            ==gA C==        NAME          is  the  name of the character set to == A C==                      be used, if the set is a library  set == A C==                      or    the   standard   one.   For   a ==pA C==                      user-defined set,  the  name  of  the == A C==                      file   containing  the  character-set ==hA C==                      definition should be given.  In  both == A C==                      cases, the name must be terminated by ==vA C==                      a  blank.  The  name  of the standard ==aA C==                      character set is STANDARD.            ==/A C==                                                            ==CA C==        WHAT          is  a  fullword  integer  (INTEGER*4) == A C==                      which  is zero if NAME is the name of ==CA C==                      a  library  character  set  (or   the == A C==                      standard one), and nonzero if it is a ==aA C==                      file name for a user-defined set.     ==rA C==                                                            ==rA C==        &RC4          is  the  exit  taken if the character == A C==                      set has not  been  found,  or  if  an == A C==                      error occurred while reading it.      ==rA C==                                                            ==eA C==  METHOD:                                                   ==hA C==                                                            ==PA C==     Calling PALPHA causes all symbols drawn via PSYM to be == A C==     drawn with the specified character set.                == A C==                                                            ==rA C==     If  a  library  character set is specified, it is read ==tA C==     from  TRIUMF$FONTS:VAXFONT.DAT                         ==eA C==     If   a   user-defined   set  is                        ==eA C==     specified,  it is read from the file named in NAME. If ==nA C==     the character set  is  read  successfully,  succeeding ==tA C==     calls to PSYM use the new set.                         ==eA C==                                                            == A C==     Each character set occupies three lines in a file. The == A C==     first  line  contains  the  control  block,  which  is ==rA C==     described below. The second line is  a  directory  for ==.A C==     the  character  information  on  the  third  line. The ==eA C==     directory consists of 256 halfwords; halfword "m" (0<= ==lA C==     m <= 255) is the displacement of the information for   ==cA C==     character  "m"  in  the  third  line.  The  third line == A C==     contains  the  actual  character   definitions.   Each ==lA C==     character is defined by a sequence of points on an n*n == A C==     grid.  The  coordinates  of  the lower-left corner are == A C==     (0,0);  of  the  lower-right   corner   (n-1,0).   The ==hA C==     character  is  drawn by drawing straight lines between == A C==     successive points. The point (15,15) (or (255,255)  if == A C==     n>16)  means move to the next point without drawing (a ==hA C==     pen up operation). To draw to the point  (15,15)  when == A C==     n <= 16, two successive (15,15)'s are used. A pen up is== A C==     not necessary before the first point. If n <= 16 each  ==pA C==     point is represented in the character information by a ==tA C==     single byte. The high-order 4 bits of the byte contain ==tA C==     the    hexadecimal   representation   of   the   first == A C==     coordinate, and  the  low-order  4  bits  contain  the ==nA C==     second  coordinate. If n>16, each point is represented ==dA C==     by  two  bytes,  the  first   containing   the   first ==rA C==     coordinate,  and  the  second  containing  the  second ==HA C==     coordinate. The format of  the  information  for  each == A C==     character is:                                          == A C==                                                            ===A C==     1 byte number of points (k)                            == A C==     1 byte letterspacing (see below)                       == A C==     k (or 2k for n>16) bytes points.                       == A C==                                                            == A C==     The  character definitions may be packed end-to-end in ==oA C==     the   character   information.   For   example,    the ==nA C==     information for a lowercase h on a 16x16 grid might be ==eA C==     (in hex):                                              ===A C==                                                            == A C==     0809333FFF3A4B8B9A93                                   ==HA C==                                                            ==)A C==     The  structure of the control block is shown below. In ==IA C==     the  following  table,  H  means  a  halfword  integer ==PA C==     (INTEGER*2), and E means a fullword real (REAL*4). The ==AA C==     displacement is in decimal.                            == A C==                                                            == A C==                                                            ==)A C Disp Type Name             Description                       == A C                                                              ==)A C  0   H   SIZE   is the total length of character information,==NA C                 in bytes.                                    ==*A C                                                              == A C  2   H   GRID   is the grid size (GRID*GRID).                == A C                                                              == A C  4   H   HSPAC  is the number of grid units between adjacent ==4A C                 characters on the same line.  It must satisfy==EA C                 HSPAC > -GRID.                               ===A C                                                              ==hA C  6   H   VSPAC  is the number of grid units between lines of == A C                 characters.  It must satisfy VSPAC > -GRID.  ===A C                                                              ==YA C  8  2H   PSUP   are the coordinates of a grid point to be    ==/A C                 used as a reference point for superscripts   == A C                 (halfword x coordinate, halfword y           ==2A C                 coordinate).                                 ==,A C                                                              == A C 12  2H   PSUB   are the coordinates of a grid point to be    == A C                 used as a reference point for subscripts     == A C                 (halfword x coordinate, halfword y           ==IA C                 coordinate).                                 ==EA C                                                              ==IA C 16   E   SHGT   is (height of subscripts and superscripts) / ==5A C                 character height.                            ==SA C                                                              == A C 20   E   SCAL   are the grid proportions (horizontal/vertical==,A C                                                              == A C 24   E   SSCAL  is the height scale.  Heights given to PSYM  ==oA C                 are multiplied by this value.                == A C                                                              ==WA C 28   E   ANGL   is the angle of the Y grid axis from the     == A C                 vertical in degrees (<0 corresponds to left- ==,A C                 slanting letters).  It must satisfy          ==HA C                 -90.<ANGL<90.                                ==.A C                                                              ==.A C 32  2H   REF    are the coordinates of a grid point which is == A C                 the reference point for characters.  For the ==SA C                 first character of a string drawn by PSYM,   == A C                 this grid point corresponds to (X,Y).        == A C                                                              == A C 36   H   SWITCH Only the high-order bit of SWITCH is currently= A C                 used.  If it is 1, letterspacing is enabled; == A C                 if 0, letterspacing is disabled.             == A C                                                              ==AA C 38   H   LSPAC  is the constant horizontal spacing (similar  ==GA C                 to HSPAC) used when letterspacing is enabled.== A C                                                              == A C 40  CL16 NAME   is the 16-character alphabet name, padded    == A C                 with blanks if necessary.                    == A C==                                                            ===A C==                                                            == A C==  Variable character spacing, or letterspacing, may be used ===A C==  in  character  sets.  In a set with variable spacing, the ==VA C==  definition of each character includes the  width  of  the ==,A C==  character  so  that the space allotted that character can == A C==  be shortened (which will  allow  the  next  character  to ==CA C==  appear  closer  to  it). Specifically, the second byte of ==LA C==  the character definition contains (in hex) the coordinate == A C==  of  the  column  which  is  considered  the  end  of  the ==ZA C==  character.                                                ==9A C==                                                            ==SA C=================================================================A C==        WRITTEN BY RICHARD T. LEE,  TRIUMF,  UBC.           == A C==                                     JULY 3, 1981.          ===H C======================================================================CH C                                                                      CH C     Modified by Alan Carruthers, October 28, 1983                    CH C        -- three fonts incorrectly spelled:                           CH C              GOTHIC.ENGLISH                                          CH C              ROMAN.2A                                                CH C              GOTHIC.ITALIAN                                          CH C                                                                      CH C  Modified May 4/84 by F.W. Jones:                                    CH C                                                                      CH C  The fonts are now read from TRIUMF$FONTS:VAXFONT.DAT                CH C  using the LOK_IOFAST                                                CH C  routines rather than FORTRAN sequential I/O.  This improves the     CH C  speed when loading new fonts, particularly the widely-used          CH C  TRIUMF.2 font, which is at the end of all the other fonts.          CH C  "Pseudo-random-access" to TRIUMF$FONTS:VAXFONT.DAT is provided by   CH C  LOK_IOFAST$GETM which uses the record addresses stored in the       CH C  array MARK to locate each font.  The addresses in MARK were         CH C  obtained using LOK_IOFAST$MARK.  New addresses may have to be       CH C  calculated if changes are made to TRIUMF$FONTS:VAXFONT.DAT !        CH C                                                                      CH C  Modified May 4/84 by F.W. Jones:                                    CH C                                                                      CH C  A "font number" is stored in COMMON/EDGR_ATT_SET/ to allow the      CH C  support of fonts in the Graphics Editor.                            CH C                                                                      CH C  Modified Jun28/88 by R. Lee:                                        C C								       CTI C  A new font called TRIUMF.OUTLINE is constructed and added into      C  H C  the library. Address used by LOK_IOFAST$GETM is calculated for this CH C  font.                                                               CH C======================================================================C CU!       LOGICAL EQCMP,FIRST/.TRUE./U       INTEGER NAMEDIM, NAMELN ,       PARAMETER (NAMEDIM=5,NAMELN=4*NAMEDIM)        INTEGER NAME(NAMEDIM),WHAT       LOGICAL*1 LINE1(56)        INTEGER*2 LINE2(256)       LOGICAL*1 LINE3(25000)>       INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,%      *          REFX,REFY,SWITC,LSPAC=       LOGICAL*1 NAMM(16)!       REAL*4 SHGT,SCAL,SSCAL,ANGL '       EQUIVALENCE (LINE1( 1),    SIZE),,'      *            (LINE1( 3),    GRID),U'      *            (LINE1( 5),   HSPAC),2'      *            (LINE1( 7),   VSPAC),A'      *            (LINE1( 9),   PSUPX),E'      *            (LINE1(11),   PSUPY), '      *            (LINE1(13),   PSUBX), '      *            (LINE1(15),   PSUBY),R'      *            (LINE1(17),    SHGT),T'      *            (LINE1(21),    SCAL), '      *            (LINE1(25),   SSCAL),O'      *            (LINE1(29),    ANGL),U'      *            (LINE1(33),    REFX),2'      *            (LINE1(35),    REFY),T'      *            (LINE1(37),   SWITC),='      *            (LINE1(39),   LSPAC), &      *            (LINE1(41), NAMM(1))       LOGICAL GRID16,LISPON=       INTEGER*2 SWITON/Z8000/=8       COMMON /FONT/LINE1,LINE2,LINE3,GRID16,LISPON,MGRID       LOGICAL PALPCD,PSYMCDO)       COMMON /CALLED/ PALPCD,PSYMCD,XC,YC #       COMMON/PLOT_OUTPUT_UNIT/IOUTS        DATA IOUTS/6/        REAL LMAT(3,3)       COMMON /LOTRAN/ LMATH C                                                                      *H C   LIB contains the font names                                        *H C   NFONT is the number of font names                                  *H C   LIBFONT is the current font name                                   *H C                                                                      **       INTEGER LIB(4,99), NFONT, LIBFONT(4)/       COMMON /PALPHA_FONTS/ LIB, NFONT, LIBFONT        DATA NFONT/43/0       DATA LIBFONT /'STAN','DARD','    ','    '/       DATA LIB/D$      X  'STAN','DARD','    ','    ',$      X  'HELV','ETIC','A.1 ','    ',E      X  'GOTH','IC.E','NGLI','SH  ',  !Alan Carruthers, Oct. 28, 1983 $      X  'ROMA','N.3 ','    ','    ',$      X  'ITAL','IC.3','    ','    ',$      X  'GREE','K.2A','    ','    ',$      X  'ITAL','IC.2','A   ','    ',E      X  'ROMA','N.2A','    ','    ',  !Alan Carruthers, Oct. 28, 1983N$      X  'SANS','ERIF','.2  ','    ',$      X  'GREE','K.1 ','    ','    ',$      X  'SANS','ERIF','.1  ','    ',$      X  'SCRI','PT.1','    ','    ',$      X  'GOTH','IC.F','RAKT','UR  ',E      X  'GOTH','IC.I','TALI','AN  ',  !Alan Carruthers, Oct. 28, 1983U$      X  'SCRI','PT.2','    ','    ',$      X  'ROMA','N.2 ','    ','    ',$      X  'ITAL','IC.2','    ','    ',$      X  'GREE','K.2 ','    ','    ',$      X  'CYRI','LLIC','.2  ','    ',$      X  'SANS','ERIF','.CAR','T   ',$      X  'GREE','K.CA','RT  ','    ',$      X  'HIRA','GANA','    ','    ',$      X  'KATA','KANA','    ','    ',$      X  'KANJ','I1  ','    ','    ',$      X  'KANJ','I2  ','    ','    ',$      X  'KANJ','I3  ','    ','    ',$      X  'KANJ','I4  ','    ','    ',$      X  'KANJ','I5  ','    ','    ',$      X  'OLDA','LPH ','    ','    ',$      X  'TRIU','MF.1','    ','    ',$      X  'TRIU','MF.2','    ','    ',$      X  'TSAN','    ','    ','    ',$      X  'ROMA','N.FU','TURA','    ',$      X  'ROMA','N.SE','RIF ','    ',$      X  'ROMA','N.FA','SHON','    ',$      X  'ROMA','N.LO','GO1 ','    ',$      X  'ROMA','N.SW','ISSL','    ',$      X  'ROMA','N.SW','ISSM','    ',$      X  'ROMA','N.SW','ISSB','    ',$      X  'SPEC','IAL ','    ','    ',$      X  'MATH','    ','    ','    ',$      X  'HEBR','EW  ','    ','    ',$      X  'TRIU','MF.O','UTLI','NE  ',%      X  224*'    '                  /        INTEGER*2 LEN1,LEN2,LEN3       DATA RADE/.1745329E-1/       LOGICAL*1 DUMMY %       CHARACTER USERFILENAME*(NAMELN)H CT C Buffers for LOK_IOFAST reads:        CHARACTER*180 BUFFER1        CHARACTER*512 BUFFER2        CHARACTER*25000 BUFFER3         EQUIVALENCE(BUFFER3,LINE3) CH C Record address for each font: D       INTEGER MARK(43)/   65536,  262600,  459084, 1507382, 2490830,D      #                  3473744, 4063602, 4587730, 5242910, 5832904,D      #                  6357388, 6881588, 7405652, 8454436, 9371956,D      #                 10092970,11010096,11665874,12517760,13303948,D      #                 13500782,13762632,14745714,15401466,16777582,D      #                 18809188,21823520,24510860,27263390,27525344,D      #                 28770336,29950308,30736434,31916340,33686000,D      #                 34799702,35455264,37224628,38732152,40370342,2      #                 40829164,41222262,41484322/ C  C Graphics Editor attributes:i,       COMMON/EDGR_ATT_SET/IFONT_SET,ICOL_SET C 1       CALL FINDC(NAME,NAMELN,' ',1,1,IF,ICF,&900)        IF(WHAT .EQ. 0) GO TO 50 Cm       USERFILENAME = ' ',       CALL MOVEC(IF,NAME,%REF(USERFILENAME))" CC      OPEN(19,FILE=USERFILENAME,< CC     *   STATUS='OLD',READONLY,SHARED, RECL=25000,ERR=900),       ISTAT=LOK_IOFAST$OPENR(8,USERFILENAME)       IF(.NOT.ISTAT)GO TO 900        GO TO 252l Cd    50 CONTINUEA C================================================================nA C==   The character set is to be found in the library.         ==rA C================================================================i 1313  FORMAT(1X,2I10,1X,5A4)2       IF (IF .LE. 0 .OR. IF .GT. NAMELN) GO TO 900 CC      IEND=IF-1 
       IEND=IF        DO 100 I=1,NFONT*         IF (EQCMP(IEND,NAME,LIB(1,I)))THENH C                                                                      *H C    Set the current font name for the common block PALPHA_FONTS       *H C                                                                      *           DO II = 1, 4#             LIBFONT(II) = LIB(II,I)            END DO           GO TO 200          END IF   100 CONTINUEA C================================================================SA C==   The character set is not found in the library, yet WHAT=0.= A C================================================================        GO TO 900  C    200 CONTINUE Cr C Set font # in EDGR:        IFONT_SET=I  C        IF(FIRST)THENX<         ISTAT=LOK_IOFAST$OPENR(8,'TRIUMF$FONTS:VAXFONT.DAT')         IF(.NOT.ISTAT)GO TO 990        ENDIF  C  C Read the first record:@ 252   IF(WHAT.EQ.0)ISTAT=LOK_IOFAST$GETM(8,BUFFER1,LREC,MARK(I))% C Sequential read for user font file: 7       IF(WHAT.NE.0)ISTAT=LOK_IOFAST$GET(8,BUFFER1,LREC)        IF(.NOT.ISTAT)GO TO 900 G       READ(BUFFER1,254,ERR=900)SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,p>      *   PSUBY,SHGT,SCAL,SSCAL,ANGL,REFX,REFY,SWITC,LSPAC,NAMM$ 254   FORMAT(8I8,4F16.6,4I8,4X,16A1) C= C Read the second record:s! CC      READ(19,256,ERR=900)LINE2.*       ISTAT=LOK_IOFAST$GET(8,BUFFER2,LREC)       IF(.NOT.ISTAT)GO TO 900 $       READ(BUFFER2,256,ERR=900)LINE2 256   FORMAT(256A2)l C= C Read the third record:/ CC      READ(19,255,ERR=900)(LINE3(N),N=1,SIZE)h*       ISTAT=LOK_IOFAST$GET(8,BUFFER3,LREC)       IF(.NOT.ISTAT)GO TO 900        FIRST=.FALSE.r Cd   300 CONTINUE       PALPCD=.TRUE.c       GRID16=.TRUE.e
       MGRID=1s&       IF (GRID .GT. 16) GRID16=.FALSE.       IF (GRID .GT. 16) MGRID=2rA C================================================================ A C==   This is an entry point to update some of the internal    ==tA C==   parameters.                                              ==)A C================================================================n       ENTRY LOCTRA       LISPON=.FALSE..       IF ((SWITC/SWITON) .GE. 1) LISPON=.TRUE.A C================================================================ A C==   Calculate the local transformation.                      ==nA C================================================================g       SD=SSCAL/GRIDe       SL11=SD*SCAL       LMAT(1,1)=SL11       LMAT(1,2)=0.       LMAT(1,3)=0.#       LMAT(2,1)=SL11*TAN(ANGL*RADE)e       LMAT(2,2)=SD       LMAT(2,3)=0.       LMAT(3,1)=SL11*(-REFX)       LMAT(3,2)=SD*(-REFY)       LMAT(3,3)=1.       RETURN
   900 RETURN1    990 WRITE(IOUTS,1099) <  1099 FORMAT(' ERROR !!! Cant find a file associated with ',#      # ' TRIUMF$FONTS:VAXFONT.DAT') 	       ENDo      ;       SUBROUTINE SPLITE(CHA,LEN,IPT,INX,INY,MGRID,MOVETO,*) A C================================================================ A C==   THIS SUBROUTINE OUTPUTS ONE POINT FROM THE CHAIN CODE,   == A C==   AND INDICATES IF IT IS CONNECTED TO THE POINT BEFORE IT  ==eA C==   OR NOT.                                                  ==sA C==   PARAMETERS:                                              == A C==         CHA   :  THE ARRAY STORING THE CHAIN CODE.         ==oA C==         LEN   :  THE NUMBER OF BYTES IN THE CHAIN CODE.    ==mA C==         IPT   :  THE INDEX OF THE POINT TO BE FOUND.       ==cA C==         INX   :  THE CO-ORDINATES OF THE POINT.            == A C==         INY   :  THE CO-ORDINATES OF THE POINT.            == A C==         MGRID :  THE NUMBER OF BYTES FOR EACH POINT.       == A C==                  =1 OR 2.                                  == A C==         MOVETO:  = .TRUE. IF THE POINT IS CONNECTED TO ONE ==oA C==                           BEFORE IT;                       == A C==                  = .FALSE. IF IT IS NOT.                   ==sA C==         &RC4  :  THE EXIT TAKEN IF THE INDEX 'IPT' IS OUT  ==m@ C==                  OF RANGE.                                ==A C==                                                            == A C==   WRITTEN BY    RICHARD LEE,   TRIUMF,  UBC.               ==DA C==                                MARCH  1981.                == / C==                 REVISED ON   JULY 9,  1981.SA C================================================================        LOGICAL EQUC       LOGICAL*1 CHA(1),MOVETO=       INTEGER*2 INHEX/0/!       LOGICAL*1 INHEXL(2),FF/ZFF/ #       EQUIVALENCE (INHEX,INHEXL(1))i       LOGICAL*1 BYTE1,BYTE2 A C================================================================ A C==   RETURN1 IF 'IPT' IS OUT OF RANGE.                        ==aA C================================================================a/       IF (IPT .LE. 2 .OR. IPT .GT. LEN) RETURN1 !       IF (MGRID .EQ. 2) GO TO 150 A C================================================================HA C==   GET THE HORIZONTAL AND VERTICAL CO-ORDINATES FROM ONE    == A C==   BYTE OF INFORMATION.                                     == A C================================================================H       BYTE1=CHA(IPT)       INHEXL(1)=BYTE1        INX=INHEX/16       INY=INHEX-INX*16       IPT=IPT+1        MOVETO=.FALSE.A C================================================================ A C==   RETURN IF THE CO-ORDINATES HAVE BEEN OBTAINED.           == A C================================================================ (       IF (.NOT. (EQUC(BYTE1,FF))) RETURN       BYTE1=CHA(IPT)       INHEXL(1)=BYTE1d       INX=INHEX/16       INY=INHEX-INX*16       IPT=IPT+1 A C================================================================ A C==   THE CO-ORDINATES OF THE POINT IS (15,15) WHEN RETURN HERE.= A C================================================================         IF (EQUC(BYTE1,FF)) RETURN       MOVETO=.TRUE.        RETURN   150 CONTINUEA C================================================================ A C==   GET THE HORIZONTAL AND VERTICAL CO-ORDINATES FROM TWO    ==oA C==   BYTES INFORMATION.                                       == A C================================================================c       BYTE1=CHA(IPT)       INHEXL(1)=BYTE1        INX=INHEXi       IPT=IPT+1        BYTE2=CHA(IPT)       INHEXL(1)=BYTE2        INY=INHEX        MOVETO=.FALSE.       IPT=IPT+1 A C================================================================ A C==   RETURN IF THE CO-ORDINATES HAVE BEEN OBTAINED.           == A C================================================================ 6       IF (.NOT. (EQUC(BYTE1,FF) .AND. EQUC(BYTE2,FF)))      1   RETURN        BYTE1=CHA(IPT)       INHEXL(1)=BYTE1        INX=INHEX        IPT=IPT+1e       BYTE2=CHA(IPT)       INHEXL(1)=BYTE2        INY=INHEX        IPT=IPT+1eA C================================================================wA C==   THE CO-ORDINATES OF THE POINT IS (255,255) WHEN RETURN   ==(A C==   HERE.                                                    == A C================================================================C5       IF (EQUC(BYTE1,FF) .AND. EQUC(BYTE2,FF)) RETURNl       MOVETO=.TRUE.e       RETURN	       END +       FUNCTION PSMLEN(STRING,LENGTH,HEIGHT)=A C=================================================================A C==   FUNCTION PSMLEN                                          ===A C==                                                            ===A C==  PURPOSE:                                                  ===A C==                                                            ===A C==     PSMLEN   determines the length in  user units  that  a ===A C==     character string would be if plotted by PSYM.          ===A C==                                                            ===A C==  HOW TO USE:                                               ===A C==                                                            ===A C==           SIZE = PSMLEN(STRING,LENGTH,HEIGHT)              ===A C==                                                            ===A C==     where:                                                 ===A C==                                                            ===A C==           STRING  is the character string whose length  is ===A C==                   to be determined.                        ===A C==                                                            ===A C==           LENGTH  is   the   fullword-integer  (INTEGER*4) ===A C==                   number of characters in the string.      ===A C==                                                            ===A C==           HEIGHT  is the floating-point (REAL*4) height in ===A C==                   user units for STRING.                   ===A C==                                                            == A C==           SIZE    The function result is the length of the == A C==                   string in user units.                    == A C==                                                            == A C==  METHOD:                                                   == A C==                                                            ==AA C==     STRING has the same format as a character string given == A C==     to PSYM. (The same string could be  passed  to  PSYM.) == A C==     The length of STRING as it would be plotted by PSYM is == A C==     determined,  with  the exception that carriage returns ==TA C==     in STRING are ignored.                                 ==CA C==                                                            == A C================================================================vA C==                                                            ==eA C==   Written by  RICHARD T. LEE,  TRIUMF,  UBC,               ==eA C==                                July 7, 1981.               ==:A C================================================================e       LOGICAL ASIS       COMMON /MODE/ASISy       DATA ASIS/.FALSE./       LOGICAL EQUC&       LOGICAL*1 STRING(1),STRINGB(256)       LOGICAL*1 LINE1(56)e       INTEGER*2 LINE2(256)       LOGICAL*1 LINE3(25000)>       INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,%      *          REFX,REFY,SWITC,LSPAC        LOGICAL*1 NAME(16)!       REAL*4 SHGT,SCAL,SSCAL,ANGL '       EQUIVALENCE (LINE1( 1),    SIZE), '      *            (LINE1( 3),    GRID), '      *            (LINE1( 5),   HSPAC),d'      *            (LINE1( 7),   VSPAC), '      *            (LINE1( 9),   PSUPX),d'      *            (LINE1(11),   PSUPY), '      *            (LINE1(13),   PSUBX), '      *            (LINE1(15),   PSUBY),2'      *            (LINE1(17),    SHGT), '      *            (LINE1(21),    SCAL),n'      *            (LINE1(25),   SSCAL),t'      *            (LINE1(29),    ANGL),y'      *            (LINE1(33),    REFX),u'      *            (LINE1(35),    REFY), '      *            (LINE1(37),   SWITC), '      *            (LINE1(39),   LSPAC),=&      *            (LINE1(41), NAME(1))       LOGICAL GRID16,LISPON/9       COMMON /FONT/ LINE1,LINE2,LINE3,GRID16,LISPON,MGRIDN.       REAL L11,L12,L13,L21,L22,L23,L31,L32,L339       COMMON /LOTRAN/ L11,L21,L31,L12,L22,L32,L13,L23,L33I       LOGICAL*1 LOC(2),LOCLE       INTEGER*2 LOCATN/Z0000/G!       EQUIVALENCE (LOC(1),LOCATN)S       EQUIVALENCE (LOC(1),LOCL)W       LOGICAL*1 WIDTHL(2)        INTEGER*2 WIDTHC/Z0000/L$       EQUIVALENCE (WIDTHL(1),WIDTHC)0       LOGICAL*1 CTRL(6)/Z15,Z16,Z09,Z38,Z0A,Z39/1       LOGICAL*1 CTRL2(6)/Z15,Z16,Z05,Z01,Z03,Z02/        INTEGER NCTRL/6/       LOGICAL PALPCD,PSYMCD )       COMMON /CALLED/ PALPCD,PSYMCD,XC,YC        IF (PALPCD) GO TO 5         CALL PALPHA('STANDARD ',0)     5 CONTINUE       LEVELS=0       LEVELV=0       DSUBX=PSUBX-REFX       DSUBY=PSUBY-REFY       DSUPX=PSUPX-REFX       DSUPY=PSUPY-REFY       SHGTD=1./SHGT        SCALEN=L11*HEIGHT        PSMLEN=0.AA C================================================================ A C==   EXTRACT INFORMATION FROM 'STRING'.                       == A C================================================================)$ C==   ASIS = .FALSE. FOR CONVERSION.'       CALL MOVEC(LENGTH,STRING,STRINGB) 9       IF (.NOT.ASIS) CALL PASCEBC(STRINGB,STRINGB,LENGTH)O       DO 500 I=1,LENGTH           LOCL=STRINGB(I)          DO 10 J=1,NCTRL          IF(ASIS)THEN -             IF (EQUC(LOCL,CTRL(J))) GO TO 400 
          ELSER-             IF(EQUC(LOCL,CTRL2(J))) GO TO 400           ENDIF    10    CONTINUE !          IFIRST=LINE2(LOCATN+1)+1 "          WIDTHL(1)=LINE3(IFIRST+1)A C================================================================ A C==   LETTERSPACING IS CONSIDERED HERE.                        == A C================================================================           WIDTHH=HSPAC+GRID(          IF (LISPON) WIDTHH=LSPAC+WIDTHC$          PSMLEN=PSMLEN+WIDTHH*SCALEN          GO TO 500   400    CONTINUEL(       GO TO (410,420,430,440,450,460), J       GO TO 500    410 CONTINUEA C================================================================TA C==   CARRIAGE RETURN.                                         == A C================================================================        GO TO 500.   420 CONTINUEA C================================================================ A C==   BACKSPACE.                                               ==,A C================================================================'       WIDTHH=HSPAC+GRID !       PSMLEN=PSMLEN-WIDTHH*SCALEN        GO TO 500C   430 CONTINUEA C================================================================,A C==   UP. SUPERSCRIPTS ARE HANDLED HERE.                       ==,A C================================================================'       LEVELS=LEVELS+1        IF (LEVELS) 432,434,436    432 CONTINUE        PSMLEN=PSMLEN-PSUBX*SCALEN       GO TO 500R   434 CONTINUE       PSMLEN=PSMLEN-REFX*SCALEN,       SCALEN=SCALEN*SHGTD         PSMLEN=PSMLEN-DSUBX*SCALEN       GO TO 500    436 CONTINUE        PSMLEN=PSMLEN+DSUPX*SCALEN+       IF (LEVELS .EQ. 1) SCALEN=SCALEN*SHGT,       PSMLEN=PSMLEN+REFX*SCALEN5       GO TO 500,   440 CONTINUEA C================================================================XA C==   DOWN. SUBSCRIPTS ARE HANDLED HERE.                       ==,A C================================================================'       LEVELS=LEVELS-1'       IF (LEVELS) 442,444,446    442 CONTINUE        PSMLEN=PSMLEN+DSUBX*SCALEN,       IF (LEVELS .EQ. -1) SCALEN=SCALEN*SHGT       PSMLEN=PSMLEN+REFX*SCALENI       GO TO 500    444 CONTINUE       PSMLEN=PSMLEN-REFX*SCALEN'       SCALEN=SCALEN*SHGTDX        PSMLEN=PSMLEN-DSUPX*SCALEN       GO TO 500O   446 CONTINUE        PSMLEN=PSMLEN-PSUPX*SCALEN       GO TO 500E   450 CONTINUEA C================================================================HA C==   UP. SUPERSCRIPTS ARE HANDLED HERE.                       == A C================================================================        LEVELV=LEVELV+1        IF (LEVELV) 454,454,456E   454 CONTINUE       PSMLEN=PSMLEN-REFX*SCALENN       SCALEN=SCALEN*SHGTD6        PSMLEN=PSMLEN-DSUBX*SCALEN       GO TO 500    456 CONTINUE        PSMLEN=PSMLEN+DSUPX*SCALEN       SCALEN=SCALEN*SHGT       PSMLEN=PSMLEN+REFX*SCALEN6       GO TO 500#   460 CONTINUEA C================================================================ A C==   DOWN. SUBSCRIPTS ARE HANDLED HERE.                       == A C================================================================        LEVELV=LEVELV-18       IF (LEVELV) 462,464,464    462 CONTINUE        PSMLEN=PSMLEN+DSUBX*SCALEN       SCALEN=SCALEN*SHGT       PSMLEN=PSMLEN+REFX*SCALEN4       GO TO 500r   464 CONTINUE       PSMLEN=PSMLEN-REFX*SCALEN_       SCALEN=SCALEN*SHGTD         PSMLEN=PSMLEN-DSUPX*SCALEN       GO TO 500    500 CONTINUE       RETURN	       END        SUBROUTINE PSYMLC(X,Y)A C================================================================MA C==                                                            == A C==  PURPOSE:                                                  ==TA C==                                                            ===A C==     PSYMLC  obtains the coordinates of the end of the last ==eA C==     character string drawn by PSYM.                        ===A C==                                                            ==1A C==  HOW TO USE:                                               == A C==                                                            ==MA C==           CALL PSYMLC(X,Y)                                 == A C==                                                            ==rA C==     where:                                                 == A C==                                                            ==4A C==           X,Y     are  floating-point  (REAL*4)  variables == A C==                   set  to  the absolute coordinates of the ===A C==                   point  at   which   PSYM   would   begin == A C==                   lettering.                               ===B C==                   (hexadecimal 80000000,hexadecimal 80000000).A C==                   is returned if PSYM has never been called== A C==                                                            ==VA C================================================================ A C==                                                            ==BA C==         WRITTEN  BY  RICHARD T. LEE,  TRIUMF,  UBC.        == A C==                                       July 13, 1981.       ==SA C================================================================C       LOGICAL PALPCD,PSYMCD )       COMMON /CALLED/ PALPCD,PSYMCD,XC,YC,
       X=XC
       Y=YC       RETURN	       END ,       SUBROUTINE PSALPH(WHAT,VALUE,OLDVAL,*)A C================================================================ A C==                                                            == A C==  PURPOSE:                                                  ==,A C==                                                            ==EA C==     PSALPH  changes  the  values  of  parameters  for  the == A C==     current character set.                                 ==GA C==                                                            == A C==  HOW TO USE:                                               ===A C==                                                            ==tA C==           CALL PSALPH(WHAT,VALUE,OLDVAL,&RC4)              == A C==                                                            ===A C==     where:                                                 ==SA C==                                                            ===A C==        WHAT       is   the   4-character   name   or   the ==fA C==                   fullword-integer number of the parameter ===A C==                   to be changed.                           ==1A C==                                                            ===A C==        VALUE      is the new value to be assigned to  that == A C==                   parameter.  It  is  either  one  or  two ==FA C==                   fullword  integers  (INTEGER*4)   or   a ==OA C==                   single  floating- point (REAL*4) number, ==tA C==                   as appropriate for WHAT.                 == A C==                                                            ===A C==        OLDVAL     is set on return to the  previous  value ==SA C==                   of  the  parameter.  It  should have the ==NA C==                   same size and type as VALUE.             ==TA C==                                                            ==EA C==        &RC4       is a return taken  if  WHAT  was  not  a == A C==                   parameter,  VALUE  was invalid for WHAT, == A C==                   or  space  could  not  be  obtained  for == A C==                   copying the standard alphabet.           == A C==                                                            == A C==  METHOD:                                                   == A C==                                                            == A C==     The  parameter specified by WHAT has its value changed == A C==     to VALUE,  and  its  previous  value  is  returned  in == A C==     OLDVAL. The table below describes the values for WHAT. == A C==     In  the  "Type"  column,  F  means  a fullword integer == A C==     (INTEGER*4)  and  E  means   fullword   floating-point == A C==     (REAL*4).                                              == A C==                                                            == A C==                                                            == A C==             WHAT                                           == A C==        Name     Number    Type    Parameter Changed        ===A C==                                                            ==AA C==        HSPC        1        F        HSPAC                 ==LA C==        VSPC        2        F        VSPAC                 == A C==        SUPS        3       2F        PSUP                  ===A C==        SUBS        4       2F        PSUB                  == A C==        SHGT        5        E        SHGT                  ===A C==        SCAL        6        E        SCAL                  == A C==        HSCL        7        E        SSCAL                 ===A C==        ANGL        8        E        ANGL                  ==AA C==        LTRS        9        F        SWITCH                == A C==                                       =0 letterspacing off ===A C==                                        otherwise on        ==1A C==        REFP       10       2F         REF                  ==+A C==        LSPC       11        F         LSPAC                ===A C==                                                            ==NA C==                                                            ===A C==        See  the  description  of PALPHA for an explanation == A C==        of the parameters.  The  value  restrictions listed == A C==        there are enforced by PSALPH.                       ===A C================================================================HA C==                                                            ===A C==         WRITTEN  BY  RICHARD T. LEE,  TRIUMF,  UBC.        ==EA C==                                       July 13, 1981.       ===A C================================================================        LOGICAL EQCMPR       LOGICAL*1 LINE1(56)        INTEGER*2 LINE2(256)       LOGICAL*1 LINE3(25000)>       INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,%      *          REFX,REFY,SWITC,LSPACP       LOGICAL*1 NAME(16)!       REAL*4 SHGT,SCAL,SSCAL,ANGL '       EQUIVALENCE (LINE1( 1),    SIZE),Y'      *            (LINE1( 3),    GRID),S'      *            (LINE1( 5),   HSPAC),='      *            (LINE1( 7),   VSPAC),='      *            (LINE1( 9),   PSUPX),V'      *            (LINE1(11),   PSUPY),='      *            (LINE1(13),   PSUBX),='      *            (LINE1(15),   PSUBY),E'      *            (LINE1(17),    SHGT),T'      *            (LINE1(21),    SCAL),1'      *            (LINE1(25),   SSCAL),+'      *            (LINE1(29),    ANGL),='      *            (LINE1(33),    REFX),e'      *            (LINE1(35),    REFY),='      *            (LINE1(37),   SWITC),O'      *            (LINE1(39),   LSPAC),E&      *            (LINE1(41), NAME(1))       LOGICAL GRID16,LISPON 9       COMMON /FONT/ LINE1,LINE2,LINE3,GRID16,LISPON,MGRID='       INTEGER*4 WHAT,VALUE(2),OLDVAL(2))        INTEGER*4 VAIN(2),OVAIN(2)       REAL*4 VA,OVA .       EQUIVALENCE (VA,VAIN(1)), (OVA,OVAIN(1))<       INTEGER NAMELT(11)/'HSPC','VSPC','SUPS','SUBS','SHGT',<      *            'SCAL','HSCL','ANGL','LTRS','REFP','LSPC'/       DATA NLIST/11/       LOGICAL PALPCD,PSYMCD )       COMMON /CALLED/ PALPCD,PSYMCD,XC,YC A C================================================================ A C==   See if PALPHA has been called or not. If not, set up the == A C==   STANDARD font.                                           ==aA C================================================================        IF (PALPCD) GO TO 5 %       CALL PALPHA('STANDARD ',0,&999)      5 CONTINUEA C================================================================ A C==   Here we check if WHAT is an integer parameter number.    == A C================================================================        DO 10 I=1,NLIST "          IF (WHAT .EQ. I) GO TO 50    10 CONTINUEA C================================================================ A C==   Here we assume that WHAT is a four-character name.       ==IA C================================================================        DO 20 I=1,NLIST .          IF (EQCMP(4,WHAT,NAMELT(I))) GO TO 50    20 CONTINUE       GO TO 999 ;    50 GO TO (110,120,130,140,150,160,170,180,190,200,210),I A C================================================================ A C==   In the following the control parameter specified by WHAT == A C==   is changed to VALUE and its old value is returned in     ==*A C==   OLDVAL, provided that VALUE is valid.                    == A C================================================================    110 CONTINUE       OLDVAL(1)=HSPAC (       IF (VALUE(1) .LE. -GRID) GO TO 999       HSPAC=VALUE(1)       GO TO 500r   120 CONTINUE       OLDVAL(1)=VSPAC (       IF (VALUE(1) .LE. -GRID) GO TO 999       VSPAC=VALUE(1)       GO TO 500    130 CONTINUE       OLDVAL(1)=PSUPX        OLDVAL(2)=PSUPY        PSUPX=VALUE(1)       PSUPY=VALUE(2)       GO TO 500I   140 CONTINUE       OLDVAL(1)=PSUBXt       OLDVAL(2)=PSUBY        PSUBX=VALUE(1)       PSUBY=VALUE(2)       GO TO 500=   150 CONTINUE       OVA=SHGT       OLDVAL(1)=OVAIN(1)       VAIN(1)=VALUE(1)
       SHGT=VAe       GO TO 500r   160 CONTINUE       OVA=SCAL       OLDVAL(1)=OVAIN(1)       VAIN(1)=VALUE(1)
       SCAL=VA        GO TO 500    170 CONTINUE       OVA=SSCAL=       OLDVAL(1)=OVAIN(1)       VAIN(1)=VALUE(1)       SSCAL=VA       GO TO 500    180 CONTINUE       OVA=ANGL       OLDVAL(1)=OVAIN(1)       VAIN(1)=VALUE(1)6       IF ((VA .LE. -90.) .OR. (VA .GE. 90.)) GO TO 999
       ANGL=VA        GO TO 500.   190 CONTINUE       OLDVAL(1)=SWITC=       SWITC=VALUE(1)       GO TO 500=   200 CONTINUE       OLDVAL(1)=REFX       OLDVAL(2)=REFY       REFX=VALUE(1)        REFY=VALUE(2)        GO TO 500G   210 CONTINUE       OLDVAL(1)=LSPAC(       LSPAC=VALUE(1)       GO TO 500    500 CONTINUEA C================================================================BA C==   Here LOCTRA, which is an entry point in subroutine       ==)A C==   PALPHA, is called to update the local transformation.    == A C================================================================        CALL LOCTRAS       RETURN
   999 RETURN1N       END       