<       SUBROUTINE PSYM_TPLT(X,Y,HEIGHT,STRING,ANGLE,LENGTH,*) C H C  reqd. KOSTL: routines - ASCEBC,EQCMP,EQUC,FINDC,MOVEC,PLOTTPLT,PLOTI, C                        - PSYM  C A C================================================================ A C==                                                            == A C==                                                            == A C==   This subroutine produces text on a plot. Any character   == A C==   sets can be used as long as they are set up appropriately.= A C==   Note that this subroutine tries to simulate the 'PSYM' of== A C==   UBC Computer Centre, which is written in ASSEMBLER.      == A C==   It is hoped that this version is more portable and easier== A C==   to be modified.                                          == A C==                                                            == A C==   The following documentation is adapted from UBC PLOT     == A C==   (April 1981).                                            == A C==                                                            == A C==  PURPOSE:                                                  == A C==                                                            == A C==     PSYM produces text on a plot. This routine is used for == A C==     all character sets. See the description of PALPHA  for == A C==     information on alternative character sets.             == A C==                                                            == A C==  HOW TO USE:                                               == A C==                                                            == A C==           CALL PSYM(X,Y,HEIGHT,STRING,ANGLE,LENGTH,&RC4)   == A C==                                                            == A C==     where:                                                 == A C==           X,Y     are    the    floating-point    (REAL*4) == A C==                   coordinates of the first character to be == A C==                   drawn.   For   most   character    sets, == A C==                   including  the standard one, this is the == A C==                   lower-left   corner   of    the    first == A C==                   character.  If either coordinate is -0.0 == A C==                   (hexadecimal 80000000),  PSYM  continues == A C==                   from  the  end  of  the  last  character == A C==                   string drawn.                            == A C==                                                            == A C==           HEIGHT  is the floating-point (REAL*4) height in == @ C==                   user units at which the string is drawn.==A C==                                                            == A C==           STRING  is the character string to be drawn.     == A C==                                                            == A C==           ANGLE   is the floating-point (REAL*4) angle  in == A C==                   degrees of the character string (using a == A C==                   positive counterclockwise convention).   == A C==                                                            == A C==           LENGTH  is   the   fullword-integer  (INTEGER*4) == A C==                   number of characters in STRING.          == A C==                                                            == A C==           &RC4    is the exit taken  for  an  unsuccessful == A C==                   return;  STRING is not drawn. Either the == A C==                   parameters are in error  (for  instance, == A C==                   calling  PSYM  for the first time with X == A C==                   or Y equal to  -0.0),  or  there  is  an == A C==                   error in a user-defined character set.   == A C==                                                            == A C==  METHOD:                                                   == A C==                                                            == A C==     PSYM draws STRING with the HEIGHT specified, beginning == A C==     at (X,Y), with the angle ANGLE.                        == A C==                                                            == A C==     There   are  six   special  characters  which  produce == A C==     carriage   returns,   backspaces,   subscripts,    and == A C==     superscripts. The first character shown for each is    == A C==     used if ASIS=.TRUE. in the /MODE/ common block, i.e.   == A C==     if the input STRING is in EBCDIC code (the native      == A C==     code of the PSYM font structure). The second character == A C==     shown is used if ASIS=.FALSE. (default) in the /MODE/  == A C==     common block, i.e. if the input STRING is in ASCII     == A C==     code. In this case the STRING will be converted to     == A C==     EBCDIC code by the translation subroutine ASCEBC.      == A C==                                                            == A C== X'15':  Carriage return. This causes an immediate carriage == A C== X'0A'   return  as on a  typewriter,  where the  margin is == A C==         defined  by the  last  previous  carriage  return, == A C==         or the last explicit (not -0.0) X,Y pair.          == A C==                                                            == A C== X'16':  Backspace.   This  produces  a one-character back- == A C== X'08'   space.  If the alphabet currently being  used  has == A C==         letterspacing  on,  this  may  be farther than one == A C==         character back.  See the description of PALPHA for == A C==         details.                                           == A C==                                                            == A C== X'09':  Up.  If encountered while drawing  text  normally, == A C== X'09'   succeeding  text  is  drawn  as  superscripts.  If == A C==         encountered while drawing  superscripts,  text  is == A C==         drawn  at  the  next higher superscript level.  If == A C==         encountered while drawing subscripts, drawing con- == A C==         tinues at the next higher level of subscripts  (or == A C==         back  to  normal  if  there  was only one level of == A C==         subscripts).                                       == A C==                                                            == A C== X'38':  Down.  If encountered while drawing text normally, == A C== X'01'   succeeding  text  is  drawn  as  subscripts.    If == A C==         encountered  while  drawing  subscripts,  text  is == A C==         drawn at  the  next  lower  subscript  level.   If == A C==         encountered while drawing superscripts, succeeding == A C==         text  is  drawn  at the next lower level of super- == A C==         scripts (or back to normal if there was  only  one == A C==         level of superscripts).                            == A C==                                                            == A C== X'0A':  Up. It is similar to X'09',  but  the  height   is == A C== X'03'   always changed.                                    == A C==                                                            == A C== X'39':  Down. It is similar to X'38', but the  height   is == A C== X'02'   always changed.                                    == A C==                                                            == A C==        The  exact  location  and  height of subscripts and == A C==        superscripts   are  determined  by  the  particular == A C==        alphabet.   Multiple    levels  of  subscripts  and == A C==        superscripts are permitted; all  levels  are  drawn == A C==        with the same height for X'09' and X'38',  and they == A C==        are drawn with different height for X'0A' and X'39'.== A C==        When change of size occurs, it is always a fraction == A C==        of  HEIGHT.  See  the  description  of  PALPHA  for == A C==        details.                                            == A C==                                                            == A C================================================================ A C==                                                            == A C==   WRITTEN BY RICHARD T. LEE,  TRIUMF, UBC.                 == A C==                               JULY 3, 1981.                == A C================================================================        LOGICAL ASIS       COMMON /MODE/ASIS        DATA ASIS/.FALSE./       REAL*4 X,Y,HEIGHT,ANGLE        LOGICAL EQUC&       LOGICAL*1 STRING(1),STRINGB(256)       LOGICAL*1 LINE1(56)        INTEGER*2 LINE2(256)       LOGICAL*1 LINE3(25000)>       INTEGER*2 SIZE,GRID,HSPAC,VSPAC,PSUPX,PSUPY,PSUBX,PSUBY,%      *          REFX,REFY,SWITC,LSPAC        LOGICAL*1 NAME(16)!       REAL*4 SHGT,SCAL,SSCAL,ANGL '       EQUIVALENCE (LINE1( 1),    SIZE), '      *            (LINE1( 3),    GRID), '      *            (LINE1( 5),   HSPAC), '      *            (LINE1( 7),   VSPAC), '      *            (LINE1( 9),   PSUPX), '      *            (LINE1(11),   PSUPY), '      *            (LINE1(13),   PSUBX), '      *            (LINE1(15),   PSUBY), '      *            (LINE1(17),    SHGT), '      *            (LINE1(21),    SCAL), '      *            (LINE1(25),   SSCAL), '      *            (LINE1(29),    ANGL), '      *            (LINE1(33),    REFX), '      *            (LINE1(35),    REFY), '      *            (LINE1(37),   SWITC), '      *            (LINE1(39),   LSPAC), &      *            (LINE1(41), NAME(1))       LOGICAL GRID16,LISPON 9       COMMON /FONT/ LINE1,LINE2,LINE3,GRID16,LISPON,MGRID A C================================================================ A C==   The following indicates that PALPHA and PSYM have never  == A C==   been called.                                             == A C================================================================X       LOGICAL PALPCD,PSYMCD,)       COMMON /CALLED/ PALPCD,PSYMCD,XC,YCQF       DATA PALPCD/.FALSE./,PSYMCD/.FALSE./,XC/Z80000000/,YC/Z80000000/.       REAL L11,L12,L13,L21,L22,L23,L31,L32,L339       COMMON /LOTRAN/ L11,L21,L31,L12,L22,L32,L13,L23,L33 9       COMMON /GOTRAN/ G11,G21,G31,G12,G22,G32,G13,G23,G33 9       COMMON /TOTRAN/ T11,T21,T31,T12,T22,T32,T13,T23,T33n       LOGICAL*1 LOC(2),LOCLy       INTEGER*2 LOCATN/Z0000/n!       EQUIVALENCE (LOC(1),LOCATN)        EQUIVALENCE (LOC(1),LOCL)        LOGICAL*1 LENCHZ(2)m       INTEGER*2 LENCHA/Z0000/B$       EQUIVALENCE (LENCHZ(1),LENCHA)       LOGICAL*1 WIDTHL(2)        INTEGER*2 WIDTHC/Z0000/s$       EQUIVALENCE (WIDTHL(1),WIDTHC)0       LOGICAL*1 CTRL(6)/Z15,Z16,Z09,Z38,Z0A,Z39/1       LOGICAL*1 CTRL2(6)/Z15,Z16,Z05,Z01,Z03,Z02/        INTEGER NCTRL/6/       LOGICAL*1 FIRST,MOVETO       DATA RADE/1.745329E-2/       DATA ZM0/Z80000000/)       IF(LENGTH.LE.0)RETURN        LENG=MIN(LENGTH,256)       IF (PSYMCD) GO TO 5 6       IF (.NOT. PALPCD) CALL PALPHA('STANDARD ',0,&99)       PSYMCD=.TRUE. 1 C      IF (EQUC(X,ZM0) .OR. EQUC(Y,ZM0)) GO TO 99      5 CONTINUE0 C      IF (EQUC(X,ZM0) .OR. EQUC(Y,ZM0)) GO TO 7
       XC=X
       YC=Y     7 CONTINUE c  set the left margin.s       XMARG=XC       YMARG=YC       LEVELS=0       LEVELV=0       DSUBX=PSUBX-REFX       DSUBY=PSUBY-REFY       DSUPX=PSUPX-REFX       DSUPY=PSUPY-REFY       SHGTD=1./SHGT A C================================================================ A C==   HERE THE GLOBAL TRANSFORMATION IS CALCULATED.            == A C==                                                            == A C================================================================        ANGLER=ANGLE*RADE        COSA=COS(ANGLER)       SINA=SIN(ANGLER)       G11=HEIGHT*COSA        G12=HEIGHT*SINA        G21=-G12
       G22=G11        G13=0.       G23=0.       G31=0.       G32=0.       G33=1.       T11=L11*G11        T12=L11*G12        T13=0.       T21=L21*G11+L22*G21        T22=L21*G12+L22*G22        T23=0.       T31=L31*G11+L32*G21        T32=L31*G12+L32*G22        T33=1.A C================================================================ A C==   EXTRACT INFORMATION FROM 'STRING'.                       == A C================================================================ ' C==     ASIS = .FALSE.  FOR CONVERSION. %       CALL MOVEC(LENG,STRING,STRINGB) :       IF (.NOT.ASIS) CALL ASCEBC_OLD(STRINGB,STRINGB,LENG)       DO 500 I=1,LENG           LOCL=STRINGB(I)          DO 10 J=1,NCTRL          IF(ASIS)THEN -             IF (EQUC(LOCL,CTRL(J))) GO TO 400 
          ELSE -             IF(EQUC(LOCL,CTRL2(J))) GO TO 400           ENDIF    10    CONTINUE !          IFIRST=LINE2(LOCATN+1)+1 ) C         WRITE(6,1313)LOCATN,IFIRST,SIZE  1313     FORMAT(1X,3I10)'          IF (IFIRST .GT. SIZE) GO TO 99            LENCHZ(1)=LINE3(IFIRST)          LCHARA=LENCHA    *          IF (.NOT. GRID16) LCHARA=LCHARA*2          LCHARA=LCHARA+2          FIRST=.TRUE.           IPT=3   100    CONTINUE A C================================================================ A C==   THE FOLLOWING LOOP PLOTS A COMPLETE CHARACTER.           == A C================================================================ H          CALL SPLITE(LINE3(IFIRST),LCHARA,IPT,INX,INY,MGRID,MOVETO,&110)#          XIN=XC+INX*T11+INY*T21+T31 #          YIN=YC+INX*T12+INY*T22+T32 #          IF (.NOT. FIRST) GO TO 105 "          WIDTHL(1)=LINE3(IFIRST+1)"          CALL PLOT_TPLT(XIN,YIN,3)          FIRST=.FALSE.          GO TO 100.   105    IF (MOVETO) CALL PLOT_TPLT(XIN,YIN,3)4          IF (.NOT. MOVETO) CALL PLOT_TPLT(XIN,YIN,2)          GO TO 100   110    CONTINUE A C================================================================ A C==   LETTERSPACING IS CONSIDERED HERE.                        == A C================================================================           WIDTHH=HSPAC+GRID(          IF (LISPON) WIDTHH=LSPAC+WIDTHC          XC=XC+WIDTHH*T11           YC=YC+WIDTHH*T12           GO TO 500   400    CONTINUE (       GO TO (410,420,430,440,450,460), J       GO TO 500    410 CONTINUEA C================================================================ A C==   CARRIAGE RETURN.                                         == A C================================================================        XP=-(VSPAC+GRID)*L21       YP=-(VSPAC+GRID)*L22       XC=XMARG+XP*G11+YP*G21       YC=YMARG+XP*G12+YP*G22       XMARG=XC       YMARG=YC       GO TO 500    420 CONTINUEA C================================================================ A C==   BACKSPACE.                                               == A C================================================================        WIDTHH=HSPAC+GRID        XC=XC-WIDTHH*T11       YC=YC-WIDTHH*T12       GO TO 500    430 CONTINUEA C================================================================ A C==   UP.                                                      == A C================================================================        LEVELS=LEVELS+1        IF (LEVELS) 432,434,436    432 CONTINUE!       XC=XC-(PSUBX*T11+PSUBY*T21) !       YC=YC-(PSUBX*T12+PSUBY*T22)        GO TO 500    434 CONTINUE       XC=XC-(REFX*T11+REFY*T21)        YC=YC-(REFY*T12+REFY*T22)        CALL TRANSF(SHGTD)!       XC=XC-(DSUBX*T11+DSUBY*T21) !       YC=YC-(DSUBX*T12+DSUBY*T22)        GO TO 500    436 CONTINUE!       XC=XC+(DSUPX*T11+DSUPY*T21) !       YC=YC+(DSUPX*T12+DSUPY*T22) *       IF (LEVELS .EQ. 1) CALL TRANSF(SHGT)       XC=XC+(REFX*T11+REFY*T21)        YC=YC+(REFX*T12+REFY*T22)        GO TO 500    440 CONTINUEA C================================================================ A C==   DOWN.                                                    == A C================================================================        LEVELS=LEVELS-1        IF (LEVELS) 442,444,446    442 CONTINUE!       XC=XC+(DSUBX*T11+DSUBY*T21) !       YC=YC+(DSUBX*T12+DSUBY*T22) +       IF (LEVELS .EQ. -1) CALL TRANSF(SHGT)        XC=XC+(REFX*T11+REFY*T21)        YC=YC+(REFX*T12+REFY*T22)        GO TO 500    444 CONTINUE       XC=XC-(REFX*T11+REFY*T21)        YC=YC-(REFX*T12+REFY*T22)        CALL TRANSF(SHGTD)!       XC=XC-(DSUPX*T11+DSUPY*T21) !       YC=YC-(DSUPX*T12+DSUPY*T22)        GO TO 500    446 CONTINUE!       XC=XC-(PSUPX*T11+PSUPY*T21) !       YC=YC-(PSUPX*T12+PSUPY*T22)        GO TO 500    450 CONTINUEA C================================================================ A C==   UP. The size of the character always changes.            == A C================================================================        LEVELV=LEVELV+1        IF (LEVELV) 454,454,456    454 CONTINUE       XC=XC-(REFX*T11+REFY*T21)        YC=YC-(REFY*T12+REFY*T22)        CALL TRANSF(SHGTD)!       XC=XC-(DSUBX*T11+DSUBY*T21) !       YC=YC-(DSUBX*T12+DSUBY*T22)        GO TO 500    456 CONTINUE!       XC=XC+(DSUPX*T11+DSUPY*T21) !       YC=YC+(DSUPX*T12+DSUPY*T22)        CALL TRANSF(SHGT)        XC=XC+(REFX*T11+REFY*T21)        YC=YC+(REFX*T12+REFY*T22)        GO TO 500    460 CONTINUEA C================================================================ A C==   DOWN. The size of the character always changes.          == A C================================================================        LEVELV=LEVELV-1        IF (LEVELV) 462,464,464    462 CONTINUE!       XC=XC+(DSUBX*T11+DSUBY*T21) !       YC=YC+(DSUBX*T12+DSUBY*T22)        CALL TRANSF(SHGT)        XC=XC+(REFX*T11+REFY*T21)        YC=YC+(REFX*T12+REFY*T22)        GO TO 500    464 CONTINUE       XC=XC-(REFX*T11+REFY*T21)        YC=YC-(REFX*T12+REFY*T22)        CALL TRANSF(SHGTD)!       XC=XC-(DSUPX*T11+DSUPY*T21) !       YC=YC-(DSUPX*T12+DSUPY*T22)        GO TO 500    500 CONTINUE       CALL PLOT_I(0,0,99)        RETURN
    99 RETURN1 	       END 