        SUBROUTINE PUT_FORMSG(LUN)H C======================================================================CH C                                                                      CH C  PUT_FORMSG                                      F.W. Jones, TRIUMF  CH C                                                                      CH C  Puts out diagnostic messages for the last FORTRAN run-time error.   CH C                                                                      CH C  System messages are written out for each condition or status code   CH C  that resulted from the error.  For example, in the case of an open  CH C  failure on a file, the system messages will usually indicate why    CH C  the file could not be opened.                                       CH C                                                                      CH C  Input:                                                              CH C                                                                      CH C    LUN   Optional argument specifying a logical unit number for      CH C          message output.  If LUN=0 or LUN is omitted, the message    CH C          is put on SYS$OUTPUT.  If LUN>0, the message is put out     CH C          on logical unit LUN.                                        CH C                                                                      CH C  Example:                                                            CH C                                                                      CH C        CHARACTER*10 FOO                                              CH C        FOO=')JUNK'                                                   CH C        OPEN(UNIT=1,FILE=FOO,STATUS='UNKNOWN',IOSTAT=IERR)            CH C        IF(IERR.NE.0)THEN                                             CH C          WRITE(*,*)'Error opening file ',FOO                         CH C          CALL PUT_FORMSG                                             CH C        ENDIF                                                         CH C                                                                      CH C  Produces the following output on SYS$OUTPUT:                        CH C                                                                      CH C    Error opening file )JUNK                                          CH C    %RMS-F-SYN, file specification syntax error                       CH C    %FOR-F-FILNAMSPE, file name specification error                   CH C                                                                      CH C======================================================================C C  C Get unit number, if any.       LUN1=0       IF(NARGS().GT.0)LUN1=LUN C G       CALL ERRSNS(IERR,ISTS,ISTV,IUNIT,ICOND)     !sense the last error 2       IF(IERR.EQ.0)RETURN      !no error condition C ' C Put out the relevant system messages: -       IF(ISTS.NE.0)CALL PUT_SYSMSG(ISTS,LUN1) -       IF(ISTV.NE.0)CALL PUT_SYSMSG(ISTV,LUN1) /       IF(ICOND.NE.0)CALL PUT_SYSMSG(ICOND,LUN1)  C        RETURN	       END 