&       SUBROUTINE PUT_SYSMSG(ISTAT,LUN)H C======================================================================CH C                                                                      CH C  PUT_SYSMSG                                      F.W. Jones, TRIUMF  CH C                                                                      CH C  Puts out the system message for status code ISTAT.                  CH C                                                                      CH C  Input:                                                              CH C                                                                      CH C    ISTAT   System status code (e.g. return value from Run-Time       CH C            Library routine or System Service)                        CH C                                                                      CH C    LUN   Optional argument specifying a logical unit number for      CH C          message output.  If LUN=0 or LUN is omitted, the message    CH C          is put on SYS$OUTPUT.  If LUN>0, the message is put out     CH C          on logical unit LUN.                                        CH C                                                                      CH C  Example:                                                            CH C                                                                      CH C    CHARACTER*10 FOO                                                  CH C    FOO=')JUNK'                                                       CH C    ISTAT=LOK_IOFAST$OPENR(1,FOO)                                     CH C    IF(.NOT.ISTAT)THEN                                                CH C      WRITE(*,*)'Error opening file ',FOO                             CH C      CALL PUT_SYSMSG(ISTAT)                                          CH C    ENDIF                                                             CH C                                                                      CH C  Produces the following output on SYS$OUTPUT:                        CH C                                                                      CH C    Error opening file )JUNK                                          CH C    %RMS-F-SYN, file specification syntax error                       CH C    %FOR-F-FILNAMSPE, file name specification error                   CH C                                                                      CH C======================================================================C       CHARACTER*80 MSG C  C Get unit number, if any.       LUN1=0       IF(NARGS().GT.1)LUN1=LUN C  C Get the message:
       MSG=' ' %       IST=LIB$SYS_GETMSG(ISTAT,L,MSG) F       IF(.NOT.IST)RETURN      !failed to get a message ... do nothing. C ) C Chop off any (empty) diagnostic fields:        IEX=INDEX(MSG,'!')       IF(IEX.GT.0)L=IEX-1  C . C Put the message to the relevant destination:       IF(LUN1.GT.0)THEN          WRITE(LUN1,*)MSG(1:L) 
       ELSE         WRITE(*,*)MSG(1:L)       ENDIF        C        RETURN	       END 