8       SUBROUTINE PUT_METAFILE1(LUN,OPER,X,Y,P1,IERROR,*) C     reqd. routines - NONE H C======================================================================== C     PUT_METAFILE1 writes one record to a graphics metafile. A C     The metafile can be read back by the GET_METAFILE1 routine. H C     Each record written by PUT_METAFILE1 contains one or more  TelidonH C     PDIs followed by a carriage return (the carriage return  signifies C     the end-of-record).  C H C     An arbitrary amount of ASCII text can be written to  the  metafileH C     before calling PUT_METAFILE1.  The  first  call  to  PUT_METAFILE1H C     should specify the 'SO' operation described below under  the  OPERH C     input argument.  This first call should be immediately followed by5 C     a call that specifies the 'INITIALI' operation.  C H C     It is desireable, but not  mandatory,  to  write  the  ASCII  "SI"H C     ("shift in") character (hexadecimal 0F) to the metafile  followingH C     the  last  Telidon  PDI.  This  can  be  accomplished  by  calling% C     PUT_METAFILE1 with OPER = 'SI'.  C H C     An alternate error return is taken for any of the error conditions  C     listed under IERROR below. C  C     Input arguments: C     ----- ---------  C H C     LUN        INTEGER*4   -- logical unit that metafile  is  attached" C                               to C  C     OPER       CHARACTER*(*)H C                            -- string containing the desired operation.< C                               The possible operations are: C C C                               'CLEAR'      clear display surface; = C                                            pen up to (0,0). @ C                               'COLOR'      select pen color n,H C                                            0 < n < 5, where n is givenF C                                            by the P1 input argument.A C                               'INITIALI'   initialize metafile. ? C                               'LINE'       pen down to (X,Y). = C                               'MOVE'       pen up to (X,Y). H C                               'POINT'      pen up to (X,Y) and draw  a3 C                                            point. H C                               'SI'         write the ASCII  "shift in"G C                                            character to the metafile. H C                               'SO'         write the ASCII "shift out"G C                                            character to the metafile. G C                               'WAIT'       send WAIT PDI to metafile.  C D C     X          REAL*4      -- X coordinate for LINE, MOVE or POINT7 C                               operations, 0 <= X <= 1  C D C     Y          REAL*4      -- Y coordinate for LINE, MOVE or POINT7 C                               operations, 0 <= X <= 1  C 7 C     P1         INTEGER*4   -- With 'COLOR' operation: ? C                                 color to be selected by COLOR 8 C                                 operation; 0 < P1 < 5.3 C                                 P1 = 1      white 1 C                                    = 2      red 3 C                                    = 3      green 2 C                                    = 4      blue6 C                            -- With 'WAIT' operation:D C                                 specifies time delay in processingB C                                 metafile; units are 1/10 second.. C                                 0 <= P1 < 64" C                                  C  C     Output arguments:  C     ------ --------- C + C     IERROR     INTEGER*4   -- error code: . C                               0  -- no error< C                               1  -- no specified operation< C                               2  -- unrecognized operationH C                               3  -- invalid (X,Y) coordinate for LINE,> C                                     MOVE or POINT operationsH C                               4  -- invalid  color  index  for   COLOR/ C                                     operation H C                               5  -- unable to write  to  logical  unit) C                                     LUN 8 C                               6  -- no active metafileH C                               7  -- invalid   wait   time   for   WAIT/ C                                     operatione CT, C     Author:  Alan Carruthers, July 5, 1983 C     ------ C1H C======================================================================= C        LOGICAL*1 PDI(20)s       INTEGER P1$       CHARACTER OPER*(*), OPERATOR*8       LOGICAL ON%       COMMON /METAFILE1/ ON, META_LUN  Co       IF(.NOT. ON) THEN $ C        Error -- no active metafile          IERROR = 6t          RETURN 1e       END IF Ce"       IERROR = 0  !assume no error       L_OPER = LEN(OPER) Cm       IF(L_OPER .LE. 0) THEN( C        Error -- no specified operation          IERROR = 1           RETURN 1           END IFw Ce& C     Translate OPERATOR to uppercase.       OPERATOR = OPERF(       CALL STR$UPCASE(OPERATOR,OPERATOR) C $ C     ------------------------------,       IF     (OPERATOR .EQ. 'CLEAR   ') THEN C * C        Clear screen and border to black.#          PDI(1)  = '20'X    !RESET t          PDI(2)  = '78'X          PDI(3)  = '40'X C : C        Set drawing position to (0,0). No point is drawn.<          PDI(4)  = '24'X    !POINT SET (absolute, invisible)1          CALL PUT_TELIDON_COORDINATE(PDI,5,0.,0.)A          N = 12  C $ C     ------------------------------,       ELSE IF(OPERATOR .EQ. 'COLOR   ') THEN C            IF     (P1 .EQ. 1) THEN+             PDI(2) = '5F'X           !whiteR           ELSE IF(P1 .EQ. 2) THEN)             PDI(2) = '6B'X           !redp           ELSE IF(P1 .EQ. 3) THEN+             PDI(2) = '75'X           !green            ELSE IF(P1 .EQ. 4) THEN*             PDI(2) = '60'X           !blue
          ELSE = C           Error -- invalid color index for COLOR operation.              IERROR = 4             RETURN 1          END IF (          PDI(1) = '3E'X    !SELECT COLOR          N = 2 C $ C     ------------------------------,       ELSE IF(OPERATOR .EQ. 'INITIALI') THEN C 6 C        Specify dimensionality of 2, full resolution,& C        and logical pel size of zero.#          PDI(1)  = '21'X    !DOMAIN           PDI(2)  = '5C'X1          CALL PUT_TELIDON_COORDINATE(PDI,3,0.,0.)  C B C        Select color mode 1 (color map for foreground pels only),@ C        set color map to default colors, and set in-use drawing C        color to white."          PDI(11) = '20'X    !RESET          PDI(12) = '46'X          PDI(13) = '40'X          N = 13  C $ C     ------------------------------,       ELSE IF(OPERATOR .EQ. 'LINE    ') THEN C !          PDI(1)  = '28'X    !LINE 4          CALL PUT_TELIDON_COORDINATE(PDI,2,X,Y,*250)          N = 9 C $ C     ------------------------------,       ELSE IF(OPERATOR .EQ. 'MOVE    ') THEN C-<          PDI(1)  = '24'X    !POINT SET (absolute, invisible)4          CALL PUT_TELIDON_COORDINATE(PDI,2,X,Y,*250)          N = 9 Co$ C     ------------------------------,       ELSE IF(OPERATOR .EQ. 'POINT   ') THEN C :          PDI(1)  = '26'X    !POINT SET (absolute, visible)4          CALL PUT_TELIDON_COORDINATE(PDI,2,X,Y,*250)          N = 9 C $ C     ------------------------------,       ELSE IF(OPERATOR .EQ. 'SI      ') THEN C 5          PDI(1)  = '0F'X    !ASCII shift-in character           N = 1 C $ C     ------------------------------,       ELSE IF(OPERATOR .EQ. 'SO      ') THEN C 6          PDI(1)  = '0E'X    !ASCII shift-out character          N = 1 C-$ C     ------------------------------,       ELSE IF(OPERATOR .EQ. 'WAIT    ') THEN C /          IF((P1 .LT. 0) .OR. (P1 .GT. 63)) THEN + C           Error -- invalid wait interval.              IERROR = 7             RETURN 1          END IF !          PDI(1)  = '3D'X    !WAIT           PDI(2)  = '5C'X          PDI(3)  = 64 + P1          N = 3 C $ C     ------------------------------
       ELSE+ C        Error -- operation not recognized.           IERROR = 2           RETURN 1        END IF C . C     Write Picture Discription Instruction(s)/       WRITE(LUN,200,ERR=220) (PDI(I), I = 1, N)    200 FORMAT(100A1)        RETURN Co Ct3 C     Error -- unable to write to logical unit LUN.n   220 CONTINUE       IERROR = 5       RETURN 1 C " C     Error -- invalid coordinate.   250 CONTINUE       IERROR = 3       RETURN 1 C-	       END= C= C= C=4       SUBROUTINE PUT_TELIDON_COORDINATE(PDI,N,X,Y,*) C %       LOGICAL*1 PDI(20), PDI_COORD(8)E       INTEGER W(2)%       EQUIVALENCE (W(1),PDI_COORD(1))  C < C     Ensure that (X,Y) lies within the Telidon unit square.*       IF((X .LT. 0.) .OR. (X .GT. 1.) .OR./      >   (Y .LT. 0.) .OR. (Y .GT. 1.)) RETURN 1  C H C     W will hold the Telidon representation of the X and Y coordinates.G C     This will be a Telidon multi-value operand of 8 bytes, hence W is ! C     dimensioned as 2 longwords.  C @ C     Initialize W before moving X and Y coordinate bits into W.       W(1) = '40404040'X       W(2) = W(1)R CR/       CALL REAL4_TO_TELIDON_COORDINATE('X',X,W)- C H C     (February 9, 1984.  Y coordinate scaled so that it lies within theG C     customary physical screen of a Telidon terminal with aspect ratio 8 C     of 4 horizontal : 3 vertical.  -- Alan Carruthers)4       CALL REAL4_TO_TELIDON_COORDINATE('Y',Y*0.75,W) C        NN = 0       DO 50 I = N, N+7          NN = NN + 1          PDI(I) = PDI_COORD(NN).    50 CONTINUE
       RETURN  	       END- C- C- C-:       SUBROUTINE REAL4_TO_TELIDON_COORDINATE(XORY,COORD,W)       CHARACTER*1 XORY!       INTEGER W(2), EXPONENT, POS !       EQUIVALENCE (COORD1,ICOORD)P CEA C     XPOS and YPOS contain the bit positions in W that will holdS: C     successive binary digits of the X and Y coordinates.        INTEGER XPOS(23), YPOS(23)A       DATA XPOS/4,3,13,12,11,21,20,19,29,28,27,37,36,35,45,44,43, "      >          53,52,51,61,60,59/?       DATA YPOS/1,0,10,9,8,18,17,16,26,25,24,34,33,32,42,41,40,E"      >          50,49,48,58,57,56/ C1 C @ C     Extract excess 128 binary exponent from REAL*4 coordinate.       COORD1 = COORD"       EXPONENT = IBITS(ICOORD,7,8) C 4 C     Change excess 128 exponent to actual exponent.       EXPONENT = EXPONENT - 128z Cf!       IF(XORY .EQ. 'Y') GO TO 100  CM@ C     Pack X coordinate into 8 byte Telidon multi-value operand.       IF(COORD .EQ. 1.) THEN%          W(1) = W(1) .OR. '38383818'Xe%          W(2) = W(2) .OR. '38383838'Xm!       ELSE IF(COORD .GT. 0.) THENeH          IF(EXPONENT .LT. -22) GO TO 100  !coordinate is treated as zero C E C        Insert first non-zero binary digit of coordinate in W. (This D C        bit is not contained in the fractional part of the floating- C        representation of the X coordinate.) !          POS = XPOS(1 - EXPONENT)A          IF(POS .LE. 31) THEN="             W(1) = IBSET(W(1),POS)
          ELSE %             W(2) = IBSET(W(2),POS-32)           END IF1 C=@ C        Insert fractional part of floating representation in W.          LIM = 2 - EXPONENT)          IF(LIM .LE. 23) THEN-             POS = -1             DO 20 I = LIM,23                POS = POS + 1                IPOS = XPOS(I)S"                IF(POS .LE. 6) THEN'                   IF(IPOS .LE. 31) THEN :                      CALL MVBITS(ICOORD,6-POS,1,W(1),IPOS)                   ELSE=                      CALL MVBITS(ICOORD,6-POS,1,W(2),IPOS-32)t                   END IF                ELSE-'                   IF(IPOS .LE. 31) THENP;                      CALL MVBITS(ICOORD,38-POS,1,W(1),IPOS)                    ELSE>                      CALL MVBITS(ICOORD,38-POS,1,W(2),IPOS-32)                   END IF                END IF     20       CONTINUE          END IF)       END IF       GO TO 200v Cd Ci   100 CONTINUE C @ C     Pack Y coordinate into 8 byte Telidon multi-value operand.       IF(COORD .EQ. 1.) THEN%          W(1) = W(1) .OR. '07070703'X %          W(2) = W(2) .OR. '07070707'X-!       ELSE IF(COORD .GT. 0.) THEN H          IF(EXPONENT .LT. -22) GO TO 100  !coordinate is treated as zero C E C        Insert first non-zero binary digit of coordinate in W. (ThisuD C        bit is not contained in the fractional part of the floating- C        representation of the Y coordinate.)-!          POS = YPOS(1 - EXPONENT)N          IF(POS .LE. 31) THENR"             W(1) = IBSET(W(1),POS)
          ELSEo%             W(2) = IBSET(W(2),POS-32)=          END IF1 C-@ C        Insert fractional part of floating representation in W.          LIM = 2 - EXPONENTA          IF(LIM .LE. 23) THEN              POS = -1             DO 120 I = LIM,23                 POS = POS + 1                IPOS = YPOS(I)u"                IF(POS .LE. 6) THEN'                   IF(IPOS .LE. 31) THENY:                      CALL MVBITS(ICOORD,6-POS,1,W(1),IPOS)                   ELSE=                      CALL MVBITS(ICOORD,6-POS,1,W(2),IPOS-32)d                   END IF                ELSE2'                   IF(IPOS .LE. 31) THENr;                      CALL MVBITS(ICOORD,38-POS,1,W(1),IPOS)0                   ELSE>                      CALL MVBITS(ICOORD,38-POS,1,W(2),IPOS-32)                   END IF                END IF    120       CONTINUE          END IFs       END IF CT Cd   200 CONTINUE       RETURN	       END4  