H C======================================================================CH C                                                                      CH C   PX_BASIC                         A. Haynes, C.J. Kost, F.W. Jones  CH C                                                                      CH C   Self contained program to read the graphics screen bitmap from     CH C   VT640 terminals and emulators, store it (in HP Laserjet            CH C   format) in the internal bitmap array. The user is responsible for  CH C   writing the bit map ARRAY(128,480) to his device!                  CH C   The bitmap is also available in HP laserjet form in HARDCOPY       CH C                                                                      CH C======================================================================C        LOGICAL*1 HARDCOPY(80,480)         COMMON/TO_BIT_OR_NOT/WELL        LOGICAL WELL/.TRUE./         INTEGER LEN(480)'       LOGICAL*1 ARRAY(128,480),ARR(128)        LOGICAL ERROR          INTEGER INBUFF1        LOGICAL*1 INBUFF1L(4) #       EQUIVALENCE(INBUFF1,INBUFF1L)        INTEGER INBUFF2        LOGICAL*1 INBUFF2L(4) #       EQUIVALENCE(INBUFF2,INBUFF2L)          INTEGER OUTBUFF1       LOGICAL*1 OUTBUFF1L(4)%       EQUIVALENCE(OUTBUFF1,OUTBUFF1L)        INTEGER OUTBUFF2       LOGICAL*1 OUTBUFF2L %       EQUIVALENCE(OUTBUFF2,OUTBUFF2L)          N1=80        N2=480  *       CALL READ_PLOT('TT',ARRAY,LEN,ERROR)       CALL TRANSPARENT_MODE(0)D       IF(ERROR)STOP '  ***Error*** in reading plot from the screen.'         DO J=1,480         NARR=0         L=0 
 50      L=L+1          IF(L.GT.LEN(J))GO TO 70 %         IF(ARRAY(L,J).EQ.'$')GO TO 60          NARR=NARR+1          ARR(NARR)=ARRAY(L,J)         GO TO 50    C Expand sequence of zero bytes: 60      NZERO=ARRAY(L+1,J)         NZERO=MOD(NZERO,64)          DO NA=NARR+1,NARR+NZERO            ARR(NA)=0 
         ENDDO          NARR=NARR+NZERO 
         L=L+1          GO TO 50         70      DO IGROUP=1,16)           INBUFF1L(1)=ARR((IGROUP-1)*8+1) )           INBUFF1L(2)=ARR((IGROUP-1)*8+2) )           INBUFF1L(3)=ARR((IGROUP-1)*8+3) )           INBUFF1L(4)=ARR((IGROUP-1)*8+4) )           INBUFF2L(1)=ARR((IGROUP-1)*8+5) )           INBUFF2L(2)=ARR((IGROUP-1)*8+6) )           INBUFF2L(3)=ARR((IGROUP-1)*8+7) )           INBUFF2L(4)=ARR((IGROUP-1)*8+8)   -           CALL MVBITS(INBUFF1,0,5,OUTBUFF1,3) .           CALL MVBITS(INBUFF1,10,3,OUTBUFF1,0).           CALL MVBITS(INBUFF1,8,2,OUTBUFF1,14).           CALL MVBITS(INBUFF1,16,5,OUTBUFF1,9).           CALL MVBITS(INBUFF1,28,1,OUTBUFF1,8)/           CALL MVBITS(INBUFF1,24,4,OUTBUFF1,20) .           CALL MVBITS(INBUFF2,1,4,OUTBUFF1,16).           CALL MVBITS(INBUFF2,0,1,OUTBUFF1,31).           CALL MVBITS(INBUFF2,8,5,OUTBUFF1,26)/           CALL MVBITS(INBUFF2,19,2,OUTBUFF1,24) .           CALL MVBITS(INBUFF2,16,3,OUTBUFF2,5).           CALL MVBITS(INBUFF2,24,5,OUTBUFF2,0)  1           HARDCOPY((IGROUP-1)*5+1,J)=OUTBUFF1L(1) 1           HARDCOPY((IGROUP-1)*5+2,J)=OUTBUFF1L(2) 1           HARDCOPY((IGROUP-1)*5+3,J)=OUTBUFF1L(3) 1           HARDCOPY((IGROUP-1)*5+4,J)=OUTBUFF1L(4) .           HARDCOPY((IGROUP-1)*5+5,J)=OUTBUFF2L
         ENDDO        ENDDO     C      CALL GRAPHICS_HARDCOPY(0)	       END H C======================================================================CH C                                                                      CH C  READPLOT.FOR                                                        CH C                                                                      CH C  Support routines for reading from and writing to the VT640          CH C  bitmap, & for dumping the bitmap to the Printronix printer.         CH C  These routines are used by PX, PX650 utilities.                     CH C                                                                      CH C  NOTE: WRITE_BITMAP_PX has been removed to its own source file.      CH C                                                                      CH C======================================================================C  2       SUBROUTINE READ_PLOT(DEVICE,ARRAY,LEN,ERROR) C 8 C  reqd. KOSTL: routines - BTD,LSWAP.MAR,MOVEC,READNOECHB C  the following are in READNOECH - ASSIGN_DEVICE,DEASSIGN_DEVICE,0 C                                 - WRITE_DIRECT C G C====================================================================== G C====================================================================== G C==                                                                  == G C==   READ_PLOT: reads the bitmap from the VT640 terminal which has  == G C==              the logical name "DEVICE" (eg. 'TT' or '_TTA1:').   == G C==              The bitmap is stored in the 2-dimensional array:    == G C==              ARRAY(128,480) as 480 dot lines of 128 5-bit        == G C==              characters (See the VT640 graphics manual for more  == G C==              details on how the screen raster image is stored).  == G C==              LEN(480) is an array of lengths (in bytes) of each  == G C==              dot line. The first line of ARRAY, ARRAY(128,1)     == G C==              corresponds to the top dot line on the screen.      == G C==              If ERROR is returned as .TRUE. then an error has    == G C==              occured in reading the bitmap from the screen.      == G C==                                                                  == G C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        == G C==                                                                  == G C==   Input  Parameters: DEVICE (CHARACTER*(*)).                     == G C==                                                                  == G C==   Output Parameters: ARRAY(128,480) (L*1); LEN(480) (I*4);       == G C==                      ERROR (L*4).                                == G C==                                                                  == G C====================================================================== G C======================================================================        CHARACTER*(*) DEVICE1       LOGICAL*1 ARRAY(128,480),BUFFER(9),ARR(129)        INTEGER LEN(480)       LOGICAL ERROR C       LOGICAL*1 OUT1(13)/'+',Z1B,'"','0',';',3*'0',';','1','2','8',       *                   'c'/ $       LOGICAL*1 GRAPHICS(2)/'+',Z1D/       INTEGER*2 CHANNEL G C====================================================================== G C==   Assign the DEVICE to the CHANNEL.                              == G C====================================================================== .       CALL ASSIGN_DEVICE(DEVICE,CHANNEL,ERROR)       IF(ERROR)RETURN G C====================================================================== G C==   Write out the control sequence which puts the VT640 in graphics== G C==   mode.                                                          == G C====================================================================== 1       CALL WRITE_DIRECT(CHANNEL,GRAPHICS,2,ERROR)        IF(ERROR)RETURN        DO 100 L=1,480(       CALL BTD(480-L,OUT1(6),3,NSIG,'0')G C====================================================================== G C==   Write out the control sequence which causes the VT640 to send  == G C==   back to the host computer the L'th dot line from the top of the== G C==   screen.                                                        == G C====================================================================== .       CALL WRITE_DIRECT(CHANNEL,OUT1,13,ERROR)       IF(ERROR)RETURN G C====================================================================== G C==   Read the L'th dot line without echoing it on the terminal.     == G C====================================================================== 5       CALL READ_NO_ECHO(CHANNEL,ARR,LEN(L),129,ERROR)        IF(ERROR)RETURN G C====================================================================== G C==   Store the LEN(L) characters of the L'th dot line at the        == G C==   array location ARRAY(1,L).                                     == G C====================================================================== '       CALL MOVEC(LEN(L),ARR,ARRAY(1,L))  100   CONTINUEG C====================================================================== G C==   Deassign the DEVICE from the CHANNEL.                          == G C====================================================================== )       CALL DEASSIGN_DEVICE(CHANNEL,ERROR)        RETURN	       END <       SUBROUTINE READ_NO_ECHO(CHANNEL,LINE,LEN,MAXLEN,ERROR) C    C     reqd. routines - NONE G C====================================================================== G C====================================================================== G C==                                                                  == G C==   READ_NO_ECHO: reads from the I/O channel number "CHANNEL",     == G C==                 assigned to a terminal, a line which has a       == G C==                 maximum of "MAXLEN" characters, without echoing  == G C==                 the characters. The actual number of characters  == G C==                 read in and returned in "LINE" is "LEN"          == G C==                 characters. Example: if the user uses this to    == G C==                 read a line of characters from his terminal then == G C==                 the characters which he types will not be echoed == G C==                 on the terminal.                                 == G C==                 Note: The I/O channel number "CHANNEL" can be    == G C==                 assigned to a terminal using the subroutine      == G C==                 "ASSIGN_DEVICE".                                 ===G C==                                                                  == G C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        ==SG C==                                                                  == G C==   Input  Parameters: CHANNEL (I*2); MAXLEN (I*4).                ==cG C==                                                                  == G C==   Output Parameters: LINE(MAXLEN) (L*1); LEN (I*4); ERROR (L*4). ==tG C==                                                                  ==nG C==   Parameter Definitions:                                         ==iG C==   --------- -----------                                          == G C==                                                                  ===G C==   CHANNEL: Integer*2 I/O channel number assigned to the terminal ==IG C==            from which the characters are to be read without echo.== G C==                                                                  ==RG C==   LINE   : Input line buffer of "MAXLEN" characters in which the ==NG C==            "LEN" characters read from the terminal are returned. == G C==            Note: If the number of characters sent from the       == G C==            terminal is less than "MAXLEN" then "LEN" < "MAXLEN"  ==FG C==            and the line of characters sent from the terminal must== G C==            be terminated by a carriage return.                   ==AG C==            If the number of characters sent from the terminal is == G C==            greater than or equal to "MAXLEN" then "LEN" = "MAXLEN"= G C==            and no carriage return is required because READ_NO_ECHO= A C==            will automatically terminate the read at "MAXLEN"  G C==            characters. If a carriage return or more characters   == G C==            are sent from the terminal after this automatic       == G C==            termination of the read then they will be treated as  == G C==            the next input line from the terminal.                == G C==                                                                  == G C==   LEN    : Number of characters read in and returned in "LINE".  == G C==                                                                  == G C==   MAXLEN : Maximum number of characters read in and returned in  == G C==            "LINE".                                               == G C==                                                                  == G C==   ERROR  : LOGICAL flag which if .TRUE. indicates an error has   == G C==            occured in "READ_NO_ECHO". In this case an error      == G C==            message is automatically written on unit 6 by         == G C==            "READ_NO_ECHO".                                       == G C==                                                                  == G C====================================================================== G C======================================================================        LOGICAL*1 LINE(1)        INTEGER SYS$QIOW*       INTEGER*2 CHANNEL,IO_STATUS_BLOCK(4)'       EXTERNAL IO$_READVBLK,IO$M_NOECHO        LOGICAL ERROR        CHARACTER*10 STATUS        LEN=0        IF(MAXLEN.LE.0)RETURN G C====================================================================== G C==   The function code for the QIO is: "read a virtual block with   == G C==   no echo".                                                      == G C==   SYS$QIOW: reads in the line.                                   == G C====================================================================== 7       IFUNCTION=%LOC(IO$_READVBLK).OR.%LOC(IO$M_NOECHO) E       ISYS=SYS$QIOW(,%VAL(CHANNEL),%VAL(IFUNCTION),IO_STATUS_BLOCK,,, +      *               LINE,%VAL(MAXLEN),,,,) G C====================================================================== G C==   A SYS$QIOW error occurs if ISYS .ne. 1.                        == G C======================================================================        ERROR=ISYS.NE.1        IF(ERROR)GO TO 5G C====================================================================== G C==   The number of characters read in is in IO_STATUS_BLOCK(2).     == G C======================================================================        LEN=IO_STATUS_BLOCK(2)       RETURNG C====================================================================== G C==   On an error check the return status and write out the          == G C==   appropriate messages.                                          == G C====================================================================== 8 5     CALL CHECK_RETURN_STATUS(ISYS,.TRUE.,ERROR,STATUS)       IF(ERROR)WRITE(6,10)/ 10    FORMAT('   ***Error*** in READ_NO_ECHO:', <      *       ' Failed to read from CHANNEL using SYS$QIOW.')       RETURN	       END 5       SUBROUTINE WRITE_DIRECT(CHANNEL,LINE,LEN,ERROR) G C====================================================================== G C====================================================================== G C==                                                                  == G C==   WRITE_DIRECT: writes to the I/O channel number "CHANNEL",      == G C==                 assigned to a terminal, a "LINE" which has a "LEN"= G C==                 characters, the first of which is a carriage     == G C==                 control character.                               == G C==                 If an error occurs while writing, then "ERROR" is== G C==                 returned as .TRUE. and an error message is       == G C==                 written on unit 6 by "READ_NO_ECHO".             == @ C==                                                             *       INTEGER*2 CHANNEL,IO_STATUS_BLOCK(4)       LOGICAL ERROR +       LOGICAL*1 LINE(1),CARRIAGE_CONTROL(4) 3       INTEGER ICARRIAGE_CONTROL/Z00000000/,SYS$QIOW 9       EQUIVALENCE (CARRIAGE_CONTROL(1),ICARRIAGE_CONTROL)        EXTERNAL IO$_WRITEVBLK       CHARACTER*10 STATUS        IF(LEN.LE.0)RETURN!       CARRIAGE_CONTROL(1)=LINE(1) #       IFUNCTION=%LOC(IO$_WRITEVBLK) E       ISYS=SYS$QIOW(,%VAL(CHANNEL),%VAL(IFUNCTION),IO_STATUS_BLOCK,,, D      *               LINE(2),%VAL(LEN-1),,%VAL(ICARRIAGE_CONTROL),,)       ERROR=ISYS.NE.1        IF(.NOT.ERROR)RETURN8       CALL CHECK_RETURN_STATUS(ISYS,.TRUE.,ERROR,STATUS)       IF(ERROR)WRITE(6,10)/ 10    FORMAT('   ***Error*** in WRITE_DIRECT:', ;      *       ' Failed to write on CHANNEL using SYS$QIOW.')        RETURN	       END 4       SUBROUTINE ASSIGN_DEVICE(DEVICE,CHANNEL,ERROR)       CHARACTER*(*) DEVICE       INTEGER*2 CHANNEL        INTEGER SYS$ASSIGN)       LOGICAL ERROR,WRITE_MESSAGE/.TRUE./        CHARACTER*10 STATUS <       CALL CHECK_RETURN_STATUS(SYS$ASSIGN(DEVICE,CHANNEL,,),:      *                         WRITE_MESSAGE,ERROR,STATUS)        IF(ERROR)WRITE(6,10)DEVICE0 10    FORMAT('   ***Error*** in ASSIGN_DEVICE:',:      *       ' Failed to assign device ',A,' to CHANNEL.')       RETURN	       END /       SUBROUTINE DEASSIGN_DEVICE(CHANNEL,ERROR)        INTEGER*2 CHANNEL )       LOGICAL ERROR,WRITE_MESSAGE/.TRUE./        CHARACTER*10 STATUS 9       CALL CHECK_RETURN_STATUS(SYS$DASSGN(%VAL(CHANNEL)), :      *                         WRITE_MESSAGE,ERROR,STATUS)!       IF(ERROR)WRITE(6,10)CHANNEL 2 10    FORMAT('   ***Error*** in DEASSIGN_DEVICE:',0      *       ' Failed to deassign CHANNEL:',I12)       RETURN	       END 3       SUBROUTINE CHECK_RETURN_STATUS(RETURN_STATUS, @      *                               WRITE_MESSAGE,ERROR,STATUS)       INTEGER RETURN_STATUS !       LOGICAL WRITE_MESSAGE,ERROR        CHARACTER*(*) STATUSH       EXTERNAL SS$_NORMAL,SS$_REMOTE,SS$_ABORT,SS$_ACCVIO,SS$_DEVACTIVE,G      * SS$_DEVALLOC,SS$_DEVNOTMBX,SS$_EXQUOTA,SS$_INSFMEM,SS$_IVDEVNAM, F      * SS$_IVLOGNAM,SS$_NOIOCHAN,SS$_NOLINKS,SS$_NOPRIV,SS$_NOSUCHDEV,+      * SS$_NOSUCHNODE,SS$_REJECT,SS$_IVCHAN .       IF(RETURN_STATUS.EQ.%LOC(SS$_NORMAL).OR./      *   RETURN_STATUS.EQ.%LOC(SS$_REMOTE))THEN           ERROR=.FALSE.          RETURN           ENDIF       ERROR=.TRUE.       STATUS='WHO KNOWS?' 8       IF(RETURN_STATUS.EQ.%LOC(SS$_ABORT))STATUS='ABORT':       IF(RETURN_STATUS.EQ.%LOC(SS$_ACCVIO))STATUS='ACCVIO'@       IF(RETURN_STATUS.EQ.%LOC(SS$_DEVACTIVE))STATUS='DEVACTIVE'>       IF(RETURN_STATUS.EQ.%LOC(SS$_DEVALLOC))STATUS='DEVALLOC'@       IF(RETURN_STATUS.EQ.%LOC(SS$_DEVNOTMBX))STATUS='DEVNOTMBX'<       IF(RETURN_STATUS.EQ.%LOC(SS$_EXQUOTA))STATUS='EXQUOTA'<       IF(RETURN_STATUS.EQ.%LOC(SS$_INSFMEM))STATUS='INSFMEM'>       IF(RETURN_STATUS.EQ.%LOC(SS$_IVDEVNAM))STATUS='IVDEVNAM'>       IF(RETURN_STATUS.EQ.%LOC(SS$_IVLOGNAM))STATUS='IVLOGNAM'>       IF(RETURN_STATUS.EQ.%LOC(SS$_NOIOCHAN))STATUS='NOIOCHAN'<       IF(RETURN_STATUS.EQ.%LOC(SS$_NOLINKS))STATUS='NOLINKS':       IF(RETURN_STATUS.EQ.%LOC(SS$_NOPRIV))STATUS='NOPRIV'@       IF(RETURN_STATUS.EQ.%LOC(SS$_NOSUCHDEV))STATUS='NOSUCHDEV'>       IF(RETURN_STATUS.EQ.%LOC(SS$_NOSUCHNODE))STATUS='REJECT':       IF(RETURN_STATUS.EQ.%LOC(SS$_IVCHAN))STATUS='IVCHAN'6       IF(WRITE_MESSAGE)WRITE(6,10)STATUS,RETURN_STATUS= 10    FORMAT('   ***Return Status from system routine is ',A,(      *       ',  Value =',I12)       RETURN	       END -       SUBROUTINE BTD(NUMB,CH,NCH,NSIG,FILL,*)a Ce C     LIBRARY-ROUTINE  C = C                                                29/JULY/1980 > C                                                C.J. KOST SIN C  C     reqd. routines - NONE  C A C================================================================dA C================================================================tA C==                                                            == A C==   BTD: ("BINARY TO DECIMAL"), CONVERTS FORTRAN INTEGER     ==oA C==        NUMBERS INTO NUMERIC CHARACTER STRINGS.             ==tA C==                                                            ==IA C==   THIS ROUTINE IS EQUIVALENT TO THE UBC CHARACTER ROUTINE: ==tA C==   "BTD".                                                   == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., APRIL 17, 1979. ==AA C==                                                            == A C==   INPUT  PARAMETERS: NUMB,NCH, (I*4); FILL (L*1).          == A C==                                                            ==aA C==   OUTPUT PARAMETERS: CH(NCH), (L*1); NSIG (I*4).           == A C==                                                            == A C==   HOW TO USE:                                              == A C==                                                            ==eA C==   CALL BTD(NUMB,CH,NCH,NSIG,FILL,&S)                       == A C==                                                            == A C==   WHERE:                                                   ==mA C==                                                            == A C==   NUMB: IS AN INTEGER EXPRESSION GIVING THE NUMBER TO BE   == A C==         CONVERTED.                                         == A C==                                                            == A C==   CH  : IS AN ARRAY OF "NCH" CHARACTERS WHERE THE CHARACTER== A C==         REPRESENTATION OF "NUMB" IS TO BE STORED.          ==nA C==                                                            == A C==   NCH : IS THE NUMBER OF CHARACTERS DESIRED IN "CH".       ==tA C==         "NCH" SHOULD BE <= 12 AND => 0. IF "NCH" <= 0, THEN== A C==         THE NUMBER OF CHARACTERS WILL BE TAKEN AS THE      == A C==         NUMBER OF SIGNIFICANT DIGITS IN "NUMB" PLUS ONE FOR===A C==         THE SIGN IF "NUMB" IS NEGATIVE. IF "NCH">12, THE   ===A C==         CHARACTERS WILL BE RIGHT JUSTIFIED IN THE 12       ==*A C==         POSITIONS STARTING WITH "CH" AND A RETURN 1 TAKEN. ==UA C==                                                            == A C==   NSIG: WILL BE SET TO THE NUMBER OF SIGNIFICANT DIGITS    ==EA C==         IN 'NUMB', (PLUS 1 IF THE SIGN IS NEGATIVE).       ===A C==                                                            ==iA C==   FILL: IS A CHARACTER WHICH WILL BE USED TO REPLACE       == A C==         LEADING ZEROS IN THE STRING.                       == A C==                                                            ===A C==   &S  : (RETURN1) IS THE NUMBER OF A FORTRAN STATEMENT TO  ==RA C==         WHICH CONTROL WILL BE TRANSFERRED IF "NCH" > 12.   ==%A C==                                                            ==MA C==   COMMENTS:                                                ===A C==                                                            == A C==   AFTER A CALL TO BTD, "NSIG" > "NCH" IMPLIES A LOSS OF    ===A C==   SIGNIFICANT DIGITS IN THE CONVERSION.                    ==RA C==                                                            ===A C==   IF "NUMB" EQUALS ZERO, THEN THE ENTIRE FIELD OF "NCH"    ==TA C==   CHARACTERS IN "CH" WILL CONSIST OF "FILL" CHARACTERS.    ===A C==                                                            ==EA C=================================================================A C================================================================ A CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC 6       LOGICAL*1 CH(1),FILL,NFIRST,MINUS,ADD1,DIGIT(10)       DATA MINUS/'-'/,5      * DIGIT/'0','1','2','3','4','5','6','7','8','9'/T       INUMB=IABS(NUMB)A C================================================================OA C==   HANDLE THE SPECIAL CASE WHEN "NUMB"= -2**31 = -2147483648== A C==   WHICH IS THE LARGEST NEGATIVE 2'S COMPLEMENT INTEGER     ==EA C==   THAT CAN BE STORED IN 32 BITS.                           ===A C==   THIS CASE IS INDICATED WHEN IABS(NUMB) IS NEGATIVE, I.E. ===A C==   WHEN ADD1=INUMB.LT.0 IS .TRUE.                           == A C==   IN THIS CASE WE INITIALLY SET INUMB=IABS(NUMB+1) WHICH IS==/A C==   EQUAL TO |-2147483647| = 2147483647 AND THEN CONVERT     ==tA C==   INUMB=2147483647 TO CHARACTERS. AFTER THE CONVERSION WE  ==rA C==   THEN CHANGE THE LAST CHARACTER FROM "7" TO "8" = DIGIT(9).= A C================================================================        ADD1=INUMB.LT.0u        IF(ADD1)INUMB=IABS(NUMB+1)A C================================================================ A C==   USING INUMB2=INUMB DETERMINE "NSIG", THE NUMBER OF       == A C==   SIGNIFICANT DIGITS IN NUMB, BY REPEATEDLY DIVIDING INUMB2== A C==   BY 10 UNTIL IT EQUALS 0. NSIG = THEN NUMBER OF           ==IA C==   SIGNIFCANT DIGITS PLUS ONE IF NUMB IS NEGATIVE.          ==EA C================================================================I       INUMB2=INUMB       NSIG=0       IF(NUMB.LT.0)NSIG=1B 10    IF(INUMB2.EQ.0)GO TO 20        NSIG=NSIG+1E       INUMB2=INUMB2/10       GO TO 10A C================================================================HA C==   NCHAR IS THE NUMBER OF CHARACTERS TO BE PLACED IN "CH".  ==NA C================================================================  20    NCHAR=NCHR       IF(NCH.LE.0)NCHAR=NSIG       IF(NCHAR.GT.12)NCHAR=12SA C================================================================ A C==   NFIRST IS A FLAG WHICH IS SET TO .TRUE. AS SOON AS INUMB ==YA C==   BECOMES ZERO IN THE FOLLOWING DO LOOP.                   ==EA C================================================================        NFIRST=.FALSE.A C================================================================RA C==   THE FOLLOWING DO LOOP EXTRACTS THE DIGITS FROM INUMB     ==CA C==   ONE BY ONE MOVING RIGHT TO LEFT BY FIRST TAKING          ==UA C==   MOD(INUMB,10), WHICH IS THE RIGHT MOST DIGIT OF INUMB,   ==iA C==   AND SECONDLY DIVIDING INUMB BY 10 WHICH SHIFTS THE NEXT  == A C==   DIGIT INTO THE RIGHT MOST POSITION IN INUMB.             ==IA C==   WHEN INUMB BECOMES 0 THEN THE LEADING CHARACTERS IN CH   ==RA C==   ARE REPLACED BY THE FILL CHARACTER AND A MINUS SIGN IF   ==RA C==   NECESSARY.                                               == A C================================================================        DO 40 I=1,NCHARr       INDEX=NCHAR-I+1C       CH(INDEX)=FILL       IF(INUMB.EQ.0)GO TO 30&       CH(INDEX)=DIGIT(MOD(INUMB,10)+1)       INUMB=INUMB/10       GO TO 40 30    IF(NFIRST)GO TO 40       NFIRST=.TRUE.EA C================================================================ A C==   HERE IS WHERE WE PLACE THE MINUS SIGN IN CH, IF NUMB < 0.==$A C================================================================D"       IF(NUMB.LT.0)CH(INDEX)=MINUS 40    CONTINUEA C================================================================SA C==   HERE IS WHERE WE CHANGE THE LAST DIGIT IN CH FROM "7" TO ==FA C==   "8" FOR THE SPECIAL CASE WHEN ADD1=.TRUE., I.E. WHEN     ==LA C==   NUMB = -2**31 = -2147483648 (SEE ABOVE).                 == A C================================================================F        IF(ADD1)CH(NCHAR)=DIGIT(9)       IF(NCH.GT.12)RETURN1       RETURN	       ENDC'       SUBROUTINE MOVEC(NUM,STR1,STR2,*)T CE C     LIBRARY-ROUTINET CS= C                                                29/JULY/1980U> C                                                C.J. KOST SIN C  E C     reqd. routines - NONET CEB C=================================================================B C=================================================================B C==   THIS SUBROUTINE IS DESIGNED TO MOVE CHARACTER STRINGS     ==B C==   FROM ONE MEMORY LOCATION TO ANOTHER. THIS ROUTINE IS      ==B C==   IDENTICAL IN ACTION TO A ROUTINE IN THE U.B.C.            ==B C==   SYSTEM LIBRARY.                                           ==B C==                                                             ==B C==   WRITTEN BY LAURENCE C. TORHSER, TRIUMF, U.B.C., MAY 1979. ==B C==   INPUT PARAMTERS: STR1(NUMB),STR2(NUMB) (L*1); NUM (I*4).  ==B C==   OUTPUT PARAMETERS:STR2(NUMB).                             ==B C==                                                             ==B C==   'STR1' IS THE CHARACTER STRING TO BE MOVED.               ==B C==   'STR2' IS THE PLACE TO WHICH THE CHARACTER STRING IS TO   ==B C==        BE MOVED.                                            ==B C==   ALTERNATE RETURN: IF, ON ENTRY, 'NUMB' <= 0, NO CHARACTERS==B C==        ARE MOVED AND A RETURN 1 IS EXECUTED.                ==B C==                                                             ==B C==   NOTE: STRINGS MAY BE MOVED IN THE SAME ARRAY, AND         ==B C==        'STR1' AND 'STR2' MAY EVEN OVERLAP. HOWEVER, SINCE   ==B C==        CHARACTERS ARE MOVED ONE AT A TIME, FROM LEFT TO     ==B C==        RIGHT, CARE MUST BE EXERCISED THAT CHARACTERS TO BE  ==B C==        MOVED ARE NOT REPLACED BEFORE BEING MOVED.           ==B C=================================================================B C=================================================================B CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC       LOGICAL*1 STR1(1),STR2(1)        IF(NUM.LE.0) RETURN1       DO 10 J=1,NUM        STR2(J)=STR1(J)  10    CONTINUE       RETURN	       END )       SUBROUTINE TRANSPARENT_MODE(ICLEAR) H C======================================================================CH C                                                                      CH C  TRANSPARENT_MODE: puts monitor 1 into transparent mode              CH C  (i.e. VT100 alpha-numeric mode as opposed to graphics alpha-numeric CH C  mode).  If "ICLEAR" = 0 then the screen is not cleared before       CH C  being put into transparent mode.  If "ICLEAR" .ne. 0 then the       CH C  screen is cleared before being put into transparent mode.           CH C                                                                      CH C  *This routine must be maintained in parallel with TRANSPARENT_MODE2 CH C                                                                      CH C  Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.              CH C                                                                      CH C  Input  Parameters: ICLEAR (I*4).                                    CH C                                                                      CH C  Modified February 6/84 by F. Jones.  The VT640 is put in graphics   CH C    mode before sending the transparent mode character CAN, since     CH C    CAN is interpreted as a checkerboard character if the terminal    CH C    is already in transparent mode.                                   CH C  Modified by F.W. Jones, August/84, to include the VT241.            CH C  Modified by F.W. Jones, Oct 7/85, to include the PT100G.            CH C  Modified by F.W. Jones, Mar 20/87, for Seiko GR-1105 terminal.      CH C  Mofified by F.W. Jones, Nov 27/87.  The code has been restructured  CH C    for clarity and easier maintenance.  All escape sequences are     CH C    now in the same form and are written without line-skipping.       CH C                                                                      CH C======================================================================C*       COMMON /PLOT_MONITOR/ IMONITOR,IOUTM       DATA IMONITOR,IOUTM/1,6/ C        CHARACTER*(*) CAN,ESC,GS6       PARAMETER(CAN=CHAR(24),ESC=CHAR(27),GS=CHAR(29)) C        ENTRY TRANSPARENT(ICLEAR)1 C4; C      IF(ICLEAR.NE.0)CALL CLEAR_PLOT     !Clear the screen    1000  FORMAT('+',A,$)    C VT640, PT100G:,       IF(IMONITOR.EQ.1.OR.IMONITOR.EQ.9)THEN          WRITE(IOUTM,1000)GS//CAN  	 C CIT467:=        ELSE IF(IMONITOR.EQ.6)THEN!         WRITE(IOUTM,1000)ESC//'2'=   C TK4107:  Terminate TEK mode.$       ELSE IF( IMONITOR .EQ. 7 )THEN#         WRITE(IOUTM,1000)ESC//'%!1'A   C VT241:  Terminate Regis mode.         ELSE IF(IMONITOR.EQ.8)THEN!         WRITE(IOUTM,1000)ESC//'\''  	 C GR1105:'!       ELSE IF(IMONITOR.EQ.12)THEN "         WRITE(IOUTM,1000)ESC//'K!'       ENDIF2 C+       RETURN	       ENDH