H         CHARACTER*1 FUNCTION READ_KEY (OPTIONS, PROMPT, ALTKEY, TIMEOUT) C 5 C                                       Henry Baragar 3 C                                       TRIUMF, UBC 1 C                                       May, 1984  C  C  reqd. KOSTL routines - none C I C======================================================================== I C=                                                                      = I C= READ_KEY                                                             = I C=                                                                      = I C= This routine gets a single key stroke from the terminal immediately. = I C= If an arrow key was hit, then READ_KEY returns as <null> with        = I C= with ALTKEY set, where:                                              = I C=              '^'     - means the up-arrow was hit;                   = I C=              'v'     - means the down-arrow was hit (NB. v not V);   = I C=              '<'     - means the left-arrow was hit;                 = I C=              '>'     - means the right-arrow was hit.                = I C=                                                                      = I C= If the 'KEYPAD' option is set, then READ_KEY returns as <null>       = I C= and ALTKEY is set to the character that you see on the KEYPAD key;   = I C= and the PF keys are returned as:                                     = I C=              'P'     - for PF1;                                      = I C=              'Q'     - for PF2;                                      = I C=              'R'     - for PF3;                                      = I C=              'S'     - for PF4.                                      = I C=                                                                      = I C= Also, if an <ESC> sequence could not be interpreted, then READ_KEY   = I C= is returned set to <ESC> and ALTKEY is returned with the character   = I C= at which interpretation was lost (I know this could cause problems   = I C= -- but if you don't like it, use the 'NOESC' option and interpret    = I C= the <ESC> sequence yourself!!)                                       = I C=                                                                      = I C= If the 'TIMEOUT' option is set, then if there is no character        = I C= typed within the TIMEOUT period then both READ_KEY and ALTKEY        = I C= return as <null>.                                                    = I C=                                                                      = I C= N.B. To get the opposite effect of an option, don't mention it.      = I C=      ie. the defaults are the opposite of the options available.     = I C=      eg. the default is that READ_KEY tries to interperate <ESC>     = I C=          sequences, and if it recognizes it, READ_KEY is returned    = I C=          as null, and ALTKEY contains a single character symbolic    = I C=          representation of the key (eg. for down-arrow ALTKEY='v').  = I C=                                                                      = I C= CALL:                                                                = I C=      KEY = READ_KEY (OPTIONS,PROMPT,ALTKEY[,[TIMEOUT]])              = I C=                                                                      = I C= INPUT:                                                               = I C=      OPTIONS  (Ch*(*)) - a list of options where:                    = I C=              option  / min abbrev  - description                     = I C=              -----------------------------------------------         = I C=              'ECHO' /'EC'    - echo the character read in;           = I C=              'KEYPAD' /'K'   - means turn the keypad on;             = I C=              'NOKEYPAD' /'NOK' - means turn the keypad off;          = I C=              'LC2UC' /'LC'   - translate all lower to upper case;    = I C=              'NOCTRL' /'NOC' - echo all alphanumerics;               = I C=              'NOESC' /'NOE'  - means don't try to interpret ESC      = I C=                                sequences;                            = I C=              'PROMPT' /'PR'  - write PROMPT before reading;          = I C=              'PURGE' /'PU'   - purge the type ahead buffer before    = I C=                                reading;                              = I C=              'TIMEOUT' /'TI' - if TIMEOUT seconds have elapsed       = I C=                                with out the user hitting a key:      = I C=                                READ_KEY=<null>, ALTKEY=<null>;       = I C=      ALTKEY  (Ch*1) - if READ_KEY is returns as <null>, then ALTKEY  = I C=              returns with a symbolic representation of the key hit:  = I C=              see above for symbolic values returned;                 = I C=      PROMPT (Ch*(*)) - the prompt to be written before reading       = I C=              the key (required even if no 'PROMPT' is mentioned);    = I C=      TIMEOUT (I*4)  - (optional) the number of seconds to wait       = I C=              before returning to the caller if the user has not      = I C=              hit a key.                                              = I C=                                                                      = I C= OUTPUT:                                                              = I C=      READ_KEY  (Ch*1) - the key that was hit, unless an <ESC>        = I C=              sequence was invoked and interpretted in which case     = I C=              it is <null>;                                           = I C=      ALTKEY  (Ch*1) - if READ_KEY=<null>, then ALTKEY returns with   = I C=              the symboic key (see above); else if READ_KEY=<ESC>     = I C=              and 'NOESC' was not invoked then ALTKEY returns with    = I C=              the character on which this routine choked; else ALTKEY = I C=              returns as <null>.                                      = I C=                                                                      = I C= EXAMPLES:                                                            = I C=              CHARACTER*1 KEY,ALTKEY,READ_KEY                         = I C=              KEY = READ_KEY (' ',' ',ALTKEY)                         = I C=                      !doesn't echo, translates the arrow keys, but   = I C=                      !does not translate the keypad keys (except     = I C=                      !for the PF keys).                              = I C=              KEY = READ_KEY ('PROMPT KEYPAD','Enter: ',ALTKEY)       = I C=                      !doesn't echo, translate both arrows and keypad = I C=                      !keys, and displays the prompt "Enter: " before = I C=                      !reading.                                       = I C=              KEY = READ_KEY ('PR K','Enter: ',ALTKEY)                = I C=                      !same as previous example.                      = H C=              KEY = READ_KEY ('TIMEOUT',' ',ALTKEY,45)               =I C=                      !doesn't echo, translates only arrows and PFs,  = I C=                      !and returns after 45 seconds if there has been = I C=                      !no imput.                                      = I C=                                                                      = I C= NOTES:                                                               = I C=          1)  For more detailed, though less lucid, information,      = I C=              refer to the "VAX/VMS I/O user's Guide (Volume 1)",     = I C=              section 9.4.                                            = I C=                                                                      = A C  Modified Apr 18/88 by F.W. Jones: channel assigned to terminal 3 C  placed in common block for use by VST_CROSSHAIR. I C========================================================================  C             IMPLICIT INTEGER*4 (A-Z)   	COMMON/READ_KEY/CHAN   !         CHARACTER*1 NULL, CR, ESC ;         PARAMETER (NULL=CHAR(0), CR=CHAR(13), ESC=CHAR(27))          PARAMETER LENRK = 1 &         PARAMETER IO$_READPROMPT='37'X:         PARAMETER IO$M_NOECHO='40'X,  IO$M_NOFILTR='200'X,8      +            IO$M_CVTLOW='100'X, IO$M_PURGE='800'X,"      +            IO$M_TIMED='80'X         CHARACTER*(*) OPTIONS          CHARACTER*1 ALTKEY         CHARACTER*(*) PROMPT  (         EXTERNAL SS$_NORMAL, SS$_TIMEOUT C   D C  Make sure that we have a channel (maybe one from a previous call) C            IF (CHAN .EQ. 0) THEN -             ISTAT = SYS$ASSIGN ('TT:',CHAN,,) G             IF (ISTAT.NE.%LOC(SS$_NORMAL)) CALL LIB$SIGNAL(%VAL(ISTAT)) 
         ENDIF  C    C  Set the options up: C   /         OPTS = IOR(IO$_READPROMPT,IO$M_NOFILTR) D         IF (INDEX(OPTIONS,'EC') .EQ. 0) OPTS = IOR(OPTS,IO$M_NOECHO)H         IF (INDEX(OPTIONS,'K') .NE. 0) WRITE(6,62) ESC   !Turn keypad onI         IF (INDEX(OPTIONS,'NOK') .NE. 0) WRITE(6,61) ESC !Turn keypad off D         IF (INDEX(OPTIONS,'LC') .NE. 0) OPTS = IOR(OPTS,IO$M_CVTLOW)C         IF (INDEX(OPTIONS,'PU') .NE. 0) OPTS = IOR(OPTS,IO$M_PURGE) ,         IF (INDEX(OPTIONS,'TI') .EQ. 0) THEN             WAIT = 0         ELSE'             OPTS = IOR(OPTS,IO$M_TIMED)              WAIT = TIMEOUT
         ENDIF  C   * C  Read the key; with or without a prompt. C            READ_KEY = NULL ,         IF (INDEX(OPTIONS,'PR') .EQ. 0) THEN             LENPR = 0 >             ISTAT = SYS$QIOW (, %VAL(CHAN), %VAL(OPTS), , , , ;      +          %REF(READ_KEY), %VAL(LENRK), %VAL(WAIT), ,  '      +          %REF(' '), %VAL(LENPR))          ELSE             LENPR = LEN(PROMPT) >             ISTAT = SYS$QIOW (, %VAL(CHAN), %VAL(OPTS), , , , ;      +          %REF(READ_KEY), %VAL(LENRK), %VAL(WAIT), ,  *      +          %REF(PROMPT), %VAL(LENPR))
         ENDIF -         IF (ISTAT .EQ.%LOC(SS$_TIMEOUT)) THEN              READ_KEY = NULL              ALTKEY = NULL              RETURN
         ENDIF E         IF (ISTAT .NE. %LOC(SS$_NORMAL)) CALL LIB$SIGNAL(%VAL(ISTAT))  C   H C  Now echo if 'NOCTRL' was set, and try to interpret the <ESC> sequence C  in 'NOESC' was not set. C   1         IF (INDEX(OPTIONS,'NOC') .NE. 0    .AND.  1      +           ICHAR(READ_KEY) .GE. ICHAR(' ')) !      +      WRITE (6,60) READ_KEY -         IF (INDEX(OPTIONS,'NOE') .EQ. 0) THEN -             OPTS = IAND(OPTS,NOT(IO$M_PURGE)) .             OPTS = IAND(OPTS,NOT(IO$M_CVTLOW))'             IF (READ_KEY .EQ. ESC) THEN                  LENPR = 0 B                 ISTAT = SYS$QIOW (, %VAL(CHAN), %VAL(OPTS), , , , A      +                  %REF(ALTKEY), %VAL(LENRK), %VAL(WAIT), ,  /      +                  %REF(' '), %VAL(LENPR)) )                 IF (ALTKEY .EQ. '[') THEN F                     ISTAT = SYS$QIOW (, %VAL(CHAN), %VAL(OPTS), , , , A      +                  %REF(ALTKEY), %VAL(LENRK), %VAL(WAIT), ,  /      +                  %REF(' '), %VAL(LENPR))  C   & C  We think an arrow key has been hit. C   -                     IF (ALTKEY .EQ. 'A') THEN $                         ALTKEY = '^''                         READ_KEY = NULL 2                     ELSE IF (ALTKEY .EQ. 'B') THEN$                         ALTKEY = 'v''                         READ_KEY = NULL 2                     ELSE IF (ALTKEY .EQ. 'C') THEN$                         ALTKEY = '>''                         READ_KEY = NULL 2                     ELSE IF (ALTKEY .EQ. 'D') THEN$                         ALTKEY = '<''                         READ_KEY = NULL                      ENDIF .                 ELSE IF (ALTKEY .EQ. 'O') THENF                     ISTAT = SYS$QIOW (, %VAL(CHAN), %VAL(OPTS), , , , A      +                  %REF(ALTKEY), %VAL(LENRK), %VAL(WAIT), ,  /      +                  %REF(' '), %VAL(LENPR))  C   & C  We think a keypad key has been hit. C   <                     IF (ICHAR(ALTKEY) .GE. ICHAR('p') .AND. C      +                          ICHAR(ALTKEY) .LE. ICHAR('y')) THEN &                         ALTKEY = CHAR(H      +                          ICHAR(ALTKEY) - ICHAR('p') + ICHAR('0'))'                         READ_KEY = NULL 2                     ELSE IF (ALTKEY .EQ. 'l') THEN$                         ALTKEY = ',''                         READ_KEY = NULL 2                     ELSE IF (ALTKEY .EQ. 'm') THEN$                         ALTKEY = '-''                         READ_KEY = NULL 2                     ELSE IF (ALTKEY .EQ. 'n') THEN$                         ALTKEY = '.''                         READ_KEY = NULL 2                     ELSE IF (ALTKEY .EQ. 'M') THEN#                         ALTKEY = CR '                         READ_KEY = NULL A                     ELSE IF (ICHAR(ALTKEY) .GE. ICHAR('P') .AND.  C      +                          ICHAR(ALTKEY) .LE. ICHAR('S')) THEN '                         READ_KEY = NULL                      ENDIF                  ENDIF              ELSE                 ALTKEY = NULL              ENDIF  C   F C  If we get to here, we're not suppose to know about <ESC> sequences. C            ELSE             ALTKEY = NULL          ENDIF            RETURN C    C  FORMAT statments. C       60   FORMAT('+',A,$)     61   FORMAT('+',A,'>',$)     62   FORMAT('+',A,'=',$)          END 