H C======================================================================CH C                                                                      CH C  READPLOT.FOR                                                        CH C                                                                      CH C  Support routines for reading from and writing to the VT640          CH C  bitmap, & for dumping the bitmap to the Printronix printer.         CH C  These routines are used by PX, PX650 utilities.                     CH C                                                                      CH C  NOTE: WRITE_BITMAP_PX has been removed to its own source file.      CH C                                                                      CH C======================================================================C  2       SUBROUTINE READ_PLOT(DEVICE,ARRAY,LEN,ERROR) C 8 C  reqd. KOSTL: routines - BTD,LSWAP.MAR,MOVEC,READNOECHB C  the following are in READNOECH - ASSIGN_DEVICE,DEASSIGN_DEVICE,0 C                                 - WRITE_DIRECT C G C====================================================================== G C====================================================================== G C==                                                                  == G C==   READ_PLOT: reads the bitmap from the VT640 terminal which has  == G C==              the logical name "DEVICE" (eg. 'TT' or '_TTA1:').   == G C==              The bitmap is stored in the 2-dimensional array:    == G C==              ARRAY(128,480) as 480 dot lines of 128 5-bit        ==G C==              characters (See the VT640 graphics manual for more  == G C==              details on how the screen raster image is stored).  == G C==              LEN(480) is an array of lengths (in bytes) of each  == G C==              dot line. The first line of ARRAY, ARRAY(128,1)     == G C==              corresponds to the top dot line on the screen.      == G C==              If ERROR is returned as .TRUE. then an error has    == G C==              occured in reading the bitmap from the screen.      == G C==                                                                  == G C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        == G C==                                                                  ==}G C==   Input  Parameters: DEVICE (CHARACTER*(*)).                     == G C==                                                                  == G C==   Output Parameters: ARRAY(128,480) (L*1); LEN(480) (I*4);       == G C==                      ERROR (L*4).                                == G C==                                                                  == G C====================================================================== G C======================================================================        CHARACTER*(*) DEVICE1       LOGICAL*1 ARRAY(128,480),BUFFER(9),ARR(129)        INTEGER LEN(480)       LOGICAL ERROR C       LOGICAL*1 OUT1(13)/'+',Z1B,'"','0',';',3*'0',';','1','2','8',       *                   'c'/ $       LOGICAL*1 GRAPHICS(2)/'+',Z1D/       INTEGER*2 CHANNEL G C====================================================================== G C==   Assign the DEVICE to the CHANNEL.                              == G C====================================================================== .       CALL ASSIGN_DEVICE(DEVICE,CHANNEL,ERROR)       IF(ERROR)RETURN G C====================================================================== G C==   Write out the control sequence which puts the VT640 in graphics==DG C==   mode.                                                          == G C====================================================================== 1       CALL WRITE_DIRECT(CHANNEL,GRAPHICS,2,ERROR)        IF(ERROR)RETURN        DO 100 L=1,480(       CALL BTD(480-L,OUT1(6),3,NSIG,'0')G C====================================================================== G C==   Write out the control sequence which causes the VT640 to send  == G C==   back to the host computer the L'th dot line from the top of the== G C==   screen.                                                        == G C====================================================================== .       CALL WRITE_DIRECT(CHANNEL,OUT1,13,ERROR)       IF(ERROR)RETURN G C====================================================================== G C==   Read the L'th dot line without echoing it on the terminal.     == G C====================================================================== 5       CALL READ_NO_ECHO(CHANNEL,ARR,LEN(L),129,ERROR)        IF(ERROR)RETURN G C======================================================================EG C==   Store the LEN(L) characters of the L'th dot line at the        == G C==   array location ARRAY(1,L).                                     == G C====================================================================== '       CALL MOVEC(LEN(L),ARR,ARRAY(1,L))  100   CONTINUEG C====================================================================== G C==   Deassign the DEVICE from the CHANNEL.                          == G C======================================================================.)       CALL DEASSIGN_DEVICE(CHANNEL,ERROR)       RETURN	       END0+       SUBROUTINE WRITE_PLOT(IOUT,ARRAY,LEN)hG C======================================================================&G C======================================================================IG C==                                                                  ==iG C==   WRITE_PLOT: writes the bitmap stored in the 2-dimensional array==&G C==               ARRAY(128,480) on FORTRAN output unit IOUT.        == G C==               The bitmap is stored in the 2-dimensional array:   ==	G C==               ARRAY(128,480) as 480 dot lines of 128 5-bit       ==&G C==               characters (See the VT640 graphics manual for more ==G C==               details on how the screen raster image is stored). ==G C==               LEN(480) is an array of lengths (in bytes) of each ==G C==               dot line. The first line of ARRAY, ARRAY(128,1)    ==G C==               corresponds to the top dot line on the screen.     == G C==                                                                  == G C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        == G C==                                                                  == G C==   Input  Parameters: IOUT (I*4); ARRAY(128,480) (L*1);           == G C==                      LEN(480) (I*4);                             == G C==                                                                  == G C====================================================================== G C====================================================================== G       LOGICAL*1 ARRAY(128,480),BUFFER(133)/'+',Z1D,Z1B,'+',128*' ','#'/        INTEGER LEN(480)       LOGICAL*1 ADDRESS(3)G C====================================================================== G C==   Write out the control sequence which puts the VT640 in graphics== G C==   mode.                                                          == G C======================================================================        WRITE(IOUT,10)'1D'X  10    FORMAT('+',255A1)        DO 100 L=1,480(       CALL BTD(480-L,ADDRESS,3,NSIG,'0')G C====================================================================== G C==   Write out the L'th dot line at the L'th address from the top   == G C==   of the screen.                                                 == G C====================================================================== 5       WRITE(IOUT,10)'1B'X,'"','0',';',ADDRESS,';','a' ?       WRITE(IOUT,10)'1D'X,'1B'X,'+',(ARRAY(I,L),I=1,LEN(L)),'#'  100   CONTINUE       RETURN	       END 3       SUBROUTINE WRITE_VT640_PXPLOT(IOUT,ARRAY,LEN) G C====================================================================== G C====================================================================== G C==                                                                  == G C==   WRITE_VT640_PXPLOT: writes the bitmap stored in the            == G C==               2-dimensional array ARRAY(128,480) on FORTRAN unit == G C==               IOUT in the format required to be printed on the   == G C==               printronix.                                        == G C==               The bitmap is stored in the 2-dimensional array:   == G C==               ARRAY(128,480) as 480 dot lines of 128 5-bit       == G C==               characters (See the VT640 graphics manual for more == G C==               details on how the screen raster image is stored). == G C==               LEN(480) is an array of lengths (in bytes) of each == G C==               dot line. The first line of ARRAY, ARRAY(128,1)    == G C==               corresponds to the top dot line on the screen, and == G C==               will be printed as the first dot line on the       == G C==               printronix.                                        == G C==               Note: IOUT can be assigned directly to the         == G C==               printronix or it can be assigned to a file which   == G C==               can then be printed on the printonix.              == G C==                                                                  == G C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        == G C==                                                                  == G C     Modified July 12/83 by F. Jones for unformatted output:         C G C     If IOUT is assigned to a file which is to be printed later,     C G C     processing is speeded up considerably by unformatted writes     C G C     into the file.  To take advantage of this, open unit IOUT       C G C     with FORM='UNFORMATTED' and CARRIAGECONTROL='LIST'.             C G C     The logical variable FMTED in COMMON/SPOOL/ should be           C G C     set to .FALSE. by the calling program.  The default for         C G C     FMTED is .TRUE. (formatted output as before).                   C G C                                                                     C G C==   Input  Parameters: IOUT (I*4); ARRAY(128,480) (L*1);           == G C==                      LEN(480) (I*4);                             == G C==                                                                  == G C====================================================================== G C====================================================================== 8       LOGICAL*1 ARRAY(128,480),LINE(108),NFIRST,ARR(128)       INTEGER LEN(480)9       LOGICAL*1 CTRL_E/Z05/,LSWAP,LI1,LI2,LI3,LI4,LI5,LI6 !       DATA I1,I2,I3,I4,I5,I6/6*0/ G       EQUIVALENCE (LI1,I1),(LI2,I2),(LI3,I3),(LI4,I4),(LI5,I5),(LI6,I6)        LOGICAL FMTED/.TRUE./        COMMON/SPOOL/FMTED       DO 200 J=1,480       NARR=0	       L=0  50    L=L+1        IF(L.GT.LEN(J))GO TO 70 #       IF(ARRAY(L,J).EQ.'$')GO TO 60        NARR=NARR+1        ARR(NARR)=ARRAY(L,J)       GO TO 50 60    NZERO=ARRAY(L+1,J)       NZERO=MOD(NZERO,64)         DO 65 NA=NARR+1,NARR+NZERO       ARR(NA)=0  65    CONTINUE       NARR=NARR+NZERO        L=L+1        GO TO 50       70    DO 100 I=1,21        IARR=(I-1)*6       ILIN=(I-1)*5       LI1=LSWAP(ARR(IARR+1))       LI2=LSWAP(ARR(IARR+2))       LI3=LSWAP(ARR(IARR+3))       LI4=LSWAP(ARR(IARR+4))       LI5=LSWAP(ARR(IARR+5))       LI6=LSWAP(ARR(IARR+6))
       I1=I1/8 
       I2=I2/8 
       I3=I3/8 
       I4=I4/8 
       I5=I5/8 
       I6=I6/8 "       LINE(ILIN+1)=I1+32*MOD(I2,2)$       LINE(ILIN+2)=I2/2+16*MOD(I3,4)#       LINE(ILIN+3)=I3/4+8*MOD(I4,8) $       LINE(ILIN+4)=I4/8+4*MOD(I5,16)       LINE(ILIN+5)=I5/16+2*I6  100   CONTINUE
       I=22       IARR=(I-1)*6       ILIN=(I-1)*5       LI1=LSWAP(ARR(IARR+1))       LI2=LSWAP(ARR(IARR+2))
       I1=I1/8 
       I2=I2/8 "       LINE(ILIN+1)=I1+32*MOD(I2,2)       LINE(ILIN+2)=I2/2 
       ILAST=1        NFIRST=.FALSE.       DO 150 I=107,1,-1        IF(LINE(I).EQ.0)GO TO 120        IF(NFIRST)GO TO 120        NFIRST=.TRUE.        ILAST=I+1 ) 120   IF(LINE(I).LT.32)LINE(I)=LINE(I)+64  150   CONTINUE       LINE(ILAST)=CTRL_E1       IF(FMTED)WRITE(IOUT,160)(LINE(I),I=1,ILAST)  160   FORMAT(1X,255A1)2       IF(.NOT.FMTED)WRITE(IOUT)(LINE(I),I=1,ILAST) 200   CONTINUE       RETURN	       END 