 C== RDPLOT650.FOR  C F C==Modifications of READPLOT.FOR routines for the Retro-Graphics DQ650 C 6       SUBROUTINE READ_PLOT_650(DEVICE,ARRAY,LEN,ERROR) C * C  reqd. KOSTL: routines - MOVEC,READNOECHB C  the following are in READNOECH - ASSIGN_DEVICE,DEASSIGN_DEVICE,0 C                                 - WRITE_DIRECT C H C======================================================================CH C  READ_PLOT_650                                    F.W. Jones,TRUIMF  CH C                                                                      CH C  Reads the graphics screen bitmap from the DQ650 terminal with       CH C  logical name DEVICE (e.g. 'TT:').                                   CH C                                                                      CH C  NOTE: The DQ650 must be in 4027 mode!                               CH C                                                                      CH C  The bitmap is read line by line, from the bottom of the graphics    CH C  region to the top, into ARRAY.  Six pixels are stored in each byte, CH C  in the low-order six bits. Since the data may contain repetition    CH C  factors, the length in bytes of each line is stored in array        CH C  LEN.  The end of the data (when we have reached the top of the      CH C  graphics region) is indicated by setting LEN(L)=0.                  CH C======================================================================C C        CHARACTER*(*) DEVICE(       LOGICAL*1 ARRAY(134,480),LINE(134)       INTEGER LEN(480)       LOGICAL ERROR ;       LOGICAL*1 VEC(9)/'+','!','V','E','C',' ','0',',','0'/ ;       LOGICAL*1 REA(9)/'+','!','R','E','A',' ','8','0','0'/        INTEGER*2 CHANNEL  C B C==Assign the DEVICE to the CHANNEL.                              .       CALL ASSIGN_DEVICE(DEVICE,CHANNEL,ERROR)       IF(ERROR)RETURN  C D C==Move the graphics beam to the l.l. corner of the graphics region.,       CALL WRITE_DIRECT(CHANNEL,VEC,9,ERROR)       IF(ERROR)RETURN  C        DO 100 L=1,480 C / C==Read 800 pixels (134 bytes) from the screen: ,       CALL WRITE_DIRECT(CHANNEL,REA,9,ERROR)       IF(ERROR)RETURN 6       CALL READ_NO_ECHO(CHANNEL,LINE,LEN(L),134,ERROR)       IF(ERROR)RETURN  C , C==Are we at the end of the graphics region?       IF(LEN(L).LE.4)THEN , C====Tag for end of usable portion of ARRAY:         LEN(L)=0         GO TO 110        ENDIF  C ( C==Move the LEN(L) bytes into ARRAY( ,L)(       CALL MOVEC(LEN(L),LINE,ARRAY(1,L)) C  100   CONTINUE C B C==Deassign the DEVICE from the CHANNEL.                          ) 110   CALL DEASSIGN_DEVICE(CHANNEL,ERROR)        RETURN	       END  C  C  C  C /       SUBROUTINE WRITE_PLOT_650(IOUT,ARRAY,LEN)  C H C======================================================================CH C  WRITE_PLOT_650(IOUT,ARRAY,LEN)              F.W. Jones, TRIUMF      CH C                                                                      CH C  Writes the DQ650 bitmap stored in ARRAY onto logical unit IOUT.     CH C                                                                      CH C  NOTE: The DQ650 terminal assigned to IOUT must be in 4027 mode!     CH C                                                                      CH C  The Lth line of the bitmap (from the bottom of the graphics         CH C  region) is stored in ARRAY(1-134,L), and its length in bytes is     CH C  given by LEN(L).  The end of the data is indicated by LEN(L)=0.     CH C======================================================================C C        LOGICAL*1 ARRAY(134,480)       INTEGER LEN(480)       LOGICAL*1 CHAR,CHAR1 C 2 C==Y Coordinate of initial graphics beam position:
       IBEAM=0  C        DO 20 L=1,480        IF(LEN(L).EQ.0)GO TO 99 % C==Move the beam to the current line:        WRITE(IOUT,100)IBEAM 100   FORMAT(' !VEC 0,',I3)  C 8 C==Write out the current line of 800 pixels (134 bytes):A C==The line must be split into 2 segments if it exceeds 74 bytes.  C        IF(LEN(L).LE.74)THEN.         WRITE(IOUT,444)(ARRAY(K,L),K=1,LEN(L))         GO TO 19       ENDIF  444   FORMAT(' !RAS ',74A1)  CM0 C==Terminate the first segment at location KCUT:
       KCUT=740+ C==Make sure a rep. factor is not split up.R 10    CHAR=ARRAY(KCUT,L)       CHAR1=ARRAY(KCUT-1,L)A?       IF((CHAR.GE.'?'.AND.CHAR1.NE.'(').OR.CHAR.EQ.')')GO TO 11N       KCUT=KCUT-1        GO TO 10* 11    WRITE(IOUT,444)(ARRAY(K,L),K=1,KCUT)1       WRITE(IOUT,444)(ARRAY(K,L),K=KCUT+1,LEN(L))= CC 19    IBEAM=IBEAM+1  20    CONTINUE C  99    RETURN	       ENDU C  C  C  C 3       SUBROUTINE WRITE_DQ650_PXPLOT(IOUT,ARRAY,LEN)  C H C======================================================================CH C  WRITE_DQ650_PXPLOT                             F.W. Jones, TRIUMF   CH C                                                                      CH C  Writes the DQ650 bitmap ARRAY onto logical unit IOUT in             CH C  Printronix format.  IOUT may be assigned directly to a Printronix   CH C  printer or to a file to be printed later.  Since the DQ650          CH C  bitmap may contain repetition factors, the length in bytes of       CH C  each line ARRAY(-,J) is stored in LEN(J).  LEN(J)=0 indicates       CH C  the end of the data.                                                CH C                                                                      CH C  The DQ650 resolution is 800 pixels per line, while the              CH C  Printronix resolution is 792 dots per line, so the last 8 pixels    CH C  of each line will not be printed.                                   CH C======================================================================C C'-       LOGICAL*1 ARRAY(134,480),LINE(134),CHARI       INTEGER LEN(480)A       LOGICAL*1 N63/63/,N64/64/,N127/127/,N48/48/,N57/57/,LP/'('/        LOGICAL*1 CTRL_E/Z05/  C ; C==Find the end of the bitmap (top of the graphics region):E       DO 10 J=1,480R       IF(LEN(J).EQ.0)GO TO 20p 10    CONTINUE       J=481o
 20    LIM=J-1r Co       DO 200 J=LIM,1,-1CH C======================================================================CH C  Get the Jth line of data and expand it into LINE:                   CH C======================================================================C	       N=0E	       L=0, 50    L=L+1        IF(L.GT.LEN(J))GO TO 70  Ct$ C==Examine the Lth byte of the line:       CHAR=ARRAY(L,J)= CT$ C==Fix up "?" which should be <DEL>:       IF(CHAR.EQ.N63)CHAR=N127 C1*       IF(N64.LE.CHAR.AND.CHAR.LE.N127)THEN
         N=N+1,         LINE(N)=CHAR               GO TO 50       ENDIFT CE-       IF(N48.LE.CHAR.AND.CHAR.LE.N57)GO TO 53  C  C==Illegal character       WRITE(6,111)CHAR,J,L, 111   FORMAT(' Illegal character: "',A1,'"',)      # '  at line ',I5,'   position ',I5)(       RETURN C " C==Loop to establish repeat count: 53    ICOUNT=CHAR-N48= 55    L=L+1=       CHAR=ARRAY(L,J)O       IF(CHAR.EQ.LP)GO TO 60#       ICOUNT=ICOUNT*10 + (CHAR-N48)        GO TO 55 60    L=L+1        CHAR=ARRAY(L,J)  CC0 C==Stuff the required # of characters into LINE:       DO 65 I=1,ICOUNT       N=N+1        LINE(N)=CHAR 65    CONTINUE C  C==Skip the right parenthesis:       L=L+1i       GO TO 50 C = C==Terminate the 132 usable bytes of LINE with the Printronix  C==PLOT MODE code: 70    LINE(133)=CTRL_E C==Write out the line:&       WRITE(IOUT,160)(LINE(I),I=1,133) 160   FORMAT(' ',133A1)d C  200   CONTINUE C  99    RETURN	       END 