7       SUBROUTINE READLD2(LINE,LEN,FIELDS,ITYPEI,NFIELD)  C   4 C     reqd. KOSTL: routines - CHREAL,FINDC,IGC,MOVECG C====================================================================== G C==   Purpose:  Reads free-formatted fields in LINE and returns with == G C==             type of each field (integer or floating point, or    == G C==             character string) and each field's value.            == G C==                                                                  == G C==                                                                  == G C==   Input  Parameters:  LINE(LEN)       (LOGICAL*1)                == G C==                       ITYPE(NFIELD)   (INTEGER*4)                == G C==                       NFIELD          (INTEGER*4)                == G C==                                                                  == G C==   Output Parameters:  FIELDS(132)     (REAL*8)                   == G C==                       NFIELD          (INTEGER*4)                == G C==                                                                  == G C==   Substantially revised by Alan Carruthers, TRIUMF, U.B.C.,      == G C==   from an earlier anonymous version.                             == G C==   Revised June 27, 1982.                                         == G C==   Revised  feb 5 , 1985. by C.J. KOST for arbitrary line length  == G C==                  and have ITYPE meaningful on input i.e.         == G C==           ITYPE(i)=0 interpret field # i    as F.P. else string  == G C==           ITYPE(i)=2 interpret field # i    as F.P. else string  == G C==           ITYPE(i)=1 interpret field # i    as string            == G C==               Strings default to blank, F.P. numbers to 0.       == G C==   Parameters:                                                    == G C==   ----------                                                     == G C==                                                                  == G C==   LINE   : Input buffer (length LEN) which is scanned for        == G C==            free-format input fields.  The fields of the input    == G C==            buffer must be separated by blank(s) or a comma.      == G C==            Input fields are interpreted as either numeric        == G C==            (integer or floating point) or character string.      == G C==            Null fields occur whenever two commas in the input    == G C==            buffer are adjacent or separated by only blanks.      == G C==                                                                  == G C==   NFIELD : On entry, NFIELD specifies the maximum number of      == G C==            fields to be examined (0 < NFIELD).                   == G C==            On exit, NFIELD contains the number of fields found   == G C==            in LINE (this returned value will not exceed the      == G C==            the value of NFIELD supplied on entry).               == G C==                                                                  == G C==            Note: DO NOT call this routine with the actual        == G C==                  argument of NFIELD set to an integer constant   == G C==                  -- use an INTEGER variable for NFIELD!          == G C==                                                                  == G C==   ITYPE  : ITYPE(i) indicates the type of the i'th field found   == G C==            in LINE (for i < = NFIELD).  The field types are      == G C==            returned as:                                          == G C==              0  --  null field                                   == G C==              1  --  character string field                       == G C==              2  --  integer or floating point field              == G C==                                                                  == G C==   FIELDS : FIELD(i) returns the value of the i'th field found    == G C==            in LINE (for i < = NFIELD).  The value returned       == G C==            depends on the type of field as follows:              == G C==                                                                  ==EG C==            ITYPE   FIELDS                                        ==eG C==            -----   -----------------------------------------     ===G C==              0     returned as 0.0 if ITYPE =0 or 2 on input     ==nG C==              0     returned as blank if ITYPE = 1 on input       ==rG C==              1     first EIGHT characters of character string    ==eG C==                    (if field contains less than EIGHT            == G C==                    characters, string is left justified and      == G C==                    blank filled on right)                        ==GG C==              2     floating point number                         ==TG C==            -----   -----------------------------------------     ==TG C==                                                                  == G C==            Note: Since FIELD(i) is a REAL*8 array element,       ==AG C==                  a "trick" is needed to interpret it properly    ==TG C==                  when ITYPE(i) = 1.  Suppose the actual argument == G C==                  for FIELDS in the calling routine is array X.   ==sG C==                  Then put                                        == G C==                     REAL*8 X(132)                                == G C==                     CHARACTER*8 XX(132),STRING                   == G C==                     EQUIVALENCE (X(1),XX(1))                     ==lG C==                     INTEGER*4 arg3(132),arg4                     == G C==                     LOGICAL*1 arg1(132)                          == G C==                       .                                          == G C==                       .                                          ==.G C==                       .                                          == G C==                     CALL READLN(arg1,X,arg3,arg4)                == G C==                       .                                          == G C==                       .                                          ==hG C==                       .                                          == G C==                     IF(arg3(i) .EQ. 1) STRING = XX(i)            ==aG C==                   where STRING holds the first eight characters  ==sG C==                   of the i'th field in arg1 (provided arg3(i)    == G C==                   = 1).                                          == G C==                                                                  ==eG C==   Examples of input line decomposition:                          == G C==   ------------------------------------                           == G C==                                                                  ==EG C==                          NFIELDS                                 ==uG C==   Line                 entry return   ITYPE   FIELDS             ==iG C==   ------------------   ----- ------   -----   ----------------   ==nG C==   1.3 , 7   asDFty       8     3        2     1.300D00           == G C==                                         2     7.000D00           == G C==                                         1     asDFty             ==oG C==                                                                  ==lG C==   GR,T .   ,  , 4       50     5        1     GR                 == G C==                                         1     T                  == G C==                                         1     .                  ==hG C==                                         0     0.000D00           == G C==                                         2     4.000D00           == G C==                                                                  ==dG C==       , ,                6     3        0     0.000D00           ==oG C==                                         0     0.000D00           == G C==                                         0     0.000D00           ==tG C==                                                                  ==hG C==    5.43 E5               5     2        2     5.430D00           ==sG C==                                         1     E5                 == G C==   ------------------   ----- ------   -----   ----------------   == G C======================================================================-1       REAL*8  FIELDS(132), FPOINT, STRING, BLANK8r       LOGICAL*1 LINE(LEN)o       LOGICAL*1 BUFFER(132)        LOGICAL*1 LSTR(8)s"       EQUIVALENCE (LSTR(1),STRING)       DATA BLANK8/'        '/t,       LOGICAL*1 BLANK/' '/, COMMA/','/, NULL$       INTEGER ITYPEI(132),ITYPE(132)       IF(NFIELD .LE. 0) RETURN       NFMAX = NFIELD       DO 10 I = 1,NFIELD          FIELDS(I)=0. +          IF(ITYPE(I).EQ.1) FIELDS(I)=BLANK8r          ITYPE(I)=0   10   CONTINUE       NFIELD = 0       IFIND = 0u       NULL = .TRUE.  C   20   ISTART = IFIND + 1%       IF(ISTART .GT. LEN )  GO TO 500- C-G C====================================================================== G C==   Scan line for non-blank character                              ==,G C======================================================================e   C 0       CALL IGC(LINE,LEN,' ',1,ISTART,IFIND,&400) Ce%       IF(LINE(IFIND) .EQ. COMMA) THEN  C G C==         Comma found                                              ==              IF(NULL) THEN %                   NFIELD = NFIELD + 1 #                   ITYPE(NFIELD) = 0 .                   IF(ITYPEI(NFIELD).EQ.1) THEN,                        FIELDS(NFIELD)=BLANK8'                        ITYPEI(NFIELD)=0X                   END IF                ELSE                    NULL = .TRUE.r             END IF C=!        ELSE   ! Field entry found*0             NULL = .FALSE.   ! Field is not null             NFIELD = NFIELD + 1  C G C==         Now scan for delimiter of current field                  == 8             CALL FINDC(LINE,LEN,' ,',2,IFIND,IFIND2,ICH)H             IF(IFIND2 .EQ. 0) IFIND2 = LEN+1 ! Entry runs to end of LINE CLG C==         Blank out buffer                                         ==              DO 50 I = 1,132                  BUFFER(I) = BLANK  50         CONTINUE C G C==         Move string in current field into buffer                 == :             CALL MOVEC(IFIND2-IFIND,LINE(IFIND),BUFFER(1)) C G C======================================================================sG C==         Analyze buffer                                           == G C======================================================================  C G C==         Call CHREAL to try to interpret string as floating-      == G C==         point number if ITYPEI(NFIELD) .ne. 1                    == (             IF(ITYPEI(NFIELD).NE.1) THEN                    NREAL = 2<                    CALL CHREAL(BUFFER,132,FPOINT,NREAL,&200)*                    FIELDS(NFIELD) = FPOINT%                    ITYPEI(NFIELD) = 2                     GO TO 300              ENDIF C G C==         Interpret as a string (max 8 characters)                 ==-  200        CONTINUEG C==         Move up to 8 characters into fields                      == "             NCHAR = IFIND2 - IFIND&             IF(NCHAR .GT. 8) NCHAR = 8G C==         Blank out string                                         ==              DO 210 I = 1,8                LSTR(I) = BLANK  210        CONTINUE.             CALL MOVEC(NCHAR,LINE(IFIND),LSTR)#             FIELDS(NFIELD) = STRING              ITYPEI(NFIELD) = 1 C   300        IFIND = IFIND2 - 1          END IF= C %          IF(NFIELD .EQ. NFMAX) RETURN           GO TO 20  C= C G C====================================================================== G C==   No non-blank characters found                                  == G C====================================================================== 9  400  IF(ISTART .EQ. 1) RETURN   ! LINE is entirely blank  C  C G C====================================================================== G C==   LINE has been completely scanned                               == G C======================================================================   500  IF(NULL) THEN           NFIELD = NFIELD + 1       END IF       RETURN	       END 