1       SUBROUTINE READLN(LINE,FIELDS,ITYPE,NFIELD)  C   4 C     reqd. KOSTL: routines - CHREAL,FINDC,IGC,MOVECG C====================================================================== G C==   Purpose:  Reads free-formatted fields in LINE and returns with == G C==             type of each field (integer or floating point, or    == G C==             character string) and each field's value.            == G C==                                                                  == G C==   Input  Parameters:  LINE(132)       (LOGICAL*1)                == G C==                       NFIELD          (INTEGER*4)                == G C==                                                                  == G C==   Output Parameters:  FIELDS(132)     (REAL*4)                   == G C==                       ITYPE(132)      (INTEGER*4)                == G C==                       NFIELD          (INTEGER*4)                == G C==                                                                  == G C==   Substantially revised by Alan Carruthers, TRIUMF, U.B.C.,      == G C==   from an earlier anonymous version.                             == G C==   Revised June 27, 1982.                                         == G C==                                                                  == G C==   Parameters:                                                    == G C==   ----------                                                     == G C==                                                                  == G C==   LINE   : Input buffer (length 132) which is scanned for        == G C==            free-format input fields.  The fields of the input    == G C==            buffer must be separated by blank(s) or a comma.      == G C==            Input fields are interpreted as either numeric        == G C==            (integer or floating point) or character string.      == G C==            Null fields occur whenever two commas in the input    == G C==            buffer are adjacent or separated by only blanks.      == G C==                                                                  == G C==   NFIELD : On entry, NFIELD specifies the maximum number of      == G C==            fields to be examined (0 < NFIELD).                   == G C==            On exit, NFIELD contains the number of fields found   == G C==            in LINE (this returned value will not exceed the      == G C==            the value of NFIELD supplied on entry).               == G C==                                                                  == G C==            An entirely blank or empty line is interpreted to     == G C==            have 0 fields.                                        == G C==                                                                  == G C==            Note: DO NOT call this routine with the actual        == G C==                  argument of NFIELD set to an integer constant   == G C==                  -- use an INTEGER variable for NFIELD!          == G C==                                                                  == G C==   ITYPE  : ITYPE(i) indicates the type of the i'th field found   == G C==            in LINE (for i < = NFIELD).  The field types are      == G C==            returned as:                                          == G C==              0  --  null field                                   == G C==              1  --  character string field                       == G C==              2  --  integer or floating point field              == G C==                                                                  == G C==   FIELDS : FIELD(i) returns the value of the i'th field found    == G C==            in LINE (for i < = NFIELD).  The value returned       == G C==            depends on the type of field as follows:              == G C==                                                                  == G C==            ITYPE   FIELDS                                        == G C==            -----   -----------------------------------------     == G C==              0     returned as 0.0                               ==RG C==              1     first four characters of character string     ==eG C==                    (if field contains less than four             ===G C==                    characters, string is left justified and      ==nG C==                    blank filled on right)                        ==rG C==              2     floating point number                         ==eG C==            -----   -----------------------------------------     == G C==                                                                  ==GG C==            Note: Since FIELD(i) is a REAL*4 array element,       ==TG C==                  a "trick" is needed to interpret it properly    == G C==                  when ITYPE(i) = 1.  Suppose the actual argument ==AG C==                  for FIELDS in the calling routine is array X.   ==TG C==                  Then put                                        ==TG C==                     REAL*4 X(132)                                == G C==                     CHARACTER*4 XX(132),STRING                   ==sG C==                     EQUIVALENCE (X(1),XX(1))                     == G C==                     INTEGER*4 arg3(132),arg4                     == G C==                     LOGICAL*1 arg1(132)                          == G C==                       .                                          == G C==                       .                                          == G C==                       .                                          == G C==                     CALL READLN(arg1,X,arg3,arg4)                ==hG C==                       .                                          == G C==                       .                                          ==aG C==                       .                                          ==sG C==                     IF(arg3(i) .EQ. 1) STRING = XX(i)            == G C==                   where STRING holds the first four characters   == G C==                   of the i'th field in arg1 (provided arg3(i)    ==eG C==                   = 1).                                          == G C==                                                                  == G C==   Examples of input line decomposition:                          ==EG C==   ------------------------------------                           ==uG C==                                                                  ==iG C==                          NFIELDS                                 ==nG C==   Line                 entry return   ITYPE   FIELDS             == G C==   ------------------   ----- ------   -----   ----------------   ==eG C==   1.3 , 7   asDFty       8     3        2     1.300E00           == G C==                                         2     7.000E00           == G C==                                         1     asDF               == G C==                                                                  ==oG C==   GR,T .   ,  , 4       50     5        1     GR                 ==lG C==                                         1     T                  == G C==                                         1     .                  == G C==                                         0     0.000E00           ==hG C==                                         2     4.000E00           == G C==                                                                  == G C==       , ,                6     3        0     0.000E00           ==dG C==                                         0     0.000E00           ==oG C==                                         0     0.000E00           == G C==                                                                  ==tG C==    5.43 E5               5     2        2     5.430E00           ==hG C==                                         1     E5                 ==sG C==   ------------------   ----- ------   -----   ----------------   == G C======================================================================        DIMENSION FIELDS(132)=       LOGICAL*1 LINE(132)-       LOGICAL*1 BUFFER(132)-       LOGICAL*1 LSTR(4) "       EQUIVALENCE (LSTR(1),STRING),       LOGICAL*1 BLANK/' '/, COMMA/','/, NULL       INTEGER ITYPE(132)       IF(NFIELD .LE. 0) RETURN       NFMAX = NFIELD       DO 10 I = 1,NFIELD          FIELDS(I)=0.=          ITYPE(I)=0c  10   CONTINUE       NFIELD = 0       IFIND = 0=       NULL = .TRUE.b Ck  20   ISTART = IFIND + 1%       IF(ISTART .GT. 132 )  GO TO 500  CfG C======================================================================-G C==   Scan line for non-blank character                              == G C======================================================================n   CE0       CALL IGC(LINE,132,' ',1,ISTART,IFIND,&400) C %       IF(LINE(IFIND) .EQ. COMMA) THENp C G C==         Comma found                                              ==a             IF(NULL) THEN %                   NFIELD = NFIELD + 1r#                   ITYPE(NFIELD) = 0                 ELSE                    NULL = .TRUE.              END IF C #          ELSE   ! Field entry found 0             NULL = .FALSE.   ! Field is not null             NFIELD = NFIELD + 1  C=G C==         Now scan for delimiter of current field                  ===8             CALL FINDC(LINE,132,' ,',2,IFIND,IFIND2,ICH)H             IF(IFIND2 .EQ. 0) IFIND2 = 133   ! Entry runs to end of LINE C G C==         Blank out buffer                                         ==              DO 50 I = 1,132                  BUFFER(I) = BLANK  50         CONTINUE C G C==         Move string in current field into buffer                 == :             CALL MOVEC(IFIND2-IFIND,LINE(IFIND),BUFFER(1)) C G C====================================================================== G C==         Analyze buffer                                           == G C======================================================================  C G C==         Call CHREAL to try to interpret string as floating-      == G C==         point number                                             ==              NREAL = 1 5             CALL CHREAL(BUFFER,132,FPOINT,NREAL,&200) #             FIELDS(NFIELD) = FPOINT              ITYPE(NFIELD) = 2=             GO TO 300  C G C==         Interpret as a string (max 4 characters)                 ==   200        CONTINUEG C==         Move up to 4 characters into fields                      == "             NCHAR = IFIND2 - IFIND&             IF(NCHAR .GT. 4) NCHAR = 4G C==         Blank out string                                         ==              DO 210 I = 1,4                LSTR(I) = BLANK  210        CONTINUE.             CALL MOVEC(NCHAR,LINE(IFIND),LSTR)#             FIELDS(NFIELD) = STRING              ITYPE(NFIELD) = 1  C8  300        IFIND = IFIND2 - 1          END IF  C %          IF(NFIELD .EQ. NFMAX) RETURN           GO TO 20= C  C G C====================================================================== G C==   No non-blank characters found                                  == G C====================================================================== 9  400  IF(ISTART .EQ. 1) RETURN   ! LINE is entirely blank  C  C G C====================================================================== G C==   LINE has been completely scanned                               ==hG C======================================================================   500  IF(NULL) THEN           NFIELD = NFIELD + 1          ITYPE(NFIELD) = 0       END IF       RETURN	       END 