<       SUBROUTINE READ_NO_ECHO(CHANNEL,LINE,LEN,MAXLEN,ERROR) C    C     reqd. routines - NONE G C====================================================================== G C====================================================================== G C==                                                                  == G C==   READ_NO_ECHO: reads from the I/O channel number "CHANNEL",     == G C==                 assigned to a terminal, a line which has a       == G C==                 maximum of "MAXLEN" characters, without echoing  == G C==                 the characters. The actual number of characters  == G C==                 read in and returned in "LINE" is "LEN"          == G C==                 characters. Example: if the user uses this to    == G C==                 read a line of characters from his terminal then == G C==                 the characters which he types will not be echoed == G C==                 on the terminal.                                 == G C==                 Note: The I/O channel number "CHANNEL" can be    == G C==                 assigned to a terminal using the subroutine      == G C==                 "ASSIGN_DEVICE".                                 == G C==                                                                  == G C==   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.        == G C==                                                                  == G C==   Input  Parameters: CHANNEL (I*2); MAXLEN (I*4).                == G C==                                                                  == G C==   Output Parameters: LINE(MAXLEN) (L*1); LEN (I*4); ERROR (L*4). == G C==                                                                  == G C==   Parameter Definitions:                                         == G C==   --------- -----------                                          == G C==                                                                  == G C==   CHANNEL: Integer*2 I/O channel number assigned to the terminal == G C==            from which the characters are to be read without echo.== G C==                                                                  == G C==   LINE   : Input line buffer of "MAXLEN" characters in which the == G C==            "LEN" characters read from the terminal are returned. == G C==            Note: If the number of characters sent from the       == G C==            terminal is less than "MAXLEN" then "LEN" < "MAXLEN"  == G C==            and the line of characters sent from the terminal must== G C==            be terminated by a carriage return.                   == G C==            If the number of characters sent from the terminal is == G C==            greater than or equal to "MAXLEN" then "LEN" = "MAXLEN"= G C==            and no carriage return is required because READ_NO_ECHO= A C==            will automatically terminate the read at "MAXLEN"  G C==            characters. If a carriage return or more characters   == G C==            are sent from the terminal after this automatic       == G C==            termination of the read then they will be treated as  == G C==            the next input line from the terminal.                == G C==                                                                  == G C==   LEN    : Number of characters read in and returned in "LINE".  == G C==                                                                  == G C==   MAXLEN : Maximum number of characters read in and returned in  == G C==            "LINE".                                               == G C==                                                                  == G C==   ERROR  : LOGICAL flag which if .TRUE. indicates an error has   == G C==            occured in "READ_NO_ECHO". In this case an error      == G C==            message is automatically written on unit 6 by         == G C==            "READ_NO_ECHO".                                       == G C==                                                                  == G C====================================================================== G C======================================================================        LOGICAL*1 LINE(1)-       INTEGER SYS$QIOW*       INTEGER*2 CHANNEL,IO_STATUS_BLOCK(4)'       EXTERNAL IO$_READVBLK,IO$M_NOECHO=       LOGICAL ERROR=       CHARACTER*10 STATUS        LEN=0        IF(MAXLEN.LE.0)RETURN G C======================================================================nG C==   The function code for the QIO is: "read a virtual block with   ==iG C==   no echo".                                                      ==eG C==   SYS$QIOW: reads in the line.                                   ==nG C======================================================================N7       IFUNCTION=%LOC(IO$_READVBLK).OR.%LOC(IO$M_NOECHO) E       ISYS=SYS$QIOW(,%VAL(CHANNEL),%VAL(IFUNCTION),IO_STATUS_BLOCK,,,n+      *               LINE,%VAL(MAXLEN),,,,)=G C=======================================================================G C==   A SYS$QIOW error occurs if ISYS .ne. 1.                        ===G C=======================================================================       ERROR=ISYS.NE.1n       IF(ERROR)GO TO 5G C====================================================================== G C==   The number of characters read in is in IO_STATUS_BLOCK(2).     == G C======================================================================r       LEN=IO_STATUS_BLOCK(2)       RETURNG C======================================================================tG C==   On an error check the return status and write out the          == G C==   appropriate messages.                                          ==tG C====================================================================== 8 5     CALL CHECK_RETURN_STATUS(ISYS,.TRUE.,ERROR,STATUS)       IF(ERROR)WRITE(6,10)/ 10    FORMAT('   ***Error*** in READ_NO_ECHO:',-<      *       ' Failed to read from CHANNEL using SYS$QIOW.')       RETURN	       END 5       SUBROUTINE WRITE_DIRECT(CHANNEL,LINE,LEN,ERROR) G C====================================================================== G C====================================================================== G C==                                                                  == G C==   WRITE_DIRECT: writes to the I/O channel number "CHANNEL",      == G C==                 assigned to a terminal, a "LINE" which has a "LEN"= G C==                 characters, the first of which is a carriage     == G C==                 control character.                               == G C==                 If an error occurs while writing, then "ERROR" is== G C==                 returned as .TRUE. and an error message is       == G C==                 written on unit 6 by "READ_NO_ECHO".             == @ C==                                                             *       INTEGER*2 CHANNEL,IO_STATUS_BLOCK(4)       LOGICAL ERRORD+       LOGICAL*1 LINE(1),CARRIAGE_CONTROL(4) 3       INTEGER ICARRIAGE_CONTROL/Z00000000/,SYS$QIOWa9       EQUIVALENCE (CARRIAGE_CONTROL(1),ICARRIAGE_CONTROL)        EXTERNAL IO$_WRITEVBLK       CHARACTER*10 STATUS        IF(LEN.LE.0)RETURN!       CARRIAGE_CONTROL(1)=LINE(1)l#       IFUNCTION=%LOC(IO$_WRITEVBLK)tE       ISYS=SYS$QIOW(,%VAL(CHANNEL),%VAL(IFUNCTION),IO_STATUS_BLOCK,,, D      *               LINE(2),%VAL(LEN-1),,%VAL(ICARRIAGE_CONTROL),,)       ERROR=ISYS.NE.1r       IF(.NOT.ERROR)RETURN8       CALL CHECK_RETURN_STATUS(ISYS,.TRUE.,ERROR,STATUS)       IF(ERROR)WRITE(6,10)/ 10    FORMAT('   ***Error*** in WRITE_DIRECT:',i;      *       ' Failed to write on CHANNEL using SYS$QIOW.')        RETURN	       END 4       SUBROUTINE ASSIGN_DEVICE(DEVICE,CHANNEL,ERROR)       CHARACTER*(*) DEVICE       INTEGER*2 CHANNELf       INTEGER SYS$ASSIGN)       LOGICAL ERROR,WRITE_MESSAGE/.TRUE./r       CHARACTER*10 STATUSi<       CALL CHECK_RETURN_STATUS(SYS$ASSIGN(DEVICE,CHANNEL,,),:      *                         WRITE_MESSAGE,ERROR,STATUS)        IF(ERROR)WRITE(6,10)DEVICE0 10    FORMAT('   ***Error*** in ASSIGN_DEVICE:',:      *       ' Failed to assign device ',A,' to CHANNEL.')       RETURN	       END=/       SUBROUTINE DEASSIGN_DEVICE(CHANNEL,ERROR)=       INTEGER*2 CHANNEL=)       LOGICAL ERROR,WRITE_MESSAGE/.TRUE./        CHARACTER*10 STATUS$9       CALL CHECK_RETURN_STATUS(SYS$DASSGN(%VAL(CHANNEL)),E:      *                         WRITE_MESSAGE,ERROR,STATUS)!       IF(ERROR)WRITE(6,10)CHANNEL 2 10    FORMAT('   ***Error*** in DEASSIGN_DEVICE:',0      *       ' Failed to deassign CHANNEL:',I12)       RETURN	       END 3       SUBROUTINE CHECK_RETURN_STATUS(RETURN_STATUS, @      *                               WRITE_MESSAGE,ERROR,STATUS)       INTEGER RETURN_STATUSt!       LOGICAL WRITE_MESSAGE,ERROR        CHARACTER*(*) STATUSH       EXTERNAL SS$_NORMAL,SS$_REMOTE,SS$_ABORT,SS$_ACCVIO,SS$_DEVACTIVE,G      * SS$_DEVALLOC,SS$_DEVNOTMBX,SS$_EXQUOTA,SS$_INSFMEM,SS$_IVDEVNAM,EF      * SS$_IVLOGNAM,SS$_NOIOCHAN,SS$_NOLINKS,SS$_NOPRIV,SS$_NOSUCHDEV,+      * SS$_NOSUCHNODE,SS$_REJECT,SS$_IVCHAN=.       IF(RETURN_STATUS.EQ.%LOC(SS$_NORMAL).OR./      *   RETURN_STATUS.EQ.%LOC(SS$_REMOTE))THEN           ERROR=.FALSE.          RETURN=          ENDIF       ERROR=.TRUE.       STATUS='WHO KNOWS?'S8       IF(RETURN_STATUS.EQ.%LOC(SS$_ABORT))STATUS='ABORT':       IF(RETURN_STATUS.EQ.%LOC(SS$_ACCVIO))STATUS='ACCVIO'@       IF(RETURN_STATUS.EQ.%LOC(SS$_DEVACTIVE))STATUS='DEVACTIVE'>       IF(RETURN_STATUS.EQ.%LOC(SS$_DEVALLOC))STATUS='DEVALLOC'@       IF(RETURN_STATUS.EQ.%LOC(SS$_DEVNOTMBX))STATUS='DEVNOTMBX'<       IF(RETURN_STATUS.EQ.%LOC(SS$_EXQUOTA))STATUS='EXQUOTA'<       IF(RETURN_STATUS.EQ.%LOC(SS$_INSFMEM))STATUS='INSFMEM'>       IF(RETURN_STATUS.EQ.%LOC(SS$_IVDEVNAM))STATUS='IVDEVNAM'>       IF(RETURN_STATUS.EQ.%LOC(SS$_IVLOGNAM))STATUS='IVLOGNAM'>       IF(RETURN_STATUS.EQ.%LOC(SS$_NOIOCHAN))STATUS='NOIOCHAN'<       IF(RETURN_STATUS.EQ.%LOC(SS$_NOLINKS))STATUS='NOLINKS':       IF(RETURN_STATUS.EQ.%LOC(SS$_NOPRIV))STATUS='NOPRIV'@       IF(RETURN_STATUS.EQ.%LOC(SS$_NOSUCHDEV))STATUS='NOSUCHDEV'>       IF(RETURN_STATUS.EQ.%LOC(SS$_NOSUCHNODE))STATUS='REJECT':       IF(RETURN_STATUS.EQ.%LOC(SS$_IVCHAN))STATUS='IVCHAN'6       IF(WRITE_MESSAGE)WRITE(6,10)STATUS,RETURN_STATUS= 10    FORMAT('   ***Return Status from system routine is ',A,       *       ',  Value =',I12)       RETURN	       ENDr