5       SUBROUTINE REALCH(REAL,NREAL,IPOW,NPOS,NDEC,CH)  C  C     LIBRARY-ROUTINE  C = C                                                29/JULY/1980 > C                                                C.J. KOST SIN C   ) C     reqd. KOSTL: routines - DEXP10,EQUC  C A C================================================================ A C================================================================ A C==                                                            == A C==   REALCH: CONVERTS THE REAL NUMBER REAL INTO A CHARACTER   == A C==   STRING CH WITH FORMAT F(NPOS).(NDEC) SUCH THAT:          == A C==   REAL = CH*(10**IPOW), AND THE CHARACTER STRING CH IS     == A C==   RIGHT-JUSTIFIED IN THE FIELD WIDTH OF NPOS CHARACTERS.   == A C==   IF |NREAL|=1 THEN REAL IS REAL*4, IF |NREAL|=2 THEN REAL == A C==   IS A REAL*8 NUMBER. IF NREAL > 0 THEN THE POWER IPOW WILL== A C==   BE ACCEPTED AS INPUT AND REALCH WILL CONVERT THE SCALED  == A C==   NUMBER REAL/10**IPOW INTO THE CHARACTER STRING: CH.      == A C==   IF NREAL < 0 THEN THE POWER IPOW WILL BE DETEMINED BY    == A C==   REALCH SO THAT THE NUMBER REAL/10**IPOW WILL FIT EXACTLY == A C==   INTO THE FIELD WIDTH OF NPOS CHARACTERS, I.E. REALCH WILL== A C==   SCALE REAL SO THAT IT WILL FIT INTO THE F(NPOS).(NDEC)   == A C==   FORMAT WITH A MAXIMUM NUMBER OF SIGNIFICANT DIGITS. THE  == A C==   POWER IPOW USED WILL BE RETURNED.                        == A C==   IF THE NUMBER OF DECIMAL PLACES NDEC IS LESS THAN ZERO   == A C==   THEN THE DECIMAL POINT IN THE CHARACTER REPRESENTATION OF== A C==   REAL WILL BE SUPPRESSED (I.E. IT IS ASSUMED TO BE ON THE == A C==   FAR RIGHT OF THE NPOS CHARACTERS OF THE CH ARRAY).       == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., MARCH 5, 1979.  == A C==   (NOTE: THIS IS A REVISION OF THE FORMER ROUTINE: NUMCON. == A C==          REALCH IS THE INVERSE OF THE ROUTINE CHREAL, WHICH== A C==          CONVERTS A CHARACTER STRING INTO A REAL NUMBER).  == A C==                                                            == A C==   INPUT  PARAMETERS: REAL, (R*4: |NREAL|=1, R*8: |NREAL|=2)== A C==                      NREAL,IPOW,NPOS,NDEC (I*4).           == A C==                                                            == A C==   OUTPUT PARAMETERS: CH, (LOGICAL*1).                      == A C==                                                            == A C================================================================ A C================================================================ A CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC        IMPLICIT REAL*8 (A-H,O-Z)        REAL REAL(2),REAL4(2)        REAL*8 REAL8"       EQUIVALENCE (REAL4(1),REAL8)       BYTE CH(NPOS)        BYTE DIGIT(10)       BYTE MINUS,DEC,BLANK,STAR :       DATA DIGIT/'0','1','2','3','4','5','6','7','8','9'/,/      * MINUS/'-'/,DEC/'.'/,BLANK/' '/,STAR/'*'/        LOGICAL EQUC       IF(NPOS.LE.0)RETURN A C================================================================ A C==   STORE THE REAL NUMBER: REAL (R*4,R*8) INTO REAL8 (R*8).  == A C================================================================        REAL8=0.D0       REAL4(1)=REAL(1)*       IF(IABS(NREAL).EQ.2)REAL4(2)=REAL(2)A C================================================================ A C==   DETERMINE NINT, THE NUMBER OF DIGITS TO THE LEFT OF THE  == A C==   DECIMAL POINT, AND NDEC2, THE NUMBER OF DECIMAL PLACES,  == A C==   ALLOWED BY THE FORMAT SPECIFICATION AND THE SIGN OF REAL8.= A C==   NDIG=NDEC2+NINT = NUMBER OF DIGITS ALLOWED BY THE FORMAT.== A C==   IF NINT < 0 OR NDIG <= 0 THEN AN FORMAT OVERFLOW         == A C==   HAS OCCURED, HENCE GO TO 100 AND PUT "*"S IN THE CH      == A C==   FIELD.                                                   == A C================================================================        NDEC1=MAX0(NDEC,-1)        NDEC2=MAX0(NDEC,0)       NINT=NPOS-NDEC1-1 "       IF(REAL8.LT.0.D0)NINT=NINT-1       IF(NINT.LT.0)GO TO 100"       IF(NINT+NDEC2.LE.0)GO TO 100A C================================================================ A C==   IF NREAL > 0 SCALE REALA=|REAL8| DOWN BY 10**IPOW.       == A C==   IF NREAL < 0 DETERMINE IPOW SO THAT CH=REAL8/10**IPOW    == A C==   WILL FIT EXACTLY IN THE FORMAT SPECIFICATION (EVEN WHEN  == A C==   THE NUMBER IS ROUNDED).                                  ===A C=================================================================       POWDEC=10.D0**NDEC2        REALA=DABS(REAL8)        IF(NREAL.LT.0)GO TO 10A C================================================================IA C==   DEXP10(REALA,IPOW)=REALA/10.D0**IPOW                     ==LA C==   DEXP10 IS USED INSTEAD OF "**" BECAUSE |IPOW| MAY BE TOO ==HA C==   LARGE.                                                   ==|A C==   EXAMPLE: IF REALA=1.E-70 AND IPOW=-100 THEN              ==AA C==   10.D0**IPOW IS UNDEFINED (UNDERFLOW) BUT                 ==AA C==   REALA/10.D0**IPOW = 1.E-70/10**-100 = 1.E30 IS DEFINED,  ==BA C==   AND THIS IS THE RESULT DEXP10(REALA,IPOW) WILL RETURN.   ==NA C================================================================L       REALA=DEXP10(REALA,IPOW)       GO TO 20A C================================================================HA C==   NREAL < 0: DETERMINE IPOW.                               ==EA C================================================================  10    IPOW=0       IF(REALA.EQ.0.D0)GO TO 20D.       IPOW=IDINT(DLOG10(REALA)+100.D0)-99-NINTA C================================================================CA C==   DEXP10(REALA,IPOW)=REALA/10.D0**IPOW                     ==EA C================================================================F       REALA=DEXP10(REALA,IPOW)A C================================================================ A C==   CHECK THAT THE NUMBER CH=REALA=REAL8/10**IPOW WILL FIT   ==RA C==   INTO THE FORMAT SPECIFICATION EVEN WHEN IT IS ROUNDED OFF==TA C================================================================        REALN=POWDEC*REALA+.5D0C       RNMAX=POWDEC*10.D0**NINT#       IF(REALN.GE.RNMAX)IPOW=IPOW+1 )       IF(REALN.GE.RNMAX)REALA=REALA/10.D0 A C================================================================|A C==   EXTRACT THE REQUIRED NUMBER OF DIGITS FROM THE REAL      == A C==   NUMBER REALA, AND CONVERT THEM TO CHARACTERS IN CH.      == A C================================================================  20    REALN=POWDEC*REALA+.5D0        DO 40 I=1,NPOS       IF(I.NE.NDEC2+1)GO TO 30       IF(NDEC1.LT.0)GO TO 30       CH(NPOS-I+1)=DEC       GO TO 40" 30    INDEX=DMOD(REALN,10.D0)+1.D0*       IF(INDEX.LT.1.OR.INDEX.GT.10)INDEX=1       CH(NPOS-I+1)=DIGIT(INDEX)C       REALN=REALN/10.D0R 40    CONTINUEA C================================================================CA C==   IF REALN => 1, THEN REALN HAS OVERFLOWED THE CH FORMAT,  == A C==   BECAUSE THERE ARE STILL NON-ZERO LEADING DIGITS WHICH DO =='A C==   NOT FIT INTO THE NPOS POSITIONS OF CH.                   =='A C=================================================================        IF(REALN.GE.1.D0)GO TO 100A C================================================================RA C==   DETERMINE THE FIRST NON-ZERO CHARACTER OF CH.            ===A C================================================================F       DO 50 I=1,NPOS&       IF(.NOT.EQUC(CH(I),'0'))GO TO 60       CH(I)=BLANK= 50    CONTINUE       CH(NPOS)=DIGIT(1)T       I=NPOS 60    IF(REAL8.LT.0.D0)GO TO 70 A C================================================================ A C==   REAL8 > 0:                                               == A C==   IF THE DECIMAL POINT IS THE FIRST NON-ZERO CHARACTER IN  == A C==   CH, THEN PUT A LEADING ZERO IN FRONT IF THERE IS ROOM.   == A C================================================================ $       IF(.NOT.EQUC(CH(I),'.'))RETURN        IF(I.GT.1)CH(I-1)=DIGIT(1)       RETURNA C================================================================NA C==   REAL8 < 0: PUT A MINUS SIGN IN CH.                       == A C================================================================F 70    IF(I.EQ.1)GO TO 100 !       IF(EQUC(CH(I),'.'))GO TO 80=       CH(I-1)=MINUS=       RETURN 80    IF(I.GT.2)GO TO 90       CH(I-1)=MINUSI       RETURN 90    CH(I-1)=DIGIT(1)       CH(I-2)=MINUSH       RETURNA C================================================================WA C==   CH FORMAT HAS OVERFLOWED: FILL CH WITH "*"'S.            == A C================================================================= 100   DO 110 I=1,NPOS1       CH(I)=STAR 110   CONTINUE       RETURN	       END)