-       CHARACTER*(*) FUNCTION RMS_ERROR(ISTAT) H C***********************************************************************H C                                                                      *H C    Reqd. Routines - NONE                                             *H C                                                                      *H C    This routine returns the error message corresponding to the value *H C    of ISTAT that is the value returned when calling one of the       *H C    RMS routines.                                                     *H C                                                                      *H C    Examples:                                                         *H C                                                                      *H C             CHARACTER*132 RMS_ERROR                                  *H C             ISTAT = LOK_IOFAST$OPEN(LUN,FILE)                        *H C             IF(.NOT.ISTAT)WRITE(6,*)RMS_ERROR(ISTAT)                 *H C                                                                      *H C                                               Author: Joe Chuma      *H C                                                       May 4, 1984    *H C                                                                      *H C***********************************************************************       INCLUDE '($RMSDEF)'        RMS_ERROR = ' '        IF(ISTAT)THEN ;         RMS_ERROR = ' *** Normal successful completion ***'          RETURN       END IF?       IF(ISTAT .EQ. RMS$_SUC)THEN                 ! '00010001'X 3         RMS_ERROR = ' *** OPERATION SUCCESSFUL ***' ?       ELSE IF(ISTAT .EQ. RMS$_NORMAL)THEN         ! '00010001'X 3         RMS_ERROR = ' *** OPERATION SUCCESSFUL ***' ?       ELSE IF(ISTAT .EQ. RMS$_STALL)THEN          ! '00018001'X D         RMS_ERROR = ' *** synchronize with operation completion ***'?       ELSE IF(ISTAT .EQ. RMS$_PENDING)THEN        ! '00018009'X G         RMS_ERROR = ' *** asynchronous operation not yet completed ***' ?       ELSE IF(ISTAT .EQ. RMS$_OK_DUP)THEN         ! '00018011'X @         RMS_ERROR = ' *** record inserted had duplicate key ***'?       ELSE IF(ISTAT .EQ. RMS$_OK_IDX)THEN         ! '00018019'X :         RMS_ERROR = ' *** index update error occurred ***'?       ELSE IF(ISTAT .EQ. RMS$_OK_RLK)THEN         ! '00018021'X <         RMS_ERROR = ' *** record locked but read anyway ***'?       ELSE IF(ISTAT .EQ. RMS$_OK_RRL)THEN         ! '00018029'X          RMS_ERROR = <      # ' *** record locked against read but read anyway ***'?       ELSE IF(ISTAT .EQ. RMS$_KFF)THEN            ! '00018031'X /         RMS_ERROR = ' *** known file found ***' ?       ELSE IF(ISTAT .EQ. RMS$_OK_ALK)THEN         ! '00018039'X 7         RMS_ERROR = ' *** record is already locked ***' ?       ELSE IF(ISTAT .EQ. RMS$_OK_DEL)THEN         ! '00018041'X C         RMS_ERROR = ' *** deleted record successfully accessed ***' ?       ELSE IF(ISTAT .EQ. RMS$_OK_RNF)THEN         ! '00018049'X F         RMS_ERROR = ' *** nonexistent record successfuly accessed ***'?       ELSE IF(ISTAT .EQ. RMS$_OK_LIM)THEN         ! '00018051'X          RMS_ERROR = >      # ' *** retrieved record exceeds specified key value ***'?       ELSE IF(ISTAT .EQ. RMS$_OK_NOP)THEN         ! '00018059'X >         RMS_ERROR = ' *** XAB not filled in for block I/O ***'?       ELSE IF(ISTAT .EQ. RMS$_OK_WAT)THEN         ! '00018061'X 7         RMS_ERROR = ' *** record locked after wait ***' ?       ELSE IF(ISTAT .EQ. RMS$_CRE_STM)THEN        ! '00018069'X @         RMS_ERROR = ' *** file was created in stream format ***'?       ELSE IF(ISTAT .EQ. RMS$_CONTROLC)THEN       ! '00010651'X A         RMS_ERROR = ' *** terminal I/O aborted due to CTRL/C ***' ?       ELSE IF(ISTAT .EQ. RMS$_CONTROLO)THEN       ! '00010609'X A         RMS_ERROR = ' *** terminal I/O ignored due to CTRL/O ***' ?       ELSE IF(ISTAT .EQ. RMS$_CONTROLY)THEN       ! '00010611'X A         RMS_ERROR = ' *** terminal I/O aborted due to CTRL/Y ***' ?       ELSE IF(ISTAT .EQ. RMS$_CREATED)THEN        ! '00010619'X ;         RMS_ERROR = ' *** file was created, not opened ***'*?       ELSE IF(ISTAT .EQ. RMS$_SUPERSEDE)THEN      ! '00010631'X G         RMS_ERROR = ' *** created file superseded existing version ***'E?       ELSE IF(ISTAT .EQ. RMS$_BOF)THEN            ! '00018198'X 9         RMS_ERROR = ' *** beginning of file detected ***' ?       ELSE IF(ISTAT .EQ. RMS$_RNL)THEN            ! '000181A0'Xe0         RMS_ERROR = ' *** record not locked ***'?       ELSE IF(ISTAT .EQ. RMS$_RTB)THEN            ! '000181A8'X          RMS_ERROR = >      # ' *** !UL byte record too large for user''s buffer ***'?       ELSE IF(ISTAT .EQ. RMS$_TMO)THEN            ! '000181B0'X 5         RMS_ERROR = ' *** timeout period expired ***' ?       ELSE IF(ISTAT .EQ. RMS$_TNS)THEN            ! '000181B8'XH2         RMS_ERROR = ' *** terminator not seen ***'?       ELSE IF(ISTAT .EQ. RMS$_BES)THEN            ! '000181C0'X 2         RMS_ERROR = ' *** bad escape sequence ***'?       ELSE IF(ISTAT .EQ. RMS$_PES)THEN            ! '000181C8'X 6         RMS_ERROR = ' *** partial escape sequence ***'?       ELSE IF(ISTAT .EQ. RMS$_ACT)THEN            ! '0001825A'X @         RMS_ERROR = ' *** file activity precludes operation ***'?       ELSE IF(ISTAT .EQ. RMS$_DEL)THEN            ! '00018262'X >         RMS_ERROR = ' *** RFA-accessed record was deleted ***'?       ELSE IF(ISTAT .EQ. RMS$_TEMP1)THEN          ! '0001826A'X          RMS_ERROR = G      # ' *** old message code available for reassignment - was DNF ***' ?       ELSE IF(ISTAT .EQ. RMS$_DNR)THEN            ! '00018272'X >         RMS_ERROR = ' *** device not ready or not mounted ***'?       ELSE IF(ISTAT .EQ. RMS$_EOF)THEN            ! '0001827A'X 3         RMS_ERROR = ' *** end of file detected ***'U?       ELSE IF(ISTAT .EQ. RMS$_FEX)THEN            ! '00018282'X B         RMS_ERROR = ' *** file already exists, not superseded ***'?       ELSE IF(ISTAT .EQ. RMS$_FLK)THEN            ! '0001828A'X D         RMS_ERROR = ' *** file currently locked by another user ***'?       ELSE IF(ISTAT .EQ. RMS$_FNF)THEN            ! '00018292'X -         RMS_ERROR = ' *** file not found ***' ?       ELSE IF(ISTAT .EQ. RMS$_PRV)THEN            ! '0001829A'XR         RMS_ERROR = E      # ' *** insufficient privilege or file protection violation ***' ?       ELSE IF(ISTAT .EQ. RMS$_REX)THEN            ! '000182A2'X24         RMS_ERROR = ' *** record already exists ***'?       ELSE IF(ISTAT .EQ. RMS$_RLK)THEN            ! '000182AA'X          RMS_ERROR = B      # ' *** target record currently locked by another stream ***'?       ELSE IF(ISTAT .EQ. RMS$_RNF)THEN            ! '000182B2'X8/         RMS_ERROR = ' *** record not found ***'d?       ELSE IF(ISTAT .EQ. RMS$_WLK)THEN            ! '000182BA'X8<         RMS_ERROR = ' *** device currently write locked ***'?       ELSE IF(ISTAT .EQ. RMS$_EXP)THEN            ! '000182C2'X'C         RMS_ERROR = ' *** file expiration date not yet reached ***'*?       ELSE IF(ISTAT .EQ. RMS$_NMF)THEN            ! '000182CA'X'2         RMS_ERROR = ' *** no more files found ***'?       ELSE IF(ISTAT .EQ. RMS$_SUP)THEN            ! '000182D2'X          RMS_ERROR = A      # ' *** network operation not supported; DAP code = !XL ***'f?       ELSE IF(ISTAT .EQ. RMS$_RSA)THEN            ! '000182DA'X =         RMS_ERROR = ' *** record stream currently active ***' ?       ELSE IF(ISTAT .EQ. RMS$_CRC)THEN            ! '000182E2'X A         RMS_ERROR = ' *** network DAP level CRC check failed ***'a?       ELSE IF(ISTAT .EQ. RMS$_WCC)THEN            ! '000182EA'X0D         RMS_ERROR = ' *** invalid wild card context (WCC) value ***'?       ELSE IF(ISTAT .EQ. RMS$_IDR)THEN            ! '000182F2'X5A         RMS_ERROR = ' *** invalid directory rename operation ***'*?       ELSE IF(ISTAT .EQ. RMS$_ACC)THEN            ! '0001C002'X05         RMS_ERROR = ' *** ACP file access failed ***'e?       ELSE IF(ISTAT .EQ. RMS$_CRE)THEN            ! '0001C00A'X 5         RMS_ERROR = ' *** ACP file create failed ***'O?       ELSE IF(ISTAT .EQ. RMS$_DAC)THEN            ! '0001C012'XEE         RMS_ERROR = ' *** ACP file deaccess failed during $CLOSE ***'d?       ELSE IF(ISTAT .EQ. RMS$_ENT)THEN            ! '0001C01A'X 8         RMS_ERROR = ' *** ACP enter function failed ***'?       ELSE IF(ISTAT .EQ. RMS$_EXT)THEN            ! '0001C022'X_5         RMS_ERROR = ' *** ACP file extend failed ***' ?       ELSE IF(ISTAT .EQ. RMS$_FND)THEN            ! '0001C02A'XRB         RMS_ERROR = ' *** ACP file or directory lookup failed ***'?       ELSE IF(ISTAT .EQ. RMS$_MKD)THEN            ! '0001C032'X C         RMS_ERROR = ' *** ACP could not mark file for deletion ***'o?       ELSE IF(ISTAT .EQ. RMS$_DPE)THEN            ! '0001C03A'XS7         RMS_ERROR = ' *** device positioning error ***' ?       ELSE IF(ISTAT .EQ. RMS$_SPL)THEN            ! '0001C042'X_         RMS_ERROR = B      # ' *** spool or submit of command file failed on $CLOSE ***'?       ELSE IF(ISTAT .EQ. RMS$_DNF)THEN            ! '0001C04A'X 2         RMS_ERROR = ' *** directory not found ***'?       ELSE IF(ISTAT .EQ. RMS$_ABO)THEN            ! '000183EC'X 0         RMS_ERROR = ' *** operation aborted ***'?       ELSE IF(ISTAT .EQ. RMS$_AID)THEN            ! '000183F4'X'<         RMS_ERROR = ' *** invalid area ID in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_ALN)THEN            ! '000183FC'X8D         RMS_ERROR = ' *** alignment options error in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_ALQ)THEN            ! '00018404'X          RMS_ERROR = >      # ' *** invalid allocation quantity ( <= on $EXTEND) ***'?       ELSE IF(ISTAT .EQ. RMS$_ANI)THEN            ! '0001840C'X02         RMS_ERROR = ' *** not ANSI "D" format ***'?       ELSE IF(ISTAT .EQ. RMS$_AOP)THEN            ! '00018414'X E         RMS_ERROR = ' *** allocation options error in XAB at !XL ***'*?       ELSE IF(ISTAT .EQ. RMS$_BKS)THEN            ! '0001841C'X8:         RMS_ERROR = ' *** bucket size too large (FAB) ***'?       ELSE IF(ISTAT .EQ. RMS$_BKZ)THEN            ! '00018424'X B         RMS_ERROR = ' *** bucket size too large in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_BLN)THEN            ! '0001842C'X          RMS_ERROR = B      # ' *** invalid block length for control block (RAB/FAB) ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG)THEN            ! '00018434'X D         RMS_ERROR = ' *** internal RMS error condition detected ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_DDI)THEN        ! '0001843C'X 8         RMS_ERROR = ' *** invalid default directory ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_DAP)THEN        ! '00018444'X          RMS_ERROR = E      # ' *** Data Access Protocol error detected; DAP code = !XL ***'E?       ELSE IF(ISTAT .EQ. RMS$_BUG_XX2)THEN        ! '0001844C'XM0         RMS_ERROR = ' *** reserved bug code ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_XX3)THEN        ! '00018454'XM0         RMS_ERROR = ' *** reserved bug code ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_XX4)THEN        ! '0001845C'X'0         RMS_ERROR = ' *** reserved bug code ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_XX5)THEN        ! '00018464'X 0         RMS_ERROR = ' *** reserved bug code ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_XX6)THEN        ! '0001846C'X 0         RMS_ERROR = ' *** reserved bug code ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_XX7)THEN        ! '00018474'X 0         RMS_ERROR = ' *** reserved bug code ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_XX8)THEN        ! '0001847C'Xc0         RMS_ERROR = ' *** reserved bug code ***'?       ELSE IF(ISTAT .EQ. RMS$_BUG_XX9)THEN        ! '00018484'X 0         RMS_ERROR = ' *** reserved bug code ***' C  (NEXT CODE CURRENTLY UNUSED)0?       ELSE IF(ISTAT .EQ. RMS$_CAA)THEN            ! '0001848C'XW:         RMS_ERROR = ' *** cannot access argument list ***'?       ELSE IF(ISTAT .EQ. RMS$_CCR)THEN            ! '00018494'X 1         RMS_ERROR = ' *** cannot connect RAB ***'S?       ELSE IF(ISTAT .EQ. RMS$_CHG)THEN            ! '0001849C'XC         RMS_ERROR = =      # ' *** invalid key change in $UPDATE (CHG not set) ***'C?       ELSE IF(ISTAT .EQ. RMS$_CHK)THEN            ! '000184A4'X D         RMS_ERROR = ' *** bucket format check failed; VBN = !UL ***'?       ELSE IF(ISTAT .EQ. RMS$_COD)THEN            ! '000184AC'X          RMS_ERROR = A      # ' *** invalid or unsupported type field in XAB at !XL ***'*?       ELSE IF(ISTAT .EQ. RMS$_CUR)THEN            ! '000184B4'XX         RMS_ERROR = D      # ' *** no current record (op. not preceded by $GET/$FIND) ***'?       ELSE IF(ISTAT .EQ. RMS$_DAN)THEN            ! '000184BC'X E         RMS_ERROR = ' *** invalid data area number in XAB at !XL ***' ?       ELSE IF(ISTAT .EQ. RMS$_DEV)THEN            ! '000184C4'X          RMS_ERROR = '      # ' *** error in device name or'// 5      # ' inappropriate device type for operation ***'0?       ELSE IF(ISTAT .EQ. RMS$_DIR)THEN            ! '000184CC'X 6         RMS_ERROR = ' *** error in directory name ***'?       ELSE IF(ISTAT .EQ. RMS$_DME)THEN            ! '000184D4'X 7         RMS_ERROR = ' *** dynamic memory exhausted ***'E?       ELSE IF(ISTAT .EQ. RMS$_DNA)THEN            ! '000184DC'X G         RMS_ERROR = ' *** invalid default file name string address ***' ?       ELSE IF(ISTAT .EQ. RMS$_DTP)THEN            ! '000184E4'X B         RMS_ERROR = ' *** invalid key data type in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_DUP)THEN            ! '000184EC'X C         RMS_ERROR = ' *** duplicate key detected (DUP not set) ***' ?       ELSE IF(ISTAT .EQ. RMS$_DVI)THEN            ! '000184F4'X C         RMS_ERROR = ' *** invalid device ID value in NAM block ***' ?       ELSE IF(ISTAT .EQ. RMS$_ESA)THEN            ! '000184FC'Xn>         RMS_ERROR = ' *** invalid expanded string address ***'?       ELSE IF(ISTAT .EQ. RMS$_ESS)THEN            ! '00018504'X*=         RMS_ERROR = ' *** expanded string area too small ***'1?       ELSE IF(ISTAT .EQ. RMS$_FAB)THEN            ! '0001850C'Xt@         RMS_ERROR = ' *** invalid FAB or FAB not accessible ***'?       ELSE IF(ISTAT .EQ. RMS$_FAC)THEN            ! '00018514'X          RMS_ERROR = E      # ' *** record op. not perm. by specified file access (FAC) ***' ?       ELSE IF(ISTAT .EQ. RMS$_FLG)THEN            ! '0001851C'X C         RMS_ERROR = ' *** invalid key def. flags in XAB at !XL ***' ?       ELSE IF(ISTAT .EQ. RMS$_FNA)THEN            ! '00018524'X ?         RMS_ERROR = ' *** invalid file name string address ***' ?       ELSE IF(ISTAT .EQ. RMS$_FNM)THEN            ! '0001852C'X*1         RMS_ERROR = ' *** error in file name ***' ?       ELSE IF(ISTAT .EQ. RMS$_FSZ)THEN            ! '00018534'Xt@         RMS_ERROR = ' *** invalid fixed control header size ***'?       ELSE IF(ISTAT .EQ. RMS$_FOP)THEN            ! '0001853C'X 3         RMS_ERROR = ' *** invalid file options ***'S?       ELSE IF(ISTAT .EQ. RMS$_FUL)THEN            ! '00018544'XO         RMS_ERROR = A      # ' *** device full (insufficient space for allocation) ***'0?       ELSE IF(ISTAT .EQ. RMS$_IAL)THEN            ! '0001854C'X 4         RMS_ERROR = ' *** invalid argument list ***'?       ELSE IF(ISTAT .EQ. RMS$_IAN)THEN            ! '00018554'XEF         RMS_ERROR = ' *** invalid index area number in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_IDX)THEN            ! '0001855C'XU4         RMS_ERROR = ' *** index not initialized ***'?       ELSE IF(ISTAT .EQ. RMS$_IFI)THEN            ! '00018564'XX         RMS_ERROR = >      # ' *** invalid internal file identifier (IFI) value ***'?       ELSE IF(ISTAT .EQ. RMS$_IMX)THEN            ! '0001856C'X          RMS_ERROR = ?      # ' *** invalid duplicate XAB or non-dense XAB at !XL ***' ?       ELSE IF(ISTAT .EQ. RMS$_IOP)THEN            ! '00018574'X          RMS_ERROR = C      # ' *** operation invalid for file organization or device ***' ?       ELSE IF(ISTAT .EQ. RMS$_IRC)THEN            ! '0001857C'XsD         RMS_ERROR = ' *** illegal record encountered; STV = !UL ***'?       ELSE IF(ISTAT .EQ. RMS$_ISI)THEN            ! '00018584'XE         RMS_ERROR = @      # ' *** invalid internal stream identifier (ISI) value ***'?       ELSE IF(ISTAT .EQ. RMS$_KBF)THEN            ! '0001858C'XI1         RMS_ERROR = ' *** invalid key buffer ***' ?       ELSE IF(ISTAT .EQ. RMS$_KEY)THEN            ! '00018594'X E         RMS_ERROR = ' *** invalid record number key or key value ***' ?       ELSE IF(ISTAT .EQ. RMS$_KRF)THEN            ! '0001859C'XeF         RMS_ERROR = ' *** invalid key-of-reference for $GET/$FIND ***'?       ELSE IF(ISTAT .EQ. RMS$_KSZ)THEN            ! '000185A4'Xe>         RMS_ERROR = ' *** invalid key size for $GET/$FIND ***'?       ELSE IF(ISTAT .EQ. RMS$_LAN)THEN            ! '000185AC'X          RMS_ERROR = F      # ' *** invalid lowest-level-index area number in XAB at !XL ***' C  (NEXT CODE CURRENTLY UNUSED)M?       ELSE IF(ISTAT .EQ. RMS$_LBL)THEN            ! '000185B4'Xa<         RMS_ERROR = ' *** tape label is not ANSI format ***'?       ELSE IF(ISTAT .EQ. RMS$_LNE)THEN            ! '000185BC'X F         RMS_ERROR = ' *** logical name translation count exceeded ***' C  (NEXT CODE CURRENTLY UNUSED) ?       ELSE IF(ISTAT .EQ. RMS$_LOC)THEN            ! '000185C4'XE         RMS_ERROR = A      # ' *** invalid allocation location field in XAB at !XL ***' ?       ELSE IF(ISTAT .EQ. RMS$_MRN)THEN            ! '000185CC'XR         RMS_ERROR = B      # ' *** invalid maximum record # or record # exceeds MRN ***'?       ELSE IF(ISTAT .EQ. RMS$_MRS)THEN            ! '000185D4'X :         RMS_ERROR = ' *** invalid maximum record size ***'?       ELSE IF(ISTAT .EQ. RMS$_NAM)THEN            ! '000185DC'XN         RMS_ERROR = ?      # ' *** invalid NAM block or NAM block not accessible ***'o?       ELSE IF(ISTAT .EQ. RMS$_NEF)THEN            ! '000185E4'X0         RMS_ERROR = -      # ' *** not positioned to EOF on $PUT'//*,      # ' (sequential organization only) ***' C  (NEXT CODE CURRENTLY UNUSED)M?       ELSE IF(ISTAT .EQ. RMS$_NID)THEN            ! '000185EC'XIH         RMS_ERROR = ' *** cannot allocate internal index descriptor ***'?       ELSE IF(ISTAT .EQ. RMS$_NOD)THEN            ! '000185F4'X 1         RMS_ERROR = ' *** error in node name ***' ?       ELSE IF(ISTAT .EQ. RMS$_NPK)THEN            ! '000185FC'XlF         RMS_ERROR = ' *** no primary key defined for indexed file ***'?       ELSE IF(ISTAT .EQ. RMS$_ORD)THEN            ! '00018604'Xi?         RMS_ERROR = ' *** XABs not in correct order at !XL ***' ?       ELSE IF(ISTAT .EQ. RMS$_ORG)THEN            ! '0001860C'Xt>         RMS_ERROR = ' *** invalid file organization value ***'?       ELSE IF(ISTAT .EQ. RMS$_PBF)THEN            ! '00018614'Xe4         RMS_ERROR = ' *** invalid prompt buffer ***'?       ELSE IF(ISTAT .EQ. RMS$_PLG)THEN            ! '0001861C'Xo         RMS_ERROR = G      # ' *** error detected in file''s prologue (reconstruct file) ***'M?       ELSE IF(ISTAT .EQ. RMS$_POS)THEN            ! '00018624'XE         RMS_ERROR = G      # ' *** invalid key position (greater than MRS) in XAB at !XL ***'u C  (NEXT CODE CURRENTLY UNUSED)*?       ELSE IF(ISTAT .EQ. RMS$_PRM)THEN            ! '0001862C'X'D         RMS_ERROR = ' *** invalid file date value in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_QUO)THEN            ! '00018634'X_5         RMS_ERROR = ' *** error in quoted string ***'*?       ELSE IF(ISTAT .EQ. RMS$_RAB)THEN            ! '0001863C'X'@         RMS_ERROR = ' *** invalid RAB or RAB not accessible ***'?       ELSE IF(ISTAT .EQ. RMS$_RAC)THEN            ! '00018644'X 9         RMS_ERROR = ' *** invalid record access mode ***' ?       ELSE IF(ISTAT .EQ. RMS$_RAT)THEN            ! '0001864C'X 8         RMS_ERROR = ' *** invalid record attributes ***'?       ELSE IF(ISTAT .EQ. RMS$_RBF)THEN            ! '00018654'XA4         RMS_ERROR = ' *** invalid record buffer ***'?       ELSE IF(ISTAT .EQ. RMS$_RFA)THEN            ! '0001865C'XiC         RMS_ERROR = ' *** invalid record''s file address (RFA) ***' ?       ELSE IF(ISTAT .EQ. RMS$_RFM)THEN            ! '00018664'Xr4         RMS_ERROR = ' *** invalid record format ***'?       ELSE IF(ISTAT .EQ. RMS$_RHB)THEN            ! '0001866C'X*;         RMS_ERROR = ' *** invalid record header buffer ***'L?       ELSE IF(ISTAT .EQ. RMS$_RLF)THEN            ! '00018674'X 8         RMS_ERROR = ' *** invalid related NAM block ***'?       ELSE IF(ISTAT .EQ. RMS$_ROP)THEN            ! '0001867C'XR5         RMS_ERROR = ' *** invalid record options ***' ?       ELSE IF(ISTAT .EQ. RMS$_RRV)THEN            ! '00018684'Xe=         RMS_ERROR = ' *** invalid RRV record encountered ***'F?       ELSE IF(ISTAT .EQ. RMS$_RVU)THEN            ! '0001868C'X0         RMS_ERROR = G      # ' *** error updating RRV''s, some paths to data may be lost ***'E?       ELSE IF(ISTAT .EQ. RMS$_RSS)THEN            ! '00018694'X <         RMS_ERROR = ' *** invalid resultant string size ***'?       ELSE IF(ISTAT .EQ. RMS$_RST)THEN            ! '0001869C'XE?         RMS_ERROR = ' *** invalid resultant string address ***' ?       ELSE IF(ISTAT .EQ. RMS$_RSZ)THEN            ! '000186A4'XR2         RMS_ERROR = ' *** invalid record size ***'?       ELSE IF(ISTAT .EQ. RMS$_SEQ)THEN            ! '000186AC'XEG         RMS_ERROR = ' *** primary key out of sequence (SEQ access) ***' ?       ELSE IF(ISTAT .EQ. RMS$_SHR)THEN            ! '000186B4'XlA         RMS_ERROR = ' *** invalid file sharing (SHR) options ***'.?       ELSE IF(ISTAT .EQ. RMS$_SIZ)THEN            ! '000186BC'X =         RMS_ERROR = ' *** invalid key size in XAB at !XL ***''?       ELSE IF(ISTAT .EQ. RMS$_SQO)THEN            ! '000186C4'X A         RMS_ERROR = ' *** operation not sequential (SQO set) ***'  C  (NEXT CODE CURRENTLY UNUSED) ?       ELSE IF(ISTAT .EQ. RMS$_STK)THEN            ! '000186CC'Xl<         RMS_ERROR = ' *** stack too large for save area ***'?       ELSE IF(ISTAT .EQ. RMS$_SYN)THEN            ! '000186D4'XR>         RMS_ERROR = ' *** file specification syntax error ***'?       ELSE IF(ISTAT .EQ. RMS$_TRE)THEN            ! '000186DC'XS2         RMS_ERROR = ' *** error in index tree ***'?       ELSE IF(ISTAT .EQ. RMS$_TYP)THEN            ! '000186E4'Xe1         RMS_ERROR = ' *** error in file type ***'.?       ELSE IF(ISTAT .EQ. RMS$_UBF)THEN            ! '000186EC'X*2         RMS_ERROR = ' *** invalid user buffer ***'?       ELSE IF(ISTAT .EQ. RMS$_USZ)THEN            ! '000186F4'X*7         RMS_ERROR = ' *** invalid user buffer size ***'E?       ELSE IF(ISTAT .EQ. RMS$_VER)THEN            ! '000186FC'XM6         RMS_ERROR = ' *** error in version number ***' C  (NEXT CODE CURRENTLY UNUSED))?       ELSE IF(ISTAT .EQ. RMS$_VOL)THEN            ! '00018704'X B         RMS_ERROR = ' *** invalid volume number in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_XAB)THEN            ! '0001870C'XmG         RMS_ERROR = ' *** invalid XAB or XAB not accessible at !XL ***'8?       ELSE IF(ISTAT .EQ. RMS$_ESL)THEN            ! '00018714'X'=         RMS_ERROR = ' *** invalid expanded string length ***'R?       ELSE IF(ISTAT .EQ. RMS$_WSF)THEN            ! '0001871C'X          RMS_ERROR = G      # ' *** working set full (cannot lock buffers in working set) ***'N?       ELSE IF(ISTAT .EQ. RMS$_ENV)THEN            ! '00018724'X8         RMS_ERROR = E      # ' *** support for RMS service call or feature not present ***'S?       ELSE IF(ISTAT .EQ. RMS$_PLV)THEN            ! '0001872C'XO;         RMS_ERROR = ' *** unsupported prologue version ***'E?       ELSE IF(ISTAT .EQ. RMS$_MBC)THEN            ! '00018734'X 8         RMS_ERROR = ' *** invalid multi-block count ***'?       ELSE IF(ISTAT .EQ. RMS$_RSL)THEN            ! '0001873C'XR>         RMS_ERROR = ' *** invalid resultant string length ***'?       ELSE IF(ISTAT .EQ. RMS$_WLD)THEN            ! '00018744'X 9         RMS_ERROR = ' *** invalid wildcard operation ***' ?       ELSE IF(ISTAT .EQ. RMS$_NET)THEN            ! '0001874C'X          RMS_ERROR = G      # ' *** network operation failed at remote node; DAP code=!XL ***''?       ELSE IF(ISTAT .EQ. RMS$_IBF)THEN            ! '00018754'X)?         RMS_ERROR = ' *** illegal bucket format; STV = !UL ***'8?       ELSE IF(ISTAT .EQ. RMS$_REF)THEN            ! '0001875C'X E         RMS_ERROR = ' *** invalid key-of-reference in XAB at !XL ***'M?       ELSE IF(ISTAT .EQ. RMS$_IFL)THEN            ! '00018764'X(         RMS_ERROR = D      # ' *** index bucket fill size > bucket size in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_DFL)THEN            ! '0001876C'X          RMS_ERROR = C      # ' *** data bucket fill size > bucket size in XAB at !XL ***'A?       ELSE IF(ISTAT .EQ. RMS$_KNM)THEN            ! '00018774'X          RMS_ERROR = ?      # ' *** key name buffer not accessible in XAB at !XL ***'  ?       ELSE IF(ISTAT .EQ. RMS$_IBK)THEN            ! '0001877C'Xu         RMS_ERROR = H      # ' *** LAN bucket size not = to IAN bucket size in XAB at !XL ***'?       ELSE IF(ISTAT .EQ. RMS$_KSI)THEN            ! '00018784'Xn         RMS_ERROR = 3      # ' *** index bucket will not hold two keys'//0)      # '  for key-of-reference = !UL ***' ?       ELSE IF(ISTAT .EQ. RMS$_LEX)THEN            ! '0001878C'X)         RMS_ERROR = -      # ' *** invalid $EXTEND for area !UL '//o(      # 'containing an unused extent ***'?       ELSE IF(ISTAT .EQ. RMS$_SEG)THEN            ! '00018794'Xr         RMS_ERROR = -      # ' *** data types other than string '//.1      # 'limited to one segment in XAB at !XL ***'M?       ELSE IF(ISTAT .EQ. RMS$_SNE)THEN            ! '0001879C'XL7         RMS_ERROR = ' *** file sharing not enabled ***' ?       ELSE IF(ISTAT .EQ. RMS$_SPE)THEN            ! '000187A4'X >         RMS_ERROR = ' *** file sharing pagecount exceeded ***'?       ELSE IF(ISTAT .EQ. RMS$_UPI)THEN            ! '000187AC'X          RMS_ERROR = =      # ' *** UPI not set when sharing and BIO or BRO set ***' ?       ELSE IF(ISTAT .EQ. RMS$_ACS)THEN            ! '000187B4'Xe=         RMS_ERROR = ' *** error in access control string ***' ?       ELSE IF(ISTAT .EQ. RMS$_STR)THEN            ! '000187BC'X          RMS_ERROR = D      # ' *** user structure (FAB/RAB) became invalid during op. ***'?       ELSE IF(ISTAT .EQ. RMS$_FTM)THEN            ! '000187C4'XS         RMS_ERROR = D      # ' *** network file transfer mode precludes op. (SQO set) ***'?       ELSE IF(ISTAT .EQ. RMS$_GBC)THEN            ! '000187CC'X :         RMS_ERROR = ' *** invalid global buffer count ***'?       ELSE IF(ISTAT .EQ. RMS$_DEADLOCK)THEN       ! '000187D4'XM0         RMS_ERROR = ' *** deadlock detected ***'?       ELSE IF(ISTAT .EQ. RMS$_EXENQLM)THEN        ! '000187DC'X 5         RMS_ERROR = ' *** exceeded enqueue quota ***' ?       ELSE IF(ISTAT .EQ. RMS$_ATR)THEN            ! '0001C0CC'X)9         RMS_ERROR = ' *** file attributes read error ***'n?       ELSE IF(ISTAT .EQ. RMS$_ATW)THEN            ! '0001C0D4'XR:         RMS_ERROR = ' *** file attributes write error ***'?       ELSE IF(ISTAT .EQ. RMS$_CCF)THEN            ! '0001C0DC'XI0         RMS_ERROR = ' *** cannot close file ***'?       ELSE IF(ISTAT .EQ. RMS$_CDA)THEN            ! '0001C0E4'XR1         RMS_ERROR = ' *** cannot deliver AST ***' ?       ELSE IF(ISTAT .EQ. RMS$_CHN)THEN            ! '0001C0EC'Xl         RMS_ERROR = >      # ' *** assign channel system service request failed ***'?       ELSE IF(ISTAT .EQ. RMS$_RER)THEN            ! '0001C0F4'Xo.         RMS_ERROR = ' *** file read error ***'?       ELSE IF(ISTAT .EQ. RMS$_RMV)THEN            ! '0001C0FC'X29         RMS_ERROR = ' *** ACP remove function failed ***'n?       ELSE IF(ISTAT .EQ. RMS$_RPL)THEN            ! '0001C104'X8D         RMS_ERROR = ' *** error detected while reading prologue ***'?       ELSE IF(ISTAT .EQ. RMS$_SYS)THEN            ! '0001C10C'X @         RMS_ERROR = ' *** QIO system service request failed ***'?       ELSE IF(ISTAT .EQ. RMS$_WER)THEN            ! '0001C114'X /         RMS_ERROR = ' *** file write error ***'*?       ELSE IF(ISTAT .EQ. RMS$_WPL)THEN            ! '0001C11C'X'D         RMS_ERROR = ' *** error detected while writing prologue ***'?       ELSE IF(ISTAT .EQ. RMS$_IFA)THEN            ! '0001C124'XH         RMS_ERROR = 0      # ' *** illegal file attributes detected'//&      # '  (file header corrupted) ***'?       ELSE IF(ISTAT .EQ. RMS$_WBE)THEN            ! '0001C12C'XO4         RMS_ERROR = ' *** error on write behind ***'?       ELSE IF(ISTAT .EQ. RMS$_ENQ)THEN            ! '0001C134'X(@         RMS_ERROR = ' *** ENQ system service request failed ***'?       ELSE IF(ISTAT .EQ. RMS$_NETFAIL)THEN        ! '0001C13C'XNF         RMS_ERROR = ' *** network operation failed at remote node ***'?       ELSE IF(ISTAT .EQ. RMS$_SUPPORT)THEN        ! '0001C144'XA>         RMS_ERROR = ' *** network operation not supported ***'?       ELSE IF(ISTAT .EQ. RMS$_CRMP)THEN           ! '0001C14C'X*         RMS_ERROR = D      # ' *** CRMPSC system service failed to map global buffers ***'       END IF       RETURN	       END 