.       SUBROUTINE RNCONE(X,Y,Z,COSANG,XR,YR,ZR)A C================================================================ A C================================================================ A C==                                                            == A C==   RNCONE: GENERATES A UNIT VECTOR: (XR,YR,ZR) UNIFORMLY    == A C==           SUCH THAT: X*XR + Y*YR + Z*ZR = COSANG,          == A C==           (INNER PRODUCT <(X,Y,Z),(XR,YR,ZR)>=COSANG),     == A C==           I.E. A RANDOM UNIT VECTOR IS CHOSEN TO LIE ON THE== A C==           SURFACE OF THE CONE WHOSE ANGLE W.R.T THE INPUT  == A C==           VECTOR (X,Y,Z) IS: ARCOS(COSANG).                == A C==                                                            == A C==   INPUT  PARAMETERS: X,Y,Z,COSANG (ALL REAL*4).            == A C==   OUTPUT PARAMETERS: XR,YR,ZR (ALL REAL*4).                == A C==                                                            == A C==   WRITTEN BY C. KOST AND A. HAYNES, TRIUMF, AUGUST 2, 1978.== A C==                                                            == A C================================================================ A C==                                                            == A C==   ALGORITHM USED:                                          == A C==                                                            == A C==   1) DEFINE A PRIMED SYSTEM (X-PRIME,Y-PRIME,Z-PRIME) IN   == A C==      WHICH THE Z-PRIME AXIS IS ALIGNED IN THE DIRECTION OF == A C==      THE INPUT VECTOR (X,Y,Z).                             == A C==                                                            == A C==   2) NEXT CHOOSE A UNIT VECTOR  VP = (XRP,YRP,ZRP) IN THE  == A C==      PRIMED SYSTEM AS FOLLOWS:                             == A C==      VP = (SIN(ANG)*COS(PHI), SIN(ANG)*SIN(PHI), COS(ANG)) == A C==      WHERE ANG = ARCOS(COSANG) IS THE ANGLE BETWEEN VP AND == A C==      THE Z-PRIME AXIS, AND PHI IS A RANDOM ANGLE CHOSEN    == A C==      UNIFORMLY IN THE RANGE 0 <= PHI <= 2*PI.              == A C==      ANG AND PHI ARE JUST THE SPHERICAL ANGLES OF VP IN    == A C==      THE PRIMED SYSTEM, AND VP IS A RANDOM VECTOR ON THE   == A C==      SURFACE OF THE CONE WHOSE ANGLE RELATIVE TO THE Z-PRIME= A C==      AXIS IS ANG.                                          == A C==                                                            == A C==   3) TO CALCULATE COS(PHI) AND SIN(PHI) WHERE PHI IS A     == A C==      UNIFORM RANDOM ANGLE IN THE RANGE: 0 <= PHI <= 2*PI,  == A C==      WE USE THE FOLLOWING REJECTION TECHNIQUE, DEVELOPED BY== A C==      VON NEUMANN, WHICH INVOLVES NO TRIGNOMETRIC           == A C==      CALCULATIONS (WHICH ARE EXTREMELY SLOW):              == A C==                                                            == A C==   A) CHOOSE A UNIFORM RANDOM NUMBER X1 IN THE RANGE 0 TO 1.== A C==                                                            == A C==   B) CHOOSE A UNIFORM RANDOM NUMBER X2 IN THE RANGE -1 TO 1.= A C==                                                            == A C==   C) IF X1**2 + X2**2 IS GREATER THAN 1 REPEAT A) AND B).  == A C==                                                            == A C==   D) X1**2 + X2**2 IS NOW <= 1.                            == A C==                                                            == A C==      WE NOW CALCULATE THE RANDOM COSINE AND SINE AS FOLLOWS:= A C==      COS(PHI) = (X1**2 - X2**2)/(X1**2 + X2**2) ,          == A C==      SIN(PHI) = 2*X1*X2/(X1**2 + X2**2).                   == A C==                                                            == A C==      THE ABOVE TECHNIQUE IS DESCRIBED IN:                  == A C==      "DIGITAL COMPUTER USER'S HANDBOOK", BY KLERER & KORN, == A C==      SECTION 3.4-10 (PAGE 3-70).                           == A C==                                                            == A C==      THE PROBABILITY AT STEP C) OF  X1**2+X2**2 BEING LESS == A C==      THAN OR EQUAL TO 1 (I.E. THE PROBABILITY THAT (X1,X2) == A C==      FALLS IN THE UNIT CIRCLE) IS PI/4. HENCE THE          == A C==      PROBABILITY OF FAILURE IN FINDING (X1,X2) WITHIN THE  ==,A C==      UNIT CIRCLE IS 1-PI/4. THEREFORE THE PROBABILITY THAT ===A C==      THE A-B-C LOOP WILL BE REPEATED N TIMES IS (1-PI/4)**N===A C==      I.E. THE PROBABILITY OF SUCCESS IN FINDING AN (X1,X2) == A C==      WHICH SATISFIES (X1**2+X2**2) <= 1, IN A MAXIMUM OF N == A C==      TRIALS IS: P(N) = 1-((1-PI/4)**N).                    ==AA C==      EXAMPLES: P(1)=.785, P(2)=.954, P(3)=.990, P(4)=.998, ===A C==                P(5)=.9995, P(10)=.9999998                  == A C==                                                            ==.A C================================================================ A C================================================================  10    X1=2.*FRAND(0)-1.N       X2=FRAND(0)Y       X1SQ=X1*X1       X2SQ=X2*X2       SUMSQ=X1SQ+X2SQT       IF(SUMSQ.GT.1.0)GO TO 10       SINANG=SQRT(1.-COSANG**2) "       XRP=SINANG*(X1SQ-X2SQ)/SUMSQ       YRP=SINANG*2.*X1*X2/SUMSQ        ZRP=COSANG       IF(ABS(Z).LT.1.)GO TO 20       XR=XRP       YR=YRP       ZR=ZRP       RETURN 20    SQRTZ=SQRT(1.-Z*Z)       DSQRT=1./SQRTZ       YDSQ=Y*DSQRT       XDSQ=X*DSQRT       ZXRP=Z*XRP'       XR = XDSQ*ZXRP - YDSQ*YRP + X*ZRP='       YR = YDSQ*ZXRP + XDSQ*YRP + Y*ZRP '       ZR =-SQRTZ*XRP            + Z*ZRP        RETURN	       END   