>       SUBROUTINE ROBUST_CO(N,X,Y,W,A,B,R,VAR,RES,RESOLD,C,EPS,,      ,                         ITMAX,KODERR) C E C ******************************************************************* E C *                                                                 * E C *  PROGRAM FOR ROBUST CIRCLE FITTING (FOR CONTAMINATED DATA)      *  C J C ************************************************************************J C *    From "Fast Program for Circle Fitting" by N.I. Chernov and        *J C *         G.A. Ososkov. TRIUMF PP 87-1408                              *J C *     Collection of Scientific Papers in Collaboration with Joint      *J C *     Institute for Nuclear Research, Dubna, USSR and Central Research *J C *     Institute for Physics, Budapest, Hungary.                        *J C *     Algorithms and Programs for solution of some problems in Physics *J C *                        Fifth Volume                                  *E C *                                                                 * E C *  INPUT DATA: N - THE NUMBER OF POINTS, X(I),Y(I) - THEIR        * E C *  COORDINATES, C - THE CONSTANT FOR TUKEY BIWEIGHT FORMULA       * E C *  (C<1), EPS - MAXIMAL ADMISSIBLE ACCURACY OF THE CIRCLE FIT-    * E C *  TING, ITMAX - MAXIMAL ADMISSIBLE ITERATION NUMBER (IF ITMAX=0  * E C *  THEN NO RESTRICTION FOR NUMBER OF ITERATIONS IS SUPPOSED).     * E C *                                                                 * E C *  OUTPUT DATA: A,B - THE COORDINATE OF THE CIRCLE CENTER,        * E C *  R - THE RADIUS, W(I) - THE WEIGHTS OF POINTS, R(I) - THE       * E C *  RESIDUAL VECTOR, VAR - THE ROBUST ESTIMATE OF VARIANCE.        * E C *            (RESOLD(N) IS AN INTERNAL ARRAY)                     * E C *                                                                 * E C *  FOR ROBUST FITTING A SMALL SIZE CIRCULAR ARC REPLACE THE       * E C *  CALL SUBROUTINE "CIRCLE" BY THE CALL SUBROUTINE "ARC" WITH     * E C *  THE CORRESPONDING PARAMETER SET.                               * E C *                                                                 * E C *  ERROR DIAGNOSTIC: KODERR=0 IF NO ERRORS HAVE BEEN DETECTED;    * E C *  KODERR=1,2 IF THE PROGRAM FOR CIRCLE FITTING FAILS - SEE       * E C *  THE MEANING OF KODERR IN THE CORRESPONDING PROGRAM TEXT.       * E C *                                                                 * E C *******************************************************************  C /       DIMENSION X(N),Y(N),W(N),RES(N),RESOLD(N)  C        IF (C.LT.1.) GOTO 6  C F C----------------- FIRST ITERATION: W(I)=1 FOR ALL I -----------------       ITER=1       DO 1 I=1,N
    1  W(I)=1.  C 7       CALL CIRCLE_CO(N,X,Y,W,A,B,R,VAR,RESOLD,0,KODERR)        IF (VAR.LT.1.E-10) GOTO 5  C G C--------------- PASS TO THE NEXT ITERATION ---------------------------     2  ITER=ITER+1 0 C          ----- RECALCULATE THE WEIGHTS -------       CVAR=C*SQRT(VAR)       DO 3 I=1,N          W(I)=0.+          IF (ABS(RESOLD(I)).GE.CVAR) GOTO 3 )          W(I)=(1.-(RESOLD(I)/CVAR)**2)**2     3  CONTINUE8 C          ----- RECALCULATE THE CIRCLE PARAMETERS ----- C 5       CALL CIRCLE_CO (N,X,Y,W,A,B,R,VAR,RES,0,KODERR) ,       IF (KODERR.EQ.1.OR.KODERR.EQ.2) GOTO 6       IF (VAR.LT.1.E-10) GOTO 5  C 7 C          ----- ESTIMATE THE SHIFT OF THE CIRCLE -----        DEL=0.       DO 4 I=1,ND          IF (DEL.LT.ABS(RES(I)-RESOLD(I))) DEL=ABS(RES(I)-RESOLD(I))          RESOLD(I)=RES(I)     4  CONTINUE2 C         ----- STOP THE ITERATIONAL PROCESS ----- C        IF (DEL.LT.EPS) GOTO 5.       IF (ITMAX.GT.0.AND.ITER.GE.ITMAX) GOTO 5       GOTO 2    5  KODERR=0    6  RETURN	       END 