5       SUBROUTINE SCALE1(XMIN,XMAX,N,XMINP,XMAXP,XINC)  C    C     reqd. routines - NONE G C====================================================================== G C==                                                                  == G C==   SCALE1:  Axis scaling routine.  Given XMIN, XMAX, and N        == G C==            SCALE1 finds a new range XMINP to XMAXP divisible     == G C==            into approximately N linear intervals of size         == G C==            XINC.  XMINP and XMAXP are integer multiples of       == G C==            XINC.                                                 == G C==                                                                  == G C==   Entered by Alan Carruthers, TRIUMF U.B.C, June 18, 1982        == G C==                                                                  == G C==   Source:  Algorithm 463                                         == G C==            Lewart, C. R.  1973.  Algorithms SCALE1, SCALE2,      == G C==              SCALE3 for determination of scales on computer      == G C==              generated plots.  Comm. ACM 16: 639-640             == G C==                                                                  == G C==                                                                  == G C==   Altered by Joe Chuma, February 13, 1984 to allow scaling       == G C==        when XMIN = XMAX, i.e. if XMIN = 0  then scale from -1    == G C==        to +1, if not = 0 then scale from 0 to twice value        == G C==                                                                  == G C==   Input  Parameters:  XMIN, XMAX,   (REAL*4)                     == G C==                       N             (INTEGER*4)                  == G C==                                                                  == G C==   Output Parameters:  XMINP, XMAXP, XINC   (REAL*4)              == G C==                                                                  == G C==   Parameter Definitions:                                         == G C==   ---------------------                                          == G C==                                                                  == G C==   XMIN   : Minimum of values that axis must encompass.           == G C==                                                                  == G C==   XMAX   : Maximum of values that axis must encompass.           == G C==                                                                  == G C==   N      : Requested number of axis intervals.                   == G C==                                                                  == G C==   XMINP  : Returned axis minimum.                                == G C==                                                                  == G C==   XMAXP  : Returned axis maximum.                                == G C==                                                                  == G C==   XINC   : Returned length of axis intervals.                    == G C==                                                                  == G C====================================================================== G C==                                                                  == G C====================================================================== G C==   VINT is an array of acceptable values for XINC (times an       == G C==   integer power of 10).                                          == G C==   SOR is an array of geometric means of adjacent values of       == G C==   VINT; SOR is used as break points to determine which value     == G C==   of VINT to assign to XINC.                                     == G C======================================================================        DIMENSION VINT(4), SOR(3)        DATA VINT /1.,2.,5.,10./+       DATA SOR /1.414214,3.162278,7.071068/ G C====================================================================== G C==   Check whether proper input supplied to SCALE1                  == G C====================================================================== .       IF(XMIN .LT. XMAX .AND. N .GT. 0)GOTO 10       IF(N .LE. 0.)THENN         WRITE(6,99999)E 99999   FORMAT(' *** SCALE1 *** Requested number of intervals <= 0.')=         RETURN       END IF       IF(XMIN .GT. XMAX)THEN         WRITE(6,999)3 999     FORMAT(' *** SCALE1 *** Minimum > maximum')          RETURN       END IF       IF(XMIN .EQ. XMAX)THEN         IF(XMIN .EQ. 0.)THEN           XMIN = -1.           XMAX = +1.!         ELSE IF(XMIN .LT. 0.)THENr           XMIN = 2.*XMIN           XMAX = 0.X         ELSE           XMIN = 0.u           XMAX = 2.*XMAX         END IF       END IFG C====================================================================== G C==   DEL accounts for computer roundoff.  DEL should be greater     == G C==   than the roundoff expected from a division and float           == G C==   operation, it should be less than the minimum increment of     == G C==   the plotting device used by the main program divided by        ==3G C==   the plot size times the number of intervals N.                 ==mG C======================================================================   10   DEL = .00002       FN = NG C====================================================================== G C==   Find approximate interval size A                               == G C======================================================================        A = (XMAX - XMIN) / FN       AL = ALOG10(A)       NAL = AL!       IF(A .LT. 1.) NAL = NAL - 1tG C====================================================================== G C==   A is scaled into variable B between 1 and 10                   ==:G C======================================================================        B = A / (10.**NAL)G C====================================================================== G C==   The closest permissible value for B is found                   ==EG C======================================================================        DO 20 I = 1,3 "          IF(B .LT. SOR(I)) GOTO 30  20   CONTINUE       I = 4 G C====================================================================== G C==   The interval size is computed                                  == G C====================================================================== !  30   XINC = VINT(I) * 10. ** NAL        FM1 = XMIN / XINC        M1 = FM1!       IF(FM1 .LT. 0.) M1 = M1 - 1u4       IF(ABS(FLOAT(M1)+1.-FM1) .LT. DEL) M1 = M1 + 1G C====================================================================== G C==   The new minimum and maximum limits are found                   == G C======================================================================N       XMINP = XINC * FLOAT(M1)       FM2 = XMAX / XINC        M2 = FM2 + 1. $       IF(FM2 .LT. (-1.)) M2 = M2 - 14       IF(ABS(FM2+1.-FLOAT(M2)) .LT. DEL) M2 = M2 - 1       XMAXP = XINC * FLOAT(M2)G C====================================================================== G C==   Adjust limits to account for roundoff if necessary             == G C====================================================================== &       IF(XMINP .GT. XMIN) XMINP = XMIN&       IF(XMAXP .LT. XMAX) XMAXP = XMAX       RETURN	       END 