?       SUBROUTINE SCALE2(XMIN,XMAX,N,XMINS,XMAXS,DIST,SVAL,NVAL)= C  = C     LIBRARY-ROUTINER CC= C                                                29/JULY/1980=> C                                                C.J. KOST SIN C  O C     reqd. routines - NONE, C=A C=================================================================A C=================================================================A C==                                                            == A C==   SCALE2: GIVEN XMIN AND XMAX (XMIN <= XMAX) AND N > 1, THE==4A C==          DESIRED RANGE AND NUMBER OF INTERVALS OF THE SCALE,==A C==          SCALE2 DETERMINES XMINS, XMAXS, AND DIST THE NEW  ==2A C==          RANGE AND INTERVAL OF THE SCALE. XMINS, XMAXS,    ==TA C==          AND DIST HAVE THE FOLLOWING PROPERTIES:           ===A C==                                                            == A C==          1) XMINS <= XMIN <= XMAX <= XMAXS = XMINS+N*DIST. == A C==          2) XMINS AND XMAXS ARE INTEGRAL MULTIPLES OF DIST.===A C==          3) DIST = SVAL(I)*10**M FOR SOME EXPONENT M, WHERE== A C==             1 <= I <= NVAL, AND SVAL(I) IS A NICE NUMBER   ===A C==             BETWEEN 1 AND 10 (1. <= SVAL(I) < 10.).        == A C==             (SEE BELOW FOR MORE ABOUT SVAL.)               == A C==                                                            ===A C==   ALGORITHM USED FOR SCALING IS FROM: PAGE 640 OF          ==IA C==   COMMUNICATIONS OF THE ACM, OCT. 1973, VOL. 16, NUMBER 10.===A C==                                                            == A C==   REWRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., SEPT 19, 1978.== A C==                                                            ===A C==   INPUT  PARAMETERS: XMIN,XMAX,N,SVAL,NVAL.                ===A C==                                                            ==SA C==   OUTPUT PARAMETERS: XMINS,XMAXS,DIST.                     == A C==                                                            ===A C==   XMIN  : (R*4) MINIMUM X-VALUE OF THE DESIRED RANGE OF THE==TA C==                 SCALE.                                     ==A C==   XMAX  : (R*4) MAXIMUM X-VALUE OF THE DESIRED RANGE OF THE== A C==                 SCALE.                                     == A C==   N     : (I*4) NUMBER OF SCALE INTERVALS, (N > 1).        == A C==   XMINS : (R*4) MINIMUM X-VALUE OF THE NEW SCALE.          == A C==   XMAXS : (R*4) MAXIMUM X-VALUE OF THE NEW SCALE.          == A C==   DIST  : (R*4) INTERVAL SIZE OF THE NEW SCALE (DIST > 0). ==A C==   SVAL  : (R*4) ARRAY OF NVAL                              ==SA C==                 "NICE" SCALE VALUES BETWEEN 1 & 10 IN      == A C==                 ASCENDING ORDER (1 <= SVAL(I) < 10,        == A C==                 SVAL(I) < SVAL(I+1)).                      == A C==   NVAL  : (I*4) NUMBER OF "NICE" SCALE                     == A C==                 VALUES IN SVAL. IF NVAL <= 0 THEN SCALE    == A C==                 USES ITS OWN DEFAULT SET OF "NICE" VALUES: == A C==                 1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8.        == A C==                                                            == A C================================================================TA C=================================================================B CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"       DIMENSION SVAL(1),SVALUE(10):       DATA SVALUE/1.0,1.2,1.5,2.0,2.5,3.0,4.0,5.0,6.0,8.0/       DATA NVALUE/10/E*       IF(XMIN.LE.XMAX.AND.N.GT.1) GO TO 30       WRITE(6,25)=C 25    FORMAT(' ***ERROR*** IN CALL TO SCALE2: XMIN MUST BE <= XMAX' !      *      ,' & N MUST BE > 1.')R       RETURNA C=================================================================A C==   FIND APPROXIMATE INTERVAL SIZE A.                        ==EA C================================================================( 30    XMAXX=XMAX-       IF(XMAXX.EQ.XMIN)XMAXX=XMIN+N*ABS(XMIN)E#       IF(XMAXX.EQ.XMIN)XMAXX=XMIN+N=       A=(XMAXX-XMIN)/N       NAL=ALOG10(A)S       IF (A.LT.1.) NAL=NAL-1A C================================================================ A C==   SCALE A INTO A VARIABLE B BETWEEN 1 AND 10 (1 <= B <= 10)==SA C================================================================        B=A/10.**NALA C================================================================ A C==   FIND THE CLOSEST "NICE" VALUE => B.                      ===A C=================================================================       DEL=.00002       IF(NVAL.GT.0)GO TO 50=       DO 40 I=1,NVALUE$       IF(B.LE.SVALUE(I)+DEL)GO TO 60 40    CONTINUE       GO TO 55 50    DO 52 I=1,NVAL"       IF(B.LE.SVAL(I)+DEL)GO TO 60 52    CONTINUE	 55    I=1M       NAL=NAL+1OA C================================================================SA C==   COMPUTE THE INTERVAL SIZE: DIST.                         ==,A C================================================================: 60    IF(NVAL.GT.0)GO TO 65        DIST=SVALUE(I)*10.**NAL        GO TO 68 65    DIST=SVAL(I)*10.**NAL=A C================================================================NA C==   FIND THE NEW MAXIMUM AND MINIMUM SCALE LIMITS:           ==SA C==   XMINS AND XMAXS.                                         ==<A C================================================================  68    FMIN=XMIN/DIST       MIN=FMIN       IF(FMIN.LT.0.)MIN=MIN-1W*       IF(ABS(MIN+1.-FMIN).LE.DEL)MIN=MIN+1       XMINS=MIN*DIST       FMAX=XMAXX/DIST        MAX=FMAX       IF(FMAX.GT.0.)MAX=MAX+1A*       IF(ABS(MAX-1.-FMAX).LE.DEL)MAX=MAX-1       XMAXS=MAX*DISTA C================================================================ A C==   CHECK WHETHER ANOTHER PASS IS REQUIRED                   == A C================================================================        NS=MAX-MIN       IF(NS.LE.N)GO TO 80        I=I+1M       IF(NVAL.GT.0)GO TO 70        IF(I.LE.NVALUE)GO TO 60        GO TO 55 70    IF(I.LE.NVAL)GO TO 60        GO TO 55 80    ND=(N-NS)/2X       XMINS=XMINS-ND*DIST )       IF(XMIN.GE.0.)XMINS=AMAX1(XMINS,0.)        XMAXS=XMINS+N*DIST*       IF(XMAXX.LE.0.)XMAXS=AMIN1(XMAXS,0.)       XMINS=XMAXS-N*DISTA C================================================================ A C==   ADJUST LIMITS TO ACCOUNT FOR ROUND-OFF IF NECESSARY.     ==OA C================================================================ !       IF(XMINS.GT.XMIN)XMINS=XMINR#       IF(XMAXS.LT.XMAXX)XMAXS=XMAXX=       RETURN	       ENDI