:       SUBROUTINE SCALE4(XLOW,XUPR,XINC,LENXIS,NTBL,NCBT,*) C    C     reqd. routines - NONE G C====================================================================== G C==                                                                  == G C==   SCALE4: An axis scaling routine                                == G C==                                                                  == G C==   Written by Corrie Kost, TRIUMF U.B.C., June 18, 1982           == G C==                                                                  == G C==   Input  Parameters:  XLOW, XUPR, XINC,    (REAL*4)              == G C==                       LENXIS, NTBL         (INTEGER*4)           == G C==                                                                  == G C==   Output Parameters:  XLOW, XUPR,          (REAL*4)              == G C==                       LENXIS, NCBT         (INTEGER *4)          == G C==                                                                  == G C==   Error Return 1   :  An alternate return occurs whenever        == G C==                       LENXIS is unreasonably small in relation   == G C==                       to XINC or NTBL (i.e. whenever the         == G C==                       calculated number of screen cells          == G C==                       between ticks would be less than 1         == G C==                       (NCBT < 2)).                               == G C==                                                                  == G C==   Parameter Definitions:                                         == G C==   ---------------------                                          == G C==                                                                  == G C==     XLOW   :  Minimum value that axis must include.              == G C==               Reset by SCALE4 to axis minimum.                   == G C==                                                                  == G C==     XUPR   :  Maximum value that axis must include.              == G C==               Reset by SCALE4 to axis maximum.                   == G C==                                                                  == G C==     XINC   :  Increment (between labels).                        == G C==                                                                  == G C==     LENXIS :  Length of axis (number of cells).                  == G C==               Adjusted slightly by SCALE4 to accomodate          == G C==               specified XINC.                                    == G C==                                                                  == G C==     NTBL   :  (NTBL - 1) = Number of ticks between labels        == G C==               (exclusive of labels).  NTBL > 0  !!               == G C==                                                                  == G C==     NCBT   :  (NCBT - 1) = Number of cells between ticks         == G C==               (exclusive of ticks).                              == G C==                                                                  == G C======================================================================        XCOR = 0. $       IF(XLOW .LT. 0.) XCOR = -.9999       NLOW = XLOW / XINC + XCOR        XCOR = 0. #       IF(XUPR .GT. 0.) XCOR = .9999        NUPR = XUPR / XINC + XCOR        XLOW = NLOW * XINC       XUPR = NUPR * XINC       NINC = NUPR - NLOW#       NCBT = LENXIS / (NINC * NTBL) G C====================================================================== G C==   Take error return if NCBT < 2                                  == G C======================================================================        IF(NCBT .LT. 2) RETURN 1!       LENXIS = NCBT * NTBL * NINC        RETURN	       END 