7       SUBROUTINE SCAN(INPUT,NINPUT,IFIRST,ILAST,ISTATE, 1      *                CLASS,CTABLE,STABLE,NSTATE) A C================================================================ A C================================================================ A C==                                                            == A C==   SCAN: PERFORMS A LEXICAL SCAN OF THE "INPUT" ARRAY,      == A C==         STARTING AT THE "IFIRST" LOCATION IN "INPUT", USING== A C==         THE TRANSITION TABLE "STABLE(NSTATE,NCLASS)".      == A C==         THE TOKEN WHICH SCAN RETURNS LIES WITHIN THE       == A C==         LOCATIONS "IFIRST" AND "ILAST" OF "INPUT".         == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., JANUARY 3, 1980.== A C==                                                            == A C==   INPUT  PARAMETERS: INPUT(NINPUT) (L*1,I*2,I*4,R*4,OR R*8);= A C==                      NINPUT,IFIRST,NSTATE (I*4);           == A C==                      CLASS (EXTERNAL SUBROUTINE);          == A C==                      CTABLE (USUALLY A 256 I*2 ARRAY);     == A C==                      STABLE(NSTATE,NCLASS) (I*2).          == A C==                                                            == A C==   OUTPUT PARAMETERS: ILAST,ISTATE (I*4).                   == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   INPUT : A L*1,I*2,I*4,R*4, OR R*8 ARRAY OF ELEMENTS TO BE== A C==           SCANNED FOR TOKENS (OR TERMS).                   == A C==                                                            == A C==   NINPUT: NUMBER OF ELEMENTS TO BE SCANNED IN "INPUT".     == A C==                                                            == A C==   IFIRST: FIRST LOCATION IN "INPUT" AT WHICH THE SCAN IS TO== A C==           START.                                           == A C==                                                            == A C==   ILAST : LAST LOCATION IN "INPUT" AT WHICH THE SCAN IS    == A C==           TERMINATED. THE TOKEN RETURNED BY SCAN LIES      == A C==           WITHIN THE LOCATIONS "IFIRST" AND "ILAST" OF     == A C==           "INPUT".                                         == A C==                                                            == A C==   ISTATE: OUTPUT STATE RETURNED BY SCAN WHICH CORRESPONDS  == A C==           TO THE TYPE OF TOKEN RETURNED. SEE "STABLE".     == A C==                                                            == A C==   CLASS : EXTERNAL CLASS SUBROUTINE WHICH TAKES AN ACTION  == A C==           ON EACH STATE "ISTATE" ENCOUNTERED DURING THE    == A C==           LEXICAL SCAN AND WHICH RETURNS THE CLASS "ICLASS"== A C==           OF THE NEXT ELEMENT IN "INPUT". THE SUBROUTINE   == A C==           CLASS HAS THE FOLLOWING ARGUMENTS:               == A C==                                                            == A C==           CALL CLASS(INPUT,NINPUT,ILAST,ISTATE,NSTATE,     == A C==          * CTABLE,ICLASS,RETURN)                           == A C==                                                            == A C==           WHERE "INPUT" AND "NINPUT" ARE INPUT             == A C==           PARAMETERS DEFINED ABOVE, "ILAST" IS AN          == A C==           I/O PARAMETER WHICH KEEPS TRACK OF THE CURRENT   == A C==           ELEMENT IN "INPUT" BEING SCANNED (ON INPUT TO    == A C==           "CLASS" "ILAST" IS ASSUMED TO POINT TO THE LAST  == A C==           ELEMENT LOOKED AT BY "CLASS"; "CLASS" WILL THEN  == A C==           USUALLY INCREMENT "ILAST" BY 1 AND RETURN THE    == A C==           CLASS "ICLASS" OF THE ELEMENT POINTED TO BY      == A C==           "ILAST"), "ISTATE" IS AN INPUT PARAMETER WHICH   == A C==           TELLS "CLASS" THE CURRENT STATE OF THE SCAN, AND == A C==           ON OCCASION IF "ISTATE" IS AN ACTION STATE ON    == A C==           INPUT TO "CLASS" THEN "CLASS" MAY CHANGE "ISTATE"==NA C==           AND RETURN IT AS AN OUTPUT PARAMETER,            ==EA C==           "NSTATE" AND "CTABLE" ARE INPUT PARAMETERS       ===A C==           DEFINED BELOW,                                   ===A C==           "ICLASS" IS AN OUTPUT PARAMETER WHICH IS THE CLASS= A C==           OF THE NEXT ELEMENT IN "INPUT", AND "RETURN" IS  =="A C==           A L*1 OUTPUT FLAG WHICH TELLS "SCAN" TO RETURN   =="A C==           IF IT IS ".TRUE.".                               ==CA C==                                                            ==HA C==   CTABLE: IS USUALLY AN INTEGER*2 CLASS TABLE "CTABLE(256)".=PA C==           IF "CHAR" IS A CHARACTER (1 BYTE) THEN IT HAS A  == A C==           NUMERIC VALUE "ICHAR" IN THE RANGE               ==NA C==           0 <= "ICHAR" <= 255 AND ITS CLASS NUMBER IS      == A C==           GIVEN BY "CTABLE(ICHAR+1)".                      ==*A C==                                                            ==4A C==   STABLE: LEXICAL SCANNER TRANSITION TABLE DIMENSIONED AS: ==NA C==           STABLE(NSTATE,NCLASS) WHERE "NSTATE" IS THE NUMBER=2A C==           OF TRANSITION STATES AND "NCLASS" IS THE NUMBER  ==*A C==           OF "INPUT" ELEMENT CLASSES.                      == A C==           IF 1 <= "STABLE(ISTATE,ICLASS)" <= NSTATE THEN IT== A C==           IS A TRANSITION STATE.                           == A C==           IF "STABLE(ISTATE,ICLASS)" < 1 THEN IT IS AN     == A C==           OUTPUT STATE AND THE SCAN POINTER "ILAST" IS     == A C==           SHIFTED BY "CLASS" BACK BY 1.                    == A C==           IF "STABLE(ISTATE,ICLASS)" > NSTATE THEN IT IS AN==EA C==           OUTPUT STATE AND THE SCAN POINTER IS NOT CHANGED.== A C==           THE VALUE OF THE OUTPUT STATE IS RETURNED BY     == A C==           "SCAN" IN "ISTATE".                              == A C==                                                            == A C==   NSTATE: NUMBER OF TRANSITION STATES.                     ==TA C==                                                            == A C==   ALGORITHM USED BY "SCAN":                                == A C==   --------- ---- -- ------                                 ==HA C==                                                            ==CA C==   1) ILAST  <-- IFIRST - 1                                 ==IA C==                                                            == A C==   2) ISTATE <-- 1                                          == A C==                                                            == A C==   3) IF "ISTATE" IS AN OUTPUT STATE THEN RETURN.           =="A C==      IF "ISTATE" IS AN ACTION STATE THEN PERFORM THE ACTION.= A C==                                                            ==EA C==   4) ILAST  <-- ILAST + 1                                  ==DA C==                                                            ==CA C==   5) ICLASS <-- CLASS("INPUT(ILAST)")                      == A C==                                                            == A C==   6) ISTATE <-- STABLE(ISTATE,ICLASS)                      == A C==                                                            ==EA C==   7) GO TO 3).                                             == A C==                                                            == A C==   REQD. ROUTINES - NONE                                    ==TA C================================================================SA C================================================================T        INTEGER*2 STABLE(NSTATE,1)       LOGICAL*1 RETURN       ILAST=IFIRST-1       ISTATE=12 10    CALL CLASS(INPUT,NINPUT,ILAST,ISTATE,NSTATE,&      *           CTABLE,ICLASS,RETURN)       IF(RETURN)RETURN"       ISTATE=STABLE(ISTATE,ICLASS)       GO TO 10	       ENDR