B       SUBROUTINE SCATP(X,Y,Z,NX,NY,NX1,XLAB,NXLAB,YLAB,NYLAB,XFMT,@      *                 YFMT,ZFMT,TITLE,NTITLE,ITYPE,ZMAX,NWIDTH,2      *                 IOUT,IEMPTY,DIGITS,NDIGS,*)A C================================================================ A C================================================================ A C==                                                            == A C==   SCATP: SCATTERPLOTS THE NX * NY BIN COUNTS STORED IN "Z" == A C==   AGAINST THE HORIZONTAL "X" AXIS VALUES AND THE VERTICAL  == A C==   "Y" AXIS VALUES. "Z(I,J)" IS THE NUMBER OF BIN COUNTS AT == A C==   THE LOCATION WITH COORDINATES: (X(I),Y(J)).              == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., NOV. 17, 1978.  == A C==                                                            == A C==   INPUT PARAMETERS:                                        == A C==   X(NX),Y(NY),Z(NX1,NY),ZMAX (R*4); NX,NY,NX1,NXLAB,NYLAB, == A C==   NTITLE,ITYPE,NWIDTH,IOUT,IEMPTY,NVAL,NDIGS (I*4);        == A C==   XLAB(NXLAB),YLAB(NYLAB),XFMT,YFMT,ZFMT,TITLE(NTITLE),    == A C==   DIGITS(NDIGS) (L*1).                                     == A C==                                                            == A C==   OUTPUT PARAMETERS: NONE.                                 == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   X     : ARRAY OF "NX" HORIZONTAL X-AXIS VALUES.          == A C==           THE "X" VALUES CAN BE POSITIVE, NEGATIVE OR ZERO,== A C==           AND THEY DO NOT HAVE TO BE IN ANY ORDER.         == A C==           IF NX < 0 THEN X(I) IS ASSUMED TO BE AN EQUALLY  == A C==           SPACED ARRAY WITH |NX| VALUES GIVEN BY:          == A C==           X(I) = X(1)+(I-1)*X(2), I=1,...,|NX|. NOTE: WHEN == A C==           NX < 0 THEN ONLY THE FIRST 2 ELEMENTS OF "X" ARE == A C==           USED. THERE IS NO LIMIT TO THE ARRAY SIZE |NX|;  == A C==           THE SCATTERPLOT X-BINS WILL BE PRINTED ACROSS AS == A C==           MANY PAGES AS NECESSARY. SEE "PARAMETER          == A C==           RESTRICTIONS AND FORMULAS" FOR THE MAXIMUM NUMBER== A C==           OF X-BINS PER PAGE.                              == A C==                                                            == A C==   Y     : ARRAY OF "NY" VERTICAL Y-AXIS VALUES.            == A C==           THE "Y" VALUES CAN BE POSITIVE, NEGATIVE OR ZERO,== A C==           AND THEY DO NOT HAVE TO BE IN ANY ORDER.         == A C==           IF NY < 0 THEN Y(I) IS ASSUMED TO BE AN EQUALLY  == A C==           SPACED ARRAY WITH |NY| VALUES GIVEN BY:          == A C==           Y(I) = Y(1)+(I-1)*Y(2), I=1,...,|NY|. NOTE: WHEN == A C==           NY < 0 THEN ONLY THE FIRST 2 ELEMENTS OF "Y" ARE == A C==           USED. THERE IS NO LIMIT TO THE ARRAY SIZE |NY|;  == A C==           THE SCATTERPLOT Y-BINS WILL BE PRINTED DOWN AS   == A C==           MANY PAGES AS NECESSARY.                         == A C==                                                            == A C==   Z     : ARRAY OF |NX| * |NY| BIN COUNTS TO BE SCATTER-   == A C==           PLOTTED AGAINST THE HORIZONTAL "X" AXIS VALUES   == A C==           AND THE VERTICAL "Y" AXIS VALUES. "Z(I,J)" IS THE== A C==           NUMBER OF BIN COUNTS AT THE LOCATION WITH        == A C==           COORDINATES: (X(I),Y(J)).                        == A C==                                                            == A C==   NX    : |NX| IS THE NUMBER OF X-AXIS BIN VALUES.         == A C==                                                            == A C==   NY    : |NY| IS THE NUMBER OF Y-AXIS BIN VALUES.         == A C==                                                            == A C==   NX1   : IS THE FIRST DIMENSION OF THE Z-ARRAY.           == A C==           NX1 IS ALWAYS => |NX|.                           == A C==                                                            == A C==   XLAB  : X-AXIS LABEL CONSISTING OF "NXLAB" CHARACTERS.   == A C==                                                            == A C==   NXLAB : NUMBER OF CHARACTERS IN "XLAB".                  == A C==                                                            == A C==   YLAB  : Y-AXIS LABEL CONSISTING OF "NYLAB" CHARACTERS.   == A C==                                                            == A C==   NYLAB : NUMBER OF CHARACTERS IN "YLAB".                  == A C==                                                            == A C==   XFMT  : FORMAT OF THE X-AXIS (HORIZONTAL) VALUES.        == A C==           EG. XFMT = '(I5)' OR '(F10.3)' OR '(E12.5)' OR   == A C==           '(G11.5)'. NOTE: THE X ARRAY IS ALWAYS ASSUMED TO== A C==           BE REAL EVEN WHEN THE FORMAT IS INTEGER FORMAT.  == A C==                                                            == A C==   YFMT  : FORMAT OF THE Y-AXIS (HORIZONTAL) VALUES.        == A C==           EG. YFMT = '(I5)' OR '(F10.3)' OR '(E12.5)' OR   == A C==           '(G11.5)'. NOTE: THE Y ARRAY IS ALWAYS ASSUMED TO== A C==           BE REAL EVEN WHEN THE FORMAT IS INTEGER FORMAT.  == A C==                                                            == A C==   ZFMT  : FORMAT OF THE X AND Y PROJECTIONS OF THE SCATTER-== A C==           PLOT BIN COUNTS.                                 == A C==                                                            == A C==           IF ITYPE <= 1 THEN THIS IS THE ONLY FORMAT       == A C==           REQUIRED; EG. ZFMT = '(I4)' OR '(F8.2)' OR       == A C==           '(D10.4)' OR '(E11.5)' OR '(G11.4)'.             == A C==                                                            == A C==           IF ITYPE => 2 THEN THIS FORMAT CODE MAY BE       == A C==           FOLLOWED BY A SECOND CODE WHICH IS THE FORMAT OF == A C==           THE BIN COUNTS WHICH ARE TO BE PRINTED ON THE    == A C==           SCATTERPLOT; EG. ZFMT = '(I4)(I3)' OR '(I4) ' OR == A C==           '(E11.3)(F7.3)' OR '(F10.5) '. NOTE: IN THIS CASE== A C==           IF THE 2'ND Z-FORMAT CODE IS NOT SPECIFIED THEN  == A C==           IT WILL BY DEFAULT EQUAL THE 1'ST Z-FORMAT CODE  == A C==           AND THE 1'ST Z-FORMAT CODE MUST BE FOLLOWED BY AT== A C==           LEAST ONE BLANK.                                 == A C==                                                            == A C==           NOTE: THE 2-DIMENSIONAL Z ARRAY IS ALWAYS ASSUMED== A C==           TO BE REAL EVEN WHEN THE FORMAT IS INTEGER       == A C==           FORMAT.                                          == A C==                                                            == A C==           NOTE:                                            == A C==           WHEN ITYPE <= 1 THEN THE SCATTERPLOT IS A        == A C==           "CHARACTER SCATTERPLOT", I.E. EACH BIN COUNT IS  == A C==           REPRESENTED BY 1 CHARACTER AND HENCE THE NUMBER  == A C==           OF CHARACTERS PER BIN = 1.                       == A C==           WHEN ITYPE => 2 THEN THE SCATTERPLOT IS A        == A C==           "NUMBER SCATTERPLOT", I.E. EACH BIN COUNT IS     == A C==           PRINTED AS A FORMATTED NUMBER USING THE 2'ND     == A C==           Z FORMAT CODE IN "ZFMT". IF THE FORMAT CODE IS   == A C==           "I" OF "F" TYPE THEN THE NUMBER OF CHARACTERS PER== A C==           BIN = ZWIDTH2 (THE 2'ND Z FORMAT WIDTH). IF THE  == A C==           FORMAT CODE IS "E", "D", OR "G" TYPE THEN        == A C==           THEN THE NUMBER OF CHARACTERS PER BIN = ZWIDTH2  == A C==           + 1, I.E. EACH BIN COUNT NUMBER IS PRINTED IN A  == A C==           A FORMAT FIELD WITH WIDTH "ZWIDTH2" AND THESE    == A C==           FIELDS ARE SEPARATED BY SINGLE BLANKS.           == A C==                                                            == A C==           NOTE: "XFMT", "YFMT", AND "ZFMT" MUST NOT HAVE   == A C==                 ANY IMBEDDED BLANKS.                       == A C==           NOTE: A USEFUL SUBROUTINE FOR DETERMINING THE    == A C==                 FORMAT CODES "XFMT", "YFMT", AND "ZFMT"    == A C==                 GIVEN THE MINIMUM AND MAXIMUM X, Y, AND Z  == A C==                 VALUES IS: "FORMTS".                       == A C==                                                            == A C==   TITLE : SCATTERPLOT TITLE CONSISTING OF "NTITLE"         == A C==           CHARACTERS. NOTE: THE TITLE IS PRINTED OUT       == A C==           STARTING AT THE FIRST COLUMN OF THE PAGE AND THE == A C==           1'ST CHARACTER OF "TITLE" IS TREATED AS A        == A C==           CARRIAGE CONTROL.                                == A C==                                                            == A C==   NTITLE: THE NUMBER OF CHARACTERS IN "TITLE".             == A C==                                                            == A C==   ITYPE : THERE ARE 2 TYPES OF SCATTERPLOTS:               == A C==                                                            == A C==           IF ITYPE <= 1 THEN THE SCATTERPLOT IS A          == A C==           "CHARACTER SCATTERPLOT", I.E. IT PLOTS THE BINS  == A C==           USING THE SINGLE CHARACTERS: "-", " ", "0-9",    == A C==           "A-Z", "+". (THIS CHARACTER SET CAN BE CHANGED BY== A C==           USING "DIGITS" & "NDIGS", SEE BELOW). A "-"      == A C==           SIGNIFIES NEGATIVE COUNTS, A " " SIGNIFIES NO    == A C==           COUNTS, A "0-9" SIGNIFIES 0 - 9 COUNTS, AN "A-Z" == A C==           SIGNIFIES 10 - 35 COUNTS, AND A "+" SIGNIFIES A  == A C==           BIN OVERFLOW GREATER THAN 35. ALL BIN COUNTS ARE == A C==           ROUNDED OFF TO THE NEAREST INTEGER. (THE         ==,A C==           DIFFERENCE BETWEEN " " AND "0" IS THAT " "       ==LA C==           DENOTES AN ABSOLUTE ZERO, WHILE "0" DENOTES      ==GA C==           POSITIVE COUNTS ROUNDED OFF TO ZERO, I.E. COUNTS ===A C==           > .5).                                           ===A C==                                                            == A C==           IF ITYPE => 2 THEN THE SCATTERPLOT IS A "NUMBER  =="A C==           SCATTERPLOT", I.E. EACH BIN COUNT IS PRINTED AS  == A C==           A FORMATTED NUMBER USING THE 2'ND Z FORMAT CODE  ==TA C==           "ZFMT". THIS KIND OF SCATTERPLOT PRINTS NEGATIVE == A C==           BIN COUNTS UNLIKE THE "ITYPE <= 1" TYPE WHICH    == A C==           USES A "-" TO DENOTE NEGATIVE COUNTS.            == A C==                                                            == A C==   ZMAX  : THERE ARE 2 CASES DEPENDING ON "ITYPE":          == A C==                                                            ==,A C==           IF ITYPE <= 1, THEN "ZMAX" CONTROLS THE AUTOMATIC== A C==           SCALING OF THE POSITIVE BIN COUNTS OF THE        == A C==           "CHARACTER SCATTERPLOT". NEGATIVE BIN COUNTS ARE == A C==           IGNORED IN THE SCALING AND ARE PRINTED ON THE    == A C==           PLOT AS "-"'S. IF "ZMAX" IS POSITIVE THEN THE BIN== A C==           COUNTS ARE SCALED DOWN BY A WHOLE NUMBER, TO BE  == A C==           LESS THAN OR EQUAL TO "ZMAX". NOTE: THIS SCALING == A C==           IS NOT DONE IF ALL THE COUNTS ARE ALREADY LESS   == A C==           THAN OR EQUAL TO "ZMAX". IF "ZMAX" IS ZERO THEN  == A C==           THE BIN COUNTS ARE NOT SCALED, AND ANY OVERFLOWS == A C==           ARE DENOTED BY "+" (THIS CHARACTER CAN BE CHANGED== A C==           BY USING "DIGITS" & "NDIGS", SEE BELOW). IF      == A C==           "ZMAX" IS NEGATIVE THEN THE BIN COUNTS ARE       == A C==           SCALED UP OF DOWN BY A WHOLE NUMBER, TO BE LESS  == A C==           THAN OR EQUAL TO |ZMAX|, AND SO THAT THE MAXIMUM == A C==           COUNT IS AS CLOSE AS POSSIBLE TO |ZMAX|. NOTE:   == A C==           IN THIS CASE THE COUNTS MAY BE SCALED UP EVEN    == A C==           WHEN THEY ARE ALL LESS THAN |ZMAX|.              == A C==           NOTE: FOR ITYPE <= 1, ONE USUALLY CHOOSES        == A C==                 ZMAX = 35.0, WHICH CORRESPONDS WITH THE    == A C==                 MAXIMUM BIN CHARACTER "Z".                 == A C==                                                            == A C==           IF ITYPE => 2, THEN "ZMAX" CONTROLS THE AUTOMATIC== A C==           SCALING OF BOTH NEGATIVE AND POSITIVE COUNTS OF  == A C==           THE "NUMBER SCATTERPLOT". IF "ZMAX" IS POSITIVE  == A C==           THEN THE BIN COUNTS ARE SCALED DOWN BY A WHOLE   == A C==           NUMBER, SO THAT THEIR MAGNITUDES ARE LESS THAN OR== A C==           EQUAL TO "ZMAX". NOTE: THIS SCALING IS NOT DONE  == A C==           IF THE MAGNITUDES OF ALL THE COUNTS ARE ALREADY  == A C==           LESS THAN OR EQUAL TO "ZMAX". IF "ZMAX" IS ZERO  == A C==           THEN THE BIN COUNTS ARE NOT SCALED, AND ANY      == A C==           FORMAT ("ZFMT") OVERFLOWS APPEAR AS "*"'S. IF    == A C==           "ZMAX" IS NEGATIVE THEN THE BIN COUNTS ARE SCALED== A C==           UP OR DOWN BY A WHOLE NUMBER, SO THAT THEIR      == A C==           MAGNITUDES ARE LESS THAN OR EQUAL TO |ZMAX|, AND == A C==           SO THAT THE MAXIMUM MAGNITUDE IS AS CLOSE AS     == A C==           POSSIBLE TO |ZMAX|. NOTE: IN THIS CASE THE COUNTS== A C==           MAY BE SCALED UP EVEN WHEN ALL OF THEIR          == A C==           MAGNITUDES ARE LESS THAN OR EQUAL TO |ZMAX|.     == A C==           NOTE: FOR ITYPE => 2, ONE USUALLY CHOOSES "ZMAX" == A C==                 SO THAT "-|ZMAX|" WILL FIT IN THE "ZFMT"   == A C==                 FORMAT FIELD. EG. A GOOD CHOICE FOR "ZFMT" == A C==                 = '(I4)(I3)' WOULD BE "ZMAX" = 99, BECAUSE == A C==                 "-99" FITS INTO AN "I3" FORMAT FIELD.      == A C==                                                            == A C==   NWIDTH: MAXIMUM WIDTH OF THE SCATTERPLOT PRINT PAGE IN   == A C==           CHARACTERS. EG. NWIDTH =132 WILL GIVE THE FULL   == A C==           PRINTER PAGE.                                    == A C==                                                            == A C==   IOUT  : OUTPUT UNIT ON WHICH THE SCATTERPLOT IS PRINTED. == A C==           ERROR MESSAGES ARE ALSO PRINTED ON THIS UNIT.    == A C==                                                            == A C==   IEMPTY: FLAG INDICATING WHETHER OR NOT TO PRINT EMPTY    == A C==           PAGES OF THE SCATTERPLOT ONTO THE PRINTER. IF    == A C==           IEMPTY = 1 THEN EMPTY SCATTERPLOT PAGES WILL NOT == A C==           BE PRINTED, OTHERWISE THEY WILL BE PRINTED.      == A C==                                                            == A C==   DIGITS: IS USED TO CHANGE THE DIGITS OR CHARACTERS USED  == A C==           TO PLOT A "CHARACTER SCATTERPLOT" WHEN           == A C==           ITYPE <= 1. DIGITS IS AN                         == A C==           ARRAY OF "NDIGS" CHARACTERS WHICH WHEN SPECIFIED == A C==           OVERLAY THE DEFAULT "NDIG" = 39 CHARACTERS STORED== A C==           IN THE INTERNAL ARRAY "DIGIT". THE DEFAULT       == A C==           CHARACTERS STORED IN "DIGIT" ARE AS FOLLOWS:     == A C==           "- 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ+".       == A C==           NOTE: THE INTERNAL ARRAY "DIGIT" IS NOT ACTUALLY == A C==           WIPED OUT BY THE OVERLAY; THE OVERLAY IS ONLY    == A C==           PERFORMED LOGICALLY.                             == A C==                                                            == A C==           FOR PURPOSES OF DISCUSSION WE DEFINE "MDIGIT" TO == A C==           BE AN ARRAY CONTAINING THE RESULT OF OVERLAYING  == A C==           "DIGITS" ONTO "DIGIT". THE TOTAL NUMBER OF       == A C==           CHARACTERS IN "MDIGIT" IS "MAXDIG" =             == A C==           MAX(NDIG,NDIGS). "MDIGIT" IS USED IN THE         == A C==           FOLLOWING WAY:                                   == A C==                                                            == A C==           MDIGIT(1): IS THE CHARACTER USED TO DENOTE       == A C==                      NEGATIVE BIN COUNTS.                  == A C==                                                            == A C==           MDIGIT(2): IS THE CHARACTER USED TO DENOTE       == A C==                      ABSOLUTE 0 COUNTS, (AS OPPOSED TO     == A C==                      COUNTS ROUNDED OFF TO 0).             == A C==                                                            == A C==           MDIGIT(3)                                        == A C==         - MDIGIT(MAXDIG-1): DENOTE 0 - MAXDIG-4 COUNTS.    == A C==                                                            == A C==           MDIGIT(MAXDIG): DENOTES A BIN OVERFLOW.          == A C==                                                            == A C==   NDIGS:  NUMBER OF CHARACTERS IN "DIGITS". IF NDIGS <= 0  == A C==           THEN "DIGITS" IS NOT USED AND THE DEFAULT DIGITS == A C==           WHICH ARE USED INSTEAD ARE THE 39 CHARACTERS:    == A C==           "- 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ+".       == A C==                                                            == A C==                                                            == A C==   PARAMETER RESTRICTIONS AND FORMULAS:                     == A C==   --------- ------------ --- --------                      == A C==                                                            == A C==   NOTE:                                                    == A C==                                                            == A C==   DEFINITIONS:                                             == A C==   XWIDTH  = FORMAT WIDTH OF X FORMAT IN "XFMT".            == A C==   YWIDTH  = FORMAT WIDTH OF Y FORMAT IN "YFMT".            == A C==   ZWIDTH1 = FORMAT WIDTH OF 1'ST Z FORMAT CODE IN "ZFMT".  == A C==   ZWIDTH2 = NUMBER OF CHARACTERS PER BIN;                  == A C==           = 1, IF ITYPE <= 1;                              == A C==           = FORMAT WIDTH OF 2'ND Z FORMAT CODE IN "ZFMT",  ===A C==             IF ITYPE => 2 AND FORMAT IS "I" OR "F" TYPE;   ===A C==           = FORMAT WIDTH + 1 OF 2'ND Z FORMAT CODE IN      ===? C==             "ZFMT", IF ITYPE => 2 AND FORMAT IS "E", "D",== A C==             OR "G" TYPE, (I.E. FOR "E","D", OR "G" TYPE    == A C==             FORMAT CODES THERE IS AN EXTRA SPACE USED TO   == A C==             SEPARATE THE BIN COUNT FIELDS, WHILE FOR "I" OR== A C==             "F" TYPE FORMAT CODES THERE IS NO SEPARATOR).  == A C==                                                            ===A C==   RETURN1:                                                 ===A C==   AN ERROR RETURN FROM "SCATP" CONSISTS OF AN ERROR MESSAGE===A C==   PRINTED ON UNIT "IOUT" INDICATING THE ERROR AND A RETURN1===A C==   TO THE CALLING PROGRAM.                                  ===A C==                                                            ===A C==   IN EACH OF THE FOLLOWING RESTRICTIONS THE STATEMENT IN   ===A C==   PARENTHESES TELLS WHAT WILL HAPPEN IF THE RESTRICTION IS ===A C==   VIOLATED.                                                ===A C==                                                            ===A C==   1) 11 <= NWIDTH <= 132, ("NWIDTH" IS TRUNCATED TO THESE  ===A C==      LIMITS USING AN INTERNAL VARIABLE NWID=TRUNC(NWIDTH), ===A C==      HOWEVER, THE VARIABLE "NWIDTH" IS NOT TAMPERED WITH). ===A C==   2) 1 <= XWIDTH <= 132, (ERROR RETURN).                   ===A C==   3) 1 <= YWIDTH,        (ERROR RETURN).                   ===A C==   4) 1 <= ZWIDTH1,       (ERROR RETURN).                   ===A C==   5) 1 <= ZWIDTH2,       (ERROR RETURN).                   ===A C==   6) YWIDTH+ZWIDTH1+ZWIDTH2 <= NWIDTH - 8, (ERROR RETURN). ===A C==   7) MAXIMUM NUMBER OF X-BINS/PAGE                         ===A C==      = (NWIDTH-8-YWIDTH-ZWIDTH1)/ZWIDTH2,                  ===A C==      DUE TO THE ABOVE RESTRICTIONS THIS WILL ALWAYS BE > 0.===A C==   8) |NX|*|NY| > 0, (ERROR RETURN).                        ===A C==   9) NX1 > 0,       (ERROR RETURN).                        ===A C==  10) IF NXLAB  <= 0 THEN XLAB WILL NOT BE USED.            ===A C==      IF NYLAB  <= 0 THEN YLAB WILL NOT BE USED.            ===A C==      IF NTITLE <= 0 THEN TITLE WILL NOT BE USED.           ===A C==      IF NDIGS  <= 0 THEN DIGITS WILL NOT BE USED.          ===A C==                                                            ===A C=================================================================A C=================================================================A C=================================================================A C============   USEFUL NOTES & COMMENTS ON SUBROUTINE USAGE ======A C== CARE SHOULD BE TAKEN THAT THE CALLING PARAMETERS MATCH     ===A C== IN TYPE WITH THOSE OF THIS SUBROUTINE. PARTICULARLY THAT   ===A C== CHARACTER STRINGS ARE INPUT AS LOGICAL*1 NOT AS "CHARACTER"===A C== DECLARED TYPES VARIABLES. QUOTE STRING HOLLERITH CONSTANTS ===A C== AS ACTUAL ARGUMENTS OF A CALL ARE ALSO ALLOWED.            ===A C==                                                            ===A C==     NOTE ON "CONTOUR" PRINTER PLOTTING.                    ===A C==                                                            ===A C==   TO CONTOUR PLOT AN ARRAY ON THE LINE PRINTER THE USER    ===A C==   SHOULD FIRST SCALE HIS Z(NX,NY) ARRAY BETWEEN 0 AND      ===A C==   THE MAXIMUM NUMBER OF USER SPECIFIED DIGITS ("NDIGS") -2 ===A C==   THE FOLLOWING SET OF DIGITS IS RECOMMENDED FOR CASE      ===A C==   NDIGS=12     '- 0 2 4 6 8 '                              ===A C==   THIS WILL GIVE ALTERNATING BLANK CONTOUR "BANDS"         ===A C==                                                            ===A C=================  SAMPLE OF ABOVE USE  =========================: C========================================================= C 6 C    SAMPLE USE OF SCATP , A PROGRAM THAT SCATTERPLOTS5 C    THE NX*NY BIN COUNTS STORED IN A TWO DIMENSIONALA C    ARRAY.  CS: C========================================================= C     REAL Z(45,70),X(40),Y(70)  C     CHARACTER*24 CXLAB,CYLAB C     CHARACTER*16 CXFMT,CYFMT C     CHARACTER*32 CZFMT C     CHARACTER*25 CTITLE + C     LOGICAL*1 XLAB(24),YLAB(24),TITLE(25) * C     LOGICAL*1 XFMT(16),YFMT(16),ZFMT(16) C     LOGICAL*1 DIGITS(22) C     CHARACTER*22 DIG( C     DATA DIG/'- 0 2 4 6 8 A C E G I '/ C     EQUIVALENCE (DIGITS,DIG)+ C     EQUIVALENCE (XLAB,CXLAB),(YLAB,CYLAB)9  C     EQUIVALENCE (TITLE,CTITLE)8 C     EQUIVALENCE (XFMT,CXFMT),(YFMT,CYFMT),(ZFMT,CZFMT), C     DATA CXLAB/'THIS IS A SAMPLE X LABEL'/, C     DATA CYLAB/'THIS IS A SAMPLE Y LABEL'/. C     DATA CTITLE/'1THIS IS A SAMPLE TITLE  '/ C     DATA CXFMT/'(I3) '/3 C     DATA CYFMT/'(I4) '/  C     DATA CZFMT/'(I4)(I1)'/ C     NX=40  C     NY=42  C     DO 10 J=1,NY C 3 CC    NORMALIZE Z(I,J) BETWEEN 0&10 AND PROVIDE OWN ( CC    CHARACTER SET TO PRODUCE CONTOUTS. CR C     DO 20 I=1,NX$ C     Z(I,J)=COS(I/10.)*SIN(J/7.)+1. C     Z(I,J)=Z(I,J)*5  C 20  CONTINUE C 10  CONTINUE C     DO 30 I=1,NX C     X(I)=I C 30  CONTINUE C     DO 40 J=1,NY C     Y(J)=2*J C 40  CONTINUE C     NX1=45 C     NXLAB=24 C     NYLAB=24 C     NTITLE=24E
 C     ITYPE=1= C     IOUT=6
 C     ZMAX=0.M C     NDIGS=22 C     NWIDTH=80  C     IEMPTY=07 C     CALL SCATP(X,Y,Z,NX,NY,NX1,XLAB,NXLAB,YLAB,NYLAB, 4 C    #            XFMT,YFMT,ZFMT,TITLE,NTITLE,ITYPE,; C    #            ZMAX,NWIDTH,IOUT,IEMPTY,DIGITS,NDIGS,&99)C C     STOP 'NORMAL EXIT' C 99  WRITE(6,100)) C100  FORMAT(' ERROR RETURN FROM SCATPL') 	 C     ENDP< C===========================================================< C===========================================================< C==            OUTPUT OF SAMPLE PROGRAM                  ===< C=========================================================== CTHIS IS A SAMPLE TITLEC% C                   COUNTS =  8394.19 # C                      X PROJECTIONC CG1 C        2222222222222222222222222222222222222222E1 C        1111111111111111111111100000000000000001=1 C        1111111000000000000000099999999999999990S2 C       +|---------|---------|---------|---------+7 C    84 |444444444444       666666666666666666666|  212 7 C    82 -       444444     66666                6-  217 7 C    80 |222      4444    6666      88888888     |  223 7 C    78 |222222    4444   666    88888888888888  |  227 7 C    76 |   22222   444   66   88888        8888 |  232F7 C    74 |     2222   44  666   888            888|  235I7 C    72 |0     222   44  666  888      AA      88|  238G7 C    70 |000    222  44  66   88    AAAAAAA    88|  240A7 C    68 |0000   222  44  66   88    AAAAAAAA    8|  242 7 CT   66 |0000   222  44  66  888   AAAAAAAAA    8|  242 7 CH   64 |0000   222  44  66   88    AAAAAAAA    8|  242=7 CI   62 -000    222  44  66   88    AAAAAAA    88-  240 7 CS   60 |0     222   44  666  888     AAA      88|  238 7 C    58 |     2222   44  666   888            888|  235H7 CI   56 |   22222   444   66   88888        8888 |  232 9 CS   54 |2222222   4444   666    88888888888888  |  228 Y 7 C    52 |222      4444    6666      88888888     |  223 9 CA   50 |       444444     66666                6|  217 P 9 C    48 |444444444444       666666666666666666666|  212 R 9 CS   46 |44444444               6666666666666666 |  206 O-9 CA   44 |                                        |  200 J 9 CM   42 -6666666                4444444444444444 -  194 EO9 CP   40 |666666666666       444444444444444444444|  188 C 9 CL   38 |       666666     44444                4|  183 TB9 CE   36 |888      6666    4444      22222222     |  177 I 9 C    34 |8888888   6666   444    22222222222222  |  173 O=9 CY   32 |   88888   666   44   22222        2222 |  168 N 7 C    30 |     8888   66  444   222            222|  165Y7 CL   28 |A     888   66  444  222     000      22|  162 7 CA   26 |AAA    888  66  44   22    0000000    22|  160 7 CB   24 |AAAA   888  66  44   22    00000000    2|  158I7 CE   22 -AAAA   888  66  44  222   000000000    2-  158-7 CL   20 |AAAA   888  66  44   22    00000000    2|  158=7 C    18 |AAA    888  66  44   22    0000000    22|  160 7 C    16 |A     888   66  444  222     000      22|  162 7 C    14 |     8888   66  444   222            222|  165 7 C    12 |   88888   666   44   22222        2222 |  168 7 C    10 |8888888   6666   444    22222222222222  |  173M7 C     8 |888      6666    4444      22222222     |  177D7 C     6 |       666666     44444                4|  183 7 C     4 |666666666666       444444444444444444444|  188M7 C     2 -6666666                4444444444444444 -  194 2 C       +|---------|---------|---------|---------+ C 1 C                 1111111111222222222233333333334M1 C        1234567890123456789012345678901234567890 ) C                THIS IS A SAMPLE X LABEL D C===================================================================: C========================================================= CM' C         SAMPLE OF NUMBER SCATTERPLOT."6 C    SAMPLE USE OF SCATP , A PROGRAM THAT SCATTERPLOTS5 C    THE NX*NY BIN COUNTS STORED IN A TWO DIMENSIONAL  C    ARRAY.  C : C========================================================= C     REAL Z(50,70),X(50),Y(70)R C     CHARACTER*24 CXLAB,CYLAB C     CHARACTER*16 CXFMT,CYFMT C     CHARACTER*32 CZFMT C     CHARACTER*25 CTITLE + C     LOGICAL*1 XLAB(24),YLAB(24),TITLE(25) * C     LOGICAL*1 XFMT(16),YFMT(16),ZFMT(16)+ C     EQUIVALENCE (XLAB,CXLAB),(YLAB,CYLAB)A  C     EQUIVALENCE (TITLE,CTITLE)8 C     EQUIVALENCE (XFMT,CXFMT),(YFMT,CYFMT),(ZFMT,CZFMT), C     DATA CXLAB/'THIS IS A SAMPLE X LABEL'/, C     DATA CYLAB/'THIS IS A SAMPLE Y LABEL'/. C     DATA CTITLE/'1THIS IS A SAMPLE TITLE  '/ C     DATA CXFMT/'(I3) '/  C     DATA CYFMT/'(I4) '/I C     DATA CZFMT/'(I4)(I3)'/ C     NX=30  C     NY=70N C     DO 10 J=1,NY C     DO 20 I=1,NX C     Z(I,J)=I+J C     IF(I.EQ.J)Z(I,J)=0.R C 20  CONTINUE C 10  CONTINUE C     DO 30 I=1,NX C     X(I)=I C 30  CONTINUE C     DO 40 J=1,NY C     Y(J)=2*J C 40  CONTINUE C     NX1=50 C     NXLAB=24 C     NYLAB=24 C     NTITLE=24.
 C     ITYPE=2H C     IOUT=6 C     ZMAX=100.E
 C     NDIGS=1T C     NWIDTH=70" C     IEMPTY=07 C     CALL SCATP(X,Y,Z,NX,NY,NX1,XLAB,NXLAB,YLAB,NYLAB,=4 C    #            XFMT,YFMT,ZFMT,TITLE,NTITLE,ITYPE,; C    #            ZMAX,NWIDTH,IOUT,IEMPTY,DIGITS,NDIGS,&99)  C     STOP 'NORMAL EXIT' C 99  WRITE(6,100)) C100  FORMAT(' ERROR RETURN FROM SCATPL') 	 C     END D C===================================================================C C==================================================================  C  C H CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC' C         NOW FOR THE REAL PROGRAM  !!!= C  C ( C     REAL X(NX),Y(NY),Z(NX1,NY),ZX(122)(       REAL X(1), Y(1), Z(NX1,1), ZX(122)B C     LOGICAL*1 XLAB(NXLAB),YLAB(NYLAB),XFMT(10),YFMT(10),ZFMT(10)B       LOGICAL*1 XLAB(1),    YLAB(1),    XFMT(10),YFMT(10),ZFMT(10)- C     LOGICAL*1 TITLE(NTITLE),FMT(10),ZFM(10) -       LOGICAL*1 TITLE(1),     FMT(10),ZFM(10).2       LOGICAL*1 LINE(10,122),LINE2(132),XAXIS(132)A C================================================================OA C==   /C0MM0N/ IS A SCRATCH STORAGE AREA USED TEMPORARILY BY   == A C==   SUBROUTINES "HISTP" AND "SCATP". /C0MM0N/ IS NOT INTENDED== A C==   TO BE USED TO PASS INFORMATION FROM OR TO "HISTP" OR     == A C==   "SCATP". /C0MM0N/ MAY BE USED BY ANY OTHER ROUTINES FOR  == A C==   TEMPORARY SCRATCH STORAGE.                               == A C================================================================ 1       COMMON /C0MM0N/ ZX,LINE2,LINE,FMT,ZFM,XAXISL       LOGICAL EQUC,EMPTY8       LOGICAL*1 MINUS/'-'/,BLANK/' '/,PLUS/'+'/,BAR/'|'/#       LOGICAL*1 XPROJ(12),YPROJ(12)YA       DATA XPROJ/'X',' ','P','R','O','J','E','C','T','I','O','N'/ A       DATA YPROJ/'Y',' ','P','R','O','J','E','C','T','I','O','N'/F(       DATA NXPROJ,NYPROJ/12,12/,NDIG/39/> C     LOGICAL*1 DIGIT(39),DIGITS(NDIGS),DIGIT0,NFIRST/.FALSE./>       LOGICAL*1 DIGIT(39),DIGITS(1),    DIGIT0,NFIRST/.FALSE./       IF(NFIRST)GO TO 10A C================================================================ A C==   IF IT IS THE FIRST TIME THROUGH "SCATP", THEN INITIALIZE == A C==   THE DEFAULT CHARACTERS IN "DIGIT".                       == A C================================================================        NFIRST=.TRUE.)@       CALL MOVEC(NDIG,'- 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ+',      *           DIGIT) A C================================================================ A C==   IF |NX|*|NY| = 0 THEN GO TO 1000 AND WRITE OUT AN ERROR  ==NA C==   MESSAGE.                                                 == A C================================================================  10    NXU=IABS(NX)       NYU=IABS(NY)4       IF(NXU.LE.0.OR.NYU.LE.0.OR.NX1.LE.0)GO TO 1000A C================================================================ A C==   MAXDIG: IS THE NUMBER OF DIGITS IN THE LOGICAL OVERLAY OF== A C==           DIGITS ONTO DIGIT.                               == A C==   DIGIT0: IS THE CHARACTER DENOTING ABSOLUTE ZERO ON A     == A C==           CHARACTER SCATTERPLOT.                           == A C================================================================        MAXDIG=MAX0(NDIG,NDIGS)        DIGIT0=DIGIT(2) $       IF(NDIGS.GE.2)DIGIT0=DIGITS(2)A C================================================================OA C==   TRUNCATE "NWIDTH" SO THAT 11 <= NWID <= 132.             ==UA C================================================================F       NWID=NWIDTHF       IF(NWID.GT.132)NWID=132        IF(NWID.LT.11)NWID=11 A C================================================================ A C==   FIND THE POSITION OF THE ")" IN "XFMT","YFMT", & "ZFMT". ==AA C==   IF NONE EXISTS IN THE 1'ST 10 CHARACTERS THEN GO TO 1010,==AA C==   1020, OR 1030, AND WRITE OUT AN ERROR MESSAGE.           == A C================================================================ .       CALL FINDST(XFMT,10,')',1,1,NXFMT,&1010).       CALL FINDST(YFMT,10,')',1,1,NYFMT,&1020).       CALL FINDST(ZFMT,10,')',1,1,NZFMT,&1030)A C================================================================NA C==   NXFMT = NUMBER OF CHARACTERS IN "XFMT".                  ==TA C==   NYFMT = NUMBER OF CHARACTERS IN "YFMT".                  == A C==   NZFMT = NUMBER OF CHARACTERS IN "ZFMT".                  ==IA C==   IF NXFMT, NYFMT, OR NZFMT < 4 GO TO 1040, 1050, OR 1060. ==OA C================================================================H       IF(NXFMT.LT.4)GO TO 1040       IF(NYFMT.LT.4)GO TO 1050       IF(NZFMT.LT.4)GO TO 1060A C================================================================ A C==   DETERMINE THE X-FORMAT FIELD WIDTH: "NXWID",             == A C==             THE Y-FORMAT FIELD WIDTH: "NYWID", AND         == A C==             THE Z-FORMAT FIELD WIDTH: "NZWID".             == A C================================================================        NCHAR=NXFMT-3 2       CALL DTB(XFMT(3),NXWID,NCHAR,NSIG,' ',&1040).       IF(NXWID.LT.1.OR.NXWID.GT.132)GO TO 1070       NCHAR=NYFMT-3 2       CALL DTB(YFMT(3),NYWID,NCHAR,NSIG,' ',&1050)       IF(NYWID.LT.1)GO TO 1080 N       NCHAR=NZFMT-3E2       CALL DTB(ZFMT(3),NZWID,NCHAR,NSIG,' ',&1060)       IF(NZWID.LT.1)GO TO 1090A C================================================================ A C==   NZWD1 = NUMBER OF CHARACTERS PER BIN = 1 WHEN ITYPE <= 1.== A C================================================================ 
       NZWD1=1U       IF(ITYPE.LE.1)GO TO 200 A C================================================================ A C==   IF ITYPE => 2, THEN CHECK FOR A 2'ND FORMAT CODE IN "ZFMT"= A C================================================================T*       IF(EQUC(ZFMT(NZFMT+1),'('))GO TO 100A C================================================================ A C==   THERE IS NO SECOND FORMAT CODE IN "ZFMT".                == A C==   HENCE MAKE THE 2'ND Z-FORMAT CODE "ZFM" = "ZFMT".        == A C================================================================R       NZFM=NZFMT        CALL MOVEC(NZFMT,ZFMT,ZFM)       NZWD=NZWID       GO TO 120 A C================================================================ A C==   HANDLE THE CASE WHEN THERE IS A SECOND FORMAT CODE IN    == A C==   "ZFMT". PUT IT IN "ZFM", AND DETERMINE "NZWD", THE FORMAT== A C==   FIELD WIDTH OF THE 2'ND Z-FORMAT CODE.                   ==SA C==   NZFM = NUMBER OF CHARACTERS IN "ZFM".                    ==,A C================================================================E6 100   CALL FINDST(ZFMT(NZFMT+1),10,')',1,1,NZFM,&1100)(       CALL MOVEC(NZFM,ZFMT(NZFMT+1),ZFM)       IF(NZFM.LT.4)GO TO 1110"       NCHAR=NZFM-30       CALL DTB(ZFM(3),NZWD,NCHAR,NSIG,' ',&1110)       IF(NZWD.LT.1)GO TO 1120 A C================================================================ A C==   WHEN ITYPE => 2 DETERMINE NZWID1,NZWD1,NXWID1 WHICH ARE  == A C==   EQUAL TO NZWID,NZWD,NXWID, UNLESS THE FORMATS ARE E,G,D  ==:A C==   TYPE IN WHICH CASE THEY ARE NZWID+1,NZWD+1, OR NXWID+1.  ==RA C================================================================  120   NZWID1=NZWID       NZWD1=NZWD       NXWID1=NXWID?       IF(EQUC(ZFMT(2),'E').OR.EQUC(ZFMT(2),'G'))NZWID1=NZWID1+1=*       IF(EQUC(ZFMT(2),'D'))NZWID1=NZWID1+1;       IF(EQUC(ZFM(2),'E').OR.EQUC(ZFM(2),'G'))NZWD1=NZWD1+1I'       IF(EQUC(ZFM(2),'D'))NZWD1=NZWD1+1E?       IF(EQUC(XFMT(2),'E').OR.EQUC(XFMT(2),'G'))NXWID1=NXWID1+1 *       IF(EQUC(XFMT(2),'D'))NXWID1=NXWID1+1A C=================================================================A C==   NOW THAT THE FORMATS ARE CALCULATED, CHECK THAT          == A C==   NYWID+NZWID+8+NZWD1 <= NWID, WHERE NYWID+NZWID+8+NZWD1 IS==AA C==   THE NUMBER OF CHARACTERS USED ON THE PAGE IN WRITING OUT:==WA C==   THE VERTICAL Y-LABEL (1 CHARACTER), FOLLOWED BY A BLANK, ===A C==   FOLLOWED BY A Y-AXIS SCALE NUMBER (NYWID CHARACTERS),    ==HA C==   FOLLOWED BY A BLANK, FOLLOWED BY A Y-AXIS CHARACTER (| OR==CA C==   -), FOLLOWED BY AT LEAST ONE BIN VALUE (NZWD1 CHARACTERS),=YA C==   FOLLOWED BY A Y-AXIS CHARACTER (| OR -), FOLLOWED BY A   == A C==   BLANK, FOLLOWED BY A Y-PROJECTION BIN VALUE (NZWID       ==CA C==   CHARACTERS, FOLLOWED BY A BLANK, FOLLOWED BY THE VERTICAL== A C==   Y-PROJECTION LABEL (1 CHARACTER); AND NWID IS THE MAXIMUM==IA C==   NUMBER OF CHARACTERS ALLOWED ACROSS THE PAGE IN PRINTING ==/A C==   THE SCATTERPLOT.                                         ==AA C================================================================  200   NFMT=NYWID+NZWID+8&       IF(NFMT+NZWD1.GT.NWID)GO TO 1130A C================================================================ A C==   DETERMINE THE Z SCALE FACTORS: ZSCALE AND ISCALE.        == A C================================================================        ZSCALE=1.0       ISCALE=1       IF(ZMAX.EQ.0.)GO TO 208W
       ZMX=0.0        DO 204 J=1,NYU       DO 202 I=1,NXU       IF(ITYPE.EQ.2)GO TO 201 !       IF(Z(I,J).GT.ZMX)ZMX=Z(I,J)L       GO TO 202 + 201   IF(ABS(Z(I,J)).GT.ZMX)ZMX=ABS(Z(I,J))S 202   CONTINUE 204   CONTINUE-       IF(ZMX.LE.0. .OR. ZMAX.GE.ZMX)GO TO 208R       ZSCALE=ABS(ZMAX)/ZMX        IF(ZSCALE.GE.1.0)GO TO 205       ZSCALE=1./ZSCALE       ISCALE=ZSCALE+.999       ZSCALE=1.0/ISCALE=       GO TO 208= 205   ISCALE=ZSCALE        ZSCALE=ISCALECA C================================================================OA C==   IYLAB (IYPROJ) IS THE FIRST LINE FROM THE TOP OF THE     ==ZA C==   SCATTERPLOT AT WHICH THE Y-LABEL (Y-PROJECTION LABEL) IS ==LA C==   TO BE WRITTEN VERTICALLY IN THE FIRST (LAST) COLUMN OF   ==LA C==   THE PAGE.                                                ==IA C================================================================, 208   IYLAB=(NYU-NYLAB)/2+1E       IF(IYLAB.LT.1)IYLAB=1)       IYPROJ=(NYU-NYPROJ)/2+1=       IF(IYPROJ.LT.1)IYPROJ=1=A C================================================================ A C==   ISTART IS THE COLUMN POSITION OF THE Y-AXIS.             ==EA C==   IPAGE IS THE PAGE NUMBER OF THE SCATTERPLOT.             == A C==   IPAGE = 1 FOR THE 1'ST PAGE.                             == A C================================================================        ISTART=NYWID+4
       IPAGE=0=A C================================================================LA C==   NXMAX IS THE MAXIMUM NUMBER OF SCATTERPLOT BINS WHICH CAN==/A C==         BE PLOTTED ACROSS THE PAGE.                        ==(A C==   IXX   POINTS TO THE START OF THE X-ARRAY SECTION OF THE  =='A C==         SCATTERPLOT WHICH IS TO BE PLOTTED ON THE CURRENT  =='A C==         PAGE (PAGE # IPAGE).                               ==IA C==   NXX   IS THE NUMBER OF BINS ACROSS THE PAGE WHICH ARE TO ==9A C==         BE SCATTERPLOTTED ON THE CURRENT PAGE STARTING AT  ===A C==         X(IXX).                                            ===A C=================================================================       NXMAX=(NWID-NFMT)/NZWD1D       IXX=1        NXX=0 A C=================================================================A C==   LOOP OVER THE SCATTERPLOT PAGES STARTS HERE AT 210.      ==EA C==   NXU = IABS(NX) = TOTAL NUMBER OF X-BINS.                 ===A C==   INCREMENT THE X-BIN POINTER IXX AND THE PAGE NUMBER      ==NA C==   IPAGE.                                                   == A C================================================================= 210   IXX=IXX+NXX=       NXX=NXU-IXX+1=       IF(NXX.LE.0)RETURN       IF(NXX.GT.NXMAX)NXX=NXMAXN       IPAGE=IPAGE+1RA C=================================================================A C==   DETERMINE ZSUM THE TOTAL NUMBER OF BIN COUNTS ON THE     ==LA C==   CURRENT PAGE. DETERMINE WHETHER THE CURRENT PAGE IS EMPTY== A C==   (IN WHICH CASE EMPTY IS SET TO .TRUE.).                  ==UA C================================================================        ZSUM=0.0       IX=IXX       EMPTY=.TRUE.       DO 250 I=1,NXXA C================================================================TA C==   DETERMINE ZXSUM, THE X-PROJECTION FOR EACH LINE OF THE   ===A C==   CURRENT PAGE AND STORE IT IN ZX(I).                      == A C==   NYU = ABS(NY) = NUMBER OF VERTICAL Y-BINS = TOTAL NUMBER ===A C==         OF SCATTERPLOT LINES.                              == A C=================================================================       ZXSUM=0.0        DO 240 J=1,NYU$       IF(Z(IX,J).NE.0.)EMPTY=.FALSE.        ZXSUM=ZXSUM+Z(IX,J)*ZSCALE 240   CONTINUE
       IX=IX+1S       ZX(I)=ZXSUMH       ZSUM=ZSUM+ZXSUM0 250   CONTINUEA C=================================================================A C==   IF THE SCATTERPLOT PAGE IS EMPTY AND IEMPTY=1 THEN GO TO ==LA C==   210 AND PLOT THE NEXT SCATTERPLOT PAGE, IF ANY.          ==,A C=================================================================(       IF(EMPTY.AND.IEMPTY.EQ.1)GO TO 210A C================================================================"A C==   THE FIRST THING TO WRITE OUT IS THE SCATTERPLOT TITLE.   =="A C================================================================")       IF(NTITLE.GT.0)WRITE(IOUT,220)TITLEM 220   FORMAT(255A1) A C=================================================================A C==   WRITE OUT THE TOTAL NUMBER OF SCALED COUNTS ON THE       ==NA C==   CURRENT SCATTERPLOT PAGE AND THE SCALE FACTOR.           ===A C================================================================N       NCHAR=21       IF(ZSCALE.LT.1.)NCHAR=63       IF(ZSCALE.GT.1.)NCHAR=61       SCALE=ISCALE       NXZ=NXX*NZWD1 "       NBLANK=NYWID+6+(NXZ-NCHAR)/2-       IF(NBLANK.GT.132-NCHAR)NBLANK=132-NCHAR=       IF(NBLANK.LT.1)NBLANK=1=        IF(ZSCALE.NE.1.0)GO TO 255%       CALL MOVEC(9,'COUNTS = ',LINE2)H/       CALL RICON(ZSUM,LINE2(10),2,'(G12.6)',12)G       GO TO 258 D 255   IF(ZSCALE.LT.1.0)CALL MOVEC(22,'COUNTS SCALED DOWN BY ',LINE2)B       IF(ZSCALE.GT.1.0)CALL MOVEC(20,'COUNTS SCALED UP BY ',LINE2)6       CALL RICON(SCALE,LINE2(NCHAR-40),2,'(G11.6)',11)9       CALL MOVEC(18,'  SCALED COUNTS = ',LINE2(NCHAR-29))=6       CALL RICON(ZSUM ,LINE2(NCHAR-11),2,'(G12.6)',12)< 258   WRITE(IOUT,230)(BLANK,I=1,NBLANK),(LINE2(I),I=1,NCHAR)A C================================================================ A C==   WRITE OUT THE PAGE NUMBER IF THERE IS MORE THAN 1 PAGE,  ===A C==   AND WRITE OUT THE X-PROJECTION LABEL.                    ==DA C================================================================="       NBLANK=ISTART+(NXZ-NXPROJ)/2/       IF(NBLANK.GT.132-NXPROJ)NBLANK=132-NXPROJ=%       IF(NXU.GT.NXMAX)NBLANK=NBLANK-7=       IF(NBLANK.LT.1)NBLANK=1E8       IF(NXU.LE.NXMAX)WRITE(IOUT,230)(BLANK,I=1,NBLANK),      *  (XPROJ(I),I=1,NXPROJ)Z 230   FORMAT('9',132A1) >       IF(NXU.GT.NXMAX)WRITE(IOUT,235)IPAGE,(BLANK,I=1,NBLANK),      *  (XPROJ(I),I=1,NXPROJ)L 235   FORMAT('9PAGE',I3,132A1)A C=================================================================A C==   BLANK OUT THE FIRST NYWID+3 CHARACTERS OF XAXIS.         ==EA C==   ISTART=NYWID+4. THE FIRST CHARACTER OF THE XAXIS IS A "+".=RA C==   THE DO 259 LOOP FILLS THE XAXIS ARRAY XAXIS(ISTART+1) TO ==CA C==   XAXIS(ISTART+NXZ) WITH NXZ=NXX*NZWD1 X-AXIS CHARACTERS.  ==FA C================================================================="       CALL SETC(NYWID+3,XAXIS,' ')       XAXIS(ISTART)=PLUS
       MULT=101       IF(NZWD1.GE.2)MULT=5       DO 259 I=1,NXZ       XAXIS(ISTART+I)=MINUS A C================================================================)A C==   "|"'S APPEAR AT LOCATIONS: I = NZWD1, NZWD1+MULT*NZWD1,  ===A C==   NZWD1+2*MULT*NZWD1,... ETC. OF THE ARRAY XAXIS(ISTART+I).==ZA C================================================================U9       IF(MOD(I-NZWD1,MULT*NZWD1).EQ.0)XAXIS(ISTART+I)=BART 259   CONTINUEA C=================================================================A C==   THE LAST CHARACTER IN THE XAXIS ARRAY AT POSITION        == A C==   NXAXIS = ISTART+NXZ+1 IS A "+".                          ==IA C================================================================E       NXAXIS=ISTART+NXZ+1(       XAXIS(NXAXIS)=PLUSA C================================================================OA C==   IEND IS THE LAST CHARACTER POSITION ON THE PAGE.         == A C================================================================        IEND=NXAXIS+NZWID+3 A C================================================================ A C==   DETERMINE "XDFRAC" WHICH IS .00002 TIMES THE AVERAGE X-BIN= A C==   SIZE. "XDFRAC" IS USED TO MAKE SURE THAT THE ZERO ON THE == A C==   X-AXIS IS A TRUE ZERO WHEN PRINTED OUT. IT MAY NOT BE,   == A C==   DUE TO ROUND OFF ERROR.                                  == A C================================================================        XDFRAC=0.,5       IF(NX.GT.1)XDFRAC=ABS(X(NX)-X(1))/(NX-1)*.00002Y(       IF(NX.LT.0)XDFRAC=ABS(X(2))*.00002A C================================================================ A C==   DETERMINE "YDFRAC" WHICH IS .00002 TIMES THE AVERAGE Y-BIN= A C==   SIZE. "YDFRAC" IS USED TO MAKE SURE THAT THE ZERO ON THE ==WA C==   Y-AXIS IS A TRUE ZERO WHEN PRINTED OUT. IT MAY NOT BE,   == A C==   DUE TO ROUND OFF ERROR.                                  == A C================================================================        YDFRAC=0.=5       IF(NY.GT.1)YDFRAC=ABS(Y(NY)-Y(1))/(NY-1)*.00002 (       IF(NY.LT.0)YDFRAC=ABS(Y(2))*.00002A C================================================================GA C==   IF ITYPE => 2, I.E. THE SCATTERPLOT IS A "NUMBER         == A C==   SCATTERPLOT" THEN GO TO 600.                             ===A C=================================================================       IF(ITYPE.GE.2)GO TO 600=A C=================================================================A C==   ITYPE <= 1: "CHARACTER SCATTERPLOT" SECTION:             ===A C=================================================================A C==   FOR ITIME=1: CONVERT THE SCATTERPLOT X-PROJECTION VALUES ===A C==   "ZX(I)" TO CHARACTERS IN LINE2 AND MOVE THEM 10 AT A TIME===A C==   INTO LINE(1,I).                                          ===A C=================================================================A C==   FOR ITIME=2: CONVERT THE SCATTERPLOT X-AXIS VALUES "X(IX)"==A C==   TO CHARACTERS IN LINE2, AND MOVE THEM 10 AT A TIME INTO  ===A C==   LINE(1,I).                                               ===A C=================================================================       NW=NZWID        CALL MOVEC(NZFMT,ZFMT,FMT)A C================================================================GA C==   ITIME=1: STARTS HERE.                                    ==DA C================================================================ 
       ITIME=1  260   IWW=1H       NWW=0A 270   IWW=IWW+NWWN       NWW=NW-IWW+1       IF(NWW.LE.0)GO TO 300        IF(NWW.GT.10)NWW=10        DO 280 I=1,NXX,       CALL RICON(ZX(I),LINE2,2,FMT,NW,&1150)*       CALL MOVEC(NWW,LINE2(IWW),LINE(1,I)) 280   CONTINUEA C================================================================EA C==   WRITE OUT THE LINE(I,J) ARRAY.                           == A C=================================================================       DO 290 I=1,NWW;       WRITE(IOUT,230)(BLANK,J=1,ISTART),(LINE(I,J),J=1,NXX)C 290   CONTINUE       GO TO 270E 300   IF(ITIME.EQ.2)GO TO 400CA C================================================================*A C==   ITIME=1:                                                 ==RA C================================================================AA C==   WRITE OUT THE X-AXIS AT THE TOP OF THE SCATTERPLOT.      == A C================================================================T*       WRITE(IOUT,230)(XAXIS(I),I=1,NXAXIS)A C================================================================/A C==   THE DO 320 LOOP PRINTS OUT THE ENTIRE SCATTERPLOT PAGE.  =='A C==   NYU IS THE NUMBER OF SCATTERPLOT LINES.                  == A C================================================================        DO 320 I=1,NYUA C================================================================ A C==   IN THE FIRST COLUMN OF LINE2, WHICH IS THE ENTIRE        ==IA C==   SCATTERPLOT LINE (UPTO 132 CHARACTERS LONG), WE PUT A    ==(A C==   BLANK OR IF WE ARE PAST THE IYLAB'TH LINE WE WILL PUT    ==TA C==   A Y-LABEL CHARACTER INTO LINE2(1).                       ==EA C================================================================        LINE2(1)=BLANK       IYL=I-IYLAB+1A5       IF(IYL.GE.1.AND.IYL.LE.NYLAB)LINE2(1)=YLAB(IYL) A C================================================================IA C==   LINE2(2) IS ALWAYS BLANK.                                == A C================================================================P       LINE2(2)=BLANKA C=================================================================A C==   DETERMINE THE Y-SCALE VALUE, YIY, FOR THE CURRENT LINE #.== A C==   USING "RICON" CONVERT "YIY" INTO "NYWID" CHARACTERS IN   ===A C==   LINE2(3).                                                == A C================================================================        IY=NYU-I+1       IF(NY.GT.0)YIY=Y(IY)%       IF(NY.LT.0)YIY=Y(1)+(IY-1)*Y(2)0#       IF(ABS(YIY).LT.YDFRAC)YIY=0.001       CALL RICON(YIY,LINE2(3),2,YFMT,NYWID,&1050)-A C================================================================6A C==   LINE2(NYWID+3) IS ALWAYS BLANK.                          ==-A C================================================================        LINE2(NYWID+3)=BLANKA C================================================================ A C==   Y-AXIS AT THE LEFT HAND SIDE OF THE PAGE:                ==|A C==   LINE2(ISTART) = "|" EXCEPT FOR EVERY 10'TH LINE FROM THE == A C==   BOTTOM OF THE SCATTERPLOT, IN WHICH CASE IT IS A "-".    ==0A C================================================================4       LINE2(ISTART)=BAR -       IF(IY-IY/10*10.EQ.1)LINE2(ISTART)=MINUSAA C================================================================8A C==   ZYSUM IS THE Y-PROJECTION ALONG THE CURRENT LINE.        == A C==   NOW FILL IN THE SCATTERPLOT BINS:                        == A C==   THE DO 315 LOOP FILLS THE REMAINDER OF LINE2 WITH THE    ==4A C==   APPROPRIATE SCATTERPLOT CHARACTERS WHICH ARE DETERMINED  ==6A C==   USING THE SCALED COUNTS ZZ=Z(IX,IY)*ZSCALE AND THE DIGIT == A C==   ARRAYS: "DIGIT" AND "DIGITS".                            ==6A C================================================================0       ZYSUM=0.0        IX=IXX       DO 315 J=1,NXX       ZZ=Z(IX,IY)*ZSCALE
       IX=IX+1        ZYSUM=ZYSUM+ZZ       IDIGIT=ZZ+3.56       IF(IDIGIT.GT.3)GO TO 312       IDIGIT=2       IF(ZZ.GT.0.)IDIGIT=3       IF(ZZ.LT.0.)IDIGIT=1  #       LINE2(ISTART+J)=DIGIT(IDIGIT)27       IF(IDIGIT.LE.NDIGS)LINE2(ISTART+J)=DIGITS(IDIGIT)2       GO TO 3157' 312   IF(IDIGIT.GT.MAXDIG)IDIGIT=MAXDIG27       IF(IDIGIT.LE.NDIGS)LINE2(ISTART+J)=DIGITS(IDIGIT)26       IF(IDIGIT.GT.NDIGS)LINE2(ISTART+J)=DIGIT(IDIGIT) 315   CONTINUEA C================================================================ A C==   Y-AXIS AT THE RIGHT HAND SIDE OF THE PAGE:               ==AA C==   LINE2(NXAXIS) = THE Y-AXIS CHARACTER CORRESPONDING TO    == A C==   THE CURRENT LINE.                                        == A C================================================================0!       LINE2(NXAXIS)=LINE2(ISTART)8A C================================================================4A C==   LINE2(NXAXIS+1) IS ALWAYS BLANK.                         ==2A C================================================================        LINE2(NXAXIS+1)=BLANK6A C================================================================4A C==   USING "RICON" CONVERT "ZYSUM", THE Y-PROJECTION VALUE FOR==4A C==   THE CURRENT LINE INTO "NZWID" CHARACTERS IN              ==+A C==   LINE2(NXAXIS+2).                                         ==1A C================================================================D:       CALL RICON(ZYSUM,LINE2(NXAXIS+2),2,ZFMT,NZWID,&1060)A C================================================================EA C==   LINE2(IEND-1) IS ALWAYS BLANK.                           ==EA C================================================================T       LINE2(IEND-1)=BLANK A C================================================================ A C==   IN THE LAST COLUMN (IEND) OF LINE2, WE PUT A BLANK OR IF == A C==   WE ARE PAST THE IYPROJ'TH LINE WE WILL PUT A Y-PROJECTION== A C==   LABEL CHARACTER INTO LINE2(IEND).                        ==TA C=================================================================       LINE2(IEND)=BLANKA       IYP=I-IYPROJ+1:       IF(IYP.GE.1.AND.IYP.LE.NYPROJ)LINE2(IEND)=YPROJ(IYP)A C=================================================================A C==   NOW WE CAN WRITE OUT THE SCATTERPLOT LINE.               == A C=================================================================(       WRITE(IOUT,230)(LINE2(J),J=1,IEND) 320   CONTINUEA C=================================================================A C==   WRITE OUT THE X-AXIS AT THE BOTTOM OF THE PAGE.          ===A C================================================================E*       WRITE(IOUT,230)(XAXIS(I),I=1,NXAXIS)A C================================================================RA C==   ITIME = 1: IS COMPLETE HERE.                             ==NA C================================================================ A C==   ITIME = 2: STARTS HERE.                                  ===A C================================================================(A C==   NOW INITIALIZE ARRAY ZX(I), NW, AND FMT, FOR ITIME=2.    ===A C================================================================        IX=IXX       DO 330 I=1,NXX       IF(NX.GT.0)ZX(I)=X(IX)'       IF(NX.LT.0)ZX(I)=X(1)+(IX-1)*X(2)T'       IF(ABS(ZX(I)).LT.XDFRAC)ZX(I)=0.0R
       IX=IX+1I 330   CONTINUE       NW=NXWID        CALL MOVEC(NXFMT,XFMT,FMT)
       ITIME=2        GO TO 260 A C================================================================ A C==   ITIME = 2: IS COMPLETE HERE.                             ==0A C=================================================================A C==   WRITE OUT THE X-AXIS LABEL BELOW THE SCATTERPLOT.        ==,A C==   NBLANK IS THE NUMBER OF LEADING BLANKS BEFORE THE X-LABEL.=TA C=================================================================! 400   NBLANK=ISTART+(NXZ-NXLAB)/2=-       IF(NBLANK.GT.132-NXLAB)NBLANK=132-NXLAB=       IF(NBLANK.LT.1)NBLANK=1=4       IF(NXLAB.GT.0.AND.NXLAB.LT.132)WRITE(IOUT,230).      *  (BLANK,I=1,NBLANK),(XLAB(I),I=1,NXLAB)6       IF(NXLAB.GE.132)WRITE(IOUT,230)(XLAB(I),I=1,132)(       IF(NXLAB.LE.0)WRITE(IOUT,230)BLANKA C================================================================LA C==   CONTINUE THE 210 LOOP AND PRINT OUT THE NEXT SCATTERPLOT == A C==   PAGE IF ANY.                                             ===A C================================================================S       GO TO 210 A C================================================================ A C==   ITYPE => 2: "NUMBER SCATTERPLOT" SECTION FOLLOWS:        == A C=================================================================A C==   FOR ITIME=1: CONVERT THE SCATTERPLOT X-PROJECTION VALUES == A C==   "ZX(I)" TO CHARACTERS IN LINE2 IF NZWID1 <= NZWD1, OR    == A C==   IN LINE(10,122) IF NZWID1 > NZWD1.                       == A C================================================================ A C==   FOR ITIME=2: CONVERT THE SCATTERPLOT X-AXIS VALUES "X(IX)"= A C==   TO CHARACTERS IN LINE2 IF NXWID1 <= NZWD1, OR IN         ==WA C==   LINE(10,122) IF NXWID1 > NZWD1.                          ==1A C================================================================= 600   N1=NZWD1-1       ILAST=NXZ=       NW=NZWID       NW1=NZWID1        CALL MOVEC(NZFMT,ZFMT,FMT)A C=================================================================A C==   ITIME=1: STARTS HERE.                                    ==TA C================================================================ 
       ITIME=1  605   IF(NW1.GT.NZWD1)GO TO 630=A C================================================================ A C==   NW1 <= NZWD1.                                            ===A C==   WE WILL NOW WRITE OUT  THE X-PROJECTION VALUES           == A C==   HORIZONTALLY VIA LINE2. NBL IS THE NUMBER OF BLANKS      ===A C==   BETWEEN X-PROJECTION FIELDS WHICH HAVE WIDTH NW.         == A C=================================================================       NBL=NZWD1-NW
       ILINE=1/       DO 610 I=1,NXX1       IF(NBL.GT.0)CALL SETC(NBL,LINE2(ILINE),' ')        ILINE=ILINE+NBLS3       CALL RICON(ZX(I),LINE2(ILINE),2,FMT,NW,&1150)=       ILINE=ILINE+NW 610   CONTINUE<       WRITE(IOUT,230)(BLANK,I=1,ISTART),(LINE2(I),I=1,ILAST)       GO TO 700=A C================================================================ A C==   NW1 > NZWD1:                                             ==RA C==   WRITE OUT THE X-PROJECTION VALUES VERTICALLY VIA LINE.   ==HA C================================================================  630   IWW=1        NWW=0= 640   IWW=IWW+NWW=       NWW=NW-IWW+1       IF(NWW.LE.0)GO TO 700        IF(NWW.GT.10)NWW=10=
       ILINE=1        DO 650 I=1,NXX3       IF(N1.GT.0)CALL SETC(N1*10,LINE(1,ILINE),' ')=       ILINE=ILINE+N1,       CALL RICON(ZX(I),LINE2,2,FMT,NW,&1150).       CALL MOVEC(NWW,LINE2(IWW),LINE(1,ILINE))       ILINE=ILINE+1= 650   CONTINUE       DO 660 I=1,NWW=       WRITE(IOUT,230)(BLANK,J=1,ISTART),(LINE(I,J),J=1,ILAST)= 660   CONTINUE       GO TO 640  700   IF(ITIME.EQ.2)GO TO 400YA C================================================================NA C==   ITIME=1:                                                 == A C=================================================================A C==   WRITE OUT THE X-AXIS AT THE TOP OF THE SCATTERPLOT.      ==YA C================================================================.*       WRITE(IOUT,230)(XAXIS(I),I=1,NXAXIS)A C=================================================================A C==   NBL IS THE NUMBER OF BLANKS BETWEEN BIN FIELDS.          == A C=================================================================       NBL=NZWD1-NZWDA C=================================================================A C==   THE DO 670 LOOP PRINTS OUT THE ENTIRE SCATTERPLOT PAGE.  ==EA C==   NYU IS THE NUMBER OF SCATTERPLOT LINES.                  ==FA C================================================================I       DO 670 I=1,NYUA C=================================================================A C==   IN THE FIRST COLUMN OF LINE2, WHICH IS THE ENTIRE        ==EA C==   SCATTERPLOT LINE (UPTO 132 CHARACTERS LONG), WE PUT A    ===A C==   BLANK OR IF WE ARE PAST THE IYLAB'TH LINE WE WILL PUT    == A C==   A Y-LABEL CHARACTER INTO LINE2(1).                       == A C================================================================2       LINE2(1)=BLANK       IYL=I-IYLAB+1P5       IF(IYL.GE.1.AND.IYL.LE.NYLAB)LINE2(1)=YLAB(IYL)HA C================================================================ A C==   LINE2(2) IS ALWAYS BLANK.                                ===A C================================================================.       LINE2(2)=BLANKA C================================================================YA C==   DETERMINE THE Y-SCALE VALUE, YIY, FOR THE CURRENT LINE #.== A C==   USING "RICON" CONVERT "YIY" INTO "NYWID" CHARACTERS IN   ==TA C==   LINE2(3).                                                ==SA C================================================================.       IY=NYU-I+1       IF(NY.GT.0)YIY=Y(IY)%       IF(NY.LT.0)YIY=Y(1)+(IY-1)*Y(2) #       IF(ABS(YIY).LT.YDFRAC)YIY=0.0)1       CALL RICON(YIY,LINE2(3),2,YFMT,NYWID,&1050)=A C================================================================ A C==   LINE2(NYWID+3) IS ALWAYS BLANK.                          == A C================================================================I       LINE2(NYWID+3)=BLANKA C=================================================================A C==   Y-AXIS AT THE LEFT HAND SIDE OF THE PAGE:                ===A C==   LINE2(ISTART) = "|" EXCEPT FOR EVERY 10'TH LINE FROM THE ==(A C==   BOTTOM OF THE SCATTERPLOT, IN WHICH CASE IT IS A "-".    ===A C================================================================(       LINE2(ISTART)=BAR=-       IF(IY-IY/10*10.EQ.1)LINE2(ISTART)=MINUS=A C================================================================AA C==   ZYSUM IS THE Y-PROJECTION ALONG THE CURRENT LINE.        == A C==   NOW FILL IN THE SCATTERPLOT BINS:                        == A C==   THE DO 665 LOOP FILLS THE REMAINDER OF LINE2 WITH THE    ===A C==   SCATTERPLOT BIN COUNTS WHICH ARE DETERMINED AS           ==6A C==   ZZ=Z(IX,IY)*ZSCALE.                                      ===A C=================================================================       ZYSUM=0.0=       ILINE=ISTART+1       IX=IXX       DO 665 J=1,NXX       ZZ=Z(IX,IY)*ZSCALE
       IX=IX+1=       ZYSUM=ZYSUM+ZZ1       IF(NBL.GT.0)CALL SETC(NBL,LINE2(ILINE),' ')N       ILINE=ILINE+NBLT5       IF(ZZ.EQ.0.)CALL SETC(NZWD,LINE2(ILINE),DIGIT0)Y=       IF(ZZ.NE.0.)CALL RICON(ZZ,LINE2(ILINE),2,ZFM,NZWD,&662)E       GO TO 664 & 662   CALL SETC(NZWD,LINE2(ILINE),'*') 664   ILINE=ILINE+NZWD 665   CONTINUEA C=================================================================A C==   Y-AXIS AT THE RIGHT HAND SIDE OF THE PAGE:               ===A C==   LINE2(NXAXIS) = THE Y-AXIS CHARACTER CORRESPONDING TO    ===A C==   THE CURRENT LINE.                                        ===A C=================================================================!       LINE2(NXAXIS)=LINE2(ISTART)=A C================================================================ A C==   LINE2(NXAXIS+1) IS ALWAYS BLANK.                         ===A C================================================================R       LINE2(NXAXIS+1)=BLANK=A C=================================================================A C==   USING "RICON" CONVERT "ZYSUM", THE Y-PROJECTION VALUE FOR==WA C==   THE CURRENT LINE INTO "NZWID" CHARACTERS IN              == A C==   LINE2(NXAXIS+2).                                         == A C================================================================T:       CALL RICON(ZYSUM,LINE2(NXAXIS+2),2,ZFMT,NZWID,&1060)A C================================================================2A C==   LINE2(IEND-1) IS ALWAYS BLANK.                           ==1A C================================================================C       LINE2(IEND-1)=BLANK=A C================================================================IA C==   IN THE LAST COLUMN (IEND) OF LINE2, WE PUT A BLANK OR IF ==WA C==   WE ARE PAST THE IYPROJ'TH LINE WE WILL PUT A Y-PROJECTION==EA C==   LABEL CHARACTER INTO LINE2(IEND).                        == A C=================================================================       LINE2(IEND)=BLANK=       IYP=I-IYPROJ+1:       IF(IYP.GE.1.AND.IYP.LE.NYPROJ)LINE2(IEND)=YPROJ(IYP)A C=================================================================A C==   NOW WE CAN WRITE OUT THE SCATTERPLOT LINE.               == A C================================================================ (       WRITE(IOUT,230)(LINE2(J),J=1,IEND) 670   CONTINUEA C=================================================================A C==   WRITE OUT THE X-AXIS AT THE BOTTOM OF THE PAGE.          ===A C=================================================================*       WRITE(IOUT,230)(XAXIS(I),I=1,NXAXIS)A C=================================================================A C==   ITIME = 1: IS COMPLETE HERE.                             ===A C=================================================================A C==   ITIME = 2: STARTS HERE.                                  ===A C=================================================================A C==   NOW INITIALIZE ARRAY ZX(I), NW, AND FMT, FOR ITIME=2.    ===A C=================================================================       IX=IXX       DO 680 I=1,NXX       IF(NX.GT.0)ZX(I)=X(IX)'       IF(NX.LT.0)ZX(I)=X(1)+(IX-1)*X(2)='       IF(ABS(ZX(I)).LT.XDFRAC)ZX(I)=0.0I
       IX=IX+1  680   CONTINUE       NW=NXWID       NW1=NXWID1        CALL MOVEC(NXFMT,XFMT,FMT)
       ITIME=2        GO TO 605CA C=================================================================A C==   ERROR MESSAGES:                                          ==-A C================================================================  1000  WRITE(IOUT,1001); 1001  FORMAT('0*** ERROR *** IN SCATP. DIMENSIONS NX & NY',="      *       ' MUST BE NON-ZERO.'/=      *       '               1''ST DIMENSION NX1 OF Z-ARRAY',       *       ' MUST BE > 0.') 
       RETURN1+ 1010  WRITE(IOUT,1011): 1011  FORMAT('0*** ERROR *** IN SCATP. FORMAT CODE: XFMT',      *       ' HAS NO ")" IN'/7      *       '               ITS 1''ST 10 CHARACTERS.')T
       RETURN1  1020  WRITE(IOUT,1021): 1021  FORMAT('0*** ERROR *** IN SCATP. FORMAT CODE: YFMT',      *       ' HAS NO ")" IN'/7      *       '               ITS 1''ST 10 CHARACTERS.') 
       RETURN1  1030  WRITE(IOUT,1031)B 1031  FORMAT('0*** ERROR *** IN SCATP. 1''ST FORMAT CODE OF ZFMT',      *       ' HAS NO ")" IN'/7      *       '               ITS 1''ST 10 CHARACTERS.')R
       RETURN1O 1040  WRITE(IOUT,1041): 1041  FORMAT('0*** ERROR *** IN SCATP. FORMAT CODE: XFMT',      *       ' IS INVALID.')
       RETURN1T 1050  WRITE(IOUT,1051): 1051  FORMAT('0*** ERROR *** IN SCATP. FORMAT CODE: YFMT',      *       ' IS INVALID.')
       RETURN1. 1060  WRITE(IOUT,1061)B 1061  FORMAT('0*** ERROR *** IN SCATP. 1''ST FORMAT CODE OF ZFMT',      *       ' IS INVALID.')
       RETURN1X 1070  WRITE(IOUT,1071)D 1071  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTH IN FORMAT CODE:',      *       ' XFMT MUST BE'/ @      *       '               IN THE RANGE: 1 <= XWIDTH <= 132.')
       RETURN1T 1080  WRITE(IOUT,1081)D 1081  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTH IN FORMAT CODE:',#      *       ' YFMT MUST BE => 1.')A
       RETURN1G 1090  WRITE(IOUT,1091)D 1091  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTH IN 1''ST FORMAT',*      *       ' CODE OF ZFMT MUST BE => 1')
       RETURN1= 1100  WRITE(IOUT,1101)B 1101  FORMAT('0*** ERROR *** IN SCATP. 2''ND FORMAT CODE OF ZFMT',      *       'HAS NO ")" IN '/7      *       '               ITS 1''ST 10 CHARACTERS.')=
       RETURN1  1110  WRITE(IOUT,1111)B 1111  FORMAT('0*** ERROR *** IN SCATP. 2''ND FORMAT CODE OF ZFMT',      *       ' IS INVALID.')
       RETURN1= 1120  WRITE(IOUT,1121)D 1121  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTH IN 2''ND FORMAT',*      *       ' CODE OF ZFMT MUST BE => 1')
       RETURN1= 1130  IF(ITYPE.GE.2)GO TO 1140       WRITE(IOUT,1131)? 1131  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTHS IN FORMAT',F$      *       ' CODES: YFMT,ZFMT(1)'/-      *       '               ARE TOO LARGE.',=4      *       ' YWIDTH+ZWIDTH1 MUST BE <= NWIDTH-9.')
       RETURN1O 1140  WRITE(IOUT,1141)? 1141  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTHS IN FORMAT',Z,      *       ' CODES: YFMT,ZFMT(1),ZFMT(2)'/-      *       '               ARE TOO LARGE.',4>      *       ' YWIDTH+ZWIDTH1+ZWIDTH2 MUST BE <= NWIDTH - 8.'/@      *       '               NOTE: ZWIDTH2 IS ONE GREATER THAN',+      *       ' THE SPECIFIED FORMAT WIDTH'/,>      *       '               IF THE FORMAT IS E,D OR G TYPE.')
       RETURN1= 1150  IF(ITIME.EQ.1)GO TO 1060       GO TO 1040	       ENDA