B       SUBROUTINE SCATP(X,Y,Z,NX,NY,NX1,XLAB,NXLAB,YLAB,NYLAB,XFMT,@      *                 YFMT,ZFMT,TITLE,NTITLE,ITYPE,ZMAX,NWIDTH,2      *                 IOUT,IEMPTY,DIGITS,NDIGS,*) C  C     LIBRARY-ROUTINE  C < C                                                06/AUG/1980> C                                                C.J. KOST SIN C   > C     reqd. KOSTL: routines - DTB,EQUC,FINDST,MOVEC,RICON,SETC C A C================================================================ A C================================================================ A C==                                                            == A C==   SCATP: SCATTERPLOTS THE NX * NY BIN COUNTS STORED IN "Z" == A C==   AGAINST THE HORIZONTAL "X" AXIS VALUES AND THE VERTICAL  == A C==   "Y" AXIS VALUES. "Z(I,J)" IS THE NUMBER OF BIN COUNTS AT == A C==   THE LOCATION WITH COORDINATES: (X(I),Y(J)).              == A C==                                                            == A C==   WRITTEN BY ARTHUR HAYNES, TRIUMF U.B.C., NOV. 17, 1978.  == A C==                                                            == A C==   INPUT PARAMETERS:                                        == A C==   X(NX),Y(NY),Z(NX1,NY),ZMAX (R*4); NX,NY,NX1,NXLAB,NYLAB, == A C==   NTITLE,ITYPE,NWIDTH,IOUT,IEMPTY,NVAL,NDIGS (I*4);        == A C==   XLAB(NXLAB),YLAB(NYLAB),XFMT,YFMT,ZFMT,TITLE(NTITLE),    == A C==   DIGITS(NDIGS) (L*1).                                     == A C==                                                            == A C==   OUTPUT PARAMETERS: NONE.                                 == A C==                                                            == A C==   PARAMETER DEFINITIONS:                                   == A C==   --------- -----------                                    == A C==                                                            == A C==   X     : ARRAY OF "NX" HORIZONTAL X-AXIS VALUES.          == A C==           THE "X" VALUES CAN BE POSITIVE, NEGATIVE OR ZERO,== A C==           AND THEY DO NOT HAVE TO BE IN ANY ORDER.         == A C==           IF NX < 0 THEN X(I) IS ASSUMED TO BE AN EQUALLY  == A C==           SPACED ARRAY WITH |NX| VALUES GIVEN BY:          == A C==           X(I) = X(1)+(I-1)*X(2), I=1,...,|NX|. NOTE: WHEN == A C==           NX < 0 THEN ONLY THE FIRST 2 ELEMENTS OF "X" ARE == A C==           USED. THERE IS NO LIMIT TO THE ARRAY SIZE |NX|;  == A C==           THE SCATTERPLOT X-BINS WILL BE PRINTED ACROSS AS == A C==           MANY PAGES AS NECESSARY. SEE "PARAMETER          == A C==           RESTRICTIONS AND FORMULAS" FOR THE MAXIMUM NUMBER== A C==           OF X-BINS PER PAGE.                              == A C==                                                            == A C==   Y     : ARRAY OF "NY" VERTICAL Y-AXIS VALUES.            == A C==           THE "Y" VALUES CAN BE POSITIVE, NEGATIVE OR ZERO,== A C==           AND THEY DO NOT HAVE TO BE IN ANY ORDER.         == A C==           IF NY < 0 THEN Y(I) IS ASSUMED TO BE AN EQUALLY  == A C==           SPACED ARRAY WITH |NY| VALUES GIVEN BY:          == A C==           Y(I) = Y(1)+(I-1)*Y(2), I=1,...,|NY|. NOTE: WHEN == A C==           NY < 0 THEN ONLY THE FIRST 2 ELEMENTS OF "Y" ARE == A C==           USED. THERE IS NO LIMIT TO THE ARRAY SIZE |NY|;  == A C==           THE SCATTERPLOT Y-BINS WILL BE PRINTED DOWN AS   == A C==           MANY PAGES AS NECESSARY.                         == A C==                                                            == A C==   Z     : ARRAY OF |NX| * |NY| BIN COUNTS TO BE SCATTER-   == A C==           PLOTTED AGAINST THE HORIZONTAL "X" AXIS VALUES   == A C==           AND THE VERTICAL "Y" AXIS VALUES. "Z(I,J)" IS THE== A C==           NUMBER OF BIN COUNTS AT THE LOCATION WITH        == A C==           COORDINATES: (X(I),Y(J)).                        == A C==                                                            == A C==   NX    : |NX| IS THE NUMBER OF X-AXIS BIN VALUES.         == A C==                                                            == A C==   NY    : |NY| IS THE NUMBER OF Y-AXIS BIN VALUES.         == A C==                                                            ==BA C==   NX1   : IS THE FIRST DIMENSION OF THE Z-ARRAY.           ==IA C==           NX1 IS ALWAYS => |NX|.                           == A C==                                                            == A C==   XLAB  : X-AXIS LABEL CONSISTING OF "NXLAB" CHARACTERS.   ==JA C==                                                            ==EA C==   NXLAB : NUMBER OF CHARACTERS IN "XLAB".                  ===A C==                                                            ===A C==   YLAB  : Y-AXIS LABEL CONSISTING OF "NYLAB" CHARACTERS.   == A C==                                                            ==SA C==   NYLAB : NUMBER OF CHARACTERS IN "YLAB".                  ==TA C==                                                            ==BA C==   XFMT  : FORMAT OF THE X-AXIS (HORIZONTAL) VALUES.        == A C==           EG. XFMT = '(I5)' OR '(F10.3)' OR '(E12.5)' OR   == A C==           '(G11.5)'. NOTE: THE X ARRAY IS ALWAYS ASSUMED TO==VA C==           BE REAL EVEN WHEN THE FORMAT IS INTEGER FORMAT.  == A C==                                                            == A C==   YFMT  : FORMAT OF THE Y-AXIS (HORIZONTAL) VALUES.        ==,A C==           EG. YFMT = '(I5)' OR '(F10.3)' OR '(E12.5)' OR   ==(A C==           '(G11.5)'. NOTE: THE Y ARRAY IS ALWAYS ASSUMED TO==EA C==           BE REAL EVEN WHEN THE FORMAT IS INTEGER FORMAT.  == A C==                                                            == A C==   ZFMT  : FORMAT OF THE X AND Y PROJECTIONS OF THE SCATTER-== A C==           PLOT BIN COUNTS.                                 == A C==                                                            == A C==           IF ITYPE <= 1 THEN THIS IS THE ONLY FORMAT       == A C==           REQUIRED; EG. ZFMT = '(I4)' OR '(F8.2)' OR       == A C==           '(D10.4)' OR '(E11.5)' OR '(G11.4)'.             ==UA C==                                                            ==AA C==           IF ITYPE => 2 THEN THIS FORMAT CODE MAY BE       ==RA C==           FOLLOWED BY A SECOND CODE WHICH IS THE FORMAT OF ==EA C==           THE BIN COUNTS WHICH ARE TO BE PRINTED ON THE    == A C==           SCATTERPLOT; EG. ZFMT = '(I4)(I3)' OR '(I4) ' OR ==|A C==           '(E11.3)(F7.3)' OR '(F10.5) '. NOTE: IN THIS CASE==TA C==           IF THE 2'ND Z-FORMAT CODE IS NOT SPECIFIED THEN  ==YA C==           IT WILL BY DEFAULT EQUAL THE 1'ST Z-FORMAT CODE  ==TA C==           AND THE 1'ST Z-FORMAT CODE MUST BE FOLLOWED BY AT==EA C==           LEAST ONE BLANK.                                 ==MA C==                                                            == A C==           NOTE: THE 2-DIMENSIONAL Z ARRAY IS ALWAYS ASSUMED== A C==           TO BE REAL EVEN WHEN THE FORMAT IS INTEGER       ==SA C==           FORMAT.                                          ==AA C==                                                            ==RA C==           NOTE:                                            ==EA C==           WHEN ITYPE <= 1 THEN THE SCATTERPLOT IS A        == A C==           "CHARACTER SCATTERPLOT", I.E. EACH BIN COUNT IS  ==|A C==           REPRESENTED BY 1 CHARACTER AND HENCE THE NUMBER  ==TA C==           OF CHARACTERS PER BIN = 1.                       ==YA C==           WHEN ITYPE => 2 THEN THE SCATTERPLOT IS A        ==TA C==           "NUMBER SCATTERPLOT", I.E. EACH BIN COUNT IS     == A C==           PRINTED AS A FORMATTED NUMBER USING THE 2'ND     == A C==           Z FORMAT CODE IN "ZFMT". IF THE FORMAT CODE IS   ==BA C==           "I" OF "F" TYPE THEN THE NUMBER OF CHARACTERS PER==AA C==           BIN = ZWIDTH2 (THE 2'ND Z FORMAT WIDTH). IF THE  ==ZA C==           FORMAT CODE IS "E", "D", OR "G" TYPE THEN        ==NA C==           THEN THE NUMBER OF CHARACTERS PER BIN = ZWIDTH2  == A C==           + 1, I.E. EACH BIN COUNT NUMBER IS PRINTED IN A  == A C==           A FORMAT FIELD WITH WIDTH "ZWIDTH2" AND THESE    ==LA C==           FIELDS ARE SEPARATED BY SINGLE BLANKS.           == A C==                                                            ==LA C==           NOTE: "XFMT", "YFMT", AND "ZFMT" MUST NOT HAVE   == A C==                 ANY IMBEDDED BLANKS.                       ==AA C==                                                            == A C==   TITLE : SCATTERPLOT TITLE CONSISTING OF "NTITLE"         == A C==           CHARACTERS. NOTE: THE TITLE IS PRINTED OUT       ==CA C==           STARTING AT THE FIRST COLUMN OF THE PAGE AND THE == A C==           1'ST CHARACTER OF "TITLE" IS TREATED AS A        == A C==           CARRIAGE CONTROL.                                == A C==                                                            ==CA C==   NTITLE: THE NUMBER OF CHARACTERS IN "TITLE".             == A C==                                                            == A C==           IF ITYPE <= 1 THEN THE SCATTERPLOT IS A          == A C==           "CHARACTER SCATTERPLOT", I.E. EACH BIN COUNT IS  ==AA C==           REPRESENTED BY 1 CHARACTER.                      ==(A C==                                                            ==AA C==           IF ITYPE => 2 THEN THE SCATTERPLOT IS A "NUMBER  ==EA C==           SCATTERPLOT", I.E. EACH BIN COUNT IS PRINTED AS  == A C==           A FORMATTED NUMBER USING THE 2'ND Z FORMAT CODE  ==AA C==           "ZFMT".                                          ==(A C==                                                            ==AA C==   ZMAX  : IF ITYPE <= 1, THEN ZMAX CONTROLS THE AUTOMATIC  ==EA C==           SCALING OF THE POSITIVE BIN COUNTS OF THE        == A C==           "CHARACTER SCATTERPLOT". NEGATIVE BIN COUNTS ARE ==FA C==           IGNORED IN THE SCALING AND ARE PRINTED ON THE    == A C==          PLOT AS "-"'S (IF DEFAULT DIGITS ARE USED)        == A C==          THAT IS, IF A BIN COUNT EXCEEDS ZMAX ALL COUNTS   == A C==          ARE DIVIDED BY THE LOWEST INTEGRAL WHICH WILL     ==.A C==          BRING THE DATA WITHIN "ZMAX". THIS WILL BE PRINTED==.A C==          NEAR THE TITLE TO INFORM USER OF RENORMALIZATION  == A C==          FACTOR THAT WAS USED.                             == A C==   IOUT  : OUTPUT UNIT NUMBER (USUALLY SET TO 6) FOR PLOT   ==TA C==                                                            ==TA C==   NWIDTH: SPECIFIES COLUMN WIDTH OF OUTPUT DEVICE          ==OA C==           THE PROGRAM AUTOMATICALLY "PAGES" WHEN THE OUTPUT==:A C==           FORMAT & NX CAUSES THIS TO BE EXCEEDED.          ==EA C==                                                            ==-A C==                                                            ==FA C==   IEMPTY: IF .EQ. 0 BLANKS ZERO COUNTS , ELSE PRINTS ZERO  == A C==                                                            == A C==   DIGITS: SET OF USER SUPPLIED ALTERNATE CHARACTERS        ==AA C==           THE FIRST DIGIT IS RESERVED FOR NEGATIVE COUNTS  ==IA C==           THE SECOND DIGIT FOR ABSOLUTE ZEROS. THE THIRD   == A C==           FOR COUNTS BETWEEN 0. & 0.5 . THE FOURTH FOR     == A C==           COUNTS BETWEEN 0.5 & 1.5  ETC.                   == A C==                                                            ==TA C==                                                            ==BA C==   NDIGS : NUMBER OF USER SUPPLIED DIGITS (CHARACTERS)      ==EA C==                                                            == A C==   PARAMETER RESTRICTIONS AND FORMULAS:                     ==TA C==   --------- ------------ --- --------                      == A C==                                                            == A C==   NOTE:                                                    ==MA C==                                                            ==CA C==   DEFINITIONS:                                             ==DA C==   XWIDTH  = FORMAT WIDTH OF X FORMAT IN "XFMT".            ==EA C==   YWIDTH  = FORMAT WIDTH OF Y FORMAT IN "YFMT".            ==IA C==   ZWIDTH1 = FORMAT WIDTH OF 1'ST Z FORMAT CODE IN "ZFMT".  ==PA C==   ZWIDTH2 = NUMBER OF CHARACTERS PER BIN;                  == A C==           = 1, IF ITYPE <= 1;                              ==KA C==           = FORMAT WIDTH OF 2'ND Z FORMAT CODE IN "ZFMT",  == A C==             IF ITYPE => 2 AND FORMAT IS "I" OR "F" TYPE;   ==SA C==           = FORMAT WIDTH + 1 OF 2'ND Z FORMAT CODE IN      == ? C==             "ZFMT", IF ITYPE => 2 AND FORMAT IS "E", "D",== A C==             OR "G" TYPE, (I.E. FOR "E","D", OR "G" TYPE    ==NA C==             FORMAT CODES THERE IS AN EXTRA SPACE USED TO   ==IA C==             SEPARATE THE BIN COUNT FIELDS, WHILE FOR "I" OR==HA C==             "F" TYPE FORMAT CODES THERE IS NO SEPARATOR).  ==TA C==                                                            == A C==   RETURN1:                                                 == A C==   AN ERROR RETURN FROM "SCATP" CONSISTS OF AN ERROR MESSAGE==EA C==   PRINTED ON UNIT "IOUT" INDICATING THE ERROR AND A RETURN1== A C==   TO THE CALLING PROGRAM.                                  ==TA C==                                                            ==HA C==   IN EACH OF THE FOLLOWING RESTRICTIONS THE STATEMENT IN   == A C==   PARENTHESES TELLS WHAT WILL HAPPEN IF THE RESTRICTION IS == A C==   VIOLATED.                                                ==TA C==                                                            == A C==   1) 11 <= NWIDTH <= 132, ("NWIDTH" IS TRUNCATED TO THESE  == A C==      LIMITS USING AN INTERNAL VARIABLE NWID=TRUNC(NWIDTH), == A C==      HOWEVER, THE VARIABLE "NWIDTH" IS NOT TAMPERED WITH). == A C==   2) 1 <= XWIDTH <= 132, (ERROR RETURN).                   == A C==   3) 1 <= YWIDTH,        (ERROR RETURN).                   ==SA C==   4) 1 <= ZWIDTH1,       (ERROR RETURN).                   == A C==   5) 1 <= ZWIDTH2,       (ERROR RETURN).                   ==IA C==   6) YWIDTH+ZWIDTH1+ZWIDTH2 <= NWIDTH - 8, (ERROR RETURN). ==RA C==   7) MAXIMUM NUMBER OF X-BINS/PAGE                         ==AA C==      = (NWIDTH-8-YWIDTH-ZWIDTH1)/ZWIDTH2,                  == A C==      DUE TO THE ABOVE RESTRICTIONS THIS WILL ALWAYS BE > 0.== A C==   8) |NX|*|NY| > 0, (ERROR RETURN).                        ==EA C==   9) NX1 > 0,       (ERROR RETURN).                        == A C==  10) IF NXLAB  <= 0 THEN XLAB WILL NOT BE USED.            ==OA C==      IF NYLAB  <= 0 THEN YLAB WILL NOT BE USED.            == A C==      IF NTITLE <= 0 THEN TITLE WILL NOT BE USED.           ==DA C==      IF NDIGS  <= 0 THEN DIGITS WILL NOT BE USED.          == A C==                                                            ==EA C================================================================ A C============   USEFUL NOTES & COMMENTS ON SUBROUTINE USAGE ===== A C== CARE SHOULD BE TAKEN THAT THE CALLING PARAMETERS MATCH     ==SA C== IN TYPE WITH THOSE OF THIS SUBROUTINE. PARTICULARLY THAT   == A C== CHARACTER STRINGS ARE INPUT AS LOGICAL*1 NOT AS "CHARACTER"==AA C== DECLARED TYPES VARIABLES. QUOTE STRING HOLLERITH CONSTANTS ==EA C== AS ACTUAL ARGUMENTS OF A CALL ARE ALSO ALLOWED.            ==OA C==                                                            == A C==     NOTE ON "CONTOUR" PRINTER PLOTTING.                    == A C==                                                            == A C==   TO CONTOUR PLOT AN ARRAY ON THE LINE PRINTER THE USER    == A C==   SHOULD FIRST SCALE HIS Z(NX,NY) ARRAY BETWEEN 0 AND      ==HA C==   THE MAXIMUM NUMBER OF USER SPECIFIED DIGITS ("NDIGS") -2 == A C==   THE FOLLOWING SET OF DIGITS IS RECOMMENDED FOR CASE      == A C==   NDIGS=12     '- 0 2 4 6 8 '                              == A C==   THIS WILL GIVE ALTERNATING BLANK CONTOUR "BANDS"         == A C==                                                            == A C=================  SAMPLE OF ABOVE USE  ======================== : C========================================================= C 6 C    SAMPLE USE OF SCATP , A PROGRAM THAT SCATTERPLOTS5 C    THE NX*NY BIN COUNTS STORED IN A TWO DIMENSIONALM C    ARRAY.  CM: C========================================================= C     REAL Z(45,70),X(40),Y(70)= C     CHARACTER*24 CXLAB,CYLAB C     CHARACTER*16 CXFMT,CYFMT C     CHARACTER*32 CZFMT C     CHARACTER*25 CTITLE + C     LOGICAL*1 XLAB(24),YLAB(24),TITLE(25)W* C     LOGICAL*1 XFMT(16),YFMT(16),ZFMT(16) C     LOGICAL*1 DIGITS(22) C     CHARACTER*22 DIG( C     DATA DIG/'- 0 2 4 6 8 A C E G I '/ C     EQUIVALENCE (DIGITS,DIG)+ C     EQUIVALENCE (XLAB,CXLAB),(YLAB,CYLAB)   C     EQUIVALENCE (TITLE,CTITLE)8 C     EQUIVALENCE (XFMT,CXFMT),(YFMT,CYFMT),(ZFMT,CZFMT), C     DATA CXLAB/'THIS IS A SAMPLE X LABEL'/, C     DATA CYLAB/'THIS IS A SAMPLE Y LABEL'/. C     DATA CTITLE/'1THIS IS A SAMPLE TITLE  '/ C     DATA CXFMT/'(I3) '/F C     DATA CYFMT/'(I4) '/A C     DATA CZFMT/'(I4)(I1)'/ C     NX=40  C     NY=42  C     DO 10 J=1,NY C 3 CC    NORMALIZE Z(I,J) BETWEEN 0&10 AND PROVIDE OWN ( CC    CHARACTER SET TO PRODUCE CONTOUTS. CT C     DO 20 I=1,NX$ C     Z(I,J)=COS(I/10.)*SIN(J/7.)+1. C     Z(I,J)=Z(I,J)*5R C 20  CONTINUE C 10  CONTINUE C     DO 30 I=1,NX C     X(I)=I C 30  CONTINUE C     DO 40 J=1,NY C     Y(J)=2*J C 40  CONTINUE C     NX1=45 C     NXLAB=24 C     NYLAB=24 C     NTITLE=24I
 C     ITYPE=1N C     IOUT=6
 C     ZMAX=0.  C     NDIGS=22 C     NWIDTH=80T C     IEMPTY=07 C     CALL SCATP(X,Y,Z,NX,NY,NX1,XLAB,NXLAB,YLAB,NYLAB, 4 C    #            XFMT,YFMT,ZFMT,TITLE,NTITLE,ITYPE,; C    #            ZMAX,NWIDTH,IOUT,IEMPTY,DIGITS,NDIGS,&99)H C     STOP 'NORMAL EXIT' C 99  WRITE(6,100)) C100  FORMAT(' ERROR RETURN FROM SCATPL')H	 C     END < C===========================================================< C===========================================================< C==            OUTPUT OF SAMPLE PROGRAM                  ===< C=========================================================== CTHIS IS A SAMPLE TITLE % C                   COUNTS =  8394.19 # C                      X PROJECTION+ CD1 C        2222222222222222222222222222222222222222 1 C        1111111111111111111111100000000000000001 1 C        1111111000000000000000099999999999999990I2 C       +|---------|---------|---------|---------+7 C    84 |444444444444       666666666666666666666|  212*7 C    82 -       444444     66666                6-  217 7 C    80 |222      4444    6666      88888888     |  223 7 C    78 |222222    4444   666    88888888888888  |  227 7 C    76 |   22222   444   66   88888        8888 |  232T7 C    74 |     2222   44  666   888            888|  235T7 C    72 |0     222   44  666  888      AA      88|  238 7 C    70 |000    222  44  66   88    AAAAAAA    88|  240 7 C    68 |0000   222  44  66   88    AAAAAAAA    8|  242=7 CT   66 |0000   222  44  66  888   AAAAAAAAA    8|  242=7 CH   64 |0000   222  44  66   88    AAAAAAAA    8|  242T7 CI   62 -000    222  44  66   88    AAAAAAA    88-  240N7 CS   60 |0     222   44  666  888     AAA      88|  238S7 C    58 |     2222   44  666   888            888|  235G7 CI   56 |   22222   444   66   88888        8888 |  232R9 CS   54 |2222222   4444   666    88888888888888  |  228 Y=7 C    52 |222      4444    6666      88888888     |  223 9 CA   50 |       444444     66666                6|  217 P 9 C    48 |444444444444       666666666666666666666|  212 R 9 CS   46 |44444444               6666666666666666 |  206 O 9 CA   44 |                                        |  200 JR9 CM   42 -6666666                4444444444444444 -  194 ES9 CP   40 |666666666666       444444444444444444444|  188 CA9 CL   38 |       666666     44444                4|  183 T 9 CE   36 |888      6666    4444      22222222     |  177 I=9 C    34 |8888888   6666   444    22222222222222  |  173 O 9 CY   32 |   88888   666   44   22222        2222 |  168 N"7 C    30 |     8888   66  444   222            222|  165 7 CL   28 |A     888   66  444  222     000      22|  162O7 CA   26 |AAA    888  66  44   22    0000000    22|  160=7 CB   24 |AAAA   888  66  44   22    00000000    2|  158 7 CE   22 -AAAA   888  66  44  222   000000000    2-  158Y7 CL   20 |AAAA   888  66  44   22    00000000    2|  158M7 C    18 |AAA    888  66  44   22    0000000    22|  160=7 C    16 |A     888   66  444  222     000      22|  162C7 C    14 |     8888   66  444   222            222|  165E7 C    12 |   88888   666   44   22222        2222 |  168L7 C    10 |8888888   6666   444    22222222222222  |  173(7 C     8 |888      6666    4444      22222222     |  177*7 C     6 |       666666     44444                4|  183Q7 C     4 |666666666666       444444444444444444444|  188L7 C     2 -6666666                4444444444444444 -  194A2 C       +|---------|---------|---------|---------+ CA1 C                 1111111111222222222233333333334B1 C        1234567890123456789012345678901234567890H) C                THIS IS A SAMPLE X LABEL'D C===================================================================: C========================================================= CZ' C         SAMPLE OF NUMBER SCATTERPLOT.C6 C    SAMPLE USE OF SCATP , A PROGRAM THAT SCATTERPLOTS5 C    THE NX*NY BIN COUNTS STORED IN A TWO DIMENSIONAL, C    ARRAY.  C0: C========================================================= C     REAL Z(50,70),X(50),Y(70), C     CHARACTER*24 CXLAB,CYLAB C     CHARACTER*16 CXFMT,CYFMT C     CHARACTER*32 CZFMT C     CHARACTER*25 CTITLE + C     LOGICAL*1 XLAB(24),YLAB(24),TITLE(25) * C     LOGICAL*1 XFMT(16),YFMT(16),ZFMT(16)+ C     EQUIVALENCE (XLAB,CXLAB),(YLAB,CYLAB)   C     EQUIVALENCE (TITLE,CTITLE)8 C     EQUIVALENCE (XFMT,CXFMT),(YFMT,CYFMT),(ZFMT,CZFMT), C     DATA CXLAB/'THIS IS A SAMPLE X LABEL'/, C     DATA CYLAB/'THIS IS A SAMPLE Y LABEL'/. C     DATA CTITLE/'1THIS IS A SAMPLE TITLE  '/ C     DATA CXFMT/'(I3) '/= C     DATA CYFMT/'(I4) '/= C     DATA CZFMT/'(I4)(I3)'/ C     NX=30= C     NY=70  C     DO 10 J=1,NY C     DO 20 I=1,NX C     Z(I,J)=I+J C     IF(I.EQ.J)Z(I,J)=0.= C 20  CONTINUE C 10  CONTINUE C     DO 30 I=1,NX C     X(I)=I C 30  CONTINUE C     DO 40 J=1,NY C     Y(J)=2*J C 40  CONTINUE C     NX1=50 C     NXLAB=24 C     NYLAB=24 C     NTITLE=24 
 C     ITYPE=21 C     IOUT=6 C     ZMAX=100. 
 C     NDIGS=11 C     NWIDTH=709 C     IEMPTY=07 C     CALL SCATP(X,Y,Z,NX,NY,NX1,XLAB,NXLAB,YLAB,NYLAB, 4 C    #            XFMT,YFMT,ZFMT,TITLE,NTITLE,ITYPE,; C    #            ZMAX,NWIDTH,IOUT,IEMPTY,DIGITS,NDIGS,&99)  C     STOP 'NORMAL EXIT' C 99  WRITE(6,100)) C100  FORMAT(' ERROR RETURN FROM SCATPL')8	 C     END D C===================================================================C C==================================================================  C2 C4H CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC' C         NOW FOR THE REAL PROGRAM  !!!4 C6 C %       REAL X(1),Y(1),Z(NX1,1),ZX(122)0:       LOGICAL*1 XLAB(1),YLAB(1),XFMT(10),YFMT(10),ZFMT(10)(       LOGICAL*1 TITLE(1),FMT(10),ZFM(10)2       LOGICAL*1 LINE(10,122),LINE2(132),XAXIS(132)1       COMMON /C0MM0N/ ZX,LINE2,LINE,FMT,ZFM,XAXIS        LOGICAL EQUC,EMPTY$       LOGICAL*1 MINUS,BLANK,PLUS,BAR3       DATA MINUS/'-'/,BLANK/' '/,PLUS/'+'/,BAR/'|'/8#       LOGICAL*1 XPROJ(12),YPROJ(12) A       DATA XPROJ/'X',' ','P','R','O','J','E','C','T','I','O','N'/ A       DATA YPROJ/'Y',' ','P','R','O','J','E','C','T','I','O','N'/ (       DATA NXPROJ,NYPROJ/12,12/,NDIG/39/1       LOGICAL*1 DIGIT(39),DIGITS(1),DIGIT0,NFIRST        DATA NFIRST/.FALSE./       IF(NFIRST)GO TO 10       NFIRST=.TRUE. @       CALL MOVEC(NDIG,'- 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ+',      *           DIGIT)4 10    NXU=IABS(NX)       NYU=IABS(NY)4       IF(NXU.LE.0.OR.NYU.LE.0.OR.NX1.LE.0)GO TO 1000       MAXDIG=MAX0(NDIG,NDIGS)8       DIGIT0=DIGIT(2) $       IF(NDIGS.GE.2)DIGIT0=DIGITS(2)       NWID=NWIDTH2       IF(NWID.GT.132)NWID=1323       IF(NWID.LT.11)NWID=112.       CALL FINDST(XFMT,10,')',1,1,NXFMT,&1010).       CALL FINDST(YFMT,10,')',1,1,NYFMT,&1020).       CALL FINDST(ZFMT,10,')',1,1,NZFMT,&1030)       IF(NXFMT.LT.4)GO TO 1040       IF(NYFMT.LT.4)GO TO 1050       IF(NZFMT.LT.4)GO TO 1060       NCHAR=NXFMT-322       CALL DTB(XFMT(3),NXWID,NCHAR,NSIG,' ',&1040).       IF(NXWID.LT.1.OR.NXWID.GT.132)GO TO 1070       NCHAR=NYFMT-3A2       CALL DTB(YFMT(3),NYWID,NCHAR,NSIG,' ',&1050)       IF(NYWID.LT.1)GO TO 1080       NCHAR=NZFMT-3 2       CALL DTB(ZFMT(3),NZWID,NCHAR,NSIG,' ',&1060)       IF(NZWID.LT.1)GO TO 1090       IF(ITYPE.LE.1)GO TO 120 *       IF(EQUC(ZFMT(NZFMT+1),'('))GO TO 100       NZFM=NZFMT        CALL MOVEC(NZFMT,ZFMT,ZFM)       GO TO 110 6 100   CALL FINDST(ZFMT(NZFMT+1),10,')',1,1,NZFM,&1100)(       CALL MOVEC(NZFM,ZFMT(NZFMT+1),ZFM) 110   IF(NZFM.LT.4)GO TO 11106       NCHAR=NZFM-30       CALL DTB(ZFM(3),NZWD,NCHAR,NSIG,' ',&1110)       IF(NZWD.LT.1)GO TO 1120  120   NFMT=NYWID+NZWID+8
       NZWD1=13       IF(ITYPE.GE.2)GO TO 1605        IF(NFMT.GE.NWID)GO TO 1130       GO TO 200S 160   NZWID1=NZWID       NZWD1=NZWD       NXWID1=NXWID?       IF(EQUC(ZFMT(2),'E').OR.EQUC(ZFMT(2),'G'))NZWID1=NZWID1+1=*       IF(EQUC(ZFMT(2),'D'))NZWID1=NZWID1+1;       IF(EQUC(ZFM(2),'E').OR.EQUC(ZFM(2),'G'))NZWD1=NZWD1+1R'       IF(EQUC(ZFM(2),'D'))NZWD1=NZWD1+1C?       IF(EQUC(XFMT(2),'E').OR.EQUC(XFMT(2),'G'))NXWID1=NXWID1+1=*       IF(EQUC(XFMT(2),'D'))NXWID1=NXWID1+1&       IF(NFMT+NZWD1.GT.NWID)GO TO 1140 200   ZSCALE=1.0       ISCALE=1       IF(ZMAX.EQ.0.)GO TO 208 
       ZMX=0.0C       DO 204 J=1,NYU       DO 202 I=1,NXU       IF(ITYPE.EQ.2)GO TO 2015!       IF(Z(I,J).GT.ZMX)ZMX=Z(I,J)6       GO TO 202 + 201   IF(ABS(Z(I,J)).GT.ZMX)ZMX=ABS(Z(I,J))  202   CONTINUE 204   CONTINUE-       IF(ZMX.LE.0. .OR. ZMAX.GE.ZMX)GO TO 208Z       ZSCALE=ABS(ZMAX)/ZMX        IF(ZSCALE.GE.1.0)GO TO 205       ZSCALE=1./ZSCALE       ISCALE=ZSCALE+.999       ZSCALE=1.0/ISCALET       GO TO 208A 205   ISCALE=ZSCALE        ZSCALE=ISCALE= 208   IYLAB=(NYU-NYLAB)/2+1/       IF(IYLAB.LT.1)IYLAB=1        IYPROJ=(NYU-NYPROJ)/2+1        IF(IYPROJ.LT.1)IYPROJ=1        ISTART=NYWID+4
       IPAGE=0        NXMAX=(NWID-NFMT)/NZWD1,       IXX=1)       NXX=0T 210   IXX=IXX+NXX=       NXX=NXU-IXX+1        IF(NXX.LE.0)RETURN       IF(NXX.GT.NXMAX)NXX=NXMAX4       IPAGE=IPAGE+1        ZSUM=0.0       IX=IXX       EMPTY=.TRUE.       DO 250 I=1,NXX       ZXSUM=0.0P       DO 240 J=1,NYU$       IF(Z(IX,J).NE.0.)EMPTY=.FALSE.        ZXSUM=ZXSUM+Z(IX,J)*ZSCALE 240   CONTINUE
       IX=IX+1        ZX(I)=ZXSUMT       ZSUM=ZSUM+ZXSUMI 250   CONTINUE(       IF(EMPTY.AND.IEMPTY.EQ.1)GO TO 210)       IF(NTITLE.GT.0)WRITE(IOUT,220)TITLE  220   FORMAT(255A1)=       NCHAR=21       IF(ZSCALE.LT.1.)NCHAR=63       IF(ZSCALE.GT.1.)NCHAR=61       SCALE=ISCALE       NXZ=NXX*NZWD1="       NBLANK=NYWID+6+(NXZ-NCHAR)/2-       IF(NBLANK.GT.132-NCHAR)NBLANK=132-NCHARC       IF(NBLANK.LT.1)NBLANK=1P        IF(ZSCALE.NE.1.0)GO TO 255%       CALL MOVEC(9,'COUNTS = ',LINE2)A/       CALL RICON(ZSUM,LINE2(10),2,'(G12.6)',12)        GO TO 258LD 255   IF(ZSCALE.LT.1.0)CALL MOVEC(22,'COUNTS SCALED DOWN BY ',LINE2)B       IF(ZSCALE.GT.1.0)CALL MOVEC(20,'COUNTS SCALED UP BY ',LINE2)6       CALL RICON(SCALE,LINE2(NCHAR-40),2,'(G11.6)',11)9       CALL MOVEC(18,'  SCALED COUNTS = ',LINE2(NCHAR-29))I6       CALL RICON(ZSUM ,LINE2(NCHAR-11),2,'(G12.6)',12)< 258   WRITE(IOUT,230)(BLANK,I=1,NBLANK),(LINE2(I),I=1,NCHAR)"       NBLANK=ISTART+(NXZ-NXPROJ)/2/       IF(NBLANK.GT.132-NXPROJ)NBLANK=132-NXPROJ/%       IF(NXU.GT.NXMAX)NBLANK=NBLANK-7I       IF(NBLANK.LT.1)NBLANK=1/8       IF(NXU.LE.NXMAX)WRITE(IOUT,230)(BLANK,I=1,NBLANK),      *  (XPROJ(I),I=1,NXPROJ)6 230   FORMAT('9',132A1)W>       IF(NXU.GT.NXMAX)WRITE(IOUT,235)IPAGE,(BLANK,I=1,NBLANK),      *  (XPROJ(I),I=1,NXPROJ)N 235   FORMAT('9PAGE',I3,132A1)"       CALL SETC(NYWID+3,XAXIS,' ')       XAXIS(ISTART)=PLUS
       MULT=10I       IF(NZWD1.GE.2)MULT=5       DO 259 I=1,NXZ       XAXIS(ISTART+I)=MINUSI9       IF(MOD(I-NZWD1,MULT*NZWD1).EQ.0)XAXIS(ISTART+I)=BAR1 259   CONTINUE       NXAXIS=ISTART+NXZ+1M       XAXIS(NXAXIS)=PLUS       IEND=NXAXIS+NZWID+33       IF(ITYPE.GE.2)GO TO 6000       NW=NZWID        CALL MOVEC(NZFMT,ZFMT,FMT)
       ITIME=10 260   IWW=1=       NWW=0  270   IWW=IWW+NWWN       NWW=NW-IWW+1       IF(NWW.LE.0)GO TO 300R       IF(NWW.GT.10)NWW=10        DO 280 I=1,NXX,       CALL RICON(ZX(I),LINE2,2,FMT,NW,&1150)*       CALL MOVEC(NWW,LINE2(IWW),LINE(1,I)) 280   CONTINUE       DO 290 I=1,NWW;       WRITE(IOUT,230)(BLANK,J=1,ISTART),(LINE(I,J),J=1,NXX)  290   CONTINUE       GO TO 270  300   IF(ITIME.EQ.2)GO TO 400 *       WRITE(IOUT,230)(XAXIS(I),I=1,NXAXIS)       DO 320 I=1,NYU       LINE2(1)=BLANK       IYL=I-IYLAB+1,5       IF(IYL.GE.1.AND.IYL.LE.NYLAB)LINE2(1)=YLAB(IYL)T       LINE2(2)=BLANK       IY=NYU-I+1       IF(NY.GT.0)YIY=Y(IY)%       IF(NY.LT.0)YIY=Y(1)+(IY-1)*Y(2)11       CALL RICON(YIY,LINE2(3),2,YFMT,NYWID,&1050)D       LINE2(NYWID+3)=BLANK       LINE2(ISTART)=BAR6-       IF(IY-IY/10*10.EQ.1)LINE2(ISTART)=MINUST       ZYSUM=0.0I       IX=IXX       DO 315 J=1,NXX       ZZ=Z(IX,IY)*ZSCALE
       IX=IX+1.       ZYSUM=ZYSUM+ZZ       IDIGIT=ZZ+3.5F       IF(IDIGIT.GT.3)GO TO 312       IDIGIT=2       IF(ZZ.GT.0.)IDIGIT=3       IF(ZZ.LT.0.)IDIGIT=1#       LINE2(ISTART+J)=DIGIT(IDIGIT) 7       IF(IDIGIT.LE.NDIGS)LINE2(ISTART+J)=DIGITS(IDIGIT)D       GO TO 315U' 312   IF(IDIGIT.GT.MAXDIG)IDIGIT=MAXDIGN7       IF(IDIGIT.LE.NDIGS)LINE2(ISTART+J)=DIGITS(IDIGIT)A6       IF(IDIGIT.GT.NDIGS)LINE2(ISTART+J)=DIGIT(IDIGIT) 315   CONTINUE!       LINE2(NXAXIS)=LINE2(ISTART)I       LINE2(NXAXIS+1)=BLANKF:       CALL RICON(ZYSUM,LINE2(NXAXIS+2),2,ZFMT,NZWID,&1060)       LINE2(IEND-1)=BLANK)       LINE2(IEND)=BLANK        IYP=I-IYPROJ+1:       IF(IYP.GE.1.AND.IYP.LE.NYPROJ)LINE2(IEND)=YPROJ(IYP)(       WRITE(IOUT,230)(LINE2(J),J=1,IEND) 320   CONTINUE*       WRITE(IOUT,230)(XAXIS(I),I=1,NXAXIS)       IX=IXX       DO 330 I=1,NXX       IF(NX.GT.0)ZX(I)=X(IX)'       IF(NX.LT.0)ZX(I)=X(1)+(IX-1)*X(2) 
       IX=IX+1) 330   CONTINUE       NW=NXWID        CALL MOVEC(NXFMT,XFMT,FMT)
       ITIME=2S       GO TO 260 ! 400   NBLANK=ISTART+(NXZ-NXLAB)/2/-       IF(NBLANK.GT.132-NXLAB)NBLANK=132-NXLABX       IF(NBLANK.LT.1)NBLANK=1 4       IF(NXLAB.GT.0.AND.NXLAB.LT.132)WRITE(IOUT,230).      *  (BLANK,I=1,NBLANK),(XLAB(I),I=1,NXLAB)6       IF(NXLAB.GE.132)WRITE(IOUT,230)(XLAB(I),I=1,132)(       IF(NXLAB.LE.0)WRITE(IOUT,230)BLANK       GO TO 210P 600   N1=NZWD1-1       ILAST=NXZJ       NW=NZWID       NW1=NZWID1        CALL MOVEC(NZFMT,ZFMT,FMT)
       ITIME=1I 605   IF(NW1.GT.NZWD1)GO TO 630A       NBL=NZWD1-NW
       ILINE=1N       DO 610 I=1,NXX1       IF(NBL.GT.0)CALL SETC(NBL,LINE2(ILINE),' ')        ILINE=ILINE+NBLA3       CALL RICON(ZX(I),LINE2(ILINE),2,FMT,NW,&1150)A       ILINE=ILINE+NW 610   CONTINUE<       WRITE(IOUT,230)(BLANK,I=1,ISTART),(LINE2(I),I=1,ILAST)       GO TO 700F 630   IWW=1N       NWW=0  640   IWW=IWW+NWWG       NWW=NW-IWW+1       IF(NWW.LE.0)GO TO 700        IF(NWW.GT.10)NWW=10(
       ILINE=1,       DO 650 I=1,NXX3       IF(N1.GT.0)CALL SETC(N1*10,LINE(1,ILINE),' ')        ILINE=ILINE+N1,       CALL RICON(ZX(I),LINE2,2,FMT,NW,&1150).       CALL MOVEC(NWW,LINE2(IWW),LINE(1,ILINE))       ILINE=ILINE+11 650   CONTINUE       DO 660 I=1,NWW=       WRITE(IOUT,230)(BLANK,J=1,ISTART),(LINE(I,J),J=1,ILAST)) 660   CONTINUE       GO TO 640T 700   IF(ITIME.EQ.2)GO TO 400I*       WRITE(IOUT,230)(XAXIS(I),I=1,NXAXIS)       NBL=NZWD1-NZWD       DO 670 I=1,NYU       LINE2(1)=BLANK       IYL=I-IYLAB+1L5       IF(IYL.GE.1.AND.IYL.LE.NYLAB)LINE2(1)=YLAB(IYL).       LINE2(2)=BLANK       IY=NYU-I+1       IF(NY.GT.0)YIY=Y(IY)%       IF(NY.LT.0)YIY=Y(1)+(IY-1)*Y(2)F1       CALL RICON(YIY,LINE2(3),2,YFMT,NYWID,&1050)K       LINE2(NYWID+3)=BLANK       LINE2(ISTART)=BARG-       IF(IY-IY/10*10.EQ.1)LINE2(ISTART)=MINUS)       ZYSUM=0.0A       ILINE=ISTART+1       IX=IXX       DO 665 J=1,NXX       ZZ=Z(IX,IY)*ZSCALE
       IX=IX+1I       ZYSUM=ZYSUM+ZZ1       IF(NBL.GT.0)CALL SETC(NBL,LINE2(ILINE),' ')O       ILINE=ILINE+NBLT5       IF(ZZ.EQ.0.)CALL SETC(NZWD,LINE2(ILINE),DIGIT0)+=       IF(ZZ.NE.0.)CALL RICON(ZZ,LINE2(ILINE),2,ZFM,NZWD,&662)        GO TO 664Z&  662  CALL SETC(NZWD,LINE2(ILINE),'*')   664 ILINE=ILINE+NZWD 665   CONTINUE!       LINE2(NXAXIS)=LINE2(ISTART)T       LINE2(NXAXIS+1)=BLANKW:       CALL RICON(ZYSUM,LINE2(NXAXIS+2),2,ZFMT,NZWID,&1060)       LINE2(IEND-1)=BLANKV       LINE2(IEND)=BLANKI       IYP=I-IYPROJ+1:       IF(IYP.GE.1.AND.IYP.LE.NYPROJ)LINE2(IEND)=YPROJ(IYP)(       WRITE(IOUT,230)(LINE2(J),J=1,IEND) 670   CONTINUE*       WRITE(IOUT,230)(XAXIS(I),I=1,NXAXIS)       IX=IXX       DO 680 I=1,NXX       IF(NX.GT.0)ZX(I)=X(IX)'       IF(NX.LT.0)ZX(I)=X(1)+(IX-1)*X(2)L
       IX=IX+1E 680   CONTINUE       NW=NXWID       NW1=NXWID1        CALL MOVEC(NXFMT,XFMT,FMT)
       ITIME=2        GO TO 605Y 1000  WRITE(IOUT,1001); 1001  FORMAT('0*** ERROR *** IN SCATP. DIMENSIONS NX & NY',I"      *       ' MUST BE NON-ZERO.'/=      *       '               1''ST DIMENSION NX1 OF Z-ARRAY',.      *       ' MUST BE > 0.')J
       RETURN1Z 1010  WRITE(IOUT,1011): 1011  FORMAT('0*** ERROR *** IN SCATP. FORMAT CODE: XFMT',      *       ' HAS NO ")" IN'/7      *       '               ITS 1''ST 10 CHARACTERS.')D
       RETURN1I 1020  WRITE(IOUT,1021): 1021  FORMAT('0*** ERROR *** IN SCATP. FORMAT CODE: YFMT',      *       ' HAS NO ")" IN'/7      *       '               ITS 1''ST 10 CHARACTERS.')L
       RETURN1D 1030  WRITE(IOUT,1031)B 1031  FORMAT('0*** ERROR *** IN SCATP. 1''ST FORMAT CODE OF ZFMT',      *       ' HAS NO ")" IN'/7      *       '               ITS 1''ST 10 CHARACTERS.')2
       RETURN1M 1040  WRITE(IOUT,1041): 1041  FORMAT('0*** ERROR *** IN SCATP. FORMAT CODE: XFMT',      *       ' IS INVALID.')
       RETURN1I 1050  WRITE(IOUT,1051): 1051  FORMAT('0*** ERROR *** IN SCATP. FORMAT CODE: YFMT',      *       ' IS INVALID.')
       RETURN1  1060  WRITE(IOUT,1061)B 1061  FORMAT('0*** ERROR *** IN SCATP. 1''ST FORMAT CODE OF ZFMT',      *       ' IS INVALID.')
       RETURN1  1070  WRITE(IOUT,1071)D 1071  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTH IN FORMAT CODE:',      *       ' XFMT MUST BE'/N@      *       '               IN THE RANGE: 1 <= XWIDTH <= 132.')
       RETURN1L 1080  WRITE(IOUT,1081)D 1081  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTH IN FORMAT CODE:',#      *       ' YFMT MUST BE => 1.')B
       RETURN1  1090  WRITE(IOUT,1091)D 1091  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTH IN 1''ST FORMAT',*      *       ' CODE OF ZFMT MUST BE => 1')
       RETURN1M 1100  WRITE(IOUT,1101)B 1101  FORMAT('0*** ERROR *** IN SCATP. 2''ND FORMAT CODE OF ZFMT',      *       'HAS NO ")" IN '/7      *       '               ITS 1''ST 10 CHARACTERS.')L
       RETURN1  1110  WRITE(IOUT,1111)B 1111  FORMAT('0*** ERROR *** IN SCATP. 2''ND FORMAT CODE OF ZFMT',      *       ' IS INVALID.')
       RETURN1= 1120  WRITE(IOUT,1121)D 1121  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTH IN 2''ND FORMAT',*      *       ' CODE OF ZFMT MUST BE => 1')
       RETURN1  1130  WRITE(IOUT,1131)? 1131  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTHS IN FORMAT', $      *       ' CODES: YFMT,ZFMT(1)'/-      *       '               ARE TOO LARGE.',C4      *       ' YWIDTH+ZWIDTH1 MUST BE <= NWIDTH-9.')
       RETURN1  1140  WRITE(IOUT,1141)? 1141  FORMAT('0*** ERROR *** IN SCATP. FIELD WIDTHS IN FORMAT', ,      *       ' CODES: YFMT,ZFMT(1),ZFMT(2)'/-      *       '               ARE TOO LARGE.',I>      *       ' YWIDTH+ZWIDTH1+ZWIDTH2 MUST BE <= NWIDTH - 8.'/@      *       '               NOTE: ZWIDTH2 IS ONE GREATER THAN',+      *       ' THE SPECIFIED FORMAT WIDTH'/K>      *       '               IF THE FORMAT IS E,D OR G TYPE.')
       RETURN1) 1150  IF(ITIME.EQ.1)GO TO 1060       GO TO 1040	       END 