E       SUBROUTINE SET_PLOT_DEVICES(IMON1_IN,IOUT1_IN,IMON2_IN,IOUT2_IN C      #                           ,IBIT,UNITS,MODE,NPAGES,*,*,*,*,*)  C : C    This routine calls HARDCOPY_RANGE, MONITOR_RANGE, and= C    MONITOR2_RANGE setting up the user units for plotting in  C    centimeters or inches.  C : C    Two orientations are allowed: LANDSCAPE and PORTRAIT.G C    The viewport will have the correct aspect ratio (i.e. circles will C C    be circles on the screen, on the pen plotter and on the bitmap  C    hardcopy).  C 8 C    In LANDSCAPE mode, the world range in  centimeters: C ; C    ZETA::     0. <= X <= 27.94           0. <= Y <= 21.59 = C     HPA::     0. <= X <= 25.00           0. <= Y <= 19.00 | = C     HPB::     0. <= X <= 40.64           0. <= Y <= 25.40 | H C     HPC::     0. <= X <= 53.34           0. <= Y <= 40.64 |HP plotters= C     HPD::     0. <= X <= 83.82           0. <= Y <= 53.34 | = C     HPE::     0. <= X <=109.22           0. <= Y <= 83.82 | ; C     QMS::     0. <= X <= 27.94           0. <= Y <= 21.59 = C     HIA::     0. <= X <= 25.00           0. <= Y <= 19.00 | = C     HIB::     0. <= X <= 40.64           0. <= Y <= 25.40 | D C     HIC::     0. <= X <= 53.34           0. <= Y <= 40.64 |Houston= C     HID::     0. <= X <= 83.82           0. <= Y <= 53.34 | = C     HIE::     0. <= X <=109.22           0. <= Y <= 83.82 | ; C    LN03::     0. <= X <= 27.94           0. <= Y <= 21.59 ; C  IMAGEN::     0. <= X <= 27.94           0. <= Y <= 21.59 ; C  POSTSCRIPT:: 0. <= X <= 27.94           0. <= Y <= 21.59  C ' C      and in inches the range will be:  C : C    ZETA::     0. <= X <= 11.00           0. <= Y <=  8.5; C     HPA::     0. <= X <=  9.84           0. <= Y <=  7.48 : C     HPB::     0. <= X <= 16.00           0. <= Y <= 10.0: C     HPC::     0. <= X <= 21.00           0. <= Y <= 16.0: C     HPD::     0. <= X <= 33.00           0. <= Y <= 21.0: C     HPE::     0. <= X <= 43.00           0. <= Y <= 33.0: C     QMS::     0. <= X <= 11.00           0. <= Y <=  8.5; C     HIA::     0. <= X <=  9.84           0. <= Y <=  7.48 : C     HIB::     0. <= X <= 16.00           0. <= Y <= 10.0: C     HIC::     0. <= X <= 21.00           0. <= Y <= 16.0: C     HID::     0. <= X <= 33.00           0. <= Y <= 21.0: C     HIE::     0. <= X <= 43.00           0. <= Y <= 33.0: C    LN03::     0. <= X <= 11.00           0. <= Y <=  8.5: C  IMAGEN::     0. <= X <= 11.00           0. <= Y <=  8.5: C  POSTSCRIPT:: 0. <= X <= 11.00           0. <= Y <=  8.5 C > C      In PORTRAIT mode, the world units range in centimeters: C : C  ZETA::      0. <= X <= 21.59           0. <= Y <= 27.94: C   HPA::      0. <= X <= 19.00           0. <= Y <= 25.00: C   HPB::      0. <= X <= 25.40           0. <= Y <= 40.64: C   HPC::      0. <= X <= 40.64           0. <= Y <= 53.34: C   HPD::      0. <= X <= 53.34           0. <= Y <= 83.82: C   HPE::      0. <= X <= 83.82           0. <= Y <=109.22: C   QMS::      0. <= X <= 21.59           0. <= Y <= 27.94: C   HIA::      0. <= X <= 19.00           0. <= Y <= 25.00: C   HIB::      0. <= X <= 25.40           0. <= Y <= 40.64: C   HIC::      0. <= X <= 40.64           0. <= Y <= 53.34: C   HID::      0. <= X <= 53.34           0. <= Y <= 83.82: C   HIE::      0. <= X <= 83.82           0. <= Y <=109.22: C  LN03::      0. <= X <= 21.59           0. <= Y <= 27.94: C IMAGEN::     0. <= X <= 21.59           0. <= Y <= 27.94: C POSTSCRIPT:: 0. <= X <= 21.59           0. <= Y <= 27.94 C ' C      and in inches the range will be:  C : C    ZETA::     0. <= X <=  8.5            0. <= Y <= 11.0; C     HPA::     0. <= X <=  7.48           0. <= Y <=  9.84 : C     HPB::     0. <= X <= 10.0            0. <= Y <= 16.0: C     HPC::     0. <= X <= 16.0            0. <= Y <= 21.0: C     HPD::     0. <= X <= 21.0            0. <= Y <= 33.0: C     HPE::     0. <= X <= 33.0            0. <= Y <= 43.0: C     QMS::     0. <= X <=  8.5            0. <= Y <= 11.0; C     HIA::     0. <= X <=  7.48           0. <= Y <=  9.84 : C     HIB::     0. <= X <= 10.0            0. <= Y <= 16.0: C     HIC::     0. <= X <= 16.0            0. <= Y <= 21.0: C     HID::     0. <= X <= 21.0            0. <= Y <= 33.0: C     HIE::     0. <= X <= 33.0            0. <= Y <= 43.0: C    LN03::     0. <= X <=  8.5            0. <= Y <= 11.0: C  IMAGEN::     0. <= X <=  8.5            0. <= Y <= 11.0: C  POSTSCRIPT:: 0. <= X <=  8.5            0. <= Y <= 11.0 C  C     Input: C % C INTEGER*4     IMON1 = 0: no monitor   C                     = 1: VT640, C                     = 2: Tektronix 4010/12 C                     = 3: VS11 " C                     = 6: CIT-467# C                     = 7: TEK 4107   C                     = 8: VT241! C                     = 9: PT100G   C                     =12: SEIKO% C                     =15: VAXSTATION 6 C    "          IOUT1 = screen output unit (usually 6)F C    "          IMON2 = 0: NO plotter               (21.59 x 27.94 cm)F C                       1: VT640       display file (21.59 x 27.94 cm)F C                       2: TEK 4010/12 display file (21.59 x 27.94 cm)' C    "                  4: ZETA plotter % C                       5: HP plotter F C                          PLTR_SIZE = 0  --> size A  see common blockC C                          PLTR_SIZE = 1  --> size B   PLOTTER_SIZE 4 C                          PLTR_SIZE = 2  --> size C4 C                          PLTR_SIZE = 3  --> size D4 C                          PLTR_SIZE = 4  --> size EF C                       6: CIT-467     display file (21.59 x 27.94 cm)F C                       7: TEK 4107    display file (21.59 x 27.94 cm)F C                       8: VT241       display file (21.59 x 27.94 cm)F C                       9: PT100G      display file (21.59 x 27.94 cm)* C                      10: QMS Lasergrafix: C                      11: HOUSTON INSTRUMENTS pen plotterH C                          PLTR_SIZE = 0  --> size A    see common blockE C                          PLTR_SIZE = 1  --> size B     PLOTTER_SIZE 4 C                          PLTR_SIZE = 2  --> size C4 C                          PLTR_SIZE = 3  --> size D4 C                          PLTR_SIZE = 4  --> size EF C                      12: SEIKO       display file (21.59 x 27.94 cm)F C                      13: Imagen                   (21.59 x 27.94 cm)F C                      14: PostScript               (21.59 x 27.94 cm)F C                      16: LN03+                    (21.59 x 27.94 cm)> C    "          IOUT2 = second monitor output unit (usually 7)> C    "          IBIT  = 01 ->  700 x  785,          PRINTRONIX? C                "      02 ->  985 x  749, 100 dpi, HP LaserJet ? C                "      12 -> 1477 x 1123, 150 dpi, HP LaserJet ? C                "      22 -> 1477 x 1123, 300 dpi, HP LaserJet ? C                "      03 ->  853 x  640, 96 dpi,  HP ThinkJet 9 C                "      04 -> 1055 x  433,          LA100 ? C                "      05 -> 1980*NPAGES x 1530,   HP PaintJet = C              NPAGES = number of pages of HP PaintJet output 9 C                       restricted to be between 1 and 10 G C                       if IBIT is not 5, then NPAGES should be 1 (one)  C 1 C CHARACTER*(*)  MODE = 'LANDSCAPE' or 'PORTRAIT' ? C                    only the first character of MODE is tested  C $ C CHARACTER*2   UNITS = 'CM' or 'IN' C 9 C           RETURN1   if MODE(1:1) is neither 'P' nor 'L' ) C           RETURN2   if IMON1 is invalid ) C           RETURN3   if IMON2 is invalid ) C           RETURN4   if IBIT  is invalid ) C           RETURN5   if UNITS is invalid  C 1 C                                       Joe Chuma 5 C                                       January, 1986  C E C Revised: August, 1987 to allow for non-commensurate bitmap hardcopy B C Revised: November, 1987 to allow for HP PaintJet bitmap hardcopyH C Revised: March, 1988 to allow for different sizes of pen plotter paperC C          for HP pen plotters and Houston Instruments pen plotters ? C Revised: May, 1988 to allow for multiple (up to 10) pages of  # C          HP PaintJet paper output / C Revised: August, 1988 to allow for POSTSCRIPT  CZZZ:       CHARACTER  MODE*(*), UNITS*2, UNITSS*2, UPPER_CASE*2       LOGICAL    OPEND, FIRST        DATA FIRST /.TRUE./  C )       COMMON  /BITMAP_DEVICE/ IBIT_COMMON  C  C   PLTR_SIZE = 0  --> size A  C   PLTR_SIZE = 1  --> size B  C   PLTR_SIZE = 2  --> size C  C   PLTR_SIZE = 3  --> size D  C   PLTR_SIZE = 4  --> size E  C        INTEGER PLTR_SIZE '       COMMON  /PLOTTER_SIZE/  PLTR_SIZE        DATA  PLTR_SIZE /0/  C        IMON1 = IMON1_IN       IOUT1 = IOUT1_IN       IMON2 = IMON2_IN       IOUT2 = IOUT2_IN C &       INQUIRE(UNIT=IOUT1,OPENED=OPEND)+       IF( (IOUT1 .NE. 6) .AND. .NOT.OPEND ) 4      #  OPEN(UNIT=IOUT1,FILE='TT:',STATUS='UNKNOWN') C         UNITSS = UPPER_CASE(UNITS)        IF( UNITSS .EQ. 'CM' )THEN         UNIT_SCALE = 1.0%       ELSE IF( UNITSS .EQ. 'IN' )THEN          UNIT_SCALE = 2.54 
       ELSEB         WRITE(IOUT1,10)'*** ERROR SET_PLOT_DEVICES: Invalid units' 10      FORMAT(' ',A)          RETURN 5       END IF C ?       IF( IMON2 .EQ. 4 )THEN                 ! ZETA pen plotter          IOR2   = +1          XMAX   = 21.59         YMAX   = 27.94         XMAXM2 = 21.59         YMAXM2 = 27.94=       ELSE IF( IMON2 .EQ. 5 )THEN            ! HP pen plotter          IOR2   = -1 8         IF( PLTR_SIZE .EQ. 0 )THEN           ! HP size A           XMAX   = 19.00           YMAXM2 = 19.00           YMAX   = 25.00           XMAXM2 = 25.008         ELSE IF( PLTR_SIZE .EQ. 1 )THEN      ! HP size B           XMAX   = 25.40           YMAXM2 = 25.40           YMAX   = 40.64           XMAXM2 = 40.648         ELSE IF( PLTR_SIZE .EQ. 2 )THEN      ! HP size C           XMAX   = 40.64           YMAXM2 = 40.64           YMAX   = 53.34           XMAXM2 = 53.348         ELSE IF( PLTR_SIZE .EQ. 3 )THEN      ! HP size D           XMAX   = 53.34           YMAXM2 = 53.34           YMAX   = 83.82           XMAXM2 = 83.828         ELSE IF( PLTR_SIZE .EQ. 4 )THEN      ! HP size E           XMAX   = 83.82           YMAXM2 = 83.82           YMAX   =109.22           XMAXM2 =109.22         END IF>       ELSE IF( IMON2 .EQ. 10 )THEN        ! QMS vector plotter         IOR2   = -1          XMAX   =    7.5*2.54         XMAXM2 = 2999.0          YMAX   =   10.0*2.54         YMAXM2 = 2249.0 ?       ELSE IF( IMON2 .EQ. 11 )THEN        ! HOUSTON INSTRUMENTS          IOR2   = -1 8         IF( PLTR_SIZE .EQ. 0 )THEN           ! HI size A           XMAX   = 19.00           YMAXM2 = 19.00           YMAX   = 25.00           XMAXM2 = 25.008         ELSE IF( PLTR_SIZE .EQ. 1 )THEN      ! HI size B           XMAX   = 25.40           YMAXM2 = 25.40           YMAX   = 40.64           XMAXM2 = 40.648         ELSE IF( PLTR_SIZE .EQ. 2 )THEN      ! HI size C           XMAX   = 40.64           YMAXM2 = 40.64           YMAX   = 53.34           XMAXM2 = 53.348         ELSE IF( PLTR_SIZE .EQ. 3 )THEN      ! HI size D           XMAX   = 53.34           YMAXM2 = 53.34           YMAX   = 83.82           XMAXM2 = 83.828         ELSE IF( PLTR_SIZE .EQ. 4 )THEN      ! HI size E           XMAX   = 83.82           YMAXM2 = 83.82           YMAX   =109.22           XMAXM2 =109.22         END IFB       ELSE IF( IMON2 .EQ. 13 )THEN         ! IMAGEN vector plotter         IOR2   = -1          XMAX   =   21.59         YMAXM2 = 2560.         YMAX   =   27.94         XMAXM2 = 3328.7       ELSE IF( IMON2 .EQ. 14 )THEN         ! POSTSCRIPT          IOR2   = -1          XMAX   =   21.59         YMAXM2 = 2400.         YMAX   =   27.94         XMAXM2 = 3150.8       ELSE IF( IMON2 .EQ. 16 )THEN         ! LN03 device         IOR2   = -1          XMAX   = 21.59         YMAX   = 27.94         XMAXM2 = 639.          YMAXM2 = 479.  C + C  the rest are display files for terminals  C F       ELSE IF( (IMON2 .EQ. 0) .OR. (IMON2 .EQ. 1) .OR. (IMON2 .EQ.  2)F      #    .OR. (IMON2 .EQ. 6) .OR. (IMON2 .EQ. 7) .OR. (IMON2 .EQ.  8)9      #    .OR. (IMON2 .EQ. 9) .OR. (IMON2 .EQ. 12)  )THEN          IOR2   = +1          XMAX   = 21.59         XMAXM2 = 21.59         YMAX   = 27.94         YMAXM2 = 27.94
       ELSE         WRITE(IOUT1,10) <      #  '*** ERROR SET_PLOT_DEVICES: Invalid second monitor'         RETURN 3       END IF C        PAGES  = 1.        FACTOR = 1.0%       IF( IBIT .NE. IBIT_COMMON )THEN          IF( FIRST )THEN            FIRST = .FALSE.          ELSE           CALL CLEAR_PLOT          END IF       END IF       IBIT2  = IBIT / 10       IBIT1  = IBIT - 10*IBIT2)       IF( IBIT1 .EQ. 0 )THEN    ! unknown          YMAXP = 587.         XMAXP = 400.         IORHC = -16       ELSE IF( IBIT1 .EQ. 1 )THEN         ! PRINTRONIX         FACTOR = 1.2         YMAXP = 784.         XMAXP = 699.$         IF( MODE(1:1) .EQ. 'L' )THEN           IORHC  = -1          ELSE           IORHC  = +1          END IF2       ELSE IF( IBIT1 .EQ. 2 )THEN    ! HP Laserjet$         IF( MODE(1:1) .EQ. 'L' )THEN           IORHC  = +1          ELSE           IORHC  = -1          END IF         IF( IBIT2 .EQ. 0 )THEN           YMAXP =  748.            XMAXP =  984. #           CALL HPJET_DENSITY('100') #         ELSE IF( IBIT2 .EQ. 1 )THEN G           YMAXP = 1122.             ! 150 dots/inch * 7.48 inch (19 cm) G           XMAXP = 1476.             ! 150 dots/inch * 9.48 inch (25 cm) #           CALL HPJET_DENSITY('150') #         ELSE IF( IBIT2 .EQ. 2 )THEN            YMAXP = 1122.            XMAXP = 1476. #           CALL HPJET_DENSITY('300')          ELSE           WRITE(IOUT1,10) =      #    '*** ERROR SET_PLOT_DEVICES: Invalid bitmap device'            RETURN 4         END IF0       ELSE IF(IBIT1 .EQ. 3)THEN    ! HP Thinkjet         YMAXP = 639.         XMAXP = 852.$         IF( MODE(1:1) .EQ. 'L' )THEN           IORHC  = -1          ELSE           IORHC  = +1          END IF*       ELSE IF(IBIT1 .EQ. 4)THEN    ! LA100         YMAXP = 1055.          XMAXP = 432.$         IF( MODE(1:1) .EQ. 'L' )THEN           IORHC  = -1          ELSE           IORHC  = +1          END IF2       ELSE IF( IBIT1 .EQ. 5 )THEN    ! HP PaintJet,         PAGES = FLOAT(MAX(1,MIN(NPAGES,10)))         IMON2  = 0;         XMAX   =  8.0 * 2.54        ! 8 inch * 2.54 cm/inch          YMAX   = 11.0 * 2.54         XMAXM2 = XMAX          YMAXM2 = YMAX $         IF( MODE(1:1) .EQ. 'L' )THEN           IORHC  = +1          ELSE           IORHC  = -1          END IFH         YMAXP = 180.0 *  8.0            ! 180dpi * 8.0in (.25in margins)F         XMAXP = 180.0 * 11.0 * PAGES    ! 180dpi * 11in * no._of_pages
       ELSE         WRITE(IOUT1,10) ;      #  '*** ERROR SET_PLOT_DEVICES: Invalid bitmap device'          RETURN 4       END IF       SCALE = XMAX / YMAX        XMAX  = XMAX / UNIT_SCALE        YMAX  = YMAX / UNIT_SCALE  C        IBIT_COMMON = IBIT"       IF( MODE(1:1) .EQ. 'L' )THEN C G C    Set up the correct aspect ratio for the terminal screen and centre ; C    the viewport on the screen for the LANDSCAPE mode case  C          IF( IMON1 .EQ. 6 )THEN C  C    CIT467  C            XMN =   0.           XMX = 571.2           YMN = (479. - 571. * SCALE / PAGES) / 2.2           YMX = (479. + 571. * SCALE / PAGES) / 2.F        ELSE IF( (IMON1 .EQ. 1) .OR. (IMON1 .EQ. 7) .OR. (IMON1 .EQ. 8)%      #     .OR. (IMON1 .EQ. 9) ) THEN  C ' C    VT640 or TK4107 or VT241 or PT100G  C !           IF( PAGES .GT. 1. )THEN              XMN =   0.             XMX = 639.4             YMN = (479. - 639. * SCALE / PAGES) / 2.4             YMX = (479. + 639. * SCALE / PAGES) / 2.           ELSE,             XMN = (639. - 479. / SCALE) / 2.,             XMX = (639. + 479. / SCALE) / 2.             YMN = 0.             YMX = 479.           END IF#         ELSE IF( IMON1 .EQ. 3 )THEN  C 	 C    VS11  C            XMN =   0.           XMX = 511.2           YMN = (479. - 511. * SCALE / PAGES) / 2.2           YMX = (479. + 511. * SCALE / PAGES) / 2.$         ELSE IF( IMON1 .EQ. 12 )THEN C ( C    SEIKO GR-1105:   -2048 <= X <= 2047( C                     -1560 <= Y <= 1559 C !           IF( PAGES .GT. 1. )THEN              XMN = -2048.             XMX =  2047.?             YMN = -1560. + (3119. - 4095. * SCALE / PAGES) / 2. ?             YMX = -1560. + (3119. + 4095. * SCALE / PAGES) / 2.            ELSE7             XMN = -2048. + (4095. - 3119. / SCALE) / 2. 7             XMX = -2048. + (4095. + 3119. / SCALE) / 2.d             YMN = -1560. n             YMX =  1559.           END IF#         ELSE IF( IMON1 .EQ. 2 )THENo Cn C    Tektronix 4010/12 CA!           IF( PAGES .GT. 1. )THEN              XMN =    0.e             XMX = 1023.l5             YMN = (779. - 1023. * SCALE / PAGES) / 2.n5             YMX = (779. + 1023. * SCALE / PAGES) / 2.P           ELSE-             XMN = (1023. - 779. / SCALE) / 2..-             XMX = (1023. + 779. / SCALE) / 2.              YMN = 0.             YMX = 779.           END IF$        ELSE IF( IMON1 .EQ. 15 ) THEN C  C    VAXSTATION  C            XMN =   0.           XMX =   1./           YMN = (.75 - 1. * SCALE / PAGES) / 2. /           YMX = (.75 + 1. * SCALE / PAGES) / 2.:  2 CC          XMN = (1. - 0.75 / SCALE / PAGES) / 2.2 CC          XMX = (1. + 0.75 / SCALE / PAGES) / 2. CC          YMN = 0. CC          YMX = 0.75#         ELSE IF( IMON1 .EQ. 0 )THEN: C 
 C    VT100 C.           XMN = 0.           XMX = 639.           YMN = 0.           YMX = 479.         ELSE           WRITE(IOUT1,10) =      #    '*** ERROR SET_PLOT_DEVICES: Invalid first monitor'            RETURN 2         END IF6         CALL HARDCOPY_RANGE(0.,      XMAXP, 0., YMAXP,=      #                      0., PAGES*YMAX, 0.,  XMAX, IORHC)<?         CALL MONITOR_RANGE(IMON1,IOUT1, 0., XMAXP,   0., YMAXP,1F      #                                 XMN,   XMX,  YMN,   YMX, IORHC)E         IF( (IMON2 .EQ.  4) .OR. (IMON2 .EQ.  5) .OR. (IMON2 .EQ. 11) F      #  .OR.(IMON2 .EQ. 16) .OR. (IMON2 .EQ. 13) .OR. (IMON2 .EQ. 15) 
      #  )THEN !           IF( IORHC .EQ. +1 )THEN.>             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,6      #                      0.,XMAXM2,0.,YMAXM2,-IOR2)&           ELSE IF( IORHC .EQ. -1 )THEN>             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,5      #                      0.,XMAXM2,0.,YMAXM2,IOR2)I           END IF$         ELSE IF( IMON2 .EQ. 10 )THEN!           IF( IORHC .EQ. +1 )THEN >             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,;      #                      150.,XMAXM2,YMAXM2,150.0,-IOR2) &           ELSE IF( IORHC .EQ. -1 )THEN>             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,:      #                      150.,XMAXM2,YMAXM2,150.0,IOR2)           END IF$         ELSE IF( IMON2 .EQ. 14 )THEN!           IF( IORHC .EQ. +1 )THENt>             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,;      #                      150.,XMAXM2,150.0,YMAXM2,-IOR2).&           ELSE IF( IORHC .EQ. -1 )THEN>             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,:      #                      150.,XMAXM2,150.0,YMAXM2,IOR2)           END IF#         ELSE IF( IMON2 .GE. 0 )THEN <           CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,?      #                                 XMN,XMX, YMN,YMX, IORHC).         END IF% CC        ELSE IF( IMON2 .GT. 0 )THEN  C.%       ELSE IF(MODE(1:1) .EQ. 'P')THEN< C0G C    Set up the correct aspect ratio for the terminal screen and centre : C    the viewport on the screen for the PORTRAIT mode case C<         IF( IMON1 .EQ. 6 )THEN CX C    CIT467  C 2           XMN = (571. - 479. * SCALE / PAGES) / 2.2           XMX = (571. + 479. * SCALE / PAGES) / 2.           YMN = 0.           YMX = 479.8         ELSE IF( (IMON1 .EQ. 1) .OR. (IMON1 .EQ. 7) .OR.:      #           (IMON1 .EQ. 8) .OR. (IMON1 .EQ. 9) ) THEN C.' C    VT640 or TK4107 or VT241 or PT100G  C 1           XMN = (639. - 479. * SCALE / PAGES) / 2 1           XMX = (639. + 479. * SCALE / PAGES) / 2            YMN = 0.           YMX = 479.#         ELSE IF( IMON1 .EQ. 3 )THEN  C:	 C    VS11  C=1           XMN = (511. - 479. * SCALE / PAGES) / 2.1           XMX = (511. + 479. * SCALE / PAGES) / 2:           YMN =   0.           YMX = 479.#         ELSE IF( IMON1 .EQ. 2 )THEN. C ) C    SEIKO GR-1105:   -2048 <= XM <= 2047.) C                     -1560 <= YM <= 1559  C <           XMN = -2048. + (4095. - 3119. * SCALE / PAGES) / 2<           XMX = -2048. + (4095. + 3119. * SCALE / PAGES) / 2           YMN = -1560.           YMX =  1559.#         ELSE IF( IMON1 .EQ. 2 )THEN  C  C    Tektronix 4010/12 CS2           XMN = (1023. - 779. * SCALE / PAGES) / 22           XMX = (1023. + 779. * SCALE / PAGES) / 2           YMN =   0.           YMX = 779.%         ELSE IF( IMON1 .EQ. 15 ) THEN1 C2 C    VAXSTATION  C /           XMN = (1. - .75 * SCALE / PAGES) / 2. /           XMX = (1. + .75 * SCALE / PAGES) / 2.            YMN = 0.           YMX =  .75  " CC          IF( PAGES .EQ. 1 )THEN, CC            XMN = (1.0 - 0.75 * SCALE) / 2( CC            XMX =   XMN + 0.75 * SCALE CC            YMN = 0. CC            YMX = 0.75 CC          ELSE CC            XMN = 0. CC            XMX = 1.5 CC            YMN = (0.75 - 1.0 / SCALE / PAGES) / 2. 5 CC            YMX = (0.75 + 1.0 / SCALE / PAGES) / 2.. CC          END IF#         ELSE IF( IMON1 .EQ. 0 )THEN  C 
 C    VT100 CH           XMN =   0.           XMX = 639.           YMN =   0.           YMX = 479.         ELSE           WRITE(IOUT1,10) >      #     '*** ERROR SET_PLOT_DEVICES: Invalid first monitor'           RETURN 2         END IF6         CALL HARDCOPY_RANGE(0., XMAXP, 0.,      YMAXP,=      #                      0., XMAX,  0., PAGES*YMAX, IORHC)79         CALL MONITOR_RANGE(IMON1,IOUT1,0.,XMAXP,0.,YMAXP, 3      #                       XMN,XMX,YMN,YMX,IORHC) E         IF( (IMON2 .EQ.  4) .OR. (IMON2 .EQ.  5) .OR. (IMON2 .EQ. 11) F      #  .OR.(IMON2 .EQ. 16) .OR. (IMON2 .EQ. 13) .OR. (IMON2 .EQ. 15) 
      #  )THEN !           IF( IORHC .EQ. -1 )THEN >             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,6      #                      0.,XMAXM2,0.,YMAXM2,-IOR2)&           ELSE IF( IORHC .EQ. +1 )THEN>             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,5      #                      0.,XMAXM2,0.,YMAXM2,IOR2)_           END IF$         ELSE IF( IMON2 .EQ. 10 )THEN!           IF( IORHC .EQ. -1 )THEN >             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,:      #                      150.,XMAXM2,YMAXM2,150.,-IOR2)&           ELSE IF( IORHC .EQ. +1 )THEN>             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,9      #                      150.,XMAXM2,YMAXM2,150.,IOR2)            END IF$         ELSE IF( IMON2 .EQ. 14 )THEN!           IF( IORHC .EQ. -1 )THEN >             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,:      #                      150.,XMAXM2,150.,YMAXM2,-IOR2)&           ELSE IF( IORHC .EQ. +1 )THEN>             CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,9      #                      150.,XMAXM2,150.,YMAXM2,IOR2)            END IF#         ELSE IF( IMON2 .GE. 0 )THEN <           CALL MONITOR2_RANGE(IMON2,IOUT2,0.,XMAXP,0.,YMAXP,3      #                       XMN,XMX,YMN,YMX,IORHC)n         END IF% CC        ELSE IF( IMON2 .GT. 0 )THENb
       ELSEA         WRITE(IOUT1,10)'*** ERROR SET_PLOT_DEVICES: Invalid mode'b         RETURN 1       END IF       RETURN	       ENDO