G       SUBROUTINE TPLT(XARR,YARR,CHAR,NPT,NCX,NCY,ICX,ICY,XLAB,YLAB,IDV)  C  C     LIBRARY-ROUTINE  C = C                                                29/JULY/1980 > C                                                C.J. KOST SIN C   A C     reqd. KOSTL: routines - AXISSTPLT,LINEC,LINEH,PLOTI,SCALE2, 1 C                           - SCALE3,TPLTI,LINEH2  C B C=================================================================B C                                                               ==B C   -------------  MAIN PLOTTING SUBROUTINE ------------------  ==B C                                                               ==B C     TPLT IS THE MAIN SUBROUTINE OF A PLOTTING PACKAGE WRITTEN ==B C     IN "CELL" UNITS. A "CELL" IS DEFINED AS THE SMALLEST      ==B C     INCREMENT OF THE PLOTTING DEVICE. THE TEKTRONIC 4010-4014 ==B C     GRAPHICS SERIES HAVE 1023*780 CELLS, WHILE THE HP2647A    ==B C     HAS 720*360. THE HP2631G MATRIX PRINTER HAS 2080*980 (THE ==B C     2080 IS DOWN THE PAGE WHILE 980 IS ACROSS , IE. ALL PLOTS ==B C     ON THE MATRIX PRINTER ARE ROTATED 90 DEGREES CLOCKWISE    ==B C     BEFORE BEING PLOTTED ). THE 2080 LIMIT IS SET BY A DIMEN- ==B C     SION STATEMENT AND IS FELT TO BE SUFFICIENT FOR CURRENT   ==B C     NEEDS. PLOTS CAN ALSO BE TRANSMITTED TO A MAGNETIC TAPE   ==B C     VIA UNIT 17 TO BE PLOTTED ON THE CDC CALCOMP PLOTTER. THE ==B C     MAXIMUM NUMBER OF CELLS ALLOWED FOR THIS DEVICE IS SET TO ==B C     8192*8192 , AGAIN FELT SUFFICIENT FOR OUR PRESENT NEEDS.  ==B C        With TPLT the user can construct a FRAME made up of 1  ==B C     or more PLOTS , where each individual PLOT can have one   ==B C     or more CURVES. Each CURVE can have its own scale but only==B C     one scale can be drawn bordering each PLOT (else you have ==B C     a mess ! ). Scales can be linear or logarithmic. Each PLOT==B C     can occupy a different area of a frame (they can overlap  ==B C     but this is usually highly undesirable ! ).               ==B C         Via TPLT parameters and common block variables the    ==B C     user can control ---------------------                    ==B C                                                               ==B C      a) The length of each axis (in cells) --->NCX,NCY        ==B C      b) The origin of each plot or curve   --->ICX,ICY        ==B C      c) The size of the curve character(s) --->SIZES          ==B C      d) The plotting character (each point)--->CHAR           ==B C      e) The size of the numbers labelling                     ==B C         every major tick mark or decade    --->SIZEN          ==B C      f) The spacing between minor tick marks-->NCXBT,NCYBT    ==B C      g) The number of minor tick marks between                ==B C         major ones ( labelled ticks)       --->NTXBL,NTYBL    ==B C      h) The format of the numbers labelling--->NXDEC,NYDEC,   ==B C                                                NXDIG,NYDIG    ==B C      i) The size of the axis labels        --->SIZEL          ==B C      j) The size of the axis tick marks    --->TICK           ==B C      k) The axis scales                    --->XMIN,XINC      ==B C         (auto-scale if XINC=0., YINC=0. )      YMIN,YINC      ==B C      l) The clipping windows limitting the --->NXL,NXU,       ==B C         next plot or curve the user flushes    NYL,NYU        ==B C         onto the frame.                                       ==B C      m) Which device to plot on            --->CODE           ==B C      n) If the curve is to be a histogram  --->IDV            ==B C      o) If scales are log or linear        --->NCX,NCY        ==B C                                                               ==B C        VARIABLE   DEFAULT             PURPOSE                 ==B C       ----------  --------   ---------------------------------==B C       CHAR                   CHAR is a BYTE array ,length NPT ==B C                             specifying what symbol to plot at ==B C                             each of the NPT points of the curve=B C                             If CHAR(I)<0 the Ith plotted point==B C                             is not joined by a straight line  ==B C                             to the previous (I-1) point. If   ==B C                             CHAR(I)>0 the Ith plotted point is==B C                             joined with a straight line to the==B C                             previous plotted point (I-1). If  ==B C                             CHAR(I)=0 the Ith plotted point is==B C                             joined only by a straight line (no==B C                             symbol is plotted) to the previous==B C                             plotted point (I-1). The following==B C                             tabulates the 7 special symbols   ==B C                             that can be used.                 ==B C                             |CHAR(I)|=1 plots SQUARE symbol   ==B C                             |CHAR(I)|=2 plots  X     symbol   ==B C                             |CHAR(I)|=3 plots SQUARE with X   ==B C                                         superimposed.         ==B C                             |CHAR(I)|=4 plots + symbol        ==B C                             |CHAR(I)|=5 plots DIAMOND symbol  ==B C                             |CHAR(I)|=6 plots DIAMOND with +  ==B C                                         superimposed.         ==B C                             |CHAR(I)|=7 plots * symbol        ==B C                             At present the user should use only=B C                             |CHAR(I)| < 8. Values 8<CHAR(I)<129=B C                             results in a plotted symbol (joined=B C                             by a straight line to the previous==B C                             point ) given by the ASCII code   ==B C                             table (i.e. CHAR(I)=66 plots a B )==B C                             However , unlike the values 1 to 7 =B C                             these plotted symbols are not     ==B C                             centered at (XARR(I),YARR(I)) but ==B C                             have the lower left "foot" of the ==B C                             plotted symbol plotted at (XARR(I),=B C                             YARR(I)). The size of the plotted ==B C                             symbol is set by SIZES (if set to ==B C                             a small number, say .001, this will=B C                             result in a dot being plotted at  ==B C                             (XARR(I),YARR(I)). Future plans   ==B C                             allow for all 128 possible "special"B C                             symbols to be plotted.            ==B C       CODE        'N'        CODE is a BYTE array specifying  ==B C                             the plotting device. If 'S' or 'N'==B C                             it is the terminal screen and     ==B C                             subsequent calls to TPLT result   ==B C                             in graphics output to it. If 'M'  ==B C                             it indicates that the BYTE array  ==B C                             PB(132,2080) in the common block  ==B C                             PLA will be "drawn" on by subse-  ==B C                             quent calls to TPLT - each vector ==B C                             drawn simply resulting in the corr==B C                             ersponding string of BITS being   ==B C                             set to 1. Calls to subroutine     ==B C                             ERASE result in the flushing of   ==B C                             this array to a permanent file    ==B C                             (usually FOR017.DAT ) or the HP   ==B C                             RIGHT TAPE as determined by the   ==B C                             user response when he is promted  ==B C                             as a result of this call in this  ==B C                             mode. The user can at any time    ==B C                             manually write out or otherwise   ==B C                             dispose of this PB array. If CODE ==B C                             is set to 'Z' calls to TPLT result==B C                             in writes to unit 17. A magnetic  ==B C                             tape should normally have been    ==B C                             mounted and assigned to this unit ==B C                             before-hand as follows.           ==B C                                $ALLOC MT2:  TAPE              ==B C                                $MOU/F/DENS=800 etc.           ==B C                                $ASS/USER TAPE FOR017          ==B C                             This magnetic tape, submitted via ==B C                             a batch job to the CDC results in ==B C                             a high resolution CALCOMP type    ==B C                             plot.                             ==B C       ICX                    Specifies the location of the X- ==B C                             axis origin in cell units.        ==B C                             ICX=300 would place the origin of ==B C                             the X-axis at the screen location ==B C                             300 cells from the "left" margin. ==B C       ICY                    Specifies the location of the Y- ==B C                              axis origin in cell units.       ==B C                              ICY=50 would place the origin of ==B C                              the Y-axis at the screen location==B C                              50 cells from the "bottom" margin==B C       IDV                    >0 Normal curve plotting.        ==B C                              =0 Open histogram.               ==B C                              <0 Closed histogram.             ==B C       NCX                    |NCX| specifies the length of the==B C                              X-axis in cells. If NCX<0 log    ==B C                              (base 10) scales label the axis. ==B C       NCXBT       10          Specifies the number of cells in==B C                              the X-direction between MINOR    ==B C                              tick marks of the X-axis.        ==B C       NCY                    |NCY| specifies the length of the==B C                              Y-axis in cells. If NCY<0 log    ==B C                              (base 10) scales label the Y-axis==B C       NCYBT       10          Specifies the number of cells in==B C                              the Y-direction between MINOR    ==B C                              tick marks of the Y-axis.        ==B C       NPT                     The number of input points to be==B C                              plotted. (Dimension of XARR,YARR,==B C                              and CHAR ).                      ==B C       NTXBL       10          The number of MINOR tick marks  ==B C                              between MAJOR labelled tick marks==B C                              of the X-axis. The number of cells=B C                              between labelled tick marks is   ==B C                              thus  NCXBT*NTXBL  .             ==B C       NTYBL       10          The number of MINOR tick marks  ==B C                              between MAJOR labelled tick marks==B C                              of the Y-axis. The number of cells=B C                              between labelled tick marks is   ==B C                              thus NCYBT*NTYBL  .              ==B C       NXDEC       2           The number of decimal places in ==B C                              the numbers labelling the X-axis.==B C       NXDIG       5           The maximum number of digits    ==B C                              (including - & .) allocated to   ==B C                              the numbers labelling the X-axis.==B C       NXL          0          LEFT WINDOW MARGIN for clipping.==B C                              No plotting will be output to the==B C                              left of the cell value X < NXL . ==B C       NXU         2080        RIGHT WINDOW MARGIN for clipping==B C                              No plotting will be output to the==B C                              right of the cell value X > NXU .==B C       NYDEC       2           The number of decimal places in ==B C                              the numbers labelling the Y-axis.==B C       NYDIG       5           The maximum number of digits    ==B C                              (including - & .) allocated to   ==B C                              the numbers labelling the Y-axis.==B C       NYL          0          LOWER WINDOW MARGIN for clipping==B C                              No plotting will be output below ==B C                              the cell value Y < NYL .         ==B C       NYU         2080        UPPER WINDOW MARGIN for clipping==B C                              No plotting will be output above ==B C                              the cell value Y > NYU .         ==B C       SIZEL       20.         Size in cell units of the axis  ==B C                              labels ( not the numbers !)      ==B C       SIZEN       15.         Size in cells units of the axis ==B C                              numbers labelling MAJOR ticks.   ==B C       SIZES       8.          Size in cells units of the char-==B C                              acters of the plotted curve.     ==B C       TICK        10.         The length of the MINOR tick    ==B C                              marks of the axes will be 0.7 *  ==B C                              TICK, while MAJOR (labelled) ones==B C                              will be 1.4*TICK cells .         ==B C       XARR                    REAL*4 array, length NPT, con-  ==B C                              taining the values, in user units==B C                              of the X values of the plotted   ==B C                              curve.                           ==B C       XINC        0.          Increment in user units between ==B C                              major labelled X-axis tick marks.==B C                              Thus the user units/cell in the  ==B C                              X-direction is XINC/(NCXBT*NTXBL)==B C                              If this is set to zero TPLT will ==B C                              automatically determine the "best"=B C                              increment XINC and minimum value ==B C                              XMIN (provided that XINCD=0. )   ==B C       XINCD       0.          If XINC=0. then TPLT will use   ==B C                              XINCD for XINC provided XINCD    ==B C                              was .NE. 0.  (see XINC)          ==B C       XMIN        0.          Denotes the value in user units ==B C                              assigned to the first labelled   ==B C                              tick mark (also the origin) of   ==B C                              X-axis. If XINC was automatically==B C                              determined the so was XMIN .     ==B C       XMIND       0.          The default value of XMIN to be ==B C                              used when XINC was set to XINCD .==B C       YARR                    REAL*4 array, length NPT, con-  ==B C                              taining the values, in user units==B C                              of the Y values of the plotted   ==B C                              curve.                           ==B C       YINC        0.          Increment in user units between ==B C                              major labelled Y-axis tick marks.==B C                              Thus the user units/cell in the  ==B C                              Y-direction is YINC/(NCYBT*NTYBL)==B C                              If this is set to zero TPLT will ==B C                              automatically determine the "best"=B C                              increment YINC and minimum value ==B C                              YMIN (provided that YINCD=0. )   ==B C       YINCD       0.          If YINC=0. then TPLT will use   ==B C                              YINCD for YINC provided YINCD    ==B C                              was .NE. 0.  (see YINC)          ==B C       YMIN        0.          Denotes the value in user units ==B C                              assigned to the first labelled   ==B C                              tick mark (also the origin) of   ==B C                              Y-axis. If YINC was automatically==B C                              determined the so was YMIN .     ==B C       YMIND       0.          The default value of YMIN to be ==B C                              used when YINC was set to YINCD .==B C=================================================================B C      NOTE:  FOR LOGARITHMIC SCALES (NCX<0 for X-axis, NCY<0   ==B C             for Y-axis) XMIN or YMIN denote the origin decade ==B C             while XINC or YINC denote the increment in decades==B C             between labelled tick marks.                      ==B C=================================================================B C                                                               ==B C            ======   LINKING with TPLT =======                 ==B C       The user should be aware in which of two modes TPLT is  ==B C     being used. One way TPLT is loaded via a LINK to          ==B C     DR2:[KOST]KOST/LIB    in which case the common block      ==B C     variables must be initialized by a CALL TPLTI since       ==B C     libraries do not automatically load BLOCK DATA. If the    ==B C     user does not make such an initial call to TPLTI he should==B C     be aware that the first call to TPLT will result in such a==B C     call by TPLT. (Hence possibly RESETTING values in various ==B C     common blocks the user had previously been so careful to  ==B C     set !). Hence it is a good rule to first CALL TPLTI and   ==B C     then set the common block parameters of TPLT.             ==B C       On the other hand for those users who have explicitly   ==B C     loaded the BLOCK DATA of the TPLT package no such conflict==B C     exists ie. the first entry to TPLT will not result in a   == C     CALL TPLTI. B C=================================================================B C                                                               ==B C                   ----   ENPLT  ----                          ==B C      TPLT has been provided with an ENTRY point ENPLT which   ==B C     the user must call to avoid redrawing the axes. That is,  ==B C     to overlay PLOTS with another CURVE the user must CALL    ==B C     ENPLT. The parameters are the same as for TPLT except     ==B C     that there are NO X & Y LABEL FIELDS.                     ==B C=================================================================B C                                                               ==B C         -----   A SIMPLE EXAMPLE ----------                   ==B C            REAL X(100),Y(100)                                 ==B C            BYTE CHAR(100)                                     ==B C            DO 10 I=1,100                                      ==B C            CHAR(I)=2                                          ==B C            X(I)=I                                             ==B C            Y(I)=SIN(I/10.)/SQRT(I/5.)                         ==B C        10  CONTINUE                                           ==B C            CALL TPLT(X,Y,CHAR,100,500,250,50,50,'    ',       ==B C           #           '    ',4012)                            ==B C            END                                                ==B C=================================================================B C                                                               ==B C             ----   A MORE COMPLEX EXAMPLE -----               == C        COMMON/TPSTRT/INITP C        COMMON/CHOICE/CODEl C        BYTE CODE% C        COMMON/EDGES/NXL,NXU,NYL,NYUe% C        COMMON/NCAXIS/NCBT,NDEC,NDIG A C        COMMON/CIL/IPENX,IPENY,IPS,IPC,IPCN,FACR,XM,SIZES,SIZEN, D C       # SIZEL,TICK,STEP,XSPAC,IPNAB,ITAPE,IB,IBC,IBYTE,IBASE,IMMETB C        COMMON/CAXIS/XMIN,XINC,YMIN,YINC,XMIND,XINCD,YMIND,YINCD,7 C       # SIZELB,SIZECH,TANGLE,NXDIG,NXDEC,NYDIG,NYDEC, ! C       # NCXBT,NCYBT,NTXBL,NTYBL), C        REAL X(100),Y1(100),Y2(100),Y3(100) C        BYTE CHAR(100)  C        DO 10 I=1,100 C        X(I)=ALOG10(I*10.)t C        Y1(I)=ABS(SIN(I/10.)) C        Y2(I)=I+20.*SIN(I/5.) C        Y3(I)=I C        CHAR(I)=0 C    10  CONTINUE  C        CALL TPLTIa C        SIZES=4.  C        SIZEN=10. C        TICK=5.D C        CALL TPLT(X,Y1,CHAR,100,-250,250,60,50,'    ','    ',-4012) C        DO 20 I=1,100 C        CHAR(I)=-6  C   20   CONTINUEY C        XINC=0. C        YINC=0. C        NYDEC=0D C        CALL TPLT(X,Y2,CHAR,100,-250,250,375,50,'    ','    ',4012) C        DO 30 I=1,100 C        CHAR(I)=0 C   30   CONTINUE 7 C        CALL ENPLT(X,Y3,CHAR,100,-250,250,375,50,4012)h C        ENDH C=======================================================================
 C end.of.info H CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC       REAL XARR(1),YARR(1)       DIMENSION SVAL(1)        DATA SVAL/1./=       BYTE CHAR(1)       COMMON/TPSTRT/INITP=       COMMON/CHOICE/CODE       BYTE CODEl"       COMMON/EDGES/NXL,NXU,NYL,NYU"       COMMON/NCAXIS/NCBT,NDEC,NDIGD       COMMON/CIL/IPENX,IPENY,IPS,IPC,IPCN,FACR,XM,SIZES,SIZEN,SIZEL,?      #     TICK,STEP,XSPAC,IPNAB,ITAPE,IB,IBC,IBYTE,IBASE,IMMETn?       COMMON/CAXIS/XMIN,XINC,YMIN,YINC,XMIND,XINCD,YMIND,YINCD,a9      #      SIZELB,SIZECH,TANGLE,NXDIG,NXDEC,NYDIG,NYDEC, *      #             NCXBT,NCYBT,NTXBL,NTYBL Cd' C    NCXBT: # X CELLS BETWEEN TICK MARK ' C    NCYBT: # Y CELLS BETWEEN TICK MARKb) C    NTXBL: # X TICK MARKS BETWEEN LABELS ) C    NTYBL: # Y TICK MARKS BETWEEN LABELSd0 C    NCXBL: # X CELLS BETWEEN LABELS=NCXBT*NTXBL0 C    NCYBL: # Y CELLS BETWEEN LABELS=NCYBT*NTYBL C        BYTE XLAB(80),YLAB(80)        IF(INITP.NE.999)CALL TPLTI       INITP=999e8       IF(NPT.EQ.0.AND.(XINC.EQ.0..OR.YINC.EQ.0.)) RETURN       LOGX=1       LOGY=1 CT C    NCX: # CELLS FOR  X AXIS ( C         IF(NCX .LT. 0) X AXIS IS LOG10 C    NCY: # CELLS FOR  Y AXIS ) C          IF(NCY .LT. 0) Y AXIS IS LOG10= C    ICX: LEFT INITIAL CELL #= C    ICY: BOTTOM INITIAL CELL # - C    IDV: SPECIFIES if histogram mode or not.  C        IF(NCX .LT. 0) LOGX=-1       IF(NCY .LT. 0) LOGY=-1#       NXINC=IABS(NCX)/(NCXBT*NTXBL)R       NCXBL=NCXBT*NTXBL        NCYBL=NCYBT*NTYBLt 89    IF(XINC.NE.0.)GO TO 10        IF(XINCD .EQ. 0.) GO TO 21       XMIN=XMIND       XINC=XINCD       GO TO 10   21  XMIN=XARR(1)       XMAX=XARR(1)       DO 20 I=1,NPT %       IF(XARR(I).LT.XMIN)XMIN=XARR(I)L%       IF(XARR(I).GT.XMAX)XMAX=XARR(I)= 20    CONTINUE C=* C   PRESCALE XMAX IF  NCX .NE. NXINC*NCXBL C ,       IF(IABS(NCX).EQ. NXINC*NCXBL) GO TO 316       XMAX=XMIN+(XMAX-XMIN)*(1.*NXINC*NCXBL)/IABS(NCX):   31  CALL SCALE2(XMIN,XMAX,NXINC,XMINS,XMAXS,XINC,SVAL,0)=       IF(LOGX .EQ. -1)CALL SCALE3(XMIN,XMAX,NXINC,XMINS,XINC)        XMIN=XMINS 10    IF(YINC.NE.0.)GO TO 30        IF(YINCD .EQ. 0.) GO TO 35       YMIN=YMIND       YINC=YINCD       GO TO 30   35  YMIN=1.0E+30       YMAX=-1.0E+30 )       XMAX=XMIN+(1.*IABS(NCX))/NCXBL*XINC        DO 40 I=1,NPT  C . C  CHECK IF INSIDE PLOTTING RANGE XMIN TO XMAX C 6       IF(XARR(I).LT.XMIN .OR. XARR(I).GT.XMAX) GOTO 40%       IF(YARR(I).LT.YMIN)YMIN=YARR(I)P%       IF(YARR(I).GT.YMAX)YMAX=YARR(I)  40    CONTINUE C 4 C   NEXT LINE CHANGED FROM .LT. TO .LE. 19FEB80 CJK. C        IF(YMIN.LE.YMAX)GO TO 36
       YMIN=0. 
       YMAX=0.=#   36  NYINC=IABS(NCY)/(NCYBT*NTYBL)=-       IF(IABS(NCY) .EQ. NYINC*NCYBL) GO TO 38  C  C   PRESCALE RANGE OF Y  C 6       YMAX=YMIN+(YMAX-YMIN)*(NYINC*NCYBL*1.)/IABS(NCY):   38  CALL SCALE2(YMIN,YMAX,NYINC,YMINS,YMAXS,YINC,SVAL,0)=       IF(LOGY .EQ. -1)CALL SCALE3(YMIN,YMAX,NYINC,YMINS,YINC)O       YMIN=YMINS#   30  NXINC=IABS(NCX)/(NCXBT*NTXBL)D#       NYINC=IABS(NCY)/(NCYBT*NTYBL)P C,6 C    TEKTRONIX GRAPHICS DEVICE:  X: 0-1023  , Y: 0-779 CE CS* C    MAP USER UNITS INTO SCREEN UNITS I.E. C            XMIN----->    ICX2 C          XMIN+(XINC*NCX)/NCXBL ------> ICX+NCX-1 C            YMIN----->    ICY5 C            YMIN+(YINC*NCY)/NCYBL -------> ICY+NCY-1A C(       DX=XINC/NCXBLY       DY=YINC/NCYBL        XORG=ICX       YORG=ICY       XLEN=IABS(NCX)       YLEN=IABS(NCY)
       ILINE=01       MSYM=1? C     WRITE(6,200)XMIN,XINC,NXINC,YMIN,YINC,NYINC,DX,DY,ICX,ICY >  200  FORMAT(' XMIN=',F10.3,/,' XINC=',F10.3,/,' NXINC=',I5,/,8      # ' YMIN=',F10.3,/,' YINC=',F10.3,/,' NYINC=',I5,/,*      # ' DX,DY=',2F12.4,/,' ICX,ICY=',2I6)
       NXL=ICXI       NXU=ICX+IABS(NCX)-
       NYL=ICYN       NYU=ICY+IABS(NCY) 8 C     CALL LINE(XARR,YARR,NPT,ILINE,MSYM,XMIN-ICX*DX,DX,8 C    $                                   YMIN-ICY*DY,DY)#       IF(IDV.GT.0 .AND. NPT .NE. 0) 3      #CALL LINEC(XARR,YARR,CHAR,NPT,XMIN-ICX*DX,DX,03      #                              YMIN-ICY*DY,DY)=#       IF(IDV.LT.0 .AND. NPT .NE. 0)=3      #CALL LINEH(XARR,YARR,CHAR,NPT,XMIN-ICX*DX,DX,C3      #                              YMIN-ICY*DY,DY) #       IF(IDV.EQ.0 .AND. NPT .NE. 0)S4      #CALL LINEH2(XARR,YARR,CHAR,NPT,XMIN-ICX*DX,DX,3      #                              YMIN-ICY*DY,DY)E       NXL=0C       NXU=8192       NYL=0N       NYU=8192       IMMET=NTXBL*NCXBT,       NCBT=NCXBT       NDEC=NXDEC       NDIG=NXDIGD       CALL AXISS_TPLT(XORG,YORG,XLEN*LOGX,0.,XMIN,XINC/NCXBL,XLAB,4)       IMMET=NTYBL*NCYBTO       NCBT=NCYBT       NDEC=NYDEC       NDIG=NYDIGF       CALL AXISS_TPLT(XORG,YORG,YLEN*LOGY,90.,YMIN,YINC/NCYBL,YLAB,-4)       IMMET=NTXBL*NCXBTX       NCBT=NCXBT       NDEC=NXDEC       NDIG=NXDIGG       CALL AXISS_TPLT(XORG,YORG+IABS(NCY),XLEN*LOGX,0.,XMIN,0.,XLAB,-1)T       IMMET=NTYBL*NCYBT        NCBT=NCYBT       NDEC=NYDEC       NDIG=NYDIGG       CALL AXISS_TPLT(XORG+IABS(NCX),YORG,YLEN*LOGY,90.,YMIN,0.,YLAB,1)Y$ C==== Flush plot buffer onto screen.  199  CALL PLOT_I(0,0,99)T       RETURN9       ENTRY ENPLT(XARR,YARR,CHAR,NPT,NCX,NCY,ICX,ICY,IDV) #       NXINC=IABS(NCX)/(NCXBT*NTXBL)T#       NYINC=IABS(NCY)/(NCYBT*NTYBL)        NCXBL=NCXBT*NTXBLI       NCYBL=NCYBT*NTYBLE       DX=XINC/NCXBL        DY=YINC/NCYBL        XORG=ICX       YORG=ICY
       ILINE=0=       MSYM=1
       NXL=ICXL       NXU=ICX+IABS(NCX) 
       NYL=ICYd       NYU=ICY+IABS(NCY)N8 C     CALL LINE(XARR,YARR,NPT,ILINE,MSYM,XMIN-ICX*DX,DX,8 C    #                                   YMIN-ICY*DY,DY)?       IF(IDV.GT.0)CALL LINEC(XARR,YARR,CHAR,NPT,XMIN-ICX*DX,DX,N3      #                              YMIN-ICY*DY,DY)N?       IF(IDV.LT.0)CALL LINEH(XARR,YARR,CHAR,NPT,XMIN-ICX*DX,DX, 3      #                              YMIN-ICY*DY,DY)L@       IF(IDV.EQ.0)CALL LINEH2(XARR,YARR,CHAR,NPT,XMIN-ICX*DX,DX,3      #                              YMIN-ICY*DY,DY)I       NXL=0N       NXU=8192       NYL=0M       NYU=8192$ C==== Flush plot buffer onto screen.  299  CALL PLOT_I(0,0,99),       RETURN	       END 