.       SUBROUTINE TRFIT(N,NMAX,XIN,XOUT,XFIT,*)A C================================================================ A C== TRFIT: THIS ROUTINE PERFORMS A LEAST SQUARES FIT TO        == A C== A GROUP OF N POINTS IN 5-DIMENSIONAL PHASE SPACE           == A C== (X,THETA,Y,PHI,DELTA) SPECIFIED AT SOME INITIAL LOCATION   == A C== BY THE ARRAY "XIN", AND THEIR CORRESPONDING DOWNSTREAM     == A C== COORDINATES BY THE ARRAY "XOUT". THE MATRIX TRANSFORMATION,== A C== COMPLETE TO 2ND ORDER WITH SOME 3RD ORDER TERMS, IS        == A C== FOUND BY A LEAST SQUARES METHOD. THE 1ST ORDER TRANSFER    == A C== MATRIX IS RETURNED IN MATRIX "R1", DIMENSIONED 5X5, AND    == A C== THE 2ND ORDER TRANSFER MATRIX IS RETURNED IN MATRIX "R2",  == A C== DIMENSIONED 5X15.                                          == A C================================================================ A C== N.B. THIS VERSION FITS THE FULL 3RD ORDER MATRIX.          == A C== THE 1ST ORDER MATRIX REQUIRES  5 PARAMETERS,               == A C== THE 2ND ORDER MATRIX REQUIRES 15 PARAMETERS,               == A C== THE 3RD ORDER MATRIX REQUIRES 35 PARAMETERS,               == A C== FOR A TOTAL OF 55 PARAMETERS (MUST BE < NUMBER OF RAYS RUN)== A C================================================================ A C==                                                            == A C== INPUT PARAMETERS: N,NMAX,XIN,XOUT,XFIT                     == A C==   N: NUMBER OF POINTS CONSIDERED                           == A C==   NMAX: UPPER LIMIT FOR N (1ST DIMENSION OF ARRAY XIN)     == A C==   XIN: INPUT PHASE SPACE COORDINATES OF POINTS, DIM.(NMAX,5)= A C==   XOUT: OUTPUT PHASE SPACE COORDINATES OF POINTS,DIM.(NMAX,5) A C==   XFIT: FIT TO OUTPUT PHASE SPACE COORDINATE VECTOR        == A C==                                                            == A C== OUTPUT PARAMETERS: NONE                                    == A C================================================================        IMPLICIT REAL*8 (A-H,O-Z) D       REAL*8 XIN(NMAX,1),XOUT(NMAX,1),XFIT(NMAX,1),P(55,6),E1(55,6),3      #       E2(55,6),R1(6,6),R2(6,6,6),R3(6,6,6,6) /       LOGICAL*1 VAR(6)/'X','T','Y','P','L','D'/ '       COMMON /BUFF1/ BUFFER(132),AZ(80)        LOGICAL*1 BUFFER       INTEGER*2 AZ       EXTERNAL AUXR A C================================================================ A C== FIT EACH ROW OF THE TRANSFER MATRIX ROWS SEPARATELY USING  == A C== DLQF TO PERFORM THE LEAST SQUARES FIT.                     == A C================================================================ 
       M=55       NI=-1        EPS=1.0D-4
       NX=0       DO 10 J=1,6        IF(J.EQ.5) GOTO 18
       NX=NX+1        DO 15 K=1,M        P(K,J)=0.0D0    15 CONTINUE?       CALL DLQFMV(XIN,XOUT(1,NX),XFIT(1,NX),WT,E1(1,J),E2(1,J), ,      # P(1,J),0.0D0,N,M,NMAX,NI,ND,EPS,AUXR)       IF(ND.NE.1) GOTO 90 
    18 NP=0A C================================================================ A C== FILL 1ST ORDER (R1) MATRIX ELEMENTS                        == A C================================================================        DO 20 K=1,6 $       IF(J.EQ.5 .OR. K.EQ.5) GOTO 21
       NP=NP+1        R1(J,K)=P(NP,J) 
       GOTO 20     21 R1(J,K)=0.0D0 +       IF(J.EQ.5 .AND. K.EQ.5) R1(J,K)=1.0D0     20 CONTINUEA C================================================================ A C== FILL 2ND ORDER (R2) MATRIX ELEMENTS                        == A C================================================================        DO 22 K1=1,6       DO 24 K2=1,K1 2       IF(J.EQ.5 .OR. K1.EQ.5 .OR. K2.EQ.5) GOTO 23
       NP=NP+1        R2(J,K1,K2)=P(NP,J)        R2(J,K2,K1)=P(NP,J) 
       GOTO 24     23 R2(J,K1,K2)=0.0D0        R2(J,K2,K1)=0.0D0     24 CONTINUE    22 CONTINUEA C================================================================ A C== FILL 3RD ORDER (R3) MATRIX ELEMENTS                        == A C================================================================        DO 50 K1=1,6       DO 51 K2=1,K1        DO 52 K3=1,K2 ?       IF(J.EQ.5 .OR. K1.EQ.5 .OR. K2.EQ.5 .OR. K3.EQ.5) GOTO 53 
       NP=NP+1        R3(J,K1,K2,K3)=P(NP,J)
       GOTO 52O    53 R3(J,K1,K2,K3)=0.0D0    52 CONTINUE    51 CONTINUE    50 CONTINUE    10 CONTINUEA C================================================================ A C== WRITE OUT 1ST ORDER TRANSFER MATRIX R1                     ==AA C================================================================AE       WRITE(6,25) (AZ(IQQ),IQQ=2,80), ( (R1(IR, IJ), IJ=1,6), IR=1,6)     25 FORMAT(1H1//5X, 79A1//<      1       51X, 15H *TRANSFORM* 1  , // 6(25X, 6F10.5/)  )A C================================================================EA C== WRITE OUT 2ND ORDER TRANSFER MATRIX R2                     ==DA C================================================================T       DO 30 I1=1,6       DO 35 I2=1,62       WRITE(6,100) (I1,I3,I2,R2(I1,I3,I2),I3=1,I2)!   100 FORMAT(6(I4,I2,I1,1PE11.3))=    35 CONTINUE       WRITE(6,110)   110 FORMAT(1X)    30 CONTINUEA C================================================================ A C== WRITE OUT 3RD ORDER TRANSFER MATRIX R3 (X AND Y ROWS ONLY) == A C================================================================        DO 60 J=1,3,2 -       WRITE(6,68) (AZ(IQQ),IQQ=2,80),VAR(J),JU    68 FORMAT(1H1//5X,79A1// >      1       10X,A1,' ROW OF 3RD ORDER MATRIX (ROW ',I1,')'//)       DO 61 K1=1,6       DO 62 K2=1,K1 5       WRITE(6,67) (J,K1,K2,K3,R3(J,K1,K2,K3),K3=1,K2),"    67 FORMAT(6(I4,I2,2I1,1PD11.3))    62 CONTINUE       WRITE(6,66)O    66 FORMAT(1X)    61 CONTINUE    60 CONTINUE       RETURN    90 RETURN 1	       ENDA&       FUNCTION AUXR(NMAX,P,D,X,L,IERR)A C================================================================EA C== THIS FUNCTION ROUTINE SHOULD BE USED IN CONJUNCTION WITH   ==UA C== THE SUBROUTINE "TRFIT" TO LEAST SQUARES FIT TRANSFER       == A C== MATRIX COEFFICIENTS. IT IS CALLED BY "LQF" FROM THAT ROUTINE=NA C=================================================================       IMPLICIT REAL*8 (A-H,O-Z)=        REAL*8 P(1),D(1),X(NMAX,1)       LOGICAL IERR       IERR=.FALSE.       AUXR=0.0D0A C================================================================6A C== 1ST ORDER TRANSFER MATRIX COEFFICIENTS                     ==MA C================================================================E       DO 10 J=1,5N       D(J)=X(L,J)=       AUXR=AUXR+P(J)*D(J)=    10 CONTINUEA C================================================================LA C== 2ND ORDER TRANSFER MATRIX COEFFICIENTS                     == A C=================================================================	       M=5        DO 20 J=1,5        DO 25 K=1,J.       M=M+1X       D(M)=X(L,J)*X(L,K)       AUXR=AUXR+P(M)*D(M)     25 CONTINUE    20 CONTINUEA C================================================================)A C== 3RD ORDER TRANSFER MATRIX COEFFICIENTS                     ==DA C=================================================================       DO 30 K1=1,5       DO 31 K2=1,K1=       DO 32 K3=1,K2T       M=M+1A"       D(M)=X(L,K1)*X(L,K2)*X(L,K3)       AUXR=AUXR+P(M)*D(M)=    32 CONTINUE    31 CONTINUE    30 CONTINUE       RETURN	       ENDF>       SUBROUTINE DLQFMV(X,Y,YF,W,E1,E2,P,WZ,N,M,NMAX,NI,ND,EP,      # AUX,*,*)2A C================================================================DA C== DLQFMV: THIS ROUTINE IS A SLIGHTLY MODIFIED VERSION OF THE ===A C== UBC COMPUTING CENTRE'S "DLQF" SUBROUTINE. THE PRIMARY      == A C== MODIFICATION IS TO ALLOW EASY HANDLING OF THE CASE WHERE   ===A C== Y DEPENDS ON MORE THAN A SINGLE INDEPENDENT VARIABLE. AN   == A C== EXTRA ARGUMENT  IS INTRODUCED INTO THE CALLING SEQUENCE -- == A C== THIS IS "NMAX", WHICH IS THE 1ST DIMENSION OF THE ARRAY "X".= A C== ALSO, THE ARRAY OF INDEPENDENT VARIABLES "X" IS NOW        == A C== DIMENSIONED X(NMAX,NVAR), WHERE N IS NUMBER OF DATA VALUES,===A C== AND NVAR IS THE NUMBER OF INDEPENDENT VARIABLES.           == A C==                                                            ===A C== SUMMARY OF DLQFMV ARGUMENTS:                               == A C==                                                            ==OA C== NAME    DIMENSION              DESCRIPTION                 ==OA C==                                                            == A C== X     NMAX,NVAR     ARRAY OF INDEPENDENT VARIABLE VALUES   ===A C== Y     N             ARRAY OF DEPENDENT VARIABLE VALUES     ==1A C== YF    N             RETURNED ARRAY OF FITTED VALUES TO Y   ===A C== W     N             ARRAY OF WEIGHTS FOR DATA POINTS       ==RA C== E1    N             ARRAY OF ROOT MEAN SQUARE STATISTICAL ERR A C== E2    N             ARRAY OF ROOT MEAN SQUARE TOTAL ERROR  ===A C== P     M             ARRAY OF PARAMETER VALUES              == A C== WZ    1             WEIGHT FLAG, SPECIFY W IF WZ NOT 0.0   ===A C== N     1             NUMBER OF DATA POINTS                  ==1A C== M     1             NUMBER OF PARAMETERS TO BE FITTED      ==,A C== NMAX  1             UPPER LIMIT TO N (1ST DIM. OF X ARRAY) == A C== NI    1             MAXIMUM NUMBER OF ITERATIONS           ===A C== ND    1             SUCCESS FLAG ( FIT OK IF ND=1 RETURNED)==RA C== EPS   1             CONVERGENCE TOLERANCE                  ===A C== AUX   EXTERNAL      NAME OF USER CODED AUXILIARY FUNCTION  == A C==                                                            ==/A C== THE CALLING SEQUENCE TO THE USER SUPPLIED ROUTINE "AUX"    ==,A C== HAS ALSO BEEN MODIFIED FROM THE "DLQF" CALL. IT NOW  HAS   == A C== THE FOLLOWING CALLING SEQUENCE:                            ==1A C==                                                            ==OA C== FUNCTION AUX(NMAX,P,D,X,L,IERR)                            == A C==                                                            ===A C== WHERE THESE VARIABLES ARE DEFINED AS FOLLOWS:              ==UA C==                                                            == A C== NMAX  1             UPPER LIMIT TO NO. OF PTS (1ST DIM. OF X)SA C== P     M             ARRAY OF CURRENT PARAMETER VALUES      ===A C== D     M             ARRAY OF DERIVATIVES D(AUX)/D(P(I))    ==ZA C== X     NMAX,NVAR     NOW FULL X ARRAY PASSED, NOT SINGLE VALUERA C== L     1             INDEX OF CURRENT X, IE. USE X(L,NVAR)  ===A C== IERR  LOGICAL       USER SHOULD SET TO .TRUE. UPON ERROR   ==NA C==                                                            ===A C== N.B. THIS REVMOC VERSION IS DIMENSIONED FOR UP TO  55      == A C==      PARAMETERS.                                           ===A C================================================================M       IMPLICIT REAL*8(A-H,O-Z)>       DIMENSION X(NMAX,1),Y(N),YF(N),P(55),E1(55),E2(55),W(55)>       DIMENSION C(1540),V(55),D(55),CU(55,55),VV(55,1),PP(55),
      # VP(55)X       LOGICAL PRINT,IERR       EQUIVALENCE (V(1),VV(1))6       REAL FMT(16)/'(8H ','ITER','#  ,','    ','(   ',(      #             '6HPA','RAM#',',I2,',6      #             '4X),','8HRE','SIDU','AL,4','X,9H',(      #             'STEP',' SIZ','E/) '/       IF (N .LE.M) GO TO 200       PRINT=NI.GT.01       IERR=.FALSE.       NII=IABS(NI)
       ND=1       ALPHA=1.0D0(       XXP=1.E+35
       MB=M       IF(MB.GT.4) MB=4$       CALL BTD(MB,FMT(4),4,ISIG,' ')'       IF(PRINT) WRITE(6,FMT) (I,I=1,MB)  1000   NT=1D
       IV=0
 5     IJ=0       DO 10 I=1,M,       V(I) = 0.D0        DO 10 J=1,I=       IJ=IJ + 1= 10    C(IJ) = 0.D0
       XX=0.D0L
       TT=0.D0I       DO 20 L=1,ND       IF(WZ) 6,7,6
 6     WT=W(L)O
 22    GO TO 8S
 7     WT=1.D0I 8     U=AUX(NMAX,P,D,X,L,IERR)       IF(IERR) GOTO 99        XX=XX+WT*(U-Y(L))*(U-Y(L))       IJ = 0       DO 30 J=1,MS       DO 30 I=J,MA       IJ = IJ + 1=" 30    C(IJ) = C(IJ) + WT*D(I)*D(J)       DO 40 I=1,MC  40    V(I)=V(I)+WT*(Y(L)-U)*D(I) 20    CONTINUE
       M6=M       IF(M6.GT.4) M6=43       IF(PRINT) WRITE(6,4)NT,(P(I),I=1,M6),XX,ALPHA      4 FORMAT(1X,I4,1X,6G12.4)A,       IF(XX/XXP .GT. 1.01) ALPHA=ALPHA/2.0D0!       IF(ALPHA.LT.1.0E-4) GOTO 65N"       IF(XX/XXP .GT. 1.01) GOTO 90       XXP=XX       ALPHA=1.0D0  1001   IF(IV.EQ.1) GO TO 45        IF(NT-NII) 35,45,55:! 35    CALL DSSOL(C,VV,1,IJ,M,KEY)        DO 80 I=1,M        PP(I)=P(I)       VP(I)=V(I)    80 CONTINUE       IF (KEY .EQ. 1) GO TO 65
       NT=NT+1     90 DO 75  I=1,M       P(I)=PP(I)+ALPHA*VP(I)       V(I)=VP(I)       TC=DABS(V(I)/P(I))       IF(TC.GT.TT) TT=TC 75    CONTINUE,       IF(TT.LT.EP .AND. ALPHA.EQ.1.0D0) IV=1
       GO TO 5R 45    DO 46 I=1,M1       DO 46 J=1,M  46    CU(I,J) = 0.D0       DO 47 I=1,MY 47    CU(I,I) = 1.D0!       CALL DSSOL(C,CU,M,IJ,M,KEY)        IF (KEY .EQ. 1) GO TO 65       DO 85 I=1,MR       DO 85 J=1,MT  85    P(I) = P(I) + CU(I,J)*V(J) 55    DO 95 I=1,ME" 95    E1(I) = DSQRT(DABS(CU(I,I))) 1002  S=0.D0       DO 105 L=1,N       IF(WZ) 16,17,16 
 16    WT=W(L)        GO TO 18
 17    WT=1.D0W" 18    YF(L)=AUX(NMAX,P,D,X,L,IERR)       IF(IERR) GOTO 99       XX=(Y(L)-YF(L))**2       S=XX*WT + S  105   CONTINUE
       PPP=N-M        FI=DSQRT(S/PPP)        DO 115 I=1,M 115   E2(I)=FI  *E1(I)       RMS=DSQRT(S/N)$       IF(PRINT) WRITE(6,73) NT,S,RMS* 1003  IF (IV .NE. 1 .AND. NII .NE.1) ND=-1       RETURN 65    IF(PRINT) WRITE(6,2)' 2     FORMAT(22H LINEAR EQUATIONS FAIL)E
       ND=0       RETURNG 71    FORMAT(/53H INTERMEDIATE ESTIMATES OF PARAMETERS, SUM OF SQUARES)=:    73 FORMAT('0AFTER ',I3,' ITERS: SUM OF SQUARES=',G12.5,      # '  RMS ERROR=',G12.5/)U 200   IF(PRINT) WRITE(6,210): 210   FORMAT('REQUIRE # OF DATA POINTS > # OF PARAMETERS')
       ND=0       RETURN    99 RETURN 1	       ENDE%       SUBROUTINE DSSOL(A,B,L,M,N,KEY)        IMPLICIT REAL*8(A-H,O-Z)       DIMENSION A(M), B(55,L)= C  C !       IF (A(1).LE.0.D0) GO TO 150        IF (M .EQ. 1) GO TO 160 #             A(1) = 1.D0/DSQRT(A(1))        DO 10 I=2,N  10          A(I) = A(I)*A(1) CR CE             INC = N              I1  = 1              IN  = N              NM1 = N - 1  C  20          INC = INC - 1              I1 = IN + 1              IN = IN + INC              NS = N - INC CR             X = 0.D0             ISUB =I1             DO 30 I=INC,NM1V            ISUB = ISUB - I# 30          X = X + A(ISUB)*A(ISUB)Y'       IF (A(I1) -X .LT. 0.D0) GO TO 150 $             A(I1) = DSQRT(A(I1) - X) C, CR#       IF (A(I1).EQ. 0.D0) GO TO 150S             A(I1) = 1.D0/A(I1)       IF (INC .EQ. 1) GO TO 90 C              I11 =I1 + 1              L11 = I1 - INC       DO 50 I=I11,IN             X = 0.D0             L1 = L11                L2 = I - INC        DO 40 J =1,NS=             X = X + A(L1)*A(L2)=             L1 = L1 - INC - J= 40          L2 = L2 - INC - J-" 50          A(I) =(A(I) - X)*A(I1)       GO TO 20 90    DO 130 K=1,L              B(1,K) = B(1,K)*A(1)       DO 110 I=2,N             JM = I-1             ISUB = I             INC = N              X = 0.D0       DO 100 J=1,JME"             X = A(ISUB)*B(J,K) + X             INC = INC - 1, 100         ISUB = ISUB + INC8) 110         B(I,K) = (B(I,K) - X)*A(ISUB)  C'              B(N,K) = B(N,K)*A(M)             INC = -1             J1  = M+1        DO 125 I=2,N             INC = INC + 1              JM = J1 - 2X             J1 = JM - INC              JSUB = N-INC-1             II = JSUB              X = 0.D0       DO 120 J=J1,JM             JSUB = JSUB + 1 " 120         X = X + A(J)*B(JSUB,K)+ 125         B(II,K) = (B(II,K) - X)*A(J1-1)  130         CONTINUE             KEY  = 0             RETURN 150         KEY = 1F             RETURN 160   B(1,1)=B(1,1)/A(1)       KEY=0        RETURN             END   