?       SUBROUTINE TT_GET_INPUT(PROMPT,LINE,LENGTH,LUNOUT,CTRLZI) H C======================================================================= C== < C==   Terminal input interface routine which allows for line; C==   input recall as is done for DCL commands. The PF1 key ; C==   lists the current recall buffer lines (up to 20). The @ C==   PF2 key invokes a HELP facility. PF3 list a set (up to 21)D C==   of recallable, user loadable (via CTRL-L), set of input lines.A C==   PF4 key invokes a simple desk calculator. The status of the ? C==   current line is restored if no selection is made from the B C==   static or dynamic buffers list, as well as after terminating C==   the desk calculator. C== = C==   PROMPT: Character string used for line input prompting. > C==           The first character is used for carriage control( C==           and thus is usually blank.: C==   LINE  : Character string containing the current line9 C==           returned to the calling program if on input 8 C==           LENGTH was set to .LE. 0. If LENGTH>0 then7 C==           LINE is used as the initial default input 9 C==           which the terminal user can edit as desired 7 C==           before returning the contents back to the  C==           calling program.8 C==           It is recommended that LINE be dimensioned3 C==           CHARACTER*255 in the calling program! A C==   LENGTH: Both input and output. If >0 then input string LINE ? C==           is used as the starting line buffer. The returned 0 C==           LINE length is returned in LENGTH.: C==   LUNOUT: Logical unit number for terminal prompts and0 C==           other terminal output (usually 6).8 C==   CTRLZI: LOGICAL*4 variable returned .TRUE. if LINE: C==           was entered using a CTRL-Z instead of a C/R. C==   C C==          For the Tektronix 4010 devices (TK4010) this interface 1 C==          will not have all the VT100 features  C < C   Modified by J. Chuma on October 25, 1988 so that simple 3 C     Carriage Returns are not stored in the buffer E C   Modified by C.Kost on Jan/31/89 to use non-error trapping version ' C   of EVALUATE called EVALUATE_NO_TRAP H C=======================================================================       CHARACTER*(*) PROMPT       CHARACTER*(*) LINE8       CHARACTER*255 BUFFER(21),BUFFERS(21),TBUFF/' '/   4       INTEGER*4 LENBUF(21)/21*-1/,LENBUFS(21)/21*-1/       EXTERNAL DVI$_TT_INSERT  C I C==  To allow an external routine to 'preload' the dynamic recall buffers G C==  BUFFER and the statics buffers BUFFERS we place the following in a  C==  COMMON block TT_BUFFER. C 0       COMMON/TT_BUFFER/BUFFER,LENBUF,NBUFF,LAST,2      #                BUFFERS,LENBUFS,NBUFFS,LASTS C H       CHARACTER*21 RECAL /'123456789abcdefghijkl'/ ! 1-21 BUFFER(s) CODEH       CHARACTER*21 RECALL/'123456789ABCDEFGHIJKL'/ ! 1-21 BUFFER(s) CODE       CHARACTER*255 BLANKS/' '/ !       LOGICAL*1 INSERT,INSERT_DCL .       LOGICAL*1 UPLIM/.FALSE./,LOWLIM/.FALSE./       LOGICAL CTRLZI       LOGICAL ACTIVE/.TRUE./L       INTEGER*4 NBUFF/0/     ! # of recallable dynamic buffers filled so farE       INTEGER*4 NBUFFS/0/    ! # of recallable static buffers filled. A       INTEGER*4 LAST/0/      ! last DYNAMIC buffer # written into '       INTEGER*4 LASTP1/1/    ! LAST + 1 @       INTEGER*4 LASTS/0/     ! last STATIC buffer # written into5       INTEGER*4 NGET/1/      ! pointer for ^ v arrows F       INTEGER*4 LOCCUR/1/    ! location of cursor (from end of prompt)%       CHARACTER*1 KEY,ALTKEY,READ_KEY >       CHARACTER*1 CTRLA/1/   ! toggles insert/overstrike modes@       CHARACTER*1 CTRLB/2/   ! position up 1 line (like ^ arrow)?       CHARACTER*1 CTRLD/4/   ! position left 1 space (like <--) 6       CHARACTER*1 CTRLE/5/   ! position to end of line@       CHARACTER*1 CTRLF/6/   ! position right 1 space (like -->)G       CHARACTER*1 CTRLH/8/   ! position to column 1 (same as BACKSPACE) "       CHARACTER*1 CTRLI/9/   ! TABL       CHARACTER*1 CTRLJ/10/  ! line feed-- deletes previous field (not yet!)E       CHARACTER*1 CTRLK/11/  ! vertical tab--- disables recall buffer M       CHARACTER*1 CTRLL/12/  ! form feed-- puts current line in static buffer .       CHARACTER*1 CTRLM/13/  ! CARRIAGE RETURN.       CHARACTER*1 CTRLP/16/  ! ignored for now,       CHARACTER*1 CTRLR/18/  ! refresh line 7       CHARACTER*1 CTRLU/21/  ! erase all before cursor  6       CHARACTER*1 CTRLX/21/  ! erase all before cursor.       CHARACTER*1 CTRLZ/26/  ! handle like c/rK       CHARACTER*1 CTRLHAT/30/! CTRL^ recalls dynamic buffer matching string ,       CHARACTER*1 ESC/27/    ! ESC characterE       CHARACTER*1 DELETE/127/ ! delete previous character (except #1) L       CHARACTER*1 PF1/80/     ! ALTKEY: list, select dynamic recall buffers =       CHARACTER*1 PF2/81/     ! ALTKEY: help facility invoked I       CHARACTER*1 PF3/82/     ! ALTKEY: list, load, select static buffers @       CHARACTER*1 PF4/83/     ! ALTKEY: calls up desk calculator-       CHARACTER*1 TAB/9/      ! tab character  C G       COMMON /COM_TERMNAME/ TERMNAME    ! Application program sets this 2       CHARACTER*6 TERMNAME/'VT640 '/    ! default        LOGICAL     TT_INPUT#       COMMON /PLOT_INPUT_UNIT/ IINS &       COMMON /FORCE_TO_TERMINAL/IFORCE       DATA IINS /5/,IFORCE/0/  C 
       NCHAR=0        CTRLZI = .FALSE.*       IF(IFORCE.NE.0 .AND. ACTIVE) GO TO 37       IF( .NOT.(TT_INPUT(DUM)) .OR. (.NOT.ACTIVE) )THEN  C ? C  Since we are either in batch or SYS$INPUT is not SYS$COMMAND 6 C  OR the recall shell has been disabled with a CTRL-K= C  and this routine was still called then we will do our best @ C  and do a normal read which does not go into the recall shell. C          WRITE(LUNOUT,150)PROMPT /         READ(IINS,104,ERR=98,END=99)LENGTH,LINE  C $ C  Check if first character is a '!' C  Re-enable recall shell. C           IF(LINE(1:1).EQ.'!')THEN            WRITE(LUNOUT,97) ,  97        FORMAT('  Recall shell enabled ')            ACTIVE=.TRUE.          ENDIF         RETURN.  98     WRITE(LUNOUT,*)'*** ERROR during read'         GO TO 99       END IF C &   3   IF( TERMNAME .EQ. 'TK4010' )THEN  102    WRITE(LUNOUT,150)PROMPT 0         READ(IINS,104,ERR=102,END=99)LENGTH,LINE  104    FORMAT(Q,A)          RETURN   99    CTRLZI = .TRUE.          RETURN       END IF C 6 C==  Set INSERT_DCL to TRUE if DCL set for INSERT mode" C==  ie. user had $SET TERM/INSERT C +       INSERT_DCL=.FALSE.      ! VMS default 9       ISTAT=LIB$GETDVI(%LOC(DVI$_TT_INSERT),,'TT',IOUTVL) 2       IF(ISTAT.AND.(IOUTVL.NE.0))INSERT_DCL=.TRUE.       INSERT=INSERT_DCL        LP=LEN(PROMPT)       IF(LENGTH.GT.0)THEN  C % C==   Initialize buffer to input LINE  C            WRITE(LUNOUT,150)PROMPT          MAXLEN=MIN(131,LENGTH) (          WRITE(LUNOUT,151)LINE(1:MAXLEN)  150     FORMAT(A,$)  151     FORMAT('+',A,$)          LOCCUR=MAXLEN+1          NCHAR=MAXLEN           TBUFF=LINE(1:MAXLEN) 
       ELSE           WRITE(LUNOUT,100)PROMPT  100     FORMAT(A,$)       ENDIF H C=======================================================================4 C     Recycle point----- get another input characterH C======================================================================="   10  KEY=READ_KEY(' ',' ',ALTKEY)!       IF(ICHAR(ALTKEY).EQ.0) THEN  C " C     Normal( non-altkey)  key hit C       8          ICH=ICHAR(KEY)            ! Decimal code of key C ( C     Test for carriage return or CTRL-Z$ C     If found then input the record C C          IF(ICH.EQ.13 .OR. ICH.EQ.26) GO TO 200   ! input this line  C  C     Check for CTRL keys  C ;          IF(KEY.EQ.CTRLHAT) THEN                  ! level 2 8             GO TO 600      ! recall matching dyn. buffer C < C     CTRL-^  --- search dynamic buffer for preceding string1 C                 and if found recall that buffer  C #          ELSE IF(KEY.EQ.CTRLA)THEN   C / C     CTRL-A  --- toggle insert/overstrike mode  C              INSERT=.NOT.INSERT             GO TO 10"          ELSE IF(KEY.EQ.CTRLB)THEN C  C     CTRL-B (like up arrow ^) C F             INSERT=INSERT_DCL           !reset INSERT mode to DCL mode%             IF(.NOT.UPLIM)NGET=NGET-1 7             WRITE(LUNOUT,555)ESC   ! erase current line O             WRITE(LUNOUT,290)CTRLM ! carriage return sets cursor to left margin F             WRITE(LUNOUT,412)PROMPT(2:)! prompt without a line feed/cr%             IF(LENBUF(NGET).GE.0)THEN 1                TBUFF=BUFFER(NGET)(1:LENBUF(NGET)) >                WRITE(LUNOUT,510)TBUFF(1:MIN(131,LENBUF(NGET)))$                LOCCUR=LENBUF(NGET)+1!                NCHAR=LENBUF(NGET)                 LOWLIM=.FALSE.                 UPLIM=.FALSE.                GO TO 10              ELSE                LOCCUR=1                 NCHAR=0                UPLIM=.TRUE.                 GO TO 10              ENDIF  C ?          ELSE IF(KEY.EQ.CTRLE)THEN                     !LEVEL 2  C / C     CTRL-E  ---POSITION CURSOR TO END-OF-LINE  C F             IF(NCHAR-LOCCUR+1.EQ.0) GO TO 10  ! already at end of line/             WRITE(LUNOUT,310)ESC,NCHAR-LOCCUR+1 F  310        FORMAT('+',A1,'[',I3.3,'C',$)     ! position cursor to end             LOCCUR=NCHAR+1             GO TO 10 C "          ELSE IF(KEY.EQ.CTRLD)THEN C , C    CTRL-D (same action as left arrow <---) C "                IF(LOCCUR.GT.1)THEN!                   LOCCUR=LOCCUR-1 &                   WRITE(LUNOUT,530)ESC                ENDIF                GO TO 10  C #          ELSE IF(KEY.EQ.CTRLF) THEN  C - C    CTRL-F (same action as right arrow --->)  C 9                IF(LOCCUR.EQ.NCHAR+1) GO TO 10  ! like DCL $                IF(LOCCUR.LT.255)THEN!                   LOCCUR=LOCCUR+1 &                   WRITE(LUNOUT,540)ESC                ENDIF                GO TO 10  C ?          ELSE IF(KEY.EQ.CTRLH) THEN                    !LEVEL 2  C ? C     CTRL-H or BACKSPACE   ---Position cursor to begin of line  C <             IF(LOCCUR-1 .GT. 0)WRITE(LUNOUT,411)ESC,LOCCUR-1C   411       FORMAT('+',A1,'[',I3.3,'D',$)    ! cursor LOCCUR-1 left C   410          FORMAT('+',A1,'[1D',$)         ! cursor 1 space left              LOCCUR=1             GO TO 10 C 4          ELSE IF(KEY.EQ.CTRLR) THEN                  C ' C     CTRL-R   --- Refresh current line  C 7             WRITE(LUNOUT,555)ESC   ! erase current line O             WRITE(LUNOUT,290)CTRLM ! carriage return sets cursor to left margin F             WRITE(LUNOUT,412)PROMPT(2:)! prompt without a line feed/crL             WRITE(LUNOUT,510)TBUFF(1:MIN(131,LOCCUR-1)) ! first part of lineC             WRITE(LUNOUT,437)ESC              !save cursor position O             WRITE(LUNOUT,510)TBUFF(LOCCUR:MIN(131,NCHAR)) ! second part of line F             WRITE(LUNOUT,435)ESC              !restore cursor position   412       FORMAT('+',A,$)              GO TO 10 C ?          ELSE IF(KEY.EQ.CTRLU.OR.KEY.EQ.CTRLX) THEN    !LEVEL 2  C C C     CTRL-U or CTRL-X ---Erase all left of cursor and left justify  C               TBUFF=TBUFF(LOCCUR:)              NCHAR=NCHAR-LOCCUR+1$             IF(LOCCUR.LE.1) GO TO 107             WRITE(LUNOUT,555)ESC   ! erase current line O             WRITE(LUNOUT,290)CTRLM ! carriage return sets cursor to left margin F             WRITE(LUNOUT,412)PROMPT(2:)! prompt without a line feed/crD  420        FORMAT('+',A1,'[K',$)             ! erase to end of lineC             WRITE(LUNOUT,437)ESC              !save cursor position +             WRITE(LUNOUT,430)TBUFF(1:NCHAR)   430        FORMAT('+',A,$) F             WRITE(LUNOUT,435)ESC              !restore cursor position             LOCCUR=1             GO TO 10 C D          ELSE IF(KEY.EQ.DELETE) THEN          !Delete left character C 2 C     DELETE - erase character in front of cursor. C $             IF(LOCCUR.EQ.1) GO TO 10 C H C  delete from cursor to EOL, cursor left 1, save , write rest , restore C               WRITE(LUNOUT,431)ESC?  431        FORMAT('+',A1,'[1D',$)       !cursor left one space               WRITE(LUNOUT,437)ESC5  437        FORMAT('+',A1,'7',$)         !save cursor 5             WRITE(LUNOUT,433)TBUFF(LOCCUR:NCHAR)//' '   433        FORMAT('+',A,$)               WRITE(LUNOUT,435)ESC8  435        FORMAT('+',A1,'8',$)         !restore cursorG             TBUFF=TBUFF(1:LOCCUR-2)//TBUFF(LOCCUR:)                                  LOCCUR=LOCCUR-1              NCHAR=NCHAR-1              GO TO 10 C E          ELSE IF(KEY.EQ.CTRLK) THEN  !Disable the recall buffer shell  C ! C  Disable state of recall shell. 
 C                      ACTIVE=.FALSE.,             IF(.NOT.ACTIVE)WRITE(LUNOUT,436)C  436        FORMAT(' Recall shell disabled. Use "!" in column one',       #      '  to re-enable')              LENGTH=0             RETURN C 3          ELSE IF(KEY.EQ.CTRLP) THEN  !Ignore CTRL-P              GO TO 10 C 3          ELSE IF(KEY.EQ.CTRLL) THEN  !Ignore CTRL-L              GO TO 10 C :          ELSE IF(KEY.EQ.CTRLI) THEN  !Ignore CTRL-I or TAB             GO TO 10 C N          ELSE IF(KEY.EQ.CTRLJ) THEN  !Line-feed-- Delete previous field (N.A.)             GO TO 10 C 
          ELSE  C  C   Any normal character C              IF(INSERT)THEN C  C   Insert a character C I                WRITE(LUNOUT,440)KEY                 ! write the character '                IF(NCHAR.GE.LOCCUR) THEN D                   WRITE(LUNOUT,437)ESC                 ! save cursorC                   WRITE(LUNOUT,442)TBUFF(LOCCUR:NCHAR) ! write rest                 ENDIF  440           FORMAT('+',A1,$)   442           FORMAT('+',A,$)J                TBUFF=TBUFF(1:LOCCUR-1)//KEY//TBUFF(LOCCUR:NCHAR)   !updateH                IF(NCHAR.GE.LOCCUR) WRITE(LUNOUT,435)ESC ! restore cursor%                NCHAR=MIN(255,NCHAR+1) J                LOCCUR=LOCCUR+1                                     !update                GO TO 10              ELSE C  C   Overstrike C #                WRITE(LUNOUT,450)KEY   450           FORMAT('+',A1,$) '                TBUFF(LOCCUR:LOCCUR)=KEY /                IF(LOCCUR.GT.NCHAR)NCHAR=NCHAR+1                 LOCCUR=LOCCUR+1                GO TO 10              ENDIF              GO TO 10          ENDIFG       ELSE                                         !ICHAR(ALTKEY).NE.0   C ) C     Keypad ( or arrow) key hit           C           IF(ALTKEY.EQ.'^')THEN C  C     Up arrow C B             INSERT=INSERT_DCL       !reset INSERT mode to DCL mode%             IF(.NOT.UPLIM)NGET=NGET-1               IF(NGET.LT.1)NGET=217             WRITE(LUNOUT,555)ESC   ! erase current line O             WRITE(LUNOUT,290)CTRLM ! carriage return sets cursor to left margin F             WRITE(LUNOUT,412)PROMPT(2:)! prompt without a line feed/cr%             IF(LENBUF(NGET).GE.0)THEN 1                TBUFF=BUFFER(NGET)(1:LENBUF(NGET)) >                WRITE(LUNOUT,510)TBUFF(1:MIN(131,LENBUF(NGET)))  510           FORMAT('+',A,$)$                LOCCUR=LENBUF(NGET)+1!                NCHAR=LENBUF(NGET)                 LOWLIM=.FALSE.                 UPLIM=.FALSE.                GO TO 10              ELSE% C               WRITE(LUNOUT,521)NGET %  521           FORMAT('+ NGET=',I5,$)                 TBUFF=' '                LOCCUR=1                 NCHAR=0                UPLIM=.TRUE.                 GO TO 10              ENDIF  C $          ELSE IF(ALTKEY.EQ.'v') THEN C  C    Down arrow  C C             INSERT=INSERT_DCL        !reset INSERT mode to DCL mode &             IF(.NOT.LOWLIM)NGET=NGET+1              IF(NGET.GT.21)NGET=17             WRITE(LUNOUT,555)ESC   ! erase current line O             WRITE(LUNOUT,290)CTRLM ! carriage return sets cursor to left margin F             WRITE(LUNOUT,412)PROMPT(2:)! prompt without a line feed/cr%             IF(LENBUF(NGET).GE.0)THEN 1                TBUFF=BUFFER(NGET)(1:LENBUF(NGET)) >                WRITE(LUNOUT,510)TBUFF(1:MIN(131,LENBUF(NGET)))$                LOCCUR=LENBUF(NGET)+1!                NCHAR=LENBUF(NGET)                 LOWLIM=.FALSE.                 UPLIM=.FALSE.                GO TO 10              ELSE% C               WRITE(LUNOUT,521)NGET                 LOCCUR=1                 NCHAR=0                TBUFF=' '                LOWLIM=.TRUE.                GO TO 10              ENDIF  C $          ELSE IF(ALTKEY.EQ.'<') THEN C  C    Left arrow  C "                IF(LOCCUR.GT.1)THEN!                   LOCCUR=LOCCUR-1L&                   WRITE(LUNOUT,530)ESC(  530              FORMAT('+',A1,'[1D',$)                ENDIF                GO TO 10u Ce$          ELSE IF(ALTKEY.EQ.'>') THEN Cl C    Right arrow Co9                IF(LOCCUR.EQ.NCHAR+1) GO TO 10  ! like DCL $                IF(LOCCUR.LT.255)THEN!                   LOCCUR=LOCCUR+1 &                   WRITE(LUNOUT,540)ESC(  540              FORMAT('+',A1,'[1C',$)                ENDIF                GO TO 10t C .          ELSE IF(ICHAR(ALTKEY).EQ.80) THEN     CiL C    PF1 (Gold) keypad key. Show buffer list and optionally select an entry. Cs#                WRITE(LUNOUT,550)ESCl;  550           FORMAT(1X,A1,'[2J')           ! Clear screeni#                WRITE(LUNOUT,560)ESCi<  560           FORMAT(1X,A1,'[1;1H',$)       ! Home cursor                   WRITE(LUNOUT,561)D  561           FORMAT(' # ----5----0----5----0----5----0----5----0',>      #                  '----5----0----5----0----5----0----5')                DO I=1,NBUFFh                   NB=LAST-I+1a?                   IF(NB.LT.1)NB=21+NB        ! wrap over bottome#                   WRITE(LUNOUT,570) ?      #            RECALL(I:I),BUFFER(NB)(1:MIN(129,LENBUF(NB))) $  570              FORMAT(1X,A1,1X,A)                ENDDO                 WRITE(LUNOUT,580)9  580           FORMAT(' Type a recall code 1,2,3...K or',t8      #                ' a carriage return to resume ',$)+   60           KEY=READ_KEY(' ',' ',ALTKEY)= C 5 C==  Return and restore line and cursor as before PF1T Co'                IF(ICHAR(KEY).EQ.13)THENd9                WRITE(LUNOUT,550)ESC       ! clears screenT7                WRITE(LUNOUT,560)ESC       ! home cursor I                WRITE(LUNOUT,412)PROMPT(2:)! prompt without a line feed/crrO                WRITE(LUNOUT,510)TBUFF(1:MIN(131,LOCCUR-1)) ! first part of lineaF                WRITE(LUNOUT,437)ESC              !save cursor positionJ                WRITE(LUNOUT,510)TBUFF(LOCCUR:MIN(131,NCHAR)) ! second partI                WRITE(LUNOUT,435)ESC              !restore cursor positionE                   GO TO 10                ELSE L                   NM=INDEX(RECALL(1:NBUFF),KEY)           ! lower case checkL                   IF(NM.EQ.0)NM=INDEX(RECAL(1:NBUFF),KEY) ! UPPER CASE CHECK!                   IF(NM.NE.0)THENF#                      LOWLIM=.FALSE. "                      UPLIM=.FALSE.#                      NGET=LAST-NM+1a.                      IF(NGET.LT.1)NGET=21+NGET'                      NCHAR=LENBUF(NGET)f>                      WRITE(LUNOUT,550)ESC       ! Clear screen=                      WRITE(LUNOUT,560)ESC       ! home cursorR0                      TBUFF=BUFFER(NGET)(1:NCHAR),                      WRITE(LUNOUT,100)PROMPTD                      WRITE(LUNOUT,510)BUFFER(NGET)(1:MIN(131,NCHAR))#                      LOCCUR=NCHAR+1'                      GO TO 10S                   ELSE                      GO TO 60/                   ENDIF                 ENDIF C/*          ELSE IF(ICHAR(ALTKEY).EQ.81) THEN Ce) C    PF2 keypad key. Calls HELP facility.E C 6             WRITE(LUNOUT,550)ESC       ! clears screen4             WRITE(LUNOUT,560)ESC       ! home cursor             WRITE(LUNOUT,581)AA  581        FORMAT(' This terminal interface closely mimics',    b6      #        ' the DCL commands recall facility. ',/,8      #        ' The arrow, delete, backspace, and most',6      #        ' control keys, work as in DCL.     ',/,=      #        ' CTRL^ or CTRL~ appended to a string recalls',r3      #        ' the last command containing it.',/,s9      #        ' The functions keys have special meaning',       #        ' as follows:',/,-;      #        ' PF1 - list and allows selection of recall', $      #        ' buffer (dynamic)',/,3      #        ' PF2 - lists this HELP facility ',/, =      #        ' PF3 - list, loads (via CTRL-L), and selects', /      #        ' user input records (static)',/,l<      #        ' PF4 - invokes a simple desk CALCULATOR',/,/,E      #        ' CTRL-K disables shell, "!" in column 1 re-enables',/,*<      #        ' NOTE: Currently LINEFEED (CTRL-J), ESC and',-      #        ' TAB keys are not enabled.',/,N9      #        ' Contact Corrie Kost (310) for problems,',RC      #        ' suggestions, etc.',/,/,' TYPE ANY KEY TO RESUME',$)a(             KEY=READ_KEY(' ',' ',ALTKEY) CL4 C== Return and restore cursor position as before PF2 C/6             WRITE(LUNOUT,550)ESC       ! clears screen4             WRITE(LUNOUT,560)ESC       ! home cursorF             WRITE(LUNOUT,412)PROMPT(2:)! prompt without a line feed/crL             WRITE(LUNOUT,510)TBUFF(1:MIN(131,LOCCUR-1)) ! first part of lineC             WRITE(LUNOUT,437)ESC              !save cursor position O             WRITE(LUNOUT,510)TBUFF(LOCCUR:MIN(131,NCHAR)) ! second part of linedF             WRITE(LUNOUT,435)ESC              !restore cursor position             GO TO 10 C .          ELSE IF(ICHAR(ALTKEY).EQ.82) THEN     C ; C    PF3 keypad key. Show ( optionally load) static bufferst4 C                    and optionally select an entry. C ;                WRITE(LUNOUT,550)ESC          ! Clear screenN:                WRITE(LUNOUT,560)ESC          ! Home cursor                 WRITE(LUNOUT,562):  562           FORMAT('          STATIC BUFFERS LIST    ')>                WRITE(LUNOUT,561)             ! display a ruler                DO I=1,216                   IF(LENBUFS(I).GT.0)WRITE(LUNOUT,570)?      #            RECALL(I:I),BUFFERS(I)(1:MIN(129,LENBUFS(I)))n                ENDDO                 WRITE(LUNOUT,582)9  582           FORMAT(' Type a recall code 1,2,3...L or', :      #                ' CTRL-L to load. C/R to resume ',$)+   70           KEY=READ_KEY(' ',' ',ALTKEY) '                IF(ICHAR(KEY).EQ.13)THENh C.6 C==   Return and restore cursor position as before PF3 CN;   75              WRITE(LUNOUT,550)ESC       ! Clear screen :                   WRITE(LUNOUT,560)ESC       ! home cursorL                   WRITE(LUNOUT,412)PROMPT(2:)! prompt without a line feed/crK                   WRITE(LUNOUT,510)TBUFF(1:MIN(131,LOCCUR-1)) ! first part  I                   WRITE(LUNOUT,437)ESC              !save cursor positionEM                   WRITE(LUNOUT,510)TBUFF(LOCCUR:MIN(131,NCHAR)) ! second partRL                   WRITE(LUNOUT,435)ESC              !restore cursor position                   GO TO 10                ELSE H                   NM=INDEX(RECALL(1:21),KEY)           !lower case checkH                   IF(NM.EQ.0)NM=INDEX(RECAL(1:21),KEY) !UPPER CASE CHECK9                   IF(NM.NE.0 .AND. LENBUFS(NM).GT.0 )THENe Cf' C   Valid recall key (non-empty buffer)N C,#                      LOWLIM=.FALSE.E"                      UPLIM=.FALSE.&                      NCHAR=LENBUFS(NM)>                      WRITE(LUNOUT,550)ESC       ! Clear screen=                      WRITE(LUNOUT,560)ESC       ! home cursorI/                      TBUFF=BUFFERS(NM)(1:NCHAR) ,                      WRITE(LUNOUT,100)PROMPTC                      WRITE(LUNOUT,510)BUFFERS(NM)(1:MIN(131,NCHAR))h#                      LOCCUR=NCHAR+1=                      GO TO 10=@                   ELSE IF(KEY .EQ. CTRLL) THEN   !  load request CI> C    CTRL-L key: load current TBUFF into user specified buffer C )   50                 WRITE(LUNOUT,555)ESC!F  555                 FORMAT('+',A1,'[2K',$)      !  erase current line                      DO I=1,70G                         WRITE(LUNOUT,530)ESC     !  cursor left 1 space                       ENDDO&                      WRITE(LUNOUT,556)>  556                 FORMAT('+Enter store buffer # (1 to L),',,      #                  ' C/R to abort: ',$)1                      KEY=READ_KEY(' ',' ',ALTKEY) K                      NM=INDEX(RECALL(1:21),KEY)           !lower case checkLK                      IF(NM.EQ.0)NM=INDEX(RECAL(1:21),KEY) !UPPER CASE CHECK 2                      IF(ICHAR(KEY).EQ.13) GO TO 75M                      IF(NM.EQ.0) GO TO 50                 !invalid key--again  C  C    Valid store key--- storeI CR&                      BUFFERS(NM)=TBUFF&                      LENBUFS(NM)=NCHAR                      GO TO 75lM                   ELSE                                    !invalid key--againm                      GO TO 70T                   ENDIFi                ENDIF C .          ELSE IF(ICHAR(ALTKEY).EQ.83) THEN     CT* C    PF4 keypad key. Calls desk calculator C 7 C            WRITE(LUNOUT,550)ESC       ! clears screen 5 C            WRITE(LUNOUT,560)ESC       ! home cursorN             WRITE(LUNOUT,587)IC  587        FORMAT('       WELCOME TO THE DESK-TOP CALCULATOR!!! ')              WRITE(LUNOUT,590)LE  590        FORMAT('    -->>> Type a carriage return to exit <<<-- ') !             CALL EVALUATE_NO_TRAP              WRITE(LUNOUT,595)T:  595        FORMAT(' Thank you... Come again')             CS5 C==  Return and restore cursor position as before PF4L CU#             WRITE(LUNOUT,100)PROMPToL             WRITE(LUNOUT,510)TBUFF(1:MIN(131,LOCCUR-1)) ! first part of lineC             WRITE(LUNOUT,437)ESC              !save cursor positionRO             WRITE(LUNOUT,510)TBUFF(LOCCUR:MIN(131,NCHAR)) ! second part of lineCF             WRITE(LUNOUT,435)ESC              !restore cursor position             GO TO 10 C D C   Forgotten ALTKEY cases go here !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! CE CF C           ENDIF
 C                    ENDIFK       GO TO 10 C = C==  Update dynamic buffer and return line to calling program D C==  after setting cursor to left margin (so user has some feed-back9 C==  that he entered a line into his application program.  C   200  LINE=TBUFF       LENGTH=NCHAR"       IF( LENGTH .EQ. 0 )GO TO 202       LAST=LAST+1E       IF(LAST.GT.21)LAST=1       LASTP1=LAST+1E       IF(LASTP1.GT.21)LASTP1=1 C  C   Update dynamic BUFFERi Cf       BUFFER(LAST)=TBUFF       LENBUF(LAST)=NCHAR       LENBUF(LASTP1)=-11       NBUFF=NBUFF+1,       IF(NBUFF.GT.20)NBUFF=20C5  202  NGET=LASTP1               ! set to empty buffer        LOWLIM=.TRUE.f       UPLIM=.FALSE.RH       IF(ICH.EQ.26)CTRLZI=.TRUE.         ! set if line entered by CTRL-Z       TBUFF=' ' F CC      WRITE(LUNOUT,411)ESC,LP+LOCCUR-1   ! set cursor to left margin       WRITE(LUNOUT,290)CTRLM  290  FORMAT('+',A1,$)
       NCHAR=0i       LOCCUR=1=       INSERT=INSERT_DCL        !reset INSERT mode to DCL mode!       RETURN C 7 C  Update static buffer (result of CTRL-L (form feed) )1 CC  300  LASTS=LASTS+1o       IF(LASTS.GT.21)LASTS=1       NBUFFS=NBUFFS+1        IF(NBUFFS.GT.21)NBUFFS=21 #       BUFFERS(LASTS)=TBUFF(1:NCHAR)3       LENBUFS(LASTS)=NCHAR       GO TO 10       CU! C  String was appended with CTRL^c? C  Find a match with the dynamic buffer and place it in current0 C  buffer, else ignore CTRL^ CL  600  DO I=1,NBUFF       NB=LAST-I+1        IF(NB.LT.1)NB=21+NB-;       IMATCH=INDEX(BUFFER(NB)(1:LENBUF(NB)),TBUFF(1:NCHAR))B       IF(IMATCH.GT.0) GO TO 650C       ENDDOC       GO TO 10 CF C  Match found C D  650  WRITE(LUNOUT,555)ESC                      ! erase current lineA       WRITE(LUNOUT,290)CTRLM                    ! carriage returnrH       WRITE(LUNOUT,412)PROMPT(2:)               ! prompt without control/       WRITE(LUNOUT,510)BUFFER(NB)(1:LENBUF(NB)) $       TBUFF=BUFFER(NB)(1:LENBUF(NB))       LOCCUR=LENBUF(NB)+1        NCHAR=LENBUF(NB)       GO TO 10	       ENDT