-       CHARACTER*(*) FUNCTION UPPER_CASE(LINE)  C    C     reqd. routines - NONE A C================================================================ A C================================================================ A C==                                                            == A C==   UPPER_CASE: Converts lower case ASCII characters in      == A C==               "LINE" into UPPER CASE ASCII characters. All == A C==               other characters remain the same. The result == A C==               is returned in "UPPER_CASE".                 == A C==                    Both "LINE" and "UPPER_CASE"            == A C==               are variable length character strings, i.e.  == A C==               their length attribute is determined in the  == A C==               calling routine. The lengths of "LINE" and   == A C==               "UPPER_CASE" need not be the same. If "LINE" == A C==               is longer than "UPPER_CASE" then "LINE" will == A C==               be truncated and stored in "UPPER_CASE"; if  == A C==               "UPPER_CASE" is longer than "LINE" then it   == A C==               will be padded with blanks.                  == A C==                                                            == A C==   Written by Arthur Haynes, TRIUMF, U.B.C., Oct. 15, 1981. == A C==                                                            == A C==   Input  Parameters: LINE (CHARACTER*(N)).                 == A C==                                                            == A C==   Output Parameters: UPPER_CASE (CHARACTER*(N)).           == A C==                                                            == A C================================================================ A C================================================================        CHARACTER*(*) LINE       CHARACTER TABLE(0:255)       LOGICAL*1 NFIRST/.FALSE./        IF(NFIRST)GO TO 100 A C================================================================ A C==   First time through this subroutine.                      == A C==   Set up the character translation table to translate all  == A C==   lower case ASCII characters to upper case.               == A C================================================================        NFIRST=.TRUE.        DO 10 I=0,255 B       TABLE(I)=CHAR(I)            ! Most characters are unchanged. 10    CONTINUE       DO 20 I=97,122G       TABLE(I)=CHAR(I-32)         ! 0 parity lower case --> upper case. G       TABLE(I+128)=CHAR(I+128-32) ! 1 parity lower case --> upper case.  20    CONTINUE 100   LEN1=LEN(LINE)       LEN2=LEN(UPPER_CASE)       DO 30 I=1,MIN(LEN1,LEN2)?       UPPER_CASE(I:I)=TABLE(ICHAR(LINE(I:I))) ! Translate line.  30    CONTINUE1       IF(LEN2.GT.LEN1)UPPER_CASE(LEN1+1:LEN2)=' '        RETURN	       END   