$         FUNCTION VDT_CHAR_ATT (ATTR) CH5 C                                       Henry Baragar 3 C                                       TRIUMF, UBC 2 C                                       June, 1984 C  C  reqd. KOSTL routines -  CAI C======================================================================== I C=                                                                      = I C= VDT_CHAR_ATT                                                         =5I C=                                                                      = I C= This routine sets the terminal hardware to display characters        =(I C= written to the screen after the call with certain attributes.        = I C=                                                                      =0I C= INPUT:                                                               = I C=      ATTR  (Ch*(*)) - a string containing a description of the       ='I C=              attributes desired -- N.B.  more than one attribute     =AI C=              may be chosen;  The available attributes are:           =,I C=                      attribute            min. abbr.                 = I C=                      ---------            ----------                 = I C=                      'BLINKING'              'BLI'                   ==I C=                      'BOLD'                  'BOL'                   = I C=                      'NORMAL'                'NOR'                   = I C=                      'REVERSE_VIDEO'         'REV'                   =,I C=                      'UNDERLINE'             'UND'                   =xI C=              In addition for color terminals, there are the addi-    = I C=              tional commands to set the color of the text:           =GI C=                      'FG:'           - to set the foreground color;  ==I C=                      'BG:'           - to set the background color;  =2I C=              followed by a color:                                    = I C=                      'BLACK'                 'BLA'                   = I C=                      'RED'                   'RED'                   = I C=                      'GREEN'                 'GRE'                   =I C=                      'YELLOW'                'YEL'                   =BI C=                      'BLUE'                  'BLU'                   = I C=                      'MAGENTA'               'MAG'                   = I C=                      'CYAN'                  'CYA'                   =DI C=                      'WHITE'                 'WHI'                   = I C=                                                                      = I C= OUTPUT:                                                              = I C=      VDT_CHAR_ATT - always returns 0.0.                              = I C=                                                                      = I C= NOTE:                                                                = I C=          1)  This version currently only works in VT100 mode.        = I C=          2)  Calls to this routine are not cumulative.               = I C=                                                                      = I C= EXAMPLES:                                                            = I C=      DUMMY = VDT_CHAR_ATT ('BOLD')                                   = I C=      CALL VDT_CHAR_ATT ('BO')                                        = I C=      CALL VDT_CHAR_ATT ('REVERSE_VIDEO, BOLD')                       = I C=                                                                      = I C========================================================================  C    C             IMPLICIT INTEGER*4 (A-Z)         CHARACTER*1 ESC           PARAMETER (ESC=CHAR(27))$         PARAMETER (NATTR=5, NCOLR=8)G         CHARACTER*3 SATTR(NATTR)        /'NOR','BLI','BOL','REV','UND'/ G         CHARACTER*1 HATTR(NATTR,1)      / '0',  '5',  '1',  '7',  '4' / A         CHARACTER*3 SCOLR(NCOLR)        /'BLA','BLU','CYA','RED',hA      +                                   'GRE','MAG','YEL','WHI'/ @         CHARACTER*2 FGCOLR(NCOLR,1)     /'30', '34', '36', '31',@      +                                   '32', '35', '33', '37'/@         CHARACTER*2 BGCOLR(NCOLR,1)     /'40', '44', '46', '41',@      +                                   '42', '45', '43', '47'/         DATA TERM /1/=         CHARACTER*(*) ATTR C  =' C  * * *   M A I N    L O G I C   * * *  C            WRITE (6,600) ESC, '0'         DO IATTR=1,NATTR5             IF (INDEX(ATTR,SATTR(IATTR)) .GT. 0) THEN 0             WRITE (6,600) ESC, HATTR(IATTR,TERM)             ENDIF 
         ENDDO  C  t C  Set the text color. C  a"         FG = INDEX(ATTR,'FG:') + 3         FGC = NCOLRe=         DO WHILE (ATTR(FG:FG+2).NE.SCOLR(FGC) .AND. FGC.GE.1)              FGC = FGC - 1 
         ENDDO          IF (FGC .EQ. 0) FGC = 5 "         BG = INDEX(ATTR,'BG:') + 3         BGC = NCOLR =         DO WHILE (ATTR(BG:BG+2).NE.SCOLR(BGC) .AND. BGC.GE.1)              BGC = BGC - 1b
         ENDDO          IF (BGC .EQ. 0) BGC = 1 B         WRITE (6,600) ESC, BGCOLR(BGC,TERM)//';'//FGCOLR(FGC,TERM)         VDT_CHAR_ATT = 0.          RETURN C    C  FORMAT statement. C   "   600   FORMAT('+',A1,'[',A,'m',$)         END 