.         FUNCTION VDT_CURSOR(ACTION,ROW,COLUMN) C 5 C                                       Henry Baragar 3 C                                       TRIUMF, UBC 2 C                                       June, 1984 C * C  reqd. KOSTL: routines - READKEY, LENSIG C I C======================================================================== I C=                                                                      = I C= VDT_CURSOR                                                           = I C=                                                                      = I C= This routine moves the cursor about on the screen, using the         = I C= terminal hardware to do the moving.                                  = I C=                                                                      = I C= INPUT:                                                               = I C=      ACTION  (Ch*(*)) - a character string indicating how the        = I C=              cursor is to be moved -- more than one action may       =I C=              be specified; the actions are:                          = I C=                      '<'             - move cursor left one space    = I C=                      '>'             - move cursor right one space   = I C=                      '^'             - move cursor up one line       = I C=                      'v'             - move cursor down one line     = I C=                      '^+'            - same as '^' but scroll down   = I C=                                        if at top of screen           = I C=                      'v+'            - same as 'v' but scroll up     = I C=                                        if at bottom of screen        = I C=                      'BOL'           - move cursor to beginning of   = I C=                                        line                          = I C=                      'EOL'           - move cursor to end of line    = I C=                      'HOM'           - move cursor to home position  = I C=                      'MOV'           - move the cursor LINE lines    =I C=                                        & COLUMN columns from its     =I C=                                        current location (-ve means   = I C=                                        move up or to the left)       = I C=                      'POS'           - move cursor to position       = I C=                                        indicated by LINE & COLUMN    = I C=                      'REP'           - report the position of the    =I C=                                        cursor                        = I C=      ROW, COLUMN  (I*4)  [optional] - the row and column that the    = I C=              cursor is to be positioned at if 'POS' is selected in   = I C=              ACTION; or the number of lines and columns that are to  = I C=              move from the current position if 'MOV' is specified.   = I C=                                                                      = I C= OUTPUT:                                                              =I C=      VDT_CURSOR - always returns 0.0.                                =TI C=      ROW, COLUMN  (I*4) - are returned with the current position     =GI C=              of the cursor if 'REP' is specified in ACTION.          = I C=                                                                      =(I C= EXAMPLES:                                                            =(I C=      DUMMY = VDT_CURSOR ('^ ^ ^')    !move cursor up 3 lines;        = I C=      CALL VDT_CURSOR ('^;^.^')       !same as previous example;      = I C=      CALL VDT_CURSOR ('HOM v v v')   !move cursor to beginning of    =,I C=                                      !...of third line;              = I C=      CALL VDT_CURSOR ('POS',3,1)     !same as previous example;      =UI C=                                                                      = I C========================================================================  C    C  N         IMPLICIT INTEGER (A-Z)         CHARACTER*1 ESC,          PARAMETER (ESC=CHAR(27))         CHARACTER*5 NULLD         PARAMETER (NULL=CHAR(0)//CHAR(0)//CHAR(0)//CHAR(0)//CHAR(0))         CHARACTER*5 SEPS"         PARAMETER (SEPS = ' .,;:')>         PARAMETER (NACTS=12, PREMOV=9, MOV=10, POS=11, REP=12)!         CHARACTER*3 ACTS(NACTS) / F      +          '<  ',   '>  ',   '^  ',   'v  ',   '^+ ',   'v+ ',   C      +          'BOL',   'EOL',   'HOM',   'MOV',   'POS',   'REP'/ %         CHARACTER*5 HACTS(PREMOV,1) / F      +          '[1D  ', '[1C  ', '[1A  ', '[1B  ', 'M    ', 'D    ', +      +          '[132D', '[132C', '[1;1H'/           CHARACTER*(*) ACTION         INTEGER TERM /1/%         CHARACTER*1 INP_KEY, READ_KEYt         LENA = LEN(ACTION)         PTR = 1           DO WHILE (PTR .LE. LENA)?             DO WHILE (INDEX(SEPS,ACTION(PTR:PTR)).NE.0  .AND.          +              PTR.LE.LENA)                 PTR = PTR + 1              ENDDO              BOA = PTRa?             DO WHILE (INDEX(SEPS,ACTION(PTR:PTR)).EQ.0  .AND.  r       +              PTR.LE.LENA)                 PTR = PTR + 1              ENDDOh             EOA = PTR - 1              IACTS = 1 <             DOWHILE (ACTION(BOA:EOA).NE.ACTS(IACTS)  .AND.  $      +               IACTS.LE.NACTS)!                 IACTS = IACTS + 1c             ENDDO $             IF (IACTS .LT. MOV) THEN1                 LENH = LENSIG (HACTS(IACTS,TERM))v>                 WRITE (6,60) ESC // HACTS(IACTS,TERM) (1:LENH)    60           FORMAT('+',A,$)a)             ELSE IF (IACTS .EQ. MOV) THEN                   GOTO  (110),TERM%   110           IF (ROW .LT. 0) THEN  9                     WRITE (6,116) ESC, MOD(-ROW,100), 'A' )                 ELSE IF (ROW .GT. 0) THEN 8                     WRITE (6,116) ESC, MOD(ROW,100), 'B'                 ENDIFc'                 IF (COLUMN .LT. 0) THEN =                     WRITE (6,116) ESC, MOD(-COLUMN,1000), 'D'=-                 ELSE IF (COLUMN .GT. 0) THEN r<                     WRITE (6,116) ESC, MOD(COLUMN,1000), 'C'                 ENDIFm                 GOTO 200,   116           FORMAT('+',A1,'[',I3.3,A1,$)   200           CONTINUE)             ELSE IF (IACTS .EQ. POS) THENN!                 GOTO  (210), TERM A   210           WRITE (6,216) ESC, MOD(ROW,100), MOD(COLUMN,1000)=                 GOTO 3005   216           FORMAT('+',A,'[',I2.2,';',I3.3,'H',$)    300           CONTINUE)             ELSE IF (IACTS .EQ. REP) THEN=!                 GOTO  (310), TERM (   310           WRITE (6,316) ESC//'[6n'7                 INP_KEY = READ_KEY('NOESC',' ',INP_KEY) 7                 INP_KEY = READ_KEY('NOESC',' ',INP_KEY)u7                 INP_KEY = READ_KEY('NOESC',' ',INP_KEY))                 ROW = 0d+                 DO WHILE (INP_KEY .NE. ';')r>                     ROW = 10*ROW + ICHAR(INP_KEY) - ICHAR('0');                     INP_KEY = READ_KEY('NOESC',' ',INP_KEY)                  ENDDOe                 COLUMN = 07                 INP_KEY = READ_KEY('NOESC',' ',INP_KEY) +                 DO WHILE (INP_KEY .NE. 'R') D                     COLUMN = 10*COLUMN + ICHAR(INP_KEY) - ICHAR('0');                     INP_KEY = READ_KEY('NOESC',' ',INP_KEY)                  ENDDO                  GOTO 400   316           FORMAT('+',A,$)t   400           CONTINUE             ENDIF'
         ENDDOe         RETURN         END 