          FUNCTION VDT_ERASE(WHAT) C 5 C                                       Henry Baragar 3 C                                       TRIUMF, UBC 2 C                                       June, 1984 C # C  reqd. KOSTL routines - VDTCURSOR  C I C======================================================================== I C=                                                                      = I C= VDT_ERASE                                                            = I C=                                                                      = I C= This routine erases part or all of a line or page on a VDT display   = I C= terminal.                                                            = I C=                                                                      = I C= INPUT:                                                               = I C=      WHAT  (Ch(*)) - a string that indicates what is to be erased,   = I C=              where:                                                  = I C=                      'LINE'  - means erase the line that the cursor  = I C=                                in on;                                = I C=                      'PAGE'  - means erase the screen;               = I C=              with the folling prefixes:                              = I C=                              - no prefix means erase the whole       = I C=                                object, without moving the cursor;    = I C=                      '-'     - means erase the part of the object    = I C=                                preceding the cursor;                 = I C=                      '+'     - means erase the part of the object    = I C=                                following the cursor;                 = I C=                      '0'     - means move the cursor to the start    = I C=                                of the object and then erase it;      = I C= OUTPUT:                                                              = I C=      VDT_ERASE always returns as 0.0.                                = I C=                                                                      = I C= NOTES:                                                               = I C=          1)  'LINE' & 'PAGE' may be abreviated to 'L' & 'P'          = I C=              respectively.                                           = I C=          2)  If more than one requests are made in a call, they      = I C=              must be separated with blanks (' ').                    = I C=                                                                      = I C= EXAMPLES:                                                            = I C=      DUMMY = VDT_ERASE('LINE')                                       = I C=                      !erase the whole line                           = I C=      CALL VDT_ERASE('L')                                             = I C=                      !same as previous example                       = I C=      DUMMY = VDT_CURSOR('POS',1,1) + VDT_ERASE('PAGE')               = I C=                      !erase the whole screen and leave the cursor    = I C=                      !...at the beging of the page                   = I C=      DUMMY = VDT_ERASE('P') + VDT_CURSOR('HOM')                      = I C=                      !same as previous example                       = I C=      CALL VDT_ERASE('0PAGE')                                         = I C=                      !same as previous example                       = I C=                                                                      = I C========================================================================  C    C  C            IMPLICIT INTEGER (A-Z)         CHARACTER*1 ESC           PARAMETER (ESC=CHAR(27))         PARAMETER (NWHATS = 8)#         CHARACTER*2 WHATS(NWHATS) / G      +          ' L',  '-L',  '+L',  '0L',  ' P',  '-P',  '+P',  '0P' / %         CHARACTER*3 WHATH(NWHATS,1) / G      +          '[2K', '[1K', '[0K', '[2K', '[2J', '[1J', '[0J', '[2J'/          CHARACTER*(*) WHAT         INTEGER TERM /1/ C   & C  * * *   M A I N   L O G I C   * * * C            DO PTR=1,NWHATS 4             IF (INDEX(' '//WHAT,WHATS(PTR)) .GT. 0) 3      +          WRITE(6,600) ESC // WHATH(PTR,TERM) 
         ENDDOu C  9# C  Reposition the cursor if needed.C C   ;         IF (INDEX(WHAT,'0L') .GT. 0) CALL VDT_CURSOR('BOL')=;         IF (INDEX(WHAT,'0P') .GT. 0) CALL VDT_CURSOR('HOM')          RETURN C    C  A FORMAT statement. C      600   FORMAT('+',A,$)          END 