-       SUBROUTINE WHATSYS(ISID,VERSION,ICPU,*) H C======================================================================CH C                                                                      CH C  WHATSYS                                         F.W. Jones, TRIUMF  CH C                                                                      CH C  Gets information about the host system.  Returns the system         CH C  identification register contents, the operating system version,     CH C   and the CPU type.                                                  CH C                                                                      CH C  Input:                                                              CH C                                                                      CH C    *   Error return line number (optional).                          CH C                                                                      CH C  Output:                                                             CH C                                                                      CH C    ISID:    System identification register contents.  This           CH C             uniquely identifies the host system.                     CH C             ISID = 20449263 (decimal) for the TRIUMF VAX 11/780.     CH C                                                                      CH C    VERSION: VAX/VMS Version identifier (CHARACTER*8).                CH C                                                                      CH C    ICPU:    CPU type.                                                CH C             ICPU = 1 for a VAX 780                                   CH C                    2 for a VAX 750                                   CH C                    3 for a VAX 730                                   CH C                                                                      CH C  Companion routine:  TRIUMF_VAX780 ... indicates whether the host    CH C  system is the TRIUMF VAX 11/780 or not.                             CH C                                                                      CH C======================================================================C C        CHARACTER*8 VERSION  C        INTEGER*4 ITEMLIST(4)        INTEGER*2 LENCOD(2) (       EQUIVALENCE(ITEMLIST(1),LENCOD(1)) C %       INTEGER*4 SYS$GETSYI,SYS$WAITFR  C = C==Item codes: from macro $SYIDEF (not included in FORSYSDEF) !       INTEGER*2 SYI$_SID/'0201'X/ %       INTEGER*2 SYI$_VERSION/'0100'X/ !       INTEGER*2 SYI$_CPU/'0200'X/  C / C==Get system identification register contents:        LENCOD(1)=4        LENCOD(2)=SYI$_SID       ITEMLIST(2)=%LOC(ISID)       ITEMLIST(3)=%LOC(IDUM)       ITEMLIST(4)=0 &       ISTAT=SYS$GETSYI(,,,ITEMLIST,,,)       IF(.NOT.ISTAT)GO TO 999  C  C==Get system version:       LENCOD(1)=8        LENCOD(2)=SYI$_VERSION       ITEMLIST(2)=%LOC(VERSION)         ITEMLIST(3)=%LOC(LVERSION)       ITEMLIST(4)=0 &       ISTAT=SYS$GETSYI(,,,ITEMLIST,,,)       IF(.NOT.ISTAT)GO TO 999  C  C==Get CPU type:       LENCOD(1)=4        LENCOD(2)=SYI$_CPU       ITEMLIST(2)=%LOC(ICPU)       ITEMLIST(3)=%LOC(IDUM)       ITEMLIST(4)=0 &       ISTAT=SYS$GETSYI(,,,ITEMLIST,,,)       IF(.NOT.ISTAT)GO TO 999  C        RETURN C  C==Error return  999   RETURN 1 C 	       END       %       SUBROUTINE TRIUMF_VAX780(TV780) H C======================================================================CH C                                                                      CH C  TRIUMF_VAX780                                   F.W. Jones, TRIUMF  CH C                                                                      CH C  Calls WHATSYS to find out whether the host system is the            CH C  TRIUMF VAX 11/780 or not.                                           CH C                                                                      CH C  Input:  none.                                                       CH C                                                                      CH C  Output:                                                             CH C                                                                      CH C    TV780:  (LOGICAL)  Returned as .TRUE. if and only if the host     CH C                       system is the TRIUMF VAX 11/780.               CH C                                                                      CH C======================================================================C Ct       LOGICAL TV780t Cc       CHARACTER*8 VERSIONe Ce%       CALL WHATSYS(ISID,VERSION,ICPU)h       TV780=(ISID.EQ.20449263)       RETURN	       END 