;       SUBROUTINE WINDOW_CLIP(XP,YP,X,Y,XMIN,XMAX,YMIN,YMAX, /      *                       XDRAW,YDRAW,NDRAW)  C # C  reqd. KOSTL: routines - SEGMENTX  C B C=================================================================B C=================================================================B C==                                                             ==B C==   WINDOW_CLIP: clips the line segment (XP,YP)-->(X,Y), using==B C==        the plot window range:                               ==B C==        XMIN <= x <= XMAX; YMIN <= y <= YMAX.                ==B C==        If the line segment (XP,YP)-->(X,Y) is totally       ==B C==        outside the window then NDRAW is set to 0 and        ==B C==        XDRAW & YDRAW are undefined.                         ==B C==        If (XP,YP) & (X,Y) are both outside the window, but  ==B C==        the segment (XP,YP)-->(X,Y) crosses the window, then ==B C==        NDRAW is set to 2 and the clipped line segment inside==B C==        the window is given by:                              ==B C==        (XDRAW(1),YDRAW(1)-->(XDRAW(2),YDRAW(2)).            ==B C==        If (XP,YP) & (X,Y) are both inside the window, then  ==B C==        there is no clipping and NDRAW is set to 1 and       ==B C==        (XDRAW(1),YDRAW(1)) is set to (X,Y).                 ==B C==        If (XP,YP) is inside and (X,Y) is outside the window ==B C==        then NDRAW is set to 1 and the clipped line segment  ==B C==        inside the window is given by:                       ==B C==        (XP,YP)-->(XDRAW(1),YDRAW(1)).                       ==B C==        If (XP,YP) is outside and (X,Y) is inside the window ==B C==        then NDRAW is set to 2 and the clipped line segment  ==B C==        is given by:                                         ==B C==        (XDRAW(1),YDRAW(1))-->(XDRAW(2),YDRAW(2)), where     ==B C==        (XDRAW(2),YDRAW(2)) equals (X,Y).                    ==B C==                                                             ==B C==   Written by Arthur Haynes, TRIUMF U.B.C., July 6, 1981.    ==B C==                                                             ==B C==   Input  Parameters: XP,YP,X,Y,XMIN,XMAX,YMIN,YMAX (R*4)    ==B C==                                                             ==B C==   Output Parameters: XDRAW(2),YDRAW(2) (R*4); NDRAW (I*4).  ==B C==                                                             ==B C=================================================================B C=================================================================9       REAL*4 XDRAW(2),YDRAW(2),SDRAW(2),XC(4),YC(4),SC(4) 2       LOGICAL SEGMENT_CROSS,LCROSS(4),XYPOUT,XYOUT>       XYOUT=(X-XMIN)*(XMAX-X).LT.0..OR.(Y-YMIN)*(YMAX-Y).LT.0.C       XYPOUT=(XP-XMIN)*(XMAX-XP).LT.0..OR.(YP-YMIN)*(YMAX-YP).LT.0. !       IF(XYPOUT.OR.XYOUT)GO TO 10 B C=================================================================B C==   (X,Y) and (XP,YP) are in the plot window.                 ==B C==   Therefore there is no need for clipping.                  ==B C=================================================================
       NDRAW=1        XDRAW(1)=X       YDRAW(1)=Y       RETURNB C=================================================================B C==   Determine which segments or sides of the window perimeter ==B C==   are crossed by the line segment (XP,YP)-->(X,Y).          ==B C==   LCROSS(I) = .TRUE. if the I'th segment is crossed.        ==B C==   (XC(I),YC(I)) is the point at which the I'th segment is   ==B C==                 crossed.                                    ==B C==   SC(I)         is the relative distance along the segment  ==B C==                 (XP,YP)-->(X,Y) at which the I'th window    ==B C==                 segment crosses it, i.e. the window segment ==B C==                 crosses the segment (XP,YP)-->(X,Y) at the  ==B C==                 point given by: (XC(I),YC(I)) =             ==B C==                 (XP,YP) + SC(I) * (X-XP,Y-YP).              ==B C=================================================================< 10    LCROSS(1)=SEGMENT_CROSS(XP,YP,X,Y,XMIN,YMIN,XMAX,YMIN,0      *                        XC(1),YC(1),SC(1))<       LCROSS(2)=SEGMENT_CROSS(XP,YP,X,Y,XMAX,YMIN,XMAX,YMAX,0      *                        XC(2),YC(2),SC(2))<       LCROSS(3)=SEGMENT_CROSS(XP,YP,X,Y,XMAX,YMAX,XMIN,YMAX,0      *                        XC(3),YC(3),SC(3))<       LCROSS(4)=SEGMENT_CROSS(XP,YP,X,Y,XMIN,YMAX,XMIN,YMIN,0      *                        XC(4),YC(4),SC(4))B C=================================================================B C==   Store the crossing points in XDRAW and YDRAW.             ==B C=================================================================
       NDRAW=0))       DENOM=ABS(XMAX-XMIN)+ABS(YMAX-YMIN)e       IF(DENOM.EQ.0.)DENOM=1.a0       DISTANCE_RATIO=(ABS(X-XP)+ABS(Y-YP))/DENOM       DO 200 I=1,4!       IF(.NOT.LCROSS(I))GO TO 200        IF(NDRAW.EQ.0)GO TO 100oE       IF(ABS(SDRAW(NDRAW)-SC(I))*DISTANCE_RATIO .LE. 0.0001)GO TO 200t 100   NDRAW=NDRAW+1R       XDRAW(NDRAW)=XC(I)       YDRAW(NDRAW)=YC(I)       SDRAW(NDRAW)=SC(I)       IF(NDRAW.EQ.2)GO TO 400  200   CONTINUEB C=================================================================B C==   NDRAW = 0 implies that the line segment (XP,YP)-->(X,Y) is==B C==   totally outside the plot window.                          ==B C=================================================================       IF(NDRAW.EQ.0)RETURN       IF(NDRAW.EQ.2)GO TO 400 B C=================================================================B C==   NDRAW = 1 implies only one crossing of the line segment.  ==B C=================================================================#       IF(XYOUT.AND.XYPOUT)GO TO 310aB C=================================================================B C==   NDRAW = 1, and                                            ==B C==   one of (X,Y) or (XP,YP) is inside the plot window.        ==B C==   If (X,Y) is outside then (XP,YP) is inside; so return.    ==B C=================================================================       IF(XYOUT)RETURN B C=================================================================B C==   NDRAW = 1, and                                            ==B C==   (X,Y) is inside and (XP,YP) is outside the plot window.   ==B C=================================================================
       NDRAW=2        XDRAW(2)=X       YDRAW(2)=Y       RETURNB C=================================================================B C==   NDRAW = 1:                                                ==B C==   Both (X,Y) and (XP,YP) are outside the window.            ==B C==   Therefore since there is only one crossing point, it must ==B C==   be at a corner of the plot window.                        ==B C=================================================================
 310   NDRAW=2)       XDRAW(2)=XDRAW(1)-       YDRAW(2)=YDRAW(1)U       SDRAW(2)=SDRAW(1)=       RETURNB C=================================================================B C==   NDRAW = 2:                                                ==B C==   There are 2 crossing points.                              ==B C=================================================================' 400   IF(SDRAW(1).LE.SDRAW(2))GO TO 410E       XD1=XDRAW(1)       YD1=YDRAW(1)       XDRAW(1)=XDRAW(2)=       YDRAW(1)=YDRAW(2)h       XDRAW(2)=XD1       YDRAW(2)=YD1 410   IF(XYPOUT)RETURN
       NDRAW=1        XDRAW(1)=XDRAW(2)        YDRAW(1)=YDRAW(2)I       RETURN       END      i  