9       SUBROUTINE WRITE_BITMAP_HPJET(IOUT,ARRAY,ND1,N1,N2,       #  SUPPRESS_NULLS,LASER,*) H C======================================================================CH C                                                                      CH C  WRITE_BITMAP_HPJET                              F.W. Jones, TRIUMF  CH C                                                                      CH C  *** NOTE: this routine must be compiled with /NOOPTIMIZE ***        CH C                                                                      CH C  Analogue to WRITE_BITMAP_PX.                                        CH C  Writes the Printronix bitmap stored in ARRAY to unit IOUT           CH C  in HP Laserjet or HP Thinkjet format.                               CH C                                                                      CH C  By default, the bitmap is stored in ARRAY in Printronix format,     CH C  with 6 significant bits per byte.  Since the HP printers use        CH C  8 significant bits per byte, each group of 4 bytes from ARRAY       CH C  is compressed into 3 bytes for output to the plot file.             CH C                                                                      CH C  The bitmap in ARRAY consists of N2 lines of N1 bytes, where N1      CH C  is at most 188.  The maximum line length is 188*6=1128 dots.        CH C                                                                      CH C  If SUPPRESS_NULLS is set to .TRUE., any blank dot lines at the      CH C  end of the bitmap will not be sent.                                 CH C                                                                      CH C  Modified June 9/86 by F.W. Jones:  The plot file is now written     CH C  using the IOFAST routines, improving the speed by a factor of 2.    CH C                                                                      CH C  Modified Nov 19/86 by F.W. Jones:  Option added to make bitmap      CH C    file for TeX inclusion, by setting LASER=2.                       CH C  Modified Dec 15/86 by F.W. Jones:  Entry point HPJET_DENSITY added  CH C    to manually set the density (HP Laserjet only).                   CH C  Modified Mar 25/87 by F.W. Jones:  records written to the plot      CH C    file are now variable in length and are automatically truncated   CH C    to remove trailing zeros.  This has been done to reduce the high  CH C    overheads in file space and processing time.  In addition, the    CH C    suppression of trailing blank lines has been made mandatory, and  CH C    the flag SUPPRESS_NULLS is ignored.                               CH C  Modified Jan 19/88 by F. Jones:  This routine has been re-written   CH C    to reflect a change in internal bitmap storage from Printronix    CH C    format (6 significant bits per byte) to HP Laserjet format        CH C    (8 significant bits per byte).                                    CH C                                                                      CH C======================================================================C       LOGICAL*1 ARRAY(ND1,N2)        LOGICAL SUPPRESS_NULLS C :       COMMON /HARDCOPY_RANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH27       DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./  C        CHARACTER*1 ESC/27/  C  C Output buffer:       LOGICAL*1 LINE(188)        CHARACTER*188 CLINE        EQUIVALENCE(LINE,CLINE)  C        CHARACTER*3 CNPUT        CHARACTER*255 FNAME        CHARACTER*(*) DENS_IN        CHARACTER*3 DENS"       LOGICAL AUTO_DENSITY/.TRUE./ C  C Open the unit for IOFAST:        FNAME=' ' #       INQUIRE(UNIT=IOUT,NAME=FNAME)        CLOSE(UNIT=IOUT)"       CALL FIND_UNIT_IOFAST(IOUTF)?       ISTAT=LOK_IOFAST$OPENA(IOUTF,FNAME)      !open for append        IF(.NOT.ISTAT)THEN         NCF=LENSIG(FNAME) >         WRITE(*,*)'Error opening ',FNAME(1:NCF),' for IOFAST.'         WRITE(*,*)'Unit',IOUTF         CALL PUT_SYSMSG(ISTAT)         RETURN 1       ENDIF  C  C Find extent of bitmap data:        IBITS=INT(YMAXH2)+1        JBITS=INT(XMAXH2)+1        IEND_MAX=IBITS/8.       IF(MOD(IBITS,8).NE.0)IEND_MAX=IEND_MAX+1?       IEND_MAX=MIN(IEND_MAX,188)      !To avoid buffer overflow        JEND_MAX=MIN(JBITS,N2)       DO JEND=JEND_MAX,1,-1          DO I=1,IEND_MAX (           IF(ARRAY(I,JEND).NE.0)GO TO 70
         ENDDO        ENDDO        JEND=1 C = C Reset, set density, set left margin, start raster graphics:  70    IF(AUTO_DENSITY)THEN         DENS='100'"         IF(IBITS.GT.750)DENS='150'#         IF(IBITS.GT.1125)DENS='300'        ENDIF        IF(LASER.EQ.1)THENF            ISTAT=LOK_IOFAST$PUT(IOUTF,ESC//'E'//ESC//'*t'//DENS//'R'//8      #                         ESC//'&a4C'//ESC//'*r1A')H       ELSE IF(LASER.EQ.2)THEN    !TeX output -- no reset, no positioningH            ISTAT=LOK_IOFAST$PUT(IOUTF,ESC//'*t'//DENS//'R'//ESC//'*r1A') C Thinkjet: 
       ELSE          IF(IBITS.LE.640)THEN @             ISTAT=LOK_IOFAST$PUT(IOUTF,ESC//'E'//ESC//'*r640S'//*      #                         ESC//'*rA')
          ELSE A             ISTAT=LOK_IOFAST$PUT(IOUTF,ESC//'E'//ESC//'*r1280S'// *      #                         ESC//'*rA')          ENDIF       ENDIF        IF(.NOT.ISTAT)GO TO 999  C        DO J=1,JEND 0 C Find number of bytes to get from current line:         DO IEND=IEND_MAX,1,-1 (           IF(ARRAY(IEND,J).NE.0)GO TO 80
         ENDDO          IEND=0 80      NPUT=IEND          IF(NPUT.EQ.0)GO TO 120:         WRITE(CNPUT,1000)NPUT      !For raster data header 1000    FORMAT(I3.3) C          DO I=1,NPUT            LINE(I)=ARRAY(I,J)
         ENDDO  C  C Send the output buffer:  120     IF(NPUT.GT.0)THEN <           ISTAT=LOK_IOFAST$PUT(IOUTF,ESC//'*b'//CNPUT//'W'//-      #                         CLINE(1:NPUT))          ELSE3           ISTAT=LOK_IOFAST$PUT(IOUTF,ESC//'*b000W') 
         ENDIF          IF(.NOT.ISTAT)GO TO 999        ENDDO  C " C End raster graphics, page eject.,       ISTAT=LOK_IOFAST$PUT(IOUTF,ESC//'*rB')       IF(.NOT.ISTAT)GO TO 999 C       IF(LASER.EQ.2)THEN      !work around line-eating bug in DVIHP .         ISTAT=LOK_IOFAST$PUT(IOUTF,ESC//'*rB')         IF(.NOT.ISTAT)GO TO 999        ENDIF #       ISTAT=LOK_IOFAST$CLOSE(IOUTF) =       OPEN(UNIT=IOUT,FILE=FNAME,STATUS='OLD',ACCESS='APPEND')        RETURN C  C Error during write: 9 999   WRITE(*,*)'IOFAST error during write on unit',IOUTF        CALL PUT_SYSMSG(ISTAT)#       ISTAT=LOK_IOFAST$CLOSE(IOUTF)        RETURN 1 C   6 C Entry point to pre-set and inquire about the density"       ENTRY HPJET_DENSITY(DENS_IN) C F       IF(DENS_IN.EQ.'100'.OR.DENS_IN.EQ.'150'.OR.DENS_IN.EQ.'300')THEN         AUTO_DENSITY=.FALSE.         DENS=DENS_IN#       ELSE IF(DENS_IN.EQ.'AUT')THEN          AUTO_DENSITY=.TRUE. 9       ELSE IF(DENS_IN.EQ.'INQ')THEN      !inquire density          IF(AUTO_DENSITY)THEN           DENS_IN='AUT'          ELSE           DENS_IN=DENS
         ENDIF        ENDIF        RETURN	       END 