9       SUBROUTINE WRITE_BITMAP_LA100(IOUT,ARRAY,ND1,N1,N2,       #  SUPPRESS_NULLS,*) H C======================================================================CH C                                                                      CH C  WRITE_BITMAP_LA100                              F.W. Jones, TRIUMF  CH C                                                                      CH C  *** NOTE: this routine must be compiled with /NOOPTIMIZE ***        CH C                                                                      CH C  Analogue to WRITE_BITMAP_PX.                                        CH C  Writes the Printronix bitmap stored in ARRAY to unit IOUT           CH C  in DEC LA100 graphics format.                                       CH C                                                                      CH C  By default, the bitmap is stored in ARRAY in Printronix format,     CH C  with 6 significant bits per byte.                                   CH C                                                                      CH C  The bitmap in ARRAY consists of N2 lines of N1 bytes, where N1      CH C  is at most 188.  The maximum line length is 188*6=1128 dots.        CH C                                                                      CH C  If SUPPRESS_NULLS is set to .TRUE., any blank dot lines at the      CH C  end of the bitmap will not be sent.                                 CH C                                                                      CH C  132 dots/inch * 8" = 1056 = 176 Printronix bytes                    CH C                       1056 = 132 Laserjet bytes                      CH C                                                                      CH C  Modified Jan 19/88 by F.W. Jones:  this routine has been modified   CH C  to reflect a change in internal bitmap storage from Printronix      CH C  format (6 significant bits per byte) to HP Laserjet format          CH C  (8 significant bits per byte).  Also, trailing lines of zeros are   CH C  now suppressed by default and flag SUPPRESS_NULLS is ignored.       CH C                                                                      CH C======================================================================C       LOGICAL*1 ARRAY(ND1,N2)        LOGICAL SUPPRESS_NULLS C :       COMMON /HARDCOPY_RANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH27       DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./  C         CHARACTER*1 ESC/27/,FF/12/ C  C Output buffer:       LOGICAL*1 LINE(1056) C  C Find end of data:        IBITS=INT(YMAXH2)+1        JBITS=INT(XMAXH2)+1        IEND=IBITS/8&       IF(MOD(IBITS,8).NE.0)IEND=IEND+17       IEND=MIN(IEND,132)      !To avoid buffer overflow  C        JEND_MAX=JBITS       DO JEND=JEND_MAX,1,-1          DO I=1,IEND (           IF(ARRAY(I,JEND).NE.0)GO TO 70
         ENDDO        ENDDO        JEND=1 C  C Enter LA100 graphics mode:( 70    WRITE(IOUT,2000,ERR=999)ESC//'P1q' 2000  FORMAT(1X,A) C ,       NCOL=8*IEND    !# of columns generated       DO ICOL=1,NCOL5         LINE(ICOL)='77'O      !Offset the line buffer        ENDDO  C 5       IADD=1       !This is 2**wire# for accumulation        DO J=1,JEND          DO I=1,IEND !           ITEST=LSWAP(ARRAY(I,J)) :           ICOLBASE=1+(I-1)*8      !Base for next 8 columns           DO IBIT=0,7 !             IF(BTEST(ITEST,IBIT)) :      #        LINE(ICOLBASE+IBIT)=LINE(ICOLBASE+IBIT)+IADD           ENDDO 
         ENDDO          IADD=2*IADD G         IF(IADD.EQ.64.OR.J.EQ.JEND)THEN   !Time to write out the buffer            IADD=1:           WRITE(IOUT,1000,ERR=999)(LINE(ICOL),ICOL=1,NCOL)#           WRITE(IOUT,*,ERR=999)'$-'            DO ICOL=1,NCOL9             LINE(ICOL)='77'O      !Offset the line buffer            ENDDO 
         ENDIF        ENDDO  1000  FORMAT(1X,131A1) C End graphics mode, form feed*       WRITE(IOUT,2000,ERR=999)ESC//'\'//FF       RETURN  < 999   WRITE(*,*)'Error writing LA100 plot file on unit',IOUT       CALL PUT_FORMSG        RETURN 1	       END 