;       SUBROUTINE WRITE_BITMAP_PX_FAST(IOUT,ARRAY,ND1,N1,N2,       #  SUPPRESS_NULLS,*) H C======================================================================CH C                                                                      CH C  WRITE_BITMAP_PX_FAST                                                CH C                                                                      CH C  *** NOTE: this routine must be compiled with /NOOPTIMIZE ***        CH C                                                                      CH C  Writes the printronix bitmap stored in ARRAY(ND1,N1) to the FORTRAN CH C  unit IOUT in printronix format.  ARRAY contains N2 lines of N1      CH C  bytes which form a bit map image in printronix format with 6 bits   CH C  per byte. For the printronix N1 is a maximum of 131 which implies   CH C  a total of 786 dots per line (IY = 0 to 785).  The x-axis runs      CH C  vertically down the printronix page with IX ranging from 0 to N2-1. CH C  The y-axis runs horizontally across the page with IY ranging from   CH C  0 to N1*6-1. The origin of this coordinate system is at the top     CH C  left hand corner of the page, i.e. the 1'st bit (low order bit) of  CH C  ARRAY(1,1).  0 <= IX <= N2-1; 0 <= IY <= N1*6-1.  The dot location  CH C  (IX,IY) is represented in the array by the IMOD(IY,6)+1'th bit of   CH C  the array location ARRAY(IY/6+1,IX+1).                              CH C                                                                      CH C  Eg. (0,0) is the 1st bit of ARRAY(1,1), and (N2-1,N1*6-1) is the    CH C  6th bit of ARRAY(N1,N2).                                            CH C                                                                      CH C  If SUPPRESS_NULLS=.TRUE. then the blank dot lines at the end of     CH C  the bitmap will not be printed.                                     CH C                                                                      CH C   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.            CH C                                                                      CH C   Modified March 12/1986 by F. Jones for IOFAST output               CH C                                                                      CH C  Note that IOUT refers to an IOFAST unit # and not a FORTRAN unit    CH C  number. To write into a specific file the user must close this      CH C  file in the calling program, then call FIND_UNIT_IOFAST(IOUT) to    CH C  get an IOFAST unit number, and then open the file for IOFAST:       CH C    ISTAT=LOK_IOFAST$OPENR(IOUT,'FILENAME').                          CH C  The file FILENAME must originally have been type "FORTRAN           CH C  CARRIAGE CONTROL".                                                  CH C                                                                      CH C   Input  Parameters: IOUT (I*4); ARRAY(ND1,N2) (L*1);                CH C                      ND1,N1,N2 (I*4); SUPPRESS_NULLS (L*4).          CH C                                                                      CH C  Modified Jan 19/88 by F. Jones:  This routine has been re-written   CH C    to reflect a change in internal bitmap storage from Printronix    CH C    format (6 significant bits per byte) to HP Laserjet format        CH C    (8 significant bits per byte).  The functions LSWAP and MVBITS    CH C    are used to unpack groups of 3 bytes from the internal bitmap     CH C    into groups of 4 bytes to be written to the plot file.            CH C    Also, trailing zeros are now suppressed by default and the flag   CH C    SUPPRESS_NULLS is ignored.                                        CH C                                                                      CH C======================================================================C       LOGICAL*1 ARRAY(ND1,N2)        LOGICAL SUPPRESS_NULLS  :       COMMON /HARDCOPY_RANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH27       DATA XMINH2,XMAXH2,YMINH2,YMAXH2/0.,479.,0.,639./  C        LOGICAL*1 LINE(132)        CHARACTER*132 CHLINE       EQUIVALENCE (CHLINE,LINE)        LOGICAL*1 CTRL_E/Z05/   ? C Buffers for conversion from HP Laserjet to Printronix format:        INTEGER*4 IS,ID        LOGICAL*1 ISL(4),IDL(4) "       EQUIVALENCE(IS,ISL),(ID,IDL) C  C Bit swap function:       LOGICAL*1 LSWAP  C  C Find extent of bitmap data:        IBITS=INT(YMAXH2)+1        JBITS=INT(XMAXH2)+1        IEND_MAX=IBITS/8.       IF(MOD(IBITS,8).NE.0)IEND_MAX=IEND_MAX+1       IEND_MAX=MIN(IEND_MAX,99)        JEND_MAX=MIN(JBITS,N2)       DO JEND=JEND_MAX,1,-1          DO I=1,IEND_MAX (           IF(ARRAY(I,JEND).NE.0)GO TO 70
         ENDDO        ENDDO        JEND=1   70    DO J=1,JEND 9 C Find number of bytes (max 99) to get from current line:          DO IEND=IEND_MAX,1,-1 (           IF(ARRAY(IEND,J).NE.0)GO TO 80
         ENDDO          IEND=0; 80      NG3=IEND/3      !Number of groups of 3 bytes to get %         IF(MOD(IEND,3).NE.0)NG3=NG3+1          IF(NG3.EQ.0)GO TO 120  C 5 C Initialize base locations in input & output arrays:          ILOCI=1          ILOCO=1          IG3=1      !Group #  C < C Get next group of 3 bytes from bitmap, reversing bit order 100     DO I=1,3*           ISL(I)=LSWAP(ARRAY(ILOCI+I-1,J))
         ENDDO 2 C Expand the 3 bytes into 4 for Printronix format:          CALL MVBITS(IS,0,6,ID,0)          CALL MVBITS(IS,6,6,ID,8)"         CALL MVBITS(IS,12,6,ID,16)"         CALL MVBITS(IS,18,6,ID,24)) C Move the 4 bytes into the output buffer          DO I=1,4*           IF(IDL(I).LT.32)IDL(I)=IDL(I)+64            LINE(ILOCO+I-1)=IDL(I)
         ENDDO 0         IF(IG3.EQ.NG3)GO TO 120      !Last group C Update locations:          IG3=IG3+1          ILOCI=ILOCI+3          ILOCO=ILOCO+4          GO TO 100  C Send the output buffer:  120     ILAST=MIN(NG3*4+1,132)         LINE(ILAST)=CTRL_E7         ISTAT=LOK_IOFAST$PUT(IOUT,' '//CHLINE(1:ILAST))          IF(.NOT.ISTAT)THEND           WRITE(*,*)'IOFAST error writing PX plot file on unit',IOUT            CALL PUT_SYSMSG(ISTAT)           RETURN 1
         ENDIF        ENDDO        RETURN	       END 