1       SUBROUTINE YLM(L,M,THETA,PHI,EVEN,ODD,IERR)  C   " C     reqd. CERN: routines - ALEGF C G C====================================================================== G C==   Purpose: YLM returns the spherical harmonics given by the      == G C==            following expressions:                                == G C==                                                                  == G C==                                                                  == G C==        (+)                                                       == G C==       Y   (theta,phi) = A * B * cos(m * phi)        (even)       == G C==        l,m                                                       == G C==                                                                  == G C==        (-)                                                       == G C==       Y   (theta,phi) = A * B * sin(m * phi)        (odd)        == G C==        l,m                                                       == G C==                                                                  == G C==                                                                  == G C==       where                                                      == G C==             A = SQRT(((2l+1)/(2*pi))*(l-m)!/(l+m)!)              == G C==                                                                  == G C==                  m                                               == G C==             B = P (cos(theta))      (P is the associated         == G C==                  l                   Legendre polynomial)        == G C==                                                                  == G C==            pi = 3.141593                                         == G C==                                                                  == G C==                                                                  == G C==   Caution:                                                       == G C==   -------                                                        == G C==                                                                  == G C==   Different authors employ different normalization factors for   == G C==   spherical harmonics.  Thus, the user is cautioned that a       == G C==   value of 2 * pi is used by YLM in the normalization factor     == G C==   (term A above) rather than the value 4 * pi used by some.      == G C==                                                                  == G C==   --------------------                                           == G C==                                                                  == G C==   Written by Alan Carruthers, TRIUMF, U.B.C., July 15, 1982.     == G C==                                                                  == G C==   Linkage:  YLM uses the ALEGF routine from the CERN library.    == G C==             Consequently, YLM must be linked with                == G C==                     _DRA0:[CERN]LIBRARY.OLB                      == G C==             to obtain an executable image.                       == G C==                                                                  == G C==   Input  Parameters:  L, M             (INTEGER*4)               == G C==                       THETA, PHI       (REAL*4)                  == G C==                                                                  == G C==   Output Parameters:  EVEN, ODD        (REAL*4)                  == G C==                       IERR             (INTEGER*4)               == G C==                                                                  == G C==                                                                  == G C==   Parameters:                                                    == G C==   ----------                                                     == G C==                                                                  == G C==   L      : Denotes L'th harmonic.  L > = 0                       == G C==                                                                  == G C==   M      : Denotes M'th mode.      0 < = M < = L                 == G C==                                                                  == G C==   THETA, : Spherical coordinates                                 ===G C==   PHI                                                            ==oG C==                                                                  == G C==   EVEN   : Returned function value corresponding to (even)       == G C==            expression above.                                     == G C==                                                                  == G C==   ODD    : Returned function value corresponding to (odd)        ==hG C==            expression above.                                     == G C==                                                                  == G C==   IERR   : Error code returned by YLM.                           == G C==            = 0    -- no error                                    ==hG C==            = 1    -- L < 0                                       == G C==            = 2    -- M < 0                                       == G C==            = 3    -- M > L                                       == G C==                                                                  == G C==            Note: When IERR > 0, EVEN and ODD are returned as 0.  ==)G C==                                                                  == G C==                                                                  == G C==   Accuracy:                                                      == G C==   --------                                                       ==nG C==                                                                  == G C==   EVEN and ODD have six significant digits of accuracy.          == G C==                                                                  == G C==   This assertion is based on a comparison of YLM's returned      == G C==   values with values obtained from explicit formulae for L = 2   == G C==   (e.g. the spherical harmonics in Eugen Merzbacher, Quantum     == G C==   Mechanics, John Wiley & Sons, 1961, p. 180).                   == G C======================================================================a Ca       PARAMETER (PI = 3.141593)e       EVEN = 0.        ODD = 0. CaG C======================================================================mG C==   Check for valid L and M                                        ==pG C======================================================================        IF(L .LT. 0) GO TO 500       IF(M .LT. 0) GO TO 510       IF(M .GT. L) GO TO 520 C G C====================================================================== G C==   L and M are valid.   Proceed ...                               == G C====================================================================== %       IERR = 0   ! no error conditionF       COS_THETA = COS(THETA) C G C====================================================================== G C==   First calculate (L - M)! / (L + M)!                            == G C======================================================================        TEMP = 1. 0       IF(M .EQ. 0) GO TO 200     !   L! / L! = 18       IF(L .EQ. 0) GO TO 200     !   (0+0)! / (0+0)! = 1 CE       DO 40 I = L-M+1,L+M           TEMP = TEMP * I  40   CONTINUE       TEMP = 1. / TEMP C   200  CONTINUE C G C======================================================================tG C==   Now continue with remaining terms in expression                == G C====================================================================== -       TEMP = SQRT(((2.*L+1.)/(2.*PI))*TEMP) * )      >             ALEGF(L,M,COS_THETA,0)  C 2       EVEN = TEMP * COS(M * PHI)   ! even function C 1       ODD  = TEMP * SIN(M * PHI)   ! odd function=       RETURN C G C====================================================================== G C==   Error!  L < 0                                                  ==tG C======================================================================   500  IERR = 1       RETURN C G C====================================================================== G C==   Error!  M < 0                                                  == G C======================================================================   510  IERR = 2       RETURN C G C====================================================================== G C==   Error!  M > L                                                  ==:G C======================================================================   520  IERR = 3       RETURN	       END 