+       SUBROUTINE ZETA_HEADER(HEADER,LENGTH)  C ' C     reqd. KOSTL: routines - GETUSRNAM  C  C J C=========================================================================J C==   ZETA_HEADER returns a header string (HEADER) for                  ==J C==   ZETA plots.  The header string contains the user name             ==J C==   followed by the current date and time. An example                 ==J C==   header string is "ALAN  30-FEB-1988 11:26".                       ==J C==                                                                     ==J C==   Input parameters: none                                            ==J C==                                                                     ==J C==   Output parameters:                                                ==J C==                                                                     ==J C==     HEADER  (LOGICAL*1 HEADER(50))                                  ==J C==       contains the header string with trailing blanks               ==J C==                                                                     ==J C==     LENGTH  (INTEGER*4 LENGTH)                                      ==J C==       contains the number of characters in HEADER, excluding        ==J C==       trailing blanks.                                              ==J C==                                                                     ==J C==                                                                     ==J C==   Written by Alan Carruthers, TRIUMF U.B.C., January 6, 1983        ==J C==                                                                     ==J C=========================================================================       IMPLICIT INTEGER(A-Z)        LOGICAL*1 HEADER(50), CH/       CHARACTER STR*50, GET_USERNAME*12, CHAR*1        EQUIVALENCE (CHAR, CH) C  C J C=========================================================================J C==   Get user name.                                                    ==J C=========================================================================       STR = GET_USERNAME(L)  C  C J C=========================================================================J C==   Get current date and time, placing date and time                  ==J C==   string after user name.                                           ==J C=========================================================================&       ISTAT = LIB$DATE_TIME(STR(L+3:)) C        LENGTH = L + 19  C  C J C=========================================================================J C==   Transfer character string STR to HEADER.                          ==J C=========================================================================       DO 20 I = 1, LENGTH            CHAR = STR(I:I)            HEADER(I) = CH  20   CONTINUE       IF(LENGTH .LT. 50) THEN ( C        Place trailing blanks in HEADER          CHAR = ' '           DO 30 I = LENGTH+1, 50              HEADER(I) = CH  30      CONTINUE           END IF  C        RETURN	       END 