( /*			File Transfer Protocol (FTP) Client **			for a WorldWideWeb browser ( **			=================================== **H **	A cache of control connections is kept (NOT ANYMORE -- IT WAS BROKEN) ** ** Note: Port allocation **C **	It is essential that the port is allocated by the system, rather ? **	than chosen in rotation by us (POLL_PORTS), or the following  **	problem occurs. **H **	It seems that an attempt by the server to connect to a port which hasC **	been used recently by a listen on the same socket, or by another E **	socket this or another process causes a hangup of (almost exactly) @ **	one minute. Therefore, we have to use a rotating port number.D **	The problem remains that if the application is run twice in quick9 **	succession, it will hang for what remains of a minute.  **
 ** Authors+ **	TBL	Tim Berners-lee <timbl@info.cern.ch> < **	DD	Denis DeLaRoca 310 825-4580 <CSP1DWD@mvs.oac.ucla.edu> ** History: @ **	 2 May 91	Written TBL, as a part of the WorldWideWeb project.C **	15 Jan 92	Bug fix: close() was used for NETCLOSE for control soc ; **	10 Feb 92	Retry if cached connection times out or breaks ( **	 8 Dec 92	Bug fix 921208 TBL after DD@ **	17 Dec 92	Anon FTP password now just WWWuser@ suggested by DD **			fails on princeton.edu! ** */   /* SOCKS mods by: %  * Ying-Da Lee, <ylee@syl.dl.nec.com>   * NEC Systems Laboratory !  * C&C Software Technology Center   */   ) #include "HTFTP.h"	/* Implemented here */    #define LINE_LENGTH 1024   #include "HTParse.h" #include "HTUtils.h" #include "tcp.h" #include "HTTCP.h" #include "HTAnchor.h"  #include "HTFile.h"  #include "HTChunk.h" #include "HTSort.h"  #include "HText.h"   #ifdef SOCKETSHR #include <signal.h>  #include <setjmp.h>  #endif /* SOCKETSHR, GEC */    #ifndef IPPORT_FTP #define IPPORT_FTP	21  #endif   #ifdef __STDC__  #include <stdlib.h>  #endif   /* #define TRACE 1 */    #ifndef NIL 
 #define NIL 0  #endif   #define SWP_HACK  ' /*		Hypertext object building machinery  */ #include "HTML.h"   7 #define PUTC(c) (*targetClass.put_character)(target, c) 4 #define PUTS(s) (*targetClass.put_string)(target, s)> #define START(e) (*targetClass.start_element)(target, e, 0, 0)4 #define END(e) (*targetClass.end_element)(target, e)6 #define END_TARGET (*targetClass.end_document)(target)/ #define FREE_TARGET (*targetClass.free)(target)  struct _HTStructured { 	CONST HTStructuredClass *	isa; 
 	/* ... */ };   struct _HTStream {       CONST HTStreamClass*	isa;        /* ... */  };   /*SWP -- Yukky Cool Kludge*/ int ftpKludge=0; extern int loading_length;   #ifdef SOCKS4 extern struct in_addr SOCKS_ftpsrv; /* in HTFTP.c */ #endif     /*	Module-Wide Variables **	--------------------- */N PRIVATE char    response_text[LINE_LENGTH+1];/* Last response from NewsHost */3 PRIVATE int control = -1;		/* Current connection */ C PRIVATE int	data_soc = -1;		/* Socket for data transfer =invalid */   D PRIVATE int     master_socket = -1;	/* Listening socket = invalid	*/B PRIVATE char	port_command[255];	/* Command for setting the port */     #define DATA_BUFFER_SIZE 2048 D PRIVATE char data_buffer[DATA_BUFFER_SIZE];		/* Input data buffer */! PRIVATE char * data_read_pointer; " PRIVATE char * data_write_pointer; #ifndef NotBSN extern int binary_ftp_mode;  PUBLIC char ftp_type[16]; ! #endif /* BSN, VMS FTP servers */     7 /*	Procedure: Read a character from the data connection 7 **	----------------------------------------------------  */. PRIVATE int interrupted_in_next_data_char = 0;" PRIVATE char next_data_char NOARGS { 
   int status; $   interrupted_in_next_data_char = 0;/   if (data_read_pointer >= data_write_pointer)       { @       status = NETREAD(data_soc, data_buffer, DATA_BUFFER_SIZE);#       if (status == HT_INTERRUPTED) *         interrupted_in_next_data_char = 1;       if (status <= 0)           return (char)-1;0       data_write_pointer = data_buffer + status;&       data_read_pointer = data_buffer;     }    return *data_read_pointer++; }     # /*	Execute Command and get Response # **	--------------------------------  **D **	See the state machine illustrated in RFC959, p57. This implementsE **	one command/reply sequence.  It also interprets lines which are to B **	be continued, which are marked with a "-" immediately after the **	status code.  **D **	Continuation then goes on until a line with a matching reply code **	an a space after it.  ** ** On entry,5 **	con	points to the connection which is established. ? **	cmd	points to a command, or is NIL to just get the response.  **0 **	The command is terminated with the CRLF pair. ** ** On exit, / **	returns:  The first digit of the reply type, , **		  or negative for communication failure. */ #ifdef __STDC__ ! PRIVATE int response (char * cmd)  #else  PRIVATE int response (cmd)     char * cmd;  #endif { /   int result;				/* Three-digit decimal code */ 
 #ifdef OLD!   int continuation_response = -1;  #endif
   int status;    char	continuation;   int multiline_response = 0;   
 char *ptr;
 int bytes;   !   if (!control || control == -1)       {        if(TRACE) A         fprintf(stderr, "FTP: No control connection set up!!\n");        return -99;      }       if (cmd)       {        if (TRACE)  )         fprintf(stderr, "  Tx: %s", cmd);        8       status = NETWRITE(control, cmd, (int)strlen(cmd));       if (status<0) 	         { %           if (TRACE) fprintf(stderr,  R                              "FTP: Error %d sending command: closing socket %d\n",.                              status, control);           NETCLOSE(control);           control = -1;            return status; 	}     }    P   /* Patch to be generally compatible with RFC 959 servers  -spok@cs.cmu.edu  */:   /* Multiline responses start with a number and a hyphen;E      end with same number and a space.  When it ends, the number must       be flush left. */   do       {        char *p = response_text;F       /* If nonzero, it's set to initial code of multiline response */       for (;;)	         {            int foo;@           /* This is set to 0 at the start of HTGetCharacter. */3           extern int interrupted_in_htgetcharacter; 
           +           foo = (*p++ = HTGetCharacter ()); ,           if (interrupted_in_htgetcharacter)
             {                if (TRACE)V                 fprintf (stderr, "FTP: Interrupted in HTGetCharacter, apparently.\n");!               NETCLOSE (control);                control = -1; $               return HT_INTERRUPTED;
             } 
                      if (foo == LF ||  .        /* if (((*p++=NEXT_CHAR) == '\n') || */2               (p == &response_text[LINE_LENGTH])) 
             { @               *p++=0;                 /* Terminate the string */               if (TRACE)  =                 fprintf(stderr, "    Rx: %s", response_text);   - 	      if (!strncmp(response_text,"150",3)) { ?                   if((ptr=strrchr(response_text,'(')) && *ptr){ ,                       bytes = atoi((ptr+1)); 		  } else {                           bytes=0;                   }  		if (bytes==0) {  			HTMeter(100); 			loading_length=(-1);  		}  		else { 			loading_length=bytes; 		}  	      }
 	      else {  		HTMeter(100);  	      }  D               sscanf(response_text, "%d%c", &result, &continuation);>               if (continuation == '-' && !multiline_response)                  { .                   multiline_response = result;                 } C               else if (multiline_response && continuation == ' ' && 6                        multiline_response == result &&2                        isdigit(response_text[0]))                  { F                   /* End of response (number must be flush on left) */)                   multiline_response = 0;                  }                break;"             } /* if end of line */
            #ifndef VMS            if (*(p-1) < 0)  #else "           if (*(p-1) == (char)EOF) #endif /* VMS, AV */
             {                if (TRACE)  C                 fprintf(stderr, "Error on rx: closing socket %d\n", !                         control);  #ifdef SWP_HACK  	      loading_length=(-1);  #endifM               strcpy (response_text, "000 *** TCP read error on response\n");                 NETCLOSE(control);               control = -1; 6               return -1;	/* End of file on response */
             } $         } /* Loop over characters */     }    while (multiline_response);    
 #ifdef OLD   do       {        char *p = response_text;       for(;;)          {              int foo;@           /* This is set to 0 at the start of HTGetCharacter. */3           extern int interrupted_in_htgetcharacter;   +           foo = (*p++ = HTGetCharacter ()); ,           if (interrupted_in_htgetcharacter)
             {                if (TRACE)V                 fprintf (stderr, "FTP: Interrupted in HTGetCharacter, apparently.\n");!               NETCLOSE (control);                control = -1; $               return HT_INTERRUPTED;
             }              if (foo == LF ||  0               p == &response_text[LINE_LENGTH]) 
             {                 char continuation;               int rv;   2               *p++=0;			/* Terminate the string */               if (TRACE)  =                 fprintf(stderr, "    Rx: %s", response_text); E               /* Clear out result ahead of time to see if we couldn't &                  read a real value. */               result = -1;I               rv = sscanf(response_text, "%d%c", &result, &continuation); <               /* Try just continuing if we couldn't pull outE                  a value for result and the response_text starts with                   whitespace. */ ,               if (rv < 2 && result == -1 && D                   (*response_text == ' ' || *response_text == '\t'))                 { C                   /* Dunno what to do here -- the code isn't really D                      set up to deal with continuation lines starting2                      with whitespace.  Testcase is/                      reports.adm.cs.cmu.edu. */                  } 4               else if (continuation_response == -1)                  { D                   if (continuation == '-')  /* start continuation */3                     continuation_response = result;                  }                else  #                 { 	/* continuing */ M                   if (continuation_response == result && continuation == ' ') ;                     continuation_response = -1;	/* ended */                  }	               break;	     "             } /* if end of line */
                      if (*(p-1) == EOF)  
             {                if (TRACE)  C                 fprintf(stderr, "Error on rx: closing socket %d\n", !                         control); M               strcpy (response_text, "000 *** TCP read error on response\n");                 NETCLOSE(control);               control = -1; 6               return -1;	/* End of file on response */
             } $         } /* Loop over characters */              } &   while (continuation_response != -1); #endif      if (result == 421)       {        if(TRACE) B         fprintf(stderr, "FTP: They close so we close socket %d\n",                 control);  #ifdef SWP_HACK        loading_length=(-1); #endif       NETCLOSE(control);       return -1;     }      if (result==550) { 	HTProgress(response_text);    }      return result/100; }     % /*	Get a valid connection to the host % **	----------------------------------  ** ** On entry,< **	arg	points to the name of the host in a hypertext address ** On exit,  **	returns	<0 if error **		socket number if success **A **	This routine takes care of managing timed-out connections, and = **	limiting the number of connections in use at any one time.  **? **	It ensures that all connections are logged in if they exist. 4 **	It ensures they have the port number transferred. */- PRIVATE int get_connection ARGS1 (char *,arg)  {    int status, con;      char *username = 0;    char *password = 0; "   char dummy[MAXHOSTNAMELEN+32];       if (!arg) .     return -1;		/* Bad if no name sepcified	*/
   if (!*arg)  1     return -1;		/* Bad if name had zero length	*/    
   if (TRACE)  2     fprintf(stderr, "FTP: Looking for %s\n", arg);      { ,     char *p1 = HTParse(arg, "", PARSE_HOST);3     char *p2 = strrchr(p1, '@');        /* user? */      char * pw;     if (p2)        {          username = p1;9         *p2=0;                            /* terminate */ =         p1 = p2+1;                        /* point to host */ #         pw = strchr(username, ':');          if (pw)            {              *pw++ = 0;             password = pw;           }        }   >     /* copy hostname into dummy URL, since username:password@ +        might have been part of original */  #     sprintf(dummy, "ftp://%s", p1);        if (!username)         free(p1);    }       con = -1; 8   status = HTDoConnect (dummy, "FTP", IPPORT_FTP, &con);      if (status < 0)      {        if (TRACE)	         { '           if (status == HT_INTERRUPTED)              fprintf (stderr,6                      "FTP: Interrupted on connect\n");           else             fprintf(stderr, H                     "FTP: Unable to connect to remote host for `%s'.\n",                     arg); 	         } #       if (status == HT_INTERRUPTED) /         HTProgress ("Connection interrupted.");        if (con != -1)	         {            NETCLOSE(con);           con = -1; 	         }        if (username)          free(username); 7       HTProgress ("Unable to connect to remote host."); '       return status;			/* Bad return */      }    
   if (TRACE)  I     fprintf(stderr, "FTP connected, assigning control socket %d\n", con); 3   control = con;			/* Current control connection */   3   /* Initialise buffering for contron connection */    HTInitInput (con);   7   /* Now we log in; Look up username, prompt for pw. */    { 3     int status = response (NIL);	/* Get greeting */   !     if (status == HT_INTERRUPTED)        {          if (TRACE)           fprintf (stderr,@                    "FTP: Interrupted at beginning of login.\n"); #ifdef SWP_HACK  	loading_length=(-1);  #endif/         HTProgress ("Connection interrupted.");          NETCLOSE(control);         control = -1;          return HT_INTERRUPTED;       }      if (status == 2)         {		/* Send username */         char * command;  #ifndef NotBSN /*H  * Try to figure out what type of server we deal with. Only MultiNet andH  * MadGoat seem to announce themself properly (IMHO). Just take a chance  * for UCX and TWG.   */ K /*        if (strstr (response_text, "UNIX")) strcpy (ftp_type, "UNIX"); */ N         if (strstr (response_text, "MultiNet")) strcpy (ftp_type, "MultiNet");L         if (strstr (response_text, "MadGoat")) strcpy (ftp_type, "MadGoat");D         if (strstr (response_text, "UCX")) strcpy (ftp_type, "UCX");W         if (strstr (response_text, "FTP Server (")) strcpy (ftp_type, "UCX"); /* BGT */ N         if (strstr (response_text, "CMU")) strcpy (ftp_type, "CMU"); /* BGT */ /*  * Pathway comment: A  * We have to assume... we have gone out of our way to make it so A  * nobody can tell when our server is available on a machine. Ie, @  * configurable greeeting. So if it is not them, it could be us.  */ K         if (strstr (response_text, "Wollongong")) strcpy (ftp_type, "TWG"); V         if (strstr (response_text, "FTP Service")) strcpy (ftp_type, "TWG"); /* BGT */ #endif /* VMS server, BSN */         if (username)            { =             command = (char*)malloc(10+strlen(username)+2+1); >             sprintf(command, "USER %s%c%c", username, CR, LF);           } 
         else             { (             command = (char*)malloc(25);;             sprintf(command, "USER anonymous%c%c", CR, LF);            } $         status = response (command);         free(command);%         if (status == HT_INTERRUPTED)            {              if (TRACE)               fprintf (stderr,E                        "FTP: Interrupted while sending username.\n");  #ifdef SWP_HACK  	    loading_length=(-1);  #endif3             HTProgress ("Connection interrupted.");	             NETCLOSE(control);             control = -1;e"             return HT_INTERRUPTED;           }=       }*     if (status == 3) n       {		/* Send password */         char * command;N         if (password)            {s=             command = (char*)malloc(10+strlen(password)+2+1);a>             sprintf(command, "PASS %s%c%c", password, CR, LF);           } 
         else m           {e   #ifndef ultrix)             char * user = getenv("USER");d #elsel1             char * user = (char *)getenv("USER");* #endif /* Ultrix, BSN */-             extern char *machine_with_domain;o-             char *host = machine_with_domain;              if (!user) l               user = "WWWuser";n@             /* If not fully qualified, suppress it as ftp.uu.net/                prefers a blank to a bad name */e.             if (!strchr(host, '.')) host = "";  9             command = (char*)malloc(20+strlen(host)+2+1);              sprintf(command,0 		    "PASS %s@%s%c%c", user ? user : "WWWuser", 		    host, CR, LF); /*@@*/L           }o$         status = response (command);         free(command);%         if (status == HT_INTERRUPTED)            {1             if (TRACE)               fprintf (stderr,E                        "FTP: Interrupted while sending password.\n");n #ifdef SWP_HACKy 	    loading_length=(-1);e #endif3             HTProgress ("Connection interrupted.");i             NETCLOSE(control);             control = -1;N"             return HT_INTERRUPTED;           }l       }c     if (username)        free(username);"          if (status == 3) e       {c         char temp[80];5         sprintf (temp, "ACCT noaccount%c%c", CR, LF); !         status = response (temp);j%         if (status == HT_INTERRUPTED)            {T             if (TRACE)               fprintf (stderr,A                        "FTP: Interrupted while sending ACCT.\n");  #ifdef SWP_HACK  	    loading_length=(-1);A #endif3             HTProgress ("Connection interrupted.");"             NETCLOSE(control);             control = -1;r"             return HT_INTERRUPTED;           }g       }      if (status != 2) t       {s         if (TRACE) t@           fprintf(stderr, "FTP: Login fail: %s", response_text); #ifdef SWP_HACKT 	loading_length=(-1);m #endif         NETCLOSE(control);         control = -1;t$         return -1;		/* Bad return */       }C     if (TRACE)  +       fprintf(stderr, "FTP: Logged in.\n");  #ifndef NOT_BSNa /*H  * Try to determine the ftp server type if not already done. TWG replies+  * with the present directory in VMS formate  */r       if (ftp_type[0] == '\0')G         if (strstr (response_text, "[") && strstr (response_text, "]"))-#           strcpy (ftp_type, "TWG");I /*,  * Try a remotehelp site to see if it is UCX  */         if (ftp_type[0] == '\0') {         char temp[80];0         sprintf (temp, "HELP site%c%c", CR, LF);!         status = response (temp);c%         if (status == HT_INTERRUPTED)	           {h             if (TRACE)               fprintf (stderr,G                        "FTP: Interrupted while sending remotehelp.\n");R3             HTProgress ("Connection interrupted.");_             NETCLOSE(control);             control = -1; "             return HT_INTERRUPTED;           } P         if (strstr (response_text, "214 Syntax: SITE <sp> Vms | ULtrix | UNix"))#           strcpy (ftp_type, "UCX");-       }- #endif /* BSN */   }-      if (TRACE)  /* BGT */ :     fprintf(stderr, "FTP Type: %s\n", ftp_type); /* BGT */  !   return con;			/* Good return */  } /* Scope of con */      " /*	Close Master (listening) socket" **	------------------------------- ** ** */ #ifdef __STDC__t& PRIVATE void close_master_socket(void) #else=" PRIVATE void close_master_socket() #endif {_
   if (TRACE)  F     fprintf(stderr, "FTP: Closing master socket %d\n", master_socket);   NETCLOSE(master_socket);   master_socket = -1;e  	   return;e }     ( /*	Open a master socket for listening on( **	------------------------------------- **G **	When data is transferred, we open a port, and wait for the server toi **	connect with the data.n ** ** On entry,8 **	master_socket	Must be negative if not set up already. ** On exit,e! **	Returns		socket number if goodd **			less than zero if error.e9 **	master_socket	is socket number if good, else negative.t  **	port_number	is valid if good. */ #ifdef __STDC__n# PRIVATE int get_listen_socket(void)  #elses PRIVATE int get_listen_socket()a #endif {r>   struct sockaddr_in soc_address;	/* Binary network address */)   struct sockaddr_in *sin = &soc_address; /   int new_socket;			/* Will be master_socket */       /* Create internet socket */:   new_socket = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);      if (new_socket < 0)      return -1;   
   if (TRACE) eI     fprintf(stderr, "FTP: Opened master socket number %d\n", new_socket);n        /* Search for a free port. */ E   sin->sin_family = AF_INET;	    /* Family = internet, host order  */ ;   sin->sin_addr.s_addr = INADDR_ANY; /* Any peer address */    {      int status;E-     int address_length = sizeof(soc_address);n #ifdef SOCKS"     status = Rgetsockname(control, #else !     status = getsockname(control,) #endif9                          (struct sockaddr *)&soc_address,s 			 &address_length);d     if (status<0)        return -1;)     CTRACE(tfp, "FTP: This host is %s\n",n            HTInetString(sin));     @     soc_address.sin_port = 0; /* Unspecified: please allocate */ #ifdef SOCKS     status=Rbind(new_socket, #else      status=bind(new_socket,  #endif-               (struct sockaddr*)&soc_address, .                 /* Cast to generic sockaddr */ #ifdef SOCKS8               sizeof(soc_address), SOCKS_ftpsrv.s_addr); #elser#               sizeof(soc_address));m #endif       if (status<0)          return -1;       +       address_length = sizeof(soc_address);  #ifdef SOCKS%     status = Rgetsockname(new_socket,i #elsed$     status = getsockname(new_socket, #endif:                            (struct sockaddr*)&soc_address,,                            &address_length);     if (status<0)        return -1;   }    .   CTRACE(tfp, "FTP: bound to port %d on %s\n",#          (int)ntohs(sin->sin_port),g          HTInetString(sin));      if (master_socket >= 0)      close_master_socket ();T      master_socket = new_socket;p   =   /* Now we must find out who we are to tell the other guy */o=   (void)HTHostName(); 	/* Make address valid - doesn't work*/ 5   sprintf(port_command, "PORT %d,%d,%d,%d,%d,%d%c%c", 6           (int)*((unsigned char *)(&sin->sin_addr)+0),6           (int)*((unsigned char *)(&sin->sin_addr)+1),6           (int)*((unsigned char *)(&sin->sin_addr)+2),6           (int)*((unsigned char *)(&sin->sin_addr)+3),6           (int)*((unsigned char *)(&sin->sin_port)+0),6           (int)*((unsigned char *)(&sin->sin_port)+1),           CR, LF);   2   /* Inform TCP that we will accept connections */ #ifdef SOCKS&   if (Rlisten (master_socket, 1) < 0)  #else;%   if (listen (master_socket, 1) < 0)   #endif     {1       close_master_socket ();        return -1;     }gD   CTRACE(tfp, "FTP: Master socket(), bind() and listen() all OK\n");   #   return master_socket;		/* Good */t } /* get_listen_socket */a      A /*	Read a directory into an hypertext object from the data socket A **	--------------------------------------------------------------  ** ** On entry,1 **	anchor		Parent anchor to link the this node tou$ **	address		Address of the directory ** On exit,r **	returns		HT_LOADED if OK  **			<0 if error.g **D ** Author: Charles Henrich (henrich@crh.cl.msu.edu)  October 2, 1993 **N ** Completely re-wrote this chunk of code to present FTP directory informationF ** in a much more useful manner.  Also included the use of icons. -Crh */ PRIVATE int read_directory ARGS4 (    HTParentAnchor *,		parent,   CONST char *,			address,   HTFormat,			format_out,    HTStream *,			sink ) {    HText *HT = HText_new ();    HTFormat format;   HTAtom *pencoding;H   char *filename = HTParse(address, "", PARSE_PATH + PARSE_PUNCTUATION);   char buffer[BUFSIZ];   char itemtype;   char itemname[BUFSIZ];   char itemsize[BUFSIZ];   char *full_ftp_name, *ptr; #ifndef NOT_BSNl   char itemdate[BUFSIZ];   char itemlink[BUFSIZ];
   char *ptrd;f   int lfirst = 0;/   int lcont = 0; #endif /* BSN */   int count, ret, cmpr, c, rv;/   extern char *HTgeticonname(HTFormat, char *);      HText_beginAppend (HT);p  .   HText_appendText (HT, "<H1>FTP Directory ");"   HText_appendText (HT, filename);#   HText_appendText (HT, "</H1>\n");  #ifndef NOT_BSNe#   HText_appendText (HT, "<PRE>\n");  #endif /* BSN */"   HText_appendText (HT, "<DL>\n");7   data_read_pointer = data_write_pointer = data_buffer;   F   /* If this isnt the root level, spit out a parent directory entry */     if(strcmp(filename,"/") != 0)"     { "       HText_appendText(HT,"<DD>");  (       HText_appendText(HT,"<A HREF=\"");              strcpy(buffer,filename);        ptr = strrchr(buffer,'/');               if(ptr != NULL) *ptr='\0';              if(buffer[0] == '\0') !         HText_appendText(HT,"/"); 
       else%         HText_appendText(HT, buffer);        ,       HText_appendText(HT,"\"><IMG SRC=\"");=       HText_appendText(HT, HTgeticonname(NULL, "directory"));r #ifdef NOT_BSN6       HText_appendText(HT,"\"> Parent Directory</a>"); #elsev8       HText_appendText(HT,"\"> Parent Directory</a>\n"); #endif /* BSN */     }c      /* Loop until we hit EOF */ 
   while(1)     { "       /* Read in a line of data */-       for(count = 0; count < BUFSIZ; count++)p	         {t            c = next_data_char ();,           if (interrupted_in_next_data_char)
             {                if (TRACE)S                 fprintf (stderr, "FTP: Picked up interrupted_in_next_data_char\n");o$               return HT_INTERRUPTED;
             } 
                      if (c == '\r')
             {r$               c = next_data_char ();0               if (interrupted_in_next_data_char)                 {                    if (TRACE)                     fprintf Q                       (stderr, "FTP: Picked up interrupted_in_next_data_char\n");a(                   return HT_INTERRUPTED;                 }                               if (c != '\n') l                 break;
             }*
           +           if (c == '\n' || c == (char)EOF)               break;
                      buffer[count] = c;	         }	              if(c == (char)EOF)           break;              buffer[count] = 0;       L       /* Parse the input buffer, extract the item type, and the item size */        #if 0 E       ret=sscanf(buffer,"%c%*9s%*d %*s %*s %s", &itemtype, itemsize);          if (ret != 2)          continue;  #endifN       /* Retain whole string -- we don't use it at the moment, but we will. */&       full_ftp_name = strdup (buffer);P       /* Read but disregard itemsize -- this effectively guarantees we will knowF          what we should display and what we shouldn't -- don't ask. */
 #ifdef NotBSN;E       ret=sscanf(buffer,"%c%*9s%*d %*s %*s %s", &itemtype, itemsize);          if (ret != 2) 	         {            free (full_ftp_name);            continue;d	         }  #else        if (ftp_type[0] == '\0')	         {EI           ret=sscanf(buffer,"%c%*9s%*d %*s %*s %s", &itemtype, itemsize);e           if (ret != 2) 
             {0#               free (full_ftp_name);                continue;-
             }-	         } M       else if (!strcmp(ftp_type, "MadGoat") || !strcmp(ftp_type, "MultiNet")) 	         { $           char date1[16], date2[16]; /*D  * MultiNet and MadGoat servers should return a full directory list.  */o           if (lcont)C             ret=sscanf(buffer," %s %s %s", itemsize, date1, date2);            elseO             ret=sscanf(buffer,"%s %s %s %s", itemname, itemsize, date1, date2);f$           if ((ret == 1) && !lfirst)
             {a               lfirst = 1;;#               free (full_ftp_name);*               continue;m
             }E=           if ((ret == 1) && lfirst && strchr (itemname, '.'))c
             {(               lcont = 1;#               free (full_ftp_name);                continue;i
             }P@           if (((ret != 4) && !lcont) || !strchr (itemname, '.'))
             {;#               free (full_ftp_name);                continue;r
             }("           if ((ret != 3) && lcont)
             {=#               free (full_ftp_name);i               continue;+
             }            lcont = 0;"           if (strlen(date1) != 11)
             { $               strcpy(itemdate, " ");%               strcat(itemdate,date1);;
             }            else
             {e#             strcpy(itemdate,date1);o
             }g           strcat(itemdate," "); !           strcat(itemdate,date2);) /*:  * Remove the version if any. Maybe not necessary, but ...  */ '           ptr = strchr (itemname, ';');O$           if (ptr != 0) *ptr = '\0';1           if ((strstr (itemname, ".DIR") != 0) ||f-             (strstr (itemname, ".dir") != 0))t
             {                itemtype = 'd';t+               ptr = strchr (itemname, '.');                *ptr = '\0';
             }P           else             itemtype = '-';n	         } 
       else	         { O           if ((strchr (buffer, ' ') != 0) || ((ptr=strchr (buffer, '.')) == 0))e
             { #               free (full_ftp_name);                continue; 
             }  /*I  * MultiNet and MadGoat servers are asked to return a full directory listU9  * while UCX and Pathway are asked for the filename only.	  */a7           strncpy (itemname, buffer, sizeof(itemname));e'           ptr = strchr (itemname, ';');k /*<  * If we didn't find a semi-colon then, if the rightmost andB  * leftmost '.'s are not in the same location we take the position4  * of the rightmost dot to be by the version number.  */r           if (ptr != 0 && =            (strchr(itemname, '.') != strrchr(itemname, '.')))t)             ptr = strrchr(itemname, '.');f
           $           if (ptr != 0) *ptr = '\0';1           if ((strstr (itemname, ".DIR") != 0) ||;-             (strstr (itemname, ".dir") != 0))d
             {r               itemtype = 'd';.+               ptr = strchr (itemname, '.');t               *ptr = '\0';
             }            else             itemtype = '-'; 	         }m #endif /* VMS server, BSN */  U       /* Due to the various time stamp formats, its "safer" to retrieve the        */tU       /* filename by taking it from the right side of the string, we do that here. */U
 #ifdef NotBSN*        ptr = strrchr(buffer,' '); #else"        if (ftp_type[0] == '\0') {         char *cp;t"         ptr = strrchr(buffer,' ');         *ptr = '\0';H         if ((itemtype == 'l') && ((cp = strstr(buffer,"->")) != NULL)) {           *(cp-1) ='\0';           *ptr = ' ';C           strcpy(itemlink,cp);$           ptr = strrchr(buffer,' ');           *ptr = '\0'; /*          *(cp-1) =' '; */	         }t         ptrd = ptr - 10;!         if (*ptrd != ' ') ptrd--; !         if (*ptrd != ' ') ptrd--; !         if (*ptrd != ' ') ptrd--;o       } else {         ptr = itemname;e       }u #endif /* VMS server, BSN */              if(ptr == NULL)          continue;n       
 #ifdef NotBSN.       strcpy(itemname,ptr+1);p #elsex        if (ftp_type[0] == '\0') {         strcpy(itemname,ptr+1);e          strcpy(itemdate,ptrd+1);         *ptr = ' ';/       }  #endif /* VMS server, BSN */       $       HText_appendText (HT, "<DD>");<       /* Spit out the anchor refrence, and continue on... */       *       HText_appendText (HT, "<A HREF=\"");1       /* Assuming it's a relative reference... */ )       if (itemname && itemname[0] != '/') 	         {i*           HText_appendText (HT, filename);3           if (filename[strlen(filename)-1] != '/')  '             HText_appendText (HT, "/");s	         }R&       HText_appendText (HT, itemname);$       HText_appendText (HT, "\"> ");       U       /* There are 3 "types", directory, link and file.  If its a directory we     */ U       /* just spit out the name with a directory icon.  If its a link, we go       */ U       /* retrieve the proper name (i.e. the input looks like bob -> ../../../bob   */PU       /* so we want to hop past the -> and just grab bob.  The link case falls     */ U       /* through to the filetype case.  The filetype shows name and filesize, and  */*U       /* then attempts to select the correct icon based on file extension.         */d       switch(itemtype)	         {l         case 'd':            {r*             sprintf(buffer,"%s",itemname);0             HText_appendText(HT, "<IMG SRC=\"");C             HText_appendText(HT, HTgeticonname(NULL, "directory"));i)             HText_appendText(HT, "\"> ");m             break;           } 
                    case 'l':r #ifdef NOT_BSN           {*&             ptr = strrchr(buffer,' ');             if(ptr != NULL)e               {                  *ptr = '\0';*                 ptr = strrchr(buffer,' ');               }*                          if(ptr != NULL)                {                  *ptr = '\0';*                 ptr = strrchr(buffer,' ');               }o             3             if(ptr != NULL) strcpy(itemname,ptr+1);            }s #endif /* BSN */
                    case '-':f           {              @             /* If this is a link type, and the bytes are small, A                its probably a directory so lets not show the bytee                count */e #if 0            e8             if(itemtype == 'l' && atoi(itemsize) < 128)                { .                 sprintf(buffer,"%s",itemname);               }(             else               { B                 sprintf(buffer,"%s (%s bytes)",itemname,itemsize);               }, #endif   #if 0c              if(itemtype == 'l')                {  #endif.                 sprintf(buffer,"%s",itemname); #if 0                }              else               { G                 /* code doesn't work for this, and neither does pre. */C@                 sprintf(buffer,"<code>%s</code>",full_ftp_name);               }p #endif             K             format = HTFileFormat(itemname, &pencoding, WWW_SOURCE, &cmpr);P                          if (1)               {t4                 HText_appendText(HT, "<IMG SRC=\"");  B                 /* If this is a link, and we can't figure out whatH                    kind of file it is by extension, throw up the unknownH                    icon; however, if it isn't a link and we can't figure<                    out what it is, throw up the text icon...                     -                    Unless it's compressed. */p>                 if(itemtype == 'l' && cmpr == COMPRESSED_NOT)                    {0L                     /* If it's unknown, let's call it a menu (since symlinksH                        are most commonly used on FTP servers to point to4                        directories, IMHO... -marc */N                     HText_appendText(HT, HTgeticonname(format, "directory") );                   }t                 else                   {DI                     HText_appendText(HT, HTgeticonname(format, "text"));                     }"                 -                 HText_appendText(HT, "\"> ");r               }o             else               {C4                 HText_appendText(HT, "<IMG SRC=\"");L                 HText_appendText(HT, HTgeticonname(format, "application")); -                 HText_appendText(HT, "\"> ");                }_               break;
             }S             default:
             {*2               HText_appendText(HT, "<IMG SRC=\"");D               HText_appendText(HT, HTgeticonname(NULL, "unknown")); +               HText_appendText(HT, "\"> ");*               break;
             }            }f       $       HText_appendText (HT, buffer); #ifndef NOT_BSNV$       HText_appendText (HT, "</A>");D       if ((ftp_type[0] == '\0') || (!strcmp(ftp_type, "MadGoat")) ||,           (!strcmp(ftp_type, "MultiNet"))) {         int i1 = 0, i2 = 41;  N         if ((!strcmp(ftp_type, "MadGoat")) || (!strcmp(ftp_type, "MultiNet")))           i2 = 38;         if (itemtype == 'l') {           strcpy (buffer, " "); $           strcat (buffer, itemlink);$           i1 = strlen(itemlink) + 1;         } else {           buffer[0] = '\0';O	         }*;         i2 = i2 - i1 - strlen(itemname) - strlen(itemsize);r         if (i2 < 3) { (           HText_appendText (HT, buffer);&           HText_appendText (HT, "\n");P           if ((!strcmp(ftp_type, "MadGoat")) || (!strcmp(ftp_type, "MultiNet")))'             i2 = 42 - strlen(itemsize);_           else'             i2 = 45 - strlen(itemsize);cQ           strncpy (buffer, "                                              ", i2);            buffer[i2] = '\0';         } else {Q           strncat (buffer, "                                              ", i2);n!           buffer[i1 + i2] = '\0';t	         }F"         strcat (buffer, itemsize);         strcat (buffer, " ");a"         strcat (buffer, itemdate);&         HText_appendText (HT, buffer);       } "       HText_appendText (HT, "\n"); #else_&       HText_appendText (HT, "</A>\n"); #endif /* BSN */       free (full_ftp_name);o     }s   #   HText_appendText (HT, "</DL>\n");n #ifndef NOT_BSNs$   HText_appendText (HT, "</PRE>\n"); #endif /* BSN */   HText_endAppend (HT);s     rv = response (NIL);   if (rv == HT_INTERRUPTED)f     return rv;"   return rv == 2 ? HT_LOADED : -1; }h     /*	Retrieve File from Server **	------------------------- ** ** On entry,< **	name		WWW address of a file: document, including hostname ** On exit,w+ **	returns		Socket number for file if good.  **			<0 if bad.  */   #ifdef SOCKETSHR jmp_buf accept_env;    void hung_accept() {r   longjmp(accept_env,1); }  #endif /* SOCKETSHR, GEC */e   PUBLIC int HTFTPLoad ARGS4 (r   char *,			name,e   HTParentAnchor *,		anchor,   HTFormat,			format_out,    HTStream *,			sink )  {r   BOOL isDirectory = NO;
   int status;f*   int retry;			/* How many times tried? */   HTFormat format;   int compressed = 0;c #ifdef SOCKETSHR   int retrya = 0;    int retryl = 0;*   int timer = 8; #endif /* SOCKETSHR, GEC */r    #ifdef SOCKETSHR do { #endif /* SOCKETSHR, GEC */  #ifndef NotBSN   ftp_type[0] = '\0';d #endif /* VMS server, BSN */&   for (retry = 0; retry < 2; retry++)      {;       if (TRACE)J         fprintf (stderr, "FTP: TRYING in HTFTPLoad, attempt %d\n", retry);$       status = get_connection(name);       if (status < 0) 	         {            NETCLOSE (control);a           control = -1;r1           /* HT_INTERRUPTED will fall through. */% #ifdef SWP_HACK  	  loading_length=(-1);) #endif           return status;	         }n       #       status = get_listen_socket();t       if (status < 0)i	         {)           NETCLOSE (control);d           control = -1;3!           close_master_socket ();  #ifdef SWP_HACK) 	  loading_length=(-1);n #endifE           /* HT_INTERRUPTED would fall through, if we could interrupttF              somehow in the middle of it, which we currently can't. */           return status;	         }a       B       /* Inform the server of the port number we will listen on */       {-)         status = response (port_command);e%         if (status == HT_INTERRUPTED)            {s             if (TRACE)P               fprintf (stderr, "FTP: Interrupted in response (port_command)\n"); #ifdef SWP_HACKe 	    loading_length=(-1);- #endif3             HTProgress ("Connection interrupted.");              NETCLOSE (control);t             control = -1;s#             close_master_socket ();t"             return HT_INTERRUPTED;           }r         if (status !=2) '           {		/* Could have timed out */r             if (status < 0)                { #                 NETCLOSE (control);r                 control = -1;l'                 close_master_socket (); 5                 continue;		/* try again - net error*/e               }n               NETCLOSE (control);T             control = -1;T#             close_master_socket ();  #ifdef SWP_HACK  	    loading_length=(-1);* #endif3             return HT_NOT_LOADED;			/* bad reply */H           }T         if (TRACE)2           fprintf(stderr, "FTP: Port defined.\n");       }h       status = 0;;"       break;	/* No more retries */     } /* for retries */d     if (status < 0)i     {[       close_master_socket ();        NETCLOSE (control);        control = -1;  #ifdef SWP_HACK        loading_length=(-1); #endif0       return status;	/* Failed with this code */     }       /* Ask for the file: */    D   {oG     char *filename = HTParse(name, "", PARSE_PATH + PARSE_PUNCTUATION);>      char command[LINE_LENGTH+1];     HTAtom *encoding;n       if (!(*filename)) "       StrAllocCopy(filename, "/");L     format = HTFileFormat (filename, &encoding, WWW_PLAINTEXT, &compressed); #ifndef NotBSNL     if (TRACE) fprintf(stderr, "FTP: filename is %s\n", filename); /* BGT */     if (ftp_type[0] != '\0')       { (         if (strcmp (filename, "/") == 0)           {              free (filename);*             StrAllocCopy (filename, "[]");           }L         else           {  /*>  * Now we are in trouble. Convert the UNIX name to a VMS name.D  * I guess we can safely assume that we always start in the server's+  * topdirectory. Therefore a construct liked6  * /dir1/dir2.../dirn/name.type has to be converted to  * [.dir1.dir2..dirn]name.type  */PD             char *file_temp = (char *)malloc (strlen(filename) + 4);'             int i1 = 0, i2 = 1, i3 = 2;                file_temp[0] = '[';*             file_temp[1] = '.';R+             if (filename[0] == '/') i1 = 1;;6             for (; i1 < strlen (filename); i1++, i3++)               { (                 if (filename[i1] != '/')                   { 1                     file_temp[i3] = filename[i1];d                     continue;d                   })$                 file_temp[i3] = ']';0                 if (i2 > 1) file_temp[i2] = '.';                 i2 = i3;               }e,             if (i2 == 1) file_temp[1] = ']';!             file_temp[i3] = '\0';              free (filename);/             StrAllocCopy (filename, file_temp);              free (file_temp);p           }i       }t #endif /* VMS server, BSN */   #ifdef NotBSN    E1     sprintf(command, "TYPE %s%c%c", "I", CR, LF);  #else  /*N  * The UCX and TWG servers return data differently depending on whether binaryJ  * or ASCII mode is set. MultiNet and MadGoat as well as UNIX servers work  * well with all binary.O  * For UCX and TWG, check the setting in the Options menu, ftp binary mode box.;  */ H     if (!strcmp(ftp_type, "MadGoat") || !strcmp(ftp_type, "MultiNet")) {3       sprintf(command, "TYPE %s%c%c", "I", CR, LF);9     } else {       if (binary_ftp_mode)5         sprintf(command, "TYPE %s%c%c", "I", CR, LF); 
       else5         sprintf(command, "TYPE %s%c%c", "A", CR, LF);i     }  #endif /* VMS, BSN */t      status = response (command);     if (status != 2) h       {i%         if (status == HT_INTERRUPTED)w1           HTProgress ("Connection interrupted.");t         close_master_socket ();e         NETCLOSE (control);s         control = -1;e         free (filename); #ifdef SWP_HACK  	loading_length=(-1);f #endif@         return (status == HT_INTERRUPTED) ? HT_INTERRUPTED : -1;       })      #ifndef NotBSN.     if (filename[strlen(filename)-1] != ']') { /*   * First CWD, then get the file.  */        char filetemp[128];        char *cp;p  "       strcpy (filetemp, filename);1       if ((cp = strchr(filetemp, ']')) != NULL) {p         cp++; *cp = '\0';p9         sprintf(command, "CWD %s%c%c", filetemp, CR, LF);1$         status = response (command);         if (status != 2)	         {r            NETCLOSE (control);            control = -1;"            close_master_socket ();            free (filename);l #ifdef SWP_HACKe 	   loading_length=(-1); #endif!            return HT_INTERRUPTED; 	         }( /*!  * Now remove the directory part.   */ $         strcpy (filetemp, filename);)         cp = strchr(filetemp, ']'); cp++;e2         if (!(*cp) == '\0') strcpy (filename, cp);       }c     }m #endif /* VMS server, BSN */6     sprintf(command, "RETR %s%c%c", filename, CR, LF);      status = response (command);!     if (status == HT_INTERRUPTED)        {!         if (TRACE)D           fprintf (stderr, "FTP: Interrupted while sending RETR\n");/         HTProgress ("Connection interrupted.");          NETCLOSE (control);          control = -1;          close_master_socket ();          free (filename); #ifdef SWP_HACK  	loading_length=(-1);  #endif         return HT_INTERRUPTED;       }      if (status != 1) "(       {  /* Failed : try to CWD to it */
 #ifdef NotBSN 9         sprintf(command, "CWD %s%c%c", filename, CR, LF);d #elsee"         if (ftp_type[0] == '\0') {;           sprintf(command, "CWD %s%c%c", filename, CR, LF);*         } else {"           if (filename[0] == '[') =             sprintf(command, "CWD %s%c%c", filename, CR, LF);f           else@             sprintf(command, "CWD [.%s]%c%c", filename, CR, LF);	         }r #endif /* VMS server, BSN */$         status = response (command);%         if (status == HT_INTERRUPTED)(           {)             if (TRACE)G               fprintf (stderr, "FTP: Interrupted while sending CWD\n"); 3             HTProgress ("Connection interrupted.");              NETCLOSE (control);h             control = -1; #             close_master_socket ();l             free (filename); #ifdef SWP_HACK  	    loading_length=(-1);  #endif"             return HT_INTERRUPTED;           }UJ         /* Now pick up status == 5 for reports.adm.cs.cmu.edu, which says:              Tx: CWD /C            Rx: 530-Access not allowed for guest users for path "/".*E            Rx:     Here is a hint... If you know the full name of themF            Rx:     path or directory that you want, try to cd there inG            Rx:     one step rather than taking little steps in between. J            Rx:     Those intermediate directories are sometimes protected.K            Rx:     Or perhaps you are already in the appropriate directory.'D            Rx: 530 Use the pwd command to get the current directory.  0            This may break something.  I dunno...'         if (status == 2 || status == 5)  	   Yep it broke things... */)         if (status == 2)
           {   0             /* Successed : let's NAME LIST it */             isDirectory = YES;
 #ifdef NotBSN 1             sprintf(command, "LIST%c%c", CR, LF);s #elseo /*D  * Make an NLST for some VMS servers. It's faster and avoids bugs in  * early UCX servers.   */hH             if ((ftp_type[0] == '\0') || !strcmp(ftp_type, "MadGoat") ||+              !strcmp(ftp_type, "MultiNet"))t3               sprintf(command, "LIST%c%c", CR, LF);'             else3               sprintf(command, "NLST%c%c", CR, LF);U #endif /* VMS server, BSN */(             status = response (command);)             if (status == HT_INTERRUPTED)u               {                  if (TRACE)L                   fprintf (stderr, "FTP: Interrupted while sending LIST\n");7                 HTProgress ("Connection interrupted."); #                 NETCLOSE (control);                  control = -1;e'                 close_master_socket ();                   free (filename); #ifdef SWP_HACK  			loading_length=(-1);  #endif&                 return HT_INTERRUPTED;               }0           }        }e     free(filename);      if (status != 1) 1       {  #ifdef SOCKETSHR         if (TRACE)L 	  fprintf (stderr, "FTP: LIST directory returned with status %d\n",status); 	if (control != -1) {, #endif /* SOCKETSHR, GEC */          NETCLOSE (control);          control = -1;* #ifdef SOCKETSHR 	} #endif /* SOCKETSHR, GEC */f         close_master_socket ();  #ifdef SOCKETSHR 	if (retryl != 8)e 	  { 	    retryl++; 	    sleep (5);a< 	    fprintf (stderr, "FTP: Directory retry %d.\n", retryl);             continue;R 	  }K         if (TRACE) fprintf (stderr, "FTP: Retries failed.  Now return.\n"); J         HTProgress ("Directory list failed due to SOCKETSHR/NETLIB bug."); #endif /* SOCKETSHR, GEC */  #ifdef SWP_HACK  	loading_length=(-1);  #endif6         return HT_NOT_LOADED; /* Action not started */       }h   }u      /* Wait for the connection */P   { #     struct sockaddr_in soc_address;d  *     int	soc_addrlen = sizeof(soc_address); #ifdef SOCKETSHR     if (setjmp(accept_env))e       {s         NETCLOSE (control);          control = -1;t         close_master_socket ();n 	if (retrya != 8)  	  { 	    retrya++;2 	    fprintf (stderr, "FTP: Retry %d.\n", retrya);             continue;t 	  }K         if (TRACE) fprintf (stderr, "FTP: Retries failed.  Now return.\n"); F         HTProgress ("Connection failed due to SOCKETSHR/NETLIB bug."); #ifdef SWP_HACKt 	loading_length=(-1);  #endif         return HT_NOT_LOADED;        }e      signal(SIGALRM,hung_accept);
     alarm(8);  #endif /* SOCKETSHR, GEC */  #ifdef SOCKS#     status = Raccept(master_socket,  #else "     status = accept(master_socket, #endif4                     (struct sockaddr *)&soc_address,"                     &soc_addrlen); #ifdef SOCKETSHR
     alarm(0);;?     if (TRACE) fprintf (stderr, "FTP: Returned from accept\n");  #endif /* SOCKETSHR, GEC */r       if (status < 0)m       {          NETCLOSE (control);          control = -1;          close_master_socket (); 2         /* We can't interrupt out of an accept. */ #ifdef SWP_HACK  	loading_length=(-1);o #endif         return HT_NOT_LOADED;b       }   9     CTRACE(tfp, "FTP: Accepted new socket %d\n", status);t     data_soc = status;   }<     if (isDirectory)       { >       int s = read_directory (anchor, name, format_out, sink);   #ifdef SWP_HACK        loading_length=(-1); #endif         NETCLOSE (control);m       control = -1;        close_master_socket ();        NETCLOSE (data_soc);       data_soc = -1;         if (TRACE)N         fprintf (stderr, "FTP: Returning %d after doing read_directory\n", s);5       /* HT_INTERRUPTED should fall right through. */r       return s;r     }    else       { G       /* We reproduce ParseSocket below because of socket/child process           problem. */       HTStream * stream;$       HTStreamClass targetClass;    
       int rv;        $       stream = HTStreamStack(format,(                              format_out,(                              compressed,+                              sink, anchor);               if (!stream)  	         {t+           char buffer[1024];	/* @@@@@@@@ */ @           sprintf(buffer, "Sorry, can't convert from %s to %s.",@                   HTAtom_name(format), HTAtom_name(format_out));           HTProgress (buffer);           if (TRACE) p1             fprintf(stderr, "FTP: %s\n", buffer);P #ifdef SWP_HACK  	  loading_length=(-1);  #endif           return HT_NOT_LOADED;l	         }(       E       targetClass = *(stream->isa);	/* Copy pointers to procedures */        ftpKludge=1;'       rv = HTCopy(data_soc, stream, 0);/       ftpKludge=0;       loading_length=(-1);       if (rv == -1)e	         {            rv = HT_INTERRUPTED;	         } 
       else	         { .           (*targetClass.end_document)(stream);K           /* Do NOT call *targetClass.free yet -- sockets aren't closed. */            rv = HT_LOADED;"	         }          if (TRACE)\         fprintf (stderr, "FTP: Got back %d from our local equivalent of ParseSocket\n", rv);  :       /* Reset buffering to control connection -- probably=          no longer necessary, since we don't use a connection           more than once. */        HTInitInput(control);e         if (TRACE)D         fprintf (stderr, "FTP: Closing data socket %d\n", data_soc);       NETCLOSE (data_soc);       data_soc = -1;  C       /* Unfortunately, picking up the final reply sometimes causes;D          serious problems.  It *probably* isn't safe not to do this,G          as there is the possibility that FTP servers could die if they(0          try to send it and we're not listening.  <          Testcase for problems (10/30/93): uxc.cso.uiuc.edu,9          AnswerGarden COPYRIGHT in X11R5 contrib clients.G	          !@          Of course, we may already be triggering hostile actions<          by allowing client-side interrupts as follows... */       if (rv != HT_INTERRUPTED) 	         {r           if (TRACE)A             fprintf (stderr, "FTP: Picking up final reply...\n");2
 #ifdef OLD=           status = response (NIL);		/* Pick up final reply */ '           if (status == HT_INTERRUPTED) 
             {_               if (TRACE)O                 fprintf (stderr, "FTP: Interrupted picking up final reply.\n"); 5               HTProgress ("Connection interrupted.");   !               NETCLOSE (control);)               control = -1;,%               close_master_socket ();   6               (*targetClass.handle_interrupt)(stream);  $               return HT_INTERRUPTED;
             }            if (status != 2)
             { !               NETCLOSE (control);                control = -1;t%               close_master_socket ();a#               return HT_NOT_LOADED; 
             }p #elset           if (TRACE)U             fprintf (stderr, "FTP: Aw hell, we don't care about the final reply!\n");  #endif	         }               if (TRACE)F         fprintf (stderr, "FTP: Closing control socket %d\n", control);       NETCLOSE(control);       control = -1;S       close_master_socket ();          if (rv != HT_INTERRUPTED)=	         {U8           /* WAIT until all sockets have been closed. */           if (TRACE)E             fprintf (stderr, "FTP: Calling free method, finally.\n");m&           (*targetClass.free)(stream);	         }a       ?       return rv == HT_INTERRUPTED ? HT_INTERRUPTED : HT_LOADED;f     }  #ifdef SOCKETSHR   } while (1); #endif /* SOCKETSHR, GEC */t } /* open_file_read */