7 /*                System dependencies in the W3 library 6                                    SYSTEM DEPENDENCIES-                                               C    System-system differences for TCP include files and macros. This D    file includes for each system the files necessary for network and    file I/O.     	   AUTHORS    L   TBL                Tim Berners-Lee, W3 project, CERN, <timbl@info.cern.ch>@   EvA                     Eelco van Asperen <evas@cs.few.eur.nl>.   MA                      Marc Andreessen NCSAA   AT                      Aleksandar Totic <atotic@ncsa.uiuc.edu> A   SCW                     Susan C. Weber <sweber@kyle.eitech.com>                            
   HISTORY:C   22 Feb 91               Written (TBL) as part of the WWW library. *   16 Jan 92               PC code from EvA@   22 Apr 93               Merged diffs bits from xmosaic release2   29 Apr 93               Windows/NT code from SCW  C   Much of the cross-system portability stuff has been intentionally @   REMOVED from this version of the library by Marc A in order toF   discourage attempts to make "easy" ports of Mosaic for X to non-UnixF   platforms.  The library needs to be rewritten from the ground up; inB   the meantime, Unix is *all* we support or intend to support with   this set of source code.   */  
 #ifndef TCP_H 
 #define TCP_H    /*   Default values  D    These values may be reset and altered by system-specific sections=    later on.  there are also a bunch of defaults at the end .        */  /* Default values of those: */J #define NETCLOSE close      /* Routine to close a TCP-IP socket         */N #define NETREAD  HTDoRead       /* Routine to read from a TCP-IP socket     */J #define NETWRITE write      /* Routine to write to a TCP-IP socket      */   /* Unless stated otherwise, */J #define SELECT                  /* Can handle >1 channel.               */J #define GOT_SYSTEM              /* Can call shell with string           */   #ifdef unix  #define GOT_PIPE #endif  9 typedef struct sockaddr_in SockA;  /* See netinet/in.h */      #ifndef STDIO_H  #include <stdio.h> #define STDIO_H  #endif   #ifdef _AIX  #define AIX  #endif
 #ifdef AIX #define unix #endif  
 #ifdef _IBMR2 @ #define USE_DIRENT              /* sys V style directory open */ #endif   /* Solaris. */% #if defined(sun) && defined(__svr4__) @ #define USE_DIRENT              /* sys V style directory open */ #endif   #if defined(__alpha) #define USE_DIRENT #endif   #ifndef USE_DIRENT #ifdef SVR4  #define USE_DIRENT #endif #endif /* not USE_DIRENT */   3 #include <string.h>             /* For bzero etc */   * /* Use builtin strdup when appropriate. */4 #if defined(ultrix) || defined(VMS) || defined(NeXT) extern char *strdup ();  #endif       /*   VAX/VMS   E    Under VMS, there are many versions of TCP-IP. Define one if you do !    not use Digital's UCX product:      =   UCX                     DEC's "Ultrix connection" (default) <   WIN_TCP                 From Wollongong, now GEC software.5   MULTINET                From SRI, now from TGV Inv. A   DECNET                  Cern's TCP socket emulation over DECnet @   SOCKETSHR               E. Meyer's socket emulation for NETLIB                             +    The last three do not interfere with the F    unix i/o library, and so they need special calls to read, write andC    close sockets. In these cases the socket number is a VMS channel D    number, so we make the @@@ HORRIBLE @@@ assumption that a channelF    number will be greater than 10 but a unix file descriptor less than    10.  It works.        */ 
 #ifdef vms #ifdef WIN_TCP #undef NETREAD #undef NETWRITE  #undef NETCLOSE K #define NETREAD(s,b,l)  ((s)>10 ? netread((s),(b),(l)) : read((s),(b),(l))) M #define NETWRITE(s,b,l) ((s)>10 ? netwrite((s),(b),(l)) : write((s),(b),(l))) 9 #define NETCLOSE(s)     ((s)>10 ? netclose(s) : close(s))  #endif /* WIN_TCP */   #ifdef MULTINET  #undef NETCLOSE  #undef NETREAD #undef NETWRITE 
 #ifdef NotBSN O #define NETREAD(s,b,l)  ((s)>10 ? socket_read((s),(b),(l)) : read((s),(b),(l)))  #else L #define NETREAD(s,b,l)  ((s)>10 ? HTDoRead((s),(b),(l)) : read((s),(b),(l))) #endif /* BSN */? #define NETWRITE(s,b,l) ((s)>10 ? socket_write((s),(b),(l)) : \ 3                                 write((s),(b),(l))) = #define NETCLOSE(s)     ((s)>10 ? socket_close(s) : close(s))  #endif /* MULTINET */   K /*      Certainly this works for UCX and Multinet; not tried for Wollongong  */ #ifdef MULTINET ( #if defined(__DECC) && !defined(__alpha) #define __TYPES_LOADED 1. #endif /* DECC, fool MultiNet types.h, GEC */ 
 #ifdef __DECC  #define _POSIX_C_SOURCE  #endif /* DEC C, GEC */ 6 #include "multinet_root:[multinet.include.sys]types.h"
 #ifdef __DECC  #undef _POSIX_C_SOURCE #endif /* DEC C, GEC */ 2 #include "multinet_root:[multinet.include]errno.h"I /* Due to bugs in MultiNet V3.3's ERRNO.H for DEC C on VAX, redefine some   * things here.   */  #pragma nostandard? #if (defined(__DECC) || defined(__DECCXX)) && !defined(__alpha) C     int *cma$tis_errno_get_addr(void);  /* UNIX style error code */ P     int *cma$tis_vmserrno_get_addr(void); /* VMS error code when errno ==EVMSE*/3 #   define errno        (*cma$tis_errno_get_addr()) 6 #   define vaxc$errno   (*cma$tis_vmserrno_get_addr())O #   undef __TYPES_LOADED /* MultiNet 3.3D and earlier types.h is broken, GEC */  #endif #pragma standard   #ifdef __TIME_LOADEDI /* To avoid multiple defs. VAXC has __TIME_LOADED, Multinet __TIME BSN */  #define __TIME #else L #if defined(__DECC) && !defined(_XOPEN_SOURCE_EXTENDED) && !defined(_TYPES_)8 /* If _TYPES_ defined, then is pre-V3.5 MultiNet, GEC */ #define _XOPEN_SOURCE_EXTENDED #include <time.h>  #undef _XOPEN_SOURCE_EXTENDED I #endif /* As if MultiNet V3.5A wasn't bad enough, then came V3.5B, GEC */  #endif  5 #include "multinet_root:[multinet.include.sys]time.h"  #else  #ifdef WIN_TCP #define __STAT #endif #ifdef SOCKETSHR /* BGT */" #include "socketshr_files:types.h"( #if defined(__DECC) && !defined(__alpha)G /* The SOCKETSHR types.h does not define enough for DEC C on VAX and */ J /* there was no way to include both the SOCKETSHR and DEC C types.h, so */K /* the following were taken from DEC C's types.h.  Then DEC C V5.2 comes */ 5 /* along and makes a total hash of everything, GEC */  #ifndef __DEV_T  # define __DEV_T 1   typedef char *dev_t; # define __PID_T 1   typedef int pid_t; #if (__DECC_VER <= 50230003)   typedef unsigned off_t;    typedef unsigned short ino_t;    typedef int nlink_t;    typedef unsigned short mode_t; #endif #endif #endif #else /* BGT */  #include <types.h> #endif /* BGT */ #ifdef WIN_TCP
 #undef __STAT  #endif #include <errno.h>) #if defined(SOCKETSHR) && defined(__DECC)  #define __FD_SET 1D #endif /* DEC C V5.2 time.h conflicts with SOCKETSHR types.h, GEC */ #include <time.h>  #endif /* Multinet */    #include <string.h>    #ifndef STDIO_H  #include <stdio.h> #define STDIO_H  #endif   #ifdef SOCKETSHR /* BGT */! #include "socketshr_files:file.h"  #else /* BGT */  #include <file.h>  #endif /* BGT */   #ifndef VMS  #include unixio  #else D #if defined(SOCKETSHR) && defined(__DECC) && (__DECC_VER > 50230003) #define __UID_T 1  #define __GID_T 1  #endif #include <unixio.h>  #endif /* VMS, GEC */    #define INCLUDES_DONE   A #ifdef MULTINET  /* Include from standard Multinet directories */ 7 #include "multinet_root:[multinet.include.sys]socket.h" 9 #ifdef __TIME_LOADED  /* defined by sys$library:time.h */ > #define __TIME  /* to avoid double definitions in next file */ #endif7 #include "multinet_root:[multinet.include.netinet]in.h" 6 #include "multinet_root:[multinet.include.arpa]inet.h"
 #ifdef __DECC  #define _POSIX_C_SOURCE  #endif /* DEC C, GEC */ 2 #include "multinet_root:[multinet.include]netdb.h"
 #ifdef __DECC  #undef _POSIX_C_SOURCE #endif /* DEC C, GEC */ 6 #include "multinet_root:[multinet.include.sys]ioctl.h"  
 #ifdef __DECC  #define read  decc$read  #define write decc$write #define close decc$close #define sleep decc$sleep #endif /* DEC C, BSN */    #else  /* not multinet */   
 #ifdef DECNET & #include "types.h"  /* for socket.h */ #include "socket.h" 
 #include "dn"  #include "dnetdb"  /* #include "vms.h" */   #else /* UCX or WIN */   #ifdef CADDR_T #define __CADDR_T : #endif /* BSN, include file problem socket.h <-> xlib.h */ #include <socket.h>  #include <in.h>  #include <inet.h>  #include <netdb.h>   #if defined(WIN_TCP) #include <sys/ioctl.h> #endif  /* WIN_TCP */    #ifdef SOCKETSHR /* BGT */" #include "socketshr_files:ioctl.h"& #include "socketshr_files:socketshr.h"( #if defined(__DECC) && !defined(__alpha) #undef fread
 #undef fwrite 
 #undef fflush 
 #undef fdopen 
 #undef fclose  #undef fputs #undef fputc #undef fgets #undef fgetc #undef fprintfA #endif /* These Socketshr routines fail with DEC C on VAX, GEC */  #endif /* BGT */   #endif  /* not DECNET *// #endif  /* of Multinet or other TCP includes */    #define TCP_INCLUDES_DONE    #endif  /* vms */        /*   SCO ODT unix version    */   
 #ifdef sco #include <sys/fcntl.h> #define USE_DIRENT #endif   /*  	 MIPS unix     */ ( /* Mips hack (bsd4.3/sysV mixture...) */   #ifdef mips  extern int errno;  #endif     /*   Regular BSD unix versions   C    These are a default unix where not already defined specifically.        */  #ifndef INCLUDES_DONE  #include <sys/types.h>= /* #include <streams/streams.h>                 not ultrix */  #include <string.h>   - #include <errno.h>          /* independent */ - #include <sys/time.h>       /* independent */  #include <sys/stat.h>  #include <sys/param.h>0 #include <sys/file.h>       /* For open() etc */ #define INCLUDES_DONE  #endif  /* Normal includes */   > /*                      Directory reading stuff - BSD or SYS V */L #ifdef unix                    /* if this is to compile on a UNIX machine */L #define GOT_READ_DIR 1    /* if directory reading functions are available */1 #ifdef USE_DIRENT             /* sys v version */  #include <dirent.h>  #define direct dirent  #else  #include <sys/dir.h> #endif% #if defined(sun) && defined(__svr4__)  #include <sys/fcntl.h> #include <limits.h>  #endif #endif   /*   Defaults     INCLUDE FILES FOR TCP      */  #ifndef TCP_INCLUDES_DONE   #include <sys/ioctl.h> /* EJB */ #include <sys/socket.h>  #include <netinet/in.h> 6 #ifndef __hpux /* this may or may not be good -marc */< #include <arpa/inet.h>      /* Must be after netinet/in.h */ #endif #include <netdb.h> #endif  /* TCP includes */     /*  ,   MACROS FOR MANIPULATING MASKS FOR SELECT()     */ 
 #ifdef SELECT  #ifndef FD_SET typedef unsigned int fd_set;1 #define FD_SET(fd,pmask) (*(pmask)) |=  (1<<(fd)) 1 #define FD_CLR(fd,pmask) (*(pmask)) &= ~(1<<(fd)) % #define FD_ZERO(pmask)   (*(pmask))=0 1 #define FD_ISSET(fd,pmask) (*(pmask) & (1<<(fd)))  #endif  /* FD_SET */ #endif  /* SELECT */   #ifndef Not_BSN  #ifndef MAXHOSTNAMELEN0 #define MAXHOSTNAMELEN 64		/* Arbitrary limit */ #endif #endif /* BSN */ #endif /* TCP_H */