M /**************************************************************************** M  * NCSA Mosaic for the X Window System                                      * M  * Software Development Group                                               * M  * National Center for Supercomputing Applications                          * M  * University of Illinois at Urbana-Champaign                               * M  * 605 E. Springfield, Champaign IL 61820                                   * M  * mosaic@ncsa.uiuc.edu                                                     * M  *                                                                          * M  * Copyright (C) 1993, Board of Trustees of the University of Illinois      * M  *                                                                          * M  * NCSA Mosaic software, both binary and source (hereafter, Software) is    * M  * copyrighted by The Board of Trustees of the University of Illinois       * M  * (UI), and ownership remains with the UI.                                 * M  *                                                                          * M  * The UI grants you (hereafter, Licensee) a license to use the Software    * M  * for academic, research and internal business purposes only, without a    * M  * fee.  Licensee may distribute the binary and source code (if released)   * M  * to third parties provided that the copyright notice and this statement   * M  * appears on all copies and that no charge is associated with such         * M  * copies.                                                                  * M  *                                                                          * M  * Licensee may make derivative works.  However, if Licensee distributes    * M  * any derivative work based on or derived from the Software, then          * M  * Licensee will (1) notify NCSA regarding its distribution of the          * M  * derivative work, and (2) clearly notify users that such derivative       * M  * work is a modified version and not the original NCSA Mosaic              * M  * distributed by the UI.                                                   * M  *                                                                          * M  * Any Licensee wishing to make commercial use of the Software should       * M  * contact the UI, c/o NCSA, to negotiate an appropriate license for such   * M  * commercial use.  Commercial use includes (1) integration of all or       * M  * part of the source code into a product for sale or license by or on      * M  * behalf of Licensee to third parties, or (2) distribution of the binary   * M  * code or source code to third parties that need it to utilize a           * M  * commercial product sold or licensed by or on behalf of Licensee.         * M  *                                                                          * M  * UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR   * M  * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          * M  * WARRANTY.  THE UI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY THE    * M  * USERS OF THIS SOFTWARE.                                                  * M  *                                                                          * M  * By using or copying this Software, Licensee agrees to abide by the       * M  * copyright law and all other applicable laws of the U.S. including, but   * M  * not limited to, export control laws, and the terms of this license.      * M  * UI shall have the right to terminate this license immediately by         * M  * written notice upon Licensee's breach of, or non-compliance with, any    * M  * of its terms.  Licensee may be held legally responsible for any          * M  * copyright infringement that is caused or encouraged by Licensee's        * M  * failure to abide by the terms of this license.                           * M  *                                                                          * M  * Comments and questions are welcome and can be sent to                    * M  * mosaic-x@ncsa.uiuc.edu.                                                  * N  ****************************************************************************/  H #ifndef VMS  /* moved below to preclude warning message about caddr_t */ #include "mosaic.h"  #include "proxy.h"F struct Proxy *noproxy_list = NULL, *proxy_list = NULL, *ReadProxies(); #endif /* VMS, PGE, GEC */   /*#define PRERELEASE*/   /* not done yet -bjs */  #define nNOMETER   #include <signal.h>  #ifndef MULTINET #ifdef SOCKETSHR /* BGT */" #include "socketshr_files:types.h"( #if defined(__DECC) && !defined(__alpha)G /* The SOCKETSHR types.h does not define enough for DEC C on VAX and */ J /* there was no way to include both the SOCKETSHR and DEC C types.h, so */8 /* the following were taken from DEC C's types.h, GEC */2 #if !defined (__DEV_T) && (__DECC_VER <= 50230003)    typedef unsigned short mode_t; #endif #ifdef CADDR_T #define __CADDR_T 8 #endif /* DECwindows xresource.h wants __CADDR_T, GEC */ #endif #else /* BGT */  #include <sys/types.h> #endif /* BGT */$ #if defined(VMS) && !defined(__DECC)D #define CADDR_T      /* Used in Motif 1.1, __CADDR_T is Motif 1.2 */ #define __CADDR_T : #endif /* VMS, VAXC include file problem, BSN, PGE, GEC */) #if defined(SOCKETSHR) && defined(__DECC)  #define __FD_SET 1F #endif /* DEC C V5.2 socket.h conflicts with SOCKETSHR types.h, GEC */ #include <sys/socket.h>  #include <netinet/in.h>  #include <netdb.h> #ifdef SOCKETSHR /* BGT */& #include "socketshr_files:socketshr.h"( #if defined(__DECC) && !defined(__alpha)
 #undef fclose  #undef fprintf) #endif /* Avoid possible problems, GEC */  #endif /* BGT */ #else F #if defined(__TIME_T) && !defined(__TYPES_LOADED) && !defined(__TYPES) #define __TYPES_LOADEDF #endif /* Different defs in OpenVMS and MultiNet include files, BSN */
 #ifdef __DECC  #define _POSIX_C_SOURCE  #endif /* DEC C, GEC */ 6 #include "multinet_root:[multinet.include.sys]types.h"7 #include "multinet_root:[multinet.include.sys]socket.h" 7 #include "multinet_root:[multinet.include.netinet]in.h" 2 #include "multinet_root:[multinet.include]netdb.h"
 #ifdef __DECC  #undef _POSIX_C_SOURCE #endif /* DEC C, GEC */  #endif /* MULTINET, BSN*/  #include <ctype.h>  F #ifdef VMS  /* moved here to preclude warning message about caddr_t */ #include "mosaic.h"  #include "proxy.h"F struct Proxy *noproxy_list = NULL, *proxy_list = NULL, *ReadProxies(); #endif /* VMS, PGE, GEC */   #ifndef VMS_POSIX  #ifndef VMS  #include <sys/utsname.h> #endif #else " #include "posix$include:utsname.h", #endif /* Use VMS POSIX if installed, GEC */' #include <pwd.h>  /* from v27b2, GEC */   
 #ifdef VMS  #define strncasecmp strncasecomp #define strcasecmp strcasecompI #endif /* VMS, I don't know why they are spelled differently here, GEC */    /*SWP -- 8/14/95*/ extern int tableSupportEnabled;   * /* doesn't seem to be on all X11R4 systems! #if (XtSpecificationRelease == 4) % extern void _XEditResCheckMessages();  #define EDITRES_SUPPORT  #endif */    #if (XtSpecificationRelease > 4) #define EDITRES_SUPPORT  #endif   /*6  * EDITRES_SUPPORT seems to fail with the HP libraries  */ / #if defined(__hpux) && defined(EDITRES_SUPPORT)  #undef EDITRES_SUPPORT #endif  , #if defined(VMS) && defined(EDITRES_SUPPORT) #undef EDITRES_SUPPORT' #endif /* VMS Xmu has no Editres, BSN*/    #ifdef EDITRES_SUPPORT #include <X11/Xmu/Editres.h> #endif   #include <Xm/LabelG.h> #include <Xm/PushB.h>  #include <Xm/ScrolledW.h>  #include <Xm/ScrollBar.h>  #include <Xm/List.h> #include <Xm/ToggleB.h>  #include <Xm/Text.h> #include <Xm/TextF.h>  #include <Xm/DrawingA.h>   #include <Xm/Protocols.h>  #include <X11/keysym.h>    #ifndef VAXC #include "libhtmlw/HTML.h" #else  #include <libhtmlw/HTML.h>% #endif /* VAXC is _different_, BSN */  #include "xresources.h"    #include "bitmaps/xmosaic.xbm"# #include "bitmaps/xmosaic_left.xbm" $ #include "bitmaps/xmosaic_right.xbm"# #include "bitmaps/xmosaic_down.xbm"   - /* Because Sun cripples the keysym.h file. */  #ifndef XK_KP_Up9 #define XK_KP_Home              0xFF95  /* Keypad Home */ ? #define XK_KP_Left              0xFF96  /* Keypad Left Arrow */ = #define XK_KP_Up                0xFF97  /* Keypad Up Arrow */ @ #define XK_KP_Right             0xFF98  /* Keypad Right Arrow */? #define XK_KP_Down              0xFF99  /* Keypad Down Arrow */ < #define XK_KP_Prior             0xFF9A  /* Keypad Page Up */> #define XK_KP_Next              0xFF9B  /* Keypad Page Down */8 #define XK_KP_End               0xFF9C  /* Keypad End */ #endif     /*5  * Globals used by the pixmaps for the animated icon. 9  * Marc, I imagine you might want to do something cleaner   * with these?  */ ( extern Pixmap IconPix[NUMBER_OF_FRAMES]; extern int IconsMade; ! extern void MoCCINewConnection();    extern int force_dump_to_file; extern char *HTAppVersion;  N /* ------------------------------ variables ------------------------------- */  
 Display *dsp;  XtAppContext app_context;  Widget toplevel;- Widget view = NULL;  /* HORRIBLE HACK @@@@ */ 6 int Vclass;  /* visual class for 24bit support hack */* AppData Rdata;  /* extern'd in mosaic.h */: char *global_xterm_str;  /* required for HTAccess.c now */   char *uncompress_program;  char *gunzip_program;    int use_default_extension_map; char *global_extension_map;  char *personal_extension_map;  int use_default_type_map;  char *global_type_map; char *personal_type_map;   int tweak_gopher_types;  int max_wais_responses; 
 int have_hdf;  int twirl_increment;   char *HTReferer = NULL;   = /* This is exported to libwww, like altogether too many other     variables here. */  int binary_transfer; #ifndef NOT_BSN  int binary_ftp_mode;! #endif /* VMS ftp servers, BSN */ > /* Now we cache the current window right before doing a binary1    transfer, too.  Sheesh, this is not pretty. */  mo_window *current_win;   B /* If startup_document is set to anything but NULL, it will be the?    initial document viewed (this is separate from home_document 
    below). */  char *startup_document = NULL;@ /* If startup_document is NULL home_document will be the initial    document. */  char *home_document = NULL;  char *machine; char *shortmachine;  char *machine_with_domain;  
 #ifdef VMSF /* Need to distinguish between commandline -home argument       lll */F /* and Xresource file homeDocument setting so that              lll */F /* commandline takes precedence over WWW_HOME environment       lll */F /* variable                                                     lll */F char *cmdline_homeDocument = NULL; /*                           lll */ #endif /* VMS, LLL */    XColor fg_color, bg_color;   static Cursor busy_cursor; static int busy = 0; static Widget *busylist = NULL;  char *cached_url = NULL;  , /* Forward declaration of test predicate. */. int anchor_visited_predicate (Widget, char *);  < /* When we first start the application, we call mo_startup()=    after creating the unmapped toplevel widget.  mo_startup() ;    either sets the value of this to 1 or 0.  If 0, we don't     open a starting window. */  int defer_initial_window;   # /* Pixmaps for interrupt button. */ T static Pixmap xmosaic_up_pix, xmosaic_left_pix, xmosaic_down_pix, xmosaic_right_pix;  $ extern char *HTDescribeURL (char *);D extern mo_status mo_post_access_document (mo_window *win, char *url,>                                           char *content_type, ;                                           char *post_data); " XmxCallbackPrototype (menubar_cb);  ' #if !defined(VMS) || defined(VMS_POSIX)  struct utsname mo_uname;, #endif /* Need POSIX for this on VMS, GEC */  
 #ifdef VMS$ extern unsigned long mbx_event_flag;" extern unsigned short mbx_iosb[4]; #endif /* VMS, BSN */   N /* ----------------------------- WINDOW LIST ------------------------------ */  ! static mo_window *winlist = NULL;  static int wincount = 0;  @ /* Return either the first window in the window list or the next&    window after the current window. */* mo_window *mo_next_window (mo_window *win) {    if (win == NULL)     return winlist;    else     return win->next;  }   2 /* Return a window matching a specified uniqid. */) mo_window *mo_fetch_window_by_id (int id)  {    mo_window *win;      win = winlist;   while (win != NULL)      {        if (win->id == id) /*        goto done;*/
 	return(win);        win = win->next;     }    /* notfound:*/   return NULL; /*  done:   return win;*/  }   + /* Register a window in the window list. */ 0 mo_status mo_add_window_to_list (mo_window *win) { 
   wincount++;      if (winlist == NULL)     {        win->next = NULL;        winlist = win;     }    else     {        win->next = winlist;       winlist = win;     }      return mo_succeed; }   + /* Remove a window from the window list. */ 5 mo_status mo_remove_window_from_list (mo_window *win)  { $   mo_window *w = NULL, *prev = NULL;      while (w = mo_next_window (w))     {        if (w == win) 	         {            /* Delete w. */            if (!prev)
             { '               /* No previous window. */                 winlist = w->next;                 free (w);                w = NULL;                  wincount--;                  /* Maybe exit. */                if (!winlist)                  mo_exit (); 
             }            else
             { $               /* Previous window. */#               prev->next = w->next;                  free (w);                w = NULL;                  wincount--;                   return mo_succeed;
             } 	         }        prev = w;      }         /* Couldn't find it. */    return mo_fail;  }    /*  * THIS IS NOT USED ANYMORE!  */   M /****************************************************************************   * name:    mo_check_for_proxyJ  * purpose: Return the location of the proxy gateway for the passed access  *	    method.  * inputs:  H  *   - char *access: access string from the URL (http, gopher, ftp, etc)  * returns: @  *   The proxy gateway to use. (http://proxy.ncsa.uiuc.edu:911/):  * remarks: This should really be open-ended configurable.N  ****************************************************************************/' char *mo_check_for_proxy (char *access)  {  /* 	if (access == NULL) 	{ 		return((char *)NULL);  	}& 	else if (strcmp(access, "http") == 0) 	{ 		return(Rdata.http_proxy);  	}% 	else if (strcmp(access, "ftp") == 0)  	{ 		return(Rdata.ftp_proxy); 	}& 	else if (strcmp(access, "wais") == 0) 	{ 		return(Rdata.wais_proxy);  	}( 	else if (strcmp(access, "gopher") == 0) 	{ 		return(Rdata.gopher_proxy);  	}& 	else if (strcmp(access, "news") == 0) 	{ 		return(Rdata.news_proxy);  	}& 	else if (strcmp(access, "file") == 0) 	{ 		return(Rdata.file_proxy);  	} 	else  	{ */ 		return((char *)NULL);  /* 	} */ }   M /****************************************************************************    * name:    mo_assemble_help_url.  * purpose: Make a temporary, unique filename.  * inputs:  C  *   - char *file: Filename to be appended to Rdata.docs_directory.   * returns: .  *   The desired help url (a malloc'd string).  * remarks: N  ****************************************************************************/' char *mo_assemble_help_url (char *file)  {    char *tmp;     if (!file),     return strdup ("http://lose.lose/lose");  M   tmp = (char *)malloc ((strlen (file) + strlen (Rdata.docs_directory) + 4) * '                         sizeof (char));   B   if (Rdata.docs_directory[strlen(Rdata.docs_directory)-1] == '/')     { 2       /* Trailing slash in docs_directory spec. */8       sprintf (tmp, "%s%s", Rdata.docs_directory, file);     }    else     {        /* No trailing slash. */9       sprintf (tmp, "%s/%s", Rdata.docs_directory, file);      }    
   return tmp;  }     N /* ----------------------------- busy cursor ------------------------------ */   mo_status mo_not_busy (void) {    mo_window *win = NULL;      if (busy)      { 1       XUndefineCursor (dsp, XtWindow (toplevel)); (       while (win = mo_next_window (win))	         { 6           XUndefineCursor (dsp, XtWindow (win->base));           if (win->history_win) ?             XUndefineCursor (dsp, XtWindow (win->history_win));*           if (win->hotlist_win) ?             XUndefineCursor (dsp, XtWindow (win->hotlist_win)); #           if (win->searchindex_win)nC             XUndefineCursor (dsp, XtWindow (win->searchindex_win)); 	         }S              XFlush (dsp);        busy = 0;      }       return mo_succeed; }U   mo_status mo_busy (void) {    mo_window *win = NULL;     if (!busy)     {n<       XDefineCursor (dsp, XtWindow (toplevel), busy_cursor);(       while (win = mo_next_window (win))       { ?         XDefineCursor (dsp, XtWindow (win->base), busy_cursor);          if (win->history_win)CH           XDefineCursor (dsp, XtWindow (win->history_win), busy_cursor);         if (win->hotlist_win) H           XDefineCursor (dsp, XtWindow (win->hotlist_win), busy_cursor);!         if (win->searchindex_win) L           XDefineCursor (dsp, XtWindow (win->searchindex_win), busy_cursor);       }i              XFlush (dsp);r       busy = 1;      }       return mo_succeed; }    #ifdef HAVE_DTM N /* --------------------- mo_set_dtm_menubar_functions --------------------- */  7 mo_status mo_set_dtm_menubar_functions (mo_window *win)  {    if (mo_dtm_out_active_p ())      {lD       /* If we've got an active outport, then we can send a document)          but not open another outport. */d       XmxRSetSensitive e=         (win->menubar, mo_dtm_open_outport, XmxNotSensitive);*       XmxRSetSensitive;         (win->menubar, mo_dtm_send_document, XmxSensitive);e     }    else     { J       /* If we don't have an active outport, then we can't send a document'          but we can open an outport. */        XmxRSetSensitive  :         (win->menubar, mo_dtm_open_outport, XmxSensitive);       XmxRSetSensitive>         (win->menubar, mo_dtm_send_document, XmxNotSensitive);     }      return mo_succeed; }i #endif    M /****************************************************************************a  * name:    mo_redisplay_windowrC  * purpose: Cause the current window's HTML widget to be refreshed. H  *          This causes the anchors to be reexamined for visited status.  * inputs:  &  *   - mo_window *win: Current window.  * returns:   *   mo_succeed   * remarks:   *   iN  ****************************************************************************/. mo_status mo_redisplay_window (mo_window *win) {s   char *curl = cached_url;   cached_url = win->cached_url;e  B   HTMLRetestAnchors (win->scrolled_win, anchor_visited_predicate);     cached_url = curl;     return mo_succeed; }L    N /* ---------------------- mo_set_current_cached_win ----------------------- */  4 mo_status mo_set_current_cached_win (mo_window *win) {    current_win = win;   view = win->view;      return mo_succeed; }      static connect_interrupt = 0; $ static XmxCallback (icon_pressed_cb) {    connect_interrupt = 1; }P  N /* ----------------------- editable URL field callback -------------------- */N /* If the user hits return in the URL text field at the top of the display, */N /* then go fetch that URL  -- amb                                           */  ! static XmxCallback (url_field_cb)  { O   mo_window *win = mo_fetch_window_by_id (XmxExtractUniqid ((int)client_data));    char *url;  )   url = XmxTextGetString (win->url_text);s   if (!url || (!strlen(url)))      return;g&   mo_convert_newlines_to_spaces (url);'   mo_load_window_text (win, url, NULL);t   free(url);   	   return;n }h  M /****************************************************************************c  * name:    anchor_cb :  * purpose: Callback for triggering anchor in HTML widget.  * inputs:    *   - as per XmxCallbackm  * returns:   *   nothing  * remarks: 3  *   This is too complex and should be broken down.t@  *   We look at the button event passed in through the callback;3  *   button1 == same window, button2 == new window. >  *   Call mo_open_another_window or mo_load_window_text to get  *   the actual work done.N  ****************************************************************************/ static XmxCallback (anchor_cb) {    char *href, *reftext;  /*  char *access;*/*   static char *referer = NULL;O   mo_window *win = mo_fetch_window_by_id (XmxExtractUniqid ((int)client_data));d    XButtonReleasedEvent *event = I     (XButtonReleasedEvent *)(((WbAnchorCallbackData *)call_data)->event);L8   int force_newwin = (event->button == Button2 ? 1 : 0);   int old_binx_flag;  @   /* if shift was down, make this a Load to Local Disk -- amb */'   old_binx_flag = win->binary_transfer;S/   if ( (event->state & ShiftMask) == ShiftMask)e     win->binary_transfer = 1;e  *   if (Rdata.kiosk || Rdata.kioskNoExit) { ,     /* disable new window if in kiosk mode*/     force_newwin = 0;c     }t     if (!win)      return;e  #   if (Rdata.protect_me_from_myself)      {C /*&  * VAXC has a record length limitation  */_#       int answer = XmxModalYesOrNo i          (win->base, app_context,T          "BEWARE: Despite our best and most strenuous intentions to the contrary,\n\ absolutely anything could be on the other end of this hyperlink,\nincluding -- quite possibly -- pornography, or even nudity.\n\n\ NCSA disclaims all responsibility regarding your emotional and mental health\nand specifically all responsibility for effects of viewing salacious material via Mosaic.\n\n\H With that in mind, are you *sure* you want to follow this hyperlink???",C          "Yup, I'm sure, really.", "Ack, no!  Get me outta here.");c       if (!answer)         return;G     }i     /* amb */h   if (referer!=NULL)     {i       free(referer);       referer=NULL;l     }uH   if ( strncasecmp(win->current_node->url, "file://localhost", 16) != 0)     { 0       /* what if hostname is a partial local? */0       referer = strdup (win->current_node->url);       HTReferer = referer;     }n   else     HTReferer = NULL;/   0   if (((WbAnchorCallbackData *)call_data)->href)>     href = strdup (((WbAnchorCallbackData *)call_data)->href);   else     href = strdup ("Unlinked");.0   if (((WbAnchorCallbackData *)call_data)->text)A     reftext = strdup (((WbAnchorCallbackData *)call_data)->text);n   else"     reftext = strdup ("Untitled");  '   mo_convert_newlines_to_spaces (href);f     if (!force_newwin)-     mo_load_window_text (win, href, reftext);o   else     {n2       char *target = mo_url_extract_anchor (href);       char *url = G         mo_url_canonicalize_keep_anchor (href, win->current_node->url);d7       /* @@@ should we be keeping the anchor here??? */  #ifndef VMSyG       if (strncmp (url, "telnet:", 7) && strncmp (url, "tn3270:", 7) &&/&           strncmp (url, "rlogin:", 7)) #else<-       if (strncasecomp (url, "telnet:", 7) &&d-           strncasecomp (url, "tn3270:", 7) &&c+           strncasecomp (url, "rlogin:", 7))h0 #endif /* VMS, RFC says case-insensitive, GEC */	         {/$           /* Not a telnet anchor. */  >           /* Open the window (generating a new cached_url). */=           mo_open_another_window (win, url, reftext, target);n  *           /* Now redisplay this window. */$           mo_redisplay_window (win);	         }e
       elseF         /* Just do mo_load_window_text go get the xterm forked off. */0         mo_load_window_text (win, url, reftext);     }P  '   win->binary_transfer = old_binx_flag;(   free (href);	   return;I }S    M /****************************************************************************u.  * name:    anchor_visited_predicate (PRIVATE)F  * purpose: Called by the HTML widget to determine whether a given URL(  *          has been previously visited.  * inputs:  8  *   - Widget   w: HTML widget that called this routine.  *   - char *href: URL to test.e  * returns: 8  *   1 if href has been visited previously; 0 otherwise.  * remarks: 3  *   All this does is canonicalize the URL and callC>  *   mo_been_here_before_huh_dad() to figure out if we've been  *   there before.N  ****************************************************************************/3 int anchor_visited_predicate (Widget w, char *href)c {p	   int rv;s  ,   if (!Rdata.track_visited_anchors || !href)
     return 0;   <   /* This doesn't do special things for data elements inside2      an HDF file, because it's faster this way. */0   href = mo_url_canonicalize (href, cached_url);  B   rv = (mo_been_here_before_huh_dad (href) == mo_succeed ? 1 : 0);     free (href);   return rv; }y  : static void pointer_motion_callback (Widget w, char *href) {y   mo_window *win = NULL;   XmString xmstr; *   char *to_free = NULL, *to_free_2 = NULL;  "   if (!Rdata.track_pointer_motion)     return;d   $   while (win = mo_next_window (win))     if (win->scrolled_win == w),       goto foundit;w      /* Shit outta luck. */	   return;s   	  foundit:n     if (href && *href)     {SE       href = mo_url_canonicalize_keep_anchor (href, win->cached_url);n       to_free = href;;         /* Sigh... */s+       mo_convert_newlines_to_spaces (href);i  H       /* This is now the option wherein the URLs are just spit up there;3          else we put up something more friendly. */ %       if (Rdata.track_full_url_names) 	         {s*           /* Everything already done... */	         } 
       else	         {l;           /* This is where we go get a good description. */n&           href = HTDescribeURL (href);           to_free_2 = href;o	         }r     }l   else     href = " ";e&   xmstr = XmStringCreateSimple (href);   XtVaSetValues*     (win->tracker_label,%      XmNlabelString, (XtArgVal)xmstr,p      NULL);_   XmStringFree (xmstr);e     if (to_free)     free (to_free);T   if (to_free_2)     free (to_free_2);o   	   return;l }e    " XmxCallback (submit_form_callback) {    mo_window *win = NULL;<   char *url = NULL, *method = NULL, *enctype = NULL, *query;
   int len, i;N?   WbFormCallbackData *cbdata = (WbFormCallbackData *)call_data;a   int do_post_urlencoded = 0;t   char *entity=NULL;     if (!cbdata)     return;u  $   while (win = mo_next_window (win))     if (win->scrolled_win == w)n       goto foundit;a      /* Shit outta luck. */	   return;    	  foundit:o  
   mo_busy ();*  '   /* Initial query: Breathing space. */w   len = 16;i  "   /* Add up lengths of strings. *//   for (i = 0; i < cbdata->attribute_count; i++)e     {r%       if (cbdata->attribute_names[i])*	         {s9           len += strlen (cbdata->attribute_names[i]) * 3;**           if (cbdata->attribute_values[i])<             len += strlen (cbdata->attribute_values[i]) * 3;	         }n       len += 2;l     }*     /* Get the URL. */&   if (cbdata->href && *(cbdata->href))     url = cbdata->href;o   else!     url = win->current_node->url;   *   if (cbdata->method && *(cbdata->method))     method = cbdata->method;   else     method = strdup ("GET");  #   /* Grab enctype if it's there. */*,   if (cbdata->enctype && *(cbdata->enctype))     enctype = cbdata->enctype;<   /* Grab encentity if it's there and we have an enctype. */=   if (enctype && cbdata->enc_entity && *(cbdata->enc_entity))n      entity = cbdata->enc_entity;   #if 0e=   fprintf (stderr, "[submit_form_callback] method is '%s'\n",e            method);*>   fprintf (stderr, "[submit_form_callback] enctype is '%s'\n",            enctype); #endif  '   if (strcasecmp (method, "POST") == 0)      do_post_urlencoded = 1;c     len += strlen (url);  /   query = (char *)malloc (sizeof (char) * len);n     if (!do_post_urlencoded)     {        strcpy (query, url);       /* Clip out anchor. */       strtok (query, "#");       /* Clip out old query. */c       strtok (query, "?");(       if (query[strlen(query)-1] != '?')	         {a           strcat (query, "?");	         }      }    else     {f%       /* Get ready for cats below. */a       query[0] = 0;h     }_  .   /* Take isindex possibility into account. */%   if (cbdata->attribute_count == 1 &&-:       strcmp (cbdata->attribute_names[0], "isindex") == 0)     {t&       if (cbdata->attribute_values[0])	         {wA           char *c = mo_escape_part (cbdata->attribute_values[0]);i           strcat (query, c);           free (c);)	         }(     }N   else     {n3       for (i = 0; i < cbdata->attribute_count; i++)R	         {dB           /* For all but the first, lead off with an ampersand. */           if (i != 0)n              strcat (query, "&");           /* Rack 'em up. */)           if (cbdata->attribute_names[i])n
             {iD               char *c = mo_escape_part (cbdata->attribute_names[i]);                strcat (query, c);               free (c);i               "               strcat (query, "=");               .               if (cbdata->attribute_values[i])                 {iI                   char *c = mo_escape_part (cbdata->attribute_values[i]);n$                   strcat (query, c);                   free (c);;                 } 
             } 	         }.     }o     if (do_post_urlencoded)_     {oM       mo_post_access_document (win, url, "application/x-www-form-urlencoded",t&                                query);     }    else     { &       mo_access_document (win, query);     }       free (query);   	   return;o }w    D /* This only gets called by the widget in the middle of set_text. */" static XmxCallback (link_callback) {    mo_window *win = current_win;**   LinkInfo *linfo = (LinkInfo *)call_data;!   extern char *url_base_override;   
   if (!linfo)      return;       /* Free -nothing- in linfo. */   if (linfo->href)     { /       url_base_override = strdup (linfo->href);)  B       /* Set the URL cache variables to the correct values NOW. */?       cached_url = mo_url_canonicalize (url_base_override, "");=#       win->cached_url = cached_url;d     }    if (linfo->role)     { .       /* Do nothing with the role crap yet. */     }*  	   return;* }*     /* Exported to libwww2. */' void mo_gui_notify_progress (char *msg)p {y   XmString xmstr;n   mo_window *win = current_win;y  "   if (!Rdata.track_pointer_motion)     return;      if (!msg)a     msg = " ";  %   xmstr = XmStringCreateSimple (msg);)   XtVaSetValues*     (win->tracker_label,%      XmNlabelString, (XtArgVal)xmstr,*      NULL);s   XmStringFree (xmstr);d     XmUpdateDisplay (win->base);  	   return;* }*     void UpdateButtons (Widget w)* {*   XEvent event;e#   Display * display = XtDisplay(w);       XSync (display, 0);	   F   while (XCheckMaskEvent(display, (ButtonPressMask|ButtonReleaseMask),!                          &event))      {c.       XButtonEvent *bevent = &(event.xbutton);9       if (bevent->window == XtWindow (current_win->logo))		         {a"           XtDispatchEvent(&event);	         }oG       /* else just throw it away... users shouldn't be pressing buttonsc0          in the middle of transfers anyway... */     }  }s     static int logo_count = 0;  ! int mo_gui_check_icon (int twirl)  {    mo_window *win = current_win;N
   int ret;  ,   if (twirl && Rdata.twirling_transfer_icon)     {*      { #ifndef VMS*! 	if (IconPix[logo_count] != NULL)m #elsep* 	if (IconPix[logo_count] != (Pixmap) NULL) #endif 	{ 		AnimatePixmapInWidgetf' 		    (win->logo, IconPix[logo_count]);s 	} 	logo_count++;4 	if (logo_count >= NUMBER_OF_FRAMES) logo_count = 0;      }     }       UpdateButtons (win->base);   XmUpdateDisplay (win->base);     ret = connect_interrupt;   connect_interrupt = 0;     return(ret); }      void mo_gui_clear_icon (void)p {l   connect_interrupt = 0; }c  ! void mo_gui_done_with_icon (void)  {a   mo_window *win = current_win;   N       XClearArea(XtDisplay(win->logo), XtWindow(win->logo), 0, 0, 0, 0, True);     logo_count = 0;) }       M /**************************************************************************** .  * name:    mo_view_keypress_handler (PRIVATE)H  * purpose: This is the event handler for the HTML widget and associatedG  *          scrolled window; it handles keypress events and enables the-  *          hotkey support.r  * inputs:    *   - as per XmxEventHandleru  * returns:   *   nothing  * remarks: I  *   Hotkeys and their actions are currently hardcoded.  This is probablyo#  *   a bad idea, and Eric hates it.tN  ****************************************************************************/1 static XmxEventHandler (mo_view_keypress_handler)U {f+ /*  char url[128]; /* buffer for news io */*O   mo_window *win = mo_fetch_window_by_id (XmxExtractUniqid ((int)client_data));i   int _bufsize = 3, _count;    char _buffer[3];   KeySym _key;   XComposeStatus _cs;p     if (!win)-     return;w  !   /* Go get ascii translation. */u=   _count = XLookupString (&(event->xkey), _buffer, _bufsize,  '                           &_key, &_cs);w      /* Insert trailing Nil. */   _buffer[_count] = '\0';o     /* Page up. */:   if ((Rdata.catch_prior_and_next && _key == XK_Prior) ||        _key == XK_KP_Prior ||0       _key == XK_BackSpace || _key == XK_Delete)     {        Widget sb;       String params[1];C              params[0] = "0";  >       XtVaGetValues (win->scrolled_win, XmNverticalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb))i	         {dB           XtCallActionProc (sb, "PageUpOrLeft", event, params, 1);	         }u     }      /* Page down. */N   if ((Rdata.catch_prior_and_next && _key == XK_Next) || _key == XK_KP_Next ||,       _key == XK_Return || _key == XK_Tab ||       _key == XK_space)-     {-       Widget sb;       String params[1];r              params[0] = "0";       >       XtVaGetValues (win->scrolled_win, XmNverticalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb)).	         { E           XtCallActionProc (sb, "PageDownOrRight", event, params, 1);e	         }      }m   ,   if (_key == XK_Down || _key == XK_KP_Down)     {n       Widget sb;       String params[1];               params[0] = "0";       >       XtVaGetValues (win->scrolled_win, XmNverticalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb))t	         {nJ           XtCallActionProc (sb, "IncrementDownOrRight", event, params, 1);	         }n     };   .   if (_key == XK_Right || _key == XK_KP_Right)     {*       Widget sb;       String params[1];*              params[0] = "1";       @       XtVaGetValues (win->scrolled_win, XmNhorizontalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb))f	         {sJ           XtCallActionProc (sb, "IncrementDownOrRight", event, params, 1);	         }c     }*   (   if (_key == XK_Up || _key == XK_KP_Up)     {*       Widget sb;       String params[1];/              params[0] = "0";       >       XtVaGetValues (win->scrolled_win, XmNverticalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb))e	         {hG           XtCallActionProc (sb, "IncrementUpOrLeft", event, params, 1); 	         }e     }e   ,   if (_key == XK_Left || _key == XK_KP_Left)     {e       Widget sb;       String params[1];n              params[0] = "1";       @       XtVaGetValues (win->scrolled_win, XmNhorizontalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb))-	         {-G           XtCallActionProc (sb, "IncrementUpOrLeft", event, params, 1);h	         }i     }R* if (!(Rdata.kiosk || Rdata.kioskNoExit)) {     I   /* News Hotkeys ...  < > = prev/next thread  , . = prev/next message */ +   if(_key == XK_less) /* <<<<<<<<< HERE! */w     gui_news_prevt(win);   if(_key == XK_greater)     gui_news_nextt(win);   if(_key == XK_comma)     gui_news_prev(win);t   if(_key == XK_period)t     gui_news_next(win);g     /* Annotate. */e#   if (_key == XK_A || _key == XK_a)t=     mo_post_annotate_win (win, 0, 0, NULL, NULL, NULL, NULL);*  
   /* Back. */*#   if (_key == XK_B || _key == XK_b)*     mo_back_node (win);m      /* Clone. */#   if (_key == XK_C || _key == XK_c)h     mo_duplicate_window (win);     /* Document source. */#   if (_key == XK_D || _key == XK_d)r      mo_post_source_window (win);        /* Edit copy window */  #   if (_key == XK_E || _key == XK_e)r     mo_edit_source (win);t     /* Forward. */#   if (_key == XK_F || _key == XK_f)o     mo_forward_node (win);      /* History window. */t   if (_key == XK_H)      mo_post_hotlist_win (win);   if (_key == XK_h)*     mo_post_history_win (win);     /* Open local. */)#   if (_key == XK_L || _key == XK_l)h$     mo_post_open_local_window (win);      /* Mail to. */#   if (_key == XK_M || _key == XK_m)a     mo_post_mail_window (win);     /* New window. */*#   if (_key == XK_N || _key == XK_n))<     mo_open_another_window (win, home_document, NULL, NULL);   
   /* Open. */o#   if (_key == XK_O || _key == XK_o)x     mo_post_open_window (win);     /* Print. */#   if (_key == XK_P || _key == XK_p)f     mo_post_print_window (win);f     /* Reload. */S   if (_key == XK_r)k#     mo_reload_window_text (win, 0);     (   /* Refresh. */   if (_key == XK_R) !     mo_refresh_window_text (win);     /   /* Search. */n#   if (_key == XK_S || _key == XK_s)e      mo_post_search_window (win); }_      if (!Rdata.kioskNoExit) {      if (_key == XK_Escape)       mo_delete_window (win);a     }o   	   return;n }a     #ifndef NOMETER ' /* Callback to redraw the meter -bjs */tH static void ResizeMeter(Widget meter, XtPointer client, XtPointer call);    E static void DrawMeter(Widget meter, XtPointer client, XtPointer call)  {e*     mo_window *win = (mo_window *) client;
     GC gc;        gc = XtGetGC( meter,0,NULL);  E     if(win->meter_width== -1) ResizeMeter(meter,(XtPointer)win,NULL);m      /*+   fprintf(stderr,"DM: (%d,%d) level: %d\n",uA             win->meter_width,win->meter_height,win->meter_level);,             */  7     XSetForeground( XtDisplay(meter),gc,win->meter_bg);e7     XFillRectangle(XtDisplay(meter),XtWindow(meter),gc, - 		   0,0,win->meter_width,win->meter_height);   7     XSetForeground( XtDisplay(meter),gc,win->meter_fg);l7     XFillRectangle(XtDisplay(meter),XtWindow(meter),gc,s5 		   0,0,((win->meter_width * win->meter_level)/100),e&                    win->meter_height); 		         XtReleaseGC(meter,gc);      }   G static void ResizeMeter(Widget meter, XtPointer client, XtPointer call)A {o     XWindowAttributes wattr;*     mo_window *win = (mo_window *) client;        if(!XtWindow(meter)) return;     B     XGetWindowAttributes(XtDisplay(meter),XtWindow(meter),&wattr);  #     win->meter_width = wattr.width;p%     win->meter_height = wattr.height;_  
         /*-     fprintf(stderr,"RM: (%d,%d) level: %d\n",wA             win->meter_width,win->meter_height,win->meter_level);m             */ }r   #endif   /* Exported to libwww2 */o# void mo_gui_update_meter(int level)w {> #ifndef NOMETER).     if(current_win->meter_level == -1) return;     if(level<0) level = 0;     if(level>100) level = 100;%     current_win->meter_level = level;/     @     DrawMeter(current_win->meter,(XtPointer) current_win, NULL); #endif }n    M /****************************************************************************p$  * name:    mo_fill_window (PRIVATE)D  * purpose: Take a new (empty) mo_window struct and fill in all the   *          GUI elements.   * inputs:  "  *   - mo_window *win: The window.  * returns:   *   mo_succeedi  * remarks:   *   xN  ****************************************************************************/0 static mo_status mo_fill_window (mo_window *win) {J   Widget form; /*  Widget frame, rc;*/r    Widget title_label, url_label;  !   form = XmxMakeForm (win->base);      /* Create the menubar. */o6   win->menubar = mo_make_document_view_menubar (form);  <   XmxRSetToggleState (win->menubar, win->font_size, XmxSet);  !   /* setup news default states */d=   XmxRSetToggleState (win->menubar, mo_news_fmt0, XmxNotSet);d:   XmxRSetToggleState (win->menubar, mo_news_fmt1, XmxSet);     win->binary_transfer = 0;-7   XmxRSetToggleState (win->menubar, mo_binary_transfer,-C                       (win->binary_transfer ? XmxSet : XmxNotSet));i #ifndef NOT_BSN    win->binary_ftp_mode = 1;    binary_ftp_mode = 1;7   XmxRSetToggleState (win->menubar, mo_binary_ftp_mode,dC                       (win->binary_ftp_mode ? XmxSet : XmxNotSet));*! #endif /* VMS ftp servers, BSN */*3   win->delay_image_loads = Rdata.delay_image_loads;e9   XmxRSetToggleState (win->menubar, mo_delay_image_loads,aE                       (win->delay_image_loads ? XmxSet : XmxNotSet));e;   XmxRSetSensitive (win->menubar, mo_expand_images_current,sM                     win->delay_image_loads ? XmxSensitive : XmxNotSensitive); =   XmxRSetSensitive (win->menubar, mo_annotate, XmxSensitive);0E   XmxRSetSensitive (win->menubar, mo_annotate_edit, XmxNotSensitive);lG   XmxRSetSensitive (win->menubar, mo_annotate_delete, XmxNotSensitive);s  A   tableSupportEnabled = win->table_support = Rdata.enable_tables;k5   XmxRSetToggleState (win->menubar, mo_table_support,eA                       (win->table_support ? XmxSet : XmxNotSet));d   #ifdef HAVE_AUDIO_ANNOTATIONS/D   /* If we're not audio capable, don't provide the menubar entry. */   if (!mo_audio_capable ())_H     XmxRSetSensitive (win->menubar, mo_audio_annotate, XmxNotSensitive); #endif   #ifdef HAVE_DTMw%   mo_set_dtm_menubar_functions (win);i #endif  .   title_label = XmxMakeLabel (form, "Title:");.   XmxSetArg (XmNcursorPositionVisible, False);!   XmxSetArg (XmNeditable, False);l,   win->title_text = XmxMakeTextField (form);     ,   if (!(Rdata.kiosk || Rdata.kioskNoExit)) {,     url_label = XmxMakeLabel (form, "URL:");/     XmxSetArg (XmNcursorPositionVisible, True);b"     XmxSetArg (XmNeditable, True);,     win->url_text = XmxMakeTextField (form);=     XmxAddCallbackToText (win->url_text, url_field_cb, NULL);*     }w   else {,     url_label = XmxMakeLabel (form, "URL:");     XtUnmanageChild(url_label);(0     XmxSetArg (XmNcursorPositionVisible, False);#     XmxSetArg (XmNeditable, False);),     win->url_text = XmxMakeTextField (form);#     XtUnmanageChild(win->url_text);n     };  Q   win->logo = XmxMakeNamedPushButton (form, NULL, "logo", icon_pressed_cb, NULL);o  3       xmosaic_right_pix = XmxCreatePixmapFromBitmapa=         (win->logo, xmosaic_right_bits, xmosaic_right_width, f          xmosaic_right_height);l2       xmosaic_left_pix = XmxCreatePixmapFromBitmap;         (win->logo, xmosaic_left_bits, xmosaic_left_width,            xmosaic_left_height);0       xmosaic_up_pix = XmxCreatePixmapFromBitmap1         (win->logo, xmosaic_bits, xmosaic_width, s          xmosaic_height); 2       xmosaic_down_pix = XmxCreatePixmapFromBitmap;         (win->logo, xmosaic_down_bits, xmosaic_down_width, r          xmosaic_down_height);     if (IconsMade)     {a"        XmxApplyPixmapToLabelWidget 	    (win->logo, IconPix[0]);e     }[   else     { "        XmxApplyPixmapToLabelWidget! 	    (win->logo, xmosaic_up_pix);r     }(     XmxSetArg (WbNtext, NULL);   win->last_width = 0;,   XmxSetArg (XmNresizePolicy, XmRESIZE_ANY);O   XmxSetArg (WbNpreviouslyVisitedTestFunction, (long)anchor_visited_predicate);sF   XmxSetArg (WbNpointerMotionCallback, (long)pointer_motion_callback);=   XmxSetArg (WbNfancySelections, win->pretty ? True : False); H   XmxSetArg (WbNdelayImageLoads, win->delay_image_loads ? True : False);$   XmxSetArg (XmNshadowThickness, 2);>   win->scrolled_win = XtCreateWidget ("view", htmlWidgetClass,>                                       form, Xmx_wargs, Xmx_n);$   XtManageChild (win->scrolled_win);.   mo_register_image_resolution_function (win);F   XmxAddCallback (win->scrolled_win, WbNanchorCallback, anchor_cb, 0);H   XmxAddCallback (win->scrolled_win, WbNlinkCallback, link_callback, 0);<   XmxAddCallback (win->scrolled_win, WbNsubmitFormCallback, +                   submit_form_callback, 0);      Xmx_n = 0;*   XmxSetArg (WbNview, (long)(&win->view));4   XtGetValues (win->scrolled_win, Xmx_wargs, Xmx_n);     XmxAddEventHandler;     (win->view, KeyPressMask, mo_view_keypress_handler, 0);   ,   XmxSetArg (XmNresizePolicy, XmRESIZE_ANY);!   XmxSetArg (XmNresizable, True);=(   win->bottom_form = XmxMakeForm (form);   %   /* Children of win->bottom_form. */t   {n#     if (Rdata.track_pointer_motion)r       {e8         XmxSetArg (XmNalignment, XmALIGNMENT_BEGINNING);B         win->tracker_label = XmxMakeLabel (win->bottom_form, " ");       }t  "     XmxSetArg (XmNmarginWidth, 0);#     XmxSetArg (XmNmarginHeight, 0); )     XmxSetArg (XmNpacking, XmPACK_TIGHT);0#     XmxSetArg (XmNresizable, True); C     win->button_rc = XmxMakeHorizontalRowColumn (win->bottom_form);r  %     /* Children of win->button_rc. */      {c+       win->back_button = XmxMakePushButton /6         (win->button_rc, "Back", menubar_cb, mo_back);.       win->forward_button = XmxMakePushButton <         (win->button_rc, "Forward", menubar_cb, mo_forward);*       win->home_button = XmxMakePushButton?         (win->button_rc, "Home", menubar_cb, mo_home_document);f/       if (!(Rdata.kiosk || Rdata.kioskNoExit)) i 	{$         if (!Rdata.simple_interface)0           win->reload_button = XmxMakePushButtonG             (win->button_rc, "Reload", menubar_cb, mo_reload_document); $         if (!Rdata.simple_interface).           win->open_button = XmxMakePushButtonF             (win->button_rc, "Open...", menubar_cb, mo_open_document);-         win->save_button = XmxMakePushButton lG           (win->button_rc, "Save As...", menubar_cb, mo_save_document);u.         win->clone_button = XmxMakePushButton A           (win->button_rc, "Clone", menubar_cb, mo_clone_window);a$         if (!Rdata.simple_interface)-           win->new_button = XmxMakePushButtonf?             (win->button_rc, "New", menubar_cb, mo_new_window);o   	}       if (!Rdata.kioskNoExit) { .         win->close_button = XmxMakePushButton A           (win->button_rc, "Close", menubar_cb, mo_close_window);c 	}     }l #ifndef NOMETER 2     if (!(Rdata.kiosk || Rdata.simple_interface)){G         win->meter_frame = XmxMakeFrame(win->bottom_form, XmxShadowIn); $ 	win->meter = XtCreateManagedWidget ( 	    ("meter", xmDrawingAreaWidgetClass,! 	     win->meter_frame, NULL, 0);r0  	XmxSetOffsets (win->meter_frame, 0, 5, 5, 10); 	if (Rdata.useTextButtonBar) { 		XmxSetConstraints=? 			(win->meter_frame, XmATTACH_OPPOSITE_WIDGET, XmATTACH_FORM,  : 			 XmATTACH_WIDGET, XmATTACH_FORM, win->button_rc, NULL,  			 win->button_rc, NULL); 	} 	else {n 		XmxSetConstraints ? 			(win->meter_frame, XmATTACH_OPPOSITE_WIDGET, XmATTACH_FORM, (9 			 XmATTACH_WIDGET, XmATTACH_FORM, win->security, NULL, * 			 win->security, NULL);i 	}   	win->meter_level = 0; 	 - 	XtAddCallback(win->meter, XmNexposeCallback, $ 		      DrawMeter, (XtPointer) win);  - 	XtAddCallback(win->meter, XmNresizeCallback,k& 		      ResizeMeter, (XtPointer) win);           win->meter_width = -1;  "             /* grab some colors */	         { !             XColor ccell1,ccell2;   N             XAllocNamedColor(dsp,DefaultColormapOfScreen(XtScreen(win->base)),3                              Rdata.meterForeground, .                              &ccell1,&ccell2);)             win->meter_fg = ccell2.pixel;n  N             XAllocNamedColor(dsp,DefaultColormapOfScreen(XtScreen(win->base)),3                              Rdata.meterBackground, .                              &ccell1,&ccell2);)             win->meter_bg = ccell2.pixel;n	         }a                        /* 	XtVaGetValues(url_label,w& 		      XmNforeground, &win->meter_fg, 		      NULL); 	XtVaGetValues(win->url_text,E& 		      XmNbackground, &win->meter_bg, 		      NULL);                       */     } else {& 	win->meter_level = -1; /* no meter */     }n #endif  #     if (Rdata.track_pointer_motion)_       {_8         XmxSetOffsets (win->tracker_label, 2, 0, 5, 10);         XmxSetConstraints K           (win->tracker_label, XmATTACH_FORM, XmATTACH_NONE, XmATTACH_FORM,,2            XmATTACH_FORM, NULL, NULL, NULL, NULL);4         XmxSetOffsets (win->button_rc, 0, 5, 5, 10);         XmxSetConstraints*I           (win->button_rc, XmATTACH_WIDGET, XmATTACH_FORM, XmATTACH_FORM,oE            XmATTACH_NONE/*F*/, win->tracker_label, NULL, NULL, NULL);        }o     else       {d4         XmxSetOffsets (win->button_rc, 0, 5, 5, 10);         XmxSetConstraints I           (win->button_rc, XmATTACH_WIDGET, XmATTACH_FORM, XmATTACH_FORM,*7            XmATTACH_NONE/*F*/, NULL, NULL, NULL, NULL);i       }a         ;   } /* in v27b1, this placed after the #endif above, GEC */*      /* Constraints for form. */*   XmxSetConstraints E     (win->menubar->base, XmATTACH_FORM, XmATTACH_NONE, XmATTACH_FORM, ,      XmATTACH_FORM, NULL, NULL, NULL, NULL);  '   /* Top to menubar, bottom to nothing,c'      left to form, right to nothing. */t,   XmxSetOffsets (title_label, 13, 0, 10, 0);   XmxSetConstraints      (title_label, C      XmATTACH_WIDGET, XmATTACH_NONE, XmATTACH_FORM, XmATTACH_NONE, (+      win->menubar->base, NULL, NULL, NULL); '   /* Top to menubar, bottom to nothing,*+      Left to title label, right to logo. */ .   XmxSetOffsets (win->title_text, 9, 1, 9, 8);   XmxSetConstraints      (win->title_text, G      XmATTACH_WIDGET, XmATTACH_NONE, XmATTACH_WIDGET, XmATTACH_WIDGET,  7      win->menubar->base, NULL, title_label, win->logo); *   /* Top to title text, bottom to nothing,'      left to form, right to nothing. */B*   XmxSetOffsets (url_label, 16, 0, 10, 0);   XmxSetConstraintstN     (url_label, XmATTACH_WIDGET, XmATTACH_NONE, XmATTACH_FORM, XmATTACH_NONE, (      win->title_text, NULL, NULL, NULL);*   /* Top to title text, bottom to nothing,)      Left to url label, right to logo. */P-   XmxSetOffsets (win->url_text, 12, 1, 8, 8);_   XmxSetConstraints      (win->url_text, G      XmATTACH_WIDGET, XmATTACH_NONE, XmATTACH_WIDGET, XmATTACH_WIDGET,  2      win->title_text, NULL, url_label, win->logo);'   /* Top to menubar, bottom to nothing,('      left to nothing, right to form. */a(   XmxSetOffsets (win->logo, 8, 0, 0, 7);   XmxSetConstraintsD     (win->logo, C      XmATTACH_WIDGET, XmATTACH_NONE, XmATTACH_NONE, XmATTACH_FORM,  +      win->menubar->base, NULL, NULL, NULL);   (   /* Top to logo, bottom to bottom form,$      Left to form, right to form. */0   XmxSetOffsets (win->scrolled_win, 7, 2, 7, 7);   XmxSetConstraints(     (win->scrolled_win, E      XmATTACH_WIDGET, XmATTACH_WIDGET, XmATTACH_FORM, XmATTACH_FORM, c.      win->logo, win->bottom_form, NULL, NULL);   0   XmxSetOffsets (win->bottom_form, 10, 2, 2, 2);   XmxSetConstraints C     (win->bottom_form, XmATTACH_NONE, XmATTACH_FORM, XmATTACH_FORM,;,      XmATTACH_FORM, NULL, NULL, NULL, NULL);  C   /* Can't go back or forward if we haven't gone anywhere yet... */    mo_back_impossible (win);s   mo_forward_impossible (win);     return mo_succeed; }t    M /****************************************************************************e  * name:    mo_delete_window  * purpose: Shut down a window.]  * inputs:  "  *   - mo_window *win: The window.  * returns:   *   mo_succeedn  * remarks: F  *   This can be called, among other places, from the WM_DELETE_WINDOWL  *   handler.  By the time we get here, we must assume the window is already&  *   in the middle of being shut down.E  *   We must explicitly close every dialog that be open as a child ofiI  *   the window, because window managers too stupid to do that themselves *  *   will otherwise allow them to stay up.N  ****************************************************************************/ #define POPDOWN(x) \&   if (win->x) XtUnmanageChild (win->x)  + mo_status mo_delete_window (mo_window *win)  {    mo_node *node;     if (!win)R     return mo_fail;      node = win->history;     POPDOWN (source_win);,   POPDOWN (save_win);*   POPDOWN (savebinary_win);<   POPDOWN (open_win);    POPDOWN (mail_win);    POPDOWN (mailhist_win);    POPDOWN (print_win);   POPDOWN (history_win);   POPDOWN (open_local_win);e   if (win->hotlist_win)_&     XtDestroyWidget(win->hotlist_win);   POPDOWN (whine_win);   POPDOWN (annotate_win);n   POPDOWN (search_win);L   POPDOWN (searchindex_win);   POPDOWN (mailto_win);    POPDOWN (news_win);    POPDOWN (links_win); #ifdef HAVE_DTM    POPDOWN (dtmout_win);  #endif #ifdef HAVE_AUDIO_ANNOTATIONS    POPDOWN (audio_annotate_win);/ #endif   XtPopdown (win->base);  /   /* Free up some of the HTML Widget's state */E(   HTMLFreeImageInfo (win->scrolled_win);     while (node)     {e       mo_node *tofree = node;a       node = node->next;!       mo_free_node_data (tofree);n       free (tofree);     }w      free (win->search_start);    free (win->search_end);n  ?   /* This will free the win structure (but none of its elementseF      individually) and exit if this is the last window in the list. */#   mo_remove_window_from_list (win);/  #   /* Go get another current_win. */ 4   mo_set_current_cached_win (mo_next_window (NULL));     return mo_succeed; }y    @ int mo_get_font_size_from_res(char *userfontstr,int *fontfamily) { +   char *lowerfontstr = strdup(userfontstr);y
   int   x;  '   for (x=0; x<strlen(userfontstr); x++)t,     lowerfontstr[x]=tolower(userfontstr[x]);      *fontfamily = 0;*   if (strstr(lowerfontstr, "times")!=NULL)     { .       if (strstr(lowerfontstr, "large")!=NULL) 	return mo_large_fonts; 0       if (strstr(lowerfontstr, "regular")!=NULL) 	return mo_regular_fonts;y.       if (strstr(lowerfontstr, "small")!=NULL) 	return mo_small_fonts;f       return mo_regular_fonts;     }=.   if (strstr(lowerfontstr, "helvetica")!=NULL)     {        *fontfamily = 1;.       if (strstr(lowerfontstr, "large")!=NULL) 	return mo_large_helvetica;e0       if (strstr(lowerfontstr, "regular")!=NULL) 	return mo_regular_helvetica;i.       if (strstr(lowerfontstr, "small")!=NULL) 	return mo_small_helvetica;w"       return mo_regular_helvetica;     }G,   if (strstr(lowerfontstr, "century")!=NULL)     {        *fontfamily = 2;.       if (strstr(lowerfontstr, "large")!=NULL) 	return mo_large_newcentury;0       if (strstr(lowerfontstr, "regular")!=NULL) 	return mo_regular_newcentury;.       if (strstr(lowerfontstr, "small")!=NULL) 	return mo_small_newcentury;#       return mo_regular_newcentury;      }0+   if (strstr(lowerfontstr, "lucida")!=NULL)      {e       *fontfamily = 3;.       if (strstr(lowerfontstr, "large")!=NULL) 	return mo_large_lucidabright;0       if (strstr(lowerfontstr, "regular")!=NULL)  	return mo_regular_lucidabright;.       if (strstr(lowerfontstr, "small")!=NULL) 	return mo_small_lucidabright;%       return mo_regular_lucidabright;o     }a   return mo_regular_fonts; }  a    M /****************************************************************************;-  * name:    mo_open_window_internal (PRIVATE)r8  * purpose: Make a mo_window struct and fill up the GUI.  * inputs:  D  *   - Widget       base: The dialog widget on which this window is &  *                        to be based.F  *   - mo_window *parent: The parent mo_window struct for this window,:  *                        if one exists; this can be NULL.  * returns: "  *   The new window (mo_window *).  * remarks: D  *   This routine must set to 0 all elements in the mo_window structD  *   that can be tested by various routines to see if various things6  *   have been done yet (popup windows created, etc.).N  ****************************************************************************/J static mo_window *mo_open_window_internal (Widget base, mo_window *parent) {w   mo_window *win;s  1   win = (mo_window *)malloc (sizeof (mo_window));     win->id = XmxMakeNewUniqid ();   XmxSetUniqid (win->id);s     win->base = base;*     win->source_win = 0;   win->save_win = 0;   win->savebinary_win = 0;;   win->open_win = win->open_text = win->open_local_win = 0;iK   win->mail_win = win->mailhot_win = win->edithot_win = win->mailhist_win =l     win->inserthot_win = 0;a   win->print_win = 0; +   win->history_win = win->history_list = 0;=+   win->hotlist_win = win->hotlist_list = 0;m'   win->whine_win = win->whine_text = 0;_)   win->mailto_win = win->mailto_text = 0;t   win->news_win = 0;   win->links_win = 0;    win->news_fsb_win = 0;   win->annotate_win = 0;-   win->search_win = win->search_win_text = 0;nT   win->searchindex_win = win->searchindex_win_label = win->searchindex_win_text = 0;0   win->cci_win = win->cci_win_text = (Widget) 0;<   win->cci_accept_toggle = win->cci_off_toggle = (Widget) 0; #ifdef HAVE_DTM )   win->dtmout_win = win->dtmout_text = 0;b #endif #ifdef HAVE_AUDIO_ANNOTATIONS    win->audio_annotate_win = 0; #endif     win->history = NULL;   win->current_node = 0;   win->reloading = 0;a   win->source_text = 0;m   win->format_optmenu = 0;   win->save_format = 0;a   if (!parent) {I     win->font_size = mo_get_font_size_from_res(Rdata.default_font_choice,( 			&(win->font_family));*     /*win->font_size = mo_regular_fonts;*/     /*win->font_family = 0;*/ 
   } else {'     win->font_size = parent->font_size; +     win->font_family = parent->font_family;i   }i     win->underlines_snarfed = 0;   if (!parent)2     win->underlines_state = mo_default_underlines;   else5     win->underlines_state = parent->underlines_state;o  /   win->pretty = Rdata.default_fancy_selections;i     win->mail_format = 0;t   #ifdef HAVE_AUDIO_ANNOTATIONSa   win->record_fnam = 0;x   win->record_pid = 0; #endif      win->print_text = 0;   win->print_format = 0;     win->target_anchor = 0; +   /* Create search_start and search_end. */i;   win->search_start = (void *)malloc (sizeof (ElementRef));d9   win->search_end = (void *)malloc (sizeof (ElementRef));)   #ifdef ISINDEX   /* We don't know yet. */$   win->keyword_search_possible = -1; #endif   *   /* Install all the GUI bits & pieces. */   mo_fill_window (win);   /   /* Register win with internal window list. */    mo_add_window_to_list (win);     /* Pop the window up. */"   XtPopup (win->base, XtGrabNone);   XFlush (dsp);u   XSync (dsp, False);N     if (!IconsMade)      {l&       MakeAnimationPixmaps(win->logo);       IconsMade = 1;!       XmxApplyPixmapToLabelWidget $             (win->logo, IconPix[0]);       logo_count = 0;;     }t     /* Set the font size. */)   if (win->font_size != mo_regular_fonts)e'     mo_set_fonts (win, win->font_size);       /* Set the underline state. */1   mo_set_underlines (win, win->underlines_state);   >   /* Set the fancy selections toggle to the starting value. */'   mo_set_fancy_selections_toggle (win);i  
   return win;t }x    M /****************************************************************************   * name:    delete_cb (PRIVATE) 7  * purpose: Callback for the WM_DELETE_WINDOW protocol.w  * inputs:    *   - as per XmxCallback_  * returns:   *   nothing  * remarks: G  *   By the time we get called here, the window has already been poppeds3  *   down.  Just call mo_delete_window to clean up. N  ****************************************************************************/ static XmxCallback (delete_cb) { ,   mo_window *win = (mo_window *)client_data;   mo_delete_window (win);l	   return;b }i    M /****************************************************************************T$  * name:    mo_make_window (PRIVATE)+  * purpose: Make a new window from scratch.U  * inputs:  ;  *   - Widget      parent: Parent for the new window shell. F  *   - mo_window *parentw: Parent window, if one exists (may be NULL).  * returns: "  *   The new window (mo_window *).  * remarks: C  *   The 'parent window' parentw is the window being cloned, or the A  *   window in which the 'new window' command was triggered, etc. D  *   Some GUI properties are inherited from it, if it exists (fonts,  *   anchor appearance, etc.).N  ****************************************************************************/D static mo_window *mo_make_window (Widget parent, mo_window *parentw) {n   Widget base;   mo_window *win;-   Atom WM_DELETE_WINDOW; #ifndef NOT_BSN,# #include "bitmaps/xmosaic_icon.xbm"_   Pixmap icon_pixmap;i #endif /* BSN */  ;   XmxSetArg (XmNtitle, (long)"NCSA Mosaic: Document View"); *   XmxSetArg (XmNiconName, (long)"Mosaic");)   XmxSetArg (XmNallowShellResize, False);) #ifndef NOT_BSN C   icon_pixmap = XCreateBitmapFromData(dsp, XDefaultRootWindow(dsp),n@     xmosaic_icon_bits, xmosaic_icon_width, xmosaic_icon_height);)   XmxSetArg (XmNiconPixmap, icon_pixmap);A #endif /* BSN, icon pixmap */,?   base = XtCreatePopupShell ("shell", topLevelShellWidgetClass,d9                              toplevel, Xmx_wargs, Xmx_n);n   Xmx_n = 0;   #ifdef EDITRES_SUPPORT  .   XtAddEventHandler(base, (EventMask) 0, TRUE,C                     (XtEventHandler) _XEditResCheckMessages, NULL);  #endif  0   win = mo_open_window_internal (base, parentw);  B   WM_DELETE_WINDOW = XmInternAtom(dsp, "WM_DELETE_WINDOW", False);M   XmAddWMProtocolCallback(base, WM_DELETE_WINDOW, delete_cb, (XtPointer)win);n   
   return win;  }     M /****************************************************************************t5  * name:    mo_open_another_window_internal (PRIVATE)a6  * purpose: Open a new window from an existing window.  * inputs:  &  *   - mo_window *win: The old window.  * returns: "  *   The new window (mo_window *).  * remarks: >  *   This routine handles (optional) autoplace of new windows.N  ****************************************************************************/B static mo_window *mo_open_another_window_internal (mo_window *win) {t   Dimension oldx, oldy;c8   Dimension scrx = WidthOfScreen (XtScreen (win->base));9   Dimension scry = HeightOfScreen (XtScreen (win->base));    Dimension x, y;r   Dimension width, height;   mo_window *newwin;  5   XtVaGetValues (win->base, XmNx, &oldx, XmNy, &oldy,n=                  XmNwidth, &width, XmNheight, &height, NULL);   D   /* Ideally we open down and over 40 pixels... is this possible? */   /* If not, deal with it... */o  >   /* Bug fix, thanks to Ken Shores <kss1376@pop.draper.com> */   C   /* the original test did not handle the case where the old window F    * was exactly the same size as the screen.  Also, it used a looping>    * algorithm which would infinite loop under such a case. */      if ((oldx+width) > (scrx-40))       x = (scrx - (oldx + width));   else     x = oldx + 40;       if ((oldy+height) > (scry-40))!     y = (scry - (oldy + height));o   else     y = oldy + 40;     if (x > scrx) x = 0;   if (y > scry) y = 0;   (   XmxSetArg (XmNdefaultPosition, False);   if (Rdata.auto_place_windows)>     {r       char geom[20];'       sprintf (geom, "+%d+%d\0", x, y);s*       XmxSetArg (XmNgeometry, (long)geom);     }I   XmxSetArg (XmNwidth, width);    XmxSetArg (XmNheight, height);  *   newwin = mo_make_window (toplevel, win);%   mo_set_current_cached_win (newwin);(   return newwin; }T    M /****************************************************************************c  * name:    mo_open_window2  * purpose: Open a new window to view a given URL.  * inputs:  H  *   - Widget      parent: The parent Widget for the new window's shell.=  *   - char          *url: The URL to view in the new window.eJ  *   - mo_window *parentw: The (optional) parent window of the new window.  * returns:   *   The new window.  * remarks:   *   cN  ****************************************************************************/H mo_window *mo_open_window (Widget parent, char *url, mo_window *parentw) {    mo_window *win;l  )   win = mo_make_window (parent, parentw);l  "   mo_set_current_cached_win (win);  '   mo_load_window_text (win, url, NULL);i  
   return win;  }     M /****************************************************************************c  * name:    mo_duplicate_window A  * purpose: Clone a existing window as intelligently as possible.a  * inputs:  +  *   - mo_window *win: The existing window.	  * returns:   *   The new window.  * remarks:   *   bN  ****************************************************************************// mo_window *mo_duplicate_window (mo_window *win)n {e:   mo_window *neww = mo_open_another_window_internal (win);   '   mo_duplicate_window_text (win, neww);5     return neww; }t      M /****************************************************************************O"  * name:    mo_open_another_windowC  * purpose: Open another window to view a given URL, unless the URL 2  *          indicates that it's pointless to do so  * inputs:  0  *   - mo_window      *win: The existing window.>  *   - char           *url: The URL to view in the new window.L  *   - char           *ref: The reference (hyperlink text contents) for this-  *                          URL; can be NULL.wF  *   - char *target_anchor: The target anchor to view open opening the+  *                          window, if any.)  * returns:   *   The new window.  * remarks:   *   rN  ****************************************************************************/H mo_window *mo_open_another_window (mo_window *win, char *url, char *ref,7                                    char *target_anchor)T {t   mo_window *neww;  >   /* Check for reference to telnet.  Never open another windowF      if reference to telnet exists; instead, call mo_load_window_text,D      which knows how to manage current window's access to telnet. */ #ifndef VMS>E   if (!strncmp (url, "telnet:", 7) || !strncmp (url, "tn3270:", 7) ||i#       !strncmp (url, "rlogin:", 7))  #else.O   if (!strncasecomp (url, "telnet:", 7) || !strncasecomp (url, "tn3270:", 7) ||w(       !strncasecomp (url, "rlogin:", 7)) #endif /* VMS, GEC */I     {m+       mo_load_window_text (win, url, NULL);L       return NULL;     }   
   mo_busy ();l  /   neww = mo_open_another_window_internal (win);tC   /* Set it here; hope it gets handled in mo_load_window_text_firstt       (it probably won't, now. */&   neww->target_anchor = target_anchor;'   mo_load_window_text (neww, url, ref);      return neww; }     N /* ------------------------------------------------------------------------ */  
 char **gargv; 
 int gargc;   #ifndef VMS)N extern MO_SIGHANDLER_RETURNTYPE ProcessExternalDirective (MO_SIGHANDLER_ARGS); #else /* BSN */G' extern void ProcessExternalDirective();e$ extern void InitExternalDirective(); #endif   #ifdef HAVE_DTMn static XmxCallback (blip)i {    mo_dtm_poll_and_read ();  Q   XtAppAddTimeOut (app_context, 100, (XtTimerCallbackProc)blip, (XtPointer)True);C   	   return;A }N #endif   #ifdef HAVE_DTMH% mo_status mo_register_dtm_blip (void), {L1   /* Set a timer that will poll DTM regularly. */rQ   XtAppAddTimeOut (app_context, 100, (XtTimerCallbackProc)blip, (XtPointer)True);       return mo_succeed; }  #endif    M /****************************************************************************R   * name:    fire_er_up (PRIVATE)H  * purpose: Callback from timer that actually starts up the application,)  *          i.e., opens the first window.,  * inputs:    *   - as per XmxCallbackO  * returns: 
  *   Nothing.L  * remarks: >  *   This routine figures out what the home document should be%  *   and then calls mo_open_window().iN  ****************************************************************************/ static XmxCallback (fire_er_up)* {*   char *home_opt;*   mo_window *win;:  ?   /* Pick up default or overridden value out of X resources. */ &   home_document = Rdata.home_document;  H /* if this is a prerelease, change the default home page to the preleaseH    warning page, but only if the user uses the default NCSA home page */ #ifdef PRERELEASEe8   if (strcmp(Rdata.home_document, HOME_PAGE_DEFAULT)==0)g     home_document = strdup ("http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/PrereleaseWarningPage.html");n #endif  >   /* Value of environment variable WWW_HOME overrides that. *//   if ((home_opt = getenv ("WWW_HOME")) != NULL)*     home_document = home_opt;*  
 #ifdef VMSF   /* Value specified on command line overrides everything.      lll */F   if ((cmdline_homeDocument != NULL))                   /*      lll */F     home_document = cmdline_homeDocument;               /*      lll */ #endif /* VMS, LLL */v  ;   /* Value of argv[1], if it exists, sets startup_document. >      (All other command-line flags will have been picked up by"      the X resource mechanism.) */)   if (gargc > 1 && gargv[1] && *gargv[1])h      startup_document = gargv[1];  8   /* Check for proper home document URL construction. */#   if (!strstr (home_document, ":")) >     home_document = mo_url_canonicalize_local (home_document);:   if (startup_document && !strstr (startup_document, ":"))D     startup_document = mo_url_canonicalize_local (startup_document);  ,   XmxSetArg (XmNwidth, Rdata.default_width);.   XmxSetArg (XmNheight, Rdata.default_height);  "   if (Rdata.initial_window_iconic)      XmxSetArg (XmNiconic, True);     win = mo_open_window  J     (toplevel, startup_document ? startup_document : home_document, NULL);     /* Check the Comment Card */   CommentCard(win);c  	   return;  }e    M /****************************************************************************e"  * name:    mo_open_initial_windowC  * purpose: This routine is called when we know we want to open thet)  *          initial Document View window..  * inputs:  	  *   nonec  * returns:   *   mo_succeed;B  * remarks: This routine is simply a stub that sets a timeout thatD  *          calls fire_er_up() after 10 milliseconds, which does the  *          actual work.N  ****************************************************************************/' mo_status mo_open_initial_window (void)s {l@   /* Set a timer that will actually cause the window to open. */$   XtAppAddTimeOut (app_context, 10, E                    (XtTimerCallbackProc)fire_er_up, (XtPointer)True);g     return mo_succeed; }s    M /****************************************************************************_&  * name:    mo_error_handler (PRIVATE)  * purpose: Handle X errors.  * inputs:  )  *   - Display       *dsp: The X display."5  *   - XErrorEvent *event: The error event to handle.(  * returns: $  *   0, if it doesn't force an exit.  * remarks: @  *   The main reason for this handler is to keep the applicationE  *   from crashing on BadAccess errors during calls to XFreeColors().sN  ****************************************************************************/> static int mo_error_handler (Display *dsp, XErrorEvent *event) {    char buf[128];  K   XUngrabPointer (dsp, CurrentTime);   /* in case error occurred in Grab */l  0   /* BadAlloc errors (on a XCreatePixmap() call)C      and BadAccess errors on XFreeColors are 'ignoreable' errors */w
 #ifdef VMSB   /* VMS: BadWindow error on XGetWindowAttributes is also ignored.,      D. Potterveld, Argonne National Lab. */ #endif /* VMS */&   if (event->error_code == BadAlloc ||
 #ifdef VMSE       (event->error_code == BadWindow && event->request_code == 3) ||N #endif /* VMS */E       (event->error_code == BadAccess && event->request_code == 88)) e
     return 0;_   else       { )       /* All other errors are 'fatal'. */*7       XGetErrorText (dsp, event->error_code, buf, 128);i-       fprintf (stderr, "X Error: %s\n", buf);_E       fprintf (stderr, "  Major Opcode:  %d\n", event->request_code);a  )       /* Try to close down gracefully. */        mo_exit ();      } (  return 0; /* never makes it here.... */ }a    M /****************************************************************************i  * name:    mo_do_guirG  * purpose: This is basically the real main routine of the application.   * inputs:  (  *   - int    argc: Number of arguments.(  *   - char **argv: The argument vector.  * returns:   *   nothing  * remarks:   *   pN  ****************************************************************************/& void mo_do_gui (int argc, char **argv) {d
 #ifdef VMSA   /* Make temp files in SYS$SCRATCH if TMPDIR not defined. PGE */w(   char sys_scratch[] = "SYS$SCRATCH:\0";   char mbx_name[64];   XtInputId mo_InputId;(   int use_mbx = 0;   int grp_mbx = 0;   int j; #endif /* VMS, BSN, PGE */ #ifdef MONO_DEFAULT    int use_color = 0; #else;   int use_color = 1; #endif   int no_defaults = 0;   int color_set = 0;   char* display_name = 0;n   Display* dpy;i     int i;  
 #ifdef VMS   mbx_name[0] = '\0';  #endif /* VMS */5   /* Loop through the args before passing them off toiC      XtAppInitialize() in case we need to catch something first. */n   for (i = 1; i < argc; i++)     {- #ifndef VMS=%       if (!strcmp (argv[i], "-mono"))s 	{           use_color = 0;           color_set = 1; 	}&       if (!strcmp (argv[i], "-color")) 	{           use_color = 1; w           color_set = 1; 	}#       if (!strcmp (argv[i], "-nd"))  	{           no_defaults = 1; 	}(       if (!strcmp (argv[i], "-display")) 	{ 	  display_name = argv[i + 1];           i++; 	} #else_(        if (!strcmp (argv[i], "-mono")) {         use_color = 0;         color_set = 1;         argv[i] = NULL;i/       } else if (!strcmp (argv[i], "-color")) {i         use_color = 1;         color_set = 1;         argv[i] = NULL; ,       } else if (!strcmp (argv[i], "-nd")) {         no_defaults = 1;         argv[i] = NULL;d-       } else if (!strcmp (argv[i], "-mbx")) {          use_mbx = 1;         argv[i] = NULL; 1       } else if (!strcmp (argv[i], "-mbx_grp")) {n         use_mbx = 1;         grp_mbx = 1;         argv[i] = NULL;i2       } else if (!strcmp (argv[i], "-mbx_name")) {         use_mbx = 1;%         strcpy (mbx_name, argv[i+1]);          argv[i] = NULL;e         argv[i+1] = NULL;s         i++;1       } else if (!strcmp (argv[i], "-display")) { +         display_name = strdup(argv[i + 1]);N         argv[i] = NULL;_         argv[i+1] = NULL;i         i++;F /*                                                              lll */F /*    Need to distinguish between Xresource homepage and        lll */F /*    commandline homepage; set a pointer to the commandline    lll */F /*    argument if present.                                      lll */F /*                                                              lll */.       } else if (!strcmp (argv[i], "-home")) {7         cmdline_homeDocument = strdup (argv[i + 1]);   .:         argv[i] = NULL;                                            argv[i+1] = NULL;e.         i++;                                  ?       } /* GEC for LLL */                                      s #endif /* VMS, BSN */n     } 
 #ifdef VMS /*  * Remove used arguments.   */    j = 0;   for (i = 1; i < argc; i++) {"     if (argv[i] == NULL) continue;     j++;     argv[j] = argv[i];   }r   argc = j + 1;  #endif /* VMS, BSN */n       /*?    * Awful expensive to open and close the display just to findn    * the depth information.     */t7   if (!color_set && (dpy = XOpenDisplay(display_name)))      {f=       use_color = DisplayPlanes(dpy, DefaultScreen(dpy)) > 1;*       XCloseDisplay(dpy);*     }*
 #ifdef VMS   free(display_name);  #endif /* VMS, BSN */       /* Motif setup. */   XmxStartup ();*   XmxSetArg (XmNmappedWhenManaged, False);   if (no_defaults)     {r!       toplevel = XtAppInitialize  =         (&app_context, "Mosaic", options, XtNumber (options),e.          &argc, argv, NULL, Xmx_wargs, Xmx_n);     }l   else     {*       if (use_color)	         {*%           toplevel = XtAppInitialize  A             (&app_context, "Mosaic", options, XtNumber (options),)=              &argc, argv, color_resources, Xmx_wargs, Xmx_n);*	         }*
       else	         {*%           toplevel = XtAppInitialize TA             (&app_context, "Mosaic", options, XtNumber (options),o<              &argc, argv, mono_resources, Xmx_wargs, Xmx_n);	         }      }d  (   /* Needed for picread.c, right now. */   dsp = XtDisplay (toplevel);    {.     XVisualInfo vinfo, *vptr;n     int cnt;          vinfo.visualid = '       XVisualIDFromVisualh         (DefaultVisual (dsp,.                         DefaultScreen (dsp)));<     vptr = XGetVisualInfo (dsp, VisualIDMask, &vinfo, &cnt);     Vclass = vptr->class;,     XFree((char *)vptr);   }.   F   XtVaGetApplicationResources (toplevel, (XtPointer)&Rdata, resources,;                                XtNumber (resources), NULL);d   &   XSetErrorHandler (mo_error_handler);   #ifdef __sgi.   /* Turn on debugging malloc if necessary. */   if (Rdata.debugging_malloc)i     mallopt (M_DEBUG, 1);/ #endif  )   global_xterm_str = Rdata.xterm_command;:  0   uncompress_program = Rdata.uncompress_command;(   gunzip_program = Rdata.gunzip_command;  0   tweak_gopher_types = Rdata.tweak_gopher_types;0   max_wais_responses = Rdata.max_wais_responses;  1   proxy_list = ReadProxies(Rdata.proxy_specfile);o7   noproxy_list = ReadNoProxies(Rdata.noproxy_specfile);e  >   use_default_extension_map = Rdata.use_default_extension_map;4   global_extension_map = Rdata.global_extension_map;#   if (Rdata.personal_extension_map)      { #       char *home = getenv ("HOME");d        #ifndef VMSE       if (!home)         home = "/tmp"; #endif /* VMS, BSN */s       .       personal_extension_map = (char *)malloc D         (strlen (home) + strlen (Rdata.personal_extension_map) + 8); #ifndef VMSD7       sprintf (personal_extension_map, "%s/%s\0", home,I #elsee6       sprintf (personal_extension_map, "%s%s\0", home, #endif /* VMS, BSN */*-                Rdata.personal_extension_map);*     }    else"     personal_extension_map = "\0";  4   use_default_type_map = Rdata.use_default_type_map;*   global_type_map = Rdata.global_type_map;   if (Rdata.personal_type_map)     { #       char *home = getenv ("HOME");m        #ifndef VMSt       if (!home)         home = "/tmp"; #endif /* VMS, BSN */*       )       personal_type_map = (char *)malloc *?         (strlen (home) + strlen (Rdata.personal_type_map) + 8);_ #ifndef VMS 2       sprintf (personal_type_map, "%s/%s\0", home, #elsee1       sprintf (personal_type_map, "%s%s\0", home,h #endif /* VMS, BSN */n(                Rdata.personal_type_map);     },   else     personal_type_map = "\0";a   #ifdef HAVE_HDFe   have_hdf = 1;N #elsey   have_hdf = 0;  #endif  *   twirl_increment = Rdata.twirl_increment;     /* First get the hostname. */ 0   machine = (char *)malloc (sizeof (char) * 64);   gethostname (machine, 64);     {s' #if !defined(VMS) || defined(VMS_POSIX)/       uname(&mo_uname);e, #endif /* Need POSIX for this on VMS, GEC */       HTAppVersion = e%     	(char *)malloc (sizeof(char) * (d 			strlen(MO_VERSION_STRING) +' #if !defined(VMS) || defined(VMS_POSIX)/ 			strlen(mo_uname.sysname) +  			strlen(mo_uname.release) + # 			strlen(mo_uname.machine) + 20));  #elsef 			50)); #endif /* VMS, GEC */ .   	sprintf(HTAppVersion, "%s (X11;%s %s %s)",  				MO_VERSION_STRING,' #if !defined(VMS) || defined(VMS_POSIX)  				mo_uname.sysname,P 				mo_uname.release,( 				mo_uname.machine); #else % 				"OpenVMS","Unknown","VAX_ALPHA");  #endif /* VMS, GEC */)   }    7   /* Then make a copy of the hostname for shortmachine.       Don't even ask. */S"   shortmachine = strdup (machine);   1   /* Then find out the full name, if possible. */c   if (Rdata.full_hostname)     {i       free (machine);*$       machine = Rdata.full_hostname;     }*(   else if (!Rdata.gethostbyname_is_evil)     {        struct hostent *phe;       $       phe = gethostbyname (machine);       if (phe && phe->h_name)i	         {e           free (machine);-)           machine = strdup (phe->h_name); 	         }e     }-G   /* (Otherwise machine just remains whatever gethostname returned.) */r   C   machine_with_domain = (strlen (machine) > strlen (shortmachine) ?*1                          machine : shortmachine);*  E   {/* Author Name & Email init crap.  - bjs */  /* from v27b1, GEC */a #ifndef VMS /       struct passwd *pw = getpwuid (getuid ());t #elset&       struct passwd *pw = getpwuid (); #endif /* VMS, BSN */t       char *cc;L       &       if(!Rdata.default_author_name) {;           Rdata.default_author_name = strdup(pw->pw_gecos);c9           strcpy(Rdata.default_author_name,pw->pw_gecos);s6           for(cc = Rdata.default_author_name;*cc;cc++)               if(*cc==',') {                   *cc=0;                   break;               }*       }*'       if(!Rdata.default_author_email) {*&           Rdata.default_author_email =E               (char *) malloc(strlen(pw->pw_name)+strlen(machine)+2);oJ           sprintf(Rdata.default_author_email,"%s@%s",pw->pw_name,machine);       }    u   }w< #ifdef VMS /* Drop blanks off the mail prefix string. GEC */   {*       char *cc;*.       for(cc = Rdata.vms_mail_prefix;*cc;cc++)           if(*cc==' ') {               *cc=0;               break;           }a    } #endif /* VMS, GEC */   A   /* If there's no tmp directory assigned by the X resource, then*      look at TMPDIR. */    if (!Rdata.tmp_directory)n     {*J #ifdef VMS /* Make temp files in SYS$SCRATCH if TMPDIR not defined. PGE */.       Rdata.tmp_directory = getenv ("TMPDIR");       if (!Rdata.tmp_directory)a*         Rdata.tmp_directory = sys_scratch; #else .       Rdata.tmp_directory = getenv ("TMPDIR"); #endif /* VMS, GEC for PGE */ C       /* It can still be NULL when we leave here -- then we'll just*.          let tmpnam() do what it does best. */     }m  =   /* If there's no docs directory assigned by the X resource, <      then look at MOSAIC_DOCS_DIRECTORY environment variable&      and then at hardcoded default. */   if (!Rdata.docs_directory)     {o>       Rdata.docs_directory = getenv ("MOSAIC_DOCS_DIRECTORY");        if (!Rdata.docs_directory)6         Rdata.docs_directory = DOCS_DIRECTORY_DEFAULT;<       if (!Rdata.docs_directory || !*(Rdata.docs_directory))	         {,H           fprintf (stderr, "fatal error: nonexistent docs directory\n");           exit (-1);	         }      }s     if (Rdata.use_global_history)e     mo_setup_global_history ();    else     mo_init_global_history ();     mo_setup_default_hotlist ();(   mo_write_default_hotlist (); /* amb */   mo_setup_pan_list ();    #ifndef VMS &   /* Write pid into "~/.mosaicpid". */ #elsesJ   /* Write pid into "~/mosaicpid.". and delete a possible previous file */9   /* Changed now, just delete a possible previous file */; #endif /* VMS, BSN */-   {-(     char *home = getenv ("HOME"), *fnam;
     FILE *fp;/      #ifndef VMS      if (!home)       home = "/tmp"; #endif /* VMS, BSN */r     /     fnam = (char *)malloc (strlen (home) + 32);B #ifndef VMSn*     sprintf (fnam, "%s/.mosaicpid", home); #elset)     sprintf (fnam, "%smosaicpid.", home);_     remove (fnam); #endif /* VMS, BSN */d      #ifdef NOT_BSN     fp = fopen (fnam, "w");e     if (fp)i       {c #ifndef VMSX'         fprintf (fp, "%d\n", getpid());d #elsei'         fprintf (fp, "%x\n", getpid());_ #endif /* VMS, BSN */S         fclose (fp);       }e #endif /* Not needed, BSN */          free (fnam);   }C      {o(     Widget foo = XmxMakeForm (toplevel);<     XmString xmstr = XmxMakeXmstrFromString ("NCSA Mosaic");,     XmxSetArg (XmNlabelString, (long)xmstr);@     Xmx_w = XtCreateManagedWidget ("blargh", xmLabelGadgetClass,:                                    foo, Xmx_wargs, Xmx_n);     XmStringFree (xmstr);*     Xmx_n = 0;   }   2   busy_cursor = XCreateFontCursor (dsp, XC_watch);     XtRealizeWidget (toplevel);      gargv = argv;o   gargc = argc;    #ifndef VMSa-   signal (SIGUSR1, ProcessExternalDirective);* #else /* BSN */*   if (use_mbx) { /*F  * Reserve event flag and initalize mailbox on VMS for remote control.  */o%     i = LIB$FREE_EF(&mbx_event_flag);o(     i = LIB$RESERVE_EF(&mbx_event_flag);     if (i & 1) {G       mo_InputId = XtAppAddInput(app_context, mbx_event_flag, mbx_iosb,h(         ProcessExternalDirective, NULL);/       InitExternalDirective(grp_mbx, mbx_name);p     }    }f #endif     defer_initial_window = 0;o     if (!defer_initial_window)     mo_open_initial_window ();   #ifdef DEBUG4   printf("cciPort resourced to %d\n",Rdata.cciPort); #endif:   if ((Rdata.cciPort > 1023 ) &&  (Rdata.cciPort < 65536))   {	- 	MoCCIStartListening(toplevel,Rdata.cciPort);U   }      XtAppMainLoop (app_context); }d    M /****************************************************************************f)  * name:    mo_process_external_directive E  * purpose: Handle an external directive given to the application via 8  *          a config file read in response to a SIGUSR1.  * inputs:  A  *   - char *directive: The directive; either "goto" or "newwin".e?  *   - char       *url: The URL corresponding to the directive..  * returns:   *   nothing  * remarks:   *    N  ****************************************************************************/$ #define CLIP_TRAILING_NEWLINE(url) \&   if (url[strlen (url) - 1] == '\n') \!     url[strlen (url) - 1] = '\0';;  6 static XEvent *mo_manufacture_dummy_event (Widget foo) { "   /* This is fucking hilarious. */:   XAnyEvent *a = (XAnyEvent *)malloc (sizeof (XAnyEvent));   a->type = 1; /* HAHA! */"   a->serial = 1; /* HAHA AGAIN! */   a->send_event = False;   a->display = XtDisplay (foo);X   a->window = XtWindow (foo);o   return (XEvent *)a;e },  ? void mo_process_external_directive (char *directive, char *url)* {e8   /* Process a directive that we received externally. */   mo_window *win = current_win;*  #   /* Make sure we have a window. */*   if (!win)e      win = mo_next_window (NULL);  &   if (!strncmp (directive, "goto", 4))     {o!       CLIP_TRAILING_NEWLINE(url);   $       mo_access_document (win, url);  "       XmUpdateDisplay (win->base);     }e-   else if (!strncmp (directive, "newwin", 6))h     { !       CLIP_TRAILING_NEWLINE(url);i  (       /* Force a new window to open. */ 4       mo_open_another_window (win, url, NULL, NULL);  "       XmUpdateDisplay (win->base);     }*/   else if (!strncmp (directive, "pagedown", 8))d     {        Widget sb;       String params[1];h              params[0] = "0";       >       XtVaGetValues (win->scrolled_win, XmNverticalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb))*	         {*:           XEvent *event = mo_manufacture_dummy_event (sb);E           XtCallActionProc (sb, "PageDownOrRight", event, params, 1); 	         }s  "       XmUpdateDisplay (win->base);     }o-   else if (!strncmp (directive, "pageup", 6))r     {        Widget sb;       String params[1];r         params[0] = "0";  >       XtVaGetValues (win->scrolled_win, XmNverticalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb))*	         {*:           XEvent *event = mo_manufacture_dummy_event (sb);B           XtCallActionProc (sb, "PageUpOrLeft", event, params, 1);	         }g"       XmUpdateDisplay (win->base);     } 1   else if (!strncmp (directive, "scrolldown", 9))(     {r       Widget sb;       String params[1];r              params[0] = "0";       >       XtVaGetValues (win->scrolled_win, XmNverticalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb)) 	         {f:           XEvent *event = mo_manufacture_dummy_event (sb);J           XtCallActionProc (sb, "IncrementDownOrRight", event, params, 1);	         }e"       XmUpdateDisplay (win->base);     }s/   else if (!strncmp (directive, "scrollup", 7))      {        Widget sb;       String params[1];          params[0] = "0";  >       XtVaGetValues (win->scrolled_win, XmNverticalScrollBar, (                      (long)(&sb), NULL);!       if (sb && XtIsManaged (sb))a	         {*:           XEvent *event = mo_manufacture_dummy_event (sb);G           XtCallActionProc (sb, "IncrementUpOrLeft", event, params, 1);*	         }*"       XmUpdateDisplay (win->base);     }*7   else if (!strncmp (directive, "flushimagecache", 15))      {l!       mo_flush_image_cache (win);      }t/   else if (!strncmp (directive, "backnode", 8))*     {a       mo_back_node (win);o"       XmUpdateDisplay (win->base);     } 3   else if (!strncmp (directive, "forwardnode", 11))*     {*       mo_forward_node (win);"       XmUpdateDisplay (win->base);     }i6   else if (!strncmp (directive, "reloaddocument", 14))     {i%       mo_reload_window_text (win, 0);Y"       XmUpdateDisplay (win->base);     }n4   else if (!strncmp (directive, "reloadimages", 12))     { %       mo_reload_window_text (win, 1);d"       XmUpdateDisplay (win->base);     }s.   else if (!strncmp (directive, "refresh", 7))     {;#       mo_refresh_window_text (win);a"       XmUpdateDisplay (win->base);     }    #ifndef NOT_DUNS /*M  * The following commands were added by Mark Donszelmann, duns@vxdeop.cern.cho  */i.   else if (!strncmp (directive, "iconify", 7))     {hD       XIconifyWindow(dsp, XtWindow(win->base), XtScreen(win->base));     }(0   else if (!strncmp (directive, "deiconify", 9))     {;+       XMapWindow(dsp, XtWindow(win->base));r     }g,   else if (!strncmp (directive, "raise", 5))     { +       XMapRaised(dsp, XtWindow(win->base));a     } +   else if (!strncmp (directive, "move", 4))      {f        char *status;/        if ((status = strchr(url, '|')) != NULL)         {           *status = '\0';!           status++;n        }D        XMoveWindow(dsp, XtWindow(win->base),atoi(url),atoi(status));     } -   else if (!strncmp (directive, "resize", 6))      {_        char *status;/        if ((status = strchr(url, '|')) != NULL)l        {           *status = '\0';            status++;;        }F        XResizeWindow(dsp, XtWindow(win->base),atoi(url),atoi(status));     }b% #endif /* BSN for Mark Donszelmann */ 	   return;! }c