M /**************************************************************************** M  * NCSA Mosaic for the X Window System                                      * M  * Software Development Group                                               * M  * National Center for Supercomputing Applications                          * M  * University of Illinois at Urbana-Champaign                               * M  * 605 E. Springfield, Champaign IL 61820                                   * M  * mosaic@ncsa.uiuc.edu                                                     * M  *                                                                          * M  * Copyright (C) 1993, Board of Trustees of the University of Illinois      * M  *                                                                          * M  * NCSA Mosaic software, both binary and source (hereafter, Software) is    * M  * copyrighted by The Board of Trustees of the University of Illinois       * M  * (UI), and ownership remains with the UI.                                 * M  *                                                                          * M  * The UI grants you (hereafter, Licensee) a license to use the Software    * M  * for academic, research and internal business purposes only, without a    * M  * fee.  Licensee may distribute the binary and source code (if released)   * M  * to third parties provided that the copyright notice and this statement   * M  * appears on all copies and that no charge is associated with such         * M  * copies.                                                                  * M  *                                                                          * M  * Licensee may make derivative works.  However, if Licensee distributes    * M  * any derivative work based on or derived from the Software, then          * M  * Licensee will (1) notify NCSA regarding its distribution of the          * M  * derivative work, and (2) clearly notify users that such derivative       * M  * work is a modified version and not the original NCSA Mosaic              * M  * distributed by the UI.                                                   * M  *                                                                          * M  * Any Licensee wishing to make commercial use of the Software should       * M  * contact the UI, c/o NCSA, to negotiate an appropriate license for such   * M  * commercial use.  Commercial use includes (1) integration of all or       * M  * part of the source code into a product for sale or license by or on      * M  * behalf of Licensee to third parties, or (2) distribution of the binary   * M  * code or source code to third parties that need it to utilize a           * M  * commercial product sold or licensed by or on behalf of Licensee.         * M  *                                                                          * M  * UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR   * M  * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          * M  * WARRANTY.  THE UI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY THE    * M  * USERS OF THIS SOFTWARE.                                                  * M  *                                                                          * M  * By using or copying this Software, Licensee agrees to abide by the       * M  * copyright law and all other applicable laws of the U.S. including, but   * M  * not limited to, export control laws, and the terms of this license.      * M  * UI shall have the right to terminate this license immediately by         * M  * written notice upon Licensee's breach of, or non-compliance with, any    * M  * of its terms.  Licensee may be held legally responsible for any          * M  * copyright infringement that is caused or encouraged by Licensee's        * M  * failure to abide by the terms of this license.                           * M  *                                                                          * M  * Comments and questions are welcome and can be sent to                    * M  * mosaic-x@ncsa.uiuc.edu.                                                  * N  ****************************************************************************/   /* SOCKS mods by: %  * Ying-Da Lee, <ylee@syl.dl.nec.com>   * NEC Systems Laboratory !  * C&C Software Technology Center   */    #include "mosaic.h"  #include <signal.h>  #ifndef VMS  #include <sys/wait.h>  #include <sys/utsname.h> #else  #include <iodef.h> #include <descrip.h> #include <errno.h> #define DVI$_DEVNAM 32 #define LNM$_STRING 2  static int has_mbx = 0;  static short mbx_channel;  static char mbx_buf[100];  void InitExternalDirective ();P unsigned long mbx_event_flag = 23; /* Must be a flag in first cluster ( <32 ) */ unsigned short mbx_iosb[4]; / extern void application_user_feedback (char *);  #ifdef VMS_POSIX" #include "posix$include:utsname.h" #endif #endif /* VMS, BSN, GEC */  	 /* swp */  #include "kcms.h"    void mo_exit (void)  {    mo_write_default_hotlist ();   if (Rdata.use_global_history)      mo_write_global_history ();    mo_write_pan_list ();    #ifdef HAVE_DTM    mo_dtm_disconnect ();  #endif     exit (0);  }    #ifndef VMS F MO_SIGHANDLER_RETURNTYPE ProcessExternalDirective (MO_SIGHANDLER_ARGS) {    char filename[64];7   char line[MO_LINE_LENGTH], *status, *directive, *url;    FILE *fp; I   extern void mo_process_external_directive (char *directive, char *url);      signal (SIGUSR1, SIG_IGN);  (   /* Construct filename from our pid. */2   sprintf (filename, "/tmp/Mosaic.%d", getpid ());     fp = fopen (filename, "r"); 
   if (!fp)     goto done;  ,   status = fgets (line, MO_LINE_LENGTH, fp);   if (!status || !(*line))     goto done;   directive = strdup (line);  9   /* We now allow URL to not exist, since some directives       don't need it. */,   status = fgets (line, MO_LINE_LENGTH, fp);   if (!status || !(*line))     url = strdup ("dummy");    else     url = strdup (line);   1   mo_process_external_directive (directive, url);      free (directive);     done:-   signal (SIGUSR1, ProcessExternalDirective); 	   return;  }    #else ? void ProcessExternalDirective (char *cd, int *s, XtInputId *id)  { !   char *status, *directive, *url; I   extern void mo_process_external_directive (char *directive, char *url);   $   if (!(mbx_iosb[0] & 1)) goto done;"   if (mbx_iosb[1] <= 0) goto done;   mbx_buf[mbx_iosb[1]] = '\0';   directive = mbx_buf;  9   /* We now allow URL to not exist, since some directives       don't need it. */0   if ((status = strchr(mbx_buf, '|')) != NULL) {     *status = '\0'; 
     status++;      url = status;    }    1   mo_process_external_directive (directive, url);    done:    InitExternalDirective(0, 0);	   return;  }      void6 InitExternalDirective (int grp_mbx, char *mbx_name_in) { !   char mbx_name[64], mbx_dev[64];      if (has_mbx == 0) { 
     int retl; %     $DESCRIPTOR (mbx_desc, mbx_name); 4     $DESCRIPTOR (tab_desc, "LNM$PROCESS_DIRECTORY");8     $DESCRIPTOR (log_desc, "LNM$TEMPORARY_MAILBOX");         struct itm3 {        short bfl, code;       char *bufadr;        int *retlen;       int term; 
     } itm;     long promsk = 0xff00;   <     if ((mbx_name_in == NULL) || (mbx_name_in[0] == '\0')) {#       strcpy (mbx_name, "MOSAIC_"); (       strcat (mbx_name, getenv("USER"));     } else {%       strcpy (mbx_name, mbx_name_in);      } -     mbx_desc.dsc$w_length = strlen(mbx_name);  /*B  * Create a mailbox named from -mbx_name name command line option,B  * or default MOSAIC_<userid>. Only owner and system can access it  * unless grp_mbx is set.   */      if (grp_mbx) {       promsk = 0xf000;       itm.bfl = 9;       itm.code = LNM$_STRING;         itm.bufadr = &"LNM$GROUP";       itm.retlen = &retl;        itm.term = 0;        /*E  * Define/Table=LNM$PROCESS_DIRECTORY LNM$TEMPORARY_MAILBOX LNM$GROUP -  * to enter mailbox name in group name table.   */ @       if (!(sys$crelnm(0, &tab_desc, &log_desc, 0, &itm) & 1)) {         char *str;1         str = (char *) malloc (256*sizeof(char)); Z         sprintf (str, "Could not enter the mailbox name in the group table.\nError: %s\0",&          strerror(errno, vaxc$errno));(         application_user_feedback (str);         free (str);        }      } P     if (!(sys$crembx (0, &mbx_channel, 0, 0, promsk, 0, &mbx_desc, 0, 0) & 1)) {       char *str;/       str = (char *) malloc (256*sizeof(char)); G       sprintf (str, "Could not open mailbox %s\nError: %s\0", mbx_name, $        strerror(errno, vaxc$errno));       if (grp_mbx) strcat (str, ]          "\nCheck your Mosaic process privileges (GRPNAM is needed for a group mailbox).\0"); (       application_user_feedback (str);         free (str);        has_mbx = -1;      } else {0       char *home = getenv ("HOME"), *fnam, *str;       FILE *fp;          has_mbx = 1;        itm.bfl = sizeof(mbx_dev);       itm.code = DVI$_DEVNAM;        itm.bufadr = mbx_dev;        itm.retlen = &retl;        itm.term = 0; C       if ((sys$getdvi (0, mbx_channel, 0, &itm, 0, 0, 0, 0) & 1)) { 1         str = (char *) malloc (256*sizeof(char));          sprintf (str, P          "Mailbox for external directive processing is device %s\nName: %s\n\0",          mbx_dev, mbx_name);         if (grp_mbx)D           strcat (str, "The name is in the group logical table.\0");         elseK           strcat (str, "The name is in the process logical table only.\0"); 3         fnam = (char *)malloc (strlen (home) + 32); -         sprintf (fnam, "%smosaic.mbx", home);          remove (fnam);         fp = fopen (fnam, "w");          if (fp) { 5           fprintf (fp, "%s %s\n", mbx_dev, mbx_name);            fclose (fp);	         } (         application_user_feedback (str);         free (fnam);         free (str);        }      }  /*H  * Deassign LNM$TEMPORARY_MAILBOX (LNM$GROUP) from LNM$PROCESS_DIRECTORY  */      if (grp_mbx)*       sys$dellnm(&tab_desc, &log_desc, 0);   }  /*"  * Start to listen to the mailbox.  */    if (has_mbx == 1) { M     if (!(sys$qio (mbx_event_flag, mbx_channel, IO$_READVBLK, mbx_iosb, 0, 0, 2      mbx_buf, sizeof(mbx_buf), 0, 0, 0, 0) & 1)) {       char *str;/       str = (char *) malloc (256*sizeof(char)); E       sprintf (str, "Could not init read on mailbox %s\nError: %s\0", .        mbx_name, strerror(errno, vaxc$errno));&       application_user_feedback (str);       free (str);      }    }  }  #endif /* VMS, BSN */    static void RealFatal (void) {    signal (SIGBUS, 0);    signal (SIGSEGV, 0);   signal (SIGILL, 0);  #ifndef VMS    abort ();  #else  /*(  * Make an exit with abort fault status.  */    exit (44); #endif /* VMS, BSN */  }    #ifdef __STDC__ " static void FatalProblem (int sig) #else /* not __STDC__ */ #ifdef _HPUX_SOURCE , static MO_SIGHANDLER_RETURNTYPE FatalProblem-   (int sig, int code, struct sigcontext *scp, #                         char *addr)  #else , static MO_SIGHANDLER_RETURNTYPE FatalProblem9   (int sig, int code, struct sigcontext *scp, char *addr)  #endif #endif /* not __STDC__ */  {  #ifndef VMS C   fprintf (stderr, "\nCongratulations, you have found a bug in\n"); C   fprintf (stderr, "NCSA Mosaic %s on %s.\n\n", MO_VERSION_STRING,              MO_MACHINE_TYPE);H   fprintf (stderr, "If a core file was generated in your directory,\n");L   fprintf (stderr, "please run 'dbx Mosaic' (or 'dbx /path/Mosaic' if the\n\6 Mosaic executable is not in your current directory)\n\ and then type:\n"); %   fprintf (stderr, "  dbx> where\n"); d   fprintf (stderr, "and mail the results, and a description of what you were doing at the time,\n");A   fprintf (stderr, "to %s.  We thank you for your support.\n\n",  !            MO_DEVELOPER_ADDRESS);  #else  #define SYI$_HW_NAME 4362  #define SYI$_VERSION 4096  #define JPI$_PAGFILCNT 1044  #define JPI$_PGFLQUOTA 1038   *   char hardware[32], VMS_version[16], *cp;#   int status, pagfilcnt, pgflquota; '   unsigned short l_hardware, l_version;    struct  dsc$descriptor_s {    unsigned short  dsc$w_length;    unsigned char   dsc$b_dtype;   unsigned char   dsc$b_class;!   char            *dsc$a_pointer; 6 } hardware_desc = {sizeof(hardware), 14, 1, hardware},?   VMS_version_desc = {sizeof(VMS_version), 14, 1, VMS_version};   T   fprintf (stderr, "\nCongratulations, you may have found a bug in (your copy of)");C   fprintf (stderr, "NCSA Mosaic %s on %s.\n\n", MO_VERSION_STRING,              MO_MACHINE_TYPE);@   status = lib$getjpi (&JPI$_PAGFILCNT, 0, 0, &pagfilcnt, 0, 0);@   status = lib$getjpi (&JPI$_PGFLQUOTA, 0, 0, &pgflquota, 0, 0);O   fprintf (stderr, "\nRemaining page file quota %d, maximum virtual size %d\n",      pagfilcnt, pgflquota);   if (pagfilcnt < 1000) { g     fprintf (stderr, "You have probably run out of page file quota. An absolute minimum for Mosaic\n"); g     fprintf (stderr, "is 40000 pages, but more will help.  Your systems person should increase the\n"); W     fprintf (stderr, "Authorize parameter pgflquo for your account. But read on...\n");    }   f   fprintf (stderr, "\nIf you did not read the README.VMS-2_x file carefully before installing, it\n");d   fprintf (stderr, "might be a good time to do it now. If there were any compilation or linking\n");]   fprintf (stderr, "errors, you should try to find the reason for them and correct them.\n"); d   fprintf (stderr, "If this does not help,  please take note of what happened in as much detail\n");N   fprintf (stderr, "as possible and send mail to cook@wvnvms.wvnet.edu.\n\n");L   status = lib$getsyi (&SYI$_HW_NAME, 0, &hardware_desc, &l_hardware, 0, 0);N   status = lib$getsyi (&SYI$_VERSION, 0, &VMS_version_desc, &l_version, 0, 0);   hardware[l_hardware] = '\0';    VMS_version[l_version] = '\0';;   for (cp = &VMS_version[l_version-1]; VMS_version; cp--) {      if (*cp != ' ') break;     *cp = '\0';    } l   fprintf (stderr, "Your system version appears to be %s running on %s hardware.\n", VMS_version, hardware); #ifdef MULTINET 9   fprintf (stderr, "The TCP/IP software is MultiNet.\n"); 
 #elif WIN_TCP B   fprintf (stderr, "The TCP/IP software is Pathway.\n"); /* BGT */ #elif SOCKETSHR /* BGT */ K   fprintf (stderr, "The TCP/IP software is SOCKETSHR/NETLIB.\n"); /* BGT */  #else 4   fprintf (stderr, "The TCP/IP software is UCX.\n"); #endif /* TCP/IP flavour */  #ifdef MOTIF1_23O   fprintf (stderr, "Your Mosaic executable was generated using Motif 1.2-3\n");  #else  #ifdef MOTIF1_2 M   fprintf (stderr, "Your Mosaic executable was generated using Motif 1.2\n");  #else M   fprintf (stderr, "Your Mosaic executable was generated using Motif 1.1\n");  #endif #endif   cp = getenv("SYS$LOGIN");    if (cp == NULL) >     fprintf (stderr, "The logical SYS$LOGIN is undefined.\n");   elseA     fprintf (stderr, "The logical SYS$LOGIN points to %s\n", cp);    cp = getenv("SYS$SCRATCH");    if (cp == NULL) @     fprintf (stderr, "The logical SYS$SCRATCH is undefined.\n");   elseC     fprintf (stderr, "The logical SYS$SCRATCH points to %s\n", cp);  #endif /* VMS, BSN */ 6   fprintf (stderr, "...exiting NCSA Mosaic now.\n\n");     RealFatal ();  }      #ifndef VMS  #ifdef THIS_NOT_WORKING_YET  #ifndef SYSV void clean_child(void) {  #ifndef NEXT     int status;  #else      union wait status; #endif     pid_t pid;   #ifdef SOLARIS:     while( (pid = waitpid((pid_t)(-1),NULL,WNOHANG)) > 0);V     signal(SIGCHLD, (void (*)())clean_child); /*Solaris resets the signal on a catch*/ #else 6     while( (pid = wait3(&status, WNOHANG, NULL)) > 0); #endif }  #endif /* not SYSV */ ! #endif /* THIS_NOT_WORKING_YET */  #endif /* VMS, BSN */        main (int argc, char **argv) { ' #if !defined(VMS) || defined(VMS_POSIX)    struct utsname u;    FILE *fp;  #endif /* VMS_POSIX, GEC */    #ifndef VMS #   extern void InitChildProcessor();     extern void ChildTerminated(); #endif /* VMS, GEC */   ' #if !defined(VMS) || defined(VMS_POSIX)  	if (uname(&u)<0) {  		perror("uname"); 	} 	else { $ 		if (!strcmp(u.sysname,"SunOS") &&  		    (!strcmp(u.release,"5.0") " 		     || !strcmp(u.release,"5.1")" 		     || !strcmp(u.release,"5.2")" 		     || !strcmp(u.release,"5.3")" 		     || !strcmp(u.release,"5.4")& 		     || !strcmp(u.release,"5.5"))) {# 			if (getenv("XKEYSYMDB")==NULL) {*< 				if (!(fp=fopen("/usr/openwin/lib/X11/XKeysymDB","r"))) {9 					if (!(fp=fopen("/usr/openwin/lib/XKeysymDB","r"))) {  						/*Do Nothing*/ 					} 					else {r 						fclose(fp); 5 						putenv("XKEYSYMDB=/usr/openwin/lib/XKeysymDB");t 					} 				}r
 				else { 					fclose(fp);8 					putenv("XKEYSYMDB=/usr/openwin/lib/X11/XKeysymDB"); 				}h 			} 		}  	} #endif /* VMS_POSIX, GEC */6   #ifndef DEBUGVMS    signal (SIGBUS, FatalProblem);!   signal (SIGSEGV, FatalProblem);a    signal (SIGILL, FatalProblem); #endif /* DEBUGVMS, BSN */   #ifndef VMS F   /* Since we're doing lots of TCP, just ignore SIGPIPE altogether. */   signal (SIGPIPE, SIG_IGN);   #ifdef THIS_NOT_WORKING_YETi7   /* If not SYSV we need to clean up execed children */  #ifdef SYSV    signal(SIGCHLD, SIG_IGN);  #elses+   signal(SIGCHLD, (void (*)())clean_child);o #endif /* SYSV */*! #endif /* THIS_NOT_WORKING_YET */e #endif /* VMS, BSN */I     #ifndef VMS    InitChildProcessor();m   #ifdef SYSVI.   signal(SIGCLD, (void (*)())ChildTerminated); #else /   signal(SIGCHLD, (void (*)())ChildTerminated);  #endif #endif /* VMS, GEC */u     #ifdef SOCKS   SOCKSinit(argv[0]);h #endif     CheckKCMS();      mo_do_gui (argc, argv);b }n