 /*<  * This software is COPYRIGHT  1991-1994, Stephane Germain.  * ALL RIGHTS RESERVED. O  * Permission is granted for not-for-profit redistribution, provided all source P  * and object code remain unchanged from the original distribution, and that all#  * copyright notices remain intact.   *L  * This software is provided "AS IS". The author makes no representations orP  * warranties with respect to the software and specifically disclaim any impliedG  * warranties of merchantability or fitness for any particular purpose.   *O  ****************************************************************************** $  * ETHERNET <PROBE> TRAFFIC ANALYZER  *  * This is SYS_PROBE:REPLAY.C   * Creator S.Germain p.eng  * Using   VAX/VMS 5.4,6.1H  * History v1.0  28 Jul 91 - Incorporation of basic formatter (FORMAT.C)7  *                           and fundamental structure. >  *	   v1.1     Aug 91 - Unoptimized functional release subset.K  *	   v2.2     Dec 94 - Removed uncompleted internal loading & display code G  *                           portion. Added data formatting capabitity. O  *                           Added manufacturer/logical prefix search (static).   *
  * CONCEPT  *D  * This image is responsible for all aspects of PROBE post-recordingD  * processing. A network traffic file is provided to the program for  * interpretation and listing.  *  * NOTES  *=  * 1. Conditions are signaled according to VAX/VMS standards. .  * Compilation and linking is done as follows:  *  *    $ CC/NODEBUG REPLAY "  *    $ MESSAGE/OBJECT=MSG2 REPLAY$  *    $ SET COMMAND/OBJECT=TBL TABLE9  *    $ LINK/NODEBUG/NOTRACEBACK REPLAY,MSG2,TBL,CRTL/OPT   *E  * 2. Invocation and run-time information parsing is performed by CLI D  * routines. The command definition in file PROBE.CLD is included in(  * the process command table as follows:  *  *    $ SET COMMAND PROBE   *J  * 3. General user help information is contained in the PROBE.HLP library.  *D  * 4. Where convenient, some VMS-specific calls and library routinesK  * (particularly CLI$) are used. As this affects eventual code portability, J  * these extensions are located in low-level portions of the program call-J  * structure as much as possible and treated as black boxes which could be.  * replaced by functionally equivalent others.  *  * CONSTANTS */    # module  REPLAY  "V2.2"? # define  VERSION 0x0202		/* highest known PROBE data format */ R # define  eth$envelop	18		/* LLC=destination(6)+source(6)+ptcl:length(2)+fcs(4) */* # define  eth$min_data	46		/* IEEE spec */, # define  eth$max_data	1500		/* IEEE spec */0 # define  eth$min_frame	eth$min_data+eth$envelop0 # define  eth$max_frame	eth$max_data+eth$envelop # include <ctype.h>  # include <stdio.h>  # include <stdlib.h>; # include <climsgdef.h>			/* CLI$xxx - DCL parsing codes */ 7 # include <descrip.h>			/* DSC$xxx - VMS descriptors */ 6 # include <ssdef.h>			/*  SS$xxx - VMS status codes */D # include <sys_probe:v22$logdef.h>	/* Probe 2.2-x log file layout */B # include <sys_probe:v22$macros.h>	/* Probe 2.2-x macros etc... */  O /****************************************************************************** O  * GLOBALS                                                                    * P  ******************************************************************************/  5  FILE	  *analysis;			/* OUT: analysis file control */ 0  FILE	  *sample;			/* IN: sample file control */.  FILE	  *table;			/* IN: table file control */.  char	  a_file[81];			/* analysis file name */,  char	  s_file[81];			/* sample file name */+  char	  t_file[81];			/* table file name */   (  char	  adapter[prb$log_adapter_size+1];&  char	  log_node[prb$log_node_size+1];    C_BLOCK  *master_cycle;  N_BLOCK  *node_header;   P_BLOCK  *protocol_header;   >  unsigned long  frame_count = 0;	/* number of sample frames */7  unsigned long	log_record_size;	/* sample entry size */ E  unsigned long  log_payload_size;	/* maximum recorded payload size */   S # define  known		20		/* statically defined known manufacturer address array size */   unsigned char	node[known][3] =  		{  		  0x08, 0x00, 0x2b,	/* DEC */  		  0x08, 0x00, 0x20,	/* SUN */  		  0x08, 0x00, 0x09,	/* HP */ 		  0x08, 0x00, 0x5a,	/* IBM */  		  0x08, 0x00, 0x69,	/* SGI */   		  0x00, 0x00, 0x6b,	/* MIPS */! 		  0x08, 0x00, 0x07,	/* APPLE */   		  0x00, 0x00, 0x0f,	/* NEXT */$ 		  0x08, 0x00, 0x0e,	/* NCR-AT&T */ 		  0x00, 0x00, 0xa7,	/* NCD */ % 		  0x08, 0x00, 0x11,	/* TEKTRONIX */ % 		  0x00, 0x00, 0x1d,	/* CABLETRON */ # 		  0x08, 0x00, 0x8f,	/* CHIPCOM */ % 		  0x00, 0x00, 0x81,	/* SYNOPTICS */ ! 		  0x00, 0x00, 0x0c,	/* CISCO */ % 		  0x00, 0x00, 0xa2,	/* WELLFLEET */ " 		  0x08, 0x00, 0x87,	/* XYPLEX */+ 		  0x00, 0x00, 0x65,	/* NETWORK GENERAL */  		  0x08, 0x00, 0x86,	/* QMS */   		  0x00, 0x00, 0xaa	/* XEROX */ 		} ; !  unsigned char	name[known][8+1] = \ 		{ "DIGITAL", "SUN", "HP", "IBM", "SGI", "MIPS", "APPLE", "NEXT", "NCR/AT&T", "NCD", "TEK",^ 		  "CABLTRON", "CHIPCOM", "SYNOPTIC", "CISCO", "WELLFLT", "XYPLEX", "NETGNRL", "QMS", "XEROX" 		} ;   3  unsigned short patch;			/* revision patch level */   union     { 5     unsigned short level;		/* revision combined id */ 
     struct        {8        unsigned char minor;		/* revision secondary id */6        unsigned char major;		/* revision primary id */        } id;     } revision;     struct      { $     unsigned analysis_specified : 1;%     unsigned analysis_redirected : 1; %     unsigned is_format_collision : 1; $     unsigned is_format_controls : 1;!     unsigned is_format_cycle : 1;       unsigned is_format_data : 1;!     unsigned is_format_frame : 1; "     unsigned is_format_header : 1;!     unsigned is_format_table : 1; (     unsigned process_external_table : 1;&     unsigned sample_was_extracted : 1;#     unsigned sample_from_a_vax : 1;      unsigned : 0; :     } command;				/* overall specified & attained state */  O /****************************************************************************** O  * MAIN PROGRAM                                                               * O  *                                                                            * O  * Each routine at this level is responsible for continuing or aborting       * O  * processing directly. No transit error codes are used... return is implied  * O  * to mean success and pursuit.                                               * P  ******************************************************************************/   main() {   globalref RPL_NODISP;   parse_command_line(); 
 open_files();  read_sample_header();  read_table_definitions();  if (command.analysis_specified)     {    format_environment();    format_sample_data();    } else /* interactive */    {    lib$stop(&RPL_NODISP);     } }   O /****************************************************************************** O  * PARSE_COMMAND_LINE                                                         * O  *                                                                            * O  * This routine determines the overall user requested action and values based * O  * on the initial DCL-syntax command and possible logical name specifications.* P  ******************************************************************************/   parse_command_line() { "  globalref RPL_INVCID, RPL_ALLCYC;    unsigned short id_size;  unsigned char  id_string[6];   	  long  new_value;    C_BLOCK *new_cycle;     D_CONSTANT(analyze,"PRB_ANAZ");  D_CONSTANT(sample,"PRB_PLAY");   D_CONSTANT(table,"PRB_TABL");  D_CONSTANT(a_out,"ANAZ_OUT");  D_CONSTANT(a_all,"CLSS_ALL");  D_CONSTANT(a_col,"CLSS_COL");  D_CONSTANT(a_ctl,"CLSS_CTL");  D_CONSTANT(a_cyc,"CLSS_CYC");  D_CONSTANT(a_dat,"CLSS_DAT");  D_CONSTANT(a_frm,"CLSS_FRM");  D_CONSTANT(a_hdr,"CLSS_HDR");  D_CONSTANT(a_tbl,"CLSS_TBL");  D_CONSTANT(e_cyc,"EXTR_CYC");  D_VARIABLE(spec_a,a_file);   D_VARIABLE(spec_s,s_file);   D_VARIABLE(spec_t,t_file); "  D_VARIABLE(identifier,id_string);   /* load sample file name */   F if (cli$get_value(&sample,&spec_s,&spec_s.dsc$w_length) == SS$_NORMAL)&    s_file[spec_s.dsc$w_length] = '\0'; else!    strcpy(s_file,"RECORDED.PRB");   ' /* load table file name if specified */   ( if (cli$present(&table) == CLI$_PRESENT)H    if (cli$get_value(&table,&spec_t,&spec_t.dsc$w_length) == SS$_NORMAL)       { )       t_file[spec_t.dsc$w_length] = '\0'; )       command.process_external_table = 1;        }   E /* load analysis classes (using defaults) & file name if specified */   * if (cli$present(&analyze) == CLI$_PRESENT)    {"    command.analysis_specified = 1;H    if (cli$get_value(&a_out,&spec_a,&spec_a.dsc$w_length) == SS$_NORMAL)       { )       a_file[spec_a.dsc$w_length] = '\0'; &       command.analysis_redirected = 1;       } G    command.is_format_collision = (cli$present(&a_col) != CLI$_NEGATED); C    command.is_format_cycle = (cli$present(&a_cyc) != CLI$_NEGATED); C    command.is_format_frame = (cli$present(&a_frm) != CLI$_NEGATED); D    command.is_format_header = (cli$present(&a_hdr) != CLI$_NEGATED);C    command.is_format_table = (cli$present(&a_tbl) != CLI$_NEGATED); H    command.is_format_controls = (cli$present(&a_ctl) == CLI$_PRESENT) ||U 				((cli$present(&a_all) == CLI$_PRESENT) && (cli$present(&a_ctl) != CLI$_NEGATED)); D    command.is_format_data = (cli$present(&a_dat) == CLI$_PRESENT) ||U 				((cli$present(&a_all) == CLI$_PRESENT) && (cli$present(&a_dat) != CLI$_NEGATED));     }  H /* prepare master cycle (sample) block & load cycle list if specified */  \ master_cycle = calloc(1,sizeof(C_BLOCK));			/* allocate the cycle/sample linked list head */\ master_cycle->next = master_cycle;				/* initially unique member of forward circular list */a master_cycle->previous = master_cycle;				/* initially unique member of backward circular list */ Q master_cycle->reference_count = 0;				/* default - empty list means all cycles */ U master_cycle->block.sample.max_id = 0;				/* default - permits id=1 list insertion */   ( if (cli$present(&e_cyc) == CLI$_PRESENT)    {F    while ((cli$get_value(&e_cyc,&identifier,&id_size)) != CLI$_ABSENT)       {         id_string[id_size] = '\0';"       new_value = atoi(id_string);Z       if ((new_value <= 0) || (new_value > 32767))		/* reject out of bounds cycle entry */& 	 lib$signal(&RPL_INVCID,1,new_value);/       else							/* accept valid cycle entry */ 
          {c 	 new_cycle = calloc(1,sizeof(C_BLOCK));			/* prepare new entry block and list-search parameters */ ) 	 new_cycle->block.object.id = new_value; `          if (valid(c_connect(new_cycle)))			/* attempt insertion of new cycle into cycle list */( 	    master_cycle->reference_count += 1; 	 else 	    cfree(new_cycle);
          }       } `    if (master_cycle->reference_count == 0)			/* no entry exists on list... dynamic processing */       lib$signal(&RPL_ALLCYC);    } }   O /****************************************************************************** O  * OPEN_FILES                                                                 * O  *                                                                            * O  * This routine opens all input files & (as required) the analysis output     * O  * file. It applies default file types.                                       * P  ******************************************************************************/   open_files() { 2  globalref RPL_NOSAMPLE, RPL_NOACHAN, RPL_EXTABLE;  %  D_CONSTANT(logicals,"LNM$FILE_DEV");   $ /* sample file must be accessible */  < if ((sample = fopen(s_file,"r","dna=RECORDED.PRB")) == NULL)$    lib$stop(&RPL_NOSAMPLE,1,s_file);  0 /* analysis file must be created if specified */   if (command.analysis_specified) Y    if ((analysis = ((command.analysis_redirected) ? fopen(a_file,"w","dna=.PRB_ANALYSIS") V                                                   : fopen("SYS$OUTPUT","w"))) == NULL)       lib$stop(&RPL_NOACHAN);   + /* attempt to access external table file */   # if (command.process_external_table) 6    if ((table = fopen(t_file,"r","dna=.TBL")) == NULL)C       lib$signal(&RPL_EXTABLE), command.process_external_table = 0;  }   O /****************************************************************************** O  * READ_SAMPLE_HEADER                                                         * O  *                                                                            * O  * Get sample master characteristics and additional imbedded node & protocol  * O  * entry definitions. Give priority to any externally loaded definitions.     * P  ******************************************************************************/   read_sample_header() { H  globalref RPL_NEWLVL, RPL_BADREC, RPL_DATALESS, RPL_EMPTY, RPL_NOTAVAX,' 	   RPL_BIGCYC, RPL_CYCOOB, RPL_INCREC;     int i;     C_BLOCK *cycle;  P_BLOCK *new_protocol;   N_BLOCK *new_node;   7 /* extract and validate type and version information */   5 if ((get_data(&log.element[0],8)) && (log.type == 1))     {%    patch = log.prb$intro.patch_level; ]    if ((revision.level = ((log.prb$intro.major_id << 8) | log.prb$intro.minor_id)) > VERSION) H       lib$stop(&RPL_NEWLVL,3,revision.id.major,revision.id.minor,patch);    } else    lib$stop(&RPL_BADREC);   V /* versions prior to V2.2 have different primary layout... extract correct elements */   if (revision.level < 0x0202)    {P    command.sample_was_extracted = log.prb$intro.specific.v20.flags.is_extracted;K    command.sample_from_a_vax = log.prb$intro.specific.v20.flags.from_a_vax; 5    log_record_size = log.prb$intro.specific.v20.size;     if (command.is_format_data)<       lib$signal(&RPL_DATALESS), command.is_format_data = 0;    } else    {U    command.sample_was_extracted = log.prb$intro.specific.v22.data.flags.is_extracted; P    command.sample_from_a_vax = log.prb$intro.specific.v22.data.flags.from_a_vax;5    log_record_size = log.prb$intro.specific.v22.size; g    if ((command.is_format_data) && ((log_payload_size = log.prb$intro.specific.v22.data.payload) == 0)) 9       lib$signal(&RPL_EMPTY), command.is_format_data = 0;     } if (!command.sample_from_a_vax)     lib$stop(&RPL_NOTAVAX);  ) /* get remainder of introduction block */   0 if (get_data(&log.element[8],log_record_size-8))    {]    master_cycle->block.sample.max_id = ((log.prb$intro.cycle > 0) ? log.prb$intro.cycle : 1); J    master_cycle->block.sample.creation_time[0] = log.prb$intro.abstime[0];J    master_cycle->block.sample.creation_time[1] = log.prb$intro.abstime[1];>    master_cycle->block.sample.activity = log.prb$intro.active;>    master_cycle->block.sample.standby = log.prb$intro.standby;  L    /* build or adjust cycle block list to contain only applicable entries */  I    if (master_cycle->reference_count == 0)			/* all cycles to be built */ =       for (i = master_cycle->block.sample.max_id; i > 0; --i)  	 { = 	 cycle = calloc(1,sizeof(C_BLOCK));			/* create new entry */ 5 	 cycle->block.object.id = i;				/* identify cycle */ J 	 cycle->next = master_cycle->next;			/* place in front of forward list */C 	 master_cycle->next = cycle;				/* adjust front of forward list */ G 	 cycle->previous = master_cycle;			/* place behind of backward list */ F 	 cycle->next->previous = cycle;				/* adjust rear of backward list */@ 	 master_cycle->reference_count += 1;			/* update cycle count */ 	 }     else        { R       for (cycle = master_cycle->next; cycle != master_cycle; cycle = cycle->next)A 	 if (cycle->block.object.id > master_cycle->block.sample.max_id)  	    {6 	    lib$signal(&RPL_BIGCYC,1,cycle->block.object.id);V 	    cycle->previous->next = cycle->next;		/* adjust forward list to skip bad entry */C 	    cycle = cycle->previous;				/* step back to last good entry */ @ 	    cfree(cycle->next->previous);			/* destroy useless entry */V 	    cycle->next->previous = cycle;			/* adjust backward list to skip removed entry */C 	    master_cycle->reference_count -= 1;			/* update cycle count */  	    }-       if (master_cycle->reference_count == 0)  	 lib$stop(&RPL_CYCOOB);       }       /* load node and adapter */  ,    for (i = 0; i < log.prb$intro.nsize; ++i)*       log_node[i] = log.prb$intro.node[i];(    log_node[log.prb$intro.nsize] = '\0';,    for (i = 0; i < log.prb$intro.asize; ++i),       adapter[i] = log.prb$intro.adapter[i];'    adapter[log.prb$intro.asize] = '\0';t    } else    lib$stop(&RPL_INCREC);   ) /* prepare master node, protocol lists */s  S node_header = calloc(1,sizeof(N_BLOCK));			/* allocate the node linked list head */oO node_header->next = node_header;				/* initially unique circular list member */t? node_header->reference_count = 0;				/* default - empty list */h[ protocol_header = calloc(1,sizeof(P_BLOCK));			/* allocate the protocol linked list head */aV protocol_header->next = protocol_header;			/* initially unique circular list member */C protocol_header->reference_count = 0;				/* default - empty list */*  V /* skip sample filler & load non-conflicting imbedded protocol and node definitions */  C while ((get_data(&log.element,log_record_size)) && (log.type == 3))H!    switch (log.prb$table.subtype)i       {i       case 0:  	 break;
       case 1: + 	 new_protocol = calloc(1,sizeof(P_BLOCK)); - 	 new_protocol->object.id = log.prb$table.id;eI 	 new_protocol->object.value[0] = log.prb$table.object.protocol.value[0];sI 	 new_protocol->object.value[1] = log.prb$table.object.protocol.value[1];a* 	 for (i = 0; i < log.prb$table.size; ++i): 	    new_protocol->object.name[i] = log.prb$table.name[i];7 	 new_protocol->object.name[log.prb$table.size] = '\0';R$ 	 if (valid(p_insert(new_protocol)))+ 	    protocol_header->reference_count += 1;m 	 else 	    cfree(new_protocol);. 	 break;
       case 2: ' 	 new_node = calloc(1,sizeof(N_BLOCK));V 	 for (i = 0; i < 6; ++i)iH 	    new_node->object.address[i] = log.prb$table.object.node.address[i];* 	 for (i = 0; i < log.prb$table.size; ++i)6 	    new_node->object.name[i] = log.prb$table.name[i];3 	 new_node->object.name[log.prb$table.size] = '\0';r  	 if (valid(n_insert(new_node)))' 	    node_header->reference_count += 1;d 	 else 	    cfree(new_node);i 	 break;       default:   	 break;       }l }:  O /******************************************************************************nO  * READ_TABLE_DEFINITIONS                                                     * O  *                                                                            *oO  * As required, this routine reads the table entry definitions and dispatches *oO  * execution until the end-of-file is reached.                                *lP  ******************************************************************************/   read_table_definitions() { D  globalref PROBE_TABLE;		/* external Command Table module address */  globalref RPL_TBLFLT;  extern catch();  
  long status;f  unsigned long count = 0;_  unsigned char line[134];   D_VARIABLE(definition,line);E  . /* as required, process the file to its end */  # if (command.process_external_table)$    {(    while (fgets(line,133,table) != NULL)       {d       count += 1;s1       definition.dsc$w_length = strlen(line) - 1;L<       lib$establish(&catch);					/* prevent CLI signaling */H       if (valid(status = cli$dcl_parse(&definition,&PROBE_TABLE,0,0,0))) 	 {d8 	 lib$revert();						/* resume normal signal behavior */2          cli$dispatch();					/* execute command */ 	 }r
       else 	 {*8 	 lib$revert();						/* resume normal signal behavior */ 	 if (status != CLI$_NOCOMD)% 	    lib$signal(&RPL_TBLFLT,1,count);  	 }        } S    command.process_external_table = 0;				/* indicate end of external processing */*    } }*  O /****************************************************************************** O  * FORMAT_ENVIRONMENT                                                         *	O  *                                                                            *mO  * Output the sample characteristics and node & protocol definitions          *pO  * according to defaults and user specified request.                          * P  ******************************************************************************/   format_environment() {e  globalref RPL_ANAPROG;g  extern char * display_time();    int i;   unsigned long entity;  N_BLOCK *node;m  P_BLOCK *protocol;i    if (command.analysis_redirected)    lib$signal(&RPL_ANAPROG); if (command.is_format_header)u    {C    fprintf(analysis,"PROBE/PLAYBACK/ANALYZE 2.2\n\n");              I    fprintf(analysis,"Input file: %s\nRecording:  %s   (%d.%d-%d)",s_file,0m  	   ((command.sample_was_extracted) ? "extracted" : "original "),revision.id.major,revision.id.minor,patch);*E    if ((command.is_format_data) && (log_payload_size < eth$max_data))NS       fprintf(analysis," with payload data truncated @ %d bytes",log_payload_size); Z    fprintf(analysis,"\n\nMade:       %s\nOn Node:    %-8s\t(a VAX)\nAdapter:    %-8s\n\n",M 	   display_time(master_cycle->block.sample.creation_time),log_node,adapter);x0    if (master_cycle->block.sample.activity != 0)T       fprintf(analysis,"Cycles:     %-5d\t(%d sec Standby) + (%d sec Activity)\n\n",q 	      master_cycle->block.sample.max_id,master_cycle->block.sample.standby,master_cycle->block.sample.activity);"    elsePh       fprintf(analysis,"Cycles:     %-5d\t(manually terminated)\n\n",master_cycle->block.sample.max_id);    } if (command.is_format_table)    {w    for (entity = 0, protocol = protocol_header->next; protocol != protocol_header; ++entity, protocol = protocol->next)eV       fprintf(analysis,"Protocol %-12s\t(%02X-%02X) ID: %-6d%s",protocol->object.name,p 	      protocol->object.value[0],protocol->object.value[1],protocol->object.id,(odd(entity) ? "\n" : "\t\t\t"));S    for (node = node_header->next; node != node_header; ++entity, node = node->next)d       {t>       fprintf(analysis,"Node     %-12s\t(",node->object.name);       for (i = 0; i < 6; ++i) K 	 fprintf(analysis,"%02X%c",node->object.address[i],((i < 5) ? '-' : ')'));d=       fprintf(analysis,"%s",(odd(entity) ? "\n" : "\t\t\t"));        }p    if (entity != 0) ;       fprintf(analysis,"%s",(odd(entity) ? "\n\n" : "\n"));m    } }a  O /******************************************************************************tO  * FORMAT_SAMPLE_DATA                                                         **O  *                                                                            * O  * Output the specified cycle sample data. No load occurs.                    * P  ******************************************************************************/   format_sample_data() {e%  globalref RPL_OUTOFSEQ, RPL_BADDATA;.  extern char * display_time();  
  int i, line;r*  unsigned long max_index, index, sequence;%  unsigned char payload[eth$max_data];*  C_BLOCK *cycle;  N_BLOCK *source, *target;  P_BLOCK *protocol;   structf     {D     unsigned do_this_cycle : 1;p     unsigned p_is_matched : 1;     unsigned s_is_matched : 1;     unsigned t_is_matched : 1;     unsigned : 0;_     } state;   state.do_this_cycle = 0; cycle = master_cycle->next;  do {    switch (log.type)       {}
       case 0:* 	 frame_count += 1;* 	 if (state.do_this_cycle) 	    {! 	    cycle->reference_count += 1;N! 	    if (command.is_format_frame) 	 	       {  	       state.s_is_matched = 0; o 	       for (source = node_header; (source->next != node_header) && !state.s_is_matched; source = source->next)e 		  for (i = 5; i >= 0; --i)` 		     if (!(state.s_is_matched = (source->next->object.address[i] == log.prb$frame.source[i])))	 			break;*  	       if (!state.s_is_matched) 		  {*' 		  source = calloc(1,sizeof(N_BLOCK));g, 		  build_node(source,log.prb$frame.source); 		  }d 	       state.t_is_matched = 0;[o 	       for (target = node_header; (target->next != node_header) && !state.t_is_matched; target = target->next)L 		  for (i = 5; i >= 0; --i)e 		     if (!(state.t_is_matched = (target->next->object.address[i] == log.prb$frame.destination[i])));	 			break;N  	       if (!state.t_is_matched) 		  {C' 		  target = calloc(1,sizeof(N_BLOCK));;1 		  build_node(target,log.prb$frame.destination);, 		  }Dd 	       fprintf(analysis," Frame %010d %-10s @ %08.2f  From: %-17s  To: %-17s  Size: %4d/%-4d  %s ",^ 		       frame_count,(log.prb$frame.tag.is_ieee ? "(IEEE)" : "(Ethernet)"),log.prb$frame.time,D 		       source->object.name,target->object.name,log.prb$frame.size,H 		       (log.prb$frame.size+log.prb$frame.tag.overhead < eth$min_data ?N 			eth$min_frame : log.prb$frame.size+log.prb$frame.tag.overhead+eth$envelop),B 		       (log.prb$frame.tag.is_ieee ? "D-S SAPs:" : "Protocol:")); 	       state.p_is_matched = 0;ed 	       for (protocol = protocol_header; (protocol->next != protocol_header) && !state.p_is_matched;  		    protocol = protocol->next) 		  for (i = 1; i >= 0; --i)b 		     if (!(state.p_is_matched = (protocol->next->object.value[i] == log.prb$frame.protocol[i])))	 			break;p 	       if (state.p_is_matched)e2 		  fprintf(analysis,"%s ",protocol->object.name); 	       elseW 		  fprintf(analysis,"%02X-%02X ",log.prb$frame.protocol[0],log.prb$frame.protocol[1]); P 	       fprintf(analysis,"%s\n",(log.prb$frame.tag.warning ? "<warning>" : ""));D 	       if ((command.is_format_data) && (log.prb$frame.tag.is_data))Q 		  if (log.prb$frame.tag.is_more)	/* store contents until end-of-data block 2 */t 		     { 		     sequence = 0;1 		     if (log.prb$frame.size < log_payload_size)$" 			max_index = log.prb$frame.size; 		     else_  			max_index = log_payload_size;9 		     for (index = 0; index < prb$log_capacity; ++index)_. 			payload[index] = log.prb$frame.data[index]; 		     }= 		  else					/* no additional data blocks... format output */| 		     {$ 		     max_index = prb$log_capacity;* 		     if (log.prb$frame.size < max_index)" 			max_index = log.prb$frame.size;( 		     if (log_payload_size < max_index)  			max_index = log_payload_size;0 	             fprintf(analysis,"  Data 0000> "); 		     for (i = 0; i < 25; ++i)= 			if (i < max_index)iU 			   fprintf(analysis,"%02X%s",log.prb$frame.data[i],(i < max_index-1 ? "," : " "));; 			elsei 			   fprintf(analysis,"   ");$ 		     fprintf(analysis," ASCII> ");& 		     for (i = 0; i < max_index; ++i)I 			if ((log.prb$frame.data[i] < 0x20) || (log.prb$frame.data[i] >= 0x7F))u 			   fprintf(analysis,"."); 			else , 			   fputc(log.prb$frame.data[i],analysis); 		     fprintf(analysis,"\n"); 		     }	 	       }e 	    } 	 break;4       case 2:	/* last data block... format output */8 	 if ((command.is_format_data) && (state.do_this_cycle))- 	    if (sequence == log.prb$data.sequence-1)y	 	       {/R 	       for (i = 0; ((i < prb$entry_size-2) && (index < max_index)); ++i, ++index)- 		  payload[index] = log.prb$data.content[i];o4 	       for (line = 0; line*25 < max_index ; ++line) 		  {a. 		  fprintf(analysis,"  Data %04d> ",line*25);, 		  for (i = line*25; i < (line*25)+25; ++i) 		     if (i < max_index)oG 			fprintf(analysis,"%02X%s",payload[i],(i < max_index-1 ? "," : " "));  		     elsec 			fprintf(analysis,"   "); ! 		  fprintf(analysis," ASCII> ");rC 		  for (i = line*25; ((i < (line*25)+25) && (i < max_index)); ++i)/7 		     if ((payload[i] < 0x20) || (payload[i] >= 0x7F))* 			fprintf(analysis,".");* 		     else* 			fputc(payload[i],analysis); 		  fprintf(analysis,"\n");  		  } 	 	       } + 	    else	/* sequence of data block lost */ " 	       lib$signal(&RPL_OUTOFSEQ); 	 break;
       case 4: = 	 if ((command.is_format_collision) && (state.do_this_cycle))lo 	    fprintf(analysis," CD report %d from %s - Frames Xmit: %-10d  Deferred: %-10d   C1: %-10d   C2+: %-10d\n",*d 		    log.prb$collision.sequence,display_time(log.prb$collision.abstime),log.prb$collision.fxmitted,W 		    log.prb$collision.fdeferred,log.prb$collision.single,log.prb$collision.multiple);m 	 break;
       case 5:l7 	 if (cycle->block.object.id == log.prb$start.sequence)) 	    {! 	    if (command.is_format_cycle)im 	       fprintf(analysis,"Cycle %d started %s\n",log.prb$start.sequence,display_time(log.prb$start.abstime));= 	    state.do_this_cycle = 1;  	    } 	 else! 	    if (command.is_format_cycle) F 	       fprintf(analysis,"Cycle %d ignored\r",log.prb$start.sequence); 	 break;S       case 6:	/* spanning data block... store contents until end-of-data block 2 */m8 	 if ((command.is_format_data) && (state.do_this_cycle))- 	    if (sequence == log.prb$data.sequence-1)P	 	       {  	       sequence += 1;U 	       for (i = 0; ((i < prb$entry_size-2) && (index < eth$max_data)); ++i, ++index)*- 		  payload[index] = log.prb$data.content[i]; 	 	       } + 	    else	/* sequence of data block lost */ " 	       lib$signal(&RPL_OUTOFSEQ); 	 break;
       case 7:  	 if (state.do_this_cycle) 	    {! 	    if (command.is_format_cycle)n> 	       fprintf(analysis,"Cycle %d stopped %s (frames: %d)\n",Z 		       log.prb$stop.sequence,display_time(log.prb$stop.abstime),cycle->reference_count); 	    state.do_this_cycle = 0;e 	    cycle = cycle->next;o 	    } 	 break;       default: 	 lib$signal(&RPL_BADDATA);A       } Q    } while ((cycle != master_cycle) && (get_data(&log.element,log_record_size)));_ }t  P /******************************************************************************/P /*************************** SECOND LEVEL ROUTINES ****************************/P /******************************************************************************/  O /******************************************************************************mO  * CATCH                                                                      *iO  *                                                                            * O  * Intercept CLI routine signal and replace by SS$_CONTINUE so that messaging *rO  * is explicitely controlled by this program. Since DCL_PARSE also returns an *sO  * error status, use that value to determine command line validity.           *iP  ******************************************************************************/   catch()  {; return(SS$_CONTINUE);c }a  O /******************************************************************************cO  * DISPLAY_TIME                                                               *lO  *                                                                            *aO  * Converts an input VAX binary time into its equivalent ASCII representation.* P  ******************************************************************************/   char * display_time(value)  unsigned long *value; {r  static char result[24];   static D_VARIABLE(time,result);  static short length;{  - if (valid(sys$asctim(&length,&time,value,0)))b    result[length] = '\0';$ else    result[0] = '\0'; return(result);m }.  O /******************************************************************************nO  * UPDATE_NTABLE                                                              *gO  *                                                                            *;O  * Parses a node definition into a new node block and attempts insertion into * O  * the sorted master node linked list.                                        * P  ******************************************************************************/   update_ntable(); {/$  globalref RPL_BADNADR, RPL_NULNNAM;  extern x_load();/    unsigned short a_size;l  unsigned short n_size;e/  unsigned char  string[prb$object_name_size+1];t    N_BLOCK *new_node;	    D_CONSTANT(n_nam,"NODE_NAM");  D_CONSTANT(n_adr,"NODE_ADR");  D_VARIABLE(input,string);  % new_node = calloc(1,sizeof(N_BLOCK));uJ if (cli$present(&n_adr) == CLI$_PRESENT)			/* process specified address */@    if (!((cli$get_value(&n_adr,&input,&a_size) == SS$_NORMAL) &&@ 	 (valid(x_load(string, a_size, new_node->object.address, 6)))))       {-       cfree(new_node);       lib$signal(&RPL_BADNADR);k       return(GOOD);        }l( if (cli$present(&n_nam) == CLI$_PRESENT)W    if (cli$get_value(&n_nam,&input,&n_size) == SS$_NORMAL)	/* process specified name */r       {        string[n_size] = '\0';,       strcpy(new_node->object.name, string);       }e    elseo       lib$signal(&RPL_NULNNAM);/0 if (valid(n_insert(new_node)))					/* connect */%    node_header->reference_count += 1;  else								/* release */e    cfree(new_node);a
 return(GOOD);* }   O /****************************************************************************** O  * UPDATE_PTABLE                                                              *eO  *                                                                            *zO  * Parses a protocol definition into a new protocol block and attempts        *pO  * insertion into the sorted master protocol linked list.                     *bP  ******************************************************************************/   update_ptable()_ {C0  globalref RPL_OVRPID, RPL_BADPVAL, RPL_NULPNAM;  extern x_load();     unsigned short i_size;y  unsigned short n_size;b  unsigned short v_size;r/  unsigned char  string[prb$object_name_size+1];r    P_BLOCK *new_protocol;z    D_CONSTANT(p_nam,"PTCL_NAM");  D_CONSTANT(p_idn,"PTCL_IDN");  D_CONSTANT(p_val,"PTCL_VAL");  D_VARIABLE(input,string);  ) new_protocol = calloc(1,sizeof(P_BLOCK));fO new_protocol->object.id = 0;					/* unspecified protocol IDs default to zero */n( if (cli$present(&p_idn) == CLI$_PRESENT)U    if (cli$get_value(&p_idn,&input,&i_size) == SS$_NORMAL)	/* process specified ID */        {        string[i_size] = '\0';-       new_protocol->object.id = atoi(string);        }t
    else      ,       lib$signal(&RPL_OVRPID);H if (cli$present(&p_val) == CLI$_PRESENT)			/* process specified value */@    if (!((cli$get_value(&p_val,&input,&v_size) == SS$_NORMAL) &&B 	 (valid(x_load(string, v_size, new_protocol->object.value, 2)))))       {l       cfree(new_protocol);       lib$signal(&RPL_BADPVAL);l       return(GOOD);t       }e( if (cli$present(&p_nam) == CLI$_PRESENT)W    if (cli$get_value(&p_nam,&input,&n_size) == SS$_NORMAL)	/* process specified name */        {n       string[n_size] = '\0';0       strcpy(new_protocol->object.name, string);       }     else        lib$signal(&RPL_NULPNAM);.3 if (valid(p_insert(new_protocol)))				/* connect */ )    protocol_header->reference_count += 1;  else								/* release */     cfree(new_protocol); 
 return(GOOD);e }n  O /******************************************************************************rO  * C_CONNECT                                                                  *:O  *                                                                            **O  * Insert a new cycle block into the cycle linked list.                       * P  ******************************************************************************/   c_connect(new)  C_BLOCK *new; {e  globalref RPL_DUPCID; s  C_BLOCK *cycle;  [ /* first, scan the cycle list until the next item ID is larger or equal to the new entry */    for (cycle = master_cycle;^      ((cycle->next != master_cycle) && (cycle->next->block.object.id < new->block.object.id));      cycle = cycle->next) {}T if (cycle->next->block.object.id == new->block.object.id)	/* reject duplicated ID */    {2    lib$signal(&RPL_DUPCID,1,new->block.object.id);    return(BAD);D    }" else								/* insert into list */    {5    new->next = cycle->next;					/* connect forward */x4    new->previous = cycle;					/* connect backward */D    new->next->previous = new;					/* link backward chain to entry */C    new->previous->next = new;					/* link forward chain to entry */     return(GOOD);    } }i  O /******************************************************************************	O  * N_CONNECT                                                                  *oO  *                                                                            *hO  * Add node entry in sorted order by name (1) and address (2).                * P  ******************************************************************************/   n_connect(new)  N_BLOCK *new; {*  N_BLOCK *node;*   /* primary sort */   for (node = node_header;^      ((node->next != node_header) && (strcmp(node->next->object.name, new->object.name) < 0));      node = node->next) {}   /* subsort as required */    for (;`      ((node->next != node_header) && (strcmp(node->next->object.name, new->object.name) == 0) &&a       (compare(&node->next->object.address, &new->object.address, 6) < 0)); node = node->next) {}*   /* reconnect chain */*   new->next = node->next;  node->next = new;t
 return(GOOD);r }R  O /******************************************************************************NO  * N_INSERT                                                                   *sO  *                                                                            *PO  * Inspect the node linked list for an address match.                         *%O  * Update found entry & resort list, or insert new block in proper order.     *"P  ******************************************************************************/  
 n_insert(new)a  N_BLOCK *new; {_%  globalref RPL_UPDNDEF, RPL_LOOKATN; n  N_BLOCK *node;l  F for (node = node_header; node->next != node_header; node = node->next)J    if (compare(&node->next->object.address, &new->object.address, 6) == 0)       {eU       if (strlen(new->object.name) != 0)			/* update if name specified & different */o 	 {m= 	 if (strcmp(node->next->object.name, new->object.name) != 0)% 	    { 	    lib$signal(&RPL_UPDNDEF,8, e 		       new->object.address[0],new->object.address[1],new->object.address[2],new->object.address[3],aa 		       new->object.address[4],new->object.address[5],node->next->object.name,new->object.name);y7 	    strcpy(node->next->object.name, new->object.name);a` 	    new->next = node->next;				/* use new as a temporary holder of the updated block pointer */M 	    node->next = node->next->next;			/* break & reconnect shortened chain */2E 	    n_connect(new->next);				/* reinsert updated block */           u9 	    }                                                   i 	 } '       else							/* node status only */e 	 lib$signal(&RPL_LOOKATN,8,` 		    node->next->object.address[0],node->next->object.address[1],node->next->object.address[2],` 		    node->next->object.address[3],node->next->object.address[4],node->next->object.address[5],; 		    node->next->object.name,node->next->reference_count);)E       return(BAD);						/* caller will deallocate unused new block */n       }s n_connect(new);"
 return(GOOD);m }   O /*******************************************************************************O  * P_CONNECT                                                                  * O  *                                                                            * O  * Add protocol entry in sorted order by name (1) and value (2).              * P  ******************************************************************************/   p_connect(new)  P_BLOCK *new; {g  P_BLOCK *protocol;,   /* primary sort */    for (protocol = protocol_header;j      ((protocol->next != protocol_header) && (strcmp(protocol->next->object.name, new->object.name) < 0));"      protocol = protocol->next) {}   /* subsort as required */    for (;l      ((protocol->next != protocol_header) && (strcmp(protocol->next->object.name, new->object.name) == 0) &&i       (compare(&protocol->next->object.value, &new->object.value, 2) < 0)); protocol = protocol->next) {}o   /* reconnect chain */    new->next = protocol->next;m protocol->next = new;t
 return(GOOD);l }   O /****************************************************************************** O  * P_INSERT                                                                   *rO  *                                                                            * O  * Inspect the protocol linked list for a protocol match.                     *rO  * Update found entry & resort list, or insert new block in proper order.     *)P  ******************************************************************************/  
 p_insert(new)	  P_BLOCK *new; {.$  globalref RPL_UPDPDEF, RPL_LOOKATP;  P_BLOCK *protocol;g  ^ for (protocol = protocol_header; protocol->next != protocol_header; protocol = protocol->next)J    if (compare(&protocol->next->object.value, &new->object.value, 2) == 0)       {rC       if ((new->object.id != 0) || (strlen(new->object.name) != 0))  	 {CQ 	 if (((new->object.id != 0) && (protocol->next->object.id != new->object.id)) ||th 	     ((strlen(new->object.name) != 0) && (strcmp(protocol->next->object.name, new->object.name) != 0))) 	    lib$signal(&RPL_UPDPDEF,6,uI 		       protocol->next->object.value[0],protocol->next->object.value[1],,` 		       protocol->next->object.name,protocol->next->object.id,new->object.name,new->object.id); 	 if (new->object.id != 0)0 	    protocol->next->object.id = new->object.id;f 	 if ((strlen(new->object.name) != 0) && (strcmp(protocol->next->object.name, new->object.name) != 0))( 	    {							/* name change... resort */; 	    strcpy(protocol->next->object.name, new->object.name);td 	    new->next = protocol->next;				/* use new as a temporary holder of the updated block pointer */T 	    protocol->next = protocol->next->next;		/* break & reconnect shortened chain */E 	    p_connect(new->next);				/* reinsert updated block */             	    } 	 }s+       else							/* protocol status only */e 	 lib$signal(&RPL_LOOKATP,5,F 		    protocol->next->object.value[0],protocol->next->object.value[1],] 		    protocol->next->object.name,protocol->next->object.id,protocol->next->reference_count);_E       return(BAD);						/* caller will deallocate new unused block */.       }/ p_connect(new);u
 return(GOOD);a }o  O /******************************************************************************aO  * COMPARE                                                                    *yO  *                                                                            *dO  * Compare two arbitrary arrays of a given size until divergence.             *aO  * Similar to STRNCMP but is not affected by null end-of-string values.       * P  ******************************************************************************/   compare(first,second,size)  unsigned char *first;  unsigned char *second;   unsigned long size; {a  unsigned long i;   long result = 0;;  K for (i = 0; ((i < size) && ((result = first[i] - second[i]) == 0)); ++i) {}a return(result);d }1  O /******************************************************************************,O  * X_LOAD                                                                     *iO  *                                                                            *eO  * Converts an input character string into its equivalent network hexadecimal *;O  * form. This is used during protocol value and node address processing.      *mP  ******************************************************************************/   x_load(input,size,output,max)1  unsigned char  *input;o  unsigned short size;r  unsigned char  *output;  unsigned short max; {	  long i, offset, nibble;  unsigned char x;   ) if (max == 0)							/* sanity check... */+    return(GOOD);5 for (i = 0; i < max; ++i)					/* initialise output */i    output[i] = 0;nJ for (offset = 0; ((offset < size) && (input[offset] == '0')); ++offset) {}D if (offset == size)						/* string has null value... no more work */    return(GOOD);R if ((nibble = max * 2) < (size-offset))				/* check for sufficient output space */    return(BAD);/r for (i = (size-1), --nibble; i >= offset; --i, --nibble)	/* find all characters corresponding hexadecimal value */    {.    if ((input[i] >= '0') && (input[i] <= '9'))       x = input[i] - '0';s    elsef1       if ((input[i] >= 'A') && (input[i] <= 'F'))S 	 x = input[i] - 'A' + 10;
       else- 	 if ((input[i] >= 'a') && (input[i] <= 'f'))y 	    x = input[i] - 'a' + 10; 0 	 else							/* not a valid hexadecimal digit */ 	    return(BAD);ds    output[nibble/2] = output[nibble/2] | (odd(nibble) ? x : (x<<4));	/* insert in reverse byte order into output */e    }
 return(GOOD);l }o  O /****************************************************************************** O  * BUILD_NODE                                                                 *iO  *                                                                            *gO  * Builds a node name from the provided address if its prefix is from a known *cO  * manufacturer or the logical DECnet Phase IV. Otherwise, construct the hex  *lO  * representation of the address. Insert new node into the node list.         *aP  ******************************************************************************/   build_node(new,address)_  N_BLOCK	*new;  unsigned char	*address; {t  union     {      unsigned short address;+
     struct        {        unsigned number : 10;        unsigned area : 6;+        } logical;a
     } decnet;l    unsigned int i, j;   unsigned found;   for (i = 0; i < 6; ++i)l'    new->object.address[i] = address[i];O& if (odd(address[0]))			/* multicast */    sprintf(new->object.name,"%02X-%02X-%02X-%02X-%02X-%02X",address[0],address[1],address[2],address[3],address[4],address[5]);  elsed    if ((address[0] == 0xAA) && (address[1] == 0x00) && (address[2] == 0x04) && (address[3] == 0x00))       {=8       decnet.address = ((address[5] << 8) | address[4]);Z       sprintf(new->object.name,"DECnet(%d.%d)",decnet.logical.area,decnet.logical.number);       }o    else,       {d       found = 0;-       for (i = 0; (i < known) && !found; ++i)* 	 for (j = 0; j < 3; ++j)*V 	    if (!(found = (address[2-j] == node[i][2-j])))	/* test most variant byte first */ 	       break;       if (found)[ 	 sprintf(new->object.name,"%s:%02X-%02X-%02X",name[--i],address[3],address[4],address[5]);*
       else; 	 sprintf(new->object.name,"%02X-%02X-%02X-%02X-%02X-%02X", M 	         address[0],address[1],address[2],address[3],address[4],address[5]);        }  n_connect(new); 
 return(GOOD);  } 