 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %          Display Machine Independent File Format Image via X11.             % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Display is a machine architecture independent image processing G %  and display program.  It can display any image in the MIFF format on C %  any workstation display running X.  Display first determines the E %  hardware capabilities of the workstation.  If the number of unique J %  colors in the image is less than or equal to the number the workstationE %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Display program command syntax is:  % > %  Usage: display [options ...] file [ [options ...] file ...] %  %  Where options include: < %    -backdrop          display image centered on a backdrop= %    -border geometry   surround image with a border of color ) %    -colormap type     Shared or Private ? %    -colors value      preferred number of colors in the image G %    -colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV 5 %    -comment string    annotate image with comment", / %    -compress type     RunlengthEncoded or Zip < %    -contrast          enhance or reduce the image contrastH %    -crop geometry     preferred size and location of the cropped image< %    -delay seconds     display the next image after pausingD %    -density geometry  vertical and horizontal density of the image; %    -despeckle         reduce the speckles within an image 6 %    -display server    display image to this X server+ %    -dispose method    GIF disposal method F %    -dither            apply Floyd/Steinberg error diffusion to imageC %    -edge factor       apply a filter to detect edges in the image G %    -enhance           apply a digital filter to enhance a noisy image B %    -equalize          perform histogram equalization to an image< %    -flip              flip image in the vertical direction> %    -flop              flop image in the horizontal direction@ %    -frame geometry    surround image with an ornamental border1 %    -gamma value       level of gamma correction G %    -geometry geometry preferred size and location of the Image window : %    -immutable         displayed image cannot be modified, %    -interlace type    NONE, LINE, or PLANE2 %    -label name        assign a label to an imageB %    -map type          display image using this Standard Colormap@ %    -matte             store matte channel if the image has one@ %    -modulate value    vary the brightness, saturation, and hue: %    -monochrome        transform image to black and white6 %    -negate            apply color inversion to imageI %    -noise             reduce noise with a noise peak elimination filter L %    -normalize         transform image to span the full the range of colors: %    -opaque color      change this color to the pen color@ %    -page geometry     size and location of the Postscript page, %    -quality value     JPEG quality settingI %    -raise value       lighten/darken image edges to create a 3-D effect @ %    -roll geometry     roll an image vertically or horizontally9 %    -rotate degrees    apply Paeth rotation to the image 7 %    -sample geometry   scale image with pixel sampling * %    -scene value       image scene number( %    -segment value     segment an image; %    -sharpen factor    apply a filter to sharpen the image I %    -shear geometry    slide one edge of the image along the X or Y axis 1 %    -size geometry     width and height of image I %    -texture filename  name of texture to tile onto the image background > %    -treedepth value   depth of the color classification treeH %    -update seconds    detect when image file is modified and redisplayB %    -verbose           print detailed information about the image< %    -visual type       display image using this visual typeB %    -window id         display image to background of this windowE %    -window_group id   exit program when this window id is destroyed - %    -write filename    write image to a file  % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, I %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor, 0 %  -name, -shared_memory, -usePixmap, or -title. % D %  Change '-' to '+' in any option above to reverse its effect.  ForH %  example, specify +matte to store the image without its matte channel. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 2 %    1    press to map or unmap the Command widget8 %    2    press and drag to magnify a region of an image> %    3    press to load an image from a visual image directory %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "display.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Function Usage displays the program command syntax. % & %  The format of the Usage routine is: %  %      Usage(terminate)  % + %  A description of each parameter follows:  % J %    o terminate: A value other than zero is returned if the program is to %      terminate immediately.  %  *// static void Usage(const unsigned int terminate)  {    char     **p;  
   static char      *buttons[]=      { 6       "1    press to map or unmap the Command widget",<       "2    press and drag to magnify a region of an image",B       "3    press to load an image from a visual image directory",       (char *) NULL      },     *options[]=      { @       "-backdrop          display image centered on a backdrop",A       "-border geometry   surround image with a border of color", -       "-colormap type     Shared or Private", C       "-colors value      preferred number of colors in the image", K       "-colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", 7       "-comment string    annotate image with comment", 3       "-compress type     RunlengthEncoded or Zip", @       "-contrast          enhance or reduce the image contrast",L       "-crop geometry     preferred size and location of the cropped image",@       "-delay seconds     display the next image after pausing",H       "-density geometry  vertical and horizontal density of the image",?       "-despeckle         reduce the speckles within an image", :       "-display server    display image to this X server",/       "-dispose method    GIF disposal method", J       "-dither            apply Floyd/Steinberg error diffusion to image",G       "-edge factor       apply a filter to detect edges in the image", K       "-enhance           apply a digital filter to enhance a noisy image", F       "-equalize          perform histogram equalization to an image",@       "-flip              flip image in the vertical direction",B       "-flop              flop image in the horizontal direction",D       "-frame geometry    surround image with an ornamental border",5       "-gamma value       level of gamma correction", K       "-geometry geometry preferred size and location of the Image window", >       "-immutable         displayed image cannot be modified",0       "-interlace type    NONE, LINE, or PLANE",6       "-label name        assign a label to an image",F       "-map type          display image using this Standard Colormap",D       "-matte             store matte channel if the image has one",D       "-modulate value    vary the brightness, saturation, and hue",>       "-monochrome        transform image to black and white",:       "-negate            apply color inversion to image",M       "-noise             reduce noise with a noise peak elimination filter", L       "-normalize         transform image to span the full range of colors",>       "-opaque color      change this color to the pen color",D       "-page geometry     size and location of the Postscript page",0       "-quality value     JPEG quality setting",M       "-raise value       lighten/darken image edges to create a 3-D effect", D       "-roll geometry     roll an image vertically or horizontally",=       "-rotate degrees    apply Paeth rotation to the image", .       "-scene value       image scene number",,       "-segment value     segment an image",;       "-sample geometry   scale image with pixel sampling", ?       "-sharpen factor    apply a filter to sharpen the image", M       "-shear geometry    slide one edge of the image along the X or Y axis", 5       "-size geometry     width and height of image", M       "-texture filename  name of texture to tile onto the image background", B       "-treedepth value   depth of the color classification tree",L       "-update seconds    detect when image file is modified and redisplay",F       "-verbose           print detailed information about the image",@       "-visual type       display image using this visual type",F       "-window id         display image to background of this window",I       "-window_group id   exit program when this window id is destroyed", 1       "-write filename    write image to a file",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version);    (void) printf(N     "Usage: %s [-options ...] file [ [-options ...] file ...]\n",client_name);/   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(P     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor,\n");   (void) printf(7     "-name, -shared_memory, -usePixmap, or -title.\n");    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(M     "example, specify +matte to store the image without a matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    if (terminate)     exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e E d i t I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XAnnotateEditImage annotates the image with text.  % 3 %  The format of the XAnnotateEditImage routine is:  % < %    XAnnotateEditImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */8 static unsigned int XAnnotateEditImage(Display *display,>   XResourceInfo *resource_info,XWindows *windows,Image *image) {  #define AnnotateModeNameOp  0 " #define AnnotateModeFontColorOp  1( #define AnnotateModeBackgroundColorOp  2 #define AnnotateModeRotateOp  3  #define AnnotateModeHelpOp  4   #define AnnotateModeDismissOp  5 #define TextModeHelpOp  0  #define TextModeDismissOp  1  
   static char      *AnnotateModeMenu[]=     {        "Font Name",       "Font Color",        "Box Color",       "Rotate Text",
       "Help",        "Dismiss",       (char *) NULL      },     *TextModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      };     char      *ColorMenu[MaxNumberPens+1],     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      GC     annotate_context;      int      id,      pen_number,      x,     y;     KeySym     key_symbol;      register char      *p;      register int     i;     static double      degrees = 0.0;     static unsigned int      box_id = MaxNumberPens-2,      font_id = 0,     pen_id = 0,      transparent_box = True,      transparent_pen = False;     unsigned int     height,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XAnnotateInfo      *annotate_info,      *previous_info;      XColor
     color;  
   XFontStruct      *font_info;      XEvent
     event,     text_event;      /*     Map Command widget.    */#   windows->command.name="Annotate";    windows->command.data=4;J   (void) XCommandWidget(display,windows,AnnotateModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { "           case AnnotateModeNameOp:           {              char(               *FontMenu[MaxNumberFonts];               int                font_number;               /*)               Initialize menu selections.              */.             for (i=0; i < MaxNumberFonts; i++)6               FontMenu[i]=resource_info->font_name[i];4             FontMenu[MaxNumberFonts-2]="Browser...";5             FontMenu[MaxNumberFonts-1]=(char *) NULL;              /*6               Select a font name from the pop-up menu.             */I             font_number=XMenuWidget(display,windows,AnnotateModeMenu[id],                 FontMenu,command);              if (font_number < 0)               break;2             if (font_number == (MaxNumberFonts-2))               {                  static char 3                   font_name[MaxTextLength]="fixed";                    /*4                   Select a font name from a browser.                 */@                 resource_info->font_name[font_number]=font_name;G                 XFontBrowserWidget(display,windows,"Select",font_name); '                 if (*font_name == '\0')                    break;               }              /*#               Initialize font info.              */             font_info=L               XLoadQueryFont(display,resource_info->font_name[font_number]);2             if (font_info == (XFontStruct *) NULL)               { E                 XNoticeWidget(display,windows,"Unable to load font:", 9                   resource_info->font_name[font_number]);                  break;               }               font_id=font_number;)             XFreeFont(display,font_info);              break;           } '           case AnnotateModeFontColorOp:            {              /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */H             pen_number=XMenuWidget(display,windows,AnnotateModeMenu[id],!               ColorMenu,command);              if (pen_number < 0)                break;<             transparent_pen=pen_number == (MaxNumberPens-2);              if (transparent_pen)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } -           case AnnotateModeBackgroundColorOp:            {              /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */H             pen_number=XMenuWidget(display,windows,AnnotateModeMenu[id],!               ColorMenu,command);              if (pen_number < 0)                break;<             transparent_box=pen_number == (MaxNumberPens-2);              if (transparent_box)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             box_id=pen_number;             break;           } $           case AnnotateModeRotateOp:           {              int                entry;               static char ,               angle[MaxTextLength] = "30.0",               *RotateMenu[]=               {                  "-90",                 "-45",                 "-30",                 "0",                 "30",                  "45",                  "90",                  "180",                 (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */&             RotateMenu[8]="Dialog...";N             entry=XMenuWidget(display,windows,AnnotateModeMenu[id],RotateMenu,               command);              if (entry < 0)               break;             if (entry != 8)                { 0                 degrees=atof(RotateMenu[entry]);                 break;               } N             (void) XDialogWidget(display,windows,"OK","Enter rotation angle:",               angle);              if (*angle == '\0')                break;              degrees=atof(angle);             break;           } "           case AnnotateModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           } %           case AnnotateModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 6         if (event.xbutton.window != windows->image.id)           break;
         /*'           Change to text entering mode. 
         */         x=event.xbutton.x;         y=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*0     Set font info and check boundary conditions.   */F   font_info=XLoadQueryFont(display,resource_info->font_name[font_id]);(   if (font_info == (XFontStruct *) NULL)     { ;       XNoticeWidget(display,windows,"Unable to load font:", +         resource_info->font_name[font_id]); )       font_info=windows->image.font_info;      } >   if ((x+font_info->max_bounds.width) >= windows->image.width)7     x=windows->image.width-font_info->max_bounds.width; 1   if (y < (font_info->ascent+font_info->descent)) +     y=font_info->ascent+font_info->descent; =   if ((font_info->max_bounds.width > windows->image.width) || H       ((font_info->ascent+font_info->descent) >= windows->image.height))     return(False);   /*"     Initialize annotate structure.   */@   annotate_info=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));.   if (annotate_info == (XAnnotateInfo *) NULL)     return(False);"   XGetAnnotateInfo(annotate_info);   annotate_info->x=x;    annotate_info->y=y; +   if (!transparent_box && !transparent_pen) )     annotate_info->stencil=OpaqueStencil;    else     if (!transparent_box) /       annotate_info->stencil=BackgroundStencil;      else/       annotate_info->stencil=ForegroundStencil; =   annotate_info->height=font_info->ascent+font_info->descent; !   annotate_info->degrees=degrees; %   annotate_info->font_info=font_info; &   annotate_info->text=(char *) malloc(N     (windows->image.width/Max(font_info->min_bounds.width,1)+2)*sizeof(char));+   if (annotate_info->text == (char *) NULL)      return(False);   /**     Create cursor and set graphic context.   */.   cursor=XCreateFontCursor(display,XC_pencil);2   XDefineCursor(display,windows->image.id,cursor);3   annotate_context=windows->image.annotate_context; 4   XSetFont(display,annotate_context,font_info->fid);*   XSetBackground(display,annotate_context,9     windows->image.pixel_info->pen_colors[box_id].pixel); *   XSetForeground(display,annotate_context,9     windows->image.pixel_info->pen_colors[pen_id].pixel);    /*)     Begin annotating the image with text.    */   windows->command.name="Text";    windows->command.data=0;F   (void) XCommandWidget(display,windows,TextModeMenu,(XEvent *) NULL);   state=DefaultState; D   XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);F   text_event.xexpose.width=(unsigned int) font_info->max_bounds.width;9   text_event.xexpose.height=font_info->max_bounds.ascent+ "     font_info->max_bounds.descent;   p=annotate_info->text;   do   {      /*       Display text cursor.     */     *p='\0';F     XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */0         XSetBackground(display,annotate_context,=           windows->image.pixel_info->background_color.pixel); 0         XSetForeground(display,annotate_context,=           windows->image.pixel_info->foreground_color.pixel); C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event); 0         XSetBackground(display,annotate_context,?           windows->image.pixel_info->pen_colors[box_id].pixel); 0         XSetForeground(display,annotate_context,?           windows->image.pixel_info->pen_colors[pen_id].pixel);          if (id < 0)            continue;          switch (id) 	         {            case TextModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);<             XDefineCursor(display,windows->image.id,cursor);             break;           } !           case TextModeDismissOp:            {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:             break;	         }          continue;        }      /*       Erase text cursor.     */     text_event.xexpose.x=x; 8     text_event.xexpose.y=y-font_info->max_bounds.ascent;@     XClearArea(display,windows->image.id,x,text_event.xexpose.y,@       text_event.xexpose.width,text_event.xexpose.height,False);8     XRefreshWindow(display,&windows->image,&text_event);     switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);             break;           } ,         if (event.xbutton.button == Button2)           {              /*(               Request primary selection.             */E             XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, -               windows->image.id,CurrentTime);              break;           }          break;       }        case Expose:       { %         if (event.xexpose.count == 0)            {              XAnnotateInfo                *text_info;                /*#               Refresh Image window.              */D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);$             text_info=annotate_info;7             while (text_info != (XAnnotateInfo *) NULL) 
             { >               if (annotate_info->stencil == ForegroundStencil)G                 XDrawString(display,windows->image.id,annotate_context, <                   text_info->x,text_info->y,text_info->text,+                   strlen(text_info->text));                elseL                 XDrawImageString(display,windows->image.id,annotate_context,<                   text_info->x,text_info->y,text_info->text,+                   strlen(text_info->text)); ,               text_info=text_info->previous;
             } N             XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);           }          break;       }        case KeyPress:       {          int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; N         if ((event.xkey.state & ControlMask) || (event.xkey.state & Mod1Mask))           state|=ModifierState; "         if (state & ModifierState)           switch (key_symbol)            {              case XK_u:             case XK_U:
             { #               key_symbol=XK_Delete;                break;
             }              default:               break;           }          switch (key_symbol) 	         {            case XK_BackSpace:           {              /*"               Erase one character.             */)             if (p == annotate_info->text) D               if (annotate_info->previous == (XAnnotateInfo *) NULL)                 break;               else                 {                    /*;                     Go to end of the previous line of text.                    */8                   annotate_info=annotate_info->previous;(                   p=annotate_info->text;:                   x=annotate_info->x+annotate_info->width;%                   y=annotate_info->y; 0                   if (annotate_info->width != 0)3                     p+=strlen(annotate_info->text);                    break;                 }              p--;)             x-=XTextWidth(font_info,p,1); #             text_event.xexpose.x=x; @             text_event.xexpose.y=y-font_info->max_bounds.ascent;@             XRefreshWindow(display,&windows->image,&text_event);             break;           }            case XK_Delete:            {              /*,               Erase the entire line of text.             */,             while (p != annotate_info->text)
             {                p--;+               x-=XTextWidth(font_info,p,1); %               text_event.xexpose.x=x; B               XRefreshWindow(display,&windows->image,&text_event);
             }              break;           }            case XK_Escape:            case XK_F20:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:           {              /*:               Draw a single character on the Image window.             */&             if (state & ModifierState)               break;!             if (*command == '\0')                break;             *p=(*command);<             if (annotate_info->stencil == ForegroundStencil)N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);             elseJ               XDrawImageString(display,windows->image.id,annotate_context,                 x,y,p,1); )             x+=XTextWidth(font_info,p,1);              p++;G             if ((x+font_info->max_bounds.width) < windows->image.width)                break;           }            case XK_Return:            case XK_KP_Enter:            {              /*/               Advance to the next line of text.              */             *p='\0';J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); >             if (annotate_info->next != (XAnnotateInfo *) NULL)               {                  /*.                   Line of text already exists.                 */2                 annotate_info=annotate_info->next;#                 x=annotate_info->x; #                 y=annotate_info->y; &                 p=annotate_info->text;                 break;               } P             annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));>             if (annotate_info->next == (XAnnotateInfo *) NULL)               return(False);2             *annotate_info->next=(*annotate_info);8             annotate_info->next->previous=annotate_info;.             annotate_info=annotate_info->next;F             annotate_info->text=(char *) malloc((windows->image.width/B               Max(font_info->min_bounds.width,1)+2)*sizeof(char));5             if (annotate_info->text == (char *) NULL)                return(False);4             annotate_info->y+=annotate_info->height;9             if (annotate_info->y > windows->image.height) 5               annotate_info->y=annotate_info->height; 7             annotate_info->next=(XAnnotateInfo *) NULL;              x=annotate_info->x;              y=annotate_info->y; "             p=annotate_info->text;             break;           } 	         }          break;       }        case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);           state&=(~ModifierState);         break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;
         /*7           Annotate Image window with primary selection. 
         */"         for (i=0; i < length; i++)	         {            if (data[i] != '\n')
             {                /*<                 Draw a single character on the Image window.               */               *p=data[i]; N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);+               x+=XTextWidth(font_info,p,1);                p++;I               if ((x+font_info->max_bounds.width) < windows->image.width)                  continue; 
             }            /*-             Advance to the next line of text.            */           *p='\0';H           annotate_info->width=XTextWidth(font_info,annotate_info->text,)             strlen(annotate_info->text)); <           if (annotate_info->next != (XAnnotateInfo *) NULL)
             {                /*,                 Line of text already exists.               */0               annotate_info=annotate_info->next;!               x=annotate_info->x; !               y=annotate_info->y; $               p=annotate_info->text;               continue; 
             } N           annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));<           if (annotate_info->next == (XAnnotateInfo *) NULL)             return(False);0           *annotate_info->next=(*annotate_info);6           annotate_info->next->previous=annotate_info;,           annotate_info=annotate_info->next;D           annotate_info->text=(char *) malloc((windows->image.width/@             Max(font_info->min_bounds.width,1)+2)*sizeof(char));3           if (annotate_info->text == (char *) NULL)              return(False);2           annotate_info->y+=annotate_info->height;7           if (annotate_info->y > windows->image.height) 3             annotate_info->y=annotate_info->height; 5           annotate_info->next=(XAnnotateInfo *) NULL;            x=annotate_info->x;            y=annotate_info->y;             p=annotate_info->text;	         }          XFree((void *) data);          break;       }        default:         break;     } !   } while (!(state & ExitState));    XFreeCursor(display,cursor);   /*2     Annotation is relative to image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    /*     Initialize annotated image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);1   while (annotate_info != (XAnnotateInfo *) NULL)    { "     if (annotate_info->width == 0)       { 
         /*>           No text on this line--  go to the next line of text.
         */.         previous_info=annotate_info->previous;+         free((char *) annotate_info->text); %         free((char *) annotate_info); $         annotate_info=previous_info;         continue;        }      /*2       Determine pixel index for box and pen color.     */)     windows->image.pixel_info->box_color= 4       windows->image.pixel_info->pen_colors[box_id];/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == @             windows->image.pixel_info->pen_colors[box_id].pixel)           { 3             windows->image.pixel_info->box_index=i;              break;           } )     windows->image.pixel_info->pen_color= 4       windows->image.pixel_info->pen_colors[pen_id];/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == @             windows->image.pixel_info->pen_colors[pen_id].pixel)           { 3             windows->image.pixel_info->pen_index=i;              break;           }      /**       Define the annotate geometry string.     */9     x_factor=UpShift(width)/windows->image.ximage->width; '     annotate_info->x+=windows->image.x; :     annotate_info->x=DownShift(annotate_info->x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height; ;     annotate_info->y+=(windows->image.y-font_info->ascent); :     annotate_info->y=DownShift(annotate_info->y*y_factor);9     (void) sprintf(annotate_info->geometry,"%ux%u%+d%+d", >       (unsigned int) DownShift(annotate_info->width*x_factor),?       (unsigned int) DownShift(annotate_info->height*y_factor), -       annotate_info->x+x,annotate_info->y+y);      /*       Annotate image with text.      */     status= L       XAnnotateImage(display,windows->image.pixel_info,annotate_info,image);     if (status == 0)       return(False);     /*       Free up memory.      */*     previous_info=annotate_info->previous;'     free((char *) annotate_info->text); !     free((char *) annotate_info);       annotate_info=previous_info;   } *   XSetForeground(display,annotate_context,7     windows->image.pixel_info->foreground_color.pixel); *   XSetBackground(display,annotate_context,7     windows->image.pixel_info->background_color.pixel); C   XSetFont(display,annotate_context,windows->image.font_info->fid); )   XSetCursorState(display,windows,False);    XFreeFont(display,font_info);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B a c k g r o u n d I m a g e                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBackgroundImage displays the image in the background of a window. % 1 %  The format of the XBackgroundImage routine is:  % A %    status=XBackgroundImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o status: Function XBackgroundImage return True if the image isJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */6 static unsigned int XBackgroundImage(Display *display,?   XResourceInfo *resource_info,XWindows *windows,Image **image)  { = #define BackgroundImageText  "  Backgrounding the image...  "   
   static char &     window_id[MaxTextLength] = "root";     XResourceInfo      background_resources;      unsigned int     status;      /*     Put image in background.   */4   status=XDialogWidget(display,windows,"Background",H     "Enter window id (id 0x00 selects window with pointer):",window_id);   if (*window_id == '\0')      return(False);M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); 3   XInfoWidget(display,windows,BackgroundImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);(   background_resources=(*resource_info);+   background_resources.window_id=window_id; '   background_resources.backdrop=status; G   status=XDisplayBackgroundImage(display,&background_resources,*image); 
   if (status) C     XClientMessage(display,windows->image.id,windows->im_protocols, -       windows->im_retain_colors,CurrentTime); )   XSetCursorState(display,windows,False); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ) %  Function XChopImage chops the X image.  % + %  The format of the XChopImage routine is:  % ; %    status=XChopImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % > %    o status: Function XChopImage return True if the image isF %      cut.  False is returned is there is a memory shortage or if the %      image fails to cut. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */M static unsigned int XChopImage(Display *display,XResourceInfo *resource_info, "   XWindows *windows,Image **image) {  #define ChopModeDirectionOp  0 #define ChopModeHelpOp  1  #define ChopModeDismissOp  2 #define HorizontalChopOp  0  #define VerticalChopOp  1   
   static char      *ChopModeMenu[]=     {        "Direction",
       "Help",        "Dismiss",       (char *) NULL      };     char     text[MaxTextLength];     Image      *chop_image;     int      id,      x,     y;     RectangleInfo      chop_info;     static unsigned int !     direction = HorizontalChopOp;      unsigned int
     distance,      height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;  
   XSegment     segment_info;      /*     Map Command widget.    */   windows->command.name="Chop";    windows->command.data=1;F   (void) XCommandWidget(display,windows,ChopModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,ChopModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { #           case ChopModeDirectionOp:            {              char%               command[MaxTextLength];                static char                *Directions[]=               {                  "horizontal",                  "vertical",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             direction=O               XMenuWidget(display,windows,ChopModeMenu[id],Directions,command);              break;           }            case ChopModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);             break;           } !           case ChopModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*=           User has committed to start point of chopting line. 
         */(         segment_info.x1=event.xbutton.x;(         segment_info.x2=event.xbutton.x;(         segment_info.y1=event.xbutton.y;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */?         (void) XLookupString((XKeyEvent *) &event.xkey,command, ?           sizeof(command),&key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);        }      } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*B     Draw line as pointer moves until the mouse button is released.   */   chop_info.width=0;   chop_info.height=0;    chop_info.x=0;   chop_info.y=0;
   distance=0; B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (distance > 9)        { 
         /*.           Display info and draw chopping line.
         */"         if (!windows->info.mapped)/           XMapWindow(display,windows->info.id); L         (void) sprintf(text," %ux%u%+d%+d",chop_info.width,chop_info.height,#           chop_info.x,chop_info.y); *         XInfoWidget(display,windows,text);1         XHighlightLine(display,windows->image.id, :           windows->image.highlight_context,&segment_info);       }      else       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      if (distance > 9) /       XHighlightLine(display,windows->image.id, 8         windows->image.highlight_context,&segment_info);     switch (event.type)      {        case ButtonPress:        { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;         break;       }        case ButtonRelease:        { 
         /*.           User has committed to chopping line.
         */(         segment_info.x2=event.xbutton.x;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case Expose:         break;       case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;       }        default:         break;     }      /*        Check boundary conditions.     */     if (segment_info.x2 < 0)       segment_info.x2=0;     else9       if (segment_info.x2 > windows->image.ximage->width) 5         segment_info.x2=windows->image.ximage->width;      if (segment_info.y2 < 0)       segment_info.y2=0;     else:       if (segment_info.y2 > windows->image.ximage->height)6         segment_info.y2=windows->image.ximage->height;
     distance= L       ((segment_info.x2-segment_info.x1)*(segment_info.x2-segment_info.x1))+L       ((segment_info.y2-segment_info.y1)*(segment_info.y2-segment_info.y1));     /*        Compute chopping geometry.     */&     if (direction == HorizontalChopOp)       { :         chop_info.width=segment_info.x2-segment_info.x1+1;5         chop_info.x=windows->image.x+segment_info.x1;          chop_info.height=0;          chop_info.y=0;.         if (segment_info.x1 > segment_info.x2)           { >             chop_info.width=segment_info.x1-segment_info.x2+1;9             chop_info.x=windows->image.x+segment_info.x2;            }        }      else       {          chop_info.width=0;;         chop_info.height=segment_info.y2-segment_info.y1+1;          chop_info.x=0;5         chop_info.y=windows->image.y+segment_info.y1; .         if (segment_info.y1 > segment_info.y2)           { ?             chop_info.height=segment_info.y1-segment_info.y2+1; 9             chop_info.y=windows->image.y+segment_info.y2;            }        } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (distance <= 9)     return(True);    /*6     Image chopping is relative to image configuration.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   windows->image.window_changes.width=1     windows->image.ximage->width-chop_info.width; '   windows->image.window_changes.height= 3     windows->image.ximage->height-chop_info.height;    x=0;   y=0;   width=(*image)->columns;   height=(*image)->rows;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    chop_info.x+=x; 2   chop_info.x=DownShift(chop_info.x*scale_factor);:   chop_info.width=DownShift(chop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    chop_info.y+=y; 2   chop_info.y=DownShift(chop_info.y*scale_factor);<   chop_info.height=DownShift(chop_info.height*scale_factor);   /*     Chop image.    */*   chop_image=ChopImage(*image,&chop_info);)   XSetCursorState(display,windows,False); #   if (chop_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=chop_image;   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r E d i t I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XColorEditImage allows the user to interactively change K %  the color of one pixel for a DirectColor image or one colormap entry for G %  a PseudoClass image.  The floodfill algorithm is strongly based on a : %  similiar algorithm in "Graphics Gems" by Paul Heckbert. % 0 %  The format of the XColorEditImage routine is: % 9 %    XColorEditImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */  H static void ColorFloodfill(Image *image,int x,int y,const XColor xcolor,   const int delta) {    int      offset, 	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;      register XSegment      *p;      RunlengthPacket 
     color,     target;   
   XSegment     *segment_stack;      /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))      return; +   target=image->pixels[y*image->columns+x]; #   color.red=XDownScale(xcolor.red); '   color.green=XDownScale(xcolor.green); %   color.blue=XDownScale(xcolor.blue); %   if (ColorMatch(color,target,delta))      return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)      { D       Warning("Unable to recolor image","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */
   start=0;   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;      offset=p->y2;      y=p->y1+offset;      /*!       Recolor neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); +       if (!ColorMatch(*pixel,target,delta))          break;       pixel->red=color.red;        pixel->green=color.green;        pixel->blue=color.blue;      }      skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) %           Push(y,start,x1-1,-offset);          x=x1+1;        }      do     {        if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); 1             if (!ColorMatch(*pixel,target,delta))                break;!             pixel->red=color.red; %             pixel->green=color.green; #             pixel->blue=color.blue;            } #           Push(y,start,x-1,offset);            if (x > (x2+1)) %             Push(y,x2+1,x-1,-offset); 	         }        skip=False;        for (x++; x <= x2 ; x++)       { 1         pixel=image->pixels+(y*image->columns+x); ,         if (ColorMatch(*pixel,target,delta))           break;       }        start=x;     } while (x <= x2);   }    free((char *) segment_stack);  }   5 static unsigned int XColorEditImage(Display *display, ?   XResourceInfo *resource_info,XWindows *windows,Image **image)  {  #define ColorEditColorOp  0  #define ColorEditMethodOp  1 #define ColorEditDeltaOp  2  #define ColorEditUndoOp  3 #define ColorEditHelpOp  4 #define ColorEditDismissOp  5   
   static char      *ColorEditMenu[]=      {        "Pixel Color",       "Method",        "Delta",
       "Undo", 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int 
     entry,     id,      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *p;      static unsigned int      delta = 0,     method = PointMethodOp,      pen_id = 0;      unsigned int     height, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XColor
     color;     XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Color Edit";    windows->command.data=3;G   (void) XCommandWidget(display,windows,ColorEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,ColorEditMenu,&event);         if (id < 0)            { <             XDefineCursor(display,windows->image.id,cursor);             continue;            }          switch (id) 	         {             case ColorEditColorOp:           {              char(               *ColorMenu[MaxNumberPens];               int                pen_number;                /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];4             ColorMenu[MaxNumberPens-2]="Browser...";5             ColorMenu[MaxNumberPens-1]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */O             pen_number=XMenuWidget(display,windows,ColorEditMenu[id],ColorMenu,                command);              if (pen_number < 0)                break;0             if (pen_number == (MaxNumberPens-2))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } !           case ColorEditMethodOp:            {              static char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             entry=P               XMenuWidget(display,windows,ColorEditMenu[id],MethodMenu,command);             if (entry >= 0)                method=entry;              break;           }             case ColorEditDeltaOp:           {              static char                *DeltaMenu[]=                {                  "0",                 "1",                 "2",                 "4",                 "8",                 "16",                  "32",                  (char *) NULL,                 (char *) NULL,               },)               value[MaxTextLength] = "3";                /*8               Select a delta value from the pop-up menu.             */%             DeltaMenu[7]="Dialog..."; J             entry=XMenuWidget(display,windows,ColorEditMenu[id],DeltaMenu,               command);              if (entry < 0)               break;             if (entry != 7)                { -                 delta=atoi(DeltaMenu[entry]);                  break;               } K             (void) XDialogWidget(display,windows,"Ok","Enter delta value:",                value);              if (*value == '\0')                break;             delta=atoi(value);             break;           }            case ColorEditUndoOp:            { B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);              break;           }            case ColorEditHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           } "           case ColorEditDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           } 	         } 8         XDefineCursor(display,windows->image.id,cursor);         continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Exit loop.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { 
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     }      x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)        {          int            x,           y;  
         /*8           Pixel edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True); <         color=windows->image.pixel_info->pen_colors[pen_id];G         XPutPixel(windows->image.ximage,x_offset,y_offset,color.pixel);          x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); =         x_factor=UpShift(width)/windows->image.ximage->width; C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x; ?         y_factor=UpShift(height)/windows->image.ximage->height; C         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y; -         if ((x_offset < 0) || (y_offset < 0))            continue; L         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue;          switch (method) 	         {            case PointMethodOp:            default:           {              /*=               Update color information using point algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset); )             p->red=XDownScale(color.red); -             p->green=XDownScale(color.green); +             p->blue=XDownScale(color.blue);              break;           }            case ReplaceMethodOp:            {              RunlengthPacket                target;                /*?               Update color information using replace algorithm.              */             x=0;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {                x+=(p->length+1); <               if (x > (y_offset*(*image)->columns+x_offset))                 break;               p++;
             } '             target=(*image)->pixels[i]; /             if ((*image)->class == DirectClass)                { #                 p=(*image)->pixels; 5                 for (i=0; i < (*image)->packets; i++)                  { 2                   if (ColorMatch(*p,target,delta))                     { 3                       p->red=XDownScale(color.red); 7                       p->green=XDownScale(color.green); 5                       p->blue=XDownScale(color.blue);                      }                    p++;                 }                }              else               { 4                 for (i=0; i < (*image)->colors; i++)E                   if (ColorMatch((*image)->colormap[i],target,delta))                      { F                       (*image)->colormap[i].red=XDownScale(color.red);J                       (*image)->colormap[i].green=XDownScale(color.green);H                       (*image)->colormap[i].blue=XDownScale(color.blue);                     } "                 SyncImage(*image);               }              break;           } !           case FloodfillMethodOp:            {              /*A               Update color information using floodfill algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;A             ColorFloodfill(*image,x_offset,y_offset,color,delta);              break;           }            case ResetMethodOp:            {              /*=               Update color information using reset algorithm.              */(             (*image)->class=DirectClass;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             { +               p->red=XDownScale(color.red); /               p->green=XDownScale(color.green); -               p->blue=XDownScale(color.blue);                p++;
             }              break;           } 	         } +         state&=(~UpdateConfigurationState);        } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m p o s i t e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XCompositeImage requests an image name from the user, reads M %  the image and composites it with the X window image at a location the user  %  chooses with the pointer. % 0 %  The format of the XCompositeImage routine is: % @ %    status=XCompositeImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % D %    o status: Function XCompositeImage returns True if the image isM %      composited.  False is returned is there is a memory shortage or if the $ %      image fails to be composited. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */5 static unsigned int XCompositeImage(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) { # #define CompositeModeOperatorsOp  0  #define CompositeModeBlendOp  1  #define CompositeModeHelpOp  2! #define CompositeModeDismissOp  3   
   static char      *CompositeModeMenu[]=      {        "Operators",       "Blend",
       "Help",        "Dismiss",       (char *) NULL      },#     filename[MaxTextLength] = "\0";      char     text[MaxTextLength];     Cursor     cursor;      double
     blend;     Image      *composite_image;      int      id,      x,     y;     RectangleInfo      highlight_info,      composite_info;      static unsigned int #     operation = ReplaceCompositeOp;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*&     Request image file name from user.   */;   XFileBrowserWidget(display,windows,"Composite",filename);    if (*filename == '\0')     return(True);    /*     Read image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);7   composite_image=ReadImage(resource_info->image_info); )   XSetCursorState(display,windows,False); (   if (composite_image == (Image *) NULL)     { F       XNoticeWidget(display,windows,"Unable to read image:",filename);       return(False);     }    /*     Map Command widget.    */$   windows->command.name="Composite";   windows->command.data=1;K   (void) XCommandWidget(display,windows,CompositeModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);&   composite_info.x=windows->image.x+x;&   composite_info.y=windows->image.y+y;   composite_info.width=0;    composite_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); 0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   blend=0.0;   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */J         (void) sprintf(text," %+d%+d ",composite_info.x,composite_info.y);*         XInfoWidget(display,windows,text);       } "     highlight_info=composite_info;7     highlight_info.x=composite_info.x-windows->image.x; 7     highlight_info.y=composite_info.y-windows->image.y; 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */D         id=XCommandWidget(display,windows,CompositeModeMenu,&event);         if (id < 0)            continue;          switch (id) 	         { (           case CompositeModeOperatorsOp:           {              char%               command[MaxTextLength];                static char                *OperatorMenu[]=               {                  "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",                  "bumpmap",                 "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */H             operation=XMenuWidget(display,windows,CompositeModeMenu[id],&               OperatorMenu,command)+1;             break;           } $           case CompositeModeBlendOp:           {              static char -               factor[MaxTextLength] = "20.0";                /*3               Blend the two images a given percent.              */J             XSetFunction(display,windows->image.highlight_context,GXcopy);9             (void) XDialogWidget(display,windows,"Blend", >               "Enter the blend factor (0.0 - 99.9%):",factor);L             XSetFunction(display,windows->image.highlight_context,GXinvert);              if (*factor == '\0')               break;             blend=atof(factor);              break;           } #           case CompositeModeHelpOp:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           } &           case CompositeModeDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Change cursor.
         */6         composite_info.width=composite_image->columns;4         composite_info.height=composite_image->rows;8         XDefineCursor(display,windows->image.id,cursor);:         composite_info.x=windows->image.x+event.xbutton.x;:         composite_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); H         if ((composite_info.width != 0) && (composite_info.height != 0))           {              /*D               User has selected the location of the composite image.             */>             composite_info.x=windows->image.x+event.xbutton.x;>             composite_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;            int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */*             DestroyImage(composite_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); ,         composite_info.x=windows->image.x+x;,         composite_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*9     Image compositing is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    composite_info.x+=x;<   composite_info.x=DownShift(composite_info.x*scale_factor);D   composite_info.width=DownShift(composite_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    composite_info.y+=y;<   composite_info.y=DownShift(composite_info.y*scale_factor);F   composite_info.height=DownShift(composite_info.height*scale_factor);;   if ((composite_info.width != composite_image->columns) || 7       (composite_info.height != composite_image->rows))      {        Image          *zoomed_image;         /*         Scale composite image.       */B       zoomed_image=ZoomImage(composite_image,composite_info.width,.         composite_info.height,MitchellFilter);$       DestroyImage(composite_image);)       if (zoomed_image == (Image *) NULL) 	         { 1           XSetCursorState(display,windows,False);            return(False);	         } #       composite_image=zoomed_image;      }    if (blend != 0.0)      {        register int
         i;         register RunlengthPacket         *p;          unsigned short         index;         /*#         Create mattes for blending.        */C       index=(unsigned short) (((int) DownScale(MaxRGB)*blend)/100); )       composite_image->class=DirectClass; "       composite_image->matte=True;        p=composite_image->pixels;2       for (i=0; i < composite_image->packets; i++)       {          p->index=index;          p++;       }        index=(unsigned short)F         ((int) DownScale(MaxRGB)-((int) DownScale(MaxRGB)*blend)/100);       image->class=DirectClass;        image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          p->index=index;          p++;       } !       operation=BlendCompositeOp;      }    /*(     Composite image with X Image window.   */B   CompositeImage(image,operation,composite_image,composite_info.x,     composite_info.y);    DestroyImage(composite_image);)   XSetCursorState(display,windows,False);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e C o l o r m a p                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XConfigureImageColormap creates a new X colormap.  % 8 %  The format of the XConfigureImageColormap routine is: % A %    XConfigureImageColormap(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */5 static void XConfigureImageColormap(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) { 
   Colormap
     colormap;      /*     Make standard colormap.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);5   if (image->packets == (image->columns*image->rows))      CompressImage(image); I   XMakeStandardColormap(display,windows->image.visual_info,resource_info, =     image,windows->image.map_info,windows->image.pixel_info); -   colormap=windows->image.map_info->colormap; 9   XSetWindowColormap(display,windows->image.id,colormap); ;   XSetWindowColormap(display,windows->command.id,colormap); :   XSetWindowColormap(display,windows->widget.id,colormap);   if (windows->magnify.mapped)=     XSetWindowColormap(display,windows->magnify.id,colormap);    if (windows->pan.mapped)9     XSetWindowColormap(display,windows->pan.id,colormap); )   XSetCursorState(display,windows,False); A   XClientMessage(display,windows->image.id,windows->im_protocols, -     windows->im_update_colormap,CurrentTime);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XConfigureImage creates a new X image.  It also notifies theL %  window manager of the new image size and configures the transient widows. % 0 %  The format of the XConfigureImage routine is: % @ %    status=XConfigureImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o status: Function XConfigureImage returns True if the window is J %      resized.  False is returned is there is a memory shortage or if the %      window fails to resize. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */5 static unsigned int XConfigureImage(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) {    unsigned int     height, 	     mask,      status, 
     width,
     x_factor, 
     y_factor;      XSizeHints     *size_hints;     XWindowChanges     window_changes;      /**     Dismiss if window dimensions are zero.   */,   width=windows->image.window_changes.width;.   height=windows->image.window_changes.height;   if (resource_info->debug) <     (void) fprintf(stderr,"Configure Image: %dx%d=>%ux%u\n",O       windows->image.ximage->width,windows->image.ximage->height,width,height);    if ((width*height) == 0)     return(True);    /*0     Resize image to fit Image window dimensions.   */(   XSetCursorState(display,windows,True);   XFlush(display);7   x_factor=UpShift(width)/windows->image.ximage->width; 9   y_factor=UpShift(height)/windows->image.ximage->height; N   status=XMakeImage(display,resource_info,&windows->image,image,width,height);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);   if (status == False)A     XNoticeWidget(display,windows,"Unable to configure X image:",        windows->image.name);    /*3     Notify window manager of the new configuration.    */;   if (width > XDisplayWidth(display,windows->image.screen)) 7     width=XDisplayWidth(display,windows->image.screen);    window_changes.width=width; =   if (height > XDisplayHeight(display,windows->image.screen)) 9     height=XDisplayHeight(display,windows->image.screen);    window_changes.height=height;    mask=CWWidth | CWHeight;   if (resource_info->backdrop)     {        mask|=CWX | CWY;       window_changes.x= I         (XDisplayWidth(display,windows->image.screen) >> 1)-(width >> 1);        window_changes.y= K         (XDisplayHeight(display,windows->image.screen) >> 1)-(height >> 1);      } L   XReconfigureWMWindow(display,windows->image.id,windows->image.screen,mask,     &window_changes);    if (image->matte) ,     XClearWindow(display,windows->image.id);;   if ((x_factor == UpShift(1)) || (y_factor == UpShift(1))) <     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*(     Update Magnify window configuration.   */<   windows->magnify.x=DownShift(x_factor*windows->magnify.x);<   windows->magnify.y=DownShift(y_factor*windows->magnify.y);   if (windows->magnify.mapped)'     XMakeMagnifyImage(display,windows);    /*$     Update pan window configuration.   */8   windows->image.x=DownShift(x_factor*windows->image.x);8   windows->image.y=DownShift(y_factor*windows->image.y);:   windows->pan.crop_geometry=windows->image.crop_geometry;-   XBestIconSize(display,&windows->pan,image); -   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;      windows->pan.height<<=1;   } -   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,        &windows->pan.height);*   window_changes.width=windows->pan.width;,   window_changes.height=windows->pan.height;   size_hints=XAllocSizeHints(); (   if (size_hints != (XSizeHints *) NULL)     {        /*         Set new size hints.        */4       size_hints->flags=PSize | PMinSize | PMaxSize;-       size_hints->width=window_changes.width; /       size_hints->height=window_changes.height; .       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;:       XSetNormalHints(display,windows->pan.id,size_hints);!       XFree((void *) size_hints);      } L   XReconfigureWMWindow(display,windows->pan.id,windows->pan.screen,CWWidth |     CWHeight,&window_changes);   if (windows->pan.mapped)7     XMakePanImage(display,resource_info,windows,image);    /*%     Update icon window configuration.    */;   windows->icon.crop_geometry=windows->image.crop_geometry; .   XBestIconSize(display,&windows->icon,image);+   window_changes.width=windows->icon.width; -   window_changes.height=windows->icon.height; E   XReconfigureWMWindow(display,windows->icon.id,windows->icon.screen, (     CWWidth | CWHeight,&window_changes);)   XSetCursorState(display,windows,False);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C r o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XCropImage allows the user to select a region of the image andI %  crop, copy, or cut it.  For copy or cut, the image can subsequently be . %  composited onto the image with XPasteImage. % + %  The format of the XCropImage routine is:  % @ %    status=XCropImage(display,resource_info,windows,image,mode) % + %  A description of each parameter follows:  % ? %    o status: Function XCropImage returns True if the image is J %      copyped.  False is returned is there is a memory shortage or if the! %      image fails to be copyped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  % F %    o mode: This unsigned value specified whether the image should be %      cropped, copied, or cut.  %  %  */M static unsigned int XCropImage(Display *display,XResourceInfo *resource_info, 9   XWindows *windows,Image *image,const unsigned int mode)  {  #define CropModeHelpOp  0  #define CropModeDismissOp  1 #define RectifyModeCopyOp  0 #define RectifyModeHelpOp  1 #define RectifyModeDismissOp  2   
   static char      *CropModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Crop", 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      Image      *crop_image;     RectangleInfo      crop_info,     highlight_info;      register RunlengthPacket     *p;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.    */   switch (mode)    {      case CopyMode:     { #       windows->command.name="Copy";        break;     }      case CropMode:     { #       windows->command.name="Crop";        break;     }      case CutMode:      { "       windows->command.name="Cut";       break;     }    } +   RectifyModeMenu[0]=windows->command.name;    windows->command.data=0;F   (void) XCommandWidget(display,windows,CropModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);!   crop_info.x=windows->image.x+x; !   crop_info.y=windows->image.y+y;    crop_info.width=0;   crop_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",crop_info.x,crop_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CropModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         {            case CropModeHelpOp:           {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           } !           case CropModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*B               Note first corner of cropping rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);9             crop_info.x=windows->image.x+event.xbutton.x; 9             crop_info.y=windows->image.y+event.xbutton.y;              state|=ExitState;              break;           }          break;       }        case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         crop_info.x=windows->image.x+x; '         crop_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /**         User want to exit without croping.       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=crop_info.x;     y=crop_info.y;     crop_info.width=0;     crop_info.height=0;      state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw cropping rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*4             User has committed to croping rectangle.           */7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y; 1           XSetCursorState(display,windows,False);            state|=ExitState; ;           if (strcmp(windows->command.name,"Rectify") == 0)              break;*           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            break;	         }          case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 7           crop_info.x=windows->image.x+event.xmotion.x; 7           crop_info.y=windows->image.y+event.xmotion.y; 	         }          default:           break;       } L       if (((crop_info.x != x) && (crop_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (crop_info.x < 0)             crop_info.x=0;           else;             if (crop_info.x > windows->image.ximage->width) 7               crop_info.x=windows->image.ximage->width;            if (crop_info.x < x);             crop_info.width=(unsigned int) (x-crop_info.x);            else
             { =               crop_info.width=(unsigned int) (crop_info.x-x);                crop_info.x=x;
             }            if (crop_info.y < 0)             crop_info.y=0;           else<             if (crop_info.y > windows->image.ximage->height)8               crop_info.y=windows->image.ximage->height;           if (crop_info.y < y)<             crop_info.height=(unsigned int) (y-crop_info.y);           else
             { >               crop_info.height=(unsigned int) (crop_info.y-y);               crop_info.y=y;
             } 	         } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     {        if (windows->info.mapped) 	         {            /*%             Display pointer position.            */N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);	         }        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;            break;	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */H           XSetFunction(display,windows->image.highlight_context,GXcopy);D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);J           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);           if (id >= 0)             switch (id) 
             { %               case RectifyModeCopyOp:                { !                 state|=ExitState;                  break;               } %               case RectifyModeHelpOp:                { N                 XSetFunction(display,windows->image.highlight_context,GXcopy);                 switch (mode)                  {                     case CopyMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,C                       "Help Viewer - Image Copying",ImageCopyHelp);                      break;                   }                     case CropMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,D                       "Help Viewer - Image Cropping",ImageCropHelp);                     break;                   }                    case CutMode:                    { H                     XTextViewWidget(display,resource_info,windows,False,B                       "Help Viewer - Image Cutting",ImageCutHelp);                     break;                   }                  } P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               } (               case RectifyModeDismissOp:               {                  /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;                  break;               }                default:                 break;
             }            continue; 	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 6               crop_info.x=crop_info.x+crop_info.width;7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { 6               crop_info.x=crop_info.x+crop_info.width;.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease:            break;         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x; 1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         { 5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);               switch (mode)                {                  case CopyMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,A                     "Help Viewer - Image Copying",ImageCopyHelp);                    break;                 }                  case CropMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,B                     "Help Viewer - Image Cropping",ImageCropHelp);                   break;                 }                  case CutMode:                  { F                   XTextViewWidget(display,resource_info,windows,False,@                     "Help Viewer - Image Cutting",ImageCutHelp);                   break;                 }                } N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case KeyRelease:           break;         case MotionNotify:	         {            /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));            x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState)); !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);    if (mode == CropMode) <     if ((crop_info.width != windows->image.ximage->width) ||<         (crop_info.height != windows->image.ximage->height))       { 
         /*D           Reconfigure Image window as defined by cropping rectangle.
         */;         XSetCropGeometry(display,windows,&crop_info,image); <         windows->image.window_changes.width=crop_info.width;>         windows->image.window_changes.height=crop_info.height;D         (void) XConfigureImage(display,resource_info,windows,image);         return(True);        }    /*0     Copy image before applying image transforms.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    crop_info.x+=x; 2   crop_info.x=DownShift(crop_info.x*scale_factor);:   crop_info.width=DownShift(crop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    crop_info.y+=y; 2   crop_info.y=DownShift(crop_info.y*scale_factor);<   crop_info.height=DownShift(crop_info.height*scale_factor);)   crop_image=CropImage(image,&crop_info); )   XSetCursorState(display,windows,False); #   if (crop_image == (Image *) NULL)      return(False);#   if (copy_image != (Image *) NULL)      DestroyImage(copy_image);    copy_image=crop_image;   if (mode == CopyMode)      { B       (void) XConfigureImage(display,resource_info,windows,image);       return(True);      }    /*     Cut image.   */   image->class=DirectClass;    if (!image->matte)     {        /*         Initialize matte data.       */       p=image->pixels;(       for (x=0; x < image->packets; x++)       {          p->index=Opaque;         p++;       }        image->matte=True;     }    if (UncompressImage(image)) (     for (y=0; y < crop_info.height; y++)     { A       p=image->pixels+(crop_info.y+y)*image->columns+crop_info.x; )       for (x=0; x < crop_info.width; x++)        {          p->index=Transparent;          p++;       }      }    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y B a c k g r o u n d I m a g e                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayBackgroundImage displays an image in the background of a
 %  window. % 8 %  The format of the XDisplayBackgroundImage routine is: % B %      status=XDisplayBackgroundImage(display,resource_info,image) % + %  A description of each parameter follows:  % C %    o status: Function XDisplayBackgroundImage returns True if the , %      designated window is the root window. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */= static unsigned int XDisplayBackgroundImage(Display *display, ,   XResourceInfo *resource_info,Image *image) {    char     visual_type[MaxTextLength];      unsigned int     height,      status, 
     width;     Window     root_window;     XGCValues      context_values;      XPixelInfo     pixel_info;      XResourceInfo      resources;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      XWindowAttributes      window_attributes;  
   XWindowInfo      window_info;     /*     Determine target window.   */   window_info.id=(Window) NULL; %   window_info.ximage=(XImage *) NULL; *   window_info.matte_image=(XImage *) NULL;#   window_info.pixmap=(Pixmap) NULL; )   window_info.matte_pixmap=(Pixmap) NULL; "   window_info.shared_memory=False;;   root_window=XRootWindow(display,XDefaultScreen(display)); :   if (Latin1Compare(resource_info->window_id,"root") == 0)     window_info.id=root_window;    else     { -       if (isdigit(*resource_info->window_id)) ?         window_info.id=XWindowByID(display,root_window,(Window) F           strtol((char *) resource_info->window_id,(char **) NULL,0));*       if (window_info.id == (Window) NULL)         window_info.id= F           XWindowByName(display,root_window,resource_info->window_id);     } &   if (window_info.id == (Window) NULL)I     Error("No window with specified id exists",resource_info->window_id);    /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display)); K   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display)); '   (void) strcpy(visual_type,"default"); I   status=XGetWindowAttributes(display,window_info.id,&window_attributes);    if (status != False)'     (void) sprintf(visual_type,"0x%lx", 5       XVisualIDFromVisual(window_attributes.visual));    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) K     Error("Unable to create standard colormap","Memory allocation failed"); %   map_info->colormap=(Colormap) NULL; +   pixel_info.pixels=(unsigned long *) NULL; '   pixel_info.gamma_map=(XColor *) NULL;    /*     Initialize visual info.    */   resources=(*resource_info); #   resources.map_type=(char *) NULL; $   resources.visual_type=visual_type;;   visual_info=XBestVisualInfo(display,map_info,&resources); *   if (visual_info == (XVisualInfo *) NULL)=     Error("Unable to get visual",resource_info->visual_type);    /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);   /*     Initialize colormap.   */$   resources.colormap=SharedColormap;F   XMakeStandardColormap(display,visual_info,&resources,image,map_info,     &pixel_info);    /*     Graphic context superclass.    */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);   /*'     Initialize Image window attributes.    */O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,       resource_info,&window_info);   /*     Create the X image.%   */#   window_info.width=image->columns;%3   if (window_info.width >= window_attributes.width) .     window_info.width=window_attributes.width;!   window_info.height=image->rows; 5   if (window_info.height >= window_attributes.height) 0     window_info.height=window_attributes.height;O   status=XMakeImage(display,resource_info,&window_info,image,window_info.width,      window_info.height);   if (status == False)4     Error("Unable to create X image",(char *) NULL);   window_info.x=0;   window_info.y=0;   if (resource_info->debug)      { C       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",image->filename, 1         image->scene,image->columns,image->rows);L       if (image->colors != 0) 4         (void) fprintf(stderr,"%uc ",image->colors);2       (void) fprintf(stderr,"%s\n",image->magick);     }    /*I     Adjust image dimensions as specified by backdrop or geometry options.I   */   width=window_info.width;   height=window_info.height;   if (resource_info->backdrop)     {        /*$         Center image on root window.       */3       window_info.x=(window_attributes.width >> 1)- )         (window_info.ximage->width >> 1); 4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     } 5   if (resource_info->image_geometry != (char *) NULL)      { 
       char(         default_geometry[MaxTextLength];  	       int          flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints();N,       if (size_hints == (XSizeHints *) NULL)H         Error("Unable to display on window","Memory allocation failed");$       size_hints->flags=(long) NULL;<       (void) sprintf(default_geometry,"%ux%u",width,height);4       flags=XWMGeometry(display,visual_info->screen,7         resource_info->image_geometry,default_geometry,tJ         window_info.border_width,size_hints,&window_info.x,&window_info.y,1         (int *) &width,(int *) &height,&gravity);s$       if (flags & (XValue | YValue))	         {I(           width=window_attributes.width;*           height=window_attributes.height;	         } !       XFree((void *) size_hints);s     }    /*     Create the X pixmap.   */   window_info.pixmap=oI     XCreatePixmap(display,window_info.id,width,height,window_info.depth);o*   if (window_info.pixmap == (Pixmap) NULL)5     Error("Unable to create X pixmap",(char *) NULL);e   /*!     Display pixmap on the window.    */C   if ((width > window_info.width) || (height > window_info.height)) K     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,a       0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,C     window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);    /*     Free resources.e   */*   XFreePixmap(display,window_info.pixmap);$   XDestroyImage(window_info.ximage);0   XFreeGC(display,window_info.annotate_context);*   XFreeCursor(display,window_info.cursor);/   XFreeCursor(display,window_info.busy_cursor); $   if (window_info.id != root_window)D     XFreeStandardColormap(display,visual_info,map_info,&pixel_info);   else     {i.       XUndefineCursor(display,window_info.id);6       if (pixel_info.pixels != (unsigned long *) NULL))         free((char *) pixel_info.pixels);n2       if (pixel_info.gamma_map != (XColor *) NULL),         free((char *) pixel_info.gamma_map);     }n   XFree((void *) map_info);n   XFree((void *) visual_info);(   return(window_info.id == root_window); }t h /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %iO %                                                                             %nO %                                                                             %nO %   X D i s p l a y I m a g e                                                 %aO %                                                                             %tO %                                                                             %eO %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %eL %  Function XDisplayImage displays an image via X11.  A new image is createdI %  and returned if the user interactively transforms the displayed image.  % . %  The format of the XDisplayImage routine is: %YN %      loaded_image=XDisplayImage(display,resource_info,argv,argc,image,state) %o+ %  A description of each parameter follows:  %oF %    o loaded_image:  Function XDisplayImage returns an image when theF %      user chooses 'Load Image' from the command menu or picks a tileE %      from the image directory.  Otherwise a null image is returned.e %cE %    o display: Specifies a connection to an X server;  returned fromt %      XOpenDisplay. %gK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.h % 7 %    o argv: Specifies the application's argument list.y %t/ %    o argc: Specifies the number of arguments.o % G %    o image: Specifies an address to an address of an Image structure;  %      returned from ReadImage.  %o %  */J static Image *XDisplayImage(Display *display,XResourceInfo *resource_info,:   char **argv,int argc,Image **image,unsigned long *state) {-4 #define MagnifySize  256  /* must be a power of 2 */ #define MagickMenus  9 #define MaxWindows  10 #define MagickTitle  "Commands"   
   static char      *CommandMenu[]=      {e
       "File", 
       "Edit",a
       "View",t       "Transform",       "Enhance",       "Effects",       "Image Edit",        "Miscellany", 
       "Help",r       (char *) NULLa     },     *FileMenu[]=     {a       "Load...",
       "Next",a       "Former",s       "Select...",       "Save...",       "Print...",h       "Delete...",       "Canvas...",       "Visual Directory...",
       "Quit",a       (char *) NULLo     },     *EditMenu[]=     {k
       "Undo", 
       "Redo",        "Cut",
       "Copy",i       "Paste",       (char *) NULLn     },     *ViewMenu[]=     {n       "Half Size",       "Original Size",       "Double Size",       "Resize...",       "Apply",       "Refresh",       "Restore",       (char *) NULLg     },     *TransformMenu[]=f     {s
       "Crop", 
       "Chop",u
       "Flop",i
       "Flip",        "Rotate Right",h       "Rotate Left",       "Rotate...",       "Shear...",o       "Trim Edges",g       (char *) NULLo     },     *EnhanceMenu[]=      {        "Hue...",        "Saturation...",       "Brightness...",       "Gamma...",        "Spiff",
       "Dull",        "Equalize",-       "Normalize",       "Negate",        "Grayscale",       "Quantize...",       (char *) NULL      },     *EffectsMenu[]=      {        "Despeckle",       "Peak Noise",i       "Sharpen...",        "Blur...",       "Edge Detect...",e       "Emboss...",       "Spread...",       "Swirl...",-       "Implode...",t       "Solarize...",       "Oil Painting...",       "Raise...",w       "Segment...",i       (char *) NULL      },     *ImageEditMenu[]=a     {f       "Annotate...",       "Draw...",       "Color...",m       "Matte...",a       "Composite...",        "Add Border...",       "Add Frame...",d       "Comment...",p       "Region of Interest...",       (char *) NULL      },     *MiscellanyMenu[]=     {a       "Image Info",i       "Zoom Image",a       "Show Histogram",s       "Background...",       "Slide Show...",       "Preferences...",c       (char *) NULLt     },     *HelpMenu[]=     {t       "Overview",c       "Browse Documentation",y       "About Display",       (char *) NULLo     },     *ShortCutsMenu[]=e     { 
       "Next",        "Former",        "Load...",       "Save...",
       "Undo",.       "Restore",       "Gamma...",        "Image Info",e
       "Quit",        (char *) NULLy     },     *ImmutableMenu[]=c     {        "Image Info",i
       "Quit",e       (char *) NULL:     };  
   static char      **Menus[MagickMenus]=      {(       FileMenu,S       EditMenu,        ViewMenu,r       TransformMenu,       EnhanceMenu,       EffectsMenu,       ImageEditMenu,       MiscellanyMenu,n       HelpMenu     };     static KeySym      CommandKeys[]=     {e       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,     },     FileKeys[]=      {        XK_l,        XK_n,        XK_f,        XK_F2,       XK_s,        XK_p,        XK_Delete,       XK_C,        XK_V, 
       XK_q     },     EditKeys[]=      {        XK_u,        XK_Redo,       XK_F3,       XK_F4,       XK_F5      },     ViewKeys[]=      {        XK_less,       XK_o,        XK_greater,        XK_percent,        XK_A,        XK_at,
       XK_r     },     TransformKeys[]=     {        XK_bracketleft,        XK_bracketright,
       XK_bar,        XK_minus,        XK_slash,        XK_backslash,        XK_asterisk,       XK_F6,
       XK_t     },     EnhanceKeys[]=     {%       XK_F7,       XK_F8,       XK_F9,       XK_g,d
       XK_F10, 
       XK_F11,t       XK_equal,i       XK_N,        XK_asciitilde,       XK_G,p       XK_numbersignr     },     EffectsKeys[]=     {        XK_D,h       XK_P,t       XK_S,p       XK_B,        XK_E,a       XK_M,y
       XK_F13,t
       XK_F14,o
       XK_F15,t
       XK_F16,        XK_O,        XK_asciicircum, 
       XK_Z     },     ImageEditKeys[]=     {p       XK_a,        XK_d,t       XK_c,        XK_m,r       XK_x,        XK_b,n       XK_F,        XK_exclam,
       XK_R     },     MiscellanyKeys[]=,     {        XK_i,        XK_z,        XK_H,        XK_ampersand,r       XK_comma,a       XK_F12     },     HelpKeys[]=      {r       XK_h,u       XK_Find,
       XK_v     },     ShortCutsKeys[]=     {        XK_n,v       XK_f,        XK_l,e       XK_s,e       XK_u,o       XK_r,m       XK_g,        XK_i,t
       XK_q     },     ImmutableKeys[]=     {        XK_i, 
       XK_q     };     static KeySym      *Keys[MagickMenus]=e     {        FileKeys,d       EditKeys,        ViewKeys,        TransformKeys,       EnhanceKeys,       EffectsKeys,       ImageEditKeys,       MiscellanyKeys,o       HelpKeys     };     char     command[MaxTextLength],a#     image_signature[MaxTextLength],t!     resource_name[MaxTextLength];      Imagee     *displayed_image,      *loaded_image;     inth
     entry,     id,      status;v     KeySym     key_symbol;      register int     i;  
   static charp%     working_directory[MaxTextLength];      static Windowb     root_window;     static XClassHintd     *class_hints;l     static XFontStruct     *font_info;      static XPixelInfo      icon_pixel,a     pixel_info;c     static XPoint 
     vid_info;e     static XResourceInfo     icon_resources;i     static XStandardColormap     *icon_map,     *map_info;     static XVisualInfo     *icon_visual,i(     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo      *magick_windows[MaxWindows];     static XWMHintsa     *manager_hints;m     static unsigned int-     number_windows;f  
   struct statc     file_info;     time_t
     timer,     time_stamp,i     update_time;     unsigned int     context_mask;y     XEvent
     event;     XGCValuesa     context_values;n     XWindowChanges     window_changes;   *   if (visual_info != (XVisualInfo *) NULL)$     (void) chdir(working_directory);   else     {        /*#         Allocate standard colormap.        */       if (resource_info->debug),	         {o%           XSynchronize(display,True);k9           (void) fprintf(stderr,"Version: %s\n",Version);o	         },(       map_info=XAllocStandardColormap();(       icon_map=XAllocStandardColormap();5       if ((map_info == (XStandardColormap *) NULL) ||l3           (icon_map == (XStandardColormap *) NULL))tO         Error("Unable to create standard colormap","Memory allocation failed");P)       map_info->colormap=(Colormap) NULL; )       icon_map->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL;e+       pixel_info.gamma_map=(XColor *) NULL;m,       pixel_info.annotate_context=(GC) NULL;-       pixel_info.highlight_context=(GC) NULL;"*       pixel_info.widget_context=(GC) NULL;%       font_info=(XFontStruct *) NULL;n,       icon_pixel.annotate_context=(GC) NULL;/       icon_pixel.pixels=(unsigned long *) NULL;t+       icon_pixel.gamma_map=(XColor *) NULL;        /*         Allocate visual.       */&       icon_resources=(*resource_info);,       icon_resources.map_type=(char *) NULL;+       icon_resources.visual_type="default"; -       icon_resources.colormap=SharedColormap;rB       visual_info=XBestVisualInfo(display,map_info,resource_info);D       icon_visual=XBestVisualInfo(display,icon_map,&icon_resources);2       if ((visual_info == (XVisualInfo *) NULL) ||0           (icon_visual == (XVisualInfo *) NULL))A         Error("Unable to get visual",resource_info->visual_type);        if (resource_info->debug)w	         {--           (void) fprintf(stderr,"Visual:\n"); N           (void) fprintf(stderr,"  visual id: 0x%lx\n",visual_info->visualid);0           (void) fprintf(stderr,"  class: %s\n",2             XVisualClassName(visual_info->class));K           (void) fprintf(stderr,"  depth: %d planes\n",visual_info->depth);iC           (void) fprintf(stderr,"  size of colormap: %d entries\n",)(             visual_info->colormap_size);P           (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",:             visual_info->red_mask,visual_info->green_mask,$             visual_info->blue_mask);I           (void) fprintf(stderr,"  significant bits in color: %d bits\n",-'             visual_info->bits_per_rgb); 	         }i       /*         Allocate atoms.u       */4       windows=(XWindows *) malloc(sizeof(XWindows));'       if (windows == (XWindows *) NULL) G         Error("Unable to create X windows","Memory allocation failed");rF       windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);N       windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);H       windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);F       windows->im_protocols=XInternAtom(display,"IM_PROTOCOLS",False);N       windows->im_update_widget=XInternAtom(display,"IM_UPDATE_WIDGET",False);"       windows->im_update_colormap=8         XInternAtom(display,"IM_UPDATE_COLORMAP",False);#       windows->im_update_signature=t9         XInternAtom(display,"IM_UPDATE_SIGNATURE",False);;       *image_signature='\0';L       windows->im_former_image=XInternAtom(display,"IM_FORMER_IMAGE",False);H       windows->im_next_image=XInternAtom(display,"IM_NEXT_IMAGE",False);N       windows->im_retain_colors=XInternAtom(display,"IM_RETAIN_COLORS",False);<       windows->im_exit=XInternAtom(display,"IM_EXIT",False);       if (resource_info->debug) 	         { 0           (void) fprintf(stderr,"Protocols:\n");<           (void) fprintf(stderr,"  Window Manager: 0x%lx\n",#             windows->wm_protocols); =           (void) fprintf(stderr,"    delete window: 0x%lx\n", '             windows->wm_delete_window); :           (void) fprintf(stderr,"    take focus: 0x%lx\n",$             windows->wm_take_focus);9           (void) fprintf(stderr,"  ImageMagick: 0x%lx\n",%#             windows->im_protocols); =           (void) fprintf(stderr,"    update widget: 0x%lx\n",e'             windows->im_update_widget);d?           (void) fprintf(stderr,"    update colormap: 0x%lx\n",e)             windows->im_update_colormap);o@           (void) fprintf(stderr,"    update signature: 0x%lx\n",*             windows->im_update_signature);<           (void) fprintf(stderr,"    former image: 0x%lx\n",&             windows->im_former_image);:           (void) fprintf(stderr,"    next image: 0x%lx\n",$             windows->im_next_image);=           (void) fprintf(stderr,"    retain colors: 0x%lx\n", '             windows->im_retain_colors);eF           (void) fprintf(stderr,"    exit: 0x%lx\n",windows->im_exit);	         }        /*)         Allocate class and manager hints.o       */$       class_hints=XAllocClassHint();$       manager_hints=XAllocWMHints();1       if ((class_hints == (XClassHint *) NULL) ||o/           (manager_hints == (XWMHints *) NULL)) :         Error("Unable to allocate X hints",(char *) NULL);       /*.         Determine group leader if we have one.       */;       root_window=XRootWindow(display,visual_info->screen);D-       windows->group_leader.id=(Window) NULL;x7       if (resource_info->window_group != (char *) NULL) 	         {)4           if (isdigit(*resource_info->window_group))M             windows->group_leader.id=XWindowByID(display,root_window,(Window)uM               strtol((char *) resource_info->window_group,(char **) NULL,0)); 8           if (windows->group_leader.id == (Window) NULL)%             windows->group_leader.id=;M               XWindowByName(display,root_window,resource_info->window_group);=	         }e       /*         Initialize window id's.        */       number_windows=0;r8       magick_windows[number_windows++]=(&windows->icon);<       magick_windows[number_windows++]=(&windows->backdrop);9       magick_windows[number_windows++]=(&windows->image);_8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->command);e:       magick_windows[number_windows++]=(&windows->widget);9       magick_windows[number_windows++]=(&windows->popup); ;       magick_windows[number_windows++]=(&windows->magnify);t7       magick_windows[number_windows++]=(&windows->pan); (       for (i=0; i < number_windows; i++),         magick_windows[i]->id=(Window) NULL;       vid_info.x=0;        vid_info.y=0;n     }i   /*!     Initialize Standard Colormap.i   */   loaded_image=(Image *) NULL;   displayed_image=(*image);o   if (resource_info->debug)t     {sM       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",displayed_image->filename, O         displayed_image->scene,displayed_image->columns,displayed_image->rows);i'       if (displayed_image->colors != 0)f>         (void) fprintf(stderr,"%uc ",displayed_image->colors);<       (void) fprintf(stderr,"%s\n",displayed_image->magick);     }rJ   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,&pixel_info);   /*     Initialize font info.    */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info);/3   font_info=XBestFont(display,resource_info,False);o(   if (font_info == (XFontStruct *) NULL)5     Error("Unable to load font",resource_info->font);    /*     Initialize graphic context.    */$   windows->context.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->context);a%   class_hints->res_name="superclass"; #   class_hints->res_class="Display";n-   manager_hints->flags=InputHint | StateHint;f   manager_hints->input=False;o.   manager_hints->initial_state=WithdrawnState;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->context);f   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);>   context_values.background=pixel_info.background_color.pixel;%   context_values.font=font_info->fid; >   context_values.foreground=pixel_info.foreground_color.pixel;*   context_values.graphics_exposures=False;J   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;/   if (pixel_info.annotate_context != (GC) NULL) 1     XFreeGC(display,pixel_info.annotate_context);_   pixel_info.annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)r<     Error("Unable to create graphic context",(char *) NULL);9   context_values.background=pixel_info.depth_color.pixel; -   if (pixel_info.widget_context != (GC) NULL)>/     XFreeGC(display,pixel_info.widget_context);f   pixel_info.widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);-   if (pixel_info.widget_context == (GC) NULL)f<     Error("Unable to create graphic context",(char *) NULL);>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;0   if (pixel_info.highlight_context != (GC) NULL)2     XFreeGC(display,pixel_info.highlight_context);E   pixel_info.highlight_context=XCreateGC(display,windows->context.id,P0     context_mask | GCPlaneMask,&context_values);0   if (pixel_info.highlight_context == (GC) NULL)<     Error("Unable to create graphic context",(char *) NULL);.   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.e   */O   XGetWindowInfo(display,icon_visual,icon_map,&icon_pixel,(XFontStruct *) NULL, $     &icon_resources,&windows->icon);6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;a   class_hints->res_name="icon"; -   manager_hints->flags=InputHint | StateHint;    manager_hints->input=False; +   manager_hints->initial_state=IconicState;oF   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->icon);   if (resource_info->debug)0H     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.X   *//   if (icon_pixel.annotate_context != (GC) NULL) 1     XFreeGC(display,icon_pixel.annotate_context);,>   context_values.background=icon_pixel.background_color.pixel;>   context_values.foreground=icon_pixel.foreground_color.pixel;A   icon_pixel.annotate_context=XCreateGC(display,windows->icon.id,e1     GCBackground | GCForeground,&context_values); /   if (icon_pixel.annotate_context == (GC) NULL)n<     Error("Unable to create graphic context",(char *) NULL);=   windows->icon.annotate_context=icon_pixel.annotate_context;    /*     Initialize Image window.   */)   if (windows->image.id != (Window) NULL)o     {o)       free((char *) windows->image.name);n.       free((char *) windows->image.icon_name);     }nD   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->image);eB   windows->image.name=(char *) malloc(MaxTextLength*sizeof(char));G   windows->image.icon_name=(char *) malloc(MaxTextLength*sizeof(char)); J   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))F     Error("Unable to create Image window","Memory allocation failed");O   if ((resource_info->title != (char *) NULL) && !(*state & MontageImageState))x     {e       /*#         User specified window name.c       */>       (void) strcpy(windows->image.name,resource_info->title);C       (void) strcpy(windows->image.icon_name,resource_info->title);      }    else     {        register char-         *p;e         register Image         *q;          unsigned int         count;         /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+strlen(displayed_image->filename)-1;O       while ((p > displayed_image->filename) && (*(p-1) != *BasenameSeparator)).         p--;A       (void) sprintf(windows->image.name,"ImageMagick: %s[%u]",p,;          displayed_image->scene);       q=displayed_image;+       while (q->previous != (Image *) NULL)g         q=q->previous;7       for (count=1; q->next != (Image *) NULL; count++)e         q=q->next;G       (void) sprintf(windows->image.name,"ImageMagick: %s[%u of %u]",p, &         displayed_image->scene,count);:       if ((displayed_image->previous == (Image *) NULL) &&6           (displayed_image->next == (Image *) NULL) &&(           (displayed_image->scene == 0))@         (void) sprintf(windows->image.name,"ImageMagick: %s",p);0       (void) strcpy(windows->image.icon_name,p);     }    if (resource_info->immutable) "     windows->image.immutable=True;8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;H   if (windows->image.width > XDisplayWidth(display,visual_info->screen))D     windows->image.width=XDisplayWidth(display,visual_info->screen);.   windows->image.height=displayed_image->rows;J   if (windows->image.height > XDisplayHeight(display,visual_info->screen))F     windows->image.height=XDisplayHeight(display,visual_info->screen);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask |)G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | <     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,&     resource_info,&windows->backdrop);K   if ((resource_info->backdrop) || (windows->backdrop.id != (Window) NULL))w     {a       /*#         Initialize backdrop window.        */       windows->backdrop.x=0;       windows->backdrop.y=0;4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen); K       windows->backdrop.height=XDisplayHeight(display,visual_info->screen);w'       windows->backdrop.border_width=0;t'       windows->backdrop.immutable=True;bJ       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;'       class_hints->res_name="backdrop";/B       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state= :         resource_info->iconic ? IconicState : NormalState;J       XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,         &windows->backdrop);       if (resource_info->debug)K>         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id); 1       XClearWindow(display,windows->backdrop.id); -       if (windows->image.id != (Window) NULL)l	         { 4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         }        /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition;iI       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)-o$         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);      } +   if (resource_info->name == (char *) NULL):&     class_hints->res_name=client_name;   else.     class_hints->res_name=resource_info->name;>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state=s6     resource_info->iconic ? IconicState : NormalState;0   if (windows->group_leader.id != (Window) NULL)     {-       /*         Follow the leader.       */,       manager_hints->flags|=WindowGroupHint;;       manager_hints->window_group=windows->group_leader.id;nI       XSelectInput(display,windows->group_leader.id,StructureNotifyMask);w       if (resource_info->debug)|B         (void) fprintf(stderr,"Window id: 0x%lx (group leader)\n",$           windows->group_leader.id);     }    XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),9     argv,argc,class_hints,manager_hints,&windows->image);t0   if (windows->group_leader.id != (Window) NULL)M     XSetTransientForHint(display,windows->image.id,windows->group_leader.id);n   if (resource_info->debug)iJ     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*!     Initialize X image structure.f   */   windows->image.x=0;)   windows->image.y=0;NJ   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)4     Error("Unable to create X image",(char *) NULL);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);H   if (!windows->image.mapped || (windows->backdrop.id != (Window) NULL))*     XMapWindow(display,windows->image.id);   if (windows->image.mapped)<     XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XClientMessage(display,windows->image.id,windows->im_protocols,o.     windows->im_update_signature,CurrentTime);   /*     Initialize Info widget.(   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,"     resource_info,&windows->info);   windows->info.name="Info";!   windows->info.icon_name="Info";    windows->info.border_width=1;c   windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition;n+   windows->info.attributes.save_under=True;e4   windows->info.attributes.win_gravity=UnmapGravity;&   windows->info.attributes.event_mask=9     ButtonPressMask | ExposureMask | StructureNotifyMask;f   class_hints->res_name="info";=?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;u   manager_hints->input=False; +   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;L   XMakeWindow(display,windows->image.id,argv,argc,class_hints,manager_hints,     &windows->info);C   XSetTransientForHint(display,windows->info.id,windows->image.id);c   if (windows->image.mapped)C     XWithdrawWindow(display,windows->info.id,windows->info.screen);o   if (resource_info->debug)xH     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize Command widget.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->command);"$   windows->command.data=MagickMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL);t9   (void) sprintf(resource_name,"%s.command",client_name);nO   windows->command.geometry=XGetResourceClass(resource_info->resource_database,m,     resource_name,"geometry",(char *) NULL);$   windows->command.name=MagickTitle;"   windows->command.border_width=0;$   windows->command.flags|=PPosition;7   windows->command.attributes.backing_store=WhenMapped;D.   windows->command.attributes.save_under=True;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask |lJ     ButtonReleaseMask | EnterWindowMask | ExposureMask | LeaveWindowMask |.     OwnerGrabButtonMask | StructureNotifyMask;"   class_hints->res_name="command";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;o   manager_hints->input=False;e+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->command);wC   windows->command.highlight_stipple=XCreateBitmapFromData(display,_@     windows->command.id,(char *) HighlightBitmap,HighlightWidth,     HighlightHeight);o@   windows->command.shadow_stipple=XCreateBitmapFromData(display,H     windows->command.id,(char *) ShadowBitmap,ShadowWidth,ShadowHeight);F   XSetTransientForHint(display,windows->command.id,windows->image.id);   if (windows->command.mapped),     XMapRaised(display,windows->command.id);   if (resource_info->debug)-N     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize Widget window.a   */*   if (windows->widget.id != (Window) NULL)(     free((char *) windows->widget.name);D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,$     resource_info,&windows->widget);8   (void) sprintf(resource_name,"%s.widget",client_name);N   windows->widget.geometry=XGetResourceClass(resource_info->resource_database,,     resource_name,"geometry",(char *) NULL);C   windows->widget.name=(char *) malloc(MaxTextLength*sizeof(char));t#   if (windows->widget.name == NULL) F     Error("Unable to create Image window","Memory allocation failed");   *windows->widget.name='\0';c!   windows->widget.border_width=0;s#   windows->widget.flags|=PPosition; 6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True;aL   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | <     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;!   class_hints->res_name="widget";u?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;r   manager_hints->input=True;+   manager_hints->initial_state=NormalState;A0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->widget);G   windows->widget.highlight_stipple=windows->command.highlight_stipple; A   windows->widget.shadow_stipple=windows->command.shadow_stipple; E   XSetTransientForHint(display,windows->widget.id,windows->image.id);R   if (resource_info->debug)-L     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);   /*     Initialize popup window.   */)   if (windows->popup.id != (Window) NULL)e'     free((char *) windows->popup.name); D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->popup);nB   windows->popup.name=(char *) malloc(MaxTextLength*sizeof(char));"   if (windows->popup.name == NULL)F     Error("Unable to create Image window","Memory allocation failed");   *windows->popup.name='\0';    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped; ,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | ;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;r    class_hints->res_name="popup";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;(   manager_hints->input=True;+   manager_hints->initial_state=NormalState;X0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->popup); F   windows->popup.highlight_stipple=windows->command.highlight_stipple;@   windows->popup.shadow_stipple=windows->command.shadow_stipple;D   XSetTransientForHint(display,windows->popup.id,windows->image.id);   if (resource_info->debug) K     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id);    /*)     Initialize Magnify window and cursor.X   */+   if (windows->magnify.id != (Window) NULL) )     free((char *) windows->magnify.name); D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->magnify);L9   (void) sprintf(resource_name,"%s.magnify",client_name); O   windows->magnify.geometry=XGetResourceClass(resource_info->resource_database,o,     resource_name,"geometry",(char *) NULL);D   windows->magnify.name=(char *) malloc(MaxTextLength*sizeof(char));$   if (windows->magnify.name == NULL)H     Error("Unable to create Magnify window","Memory allocation failed");M   (void) sprintf(windows->magnify.name,"Magnify %uX",resource_info->magnify);r@   windows->magnify.cursor=XMakeCursor(display,windows->image.id,7     map_info->colormap,resource_info->background_color,i%     resource_info->foreground_color);o/   if (windows->magnify.cursor == (Cursor) NULL)_3     Error("Unable to create cursor",(char *) NULL);d%   windows->magnify.width=MagnifySize; &   windows->magnify.height=MagnifySize;$   windows->magnify.flags|=PPosition;)   windows->magnify.min_width=MagnifySize;l*   windows->magnify.min_height=MagnifySize;)   windows->magnify.width_inc=MagnifySize; *   windows->magnify.height_inc=MagnifySize;/   windows->magnify.data=resource_info->magnify;t.   windows->magnify.attributes.save_under=True;=   windows->magnify.attributes.cursor=windows->magnify.cursor; N   windows->magnify.attributes.event_mask=ButtonPressMask | ButtonReleaseMask |H     ExposureMask | KeyPressMask | KeyReleaseMask | OwnerGrabButtonMask |     StructureNotifyMask;"   class_hints->res_name="magnify";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState;t0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->magnify);I   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (magnify)\n",windows->magnify.id);F   XSetTransientForHint(display,windows->magnify.id,windows->image.id);   if (windows->magnify.mapped),     XMapRaised(display,windows->magnify.id);   /*     Initialize panning window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,!     resource_info,&windows->pan);x   windows->pan.name="Pan Icon"; 7   XBestIconSize(display,&windows->pan,displayed_image);;-   while ((windows->pan.width < MinPanSize) &&h,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;_     windows->pan.height<<=1;   }r5   (void) sprintf(resource_name,"%s.pan",client_name); K   windows->pan.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);-   if (windows->pan.geometry != (char *) NULL)_A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,f       &windows->pan.height);    windows->pan.flags|=PPosition;   windows->pan.immutable=True;*   windows->pan.attributes.save_under=True;I   windows->pan.attributes.event_mask=ButtonMotionMask | ButtonPressMask | F     ButtonReleaseMask | ExposureMask | KeyPressMask | KeyReleaseMask |     StructureNotifyMask;   class_hints->res_name="pan";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->pan);a   if (resource_info->debug) F     (void) fprintf(stderr,"Window id: 0x%lx (pan)\n",windows->pan.id);B   XSetTransientForHint(display,windows->pan.id,windows->image.id);   if (windows->image.mapped)@     if ((windows->image.width < windows->image.ximage->width) ||@         (windows->image.height < windows->image.ximage->height))*       XMapRaised(display,windows->pan.id);   /*     Respond to events.   */-   (void) SetMonitorHandler(XProgressMonitor);X%   (void) SetWarningHandler(XWarning);n'   if (!resource_info->display_warnings)i2     (void) SetWarningHandler((ErrorHandler) NULL);3   timer=time((time_t *) NULL)+resource_info->delay;;   update_time=0;   if (resource_info->update)     {*       /*3         Determine when file data was last modified.        */8       status=stat(displayed_image->filename,&file_info);       if (status == 0)'         update_time=file_info.st_mtime;t     }M   *state&=(~FormerImageState);   *state&=(~MontageImageState);i   *state&=(~NextImageState);   do   {y     /*       Handle a window event.     */"     if (resource_info->delay != 0)       { *         if (timer < time((time_t *) NULL))%           if (!resource_info->update)b/             *state|=NextImageState | ExitState;/           else
             {p               /*5                 Determine if image file was modified.e               */@               status=stat(displayed_image->filename,&file_info);               if (status == 0)6                 if (update_time != file_info.st_mtime)                   {!                     /*&                       Redisplay image.                     */F                     (void) strcpy(resource_info->image_info->filename,1                       displayed_image->filename); F                     loaded_image=ReadImage(resource_info->image_info);7                     if (loaded_image != (Image *) NULL) 9                       *state|=NextImageState | ExitState;D                   }d?               timer=time((time_t *) NULL)+resource_info->delay;i
             },9         if (XEventsQueued(display,QueuedAfterFlush) == 0)a           {h             /*(               Do not block if delay > 0.             */-             XDelay(display,SuspendTime << 2);e             continue;/           }p       } %     time_stamp=time((time_t *) NULL);(     XNextEvent(display,&event);      if (!windows->image.stasis)eC       windows->image.stasis=(time((time_t *) NULL)-time_stamp) > 0; 1     if (event.xany.window == windows->command.id)i       {t
         /*3           Select a command from the Command widget.n
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)            continue;f/         (void) strcpy(command,CommandMenu[id]); #         key_symbol=CommandKeys[id];o         if (id < MagickMenus)t           {              /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);a             if (entry < 0)               continue;;4             (void) strcpy(command,Menus[id][entry]);'             key_symbol=Keys[id][entry];f           }.(         if (key_symbol != XK_VoidSymbol)F           loaded_image=XMagickCommand(display,resource_info,windows,0,)             key_symbol,&displayed_image);h         continue;n       }f     switch (event.type)g     {        case ButtonPress:y       {_!         if (resource_info->debug)iB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);t0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))S           {F             /*-               Convert Alt-Button3 to Button2.              */)             event.xbutton.button=Button2;c-             event.xbutton.state&=(~Mod1Mask);-           }e9         if (event.xbutton.window == windows->backdrop.id)-           {eG             XSetInputFocus(display,event.xbutton.window,RevertToParent, "               event.xbutton.time);             break;           }d6         if (event.xbutton.window == windows->image.id)           { )             switch (event.xbutton.button) 
             {                case Button1:                { -                 if (resource_info->immutable)s                   {p                     /*?                       Select a command from the Immutable menu.f                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,n                       command);/#                     if (entry >= 0)cH                       loaded_image=XMagickCommand(display,resource_info,I                         windows,0,ImmutableKeys[entry],&displayed_image);x                     break;                   }e                 /*+                   Map/unmap Command widget.-                 */,                 if (windows->command.mapped)>                   XWithdrawWindow(display,windows->command.id,-                     windows->command.screen);                  else                   {_F                     (void) XCommandWidget(display,windows,CommandMenu,'                       (XEvent *) NULL);+<                     XMapRaised(display,windows->command.id);                   }e                 break;               }                case Button2:w               {f                 /*8                   User pressed the image magnify button.                 */F                 (void) XMagickCommand(display,resource_info,windows,0,2                   (KeySym) XK_z,&displayed_image);6                 XMagnifyImage(display,windows,&event);                 break;               }i               case Button3:i               {>>                 if (displayed_image->montage != (char *) NULL)                   {r                     /*J                       Load or delete a tile from a visual image directory.                     */J                     loaded_image=XTileImage(display,resource_info,windows,.                       displayed_image,&event);7                     if (loaded_image != (Image *) NULL) M                       *state|=MontageImageState | NextImageState | ExitState; 0                     vid_info.x=windows->image.x;0                     vid_info.y=windows->image.y;                     break;                   }a-                 if (resource_info->immutable)f                   {f                     /*?                       Select a command from the Immutable menu.x                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,i                       command); #                     if (entry >= 0)dH                       loaded_image=XMagickCommand(display,resource_info,I                         windows,0,ImmutableKeys[entry],&displayed_image);                      break;                   }f                 /*<                   Select a command from the Short Cuts menu.                 */M                 entry=XMenuWidget(display,windows,"Short Cuts",ShortCutsMenu,%                   command);                  if (entry >= 0) N                   loaded_image=XMagickCommand(display,resource_info,windows,0,;                     ShortCutsKeys[entry],&displayed_image);                  break;               }                default:                 break;
             }              break;           } 8         if (event.xbutton.window == windows->magnify.id)           {              char%               command[MaxTextLength];                int                factor;                static char                *MagnifyMenu[]=                {%                 "2",                 "3",                 "4",                 "5",                 "6",                 "7",                 "8",                 "9",                 (char *) NULL,               };               static KeySyms               MagnifyKeys[]=               {n                 XK_2,o                 XK_4,:                 XK_5,a                 XK_6,m                 XK_7,                  XK_8,h                 XK_9,e                 XK_3               };               /*;               Select a magnify factor from the pop-up menu.              */N             factor=XMenuWidget(display,windows,"Magnify",MagnifyMenu,command);             if (factor >= 0)K               XMagnifyWindowCommand(display,windows,0,MagnifyKeys[factor]);              break;           }r4         if (event.xbutton.window == windows->pan.id)           {I.             XPanImage(display,windows,&event);             break;           }i9         timer=time((time_t *) NULL)+resource_info->delay;h         break;       }c       case ButtonRelease:x         break;       case ClientMessage:        {d!         if (resource_info->debug) I           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n",t<             event.xclient.window,event.xclient.message_type,J             event.xclient.format,(unsigned long) event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           {)C             if (*event.xclient.data.l == windows->im_update_widget)                {(2                 windows->command.name=MagickTitle;2                 windows->command.data=MagickMenus;B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL);p                 break;               }sE             if (*event.xclient.data.l == windows->im_update_colormap)m               {m                 /*=                   Update graphic context and window colormap.p                 */2                 for (i=0; i < number_windows; i++)                 {,@                   if (magick_windows[i]->id == windows->icon.id)                     continue;%N                   context_values.background=pixel_info.background_color.pixel;N                   context_values.foreground=pixel_info.foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);N                   context_values.background=pixel_info.foreground_color.pixel;N                   context_values.foreground=pixel_info.background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context,t@                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel= 6                     pixel_info.background_color.pixel;=                   magick_windows[i]->attributes.border_pixel=e2                     pixel_info.border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,L                     magick_windows[i]->mask,&magick_windows[i]->attributes);                 } (                 if (windows->pan.mapped)                   { G                     XSetWindowBackgroundPixmap(display,windows->pan.id,,+                       windows->pan.pixmap);i:                     XClearWindow(display,windows->pan.id);7                     XDrawPanRectangle(display,windows);d                   }p:                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);D                 break;               } F             if (*event.xclient.data.l == windows->im_update_signature)               {,0                 SignatureImage(displayed_image);J                 (void) strcpy(image_signature,displayed_image->signature);                 break;               } B             if (*event.xclient.data.l == windows->im_former_image)               {e5                 *state|=FormerImageState | ExitState;                  break;               } @             if (*event.xclient.data.l == windows->im_next_image)               {E3                 *state|=NextImageState | ExitState;.                 break;               }mC             if (*event.xclient.data.l == windows->im_retain_colors)T               { *                 *state|=RetainColorsState;                 break;               }g:             if (*event.xclient.data.l == windows->im_exit)               {t"                 *state|=ExitState;                 break;               }              break;           } 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;?         if (*event.xclient.data.l != windows->wm_delete_window)t           break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {              *state|=ExitState;             break;           } 4         if (event.xclient.window == windows->pan.id)           {              /*E               Restore original image size when pan window is deleted.e             */M             windows->image.window_changes.width=windows->image.ximage->width; O             windows->image.window_changes.height=windows->image.ximage->height; A             (void) XConfigureImage(display,resource_info,windows,                displayed_image);            }          break;       }e       case ConfigureNotify:m       { !         if (resource_info->debug) K           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n",);             event.xconfigure.window,event.xconfigure.width,HJ             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event);a9         if (event.xconfigure.window == windows->image.id)            {              /*3               Image window has a new configuration.              */1             if (event.xconfigure.send_event != 0)                {t                 XWindowChanges!                   window_changes;:                   /*N                   Position the transient windows relative of the Image window.                 */?                 if (windows->command.geometry == (char *) NULL) /                   if (!windows->command.mapped)w                     { )                       windows->command.x= E                         event.xconfigure.x-windows->command.width-25;t<                       windows->command.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->command);:                       window_changes.x=windows->command.x;:                       window_changes.y=windows->command.y;G                       XReconfigureWMWindow(display,windows->command.id, K                         windows->command.screen,CWX | CWY,&window_changes);a                     } ?                 if (windows->magnify.geometry == (char *) NULL) /                   if (!windows->magnify.mapped)                      {o)                       windows->magnify.x=iE                         event.xconfigure.x+event.xconfigure.width+25;c<                       windows->magnify.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->magnify);:                       window_changes.x=windows->magnify.x;:                       window_changes.y=windows->magnify.y;G                       XReconfigureWMWindow(display,windows->magnify.id, K                         windows->magnify.screen,CWX | CWY,&window_changes);n                     }.;                 if (windows->pan.geometry == (char *) NULL)a+                   if (!windows->pan.mapped)                      {o%                       windows->pan.x=tE                         event.xconfigure.x+event.xconfigure.width+25; %                       windows->pan.y=lF                         event.xconfigure.y+windows->magnify.height+50;F                       XConstrainWindowPosition(display,&windows->pan);6                       window_changes.x=windows->pan.x;6                       window_changes.y=windows->pan.y;C                       XReconfigureWMWindow(display,windows->pan.id,;G                         windows->pan.screen,CWX | CWY,&window_changes);d                     }s               }.C             if ((event.xconfigure.width == windows->image.width) && C                 (event.xconfigure.height == windows->image.height))                {-*                 if (windows->image.mapped)J                   XRefreshWindow(display,&windows->image,(XEvent *) NULL);                 break;               }(8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             windows->image.x=0;)             windows->image.y=0;!:             if (displayed_image->montage != (char *) NULL)               {g,                 windows->image.x=vid_info.x;,                 windows->image.y=vid_info.y;               } ?             if (windows->image.mapped && windows->image.stasis)m               {u                 /*4                   Update Image window configuration.                 */K                 windows->image.window_changes.width=event.xconfigure.width;iM                 windows->image.window_changes.height=event.xconfigure.height;9E                 (void) XConfigureImage(display,resource_info,windows,.#                   displayed_image);n               } J             if ((event.xconfigure.width < windows->image.ximage->width) ||J                 (event.xconfigure.height < windows->image.ximage->height))               {I4                 XMapRaised(display,windows->pan.id);3                 XDrawPanRectangle(display,windows);a               }e             else&               if (windows->pan.mapped)M                 XWithdrawWindow(display,windows->pan.id,windows->pan.screen);s             break;           }n;         if (event.xconfigure.window == windows->magnify.id)(           {w             MonitorHandler               handler;               unsigned int               magnify;               /*5               Magnify window has a new configuration.              */:             windows->magnify.width=event.xconfigure.width;<             windows->magnify.height=event.xconfigure.height;)             if (!windows->magnify.mapped)                break;             magnify=1;5             while (magnify <= event.xconfigure.width)t               magnify<<=1;6             while (magnify <= event.xconfigure.height)               magnify<<=1;             magnify>>=1;6             if ((magnify != event.xconfigure.width) ||5                 (magnify != event.xconfigure.height))                {h-                 window_changes.width=magnify; .                 window_changes.height=magnify;A                 XReconfigureWMWindow(display,windows->magnify.id, N                   windows->magnify.screen,CWWidth | CWHeight,&window_changes);                 break;               }==             handler=SetMonitorHandler((MonitorHandler) NULL);-F             status=XMakeImage(display,resource_info,&windows->magnify,N               displayed_image,windows->magnify.width,windows->magnify.height);I             status&=XMakePixmap(display,resource_info,&windows->magnify);a              if (status == False)D               Error("Unable to create magnify image",(char *) NULL);/             XMakeMagnifyImage(display,windows);).             (void) SetMonitorHandler(handler);             break;           } 7         if (event.xconfigure.window == windows->pan.id)            {f             /*6               Pan icon window has a new configuration.             */1             if (event.xconfigure.send_event != 0)h               { 2                 windows->pan.x=event.xconfigure.x;2                 windows->pan.y=event.xconfigure.y;               } 6             windows->pan.width=event.xconfigure.width;8             windows->pan.height=event.xconfigure.height;             break;           }f8         if (event.xconfigure.window == windows->icon.id)           {              /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width;g9             windows->icon.height=event.xconfigure.height;f             break;           }.         break;       }        case DestroyNotify:i       { 
         /*"           Group leader has exited.
         */D         if (event.xdestroywindow.window == windows->group_leader.id)           {i             *state|=ExitState;             break;           }a         break;       }o       case EnterNotify:k       {i
         /*'           Selectively install colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)g8             XInductColormap(display,map_info->colormap);         break;       }i       case Expose:       {.!         if (resource_info->debug)*>           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y);a
         /*/           Refresh windows that are now exposed.f
         */6         if (event.xexpose.window == windows->image.id)$           if (windows->image.mapped)
             { =               XRefreshWindow(display,&windows->image,&event); ?               timer=time((time_t *) NULL)+resource_info->delay;t               break;
             }o8         if (event.xexpose.window == windows->magnify.id)'           if (event.xexpose.count == 0)o(             if (windows->magnify.mapped)               {i3                 XMakeMagnifyImage(display,windows);o                 break;               } 4         if (event.xexpose.window == windows->pan.id)'           if (event.xexpose.count == 0)d
             { 1               XDrawPanRectangle(display,windows);s               break;
             } 5         if (event.xexpose.window == windows->icon.id)%'           if (event.xexpose.count == 0) 
             { <               XRefreshWindow(display,&windows->icon,&event);               break;
             }          break;       }        case KeyPress:       {          int            length;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);%         if (resource_info->immutable)%           {%=             if ((key_symbol != XK_q) && (key_symbol != XK_i))g               XBell(display,0);y             elseO               (void) XMagickCommand(display,resource_info,windows,0,key_symbol,C"                 &displayed_image);             break;           }l3         if (event.xkey.window == windows->image.id) D           loaded_image=XMagickCommand(display,resource_info,windows,:             event.xkey.state,key_symbol,&displayed_image);5         if (event.xkey.window == windows->magnify.id) M           XMagnifyWindowCommand(display,windows,event.xkey.state,key_symbol); 1         if (event.xkey.window == windows->pan.id)1!           if (key_symbol == XK_q) I             XWithdrawWindow(display,windows->pan.id,windows->pan.screen);            elseA             if ((key_symbol == XK_F1) || (key_symbol == XK_Help))/B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Panning",ImagePanHelp);             elseA               XTranslateImage(display,windows,*image,key_symbol); 9         timer=time((time_t *) NULL)+resource_info->delay;o         break;       }g       case KeyRelease:       {*
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);o!         if (resource_info->debug) G           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,u             *command);         break;       }        case LeaveNotify:a       {t
         /*)           Selectively uninstall colormap.S
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)":             XUninductColormap(display,map_info->colormap);         break;       };       case MapNotify:        {x!         if (resource_info->debug) I           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window); 6         if (event.xmap.window == windows->backdrop.id)           {yD             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime); *             windows->backdrop.mapped=True;             break;           }x3         if (event.xmap.window == windows->image.id)c           { 6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap); <             if (strcmp(displayed_image->magick,"LOGO") == 0)K               loaded_image=XLoadImage(display,resource_info,windows,False);(H             if ((windows->image.width < windows->image.ximage->width) ||H                 (windows->image.height < windows->image.ximage->height))2               XMapRaised(display,windows->pan.id);'             windows->image.mapped=True;              break;           }g5         if (event.xmap.window == windows->magnify.id)            { /             XMakeMagnifyImage(display,windows);+)             windows->magnify.mapped=True; K             XWithdrawWindow(display,windows->info.id,windows->info.screen);              break;           }e1         if (event.xmap.window == windows->pan.id)t           { I             XMakePanImage(display,resource_info,windows,displayed_image);e%             windows->pan.mapped=True;c             break;           }p2         if (event.xmap.window == windows->info.id)           {I&             windows->info.mapped=True;             break;           }O2         if (event.xmap.window == windows->icon.id)           {d             /*#               Create an icon image.              */F             XMakeStandardColormap(display,icon_visual,&icon_resources,4               displayed_image,icon_map,&icon_pixel);E             (void) XMakeImage(display,&icon_resources,&windows->icon,aH               displayed_image,windows->icon.width,windows->icon.height);G             (void) XMakePixmap(display,&icon_resources,&windows->icon); @             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id); K             XWithdrawWindow(display,windows->info.id,windows->info.screen); &             windows->icon.mapped=True;             break;           };5         if (event.xmap.window == windows->command.id)m           {l)             windows->command.mapped=True;v             break;           }w3         if (event.xmap.window == windows->popup.id)l           {o'             windows->popup.mapped=True;o             break;           }s4         if (event.xmap.window == windows->widget.id)           {r(             windows->widget.mapped=True;             break;           }i         break;       }e       case MappingNotify:o       {e1         XRefreshKeyboardMapping(&event.xmapping);i         break;       }u       case NoExpose:         break;       case ReparentNotify:       {o!         if (resource_info->debug),B           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);S         break;       }f       case UnmapNotify:        { !         if (resource_info->debug)eM           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window);g8         if (event.xunmap.window == windows->backdrop.id)           { +             windows->backdrop.mapped=False;              break;           },5         if (event.xunmap.window == windows->image.id)n           {s(             windows->image.mapped=False;             break;           }o7         if (event.xunmap.window == windows->magnify.id)p           {o*             windows->magnify.mapped=False;             break;           }C3         if (event.xunmap.window == windows->pan.id)            { &             windows->pan.mapped=False;             break;           }o4         if (event.xunmap.window == windows->info.id)           {u'             windows->info.mapped=False;              break;           }*4         if (event.xunmap.window == windows->icon.id)           { 9             if (map_info->colormap == icon_map->colormap) D               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image); L             XFreeStandardColormap(display,icon_visual,icon_map,&icon_pixel);'             windows->icon.mapped=False;              break;           }u7         if (event.xunmap.window == windows->command.id)e           { *             windows->command.mapped=False;             break;           } 5         if (event.xunmap.window == windows->popup.id)            { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); (             windows->popup.mapped=False;             break;           }_6         if (event.xunmap.window == windows->widget.id)           {c6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);/)             windows->widget.mapped=False;n             break;           }          break;       }f       default:       {,!         if (resource_info->debug)s?           (void) fprintf(stderr,"Event type: %d\n",event.type);)         break;       }o     }o   }     while (!(*state & ExitState));   /*     Apply image transforms.;   */F   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,     &displayed_image);"   SignatureImage(displayed_image);>   if (strcmp(displayed_image->signature,image_signature) != 0)     {p       /*(         Query user if image has changed.       */B       status=XConfirmWidget(display,windows,"Your image changed.","         "Do you want to save it");       if (status != False)L         (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_s,           &displayed_image);     },J   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_Break,     &displayed_image);   /*$     Withdraw pan and Magnify window.   */   if (windows->pan.mapped)A     XWithdrawWindow(display,windows->pan.id,windows->pan.screen);    if (windows->magnify.mapped)I     XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);    if (windows->command.mapped)I     XWithdrawWindow(display,windows->command.id,windows->command.screen);    if (!resource_info->backdrop)u!     if (windows->backdrop.mapped)        { O         XWithdrawWindow(display,windows->backdrop.id,windows->backdrop.screen); 5         XDestroyWindow(display,windows->backdrop.id);d+         windows->backdrop.id=(Window) NULL;nI         XWithdrawWindow(display,windows->image.id,windows->image.screen);a2         XDestroyWindow(display,windows->image.id);(         windows->image.id=(Window) NULL;       } (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);?   if ((*state & FormerImageState) || (*state & NextImageState))      *state&=(~ExitState);    if (*state & ExitState)      {=       /*         Destroy X windows.       */(       for (i=0; i < number_windows; i++)       { 3         if (magick_windows[i]->id != (Window) NULL)i8           XDestroyWindow(display,magick_windows[i]->id);9         if (magick_windows[i]->ximage != (XImage *) NULL) 3           XDestroyImage(magick_windows[i]->ximage);r7         if (magick_windows[i]->pixmap != (Pixmap) NULL)e9           XFreePixmap(display,magick_windows[i]->pixmap);        }        /*         Free Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL) H         XFreeStandardColormap(display,visual_info,map_info,&pixel_info);"       XFree((void *) class_hints);$       XFree((void *) manager_hints);"       XFree((void *) icon_visual);"       XFree((void *) visual_info);       XFree((void *) icon_map);B       XFree((void *) map_info);f)       free((char *) windows->popup.name); *       free((char *) windows->widget.name);+       free((char *) windows->magnify.name);p.       free((char *) windows->image.icon_name);)       free((char *) windows->image.name);        free((char *) windows);.'       visual_info=(XVisualInfo *) NULL;v'       if (copy_image != (Image *) NULL),!         DestroyImage(copy_image);e     }a   /*     Change to home directory.i   */3   (void) getcwd(working_directory,MaxTextLength-1);e.   (void) chdir(resource_info->home_directory);   *image=displayed_image;/   return(loaded_image);. }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,O %                                                                             % O %                                                                             %-O %                                                                             % O %   X D r a w I m a g e                                                       % O %                                                                             %bO %                                                                             % O %                                                                             %kO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %XM %  Function XDrawEditImage draws a graphic primitive (point, line, rectangle,a %  etc.) on the image. %a/ %  The format of the XDrawEditImage routine is:  % G %    status=XDrawEditImage(display,resource_info,windows,degrees,image)  % + %  A description of each parameter follows:1 % H %    o status: Function XDrawEditImage return True if the image is drawnG %      upon.  False is returned is there is a memory shortage or if thet  %      image cannot be drawn on. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.M %o< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.) %  %  */4 static unsigned int XDrawEditImage(Display *display,?   XResourceInfo *resource_info,XWindows *windows,Image **image)o {a #define DrawModePrimitiveOp  0 #define DrawModeColorOp  1 #define DrawModeStippleOp  2 #define DrawModeWidthOp  3 #define DrawModeUndoOp  4  #define DrawModeHelpOp  5i #define DrawModeDismissOp  60 #define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))  
   static chare     *DrawModeMenu[]=     {l       "Primitive",       "Color",       "Stipple",       "Width",
       "Undo",(
       "Help",+       "Dismiss",       (char *) NULLM     };     char     command[MaxTextLength],r     text[MaxTextLength];     Cursor     cursor;      double     degrees;     inty
     entry,     id,p     number_coordinates,      x,     y;     RectangleInfo,     rectangle_info;      register int     i;     static Pixmapm     stipple = (Pixmap) NULL;     static unsigned intl     pen_id = 0,.     primitive = PointPrimitive,      line_width = 1;-     unsigned int
     distance,_     height,      max_coordinates,     status,f
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;m     Window     root_window;     XDrawInfo;     draw_info;     XEvent
     event;     XPoint     *coordinate_info;i  
   XSegment     line_info;     /*     Allocate polygon info.   */   max_coordinates=2048;aD   coordinate_info=(XPoint *) malloc(max_coordinates*sizeof(XPoint));)   if (coordinate_info == (XPoint *) NULL)o     { D       Warning("Unable to draw on image","Memory allocation failed");       return(False);     }w   /*     Map Command widget.y   */   windows->command.name="Draw";f   windows->command.data=4;F   (void) XCommandWidget(display,windows,DrawModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*      Wait for first button press.   */;   root_window=XRootWindow(display,XDefaultScreen(display));e"   draw_info.stencil=OpaqueStencil;   status=True;.   cursor=XCreateFontCursor(display,XC_tcross);
   for ( ; ; )t   {a4     XQueryPosition(display,windows->image.id,&x,&y);4     XDefineCursor(display,windows->image.id,cursor);+     XSelectInput(display,windows->image.id,r@       windows->image.attributes.event_mask | PointerMotionMask);     state=DefaultState;      do     {l       if (windows->info.mapped)t	         {            /*%             Display pointer position.g           */P           (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);,           XInfoWidget(display,windows,text);	         }        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 3       if (event.xany.window == windows->command.id) 	         {(           /*5             Select a command from the Command widget.            */A           id=XCommandWidget(display,windows,DrawModeMenu,&event);0           if (id < 0);             continue;            switch (id)f           {*%             case DrawModePrimitiveOp: 
             {                static charo                 *Primitives[]=                 {l                   "point",                   "line",a                   "rectangle",#                   "fill rectangle",                    "ellipse",!                   "fill ellipse",                    "polygon",!                   "fill polygon",                     (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */P               primitive=XMenuWidget(display,windows,DrawModeMenu[id],Primitives,                 command)+1;*               break;
             }o!             case DrawModeColorOp: 
             {                char,                 *ColorMenu[MaxNumberPens+1];                 intF                 pen_number;                  unsigned int                 transparent;                 XColor                 color;                 /*+                 Initialize menu selections.I               */3               for (i=0; i < (MaxNumberPens-2); i++),:                 ColorMenu[i]=resource_info->pen_colors[i];7               ColorMenu[MaxNumberPens-2]="transparent"; 6               ColorMenu[MaxNumberPens-1]="Browser...";5               ColorMenu[MaxNumberPens]=(char *) NULL;)               /*8                 Select a pen color from the pop-up menu.               */P               pen_number=XMenuWidget(display,windows,DrawModeMenu[id],ColorMenu,                 command);(!               if (pen_number < 0)u                 break;:               transparent=pen_number == (MaxNumberPens-2);               if (transparent)                 {n7                   draw_info.stencil=TransparentStencil;a                   break;                 }.2               if (pen_number == (MaxNumberPens-1))                 {i                   static chari7                     color_name[MaxTextLength] = "gray";%                     /*5                     Select a pen color from a dialog.                    */C                   resource_info->pen_colors[pen_number]=color_name; K                   XColorBrowserWidget(display,windows,"Select",color_name); *                   if (*color_name == '\0')                     break;                 }                /*                 Set pen color.               */K               (void) XParseColor(display,windows->image.map_info->colormap, >                 resource_info->pen_colors[pen_number],&color);C               XBestPixel(display,windows->image.map_info->colormap, A                 (XColor *) NULL,(unsigned int) MaxColors,&color);%F               windows->image.pixel_info->pen_colors[pen_number]=color;                pen_id=pen_number;.               draw_info.stencil=OpaqueStencil;               break;
             } #             case DrawModeStippleOp: 
             {t               static chari/                 filename[MaxTextLength] = "\0",r                  *StipplesMenu[]=                 {p                   "Brick",                   "Diagonal",m                   "Scales",                    "Vertical",s                   "Wavy",o                    "Translucent",                   "Opaque",                     (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               StipplesMenu[7]="Load...";N               entry=XMenuWidget(display,windows,DrawModeMenu[id],StipplesMenu,                 command);I               if (entry < 0)                 break;+               if (stipple != (Pixmap) NULL)n-                 XFreePixmap(display,stipple); $               stipple=(Pixmap) NULL;               if (entry == 6)n                 break;               if (entry != 7)p                 {a                    switch (entry)                   {s                     case 0:l                     { H                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) BricksBitmap,BricksWidth,BricksHeight);                       break;                     }                      case 1:e                     {iH                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) DiagonalBitmap,DiagonalWidth,DiagonalHeight);                       break;                     }                      case 2:                      {eH                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) ScalesBitmap,ScalesWidth,ScalesHeight);                       break;                     }r                     case 3:                      {eH                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) VerticalBitmap,VerticalWidth,VerticalHeight);                       break;                     }d                     case 4:o                     {;H                       stipple=XCreateBitmapFromData(display,root_window,B                         (char *) WavyBitmap,WavyWidth,WavyHeight);                       break;                     }X                     case 5:d                     default:                     {lH                       stipple=XCreateBitmapFromData(display,root_window,@                         (char *) HighlightBitmap,HighlightWidth,)                         HighlightHeight);>                       break;                     }+                   }y                   break;                 }0E               XFileBrowserWidget(display,windows,"Stipple",filename);d$               if (*filename == '\0')                 break;I               status=XReadBitmapFile(display,root_window,filename,&width,l(                 &height,&stipple,&x,&y);*               if (status != BitmapSuccess)O                 XNoticeWidget(display,windows,"Unable to read X bitmap image:",a                   filename);               break;
             }%!             case DrawModeWidthOp:o
             {I               static chare+                 width[MaxTextLength] = "3",i                 *WidthsMenu[]=                 {-                   "1",                   "2",                   "4",                   "8",                   "16",                     (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               WidthsMenu[5]="Dialog...";L               entry=XMenuWidget(display,windows,DrawModeMenu[id],WidthsMenu,                 command);                if (entry < 0)                 break;               if (entry != 5)                  {d5                   line_width=atoi(WidthsMenu[entry]);                    break;                 }wL               (void) XDialogWidget(display,windows,"Ok","Enter line width:",                 width); !               if (*width == '\0')                  break;%               line_width=atoi(width);                break;
             }               case DrawModeUndoOp:
             { D               (void) XMagickCommand(display,resource_info,windows,0,%                 (KeySym) XK_u,image);                break;
             }c              case DrawModeHelpOp:
             { B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);>               XDefineCursor(display,windows->image.id,cursor);               break;
             }o#             case DrawModeDismissOp:p
             {a               /*!                 Prematurely exit.a               */!               state|=EscapeState;t               state|=ExitState;M               break;
             }              default:               break;           } :           XDefineCursor(display,windows->image.id,cursor);           continue;x	         }        switch (event.type)i       {l         case ButtonPress: 	         {t6           if (event.xbutton.window == windows->pan.id)
             {d0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             })           /*             Exit loop.           */           x=event.xbutton.x;           y=event.xbutton.y;           state|=ExitState;h           break;	         }          case ButtonRelease:,           break;         case Expose:           break;         case KeyPress:	         {e           char#             command[MaxTextLength];.             KeySym             key_symbol;a  5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {h             case XK_Escape:              case XK_F20:
             {(               /*!                 Prematurely exit.r               */!               state|=EscapeState;n               state|=ExitState;t               break;
             }n             case XK_F1:f             case XK_Help:i
             { B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);               break;
             }n             default:
             {s               XBell(display,0);o               break;
             }=           }g           break;	         }o         case MotionNotify:	         {            /*2             Discard pending pointer motion events.           */D           while (XCheckMaskEvent(display,PointerMotionMask,&event));           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)o
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }s           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);s           break;	         }e       }:#     } while (!(state & ExitState));o+     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);      if (state & EscapeState)       break;     /*C       Draw primitive as pointer moves until the button is released.&     */     distance=0;(     degrees=0.0;     line_info.x1=x;p     line_info.y1=y;      line_info.x2=x;g     line_info.y2=y;f     rectangle_info.x=x;      rectangle_info.y=y;s     rectangle_info.width=0;n     rectangle_info.height=0;     number_coordinates=1;      coordinate_info->x=x;s     coordinate_info->y=y;2D     XSetFunction(display,windows->image.highlight_context,GXinvert);     state=DefaultState;      do     {m       switch (primitive)       {E         case PointPrimitive:         default:	         {r%           if (number_coordinates > 1)1
             {a3               XDrawLines(display,windows->image.id,dA                 windows->image.highlight_context,coordinate_info,V4                 number_coordinates,CoordModeOrigin);,               (void) sprintf(text," %+d%+d",8                 coordinate_info[number_coordinates-1].x,9                 coordinate_info[number_coordinates-1].y); 0               XInfoWidget(display,windows,text);
             }i           break;	         };         case LinePrimitive: 	         {;           if (distance > 9)N
             {                /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2- E                 line_info.y1),(double) (line_info.x2-line_info.x1)));a3               (void) sprintf(text," %.2f",degrees);u0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,.=                 windows->image.highlight_context,&line_info);.
             }.           else%             if (windows->info.mapped)wM               XWithdrawWindow(display,windows->info.id,windows->info.screen);x           break;	         }i          case RectanglePrimitive:$         case FillRectanglePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {;               /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);h0               XInfoWidget(display,windows,text);<               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }(           else%             if (windows->info.mapped);M               XWithdrawWindow(display,windows->info.id,windows->info.screen);s           break;	         }i         case EllipsePrimitive:"         case FillEllipsePrimitive:	         {sH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {i               /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);c0               XInfoWidget(display,windows,text);:               XHighlightEllipse(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }o           else%             if (windows->info.mapped);M               XWithdrawWindow(display,windows->info.id,windows->info.screen);(           break;	         }o         case PolygonPrimitive:"         case FillPolygonPrimitive:	         {)%           if (number_coordinates > 1)e1             XDrawLines(display,windows->image.id,.?               windows->image.highlight_context,coordinate_info,e2               number_coordinates,CoordModeOrigin);           if (distance > 9)c
             {;               /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2- E                 line_info.y1),(double) (line_info.x2-line_info.x1))); 3               (void) sprintf(text," %.2f",degrees);e0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,n=                 windows->image.highlight_context,&line_info);e
             }/           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);0           break;	         }s       }        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);M       switch (primitive)       {n         case PointPrimitive:         default:	         {t%           if (number_coordinates > 1) 1             XDrawLines(display,windows->image.id, ?               windows->image.highlight_context,coordinate_info,C2               number_coordinates,CoordModeOrigin);           break;	         }p         case LinePrimitive:m	         {e           if (distance > 9)s5             XHighlightLine(display,windows->image.id,u;               windows->image.highlight_context,&line_info);n           break;	         }u          case RectanglePrimitive:$         case FillRectanglePrimitive:	         {sH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3)):             XHighlightRectangle(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }          case EllipsePrimitive:"         case FillEllipsePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))8             XHighlightEllipse(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }          case PolygonPrimitive:"         case FillPolygonPrimitive:	         { %           if (number_coordinates > 1) 1             XDrawLines(display,windows->image.id, ?               windows->image.highlight_context,coordinate_info,%2               number_coordinates,CoordModeOrigin);           if (distance > 9) 5             XHighlightLine(display,windows->image.id,o;               windows->image.highlight_context,&line_info);r           break;	         }        }d       switch (event.type)r       {          case ButtonPress:f           break;         case ButtonRelease: 	         {n           /*,             User has committed to primitive.           */'           line_info.x2=event.xbutton.x;c'           line_info.y2=event.xbutton.y; +           rectangle_info.x=event.xbutton.x;a+           rectangle_info.y=event.xbutton.y;e@           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;1           if (((primitive != PolygonPrimitive) &&eG                (primitive != FillPolygonPrimitive)) || (distance <= 9))C
             {o               state|=ExitState;-               break;
             }w           number_coordinates++; 3           if (number_coordinates < max_coordinates)_
             {n+               line_info.x1=event.xbutton.x;w+               line_info.y1=event.xbutton.y;m               break;
             }w           max_coordinates<<=1;$           coordinate_info=(XPoint *)D             realloc(coordinate_info,max_coordinates*sizeof(XPoint));1           if (coordinate_info == (XPoint *) NULL)yJ             Warning("Unable to draw on image","Memory allocation failed");           break;	         }          case Expose:           break;         case MotionNotify:	         {a           /*1             Discard pending button motion events.n           */8           if (event.xmotion.window != windows->image.id)             break;*           if (primitive != PointPrimitive)
             {%G               while (XCheckMaskEvent(display,ButtonMotionMask,&event)); +               line_info.x2=event.xmotion.x; +               line_info.y2=event.xmotion.y; /               rectangle_info.x=event.xmotion.x; /               rectangle_info.y=event.xmotion.y;                break;
             } @           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;           number_coordinates++; 3           if (number_coordinates < max_coordinates)              break;           max_coordinates<<=1;$           coordinate_info=(XPoint *)D             realloc(coordinate_info,max_coordinates*sizeof(XPoint));1           if (coordinate_info == (XPoint *) NULL)iJ             Warning("Unable to draw on image","Memory allocation failed");           break;	         }          default:           break;       }s       /*"         Check boundary conditions.       */       if (line_info.x2 < 0)a         line_info.x2=0; 
       else0         if (line_info.x2 > windows->image.width),           line_info.x2=windows->image.width;       if (line_info.y2 < 0)e         line_info.y2=0; 
       else1         if (line_info.y2 > windows->image.height) -           line_info.y2=windows->image.height;.       distance=uF         ((line_info.x2-line_info.x1+1)*(line_info.x2-line_info.x1+1))+F         ((line_info.y2-line_info.y1+1)*(line_info.y2-line_info.y1+1));A       if (((rectangle_info.x != x) && (rectangle_info.y != y)) ||            (state & ExitState))	         { #           if (rectangle_info.x < 0)              rectangle_info.x=0;X           else8             if (rectangle_info.x > windows->image.width)4               rectangle_info.x=windows->image.width;#           if (rectangle_info.x < x)tE             rectangle_info.width=(unsigned int) (x-rectangle_info.x);n           else
             { G               rectangle_info.width=(unsigned int) (rectangle_info.x-x);d!               rectangle_info.x=x;i
             } #           if (rectangle_info.y < 0)a             rectangle_info.y=0;w           else9             if (rectangle_info.y > windows->image.height)(5               rectangle_info.y=windows->image.height;i#           if (rectangle_info.y < y)nF             rectangle_info.height=(unsigned int) (y-rectangle_info.y);           else
             {wH               rectangle_info.height=(unsigned int) (rectangle_info.y-y);!               rectangle_info.y=y;p
             }f	         }>#     } while (!(state & ExitState));oB     XSetFunction(display,windows->image.highlight_context,GXcopy);K     if ((primitive == PointPrimitive) || (primitive == PolygonPrimitive) ||,,         (primitive == FillPolygonPrimitive))       {n
         /*)           Determine polygon bounding box.i
         */,         rectangle_info.x=coordinate_info->x;,         rectangle_info.y=coordinate_info->y;         x=coordinate_info->x;          y=coordinate_info->y; .         for (i=1; i < number_coordinates; i++)	         {e'           if (coordinate_info[i].x > x)i#             x=coordinate_info[i].x;g'           if (coordinate_info[i].y > y)i#             y=coordinate_info[i].y; 6           if (coordinate_info[i].x < rectangle_info.x)9             rectangle_info.x=Max(coordinate_info[i].x,0);16           if (coordinate_info[i].y < rectangle_info.y)9             rectangle_info.y=Max(coordinate_info[i].y,0); 	         } 0         rectangle_info.width=x-rectangle_info.x;1         rectangle_info.height=y-rectangle_info.y; .         for (i=0; i < number_coordinates; i++)	         {m1           coordinate_info[i].x-=rectangle_info.x;o1           coordinate_info[i].y-=rectangle_info.y;d	         }(       }      else       if (distance <= 9)         continue; 
       else0         if ((primitive == RectanglePrimitive) ||,             (primitive == EllipsePrimitive))           {i#             rectangle_info.width--;)$             rectangle_info.height--;           }      /*1       Drawing is relative to image configuration.x     */!     draw_info.x=rectangle_info.x;i!     draw_info.y=rectangle_info.y;iM     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_Select, 
       image);i     x=0;     y=0;     width=(*image)->columns;     height=(*image)->rows;6     if (windows->image.crop_geometry != (char *) NULL)O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);g9     x_factor=UpShift(width)/windows->image.ximage->width;>4     draw_info.x+=windows->image.x-(line_width >> 1);     if (draw_info.x < 0)       draw_info.x=0;0     draw_info.x=DownShift(draw_info.x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height;i4     draw_info.y+=windows->image.y-(line_width >> 1);     if (draw_info.y < 0)       draw_info.y=0;0     draw_info.y=DownShift(draw_info.y*y_factor);;     draw_info.width=rectangle_info.width+(line_width << 1);n,     if (draw_info.width > (*image)->columns)(       draw_info.width=(*image)->columns;=     draw_info.height=rectangle_info.height+(line_width << 1);>*     if (draw_info.height > (*image)->rows)&       draw_info.height=(*image)->rows;4     (void) sprintf(draw_info.geometry,"%ux%u%+d%+d",9       (unsigned int) DownShift(draw_info.width*x_factor),o:       (unsigned int) DownShift(draw_info.height*y_factor),#       draw_info.x+x,draw_info.y+y);e     /*$       Initialize drawing attributes.     */     draw_info.degrees=0.0;"     draw_info.primitive=primitive;     draw_info.stipple=stipple;$     draw_info.line_width=line_width;"     draw_info.line_info=line_info;)     if (line_info.x1 > (line_width >> 1)) -       draw_info.line_info.x1=line_width >> 1; )     if (line_info.y1 > (line_width >> 1))c-       draw_info.line_info.y1=line_width >> 1;eG     draw_info.line_info.x2=line_info.x2-line_info.x1+(line_width >> 1);uG     draw_info.line_info.y2=line_info.y2-line_info.y1+(line_width >> 1);%E     if ((draw_info.line_info.x2 < 0) && (draw_info.line_info.y2 < 0))        { 9         draw_info.line_info.x2=(-draw_info.line_info.x2); 9         draw_info.line_info.y2=(-draw_info.line_info.y2);        } #     if (draw_info.line_info.x2 < 0)        { 9         draw_info.line_info.x2=(-draw_info.line_info.x2); <         Swap(draw_info.line_info.x1,draw_info.line_info.x2);       } #     if (draw_info.line_info.y2 < 0)        { 9         draw_info.line_info.y2=(-draw_info.line_info.y2); <         Swap(draw_info.line_info.y1,draw_info.line_info.y2);       } ,     draw_info.rectangle_info=rectangle_info;7     if (draw_info.rectangle_info.x > (line_width >> 1))%1       draw_info.rectangle_info.x=line_width >> 1; 7     if (draw_info.rectangle_info.y > (line_width >> 1))o1       draw_info.rectangle_info.y=line_width >> 1;t4     draw_info.number_coordinates=number_coordinates;.     draw_info.coordinate_info=coordinate_info;)     windows->image.pixel_info->pen_color=u4       windows->image.pixel_info->pen_colors[pen_id];     /*       Draw primitive on image.     */*     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);K     status=XDrawImage(display,windows->image.pixel_info,&draw_info,*image); +     XSetCursorState(display,windows,False);s     /*8       Update image colormap and return to image drawing.     */B     XConfigureImageColormap(display,resource_info,windows,*image);A     (void) XConfigureImage(display,resource_info,windows,*image);    }f)   XSetCursorState(display,windows,False);d!   free((char *) coordinate_info);    return(status);n }v e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %pO %                                                                             %fO %   X D r a w P a n R e c t a n g l e                                         %MO %                                                                             % O %                                                                             % O %                                                                             %xO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %mK %  Function XDrawPanRectangle draws a rectangle in the pan window.  The panpJ %  window displays a zoomed image and the rectangle shows which portion of. %  the image is displayed in the Image window. %l2 %  The format of the XDrawPanRectangle routine is: %v' %    XDrawPanRectangle(display,windows)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned fromC %      XOpenDisplay. %i< %    o windows: Specifies a pointer to a XWindows structure. %o %  */A static void XDrawPanRectangle(Display *display,XWindows *windows)  {    unsigned long]     scale_factor;a     RectangleInfom     highlight_info;)     /*2     Determine dimensions of the panning rectangle.   */   scale_factor=(unsigned long)?     (UpShift(windows->pan.width)/windows->image.ximage->width);p<   highlight_info.x=DownShift(windows->image.x*scale_factor);D   highlight_info.width=DownShift(windows->image.width*scale_factor);   scale_factor=(unsigned long)A     (UpShift(windows->pan.height)/windows->image.ximage->height);e<   highlight_info.y=DownShift(windows->image.y*scale_factor);F   highlight_info.height=DownShift(windows->image.height*scale_factor);   /*"     Display the panning rectangle.   */(   XClearWindow(display,windows->pan.id);L   XHighlightRectangle(display,windows->pan.id,windows->pan.annotate_context,     &highlight_info);  }i n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %nO %                                                                             %(O %                                                                             %tO %   X L o a d I m a g e                                                       %aO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 2 %  Function XLoadImage loads an image from a file. % + %  The format of the XLoadImage routine is:  % C %    loaded_image=XLoadImage(display,resource_info,windows,command)( %p+ %  A description of each parameter follows:  % J %    o loaded_image: Function XLoadImage returns an image if can be loaded9 %      successfully.  Otherwise a null image is returned.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %iK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %oK %    o command: A value other than zero indicates that the file is selectedt+ %      from the command line argument list.S %e %  */G static Image *XLoadImage(Display *display,XResourceInfo *resource_info,e/   XWindows *windows,const unsigned int command)o {n   Image      *loaded_image;     ImageInfo      image_info;t  
   static char #     filename[MaxTextLength] = "\0";=     /*      Request file name from user.   */   if (!command)i8     XFileBrowserWidget(display,windows,"Load",filename);   else     { 
       char         **filelist,f         **files;  	       intn         count,         status;          register int
         i,
         j;         /*0         Select next image from the command line.       */B       status=XGetCommand(display,windows->image.id,&files,&count);       if (!status)	         { A           Warning("Unable to select image","XGetCommand failed");E!           return((Image *) NULL); 	         } 6       filelist=(char **) malloc(count*sizeof(char *));%       if (filelist == (char **) NULL) 	         {nG           Warning("Unable to select image","Memory allocation failed"); !           XFreeStringList(files); !           return((Image *) NULL);i	         }n
       j=0;       for (i=1; i < count; i++)          if (*files[i] != '-')a!           filelist[j++]=files[i];_        filelist[j]=(char *) NULL;J       XListBrowserWidget(display,windows,&windows->widget,filelist,"Load",*         "Select Image to Load:",filename);       free((char *) filelist);       XFreeStringList(files);      }    if (*filename == '\0')     return((Image *) NULL);    GetImageInfo(&image_info);.   (void) strcpy(image_info.filename,filename);   SetImageInfo(&image_info);)   if (strcmp(image_info.magick,"X") == 0)e     {(
       char         seconds[MaxTextLength];          /*8         User may want to delay the X server screen grab.       */!       (void) strcpy(seconds,"0");aP       (void) XDialogWidget(display,windows,"Grab","Enter any delay in seconds:",         seconds); )       XDelay(display,1000*atoi(seconds));p     }a0   if ((strcmp(image_info.magick,"CMYK") == 0) ||0       (strcmp(image_info.magick,"GRAY") == 0) ||/       (strcmp(image_info.magick,"MAP") == 0) ||r1       (strcmp(image_info.magick,"MATTE") == 0) ||w/       (strcmp(image_info.magick,"RGB") == 0) || 0       (strcmp(image_info.magick,"TEXT") == 0) ||0       (strcmp(image_info.magick,"TILE") == 0) ||0       (strcmp(image_info.magick,"UYVY") == 0) ||.       (strcmp(image_info.magick,"XC") == 0) ||/       (strcmp(image_info.magick,"YUV") == 0) || .       (strcmp(image_info.magick,"YUV3") == 0))     {n       static char/,         geometry[MaxTextLength] = "512x512";         /*)         Request image size from the user.        */;       if (resource_info->image_info->size != (char *) NULL) @         (void) strcpy(geometry,resource_info->image_info->size);/       resource_info->image_info->size=geometry;f2       (void) XDialogWidget(display,windows,"Load",.         "Enter the image geometry:",geometry);     }t   /*     Load the image.a   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);4   loaded_image=ReadImage(resource_info->image_info);)   XSetCursorState(display,windows,False);n%   if (loaded_image != (Image *) NULL)iC     XClientMessage(display,windows->image.id,windows->im_protocols, *       windows->im_next_image,CurrentTime);   else     { 
       char         *text,         **textlist;w  
       FILE         *file;  	       inte
         c;         register chart         *p;          unsigned int         length;h         /*         Unknown image format.o       */(       file=(FILE *) fopen(filename,"r");        if (file == (FILE *) NULL)         return((Image *) NULL);        length=MaxTextLength;>0       text=(char *) malloc(length*sizeof(char));/       for (p=text ; text != (char *) NULL; p++)        {          c=fgetc(file);         if (c == EOF);           break;!         if ((p-text+1) >= length)p           {0             *p='\0';             length<<=1;dE             text=(char *) realloc((char *) text,length*sizeof(char));|&             if (text == (char *) NULL)               break;              p=text+strlen(text);           }n         *p=(unsigned char) c;_       }o       (void) fclose(file);        if (text == (char *) NULL)         return((Image *) NULL);)       *p='\0';"       textlist=StringToList(text);%       if (textlist != (char **) NULL) 	         {            char!             title[MaxTextLength];d             register int             i;  >           (void) sprintf(title,"Unknown format: %s",filename);M           XTextViewWidget(display,resource_info,windows,True,title,textlist);w6           for (i=0; textlist[i] != (char *) NULL; i++)'             free((char *) textlist[i]);g"           free((char *) textlist);	         }        free((char *) text);     }.   return(loaded_image);d }W o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%vO %                                                                             % O %                                                                             %lO %                                                                             %eO %   X M a g i c k C o m m a n d                                               %eO %                                                                             % O %                                                                             %eO %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %xI %  Function XMagickCommand makes a transform to the image or Image window : %  as specified by a user menu button or keyboard command. % / %  The format of the XMagickCommand routine is:i %wE %    loaded_image=XMagickCommand(display,resource_info,windows,state,e %      key_symbol,image) %t+ %  A description of each parameter follows:  %tG %    o loaded_image:  Function XMagickCommand returns an image when the=I %      user chooses 'Load Image' from the command menu.  Otherwise a null  %      image is returned.; % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %e< %    o windows: Specifies a pointer to a XWindows structure. %d %    o state: key mask.  % 2 %    o key_symbol: Specifies a command to perform. %tG %    o image: Specifies a pointer to a Image structure;  XMagickCommando> %      may transform the image and return a new image pointer. %  %  */K static Image *XMagickCommand(Display *display,XResourceInfo *resource_info,xM   XWindows *windows,const unsigned int state,KeySym key_symbol,Image **image)  {    char
     *argv[5],i     geometry[MaxTextLength],$     modulate_factors[MaxTextLength];     Image;     *cache_image,      *loaded_image;     ImageInfo-     image_info;d     int      x,     y;  
   static chara"     color[MaxTextLength] = "gray",     delta[MaxTextLength] = "",     Digits[]="01234567890";-     static KeySym      last_symbol = XK_0;      static Image!     *redo_image = (Image *) NULL,i!     *undo_image = (Image *) NULL;.     unsigned int     height,      status,.
     width;  (   XCheckRefreshWindows(display,windows);3   if ((key_symbol >= XK_0) && (key_symbol <= XK_9))h     { <       if (!((last_symbol >= XK_0) && (last_symbol <= XK_9)))	         {i           *delta='\0';#           resource_info->quantum=1;o	         }        last_symbol=key_symbol; "       delta[strlen(delta)+1]='\0';3       delta[strlen(delta)]=Digits[key_symbol-XK_0];=)       resource_info->quantum=atoi(delta);        return((Image *) NULL);S     }p   last_symbol=key_symbol;d   switch (key_symbol)e   {i     case XK_Break:     {        /*1         Free memory from the undo and redo cache.s       */*       while (undo_image != (Image *) NULL)       {          cache_image=undo_image; (         undo_image=undo_image->previous;(         DestroyImage(cache_image->list);"         DestroyImage(cache_image);       }o        undo_image=(Image *) NULL;'       if (redo_image != (Image *) NULL) !         DestroyImage(redo_image);         redo_image=(Image *) NULL;       return((Image *) NULL);o     }_     case XK_u:     case XK_Undo:h     {n       /*+         Undo the last image transformation.t       */'       if (undo_image == (Image *) NULL) 	         {            XBell(display,0); !           return((Image *) NULL); 	         };       cache_image=undo_image;e&       undo_image=undo_image->previous;?       windows->image.window_changes.width=cache_image->columns;E=       windows->image.window_changes.height=cache_image->rows;(8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);9       windows->image.crop_geometry=cache_image->geometry;w'       if (redo_image != (Image *) NULL) !         DestroyImage(redo_image);,       redo_image=(*image);       *image=cache_image->list;l        DestroyImage(cache_image);        if (windows->image.orphan)         return((Image *) NULL);iD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        return((Image *) NULL);      }      case XK_Up:      case XK_KP_Up:     case XK_Down:      case XK_KP_Down:     case XK_Left:      case XK_KP_Left:     case XK_Right:     case XK_KP_Right:S     {i       if (!(state & Mod1Mask))         break;     }      case XK_F3:t     case XK_F5:      case XK_A:     case XK_less:e     case XK_o:     case XK_greater:     case XK_percent:     case XK_t:     case XK_bracketleft:     case XK_bracketright:      case XK_minus:     case XK_bar:     case XK_slash:     case XK_backslash:     case XK_asterisk:      case XK_F6:o     case XK_asciitilde:      case XK_equal:     case XK_N:     case XK_F7:r     case XK_F8:a     case XK_F9:      case XK_g:     case XK_F10:     case XK_F11:     case XK_D:     case XK_P:     case XK_S:     case XK_B:     case XK_E:     case XK_M:     case XK_F13:     case XK_F14:     case XK_F15:     case XK_F16:     case XK_O:     case XK_asciicircum:     case XK_Z:     case XK_G:     case XK_numbersign:      case XK_R:     case XK_a:     case XK_b:     case XK_F:     case XK_x:     case XK_exclam:>     case XK_Select:x     case XK_Redo:      {        Image          *previous_image;         unsigned int         bytes;         /*:         Ensure the undo cache has enough memory available.       */       if (state & Mod5Mask)E         break;6       bytes=(*image)->packets*sizeof(RunlengthPacket);4       if ((bytes >> 20) > resource_info->undo_cache)         break;        previous_image=undo_image;.       while (previous_image != (Image *) NULL)       {iE         bytes+=previous_image->list->packets*sizeof(RunlengthPacket); #         cache_image=previous_image; 0         previous_image=previous_image->previous;6         if (bytes > (resource_info->undo_cache << 20))           { 4             if (cache_image->next != (Image *) NULL)9               cache_image->next->previous=(Image *) NULL; ,             DestroyImage(cache_image->list);&             DestroyImage(cache_image);           }        }w       /*6         Save image before transformations are applied.       */4       cache_image=AllocateImage((ImageInfo *) NULL);(       if (cache_image == (Image *) NULL)         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       (*image)->orphan=True;       cache_image->list=@         CopyImage(*image,(*image)->columns,(*image)->rows,True);       (*image)->orphan=False;;-       XSetCursorState(display,windows,False);..       if (cache_image->list == (Image *) NULL)	         { $           DestroyImage(cache_image);           break;	         } 8       cache_image->columns=windows->image.ximage->width;6       cache_image->rows=windows->image.ximage->height;9       cache_image->geometry=windows->image.crop_geometry; 8       if (windows->image.crop_geometry != (char *) NULL)	         {iL           cache_image->geometry=(char *) malloc(MaxTextLength*sizeof(char));5           if (cache_image->geometry != (char *) NULL)&N             (void) strcpy(cache_image->geometry,windows->image.crop_geometry);	         }p'       if (undo_image == (Image *) NULL)t	         {i!           undo_image=cache_image;            break;	         }<#       undo_image->next=cache_image;a,       undo_image->next->previous=undo_image;"       undo_image=undo_image->next;       break;     }+     default:       break;   }    if (key_symbol ==  XK_Redo)r     {.       /*+         Redo the last image transformation.|       */'       if (redo_image == (Image *) NULL) 	         {            XBell(display,0);t!           return((Image *) NULL); 	         }p>       windows->image.window_changes.width=redo_image->columns;<       windows->image.window_changes.height=redo_image->rows;8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);8       windows->image.crop_geometry=redo_image->geometry;       DestroyImage(*image);e       *image=redo_image;        redo_image=(Image *) NULL;        if (windows->image.orphan)         return((Image *) NULL); D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       return((Image *) NULL);      }    /*     Process user command.    */   argv[0]=client_name;   loaded_image=(Image *) NULL;C   windows->image.window_changes.width=windows->image.ximage->width; E   windows->image.window_changes.height=windows->image.ximage->height;m   switch (key_symbol)e   {m     case XK_l:     {p       /*         Load image.        */C       loaded_image=XLoadImage(display,resource_info,windows,False);a       break;     }      case XK_n:     case XK_space:     {X       /*         Display next image.        */E       XClientMessage(display,windows->image.id,windows->im_protocols,1,         windows->im_next_image,CurrentTime);       break;     }u     case XK_f:     case XK_KP_Prior:_     case XK_BackSpace:     {        /*         Display former image.        */E       XClientMessage(display,windows->image.id,windows->im_protocols,p.         windows->im_former_image,CurrentTime);       break;     }I     case XK_F2:g     {l       /*         Select image.        */2       (void) chdir(resource_info->home_directory);B       loaded_image=XLoadImage(display,resource_info,windows,True);       break;     }      case XK_s:     {-       /*         Save image.;       */=       status=XSaveImage(display,resource_info,windows,image);o       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to write X image:",               (*image)->filename);           break;	         }        break;     }      case XK_p:     {        /*         Print image.       */>       status=XPrintImage(display,resource_info,windows,image);       if (status == False)	         {:C           XNoticeWidget(display,windows,"Unable to print X image:",a              (*image)->filename);           break;	         }        break;     }s     case XK_Delete:      {        static char '         filename[MaxTextLength] = "\0";c         /*         Delete image file.       */<       XFileBrowserWidget(display,windows,"Delete",filename);       if (*filename == '\0')         break;       status=remove(filename);       if (status != False)O         XNoticeWidget(display,windows,"Unable to delete image file:",filename);(       break;     }      case XK_C:     {        static chari&         color[MaxTextLength] = "gray",,         geometry[MaxTextLength] = "640x480";         /*'         Query user for canvas geometry.i       */M       (void) XDialogWidget(display,windows,"Canvas","Enter canvas geometry:",          geometry);       if (*geometry == '\0')         break;:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')n         break;       /*         Create canvas.       */        GetImageInfo(&image_info);8       (void) sprintf(image_info.filename,"xc:%s",color);       image_info.size=geometry;e*       loaded_image=ReadImage(&image_info);)       free((char *) image_info.filename); E       XClientMessage(display,windows->image.id,windows->im_protocols,i,         windows->im_next_image,CurrentTime);       break;     },     case XK_comma:     {(       static chars#         delay[MaxTextLength] = "5";          /*)         Display next image after pausing._       */       resource_info->delay=0;h8       (void) XDialogWidget(display,windows,"Slide Show",8         "Pause how many seconds between images:",delay);       if (*delay == '\0')p         break;'       resource_info->delay=atoi(delay);lE       XClientMessage(display,windows->image.id,windows->im_protocols,i,         windows->im_next_image,CurrentTime);       break;     }c     case XK_V:     {        /*         Visual Image directory.n       */H       loaded_image=XVisualDirectoryImage(display,resource_info,windows);       break;     }m     case XK_F3:u     {t       /*         Cut image.       */F       (void) XCropImage(display,resource_info,windows,*image,CutMode);       break;     }      case XK_F4:a     {_       /*         Copy image.        */G       (void) XCropImage(display,resource_info,windows,*image,CopyMode);_       break;     }/     case XK_F5:m     {d       /*         Paste image.       */?       status=XPasteImage(display,resource_info,windows,*image);r       if (status == False)	         {aB           XNoticeWidget(display,windows,"Unable to paste X image",              (*image)->filename);           break;	         }p       break;     }t     case XK_at:*     {aC       (void) XConfigureImage(display,resource_info,windows,*image);(       break;     })     case XK_F12:     {I       /*         Set user preferences.(       */?       status=XPreferencesWidget(display,resource_info,windows);e       if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);        (*image)->orphan=False;c)       if (loaded_image != (Image *) NULL) G         XClientMessage(display,windows->image.id,windows->im_protocols,p.           windows->im_next_image,CurrentTime);       break;     }-     case XK_A:     { 
       char&         image_geometry[MaxTextLength];  <       if ((windows->image.crop_geometry == (char *) NULL) &&@           ((*image)->columns == windows->image.ximage->width) &&>           ((*image)->rows == windows->image.ximage->height) &&.           (resource_info->number_colors == 0))         break;       /*'         Apply size transforms to image./       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       /**         Crop and/or scale displayed image.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height); H       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         { 6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL; 	         }        windows->image.x=0;        windows->image.y=0; ,       if (resource_info->number_colors != 0)	         {            /*5             Reduce the number of colors in the image.            */1           if (((*image)->class == DirectClass) || B               ((*image)->colors > resource_info->number_colors) ||<               (resource_info->colorspace == GRAYColorspace))>             QuantizeImage(*image,resource_info->number_colors,>               resource_info->tree_depth,resource_info->dither,)               resource_info->colorspace);a           SyncImage(*image);	         }iD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }o     case XK_less:      {c       /*         Half image size.       */L       windows->image.window_changes.width=windows->image.ximage->width >> 1;N       windows->image.window_changes.height=windows->image.ximage->height >> 1;C       (void) XConfigureImage(display,resource_info,windows,*image);s       break;     }i     case XK_o:     {s       /*         Original image size.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }      case XK_greater:     {r       /*         Double the image size.       */L       windows->image.window_changes.width=windows->image.ximage->width << 1;N       windows->image.window_changes.height=windows->image.ximage->height << 1;C       (void) XConfigureImage(display,resource_info,windows,*image);f       break;     }      case XK_percent:     {p       unsigned int         height,_         width;         /*         Resize image.=       */)       width=windows->image.ximage->width;e+       height=windows->image.ximage->height;i4       (void) sprintf(geometry,"%ux%u",width,height);4       status=XDialogWidget(display,windows,"Resize",@         "Enter resize geometry (e.g. 640x480, 200%):",geometry);       if (*geometry == '\0')         break;       if (!status)$         (void) strcat(geometry,"!");2       ParseImageGeometry(geometry,&width,&height);0       windows->image.window_changes.width=width;2       windows->image.window_changes.height=height;C       (void) XConfigureImage(display,resource_info,windows,*image);"       break;     }w     case XK_r:     {m       /*2         Restore Image window to its original size.       */8       if ((windows->image.width == (*image)->columns) &&6           (windows->image.height == (*image)->rows) &&:           (windows->image.crop_geometry == (char *) NULL))	         {i           XBell(display,0);a           break;	         } <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         { 6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;            windows->image.x=0;p           windows->image.y=0;o	         }sD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }h     case XK_bracketleft:     {t       /*         Crop image.=       */G       (void) XCropImage(display,resource_info,windows,*image,CropMode);)       break;     }a     case XK_bracketright:_     {i       /*         Chop image.e       */=       status=XChopImage(display,resource_info,windows,image);r       if (status == False)	         { @           XNoticeWidget(display,windows,"Unable to cut X image",              (*image)->filename);           break;	         }i       break;     }p     case XK_bar:     {r       /*         Flop image scanlines.x       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flop";;       MogrifyImage(resource_info->image_info,2,argv,image);c-       XSetCursorState(display,windows,False); 8       if (windows->image.crop_geometry != (char *) NULL)	         {o           /*             Flop crop geometry.            */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height);tJ           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,<             height,(int) (*image)->columns-(int) width-x,y);	         }         if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);(       break;     }      case XK_minus:     {        /*         Flip image scanlines.h       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flip";;       MogrifyImage(resource_info->image_info,2,argv,image);U-       XSetCursorState(display,windows,False); 8       if (windows->image.crop_geometry != (char *) NULL)	         {e           /*             Flip crop geometry.g           */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height);eJ           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,:             height,x,(int) (*image)->rows-(int) height-y);	         }o        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }o     case XK_slash:     {        /**         Rotate image 90 degrees clockwise.       */D       status=XRotateImage(display,resource_info,windows,90.0,image);       if (status == False)	         {mC           XNoticeWidget(display,windows,"Unable to rotate X image",t              (*image)->filename);           break;	         }g       break;     }U     case XK_backslash:     {        /*2         Rotate image 90 degrees counter-clockwise.       */E       status=XRotateImage(display,resource_info,windows,-90.0,image);        if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",t              (*image)->filename);           break;	         }        break;     }      case XK_asterisk:=     {N       /*         Rotate image.t       */C       status=XRotateImage(display,resource_info,windows,0.0,image);s       if (status == False)	         {oC           XNoticeWidget(display,windows,"Unable to rotate X image",,              (*image)->filename);           break;	         }&       break;     }      case XK_F6:X     {        static charI.         geometry[MaxTextLength] = "45.0x45.0";         /*0         Query user for shear color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')          break;K       (void) XDialogWidget(display,windows,"Shear","Enter shear geometry:",i         geometry);       if (*geometry == '\0')         break;       /*         Shear image.       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";d       argv[2]=color;       argv[3]="-shear";        argv[4]=geometry;w;       MogrifyImage(resource_info->image_info,5,argv,image);f-       XSetCursorState(display,windows,False);y<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }s     case XK_t:     {p       /*         Trim image.        */>       status=XTrimImage(display,resource_info,windows,*image);       if (status == False)	         {eA           XNoticeWidget(display,windows,"Unable to trim X image",(              (*image)->filename);           break;	         }r       break;     })     case XK_F7:e     {g       static char )         hue_percent[MaxTextLength] = "3";g         /**         Query user for percent hue change.       */3       (void) XDialogWidget(display,windows,"Apply",w:         "Enter percent change in image hue:",hue_percent);       if (*hue_percent == '\0')%         break;       /*         Vary the image hue.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);1       (void) strcpy(modulate_factors,"0.0,0.0,"); 2       (void) strcat(modulate_factors,hue_percent);       argv[1]="-modulate";       argv[2]=modulate_factors; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);%       break;     }%     case XK_F8:      {t       static chari1         saturation_percent[MaxTextLength] = "10";          /*1         Query user for percent saturation change.d       */3       (void) XDialogWidget(display,windows,"Apply",YH         "Enter percent change in color saturation:",saturation_percent);&       if (*saturation_percent == '\0')         break;       /*         Vary color saturation.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);-       (void) strcpy(modulate_factors,"0.0,");s9       (void) strcat(modulate_factors,saturation_percent);        argv[1]="-modulate";       argv[2]=modulate_factors;p;       MogrifyImage(resource_info->image_info,3,argv,image);X-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);r       break;     }      case XK_F9:e     {l       static chars0         brightness_percent[MaxTextLength] = "3";         /*1         Query user for percent brightness change.f       */3       (void) XDialogWidget(display,windows,"Apply", H         "Enter percent change in color brightness:",brightness_percent);&       if (*brightness_percent == '\0')         break;       /*"         Vary the color brightness.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);9       (void) strcpy(modulate_factors,brightness_percent);.       argv[1]="-modulate";       argv[2]=modulate_factors; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);[       break;     }l     case XK_g:     {a       static charu&         factor[MaxTextLength] = "1.6";         /*#         Query user for gamma value.        */P       (void) XDialogWidget(display,windows,"Gamma","Enter gamma value:",factor);       if (*factor == '\0')         break;       /*         Gamma correct image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-gamma";        argv[2]=factor;,;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_F10:     {        /*#         Sharpen the image contrast.i       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-contrast";;       MogrifyImage(resource_info->image_info,2,argv,image);A-       XSetCursorState(display,windows,False);"        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }      case XK_F11:     {        /*          Dull the image contrast.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="+contrast";;       MogrifyImage(resource_info->image_info,2,argv,image);o-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_equal:     {]       /*4         Perform histogram equalization on the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-equalize";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);e        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);m       break;     }m     case XK_N:     {o       /*5         Perform histogram normalization on the image.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-normalize";K;       MogrifyImage(resource_info->image_info,2,argv,image);R-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);K       break;     }      case XK_asciitilde:K     {        /*         Negate colors in image.K       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-negate";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }K     case XK_G:     {        /*#         Convert image to grayscale.m       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colorspace";       argv[2] = "gray";,;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);m        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }K     case XK_numbersign:      {        static char &         colors[MaxTextLength] = "256";         /*0         Query user for maximum number of colors.       */6       status=XDialogWidget(display,windows,"Quantize",,         "Maximum number of colors:",colors);       if (*colors == '\0')         break;       /*         Color reduce the image.;       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colors";       argv[2]=colors; -       argv[3]=status ? "-dither" : "+dither";d;       MogrifyImage(resource_info->image_info,4,argv,image);i-       XSetCursorState(display,windows,False);t        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }t     case XK_D:     {n       /*         Despeckle image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-despeckle";s;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);t        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }E     case XK_P:     {G       /*"         Reduce noise in the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-noise"; ;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }=     case XK_S:     {N       static char '         factor[MaxTextLength] = "60.0";t         /*&         Query user for sharpen factor.       */5       (void) XDialogWidget(display,windows,"Sharpen",p=         "Enter the sharpening factor (0.0 - 99.9%):",factor);e       if (*factor == '\0')         break;       /*          Sharpen image scanlines.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-sharpen";N       argv[2]=factor;X;       MogrifyImage(resource_info->image_info,3,argv,image);N-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }a     case XK_B:     {        static charl'         factor[MaxTextLength] = "60.0";=         /*#         Query user for blur factor.        */2       (void) XDialogWidget(display,windows,"Blur",;         "Enter the blurring factor (0.0 - 99.9%):",factor);        if (*factor == '\0')         break;       /*         Blur an image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-blur";       argv[2]=factor;f;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);,        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }      case XK_E:     {_       static charv'         factor[MaxTextLength] = "50.0";a         /*#         Query user for edge factor.f       */:       (void) XDialogWidget(display,windows,"Detect Edges",>         "Enter the edge detect factor (0.0 - 99.9%):",factor);       if (*factor == '\0')         break;       /*         Detect edge in image.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-edge";       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image);d-       XSetCursorState(display,windows,False);C        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }p     case XK_M:     {e       /*         Emboss image scanlines.A       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-emboss";;       MogrifyImage(resource_info->image_info,2,argv,image);o-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);-       break;     }t     case XK_F13:     {N       static char $         amount[MaxTextLength] = "2";         /*%         Query user for spread amount.g       */4       (void) XDialogWidget(display,windows,"Spread",1         "Enter the displacement amount:",amount);:       if (*amount == '\0')         break;       /*1         Displace image pixels by a random amount.l       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-spread";       argv[2]=amount; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);)        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);l       break;     }v     case XK_F14:     {u       static char%&         degrees[MaxTextLength] = "10";         /*#         Query user for swirl angle.f       */L       (void) XDialogWidget(display,windows,"Swirl","Enter the swirl angle:",         degrees);m       if (*degrees == '\0')i         break;       /*,         Swirl image pixels about the center.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-swirl";;       argv[2]=degrees;;       MogrifyImage(resource_info->image_info,3,argv,image);l-       XSetCursorState(display,windows,False);t        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);*       break;     }r     case XK_F15:     {.       static charo'         factor[MaxTextLength] = "90.0";-         /*&         Query user for implode factor.       */5       (void) XDialogWidget(display,windows,"Implode", H         "Enter the implosion/explosion factor (-99.9 - 99.9%):",factor);       if (*factor == '\0')         break;       /*.         Implode image pixels about the center.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-implode";g       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image);o-       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);w       break;     }+     case XK_F16:     {        static charn&         factor[MaxTextLength] = "128";         /*'         Query user for solarize factor.)       */6       (void) XDialogWidget(display,windows,"Solarize",9         "Enter the solarize factor (0 - 99.9%):",factor);        if (*factor == '\0')         break;       /*         Solarize image pixels.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-solarize";       argv[2]=factor;n;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);_        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }w     case XK_O:     {e       static char0$         radius[MaxTextLength] = "3";         /*4         Query user for circular neighborhood radius.       */7       (void) XDialogWidget(display,windows,"Oil Paint",i)         "Enter the mask radius:",radius);        if (*radius == '\0')         break;       /*!         OilPaint image scanlines.n       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-paint";(       argv[2]=radius; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);-        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }"     case XK_asciicircum:     {i       static char *         bevel_width[MaxTextLength] = "10";         /*#         Query user for bevel width.i       */O       (void) XDialogWidget(display,windows,"Raise","Bevel width:",bevel_width);o       if (*bevel_width == '\0')r         break;       /*         Raise an image.>       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-raise";_       argv[2]=bevel_width;;       MogrifyImage(resource_info->image_info,3,argv,image);=-       XSetCursorState(display,windows,False);G        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);a       break;     },     case XK_Z:     {a       static char_)         threshold[MaxTextLength] = "1.5";r         /*+         Query user for smoothing threshold.        */L       (void) XDialogWidget(display,windows,"Segment","Smoothing threshold:",         threshold);        if (*threshold == '\0')e         break;       /*         Segment an image.t       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-segment";        argv[2]=threshold;;       MogrifyImage(resource_info->image_info,3,argv,image);g-       XSetCursorState(display,windows,False);=        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }l     case XK_R:     {_       /*D         Apply an image processing technique to a region of interest.       */<       (void) XROIImage(display,resource_info,windows,image);       break;     }(     case XK_a:     {i       /*%         Annotate the image with text.l       */F       status=XAnnotateEditImage(display,resource_info,windows,*image);       if (status == False)	         {iE           XNoticeWidget(display,windows,"Unable to annotate X image",d              (*image)->filename);           break;	         }z       break;     }c     case XK_d:     {        /*         Draw image.a       */A       status=XDrawEditImage(display,resource_info,windows,image);b       if (status == False)	         {eH           XNoticeWidget(display,windows,"Unable to draw on the X image",              (*image)->filename);           break;	         }_       break;     }I     case XK_b:     {n       static charn(         geometry[MaxTextLength] = "6x6";         /*1         Query user for border color and geometry.f       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')t         break;8       (void) XDialogWidget(display,windows,"Add Border",+         "Enter border geometry:",geometry);t       if (*geometry == '\0')         break;       /*"         Add a border to the image.       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image);o,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";a       argv[2]=color;       argv[3]="-border";       argv[4]=geometry;c;       MogrifyImage(resource_info->image_info,5,argv,image);a-       XSetCursorState(display,windows,False);i<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);m       break;     }i     case XK_F:     {-       static charh(         geometry[MaxTextLength] = "6x6";         /*0         Query user for frame color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')s         break;O       (void) XDialogWidget(display,windows,"Add Frame","Enter frame geometry:",          geometry);       if (*geometry == '\0')         break;       /*1         Surround image with an ornamental border.d       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image);e,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-mattecolor";       argv[2]=color;       argv[3]="-frame";m       argv[4]=geometry;l;       MogrifyImage(resource_info->image_info,5,argv,image);f-       XSetCursorState(display,windows,False); <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }x     case XK_x:     {f       /*         Composite image.       */C       status=XCompositeImage(display,resource_info,windows,*image);i       if (status == False)	         { F           XNoticeWidget(display,windows,"Unable to composite X image",              (*image)->filename);           break;	         }a       break;     }p     case XK_c:     {(       /*         Color edit.        */B       status=XColorEditImage(display,resource_info,windows,image);       if (status == False)	         {iG           XNoticeWidget(display,windows,"Unable to pixel edit X image",i              (*image)->filename);           break;	         })       break;     }w     case XK_m:     {l       /*         Matte edit.d       */B       status=XMatteEditImage(display,resource_info,windows,image);       if (status == False)	         { G           XNoticeWidget(display,windows,"Unable to matte edit X image",               (*image)->filename);           break;	         }r       break;     }n     case XK_exclam:n     { 
       char         command[MaxTextLength],a          filename[MaxTextLength];  
       FILE         *file;         /*         Edit image comment.a       */"       TemporaryFilename(filename);.       if ((*image)->comments != (char *) NULL)	         {k           register charo             *p;N  #           file=fopen(filename,"w");a$           if (file == (FILE *) NULL)
             {dK               XNoticeWidget(display,windows,"Unable to edit image comment",g                 filename);               break;
             };5           for (p=(*image)->comments; *p != '\0'; p++)i'             (void) putc((int) *p,file);d!           (void) putc('\n',file);i           (void) fclose(file);	         }o5       (void) sprintf(command,EditorCommand,filename);r9       if (resource_info->editor_command != (char *) NULL)aG         (void) sprintf(command,resource_info->editor_command,filename);.,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status) N         XNoticeWidget(display,windows,"Unable to edit image comment",command);
       else	         {;1           (void) sprintf(command,"@%s",filename);;'           CommentImage(*image,command); 	         }t       (void) remove(filename);-       XSetCursorState(display,windows,False);        break;     }p     case XK_i:     {g       /*         Display image info.w       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);I       XDisplayImageInfo(display,resource_info,windows,undo_image,*image);w-       XSetCursorState(display,windows,False);l       break;     }i     case XK_ampersand:     {i       /*         Background image.        */C       status=XBackgroundImage(display,resource_info,windows,image);W       if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);w       (*image)->orphan=False;a)       if (loaded_image != (Image *) NULL)nG         XClientMessage(display,windows->image.id,windows->im_protocols,v.           windows->im_next_image,CurrentTime);       break;     }      case XK_z:     {f       /*         Zoom image.        */"       if (windows->magnify.mapped)2         XRaiseWindow(display,windows->magnify.id);
       else	         {n           /*             Make magnify image.t           */0           XSetCursorState(display,windows,True);K           status=XMakeImage(display,resource_info,&windows->magnify,*image,o<             windows->magnify.width,windows->magnify.height);G           status&=XMakePixmap(display,resource_info,&windows->magnify);t           if (status == False)B             Error("Unable to create magnify image",(char *) NULL);2           XMapRaised(display,windows->magnify.id);1           XSetCursorState(display,windows,False); 	         }f       break;     }      case XK_H:     {)
       char         command[MaxTextLength],           filename[MaxTextLength];         /*         Show image histogram.-       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);"       TemporaryFilename(filename);@       (void) sprintf(command,HistogramCommand,windows->image.id,%         (*image)->filename,filename);bA       (void) sprintf((*image)->filename,"histogram:%s",filename);s        GetImageInfo(&image_info);,       status=WriteImage(&image_info,*image);       if (status)a'         status=!SystemCommand(command);o       if (!status)	         {aI           XNoticeWidget(display,windows,"Unable to show image histogram",t             command);("           (void) remove(filename);	         }f       XDelay(display,1500); -       XSetCursorState(display,windows,False);i       break;     }(     case XK_h:     case XK_F1:s     case XK_Help:i     {U       /*         User requested help.       */:       XTextViewWidget(display,resource_info,windows,False,1         "Help Viewer - Display",ImageMagickHelp);s       break;     }d     case XK_Find:o     { 
       Atom         mozilla_atom;e  
       char         command[MaxTextLength];          Window         mozilla_window,m         root_window;         /*-         Browse the ImageMagick documentation.f       */?       root_window=XRootWindow(display,XDefaultScreen(display));wA       mozilla_atom=XInternAtom(display,"_MOZILLA_VERSION",False);fI       mozilla_window=XWindowByProperty(display,root_window,mozilla_atom);w*       if (mozilla_window != (Window) NULL)
         {            /*@             Display documentation using Netscape remote control.           */B           (void) sprintf(command,"openURL(%s,new-window,noraise)",             DocumentationURL);E           mozilla_atom=XInternAtom(display,"_MOZILLA_COMMAND",False); J           XChangeProperty(display,mozilla_window,mozilla_atom,XA_STRING,8,G             PropModeReplace,(unsigned char *) command,strlen(command));;1           XSetCursorState(display,windows,False);i           break;
         } M       (void) sprintf(command,resource_info->browse_command,DocumentationURL);s4       (void) XDialogWidget(display,windows,"Browse",1         "Browse documentation command:",command);f       if (*command == '\0')C         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status)uP         XNoticeWidget(display,windows,"Unable to browse documentation",command);       XDelay(display,1500);c-       XSetCursorState(display,windows,False);e       break;     }(     case XK_v:     {_,       XNoticeWidget(display,windows,Version,?         "Copyright 1996 E. I. du Pont de Nemours and Company");a       break;     }      case XK_q:     {=       /*         Exit program.t       */'       if (!resource_info->confirm_exit)aG         XClientMessage(display,windows->image.id,windows->im_protocols,B(           windows->im_exit,CurrentTime);
       else	         {e           /*!             Confirm program exit.            */M           status=XConfirmWidget(display,windows,"Do you really want to exit",i             client_name);e           if (status == True)aK             XClientMessage(display,windows->image.id,windows->im_protocols,a,               windows->im_exit,CurrentTime);	         }(       break;     }r     case XK_Next:,     case XK_Prior:     case XK_Home:w     case XK_KP_Home:     {t9       XTranslateImage(display,windows,*image,key_symbol);a       break;     }g     case XK_Up:t     case XK_KP_Up:     case XK_Down:w     case XK_KP_Down:     case XK_Left:o     case XK_KP_Left:     case XK_Right:     case XK_KP_Right:d     {,       if (state & Mod1Mask)n	         {s           RectangleInfow             crop_info;             /*.             Trim one pixel from edge of image.           */           crop_info.x=0;           crop_info.y=0;7           crop_info.width=windows->image.ximage->width;*9           crop_info.height=windows->image.ximage->height;e@           if ((key_symbol == XK_Up) || (key_symbol == XK_KP_Up))
             {o=               if (resource_info->quantum >= crop_info.height)r:                 resource_info->quantum=crop_info.height-1;7               crop_info.height-=resource_info->quantum;R
             }sD           if ((key_symbol == XK_Down) || (key_symbol == XK_KP_Down))
             {wK               if (resource_info->quantum >= (crop_info.height-crop_info.y))wF                 resource_info->quantum=crop_info.height-crop_info.y-1;2               crop_info.y+=resource_info->quantum;7               crop_info.height-=resource_info->quantum;l
             } D           if ((key_symbol == XK_Left) || (key_symbol == XK_KP_Left))
             {s<               if (resource_info->quantum >= crop_info.width)9                 resource_info->quantum=crop_info.width-1; 6               crop_info.width-=resource_info->quantum;
             }LF           if ((key_symbol == XK_Right) || (key_symbol == XK_KP_Right))
             {mJ               if (resource_info->quantum >= (crop_info.width-crop_info.x))E                 resource_info->quantum=crop_info.width-crop_info.x-1;S2               crop_info.x+=resource_info->quantum;6               crop_info.width-=resource_info->quantum;
             }iH           if ((windows->image.x+windows->image.width) > crop_info.width)B             windows->image.x=crop_info.width-windows->image.width;J           if ((windows->image.y+windows->image.height) > crop_info.height)D             windows->image.y=crop_info.height-windows->image.height;>           XSetCropGeometry(display,windows,&crop_info,*image);>           windows->image.window_changes.width=crop_info.width;@           windows->image.window_changes.height=crop_info.height;E           XSetWindowBackgroundPixmap(display,windows->image.id,None); G           (void) XConfigureImage(display,resource_info,windows,*image);a           break;	         } 9       XTranslateImage(display,windows,*image,key_symbol);t       break;     }r     case XK_Return:;     case XK_KP_Enter:e     case XK_Select:p       break;     default:     {p%       if (!IsModifierKey(key_symbol))t         XBell(display,0);a       break;     }p   }t   return(loaded_image);  }i w /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %aO %                                                                             %_O %                                                                             %uO %   X M a g n i f y I m a g e                                                 %iO %                                                                             %_O %                                                                             %nO %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %oF %  Function XMagnifyImage magnifies portions of the image as indicatedL %  by the pointer.  The magnified portion is displayed in a separate window. % . %  The format of the XMagnifyImage routine is: %r) %    XMagnifyImage(display,windows,event)t %d+ %  A description of each parameter follows:f %oE %    o display: Specifies a connection to an X server;  returned fromu %      XOpenDisplay. %e< %    o windows: Specifies a pointer to a XWindows structure. %eH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.( %T %L */K static void XMagnifyImage(Display *display,XWindows *windows,XEvent *event)c {t   char     text[MaxTextLength];     register int     x,     y;     unsigned long"
     state;     /*>     Update magnified image until the mouse button is released.   */C   XDefineCursor(display,windows->image.id,windows->magnify.cursor);r   state=DefaultState;f   x=event->xbutton.x;f   y=event->xbutton.y;o(   windows->magnify.x=windows->image.x+x;(   windows->magnify.y=windows->image.y+y;   do   {w     /*F       Map and unmap Info widget as text cursor crosses its boundaries.     */     if (windows->info.mapped)n       {g:         if ((x < (windows->info.x+windows->info.width)) &&9             (y < (windows->info.y+windows->info.height)))hI           XWithdrawWindow(display,windows->info.id,windows->info.screen);        }m     else8       if ((x > (windows->info.x+windows->info.width)) ||7           (y > (windows->info.y+windows->info.height)))u-         XMapWindow(display,windows->info.id);a     if (windows->info.mapped)s       {e
         /*#           Display pointer position.r
         */N         (void) sprintf(text," %+d%+d ",windows->magnify.x,windows->magnify.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */:     XIfEvent(display,event,XScreenEvent,(char *) windows);     switch (event->type)     {g       case ButtonPress:t         break;       case ButtonRelease:e       {b
         /*-           User has finished magnifying image.\
         */         x=event->xbutton.x;F         y=event->xbutton.y;f         state|=ExitState;          break;       }e       case Expose:         break;       case MotionNotify:       {p
         /*/           Discard pending button motion events.p
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));         x=event->xmotion.x;I         y=event->xmotion.y;,         break;       }l       default:         break;     }h     /*        Check boundary conditions.     */     if (x < 0)
       x=0;     else$       if (x >= windows->image.width)!         x=windows->image.width-1;l     if (y < 0)
       y=0;     else$      if (y >= windows->image.height)!        y=windows->image.height-1;g!   } while (!(state & ExitState));d   /*     Display magnified image.   */)   XSetCursorState(display,windows,False);i }w p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %aO %                                                                             % O %                                                                             %sO %   X M a g n i f y W i n d o w C o m m a n d                                 %oO %                                                                             %eO %                                                                             %wO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d % M %  Function XMagnifyWindowCommand moves the image within an Magnify window byw, %  one pixel as specified by the key symbol. % 6 %  The format of the XMagnifyWindowCommand routine is: %e< %    XMagnifyWindowCommand(display,windows,state,key_symbol) %w+ %  A description of each parameter follows:. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %f< %    o windows: Specifies a pointer to a XWindows structure. %r %    o state: key mask.  %eM %    o key_symbol: Specifies a KeySym which indicates which side of the imagee %      to trim.  %* %  */E static void XMagnifyWindowCommand(Display *display,XWindows *windows, 3   const unsigned int state,const KeySym key_symbol)  {    unsigned int     quantum;     /*0     User specified a magnify factor or position.   */   quantum=1;   if (state & Mod1Mask)i     quantum=10;t   switch (key_symbol)y   {      case XK_q:     {oK       XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);i       break;     }      case XK_Home:f     case XK_KP_Home:     { 3       windows->magnify.x=windows->image.width >> 1; 4       windows->magnify.y=windows->image.height >> 1;       break;     }a     case XK_Left:d     case XK_KP_Left:     { !       if (windows->magnify.x > 0)f$         windows->magnify.x-=quantum;       break;     }      case XK_Up:a     case XK_KP_Up:     {m!       if (windows->magnify.y > 0) $         windows->magnify.y-=quantum;       break;     }      case XK_Right:     case XK_KP_Right:)     {(8       if (windows->magnify.x < (windows->image.width-1))$         windows->magnify.x+=quantum;       break;     }i     case XK_Down:u     case XK_KP_Down:     { 9       if (windows->magnify.y < (windows->image.height-1)) $         windows->magnify.y+=quantum;       break;     }      case XK_0:     case XK_1:     case XK_2:     case XK_3:     case XK_4:     case XK_5:     case XK_6:     case XK_7:     case XK_8:     case XK_9:     {h,       windows->magnify.data=key_symbol-XK_0;       break;     }      case XK_KP_0:      case XK_KP_1:e     case XK_KP_2:      case XK_KP_3:      case XK_KP_4:      case XK_KP_5:t     case XK_KP_6:)     case XK_KP_7:d     case XK_KP_8:      case XK_KP_9:g     {s/       windows->magnify.data=key_symbol-XK_KP_0;N       break;     }      default:       break;   }n%   XMakeMagnifyImage(display,windows);* }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             % O %                                                                             %iO %                                                                             % O %   X M a k e P a n I m a g e                                                 %eO %                                                                             % O %                                                                             %uO %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %eM %  Function XMakePanImage creates a thumbnail of the image and displays it inn %  the Pan icon window.v %.. %  The format of the XMakePanImage routine is: % 9 %      XMakePanImage(display,resource_info,windows,image)f %d+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %M< %    o windows: Specifies a pointer to a XWindows structure. %lF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %n */H static void XMakePanImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)  {e   unsigned int     status;d     /*.     Create and display image for panning icon.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   windows->pan.x=windows->image.x;"   windows->pan.y=windows->image.y;>   status=XMakeImage(display,resource_info,&windows->pan,image,,     windows->pan.width,windows->pan.height);;   status&=XMakePixmap(display,resource_info,&windows->pan);    if (status == False);     Error("Unable to create Pan icon image",(char *) NULL);/J   XSetWindowBackgroundPixmap(display,windows->pan.id,windows->pan.pixmap);(   XClearWindow(display,windows->pan.id);%   XDrawPanRectangle(display,windows); )   XSetCursorState(display,windows,False);m }( p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             % O %                                                                             %fO %                                                                             %mO %   X M a t t a E d i t I m a g e                                             % O %                                                                             %mO %                                                                             %dO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XMatteEditImage allows the user to interactively change M %  the Matte channel of an image.  If the image is PseudoClass it is promoted H %  to DirectClass before the matte information is stored.  The floodfillL %  algorithm is strongly based on a similiar algorithm in "Graphics Gems" by %  Paul Heckbert.3 % 0 %  The format of the XMatteEditImage routine is: %-9 %    XMatteEditImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:e %tE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %t< %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned frome %      ReadImage.  %  */  D static void MatteFloodfill(Image *image,int x,int y,const int matte,   const int delta) {    int      offset, 	     skip, 
     start,     x1,r     x2;i     register RunlengthPacket     *pixel;      register XSegment      *p;      RunlengthPacketo     target;l  
   XSegment     *segment_stack;      /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))n     return; +   target=image->pixels[y*image->columns+x];n-   if (target.index == (unsigned short) matte)      return;m   /*     Allocate segment stack.)   */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)h     {s@       Warning("Unable to floodfill","Memory allocation failed");
       return;o     }"   /*"     Push initial segment on stack.   */
   start=0;   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);k   while (p > segment_stack),   {w     /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;a     offset=p->y2;      y=p->y1+offset;l     /*5       Update matte information in neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     {w/       pixel=image->pixels+(y*image->columns+x); +       if (!MatteMatch(*pixel,target,delta))          break;*       pixel->index=(unsigned short) matte;     }c     skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) %           Push(y,start,x1-1,-offset);          x=x1+1;        }      do     {        if (!skip)	         {8*           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); 1             if (!MatteMatch(*pixel,target,delta))                break;0             pixel->index=(unsigned short) matte;           } #           Push(y,start,x-1,offset);            if (x > (x2+1))9%             Push(y,x2+1,x-1,-offset); 	         }        skip=False;        for (x++; x <= x2 ; x++)       {u1         pixel=image->pixels+(y*image->columns+x);i,         if (MatteMatch(*pixel,target,delta))           break;       }t       start=x;     } while (x <= x2);   }(   free((char *) segment_stack);t })  5 static unsigned int XMatteEditImage(Display *display,b?   XResourceInfo *resource_info,XWindows *windows,Image **image)m {( #define MatteEditMethodOp  0 #define MatteEditDeltaOp  1  #define MatteEditValueOp  2  #define MatteEditUndoOp  3 #define MatteEditHelpOp  4 #define MatteEditDismissOp  5   
   static char      *MatteEditMenu[]=      {        "Method",r       "Delta",       "Matte Value",
       "Undo",i
       "Help",%       "Dismiss",       (char *) NULLn     };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;t     intd
     entry,     id,f     x,
     x_offset,_     y,
     y_offset;t     register int     i;     register RunlengthPacket     *p;n  
   static chari     matte[MaxTextLength] = "0";      static unsigned intn     delta = 0,     method = PointMethodOp;m     unsigned int     height, 
     width;     unsigned longi
     state,
     x_factor, 
     y_factor;      XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Matte Edit";=   windows->command.data=2;G   (void) XCommandWidget(display,windows,MatteEditMenu,(XEvent *) NULL);c*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);o   /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color);e2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);x   state=DefaultState;    do   {x     if (windows->info.mapped)f       {_
         /*#           Display pointer position.r
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }_     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)s       { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,MatteEditMenu,&event);         if (id < 0).           {e<             XDefineCursor(display,windows->image.id,cursor);             continue;s           }e         switch (id)c	         { !           case MatteEditMethodOp:u           {a             static char                *MethodMenu[]=               {_                 "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             entry=P               XMenuWidget(display,windows,MatteEditMenu[id],MethodMenu,command);             if (entry >= 0)                method=entry;d             break;           }             case MatteEditDeltaOp:           {)             static char;               *DeltaMenu[]=                {e                 "0",                 "1",                 "2",                 "4",                 "8",                 "16",)                 "32",,                 (char *) NULL,                 (char *) NULL,               },)               value[MaxTextLength] = "3";f               /*8               Select a delta value from the pop-up menu.             */%             DeltaMenu[7]="Dialog..."; J             entry=XMenuWidget(display,windows,MatteEditMenu[id],DeltaMenu,               command);a             if (entry < 0)               break;             if (entry != 7)                {t-                 delta=atoi(DeltaMenu[entry]);                  break;               }=K             (void) XDialogWidget(display,windows,"Ok","Enter delta value:",(               value);=             if (*value == '\0')                break;             delta=atoi(value);             break;           }             case MatteEditValueOp:           {              /*0               Request matte value from the user.             */N             (void) XDialogWidget(display,windows,"Matte","Enter matte value:",               matte);m             break;           };           case MatteEditUndoOp:,           {.B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);              break;           }            case MatteEditHelpOp:            {i@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);d             break;           }i"           case MatteEditDismissOp:           {x             /*               Prematurely exit._             */             state|=EscapeState;              state|=ExitState;e             break;           }            default:             break;	         } 8         XDefineCursor(display,windows->image.id,cursor);         continue;o       }-     switch (event.type))     {f       case ButtonPress::       {x4         if (event.xbutton.window == windows->pan.id)           {u.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }a
         /*           Update matte data.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { 
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);f         break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];;           KeySym           key_symbol;w  3         if (event.xkey.window != windows->image.id)M           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),d/           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol)f	         {            case XK_Escape:            case XK_F20:           {i             /*               Prematurely exit.t             */             state|=ExitState;i             break;           }.           case XK_F1:            case XK_Help:n           {d@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);f             break;           }n           default:           {a             XBell(display,0);              break;           } 	         }_         break;       }        case MotionNotify:       {w
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);i           }w         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);g         break;       }        default:         break;     }-     x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)        {          inte          x,l          y;i  
         /*8           Matte edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True);v:         XPutPixel(windows->image.ximage,x_offset,y_offset,=           windows->image.pixel_info->background_color.pixel);-         x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);=         x_factor=UpShift(width)/windows->image.ximage->width; C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x;v?         y_factor=UpShift(height)/windows->image.ximage->height;nC         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y;r-         if ((x_offset < 0) || (y_offset < 0))            continue;mL         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue;|$         (*image)->class=DirectClass;         if (!(*image)->matte)e           {              /*$               Initialize matte data.             */             p=(*image)->pixels;p1             for (i=0; i < (*image)->packets; i++) 
             {f               p->index=Opaque;               p++;
             }d!             (*image)->matte=True;            }r         switch (method) 	         {.           case PointMethodOp:a           default:           {              /*=               Update matte information using point algorithm.              */)             if (!UncompressImage(*image))d               break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset);g(             p->index=atoi(matte) & 0xff;             break;           }            case ReplaceMethodOp:a           {              RunlengthPacketa               target;h               /*?               Update matte information using replace algorithm.h             */             x=0;             p=(*image)->pixels;;1             for (i=0; i < (*image)->packets; i++)y
             {i               x+=(p->length+1);m<               if (x > (y_offset*(*image)->columns+x_offset))                 break;               p++;
             }i'             target=(*image)->pixels[i];              p=(*image)->pixels;w1             for (i=0; i < (*image)->packets; i++)g
             {i.               if (ColorMatch(*p,target,delta)),                 p->index=atoi(matte) & 0xff;               p++;
             })             break;           }e!           case FloodfillMethodOp:s           {              /*A               Update matte information using floodfill algorithm.              */)             if (!UncompressImage(*image))a               break;N             MatteFloodfill(*image,x_offset,y_offset,atoi(matte) & 0xff,delta);             break;           }i           case ResetMethodOp:            {)             /*=               Update matte information using reset algorithm.n             */             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {g*               p->index=atoi(matte) & 0xff;               p++;
             } /             if ((atoi(matte) & 0xff) == Opaque)e$               (*image)->matte=False;             break;           } 	         } +         state&=(~UpdateConfigurationState);f       }t!   } while (!(state & ExitState));=O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);n)   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);a }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             %;O %                                                                             % O %                                                                             %rO %   X P a n I m a g e                                                         %xO %                                                                             %EO %                                                                             % O %                                                                             %cO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%C %rH %  Function XPanImage pans the image until the mouse button is released. %:* %  The format of the XPanImage routine is: % % %    XPanImage(display,windows,event): %%+ %  A description of each parameter follows:. %dE %    o display: Specifies a connection to an X server;  returned from. %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.  %  */G static void XPanImage(Display *display,XWindows *windows,XEvent *event)e {i   char     text[MaxTextLength];     Cursor     cursor;r     RectangleInfoo
     pan_info;v     unsigned long=
     state,
     x_factor, 
     y_factor;.     /*     Define cursor.   */>   if ((windows->image.ximage->width > windows->image.width) &&>       (windows->image.ximage->height > windows->image.height))/     cursor=XCreateFontCursor(display,XC_fleur);=   else<     if (windows->image.ximage->width > windows->image.width)=       cursor=XCreateFontCursor(display,XC_sb_h_double_arrow);      else@       if (windows->image.ximage->height > windows->image.height)?         cursor=XCreateFontCursor(display,XC_sb_v_double_arrow); 
       else3         cursor=XCreateFontCursor(display,XC_arrow);;0   XDefineCursor(display,windows->pan.id,cursor);   /*B     Pan image as pointer moves until the mouse button is released.   */   x_factor=(unsigned long)=     UpShift(windows->image.ximage->width)/windows->pan.width;t   y_factor=(unsigned long)?     UpShift(windows->image.ximage->height)/windows->pan.height;uI   pan_info.width=(unsigned int) (UpShift(windows->image.width)/x_factor);dK   pan_info.height=(unsigned int) (UpShift(windows->image.height)/y_factor);c!   state=UpdateConfigurationState;-   do   {%     switch (event->type)     {k       case ButtonPress:y       {=
         /*.           User choose an initial pan location.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        {s
         /*.           User has finished panning the image.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;4         state|=UpdateConfigurationState | ExitState;         break;       }m       case MotionNotify:       {e
         /*/           Discard pending button motion events..
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));$         pan_info.x=event->xmotion.x;$         pan_info.y=event->xmotion.y;(         state|=UpdateConfigurationState;       }        default:         break;     }r)     if (state & UpdateConfigurationState)l       {-
         /*$           Check boundary conditions.
         */J         pan_info.x=DownShift((pan_info.x-(pan_info.width >> 1))*x_factor);         if (pan_info.x < 0)-           pan_info.x=0;          elseO           if ((pan_info.x+windows->image.width) > windows->image.ximage->width).I             pan_info.x=windows->image.ximage->width-windows->image.width;dK         pan_info.y=DownShift((pan_info.y-(pan_info.height >> 1))*y_factor);          if (pan_info.y < 0)            pan_info.y=0;d         else2           if ((pan_info.y+windows->image.height) >-                windows->image.ximage->height)oK             pan_info.y=windows->image.ximage->height-windows->image.height; /         if ((windows->image.x != pan_info.x) ||t-             (windows->image.y != pan_info.y))            {c             /*'               Display image pan offset.r             */(             windows->image.x=pan_info.x;(             windows->image.y=pan_info.y;E             (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,fG               windows->image.height,windows->image.x,windows->image.y);s.             XInfoWidget(display,windows,text);             /*#               Refresh Image window.              *//             XDrawPanRectangle(display,windows);TD             XRefreshWindow(display,&windows->image,(XEvent *) NULL);           }m+         state&=(~UpdateConfigurationState);w       }o     /*       Wait for next event.     */     if (!(state & ExitState))l<       XIfEvent(display,event,XScreenEvent,(char *) windows);!   } while (!(state & ExitState));e   /*     Restore cursor.e   */=   XDefineCursor(display,windows->pan.id,windows->pan.cursor);w   XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);) }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %nO %                                                                             % O %                                                                             %iO %   X P a s t e I m a g e                                                     %nO %                                                                             %aO %                                                                             %cO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XPasteImage pastes an image previously saved with XCropImageI %  in the X window image at a location the user chooses with the pointer.  % , %  The format of the XPasteImage routine is: %_< %    status=XPasteImage(display,resource_info,windows,image) % + %  A description of each parameter follows:e %r@ %    o status: Function XPasteImage returns True if the image isI %      pasted.  False is returned is there is a memory shortage or if ther  %      image fails to be pasted. % E %    o display: Specifies a connection to an X server;  returned fromi %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.( %p< %    o windows: Specifies a pointer to a XWindows structure. %-E %    o image: Specifies a pointer to a Image structure; returned from. %      ReadImage.o %> */N static unsigned int XPasteImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)v {. #define PasteModeOperatorsOp  0l #define PasteModeHelpOp  1 #define PasteModeDismissOp  2   
   static char      *PasteModeMenu[]=f     {.       "Operator",o
       "Help",        "Dismiss",       (char *) NULLe     };     char     text[MaxTextLength];     Cursor     cursor;      Image      *paste_image;o     inte     id,      x,     y;     RectangleInfop     highlight_info,;     paste_info;      static unsigned intr#     operation = ReplaceCompositeOp;      unsigned int     height,-
     width;     unsigned longn     scale_factor, 
     state;     XEvent
     event;     /*     Copy image.e   */#   if (copy_image == (Image *) NULL)      return(False);   copy_image->orphan=True;N   paste_image=CopyImage(copy_image,copy_image->columns,copy_image->rows,True);   copy_image->orphan=False;g   /*     Map Command widget.o   */    windows->command.name="Paste";   windows->command.data=1;G   (void) XCommandWidget(display,windows,PasteModeMenu,(XEvent *) NULL);u*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */)   XSetCursorState(display,windows,False);;2   XQueryPosition(display,windows->image.id,&x,&y);"   paste_info.x=windows->image.x+x;"   paste_info.y=windows->image.y+y;   paste_info.width=0;    paste_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |a     PointerMotionMask); 0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;o   do   {      if (windows->info.mapped)a       {,
         /*#           Display pointer position._
         */B         (void) sprintf(text," %+d%+d ",paste_info.x,paste_info.y);*         XInfoWidget(display,windows,text);       }      highlight_info=paste_info;3     highlight_info.x=paste_info.x-windows->image.x;e3     highlight_info.y=paste_info.y-windows->image.y;a2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);g2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)        {s
         /*3           Select a command from the Command widget.!
         */@         id=XCommandWidget(display,windows,PasteModeMenu,&event);         if (id < 0)            continue;          switch (id)w	         {d$           case PasteModeOperatorsOp:           {              char%               command[MaxTextLength];e               static char                *OperatorMenu[]=               {t                 "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",(                 "minus",                 "add",                 "subtract",t                 "difference",f                 "bumpmap",                 "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */D             operation=XMenuWidget(display,windows,PasteModeMenu[id],&               OperatorMenu,command)+1;             break;           },           case PasteModeHelpOp:            {)@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);             break;           }e"           case PasteModeDismissOp:           {i             /*               Prematurely exit.e             */             state|=EscapeState;i             state|=ExitState;              break;           }            default:             break;	         }-         continue;        }s     switch (event.type)      {i       case ButtonPress:        { !         if (resource_info->debug)dB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);(4         if (event.xbutton.window == windows->pan.id)           {y.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*=           Paste rectangle is relative to image configuration. 
         */         x=0;         y=0;         width=image->columns;e         height=image->rows; :         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,=             &width,&height);A         scale_factor=UpShift(width)/windows->image.ximage->width;nF         paste_info.width=DownShift(paste_image->columns*scale_factor);C         scale_factor=UpShift(height)/windows->image.ximage->height; D         paste_info.height=DownShift(paste_image->rows*scale_factor);8         XDefineCursor(display,windows->image.id,cursor);6         paste_info.x=windows->image.x+event.xbutton.x;6         paste_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:;       {F!         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);)@         if ((paste_info.width != 0) && (paste_info.height != 0))           {g             /*@               User has selected the location of the paste image.             */:             paste_info.x=windows->image.x+event.xbutton.x;:             paste_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;m           }a         break;       }e       case Expose:         break;       case KeyPress:       {-         char!           command[MaxTextLength];y           KeySym           key_symbol;l           int            length;%  3         if (event.xkey.window != windows->image.id)%           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */&             DestroyImage(paste_image);             state|=EscapeState;%             state|=ExitState;%             break;           }            case XK_F1:a           case XK_Help:i           {nJ             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {s             XBell(display,0);e             break;           }d	         }c         break;       }X       case MotionNotify:       {n
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)f           {n>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);p           }n         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))e1             XMapWindow(display,windows->info.id);,(         paste_info.x=windows->image.x+x;(         paste_info.y=windows->image.y+y;         break;       }x       default:       {e!         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);u         break;       },     };!   } while (!(state & ExitState));_@   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);n)   XSetCursorState(display,windows,False);i   XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*5     Image pasting is relative to image configuration._   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows;i4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);X;   scale_factor=UpShift(width)/windows->image.ximage->width;    paste_info.x+=x;4   paste_info.x=DownShift(paste_info.x*scale_factor);<   paste_info.width=DownShift(paste_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    paste_info.y+=y;4   paste_info.y=DownShift(paste_info.y*scale_factor);>   paste_info.height=DownShift(paste_info.height*scale_factor);   /*$     Paste image with X Image window.   */H   CompositeImage(image,operation,paste_image,paste_info.x,paste_info.y);   DestroyImage(paste_image);)   XSetCursorState(display,windows,False);e   /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image);o>   (void) XConfigureImage(display,resource_info,windows,image);   return(True);n }r ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             % O %                                                                             %xO %   X P r i n t I m a g e                                                     %aO %                                                                             % O %                                                                             %yO %                                                                             %cO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %i@ %  Function XPrintImage prints an image to a Postscript printer. %t, %  The format of the XPrintImage routine is: % < %    status=XPrintImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % ? %    o status: Function XPrintImage return True if the image isnJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %/F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */N static unsigned int XPrintImage(Display *display,XResourceInfo *resource_info,"   XWindows *windows,Image **image) {    char     command[MaxTextLength],e     filename[MaxTextLength],     geometry[MaxTextLength];     ImageInfo      *image_info;     int      status;;  
   static char !     print_command[MaxTextLength];      /*/     Request Postscript page geometry from user.s   */'   image_info=resource_info->image_info; *   (void) sprintf(geometry,PSPageGeometry);(   if (image_info->page != (char *) NULL)-     (void) strcpy(geometry,image_info->page);nI   XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select", 1     "Select Postscript Page Geometry:",geometry);    if (*geometry == '\0')     return(True);l0   image_info->page=PostscriptGeometry(geometry);   /*      Request file name from user.   */(   XCheckRefreshWindows(display,windows);   TemporaryFilename(filename);<   (void) strcpy(print_command,resource_info->print_command);O   (void) XDialogWidget(display,windows,"Print","Print command:",print_command);    if (*print_command == '\0')r     return(True);n>   if (strcmp(print_command,resource_info->print_command) != 0)     { 1       resource_info->print_command=print_command; &       XUserPreferences(resource_info);     }    /*     Print image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image);n(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);6   (void) sprintf((*image)->filename,"ps:%s",filename);'   status=WriteImage(image_info,*image);l1   (void) sprintf(command,print_command,filename);0"   status&=!SystemCommand(command); #ifndef vms    (void) remove(filename); #endif)   XSetCursorState(display,windows,False); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);    return(status);p }c r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             %eO %                                                                             %rO %   X P r o g r e s s M o n i t o r                                           % O %                                                                             % O %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %aF %  Function XProgressMonitor displays the progress a task is making in %  completing a task.  % 1 %  The format of the XProgressMonitor routine is:o %h* %      XProgressMonitor(task,quantum,span) % + %  A description of each parameter follows:r %M- %    o task: Identifies the task in progress.p %MO %    o quantum: Specifies the quantum position within the span which representsr< %      how much progress has been made in completing a task. % > %    o span: Specifies the span relative to completing a task. %L %  */C static void XProgressMonitor(char *task,const unsigned int quantum,(   const unsigned int span) {a4   XMonitorWidget(display,windows,task,quantum,span); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %aO %                                                                             % O %                                                                             %pO %   X R O I I m a g e                                                         %DO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a % G %  Function XROIImage applies an image processing technique to a region  %  of interest.  % * %  The format of the XROIImage routine is: %w: %    status=XROIImage(display,resource_info,windows,image) %l+ %  A description of each parameter follows:  %a> %    o status: Function XROIImage returns True if the image isJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %XK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %oE %    o image: Specifies a pointer to a Image structure; returned fromi %      ReadImage.  %  %  */L static unsigned int XROIImage(Display *display,XResourceInfo *resource_info,"   XWindows *windows,Image **image) {; #define ApplyModeMenus  5  #define ApplyModeFileOp  0 #define ApplyModeEditOp  1 #define ApplyModeTransformOp  2n #define ApplyModeEnhanceOp  3r #define ApplyModeEffectsOp  4d #define ApplyModeHelpOp  5 #define ApplyModeDismissOp  6  #define ROIModeHelpOp  0 #define ROIModeDismissOp  1s  
   static char)     *ROIModeMenu[]=t     {e
       "Help",w       "Dismiss",       (char *) NULL      },     *ApplyModeMenu[]=      { 
       "File", 
       "Edit",        "Transform",       "Enhance",       "Effects",
       "Help",e       "Dismiss",       (char *) NULL=     },     *FileMenu[]=     {n       "Image Info",        (char *) NULL      },     *EditMenu[]=     { 
       "Undo",4
       "Redo",        (char *) NULL      },     *TransformMenu[]=      { 
       "Flop", 
       "Flip",a       "Rotate Right",        "Rotate Left",       (char *) NULL      },     *EnhanceMenu[]=-     {.       "Hue...",/       "Saturation...",       "Brightness...",       "Gamma...",n       "Spiff",
       "Dull",e       "Equalize",,       "Normalize",       "Negate",        "Grayscale",       "Quantize...",       (char *) NULL(     },     *EffectsMenu[]=      {        "Despeckle",       "Peak Noise",e       "Sharpen...",        "Blur...",       "Edge Detect...",        "Emboss...",       "Spread...",       "Swirl...",i       "Implode...",        "Solarize...",       "Oil Painting...",       "Raise...",a       "Segment...",e       (char *) NULL      };  
   static char      **Menus[ApplyModeMenus]=     {U       FileMenu,        EditMenu,        TransformMenu,       EnhanceMenu,       EffectsMenu      };     static KeySymm     ApplyModeKeys[]=     {        XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_h,w
       XK_q     },     FileKeys[]=r     {e
       XK_i     },     EditKeys[]=      {f       XK_u,p
       XK_Redoa     },     TransformKeys[]=     { 
       XK_bar,        XK_minus,D       XK_slash,p       XK_backslash     },     EnhanceKeys[]=     {m       XK_F7,       XK_F8,       XK_F9,       XK_g,E
       XK_F10, 
       XK_F11,t       XK_equal,        XK_N,r       XK_asciitilde,       XK_G,e       XK_numbersign      },     EffectsKeys[]=     {f       XK_D,p       XK_P,i       XK_S,r       XK_B,        XK_E,        XK_M, 
       XK_F13,.
       XK_F14,l
       XK_F15,B
       XK_F16,        XK_O,        XK_asciicircum,.
       XK_Z     };     static KeySym      *Keys[ApplyModeMenus]=     {,       FileKeys,        EditKeys,f       TransformKeys,       EnhanceKeys,       EffectsKeys,     };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      intb
     entry,     id,t     x,     y;     KeySym     key_symbol;      MonitorHandler     handler;     RectangleInfo      highlight_info, 
     roi_info;      unsigned int     height,e
     width;     unsigned longo     scale_factor,]
     state;     XEvent
     event;     /*     Map Command widget.n   */   windows->command.name="ROI";   windows->command.data=0;E   (void) XCommandWidget(display,windows,ROIModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,u+     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);    roi_info.x=windows->image.x+x;    roi_info.y=windows->image.y+y;   roi_info.width=0;    roi_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |T     PointerMotionMask);o   state=DefaultState;,   do   {      if (windows->info.mapped)t       {e
         /*#           Display pointer position. 
         */>         (void) sprintf(text," %+d%+d ",roi_info.x,roi_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)l       {M
         /*3           Select a command from the Command widget.m
         */>         id=XCommandWidget(display,windows,ROIModeMenu,&event);         if (id < 0)x           continue;b         switch (id) 	         {            case ROIModeHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);              break;           }i            case ROIModeDismissOp:           {              /*               Prematurely exit.x             */             state|=EscapeState;              state|=ExitState;.             break;           }            default:             break;	         }          continue;        }      switch (event.type)e     {S       case ButtonPress:t       {w4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }w,         if (event.xbutton.button == Button1)           {              /*L               Note first corner of region of interest rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);8             roi_info.x=windows->image.x+event.xbutton.x;8             roi_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;-             break;           }w         break;       }o       case Expose:         break;       case KeyPress:       {w3         if (event.xkey.window != windows->image.id)v           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),d/           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol)t	         {e           case XK_Escape:i           case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;1             state|=ExitState;e             break;           }            case XK_F1:;           case XK_Help:e           {e@             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);              break;           }a           default:           {i             XBell(display,0);i             break;           }2	         }x         break;       }i       case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);i&         roi_info.x=windows->image.x+x;&         roi_info.y=windows->image.y+y;         break;       }d       default:         break;     }-!   } while (!(state & ExitState));_O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {,       /*5         User want to exit without region of interest.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);e     }eB   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {d     /*I       Size rectangle as pointer moves until the mouse button is released.%     */     x=roi_info.x;,     y=roi_info.y;e     roi_info.width=0;t     roi_info.height=0;     state=DefaultState;I+     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {g       highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x;d3       highlight_info.y=roi_info.y-windows->image.y;pD       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*?             Display info and draw region of interest rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id);dL           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);i,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped)iI           XWithdrawWindow(display,windows->info.id,windows->info.screen);)       /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)        {r         case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             {r0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }f6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;           break;	         }o         case ButtonRelease:d	         {d           /*?             User has committed to region of interest rectangle.            */6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False);            state|=ExitState;r9           if (strcmp(windows->command.name,"Apply") == 0)              break;(           windows->command.name="Apply";/           windows->command.data=ApplyModeMenus;aO           (void) XCommandWidget(display,windows,ApplyModeMenu,(XEvent *) NULL);n           break;	         }          case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events..           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 6           roi_info.x=windows->image.x+event.xmotion.x;6           roi_info.y=windows->image.y+event.xmotion.y;	         }          default:           break;       } J       if (((roi_info.x != x) && (roi_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (roi_info.x < 0)o             roi_info.x=0;f           else:             if (roi_info.x > windows->image.ximage->width)6               roi_info.x=windows->image.ximage->width;           if (roi_info.x < x) 9             roi_info.width=(unsigned int) (x-roi_info.x);a           else
             {a;               roi_info.width=(unsigned int) (roi_info.x-x);                roi_info.x=x;t
             }            if (roi_info.y < 0).             roi_info.y=0;            else;             if (roi_info.y > windows->image.ximage->height)x7               roi_info.y=windows->image.ximage->height;            if (roi_info.y < y)n:             roi_info.height=(unsigned int) (y-roi_info.y);           else
             { <               roi_info.height=(unsigned int) (roi_info.y-y);               roi_info.y=y;n
             }(	         } #     } while (!(state & ExitState));t+     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     {i       if (windows->info.mapped) 	         {r           /*%             Display pointer position.            */L           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);a,           XInfoWidget(display,windows,text);	         }        highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x; 3       highlight_info.y=roi_info.y-windows->image.y;tF       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;n           state|=ExitState;i           break;	         } $       if (state & UpdateRegionState)	         { H           XSetFunction(display,windows->image.highlight_context,GXcopy);           switch (key_symbol)f           {o             case XK_i:             case XK_u:             case XK_Undo:n             case XK_Redo: 
             { O               (void) XMagickCommand(display,resource_info,windows,0,key_symbol,                  image);c               break;
             }              default:
             {s               Image                  *roi_image;+                 RectangleInfon                 crop_info;                 /*F                 Region of interest is relative to image configuration.               */?               handler=SetMonitorHandler((MonitorHandler) NULL);r!               crop_info=roi_info;                x=0;               y=0;&               width=(*image)->columns;$               height=(*image)->rows;@               if (windows->image.crop_geometry != (char *) NULL)I                 (void) XParseGeometry(windows->image.crop_geometry,&x,&y, "                   &width,&height);G               scale_factor=UpShift(width)/windows->image.ximage->width;                crop_info.x+=x; >               crop_info.x=DownShift(crop_info.x*scale_factor);F               crop_info.width=DownShift(crop_info.width*scale_factor);I               scale_factor=UpShift(height)/windows->image.ximage->height;_               crop_info.y+=y;f>               crop_info.y=DownShift(crop_info.y*scale_factor);H               crop_info.height=DownShift(crop_info.height*scale_factor);5               roi_image=CropImage(*image,&crop_info);o0               (void) SetMonitorHandler(handler);.               if (roi_image == (Image *) NULL)                 continue;                /*K                 Apply image processing technique to the region of interest.                */)               windows->image.orphan=True; K               (void) XMagickCommand(display,resource_info,windows,Mod5Mask,t'                 key_symbol,&roi_image);e?               handler=SetMonitorHandler((MonitorHandler) NULL);yD               (void) XMagickCommand(display,resource_info,windows,0,*                 (KeySym) XK_Select,image);*               windows->image.orphan=False;A               CompositeImage(*image,ReplaceCompositeOp,roi_image,e)                 crop_info.x,crop_info.y);n&               DestroyImage(roi_image);0               (void) SetMonitorHandler(handler);               break;
             }            }l!           if (key_symbol != XK_i) 
             {lL               XConfigureImageColormap(display,resource_info,windows,*image);K               (void) XConfigureImage(display,resource_info,windows,*image);g
             },0           XCheckRefreshWindows(display,windows);,           XInfoWidget(display,windows,text);J           XSetFunction(display,windows->image.highlight_context,GXinvert);&           state&=(~UpdateRegionState);	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows);r3       if (event.xany.window == windows->command.id)y	         {            /*5             Select a command from the Command widget.<           */H           XSetFunction(display,windows->image.highlight_context,GXcopy);#           key_symbol=XK_VoidSymbol;eB           id=XCommandWidget(display,windows,ApplyModeMenu,&event);           if (id >= 0)
             {d7               (void) strcpy(command,ApplyModeMenu[id]);e+               key_symbol=ApplyModeKeys[id];r&               if (id < ApplyModeMenus)                 {]                   /*8                     Select a command from a pop-up menu.                   */P                   entry=XMenuWidget(display,windows,ApplyModeMenu[id],Menus[id],                     command); !                   if (entry >= 0)i                     { >                       (void) strcpy(command,Menus[id][entry]);1                       key_symbol=Keys[id][entry];r                     }u                 } 
             }eJ           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);!           if (key_symbol == XK_h)f
             {eL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);nN               XSetFunction(display,windows->image.highlight_context,GXinvert);               continue;a
             }a!           if (key_symbol == XK_q).
             {i               /*                 Exit._               */!               state|=EscapeState;f               state|=ExitState;(               continue; 
             }t*           if (key_symbol != XK_VoidSymbol)%             state|=UpdateRegionState;u           continue;.	         }g4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)g       {e         case ButtonPress:f	         {g6           if (event.xbutton.window == windows->pan.id)
             {x0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }a8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y;.K           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) &&iI               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))))
             {i3               roi_info.x=roi_info.x+roi_info.width;e4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             }dK           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) && <               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {i3               roi_info.x=roi_info.x+roi_info.width;i.               state|=UpdateConfigurationState;               break;
             }.;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) && ;               (x > (roi_info.x+roi_info.width-RoiDelta)) &&nI               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             {i4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             }>;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) &&o;               (x > (roi_info.x+roi_info.width-RoiDelta)) &&w<               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease:a           break;         case Expose:	         {w8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)r               {d1                 event.xexpose.x=highlight_info.x;n1                 event.xexpose.y=highlight_info.y;m9                 event.xexpose.width=highlight_info.width;i;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);o               } 7           if (event.xexpose.window == windows->info.id)%)             if (event.xexpose.count == 0)%0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         { 5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL); /           for (id=0; id < ApplyModeMenus; id++)            { E             for (entry=0; Menus[id][entry] != (char *) NULL; entry++) 0               if (key_symbol == Keys[id][entry])                 {%+                   state|=UpdateRegionState;%                   break;                 }t*             if (state & UpdateRegionState)               break;           }e(           if (state & UpdateRegionState)             break;           switch (key_symbol)o           {e             case XK_Shift_L:             case XK_Shift_R:               break;             case XK_Escape:n             case XK_F20:!               state|=EscapeState;              case XK_Return:e
             {                state|=ExitState;n               break;
             }w             case XK_F1:              case XK_Help:l
             {lL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);SN               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             };             default:
             {n               XBell(display,0);                break;
             }U           }s           break;	         }x         case KeyRelease:           break;         case MotionNotify:	         {i           /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));a           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         {%(           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         }.#     } while (!(state & ExitState)); !   } while (!(state & ExitState));=@   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);    return(True);o }d   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %sO %                                                                             %nO %                                                                             %tO %   X R o t a t e I m a g e                                                   %aO %                                                                             %fO %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %cG %  Function XRotateImage rotates the X image.  If the degrees parametereL %  if zero, the rotation angle is computed from the slope of a line drawn by %  the user. % - %  The format of the XRotateImage routine is:  % E %    status=XRotateImage(display,resource_info,windows,degrees,image)  % + %  A description of each parameter follows:> %g@ %    o status: Function XRotateImage return True if the image isJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.  %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %iD %    o degrees: Specifies the number of degrees to rotate the image. %fF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %L %B */O static unsigned int XRotateImage(Display *display,XResourceInfo *resource_info, 1   XWindows *windows,double degrees,Image **image); {  #define RotateModeColorOp  0  #define RotateModeDirectionOp  1 #define RotateModeCropOp  2  #define RotateModeSharpenOp  3 #define RotateModeHelpOp  4n #define RotateModeDismissOp  5 #define HorizontalRotateOp  0e #define VerticalRotateOp  1   
   static char      *RotateModeMenu[]=     {        "Pixel Color",       "Direction",
       "Crop",c       "Sharpen",
       "Help",)       "Dismiss",       (char *) NULLi     };     char     command[MaxTextLength],l     text[MaxTextLength];  
   ColorPacket      background;0     double     normalized_degrees;r     Imagen     *rotated_image;0     int      id,(     x,     y;     register int     i;     static unsigned int,     crop = False, #     direction = HorizontalRotateOp,)     pen_id = 0,      sharpen = True;g     unsigned int     height,r     rotations,
     width;     if (degrees == 0.0)(     {n       unsigned int         distance;m         unsigned longV         state;         XEvent         event;         XSegment         rotate_info;         /*         Map Command widget.g       */%       windows->command.name="Rotate";c       windows->command.data=4;L       (void) XCommandWidget(display,windows,RotateModeMenu,(XEvent *) NULL);.       XMapRaised(display,windows->command.id);E       XClientMessage(display,windows->image.id,windows->im_protocols,m/         windows->im_update_widget,CurrentTime);-       /*$         Wait for first button press.       */F       XSetFunction(display,windows->image.highlight_context,GXinvert);-       XSelectInput(display,windows->image.id,(B         windows->image.attributes.event_mask | PointerMotionMask);6       XQueryPosition(display,windows->image.id,&x,&y);       rotate_info.x1=x;I       rotate_info.y1=y;_       rotate_info.x2=x;(       rotate_info.y2=y;        state=DefaultState;e       do       {i1         XHighlightLine(display,windows->image.id,o9           windows->image.highlight_context,&rotate_info);e
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows); 1         XHighlightLine(display,windows->image.id,t9           windows->image.highlight_context,&rotate_info);t5         if (event.xany.window == windows->command.id)            {e             /*7               Select a command from the Command widget.t             */E             id=XCommandWidget(display,windows,RotateModeMenu,&event);              if (id < 0)                continue;eJ             XSetFunction(display,windows->image.highlight_context,GXcopy);             switch (id) 
             { %               case RotateModeColorOp:e               {o                 char,                   *ColorMenu[MaxNumberPens];                   int                    pen_number;r                   XColor                   color;                   /*-                   Initialize menu selections.)                 */5                 for (i=0; i < (MaxNumberPens-2); i++)r<                   ColorMenu[i]=resource_info->pen_colors[i];8                 ColorMenu[MaxNumberPens-2]="Browser...";9                 ColorMenu[MaxNumberPens-1]=(char *) NULL;i                 /*:                   Select a pen color from the pop-up menu.                 */J                 pen_number=XMenuWidget(display,windows,RotateModeMenu[id],%                   ColorMenu,command);t#                 if (pen_number < 0)e                   break;4                 if (pen_number == (MaxNumberPens-2))                   {%                     static char%9                       color_name[MaxTextLength] = "gray";                        /*7                       Select a pen color from a dialog.                      */E                     resource_info->pen_colors[pen_number]=color_name; M                     XColorBrowserWidget(display,windows,"Select",color_name); ,                     if (*color_name == '\0')                       break;                   }                  /*                    Set pen color.                 */M                 (void) XParseColor(display,windows->image.map_info->colormap, @                   resource_info->pen_colors[pen_number],&color);E                 XBestPixel(display,windows->image.map_info->colormap,tC                   (XColor *) NULL,(unsigned int) MaxColors,&color); H                 windows->image.pixel_info->pen_colors[pen_number]=color;"                 pen_id=pen_number;                 break;               }s)               case RotateModeDirectionOp:k               {                  static charp                    *Directions[]=                   {X!                     "horizontal",                      "vertical",m"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */I                 direction=XMenuWidget(display,windows,RotateModeMenu[id],r&                   Directions,command);                 break;               }r$               case RotateModeCropOp:               {:                 static charr                   *Options[]=                    {s                     "false",                     "true",a"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */D                 crop=XMenuWidget(display,windows,RotateModeMenu[id],#                   Options,command);o                 break;               };'               case RotateModeSharpenOp:                {                  static char                    *Options[]=                    {]                     "false",                     "true",1"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */G                 sharpen=XMenuWidget(display,windows,RotateModeMenu[id],s#                   Options,command);                  break;               } $               case RotateModeHelpOp:               {XD                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);                 break;               }n'               case RotateModeDismissOp:                {a                 /*#                   Prematurely exit.p                 */#                 state|=EscapeState;i!                 state|=ExitState;                  break;               }                default:                 break;
             }LL             XSetFunction(display,windows->image.highlight_context,GXinvert);             continue;t           }e         switch (event.type)o	         {e           case ButtonPress:o           { 8             if (event.xbutton.window == windows->pan.id)               {d2                 XPanImage(display,windows,&event);2                 XInfoWidget(display,windows,text);                 break;               } J             XSetFunction(display,windows->image.highlight_context,GXcopy);             /*               Exit loop.             */+             rotate_info.x1=event.xbutton.x;;+             rotate_info.y1=event.xbutton.y;i             state|=ExitState;              break;           }i           case ButtonRelease:              break;           case Expose:             break;           case KeyPress:           {c             char%               command[MaxTextLength];e               KeySym               key_symbol;e  7             if (event.xkey.window != windows->image.id)                break;             /**               Respond to a user key press.             */C             (void) XLookupString((XKeyEvent *) &event.xkey,command, C               sizeof(command),&key_symbol,(XComposeStatus *) NULL);a             switch (key_symbol) 
             {o               case XK_Escape:n               case XK_F20:               {N                 /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;i                 break;               }                case XK_F1:                case XK_Help:a               {aN                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }q               default:               { !                 XBell(display,0);                  break;               }X
             }e             break;           }X           case MotionNotify:           {a             /*4               Discard pending pointer motion events.             */F             while (XCheckMaskEvent(display,PointerMotionMask,&event));+             rotate_info.x1=event.xmotion.x;a+             rotate_info.y1=event.xmotion.y;            } 	         }x&         rotate_info.x2=rotate_info.x1;&         rotate_info.y2=rotate_info.y1;,         if (direction == HorizontalRotateOp)           rotate_info.x2+=32;n         else           rotate_info.y2-=32;l%       } while (!(state & ExitState));k-       XSelectInput(display,windows->image.id,t.         windows->image.attributes.event_mask);D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);        if (state & EscapeState)         return(True);l       /*F         Draw line as pointer moves until the mouse button is released.       */       distance=0; F       XSetFunction(display,windows->image.highlight_context,GXinvert);       state=DefaultState;(       do       {          if (distance > 9)-           {a             /*2               Display info and draw rotation line.             */&             if (!windows->info.mapped)3               XMapWindow(display,windows->info.id);r(             (void) sprintf(text," %.2f",F               direction == VerticalRotateOp ? degrees-90.0 : degrees);.             XInfoWidget(display,windows,text);5             XHighlightLine(display,windows->image.id,n=               windows->image.highlight_context,&rotate_info);            }m         else#           if (windows->info.mapped) K             XWithdrawWindow(display,windows->info.id,windows->info.screen);.
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows);          if (distance > 9)c3           XHighlightLine(display,windows->image.id,g;             windows->image.highlight_context,&rotate_info);o         switch (event.type)m	         {            case ButtonPress:m             break;           case ButtonRelease:_           {r             /*2               User has committed to rotation line.             */+             rotate_info.x2=event.xbutton.x;(+             rotate_info.y2=event.xbutton.y;m             state|=ExitState;n             break;           }            case Expose:             break;           case MotionNotify:           {a             /*3               Discard pending button motion events.              */E             while (XCheckMaskEvent(display,ButtonMotionMask,&event)); +             rotate_info.x2=event.xmotion.x; +             rotate_info.y2=event.xmotion.y;a           }            default:             break;	         } 
         /*$           Check boundary conditions.
         */         if (rotate_info.x2 < 0)w           rotate_info.x2=0;=         else4           if (rotate_info.x2 > windows->image.width)0             rotate_info.x2=windows->image.width;         if (rotate_info.y2 < 0)r           rotate_info.y2=0;o         else5           if (rotate_info.y2 > windows->image.height);1             rotate_info.y2=windows->image.height;m
         /*<           Compute rotation angle from the slope of the line.
         */         degrees=0.0;         distance=gP           ((rotate_info.x2-rotate_info.x1+1)*(rotate_info.x2-rotate_info.x1+1))+P           ((rotate_info.y2-rotate_info.y1+1)*(rotate_info.y2-rotate_info.y1+1));         if (distance > 9) C           degrees=RadiansToDegrees(-atan2((double) (rotate_info.y2-dG             rotate_info.y1),(double) (rotate_info.x2-rotate_info.x1)));-%       } while (!(state & ExitState));mD       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);d       if (distance <= 9)         return(True);      };$   if (direction == VerticalRotateOp)     degrees-=90.0;   if (degrees == 0.0)e     return(True);/   /*     Rotate image.s   */   normalized_degrees=degrees;o$   while (normalized_degrees < -45.0)     normalized_degrees+=360.0;;   for (rotations=0; normalized_degrees > 45.0; rotations++)a     normalized_degrees-=90.0;     if (normalized_degrees != 0.0)O     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);O   background.red=XDownScale(windows->image.pixel_info->pen_colors[pen_id].red);o   background.green= D     XDownScale(windows->image.pixel_info->pen_colors[pen_id].green);   background.blue=C     XDownScale(windows->image.pixel_info->pen_colors[pen_id].blue);    background.index=0;aE   rotated_image=RotateImage(*image,degrees,&background,crop,sharpen); )   XSetCursorState(display,windows,False);U&   if (rotated_image == (Image *) NULL)     return(False);   DestroyImage(*image);    *image=rotated_image; 4   if (windows->image.crop_geometry != (char *) NULL)     {        /*         Rotate crop geometry.s       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);(       switch (rotations % 4)       {e         default:         case 0:e           break;         case 1: 	         {            /*             Rotate 90 degrees.           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",C             height,width,(int) (*image)->columns-(int) height-y,x);,           break;	         }m         case 2: 	         {            /*             Rotate 180 degrees.!           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",7             width,height,(int) width-x,(int) height-y);            break;	         }[         case 3:"	         {            /*             Rotate 270 degrees.            */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",?             height,width,y,(int) (*image)->rows-(int) width-x);m           break;	         }=       }      }r   if (windows->image.orphan)     return(True);S    if (normalized_degrees != 0.0)     {n       /*         Update image colormap.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {(           /*:             Obtain dimensions of image from crop geometry.           */C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,r             &width,&height);4           windows->image.window_changes.width=width;6           windows->image.window_changes.height=height;	         }gD       XConfigureImageColormap(display,resource_info,windows,*image);     }l   else9     if (((rotations % 4) == 1) || ((rotations % 4) == 3))m       {lJ         windows->image.window_changes.width=windows->image.ximage->height;J         windows->image.window_changes.height=windows->image.ximage->width;       }i   /*     Update image configuration.t   */?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);c }y   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %/O %   X S a v e I m a g e                                                       % O %                                                                             %/O %                                                                             %tO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %a0 %  Function XSaveImage saves an image to a file. %o+ %  The format of the XSaveImage routine is:m %); %    status=XSaveImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:t %s> %    o status: Function XSaveImage return True if the image isJ %      written.  False is returned is there is a memory shortage or if the %      image fails to write. %>D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %s< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %( %n */M static unsigned int XSaveImage(Display *display,XResourceInfo *resource_info,d"   XWindows *windows,Image **image) {    char     filename[MaxTextLength];     ImageInfo      *image_info;     intu     status;=     register char;     *p;*     /*      Request file name from user.   */4   p=(*image)->filename+strlen((*image)->filename)-1;D   while ((p > (*image)->filename) && (*(p-1) != *BasenameSeparator))     p--;   (void) strcpy(filename,p);5   if (resource_info->write_filename != (char *) NULL)g:     (void) strcpy(filename,resource_info->write_filename);6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     return(True);o   if (IsAccessible(filename))      {        /*@         File exists-- seek user's permission before overwriting.       */B       status=XConfirmWidget(display,windows,"Overwrite",filename);       if (status == False)         return(True);-     }_'   image_info=resource_info->image_info; /   (void) strcpy(image_info->filename,filename);e*   SetImageInfo(resource_info->image_info);1   if ((strcmp(image_info->magick,"JPEG") == 0) ||c.       (strcmp(image_info->magick,"JPG") == 0))     { 
       char         quality[MaxTextLength];)         /*'         Request JPEG quality from user.b       */7       (void) sprintf(quality,"%u",image_info->quality);dH       status=XDialogWidget(display,windows,"Save","Enter JPEG quality:",         quality);        if (*quality == '\0')(         return(True);i(       image_info->quality=atoi(quality);D       image_info->interlace=status ? PlaneInterlace : NoneInterlace;     }_0   if ((strcmp(image_info->magick,"EPS") == 0) ||/       (strcmp(image_info->magick,"PS") == 0) ||i.       (strcmp(image_info->magick,"PS2") == 0))     {i
       char          geometry[MaxTextLength];         /*3         Request Postscript page geometry from user.n       */.       (void) sprintf(geometry,PSPageGeometry);,       if (image_info->page != (char *) NULL)1         (void) strcpy(geometry,image_info->page);iM       XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",w5         "Select Postscript Page Geometry:",geometry);w       if (*geometry != '\0')6         image_info->page=PostscriptGeometry(geometry);     }e   /*     Write image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);-   (void) strcpy((*image)->filename,filename);o'   status=WriteImage(image_info,*image);a)   XSetCursorState(display,windows,False); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image); A   XClientMessage(display,windows->image.id,windows->im_protocols,m.     windows->im_update_signature,CurrentTime);   return(status);e }t   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             % O %                                                                             %gO %                                                                             % O %   X S c r e e n E v e n t                                                   %yO %                                                                             % O %                                                                             %wO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XScreenEvent returns True if the certain events on the X serverw8 %  queue is associated with the image or Magnify window. %w. %  The format of the XScreenEvent function is: % ' %      XScreenEvent(display,event,data)a %)+ %  A description of each parameter follows:i %wL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %a< %    o event: Specifies a pointer to a X11 XEvent structure. %i9 %    o data: Specifies a pointer to a XWindows structure.  %  %i */B static int XScreenEvent(Display *display,XEvent *event,char *data) {    register int     x,     y;     register XWindows 
     *windows;      windows=(XWindows *) data;0   if (event->xany.window == windows->command.id)     return(True);    switch (event->type)   {_     case ButtonPress:      case ButtonRelease:/     { /       if ((event->xbutton.button == Button3) &&m,           (event->xbutton.state & Mod1Mask))	         {            /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         } 8       if (event->xbutton.window == windows->backdrop.id)D         XSetInputFocus(display,event->xbutton.window,RevertToParent,           event->xbutton.time); 5       if (event->xbutton.window == windows->image.id)g$         if (windows->magnify.mapped)           {              /*%               Update magnified image.L             */             x=event->xbutton.x;o             y=event->xbutton.y;              if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;x2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;m2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);            }        return(True);a     }w     case ClientMessage:r     {o       /*.         If client window delete message, exit.       */?       if (event->xclient.message_type != windows->wm_protocols)p         break;>       if (*event->xclient.data.l != windows->wm_delete_window)         break;7       if (event->xclient.window == windows->magnify.id) 	         {vO           XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);h           return(True);r	         }s       break;     },     case Expose:     { 5       if (event->xexpose.window == windows->image.id) 	         { 8           XRefreshWindow(display,&windows->image,event);           return(True);l	         }_3       if (event->xexpose.window == windows->pan.id)e&         if (event->xexpose.count == 0)           { /             XDrawPanRectangle(display,windows);e             return(True);,           }i       break;     }t     case KeyPress:     { 
       char         command[MaxTextLength];          KeySym         key_symbol;m         /*$         Respond to a user key press.       */N       (void) XLookupString((XKeyEvent *) &event->xkey,command,sizeof(command),-         &key_symbol,(XComposeStatus *) NULL);X4       if (event->xkey.window == windows->magnify.id)L         XMagnifyWindowCommand(display,windows,event->xkey.state,key_symbol);       return(True);t     }g     case MapNotify:m     {i4       if (event->xmap.window == windows->magnify.id)	         { -           XMakeMagnifyImage(display,windows);o'           windows->magnify.mapped=True;a           return(True);i	         },1       if (event->xmap.window == windows->info.id)o	         { $           windows->info.mapped=True;           return(True); 	         }m       break;     }      case MotionNotify:     { 5       if (event->xmotion.window == windows->image.id)c$         if (windows->magnify.mapped)           {;             /*%               Update magnified image.o             */             x=event->xmotion.x;a             y=event->xmotion.y;              if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;e2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;,2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);o           }r       return(True);      }4     case UnmapNotify:r     {e6       if (event->xunmap.window == windows->magnify.id)	         {i(           windows->magnify.mapped=False;           return(True);*	         }u3       if (event->xunmap.window == windows->info.id)a	         { %           windows->info.mapped=False;e           return(True);e	         }v       break;     }d     case KeyRelease:     case SelectionNotify:a       return(True);X     default:       break;   }r   return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             % O %                                                                             % O %                                                                             %tO %   X S e t C r o p G e o m e t r y                                           % O %                                                                             %nO %                                                                             % O %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %fH %  Function XSetCropGeometry accepts a cropping geometry relative to theH %  Image window and translates it to a cropping geometry relative to the	 %  image.u %_1 %  The format of the XSetCropGeometry routine is:t %(6 %    XSetCropGeometry(display,windows,crop_info,image) % + %  A description of each parameter follows:( %pD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %*< %    o windows: Specifies a pointer to a XWindows structure. %tL %    o crop_info:  A pointer to a RectangleInfo that defines a region of the %      Image window to crop. %r7 %    o image: Specifies a pointer to a Image structure.l %w %o */@ static void XSetCropGeometry(Display *display,XWindows *windows,(   RectangleInfo *crop_info,Image *image) {n   char     text[MaxTextLength];     int      x,     y;     unsigned int     height,u
     width;     unsigned long;     scale_factor;s     if (windows->info.mapped)      {)       /*+         Display info on cropping rectangle.(       */L       (void) sprintf(text," %ux%u%+d%+d",crop_info->width,crop_info->height,#         crop_info->x,crop_info->y);u(       XInfoWidget(display,windows,text);     }u   /*@     Cropping geometry is relative to any previous crop geometry.   */   x=0;   y=0;   width=image->columns;p   height=image->rows;w4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    else     {        /*&         Allocate crop geometry string.       */O       windows->image.crop_geometry=(char *) malloc(MaxTextLength*sizeof(char));l8       if (windows->image.crop_geometry == (char *) NULL)<         Error("Unable to crop X image",windows->image.name);     }n   /*@     Define the crop geometry string from the cropping rectangle.   */;   scale_factor=UpShift(width)/windows->image.ximage->width;    if (crop_info->x > 0)s,     x+=DownShift(crop_info->x*scale_factor);1   width=DownShift(crop_info->width*scale_factor);o   if (width == 0)v     width=1;=   scale_factor=UpShift(height)/windows->image.ximage->height;m   if (crop_info->y > 0)t,     y+=DownShift(crop_info->y*scale_factor);3   height=DownShift(crop_info->height*scale_factor);g   if (height == 0)
     height=1;dN   (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x,y); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             % O %                                                                             % O %   X T i l e I m a g e                                                       %sO %                                                                             %aO %                                                                             %wO %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %yE %  Function XTileImage loads or deletes a selected tile from a visual:G %  image directory.  The load or delete command is choosen from a menu.  %t+ %  The format of the XTileImage routine is:e %eF %    tiled_image=XTileImage(display,resource_info,windows,image,event) %a+ %  A description of each parameter follows:  % @ %    o tiled_image:  XTileImage reads or deletes the tiled imageD %      and returns it.  A null image is returned if an error occurs. %eE %    o display: Specifies a connection to an X server;  returned fromn %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.c %r< %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.s %cH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.a %  %  */G static Image *XTileImage(Display *display,XResourceInfo *resource_info,e/   XWindows *windows,Image *image,XEvent *event)_ {o #define LoadVerbOp  0  #define NextVerbOp  1a #define FormerVerbOp  2  #define DeleteVerbOp  3t #define UpdateVerbOp  4      char     command[MaxTextLength],(     filename[MaxTextLength];     Images     *tiled_image;n     int      status,-	     tile, 	     verb,f     x,     y;     register chara     *p,)     *q;      register int     i;  
   static char      *VerbMenu[]=     {p
       "Load",r
       "Next",n       "Former",a       "Delete",e       "Update",a       (char *) NULL,     };     unsigned int     height,o
     width;     unsigned long      scale_factor;      /*:     Tile image is relative to montage image configuration.   */   x=0;   y=0;   width=image->columns;i   height=image->rows;e4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;i%   event->xbutton.x+=windows->image.x;n>   event->xbutton.x=DownShift(event->xbutton.x*scale_factor)+x;=   scale_factor=UpShift(height)/windows->image.ximage->height;K%   event->xbutton.y+=windows->image.y;i>   event->xbutton.y=DownShift(event->xbutton.y*scale_factor)+y;   /*K     Determine size and location of each tile in the visual image directory.s   */   x=0;   y=0;   width=image->columns;    height=image->rows;n=   (void) XParseGeometry(image->montage,&x,&y,&width,&height);i@   tile=((event->xbutton.y-y)/height)*((image->columns-x)/width)+     (event->xbutton.x-x)/width;p   if (tile < 0),     {,       /*)         Button press is outside any tile.c       */       XBell(display,0);a       return((Image *) NULL);      }    /*0     Determine file name from the tile directory.   */   p=image->directory;i*   for (i=tile; (i != 0) && (*p != '\0'); )   {w     if (*p == '\n')1
       i--;     p++;   }v   if (*p == '\0')      {f       /*)         Button press is outside any tile.        */       XBell(display,0);a       return((Image *) NULL);e     })   /**     Select a command from the pop-up menu.   */A   verb=XMenuWidget(display,windows,"Tile Verb",VerbMenu,command);y   if (verb < 0)n     return((Image *) NULL);    q=p;&   while ((*q != '\n') && (*q != '\0'))     q++;!   (void) strncpy(filename,p,q-p);    filename[q-p]='\0';    /**     Perform command for the selected tile.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   tiled_image=(Image *) NULL;l   switch (verb)    {r     case LoadVerbOp:     {        /*         Load tile image.       */,       XCheckRefreshWindows(display,windows);>       (void) strcpy(resource_info->image_info->magick,"MIFF");B       (void) strcpy(resource_info->image_info->filename,filename);7       tiled_image=ReadImage(resource_info->image_info); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);e       break;     }a     case NextVerbOp:     {r       /*         Display next image.e       */E       XClientMessage(display,windows->image.id,windows->im_protocols,r,         windows->im_next_image,CurrentTime);       break;     }m     case FormerVerbOp:     {r       /*         Display former image.k       */E       XClientMessage(display,windows->image.id,windows->im_protocols,e.         windows->im_former_image,CurrentTime);       break;     }p     case DeleteVerbOp:     {(       /*         Delete tile image.       */"       if (!IsAccessible(filename))	         {dO           XNoticeWidget(display,windows,"Image file does not exist:",filename);            break;	         }aK       status=XConfirmWidget(display,windows,"Really delete tile",filename);        if (status == False)         break;       status=remove(filename);       if (status != False)	         { G           XNoticeWidget(display,windows,"Unable to delete image file:",s             filename);           break;	         }i     }p     case UpdateVerbOp:     {n	       intC         x_offset,o         y_offset;i         register int
         j;         register RunlengthPacket         *r;          /*$         Ensure all the images exist.       */"       if (!UncompressImage(image))         return((Image *) NULL); 
       tile=0;n/       for (p=image->directory; *p != '\0'; p++)s       {o         q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;'         (void) strncpy(filename,p,q-p);r         filename[q-p]='\0';e         p=q;#         if (IsAccessible(filename))(           {w             tile++;k             continue;w           } 
         /*/           Overwrite tile with background color.I
         */=         x_offset=width*(tile % ((image->columns-x)/width))+x;a<         y_offset=height*(tile/((image->columns-x)/width))+y;"         for (i=0; i < height; i++)	         {eA           r=image->pixels+((y_offset+i)*image->columns+x_offset);r#           for (j=0; j < width; j++) "             *r++=(*image->pixels);	         }t         tile++;        }M9       windows->image.window_changes.width=image->columns;r7       windows->image.window_changes.height=image->rows;lC       XConfigureImageColormap(display,resource_info,windows,image);"B       (void) XConfigureImage(display,resource_info,windows,image);       break;     }      default:       break;   }i)   XSetCursorState(display,windows,False);n   return(tiled_image); }  r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%3O %                                                                             %-O %                                                                             %fO %                                                                             %mO %   X T r a n s l a t e I m a g e                                             % O %                                                                             %fO %                                                                             %EO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %tG %  Function XTranslateImage translates the image within an Image window M %  by one pixel as specified by the key symbol.  If the image has a `montage'oM %  string the translation is respect to the width and height contained within  %  the string. %a0 %  The format of the XTranslateImage routine is: %r6 %    XTranslateImage(display,windows,image,key_symbol) %o+ %  A description of each parameter follows:m %)D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %kF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.o %mM %    o key_symbol: Specifies a KeySym which indicates which side of the image  %      to trim.e %p %) */? static void XTranslateImage(Display *display,XWindows *windows,,'   Image *image,const KeySym key_symbol)I {e   char     text[MaxTextLength];     int      x,     y;     unsigned int
     x_offset, 
     y_offset;      /*)     User specified a pan position offset.    */    x_offset=windows->image.width;!   y_offset=windows->image.height;d&   if (image->montage != (char *) NULL)D     (void) XParseGeometry(image->montage,&x,&y,&x_offset,&y_offset);   switch (key_symbol)    {      case XK_Home:l     case XK_KP_Home:     { 1       windows->image.x=windows->image.width >> 1; 2       windows->image.y=windows->image.height >> 1;       break;     }      case XK_Left:      case XK_KP_Left:     {n!       windows->image.x-=x_offset;        break;     }p     case XK_Next:)     case XK_Up:w     case XK_KP_Up:     {r!       windows->image.y-=y_offset;(       break;     },     case XK_Right:     case XK_KP_Right:a     {l!       windows->image.x+=x_offset;        break;     }      case XK_Prior:     case XK_Down:c     case XK_KP_Down:     {L!       windows->image.y+=y_offset;        break;     }a     default:
       return;)   }l   /*     Check boundary conditions.   */   if (windows->image.x < 0)e     windows->image.x=0;=   elseO     if ((windows->image.x+windows->image.width) > windows->image.ximage->width)/I       windows->image.x=windows->image.ximage->width-windows->image.width;d   if (windows->image.y < 0)1     windows->image.y=0;2   else2     if ((windows->image.y+windows->image.height) >'          windows->image.ximage->height)aK       windows->image.y=windows->image.ximage->height-windows->image.height;C   /*     Refresh Image window.o   */;   (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,s=     windows->image.height,windows->image.x,windows->image.y);_$   XInfoWidget(display,windows,text);(   XCheckRefreshWindows(display,windows);%   XDrawPanRectangle(display,windows);f:   XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);- }. : /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %;O %                                                                             % O %                                                                             % O %   X T r i m I m a g e                                                       % O %                                                                             %;O %                                                                             %aO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XTrimImage trims the edges from the Image window.r %e+ %  The format of the XTrimImage routine is:  %f; %    status=XTrimImage(display,resource_info,windows,image)e %a+ %  A description of each parameter follows:i %a? %    o status: Function XTrimImage returns True if the image is J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.i %X< %    o windows: Specifies a pointer to a XWindows structure.< %    o windows: Specifies a pointer to a XWindows structure. % 7 %    o image: Specifies a pointer to a Image structure.  %r %r */M static unsigned int XTrimImage(Display *display,XResourceInfo *resource_info,s!   XWindows *windows,Image *image)m {    RectangleInfo      trim_info;     register int     x,     y;     unsigned longi     background,s
     pixel;     /*     Trim edges from image.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   /*     Crop the left edge.I   */2   background=XGetPixel(windows->image.ximage,0,0);/   trim_info.width=windows->image.ximage->width;i2   for (x=0; x < windows->image.ximage->width; x++)   {g5     for (y=0; y < windows->image.ximage->height; y++)      {X1       pixel=XGetPixel(windows->image.ximage,x,y);)       if (pixel != background)         break;     } *     if (y < windows->image.ximage->height)       break;   }0   trim_info.x=x;2   if (trim_info.x == windows->image.ximage->width)     {X-       XSetCursorState(display,windows,False);t       return(False);     }(   /*     Crop the right edge.   */O   background=XGetPixel(windows->image.ximage,windows->image.ximage->width-1,0);d4   for (x=windows->image.ximage->width-1; x > 0; x--)   { 5     for (y=0; y < windows->image.ximage->height; y++)      {f1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     }(*     if (y < windows->image.ximage->height)       break;   }l"   trim_info.width=x-trim_info.x+1;   /*     Crop the top edge.   */2   background=XGetPixel(windows->image.ximage,0,0);1   trim_info.height=windows->image.ximage->height;c3   for (y=0; y < windows->image.ximage->height; y++)    {*4     for (x=0; x < windows->image.ximage->width; x++)     { 1       pixel=XGetPixel(windows->image.ximage,x,y);m       if (pixel != background)         break;     }t)     if (x < windows->image.ximage->width)*       break;   }n   trim_info.y=y;   /*     Crop the bottom edge.i   */P   background=XGetPixel(windows->image.ximage,0,windows->image.ximage->height-1);5   for (y=windows->image.ximage->height-1; y > 0; y--)n   {m4     for (x=0; x < windows->image.ximage->width; x++)     {w1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     }e)     if (x < windows->image.ximage->width)g       break;   }s#   trim_info.height=y-trim_info.y+1;r2   if ((trim_info.width != windows->image.width) ||2       (trim_info.height != windows->image.height))     {r       /*F         Reconfigure Image window as defined by the trimming rectangle.       */9       XSetCropGeometry(display,windows,&trim_info,image);t:       windows->image.window_changes.width=trim_info.width;<       windows->image.window_changes.height=trim_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     }n)   XSetCursorState(display,windows,False);e   return(True);  }a   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %UO %                                                                             %;O %   X V i s u a l D i r e c t o r y I m a g e                                 % O %                                                                             % O %                                                                             %"O %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %(C %  Function XVisualDirectoryImage creates a Visual Image Directory.  % 6 %  The format of the XVisualDirectoryImage routine is: %rF %    loaded_image=XVisualDirectoryImage(display,resource_info,windows) %i+ %  A description of each parameter follows:o %dJ %    o loaded_image: Function XVisualDirectoryImage returns a visual imageK %      directory if it can be created successfully.  Otherwise a null imagen %      is returned., %gD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %=K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.; % < %    o windows: Specifies a pointer to a XWindows structure. %; %  */5 static Image *XVisualDirectoryImage(Display *display,m1   XResourceInfo *resource_info,XWindows *windows)- { . #define LoadImageText  "  Loading images...  " #define XClientName  "montage"     char     **filelist,a     *resource_value,     window_id[MaxTextLength];p     Image,     *image,r
     **images,c     *scaled_image;     ImageInfo      local_info;i     intl     number_files;m     MonitorHandler     handler;     register int     i,     j;  
   static char #     filename[MaxTextLength] = "\0",i#     filenames[MaxTextLength] = "*";      unsigned int
     backdrop,(     height,r     status,w
     width;     XMontageInfo
     vid_info;S     XResourceInfoa     background_resources,e     vid_resources;  
   XrmDatabase      resource_database;     /*      Request file name from user.   */<   XFileBrowserWidget(display,windows,"Directory",filenames);   if (*filenames == '\0')f     return((Image *) NULL);a   /*     Expand the filenames.-   */,   filelist=(char **) malloc(sizeof(char *));!   if (filelist == (char **) NULL)g     {a7       Warning("Memory allocation error",(char *) NULL);e       return((Image *) NULL);v     }o   number_files=1;y   filelist[0]=filenames;+   ExpandFilenames(&number_files,&filelist);    if (number_files == 0)     {t5       Warning("No image files were found",filenames);y       return((Image *) NULL);i     }    /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));a    if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);e&       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);E       free((char *) filelist);       return((Image *) NULL);s     }s   /*/     Get any Visual Image Directory X resources.,   */5   resource_database=resource_info->resource_database;a!   vid_resources=(*resource_info); H   vid_resources.background_color=XGetResourceInstance(resource_database,4     XClientName,"background",DefaultTileBackground);O   resource_value=XGetResourceClass(resource_database,XClientName,"borderWidth",t     DefaultTileBorderwidth);2   vid_resources.border_width=atoi(resource_value);5   vid_resources.font=resource_info->image_info->font; H   vid_resources.foreground_color=XGetResourceInstance(resource_database,4     XClientName,"foreground",DefaultTileForeground);F   vid_resources.image_geometry=XGetResourceInstance(resource_database,5     XClientName,"imageGeometry",DefaultTileGeometry);>C   vid_resources.matte_color=XGetResourceInstance(resource_database, /     XClientName,"mattecolor",DefaultTileMatte);)   /*#     Set image background resources.    */(   background_resources=(*resource_info);+   background_resources.window_id=window_id; K   (void) sprintf(background_resources.window_id,"0x%lx",windows->image.id); %   background_resources.backdrop=True;i   /*/     Read each image and convert them to a tile.v   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   backdrop=(windows->image.visual_info->class == TrueColor) ||6    (windows->image.visual_info->class == DirectColor);   j=0;    handler=(MonitorHandler) NULL;"   for (i=0; i < number_files; i++)   {w5     handler=SetMonitorHandler((MonitorHandler) NULL); ,     local_info=(*resource_info->image_info);$     local_info.filename=filelist[i];     *local_info.magick='\0';)     if (local_info.size == (char *) NULL) 3       local_info.size=vid_resources.image_geometry;;!     image=ReadImage(&local_info);m!     if (filelist[i] != filenames)m!       free((char *) filelist[i]);t      if (image == (Image *) NULL)       continue;      image->scene=j;      image->matte=False;      LabelImage(image,"%f");      /*       Scale image.     */     width=image->columns;o     height=image->rows; D     ParseImageGeometry(vid_resources.image_geometry,&width,&height);0     scaled_image=ScaleImage(image,width,height);     DestroyImage(image);'     if (scaled_image == (Image *) NULL)        continue;a     image=scaled_image;t     if (backdrop)(       {eL         (void) XDisplayBackgroundImage(display,&background_resources,image);.         XSetCursorState(display,windows,True);       }m     images[j]=image;     j++;&     (void) SetMonitorHandler(handler);2     ProgressMonitor(LoadImageText,i,number_files);   } $   (void) SetMonitorHandler(handler);   free((char *) filelist);
   if (j == 0)w     {e-       XSetCursorState(display,windows,False); 1       Warning("No images were loaded",filenames);        free((char *) images);       return((Image *) NULL);e     }d   /*>     Request the Visual Image Directory filename from the user.   */A   XClientMessage(display,windows->image.id,windows->im_protocols,i(     windows->im_next_image,CurrentTime);6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     {d       free((char *) images);       return((Image *) NULL);i     }e   /*&     Create the Visual Image Directory.   */:   XRefreshWindow(display,&windows->image,(XEvent *) NULL);   XGetMontageInfo(&vid_info);    vid_info.number_tiles=j;@   image=XMontageImage(images,&vid_resources,&vid_info,filename);)   XSetCursorState(display,windows,False);X   free((char *) images);   if (image == (Image *) NULL)     return(image);   /*$     Save the Visual Image Directory.   */*   local_info=(*resource_info->image_info);   local_info.filename=filename;k   local_info.adjoin=True;o   SetImageInfo(&local_info);,   if (strcmp(local_info.magick,"MIFF") != 0)"     XNoticeWidget(display,windows,N       "Visual Image Directory is non-conforming (not MIFF format):",filename);'   status=WriteImage(&local_info,image);o   if (status == False)L     XNoticeWidget(display,windows,"Unable to write Visual Image Directory:",       filename);   return(image); })   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %lO %                                                                             % O %                                                                             % O %   X W a r n i n g                                                           %,O %                                                                             % O %                                                                             %hO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XWarning displays a warning message in a Notice widget.  % ) %  The format of the XWarning routine is:A %R" %      XWarning(message,qualifier) %i+ %  A description of each parameter follows:o %wG %    o message: Specifies the message to display before terminating the  %      program.  %u9 %    o qualifier: Specifies any qualifier to the message.  %  %v */? static void XWarning(const char *message,const char *qualifier)o {e   char     text[MaxTextLength];     if (message == (char *) NULL)M     return;    (void) strcpy(text,message);   (void) strcat(text,":");0   XNoticeWidget(display,windows,text,qualifier); }e h /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %cO %                                                                             % O %                                                                             % O %    M a i n                                                                  %WO %                                                                             %uO %                                                                             %;O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %o %  */ int main(int argc,char **argv) {e+ #define NotInitialized  (unsigned int) (~0)      char     density[MaxTextLength],      *option,     *resource_value,     *server_name;>     floatt     x_density,     y_density;     Image>     *image,o     *next_image;     ImageInfod     image_info;e     int      x,     y;     register int     i,     j;     unsigned int     first_scene,     height,t     *image_marker,     image_number,      last_scene,o
     scene,
     width;     unsigned long 
     state;     XResourceInfo      resource_info;  
   XrmDatabase>     resource_database;     /*     Set defaults.d   */   ReadCommandlLine(argc,&argv);     client_name=ClientName(*argv);   display=(Display *) NULL;    first_scene=0;F   image_marker=(unsigned int *) malloc((argc+1)*sizeof(unsigned int));,   if (image_marker == (unsigned int *) NULL)@     Error("Unable to display image","Memory allocation failed");   for (i=0; i <= argc; i++)      image_marker[i]=argc;e   image_number=0;e   GetImageInfo(&image_info);   last_scene=0;a'   resource_database=(XrmDatabase) NULL;w   server_name=(char *) NULL;   state=DefaultState;    /*8     Check for server name specified on the command line.   */   ExpandFilenames(&argc,&argv);    for (i=1; i < argc; i++)   {i     /*)       Check command line for server name.n     */     option=argv[i]; N     if (((int) strlen(option) == 1) || ((*option != '-') && (*option != '+')))       continue;f+     if (strncmp("display",option+1,5) == 0)r       { 
         /*%           User specified server name. 
         */         i++;         if (i == argc)A           Error("Missing server name on -display",(char *) NULL);e         server_name=argv[i];         break;       } (     if (strncmp("help",option+1,2) == 0)       Usage(True);   }    /*     Open X server connection.o   */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)E     Error("Unable to connect to X server",XDisplayName(server_name));    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.r   */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); A   (void) sscanf(PSDensityGeometry,"%fx%f",&x_density,&y_density);X=   (void) XParseGeometry(PSPageGeometry,&x,&y,&width,&height);q7   (void) sprintf(density,"%f",Min(x_density,y_density)* J     (XDisplayHeight(display,XDefaultScreen(display))-40)/(double) height);   image_info.density=uG     XGetResourceClass(resource_database,client_name,"density",density);    resource_value=(H     XGetResourceClass(resource_database,client_name,"interlace","none");*   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace; 0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace;d1   if (Latin1Compare("plane",resource_value) == 0)w(     image_info.interlace=PlaneInterlace;1   if (image_info.interlace == UndefinedInterlace)t:     Warning("Unrecognized interlace type",resource_value);B   image_info.page=XGetResourceClass(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value= D     XGetResourceClass(resource_database,client_name,"quality","75");*   image_info.quality=atoi(resource_value);   resource_value=tG     XGetResourceClass(resource_database,client_name,"verbose","False");(,   image_info.verbose=IsTrue(resource_value);   /*     Parse command line.p   */7   for (i=1; ((i <= argc) && !(state & ExitState)); i++)%   {%     if (i < argc)%       option=argv[i];%     else       if (image_number != 0)         break;
       else!         if (isatty(STDIN_FILENO))            option="logo:";          else           option="-"; M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))        switch (*(option+1))       {          case 'b': 	         { 2           if (strncmp("backdrop",option+1,5) == 0)
             { 6               resource_info.backdrop=(*option == '-');               break;
             } 8           if ((strncmp("background",option+1,5) == 0) ||.               (strncmp("bg",option+1,2) == 0))
             {%;               resource_info.background_color=(char *) NULL;%!               if (*option == '-')a                 {                    i++;                    if (i == argc)H                     Error("Missing color on -background",(char *) NULL);9                   resource_info.background_color=argv[i];s                 }d               break;
             }f-           if (strcmp("border",option+1) == 0) 
             {e!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -border",(char *) NULL);h                 }t               break;
             }l5           if (strncmp("bordercolor",option+1,7) == 0)e
             {h7               resource_info.border_color=(char *) NULL; !               if (*option == '-')i                 {e                   i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);v5                   resource_info.border_color=argv[i];g                 }g               break;
             }>5           if (strncmp("borderwidth",option+1,7) == 0)o
             { +               resource_info.border_width=0;f!               if (*option == '-')                  {i                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing width on -borderwidth",(char *) NULL);o;                   resource_info.border_width=atoi(argv[i]);.                 }t               break;
             }..           Error("Unrecognized option",option);           break;	         }          case 'c':.	         { 2           if (strncmp("colormap",option+1,6) == 0)
             {/5               resource_info.colormap=PrivateColormap;f!               if (*option == '-')I                 {i                   i++;                    if (i == argc)E                     Error("Missing type on -colormap",(char *) NULL); !                   option=argv[i]; ;                   resource_info.colormap=UndefinedColormap;e;                   if (Latin1Compare("private",option) == 0)i;                     resource_info.colormap=PrivateColormap; :                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)G                     Error("Invalid colormap type on -colormap",option);B                 }n               break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             {l,               resource_info.number_colors=0;!               if (*option == '-')                  {=                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL);h<                   resource_info.number_colors=atoi(argv[i]);                 }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             {%5               resource_info.colorspace=RGBColorspace;%!               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL); !                   option=argv[i]; ?                   resource_info.colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0)                     { >                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;                      } 8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0)b;                     resource_info.colorspace=RGBColorspace;f?                   if (Latin1Compare("transparent",option) == 0)WC                     resource_info.colorspace=TransparentColorspace;o7                   if (Latin1Compare("xyz",option) == 0) ;                     resource_info.colorspace=XYZColorspace;a9                   if (Latin1Compare("ycbcr",option) == 0)t=                     resource_info.colorspace=YCbCrColorspace;S7                   if (Latin1Compare("yiq",option) == 0)e;                     resource_info.colorspace=YIQColorspace;m9                   if (Latin1Compare("ypbpr",option) == 0)i=                     resource_info.colorspace=YPbPrColorspace;n7                   if (Latin1Compare("yuv",option) == 0)t;                     resource_info.colorspace=YUVColorspace;uF                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);a                 }e               break;
             } 1           if (strncmp("comment",option+1,4) == 0)>
             {d!               if (*option == '-')t                 {;                   i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);;                 }                break;
             }U2           if (strncmp("compress",option+1,3) == 0)
             {g3               image_info.compression=NoCompression;i!               if (*option == '-')(                 {-                   i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL);X!                   option=argv[i];wD                   if (Latin1Compare("runlengthencoded",option) == 0)G                     image_info.compression=RunlengthEncodedCompression;e                   else9                     if (Latin1Compare("zip",option) == 0)_<                       image_info.compression=ZipCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }P               break;
             }_2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             {X!               if (*option == '-')                  {a                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -crop",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd': 	         { /           if (strncmp("debug",option+1,3) == 0) 
             { 3               resource_info.debug=(*option == '-');                break;
             } /           if (strncmp("delay",option+1,3) == 0) 
             { $               resource_info.delay=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL);e4                   resource_info.delay=atoi(argv[i]);                 }                break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             {I/               image_info.density=(char *) NULL; !               if (*option == '-')l                 {d                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];e                 }u               break;
             } 3           if (strncmp("despeckle",option+1,3) == 0)R             break;1           if (strncmp("display",option+1,5) == 0)o
             {r(               server_name=(char *) NULL;!               if (*option == '-')d                 {e                   i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL);w&                   server_name=argv[i];                 }.4               resource_info.server_name=server_name;               break;
             }w1           if (strncmp("dispose",option+1,5) == 0),
             {w#               image_info.dispose=0;)!               if (*option == '-')c                 {N                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing method on -dispose",(char *) NULL);3                   image_info.dispose=atoi(argv[i]);                  }%               break;
             }%0           if (strncmp("dither",option+1,3) == 0)
             { 4               resource_info.dither=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'e': 	         { .           if (strncmp("edge",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -edge",(char *) NULL);                  }                break;
             }%1           if (strncmp("enhance",option+1,2) == 0)%             break;2           if (strncmp("equalize",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }o         case 'f':l	         {t.           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             { /               resource_info.font=(char *) NULL;n!               if (*option == '-')o                 {l                   i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);-                   resource_info.font=argv[i];r                 }o               break;
             }i8           if ((strncmp("foreground",option+1,3) == 0) ||.               (strncmp("fg",option+1,2) == 0))            {:              resource_info.foreground_color=(char *) NULL;               if (*option == '-')                {                  i++;                   if (i == argc)eL                    Error("Missing foreground on -foreground",(char *) NULL);8                  resource_info.foreground_color=argv[i];                }               break;            }/           if (strncmp("frame",option+1,2) == 0) 
             { !               if (*option == '-')u                 {e                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     Error("Missing geometry on -frame",(char *) NULL);                 }S               break;
             }e.           Error("Unrecognized option",option);           break;	         }l         case 'g':n	         { /           if (strncmp("gamma",option+1,2) == 0)g
             { !               if (*option == '-');                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);                  }                break;
             }n2           if (strncmp("geometry",option+1,2) == 0)
             { 9               resource_info.image_geometry=(char *) NULL; !               if (*option == '-'))                 {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))I                     Error("Missing geometry on -geometry",(char *) NULL);y7                   resource_info.image_geometry=argv[i];o                 }(               break;
             } .           Error("Unrecognized option",option);           break;	         }a         case 'h': 	         {f.           if (strncmp("help",option+1,2) == 0)             Usage(True);.           Error("Unrecognized option",option);           break;	         }o         case 'i': 	         {+6           if (strncmp("iconGeometry",option+1,5) == 0)
             {l8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')+                 {a                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))M                     Error("Missing geometry on -iconGeometry",(char *) NULL);n6                   resource_info.icon_geometry=argv[i];                 }w               break;
             }n0           if (strncmp("iconic",option+1,5) == 0)
             {t4               resource_info.iconic=(*option == '-');               break;
             }D3           if (strncmp("immutable",option+1,5) == 0) 
             { 7               resource_info.immutable=(*option == '-');U               break;
             }s3           if (strncmp("interlace",option+1,3) == 0)n
             {]1               image_info.interlace=NoneInterlace;r!               if (*option == '-')                  {t                   i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("plane",option) == 0)n8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }r               break;
             }d.           Error("Unrecognized option",option);           break;	         }i         case 'l':o	         {f/           if (strncmp("label",option+1,2) == 0)*
             {n!               if (*option == '-')/                 {d                   i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }e               break;
             }d.           Error("Unrecognized option",option);           break;	         }r         case 'm': 	         {r1           if (strncmp("magnify",option+1,3) == 0)i
             { &               resource_info.magnify=2;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing level on -magnify",(char *) NULL);f6                   resource_info.magnify=atoi(argv[i]);                 }d               break;
             }f-           if (strncmp("map",option+1,3) == 0)r
             {d3               resource_info.map_type=(char *) NULL; !               if (*option == '-')                  {e                   i++;                    if (i == argc)D                     Error("Missing map type on -map",(char *) NULL);1                   resource_info.map_type=argv[i];                  }                break;
             }c,           if (strcmp("matte",option+1) == 0)             break;4           if (strncmp("mattecolor",option+1,6) == 0)
             {r6               resource_info.matte_color=(char *) NULL;!               if (*option == '-')                  {0                   i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);4                   resource_info.matte_color=argv[i];                 }                break;
             } 2           if (strncmp("modulate",option+1,3) == 0)
             { !               if (*option == '-')                  {a                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing value on -modulate",(char *) NULL);                 }                break;
             }l4           if (strncmp("monochrome",option+1,3) == 0)
             {[8               resource_info.monochrome=(*option == '-');+               if (resource_info.monochrome)                  { 0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8; :                   resource_info.colorspace=GRAYColorspace;                 }e               break;
             } .           Error("Unrecognized option",option);           break;	         };         case 'n':;	         { .           if (strncmp("name",option+1,2) == 0)
             { /               resource_info.name=(char *) NULL;e!               if (*option == '-')i                 {s                   i++;                    if (i == argc)A                     Error("Missing name on -name",(char *) NULL);t-                   resource_info.name=argv[i];i                 }e               break;
             } 0           if (strncmp("negate",option+1,2) == 0)             break;/           if (strncmp("noise",option+1,3) == 0)T             break;3           if (strncmp("normalize",option+1,3) == 0)i             break;.           Error("Unrecognized option",option);           break;	         }d         case 'o': 	         { 0           if (strncmp("opaque",option+1,2) == 0)
             { !               if (*option == '-')                  {a                   i++;                    if (i == argc)D                     Error("Missing color on -opaque",(char *) NULL);                 };               break;
             }w.           Error("Unrecognized option",option);           break;	         }v         case 'p':=	         {p.           if (strncmp("page",option+1,3) == 0)
             {e,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }t               break;
             } .           Error("Unrecognized option",option);           break;	         }c         case 'q':.	         {/1           if (strncmp("quality",option+1,2) == 0)o
             {C;               image_info.quality=atoi(DefaultImageQuality); !               if (*option == '-')l                 {n                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing quality on -quality",(char *) NULL);f3                   image_info.quality=atoi(argv[i]);                  }e               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'r':k	         {=/           if (strncmp("raise",option+1,2) == 0)*
             {p               i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))E                 Error("Missing bevel width on -raise",(char *) NULL);S               break;
             }_.           if (strncmp("roll",option+1,3) == 0)
             {e!               if (*option == '-')                  {r                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -roll",(char *) NULL);                  }                break;
             },0           if (strncmp("rotate",option+1,3) == 0)
             {t!               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }i               break;
             } .           Error("Unrecognized option",option);           break;	         };         case 's':m	         { 0           if (strncmp("sample",option+1,2) == 0)
             {o!               if (*option == '-')a                 {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -sample",(char *) NULL);w                 }                break;
             },/           if (strncmp("scene",option+1,3) == 0) 
             {l               first_scene=0;               last_scene=0;)!               if (*option == '-')i                 {.                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene; J                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }                break;
             }.1           if (strncmp("segment",option+1,3) == 0)(
             {x!               if (*option == '-')                  {l                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))I                     Error("Missing threshold on -segment",(char *) NULL);c                 }                break;
             }a1           if (strncmp("sharpen",option+1,5) == 0)t
             {a!               if (*option == '-')x                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing factor on -sharpen",(char *) NULL);                 }f               break;
             })/           if (strncmp("shear",option+1,3) == 0) 
             { !               if (*option == '-')>                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))L                     Error("Missing shear geometry on -shear",(char *) NULL);                 }g               break;
             } 7           if (strncmp("shared_memory",option+1,5) == 0) 
             {;?               resource_info.use_shared_memory=(*option == '-');=               break;
             }(.           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')i                 {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -size",(char *) NULL); *                   image_info.size=argv[i];                 }                break;
             }h.           Error("Unrecognized option",option);           break;	         }          case 't': 	         {p3           if (strncmp("text_font",option+1,3) == 0) 
             { 4               resource_info.text_font=(char *) NULL;!               if (*option == '-')t                 {                    i++;                    if (i == argc)K                     Error("Missing font name on -text_font",(char *) NULL); 2                   resource_info.text_font=argv[i];                 }                break;
             } 1           if (strncmp("texture",option+1,5) == 0) 
             { /               image_info.texture=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing filename on -texture",(char *) NULL);-                   image_info.texture=argv[i];m                 }                break;
             }g/           if (strncmp("title",option+1,2) == 0)d
             {f0               resource_info.title=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     Error("Missing title on -title",(char *) NULL);*.                   resource_info.title=argv[i];                 }                break;
             }d5           if (strncmp("transparent",option+1,3) == 0) 
             { !               if (*option == '-')e                 {m                   i++;                    if (i == argc)I                     Error("Missing color on -transparent",(char *) NULL);!                 })               break;
             }m3           if (strncmp("treedepth",option+1,3) == 0)t
             {p)               resource_info.tree_depth=0;,!               if (*option == '-')                  {%                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL); 9                   resource_info.tree_depth=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'u': 	         { 0           if (strncmp("update",option+1,2) == 0)
             { 4               resource_info.update=(*option == '-');!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing seconds on -update",(char *) NULL);4                   resource_info.delay=atoi(argv[i]);                 }                break;
             }u4           if (strncmp("use_pixmap",option+1,2) == 0)
             {p8               resource_info.use_pixmap=(*option == '-');               break;
             }e.           Error("Unrecognized option",option);           break;	         }o         case 'v':r	         { 1           if (strncmp("verbose",option+1,2) == 0).
             {,2               image_info.verbose=(*option == '-');               break;
             }X0           if (strncmp("visual",option+1,2) == 0)
             {g6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')                  {r                   i++;                    if (i == argc)K                     Error("Missing visual class on -visual",(char *) NULL);m4                   resource_info.visual_type=argv[i];                 }r               break;
             }(.           Error("Unrecognized option",option);           break;	         }t         case 'w':b	         {r-           if (strcmp("window",option+1) == 0)g
             {d4               resource_info.window_id=(char *) NULL;!               if (*option == '-')                  {s                   i++;                    if (i == argc)C                     Error("Missing id, name, or 'root' on -window",s%                       (char *) NULL); 2                   resource_info.window_id=argv[i];                 }h               break;
             }n6           if (strncmp("window_group",option+1,7) == 0)
             {e7               resource_info.window_group=(char *) NULL;>!               if (*option == '-')o                 {n                   i++;                    if (i == argc)I                     Error("Missing id, name, or 'root' on -window_group", %                       (char *) NULL); 5                   resource_info.window_group=argv[i];                  }_               break;
             }_/           if (strncmp("write",option+1,2) == 0)n
             {;9               resource_info.write_filename=(char *) NULL; !               if (*option == '-')s                 {h                   i++;                    if (i == argc)G                     Error("Missing file name on -write",(char *) NULL);n7                   resource_info.write_filename=argv[i];MA                   if (IsAccessible(resource_info.write_filename))n                     {                        char"                         answer[2];  =                       (void) fprintf(stderr,"Overwrite %s? ",e6                         resource_info.write_filename);B                       (void) fgets(answer,sizeof(answer)-1,stdin);B                       if (!((*answer == 'y') || (*answer == 'Y')))                          exit(1);                     }S                 }a               break;
             } .           Error("Unrecognized option",option);           break;	         }(         case '?':-	         {h           Usage(True);           break;	         }n         default:	         {i.           Error("Unrecognized option",option);           break;	         }o       }>     else<       for (scene=first_scene; scene <= last_scene ; scene++)       { 
         /*L           Option is a file name: begin by reading image from specified file.
         */2         (void) strcpy(image_info.filename,option);&         if (first_scene != last_scene)           {m             char&               filename[MaxTextLength];               /*2               Form filename for multi-part images.             */?             (void) sprintf(filename,image_info.filename,scene); :             if (strcmp(filename,image_info.filename) == 0)I               (void) sprintf(filename,"%s.%u",image_info.filename,scene);e8             (void) strcpy(image_info.filename,filename);           }i0         (void) strcpy(image_info.magick,"MIFF");9         image_info.server_name=resource_info.server_name;P+         image_info.font=resource_info.font;R/         image_info.dither=resource_info.dither;U7         image_info.monochrome=resource_info.monochrome;t/         resource_info.image_info=(&image_info);n%         image=ReadImage(&image_info);)$         if (image == (Image *) NULL)5           if ((i < (argc-1)) || (scene < last_scene))a             continue;r           else
             {o               state|=ExitState;-               break;
             },
         do	         {n           /*J             Transmogrify image as defined by the image processing options.           */"           resource_info.quantum=1;2           MogrifyImage(&image_info,i,argv,&image);(           if (first_scene != last_scene)             image->scene=scene;            /*&             Display image to X server.           */7           if (resource_info.window_id != (char *) NULL) 
             {                unsigned int                 status;                  /*6                 Display image to a specified X window.               */K               status=XDisplayBackgroundImage(display,&resource_info,image);                if (status) )                 state|=RetainColorsState; +               if (resource_info.delay == 0)%!                 state|=ExitState;%
             }            else             do
             {o               ImageI                 *loaded_image;                 /**                 Display image to X server.               */               loaded_image=aN                 XDisplayImage(display,&resource_info,argv,argc,&image,&state);1               if (loaded_image == (Image *) NULL)                  break;P               while ((loaded_image != (Image *) NULL) && (!(state & ExitState)))               { ;                 if (loaded_image->montage != (char *) NULL)o                   {e                     /*G                       User selected a visual directory image (montage).X                     */)                     DestroyImages(image);o'                     image=loaded_image;                      break;                   }d?                 MogrifyImage(&image_info,i,argv,&loaded_image);g.                 if (first_scene != last_scene)%                   image->scene=scene;.J                 next_image=XDisplayImage(display,&resource_info,argv,argc,(                   &loaded_image,&state);*                 if (loaded_image != image).                   DestroyImages(loaded_image);(                 loaded_image=next_image;               } +             } while (!(state & ExitState));i<           if (resource_info.write_filename != (char *) NULL)
             {_               /*                 Write image.               */J               (void) strcpy(image->filename,resource_info.write_filename);3               (void) WriteImage(&image_info,image);t
             } !           if (image_info.verbose)(.             DescribeImage(image,stderr,False);           /*+             Proceed to next/previous image.y           */           next_image=image;,'           if (state & FormerImageState)*5             for (j=0; j < resource_info.quantum; j++)m
             {i.               next_image=next_image->previous;/               if (next_image == (Image *) NULL)                  break;
             }d           else5             for (j=0; j < resource_info.quantum; j++) 
             {_*               next_image=next_image->next;/               if (next_image == (Image *) NULL)t                 break;
             } +           if (next_image != (Image *) NULL)y             image=next_image;gI         } while ((next_image != (Image *) NULL) && !(state & ExitState));_
         /*           Free image resources.s
         */         DestroyImages(image);m(         if (!(state & FormerImageState)))           image_marker[i]=image_number++;          else           {s             /*(               Proceed to previous image.             */!             for (i--; i > 0; i--) 6               if (image_marker[i] == (image_number-2))                 break;"             if (image_number != 0)               image_number--;f           }a         if (state & ExitState)           break;       }      /*8       Determine if we should proceed to the first image.     */     if (i == (argc-1))A       if (resource_info.confirm_exit && (state & NextImageState)) 	         {a           unsigned int             status;*             /*!             Confirm program exit.d           */M           status=XConfirmWidget(display,windows,"Do you really want to exit",e             client_name);h           if (status == False)
             {n               i=0;               image_number=0; 
             } 	         }a   }a    if (state & RetainColorsState)N     XRetainWindowColors(display,XRootWindow(display,XDefaultScreen(display)));   free((char *) image_marker);%   free((char *) image_info.filename);    XSync(display,False);p
   exit(0);   return(False); } 