 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                       IIIII  M   M   AAA   GGGG  EEEEE                      % O %                         I    MM MM  A   A G      E                          % O %                         I    M M M  AAAAA G  GG  EEE                        % O %                         I    M   M  A   A G   G  E                          % O %                       IIIII  M   M  A   A  GGGG  EEEEE                      % O %                                                                             % O %                                                                             % O %                          ImageMagick Image Routines                         % O %                                                                             % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "Colorlist.h"   /*   Function prototypes. */
 static double    (*FilterFunction)(double);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A l l o c a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function AllocateImage allocates an Image structure and initializes each  %  field to a default value. % . %  The format of the AllocateImage routine is: % 0 %      allocated_image=AllocateImage(image_info) % + %  A description of each parameter follows:  % L %    o allocated_image: Function AllocateImage returns a pointer to an imageL %      structure initialized to default values.  A null image is returned if" %      there is a memory shortage. % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */1 Image *AllocateImage(const ImageInfo *image_info)  {    Image      *allocated_image;      /*     Allocate image structure.    */2   allocated_image=(Image *) malloc(sizeof(Image));(   if (allocated_image == (Image *) NULL)     { E       Warning("Unable to allocate image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize Image structure.    */&   allocated_image->file=(FILE *) NULL;    allocated_image->status=False;#   allocated_image->temporary=False; "   *allocated_image->filename='\0';   allocated_image->filesize=0;   allocated_image->pipe=False;0   (void) strcpy(allocated_image->magick,"MIFF");*   allocated_image->comments=(char *) NULL;'   allocated_image->label=(char *) NULL; &   allocated_image->text=(char *) NULL;"   allocated_image->id=UndefinedId;%   allocated_image->class=DirectClass;    allocated_image->matte=False; ;   allocated_image->compression=RunlengthEncodedCompression;    allocated_image->columns=0;    allocated_image->rows=0;&   allocated_image->depth=QuantumDepth;#   allocated_image->interlace=False;    allocated_image->scene=0; 2   allocated_image->units=2;  /* pixels per inch */%   allocated_image->x_resolution=72.0; %   allocated_image->y_resolution=72.0; )   allocated_image->montage=(char *) NULL; +   allocated_image->directory=(char *) NULL; 1   allocated_image->colormap=(ColorPacket *) NULL;     allocated_image->colorspace=0;   allocated_image->colors=0;   allocated_image->gamma=0.0; 0   allocated_image->normalized_maximum_error=0.0;-   allocated_image->normalized_mean_error=0.0; *   allocated_image->mean_error_per_pixel=0;"   allocated_image->total_colors=0;+   allocated_image->signature=(char *) NULL; 3   allocated_image->pixels=(RunlengthPacket *) NULL; 3   allocated_image->packet=(RunlengthPacket *) NULL;    allocated_image->packets=0; !   allocated_image->packet_size=0; 8   allocated_image->packed_pixels=(unsigned char *) NULL;)   *allocated_image->magick_filename='\0'; $   allocated_image->magick_columns=0;!   allocated_image->magick_rows=0; 5   allocated_image->magick_time=time((time_t *) NULL); *   allocated_image->geometry=(char *) NULL;&   allocated_image->page=(char *) NULL;'   allocated_image->delay=(char *) NULL;     allocated_image->orphan=False;+   allocated_image->previous=(Image *) NULL; '   allocated_image->list=(Image *) NULL; '   allocated_image->next=(Image *) NULL; '   if (image_info != (ImageInfo *) NULL)      { D       (void) strcpy(allocated_image->filename,image_info->filename);@       (void) strcpy(allocated_image->magick,image_info->magick);-       if (image_info->delay != (char *) NULL) E         allocated_image->delay=PostscriptGeometry(image_info->delay); ,       if (image_info->page != (char *) NULL)C         allocated_image->page=PostscriptGeometry(image_info->page);      }    return(allocated_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A n n o t a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function AnnotateImage annotates an image with test.  Optionally the K %  annotation can include the image filename, type, width, height, or scene I %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  % " %  produces an image annotation of %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % . %  The format of the AnnotateImage routine is: % ) %      AnnotateImage(image,annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % > %    o annotate_info: The address of a AnnotateInfo structure. %  %  */< void AnnotateImage(Image *image,AnnotateInfo *annotate_info) {    char
     *text,     **textlist;      FILE
     *file;     int 
     flags,     status,      x,     y;     register char      *p,      *q;      register int     i,     j;     static AnnotateInfo      cache_info;      static Display      *display = (Display *) NULL;     static unsigned int      font_type = 0;     static XAnnotateInfo     xannotate_info;      static XFontStruct     *font_info;      static XPixelInfo      pixel_info;      static XResourceInfo     resource_info;     static XrmDatabase     resource_database;     static XStandardColormap     *map_info;     static XVisualInfo     *visual_info;      unsigned int     height,      indirection,     length, 
     width;  +   if (annotate_info->text == (char *) NULL)      return; ,   indirection=(*annotate_info->text == '@');   if (indirection)     { 	       int 
         c;         /*         Read text from a file.       */5       file=(FILE *) fopen(annotate_info->text+1,"r");         if (file == (FILE *) NULL)	         { D           Warning("Unable to read text file",annotate_info->text+1);           return; 	         }        length=MaxTextLength; 2       annotate_info->text=(char *) malloc(length);L       for (q=annotate_info->text; annotate_info->text != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;0         if ((q-annotate_info->text+1) >= length)           {              *q='\0';             length<<=1; M             annotate_info->text=(char *) realloc(annotate_info->text,length); 5             if (annotate_info->text == (char *) NULL)                break;>             q=annotate_info->text+strlen(annotate_info->text);           }          *q=(unsigned char) c;        }        (void) fclose(file);/       if (annotate_info->text == (char *) NULL) 	         { I           Warning("Unable to annotate image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*'     Allocate and initialize image text.    */   p=annotate_info->text;3   length=strlen(annotate_info->text)+MaxTextLength; &   image->text=(char *) malloc(length);8   for (q=image->text; image->text != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;0     if ((q-image->text+MaxTextLength) >= length)       {          length<<=1; B         image->text=(char *) realloc((char *) image->text,length);)         if (image->text == (char *) NULL)            break;*         q=image->text+strlen(image->text);       }      /*,       Process formatting characters in text.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'b':        { 5         (void) sprintf(q,"%ld",image->filesize/1000); *         q=image->text+strlen(image->text);         break;       }        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);*         q=image->text+strlen(image->text);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);*         q=image->text+strlen(image->text);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); *         q=image->text+strlen(image->text);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } #   if (image->text == (char *) NULL)      { E       Warning("Unable to annotate image","Memory allocation failed"); 
       return;      }    *q++='\0';   *q++='\0';   if (indirection)'     free((char *) annotate_info->text); %   textlist=StringToList(image->text);    free(image->text);   image->text=(char *) NULL;!   if (textlist == (char **) NULL)      return;    length=strlen(textlist[0]); .   for (i=0; textlist[i] != (char *) NULL; i++)%     if (strlen(textlist[i]) > length) !       length=strlen(textlist[i]); !   text=(char *) malloc(length+4);    if (text == (char *) NULL)     { D       Warning("Unable to annotate image","Memory allocation error");
       return;      }    /*     Get annotate geometry.   */   x=0;   y=0;   width=image->columns; "   height=annotate_info->pointsize;   flags=NoValue;/   if (annotate_info->geometry != (char *) NULL)      { I       flags=XParseGeometry(annotate_info->geometry,&x,&y,&width,&height); #       if ((flags & XNegative) != 0)          x+=image->columns;#       if ((flags & YNegative) != 0)          y+=image->rows;      }    switch (font_type)   {      case 0:      default:     {        /*!         Open X server connection.        */&       if (display != (Display *) NULL)         break;7       display=XOpenDisplay(annotate_info->server_name); &       if (display != (Display *) NULL)	         {            /*,             Set our forgiving error handler.           */#           XSetErrorHandler(XError);            /*7             Get user defaults from X resource database.            */F           resource_database=XGetResourceDatabase(display,client_name);I           XGetResourceInfo(resource_database,client_name,&resource_info); +           resource_info.close_server=False; 1           resource_info.colormap=PrivateColormap; 3           if (annotate_info->font != (char *) NULL) 3             resource_info.font=annotate_info->font; 2           if (annotate_info->box != (char *) NULL)>             resource_info.background_color=annotate_info->box;2           if (annotate_info->pen != (char *) NULL)>             resource_info.foreground_color=annotate_info->pen;,           map_info=XAllocStandardColormap();5           if (map_info == (XStandardColormap *) NULL) 9             Warning("Unable to create standard colormap", *               "Memory allocation failed");           /*#             Initialize visual info.            */G           visual_info=XBestVisualInfo(display,map_info,&resource_info); 2           if (visual_info == (XVisualInfo *) NULL)F             Warning("Unable to get visual",resource_info.visual_type);-           map_info->colormap=(Colormap) NULL; 3           pixel_info.pixels=(unsigned long *) NULL; /           pixel_info.gamma_map=(XColor *) NULL;            /*.             Initialize Standard Colormap info.           */P           XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),             map_info);D           XGetPixelInfo(display,visual_info,map_info,&resource_info,(             (Image *) NULL,&pixel_info);N           pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);           /*!             Initialize font info.            */<           font_info=XBestFont(display,&resource_info,False);0           if (font_info == (XFontStruct *) NULL)>             Warning("Unable to load font",resource_info.font);9           if ((map_info == (XStandardColormap *) NULL) || 6               (visual_info == (XVisualInfo *) NULL) ||2               (font_info == (XFontStruct *) NULL))
             { F               XFreeResources(display,visual_info,map_info,&pixel_info,?                 font_info,&resource_info,(XWindowInfo *) NULL); '               display=(Display *) NULL; 
             } &           cache_info=(*annotate_info);           break;	         } O       Warning("Unable to load X server fonts","substituting Postscript fonts");        font_type++;     }      case 1:      { 
       char          filename[MaxTextLength],         page[MaxTextLength];         Image          *annotate_image;         ImageInfo          image_info;          register RunlengthPacket         *q;          unsigned int         matte;         XColor         box_color,         pen_color;         /*E         X server fonts are not available, use Postscript to annotate.        */@       (void) XQueryColorDatabase(annotate_info->box,&box_color);@       (void) XQueryColorDatabase(annotate_info->pen,&pen_color);        GetImageInfo(&image_info);"       TemporaryFilename(filename);!       image_info.monochrome=True; =       (void) sprintf(page,"%ux%u",height*length,height << 1);        image_info.page=page; /       if (annotate_info->font == (char *) NULL) (         annotate_info->font=DefaultFont;2       for (i=0; textlist[i] != (char *) NULL; i++)       { 8         if ((x >= image->columns) || (y >= image->rows))           break;!         if (*textlist[i] == '\0')            {              free(textlist[i]);             continue;            } (         (void) strcpy(text,textlist[i]);?         for (j=((int) strlen(textlist[i])-1) >> 1; j >= 0; j--) 	         { 6           (void) strcpy(image_info.filename,filename);#           file=fopen(filename,"w"); $           if (file == (FILE *) NULL)             break;3           (void) fprintf(file,"%%!PS-Adobe-3.0\n"); D           (void) fprintf(file,"/%s findfont %u scalefont setfont\n",(             annotate_info->font,height);E           (void) fprintf(file,"0 %u moveto (%s) show\n",height,text); ,           (void) fprintf(file,"showpage\n");           (void) fclose(file);0           annotate_image=ReadImage(&image_info);/           if (annotate_image == (Image *) NULL)              break;>           TransformImage(&annotate_image,"0x0",(char *) NULL);.           if (annotate_image->columns < width)             break;'           DestroyImage(annotate_image); *           (void) strcpy(text,textlist[i]);&           (void) strcpy(text+j,"...");B           (void) strcat(text,textlist[i]+strlen(textlist[i])-j-1);	         }           (void) remove(filename);         free(textlist[i]);-         if (annotate_image == (Image *) NULL)            { >             Warning("Unable to annotate image",(char *) NULL);             break;           } 
         /*(           Composite text onto the image.
         */*         annotate_image->class=DirectClass;#         annotate_image->matte=True; !         q=annotate_image->pixels; 3         for (j=0; j < annotate_image->packets; j++) 	         {            if (q->index != 0)
             { /               q->red=XDownScale(box_color.red); 3               q->green=XDownScale(box_color.green); 1               q->blue=XDownScale(box_color.blue);                q->index= K                 annotate_info->box == (char *) NULL ? Transparent : Opaque; 
             }            else
             { /               q->red=XDownScale(pen_color.red); 3               q->green=XDownScale(pen_color.green); 1               q->blue=XDownScale(pen_color.blue);                q->index= K                 annotate_info->pen == (char *) NULL ? Transparent : Opaque; 
             }            q++;	         }          matte=image->matte; >         CompositeImage(image,OverCompositeOp,annotate_image,x+P           (annotate_info->center ? (width >> 1)-(annotate_image->columns >> 1) :           0),y);         image->matte=matte; $         y+=annotate_info->pointsize;%         DestroyImage(annotate_image);        }        free(text); 0       for ( ; textlist[i] != (char *) NULL; i++)         free(textlist[i]);       free((char *) textlist);
       return;      }    }    /*     Initialize annotate info.    */$   XGetAnnotateInfo(&xannotate_info);-   if (cache_info.font != annotate_info->font)      {        /*         Font name has changed.       */#       XFreeFont(display,font_info); /       if (annotate_info->font != (char *) NULL) /         resource_info.font=annotate_info->font; 8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);     } !   if ((flags & HeightValue) == 0) 0     height=font_info->ascent+font_info->descent;%   xannotate_info.font_info=font_info;    xannotate_info.text=text;    xannotate_info.x=x;    xannotate_info.y=y;    xannotate_info.width=width; =   xannotate_info.height=font_info->ascent+font_info->descent; @   annotate_info->pointsize=font_info->ascent+font_info->descent;.   if ((annotate_info->pen != (char *) NULL) &&,       (annotate_info->box != (char *) NULL)))     xannotate_info.stencil=OpaqueStencil;    else,     if (annotate_info->pen != (char *) NULL)/       xannotate_info.stencil=ForegroundStencil;      else/       xannotate_info.stencil=BackgroundStencil; /   if ((cache_info.box != annotate_info->box) || -       (cache_info.pen != annotate_info->pen))      {        /*         Pen color has changed.       */.       if (annotate_info->box != (char *) NULL):         resource_info.background_color=annotate_info->box;.       if (annotate_info->pen != (char *) NULL):         resource_info.foreground_color=annotate_info->pen;O       XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,          &pixel_info);      }    /*     Annotate the text image.   */.   for (i=0; textlist[i] != (char *) NULL; i++)   { 4     if ((x >= image->columns) || (y >= image->rows))       break;     if (*textlist[i] == '\0')        {          free(textlist[i]);         continue;        } $     (void) strcpy(text,textlist[i]);;     for (j=((int) strlen(textlist[i])-1) >> 1; j >= 0; j--)      { L       xannotate_info.width=(height*XTextWidth(font_info,text,strlen(text)))/         xannotate_info.height;'       if (xannotate_info.width < width)          break;&       (void) strcpy(text,textlist[i]);"       (void) strcpy(text+j,"...");>       (void) strcat(text,textlist[i]+strlen(textlist[i])-j-1);     }      free(textlist[i]);N     (void) sprintf(xannotate_info.geometry,"%ux%u%+d%+d",xannotate_info.width,K       height,(int) (xannotate_info.x+(annotate_info->center ? (width >> 1)- :       (xannotate_info.width >> 1) : 0)),xannotate_info.y);A     xannotate_info.width=XTextWidth(font_info,text,strlen(text)); E     status=XAnnotateImage(display,&pixel_info,&xannotate_info,image);      if (status == 0)       { G         Warning("Unable to xannotate image","Memory allocation error");          break;       }      xannotate_info.y+=height;      y+=height;   }    /*     Free resources.    */   cache_info=(*annotate_info);
   free(text); ,   for ( ; textlist[i] != (char *) NULL; i++)     free(textlist[i]);   free((char *) textlist); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     B l u r I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BlurImage creates a new image that is a copy of an existing J %  one with the pixels blurred.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % F %  BlurImage convolves the pixel neighborhood with this blurring mask: % 
 %     1  2  1 
 %     2  W  2 
 %     1  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the BlurImage routine is: % , %      blurred_image=BlurImage(image,factor) % + %  A description of each parameter follows:  % G %    o blurred_image: Function BlurImage returns a pointer to the image J %      after it is blurred.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */, Image *BlurImage(Image *image,double factor) {  #define Blur(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;. #define BlurImageText  "  Blurring image...  "     Image      *blurred_image;      long     total_blue,      total_green,     total_red,     weight;      register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     { C       Warning("Unable to blur image","image size must exceed 3x3");        return((Image *) NULL);      }    /*(     Initialize blurred image attributes.   */B   blurred_image=CopyImage(image,image->columns,image->rows,False);&   if (blurred_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } #   blurred_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");"       DestroyImage(blurred_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=blurred_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */&   weight=(long) ((100.0-factor)/2-13);   quantum=Max(weight+12,1); %   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        s=s0; !       Blur(1);  Blur(2); Blur(1);        s=s1; %       Blur(2); Blur(weight); Blur(2);        s=s2; !       Blur(1);  Blur(2); Blur(1); <       q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);@       q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);>       q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;1     ProgressMonitor(BlurImageText,y,image->rows);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   return(blurred_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B o r d e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BorderImage takes an image and puts a border around it of a I %  particular color.  It allocates the memory necessary for the new Image H %  structure and returns a pointer to the new image.  Set the border and5 %  highlight to the same color to get a solid border.  % , %  The format of the BorderImage routine is: % A %      bordered_image=BorderImage(image,border_info,border_color)  % + %  A description of each parameter follows:  % M %    o bordered_image: Function BorderImage returns a pointer to the bordered H %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % I %    o border_info: Specifies a pointer to a XRectangle which defines the  %      border region.  % G %    o border_color: A pointer to a ColorPacket which contains the red, 6 %      green, and blue components of the border color. %  %  */; Image *BorderImage(Image *image,RectangleInfo *border_info,    ColorPacket *border_color) { 8 #define BorderImageText  "  Adding border to image...  "     Image      *bordered_image;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      border;      /*)     Initialize bordered image attributes.    */J   bordered_image=CopyImage(image,image->columns+(border_info->width << 1),2     image->rows+(border_info->height << 1),False);'   if (bordered_image == (Image *) NULL)      { C       Warning("Unable to border image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize border color.   */   border.red=border_color->red; #   border.green=border_color->green; !   border.blue=border_color->blue; #   border.index=border_color->index;    border.length=0;   /*(     Copy image and put border around it.   */   q=bordered_image->pixels; )   for (y=0; y < border_info->height; y++) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     */*     for (x=0; x < border_info->width; x++)       *q++=border;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     }      x=0;K     while (x < (bordered_image->columns-image->columns-border_info->width))      {        *q++=border;
       x++;     } 3     ProgressMonitor(BorderImageText,y,image->rows);    } O   for (y=(bordered_image->rows-image->rows-border_info->height-1); y >= 0; y--) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   return(bordered_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C h o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ChopImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure and& %  returns a pointer to the new image. % * %  The format of the ChopImage routine is: % , %      chop_image=ChopImage(image,chop_info) % + %  A description of each parameter follows:  % C %    o chop_image: Function ChopImage returns a pointer to the chop J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o chop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */7 Image *ChopImage(Image *image,RectangleInfo *chop_info)  { . #define ChopImageText  "  Chopping image...  "     Image      *chopped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      unsigned int     height;      /*     Check chop geometry.   */4   if (((chop_info->x+(int) chop_info->width) < 0) ||5       ((chop_info->y+(int) chop_info->height) < 0) || .       (chop_info->x > (int) image->columns) ||)       (chop_info->y > (int) image->rows))      { H       Warning("Unable to chop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((chop_info->x+(int) chop_info->width) > (int) image->columns) H     chop_info->width=(unsigned int) ((int) image->columns-chop_info->x);A   if ((chop_info->y+(int) chop_info->height) > (int) image->rows) F     chop_info->height=(unsigned int) ((int) image->rows-chop_info->y);   if (chop_info->x < 0)      { 7       chop_info->width-=(unsigned int) (-chop_info->x);        chop_info->x=0;      }    if (chop_info->y < 0)      { 8       chop_info->height-=(unsigned int) (-chop_info->y);       chop_info->y=0;      }    /*%     Initialize chop image attributes.    */@   chopped_image=CopyImage(image,image->columns-chop_info->width,)     image->rows-chop_info->height,False); &   if (chopped_image == (Image *) NULL)     { A       Warning("Unable to chop image","Memory allocation failed");        return((Image *) NULL);      }    /*     Extract chop image.    */   p=image->pixels;   image->runlength=p->length+1;    q=chopped_image->pixels;"   for (y=0; y < chop_info->y; y++)&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      }    /*%     Skip pixels up to the chop image.    */8   for (x=0; x < (chop_info->height*image->columns); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract chop image.    */6   height=image->rows-(chop_info->y+chop_info->height);   for (y=0; y < height; y++)   { &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      } ,     ProgressMonitor(ChopImageText,y,height);   }    return(chopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o s e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CloseImage closes a file associated with the image.  If the K %  filename prefix is '|', the file is a pipe and is closed with PipeClose.  % + %  The format of the CloseImage routine is:  %  %      CloseImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CloseImage(Image *image)  {    /*     Close image file.    */   if (image == (Image *) NULL)     return; #   if (image->file == (FILE *) NULL)      return; $   image->status=ferror(image->file);) #if !defined(vms) && !defined(__MWERKS__)    if (image->pipe)     (void) pclose(image->file);    else #endif:     if ((image->file != stdin) && (image->file != stdout))!       (void) fclose(image->file);    do   {      image->file=(FILE *) NULL;     image=image->next;   } "   while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m m e n t I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CommentImage initializes an image comment.  Optionally theH %  comment can include the image filename, type, width, height, or sceneI %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  %  %  produces an image comment of  %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % - %  The format of the CommentImage routine is:  % # %      CommentImage(image,comments)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % I %    o comments: The address of a character string containing the comment  %      format. %  %  */. void CommentImage(Image *image,char *comments) {    register char      *p,      *q;      unsigned int     indirection,     length;   '   if (image->comments != (char *) NULL) #     free((char *) image->comments);     image->comments=(char *) NULL;    if (comments == (char *) NULL)     return; !   indirection=(*comments == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*"         Read comments from a file.       */*       file=(FILE *) fopen(comments+1,"r");        if (file == (FILE *) NULL)	         { =           Warning("Unable to read comments file",comments+1);            return; 	         }        length=MaxTextLength; '       comments=(char *) malloc(length); 6       for (q=comments; comments != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;%         if ((q-comments+1) >= length)            {              *q='\0';             length<<=1; @             comments=(char *) realloc((char *) comments,length);*             if (comments == (char *) NULL)               break;(             q=comments+strlen(comments);           }          *q=(unsigned char) c;        }        (void) fclose(file);$       if (comments == (char *) NULL)	         { I           Warning("Unable to comments image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*+     Allocate and initialize image comments.    */
   p=comments; (   length=strlen(comments)+MaxTextLength;*   image->comments=(char *) malloc(length);@   for (q=image->comments; image->comments != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;4     if ((q-image->comments+MaxTextLength) >= length)       {          length<<=1; J         image->comments=(char *) realloc((char *) image->comments,length);-         if (image->comments == (char *) NULL)            break;2         q=image->comments+strlen(image->comments);       }      /*0       Process formatting characters in comments.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'b':        { 5         (void) sprintf(q,"%ld",image->filesize/1000); 2         q=image->comments+strlen(image->comments);         break;       }        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);2         q=image->comments+strlen(image->comments);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);2         q=image->comments+strlen(image->comments);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); 2         q=image->comments+strlen(image->comments);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } '   if (image->comments == (char *) NULL)      { D       Warning("Unable to comment image","Memory allocation failed");
       return;      } 
   *q='\0';   if (indirection)     free((char *) comments); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s C o l o r m a p                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressColormap compresses an image colormap removing any %  unused color entries. % 1 %  The format of the CompressColormap routine is:  %  %      CompressColormap(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */# void CompressColormap(Image *image)  { 
   ColorPacket      *colormap;     int      number_colors;     register int     i;     register RunlengthPacket     *p;      register unsigned short 
     index;     /*,     Determine if colormap can be compressed.   */"   if (image->class != PseudoClass)     return;    number_colors=image->colors;#   for (i=0; i < image->colors; i++) #     image->colormap[i].flags=False;    image->colors=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { )     if (!image->colormap[p->index].flags)        { 6         image->colormap[p->index].index=image->colors;-         image->colormap[p->index].flags=True;          image->colors++;       }      p++;   } %   if (image->colors == number_colors) $     return;  /* no unused entries */   /*     Compress colormap.   */E   colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket)); '   if (colormap == (ColorPacket *) NULL)      { H       Warning("Unable to compress colormap","Memory allocation failed");"       image->colors=number_colors;
       return;      } #   for (i=0; i < number_colors; i++) !     if (image->colormap[i].flags)        { '         index=image->colormap[i].index; 3         colormap[index].red=image->colormap[i].red; 7         colormap[index].green=image->colormap[i].green; 5         colormap[index].blue=image->colormap[i].blue;        }    /*     Remap pixels.    */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { -     p->index=image->colormap[p->index].index;      p++;   } !   free((char *) image->colormap);    image->colormap=colormap;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressImage compresses an image to the minimum number of %  runlength-encoded packets.  % . %  The format of the CompressImage routine is: %  %      CompressImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */  void CompressImage(Image *image) {    register int     i;     register RunlengthPacket     *p,      *q;      /*     Compress image.    */   if (image == (Image *) NULL)     return;    p=image->pixels;   image->runlength=p->length+1;    image->packets=0;    q=image->pixels;   q->length=MaxRunlength;    if (image->matte) 4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      }    else4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && C           (p->blue == q->blue) && ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    /*H     Runlength-encode only if it takes up less space than no compression.   */"   if (image->class == DirectClass)     { B       if (image->packets >= ((image->columns*image->rows*3) >> 2)))         image->compression=NoCompression; 
       return;      } <   if (image->packets >= ((image->columns*image->rows) >> 1))%     image->compression=NoCompression;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p o s i t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CompositeImage returns the second image composited onto the " %  first at the specified offsets. % / %  The format of the CompositeImage routine is:  % F %      CompositeImage(image,compose,composite_image,x_offset,y_offset) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 6 %    o compose: Specifies an image composite operator. % A %    o composite_image: The address of a structure of type Image.  % N %    o x_offset: An integer that specifies the column offset of the composited
 %      image.  % K %    o y_offset: An integer that specifies the row offset of the composited 
 %      image.  %  %  */< void CompositeImage(Image *image,const unsigned int compose,?   Image *composite_image,const int x_offset,const int y_offset)  { ( #define Azimuth  DegreesToRadians(135.0)6 #define CompositeImageText  "  Compositing image...  ") #define Elevation  DegreesToRadians(45.0)       typedef struct _VectorPacket     {	      long 	        x, 	        y, 	        z;     } VectorPacket;     double
     distance;      long	     blue, 
     green,     red;     register int     i,
     index,     x,     y;     register RunlengthPacket     *p,      *q,      *s0,     *s1,     *s2;  	   Quantum 
     shade;     VectorPacket
     light,     normal;      /*     Check composite geometry.    */.   if (((x_offset+(int) image->columns) < 0) ||+       ((y_offset+(int) image->rows) < 0) || J       (x_offset > (int) image->columns) || (y_offset > (int) image->rows))     { M       Warning("Unable to composite image","geometry does not contain image"); 
       return;      }    /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return; $   if (compose == ReplaceCompositeOp)     {        /*9         Promote image to DirectClass if colormaps differ.        */&       if (image->class == PseudoClass)2         if (composite_image->class == DirectClass)#           image->class=DirectClass;          else           { 2             if (image->signature == (char *) NULL)$               SignatureImage(image);<             if (composite_image->signature == (char *) NULL).               SignatureImage(composite_image);I             if (strcmp(image->signature,composite_image->signature) != 0) '               image->class=DirectClass;            } 2       if (image->matte && !composite_image->matte)	         { $           p=composite_image->pixels;6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;             p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    else     {        /*$         Initialize image matte data.       */       if (!image->matte)	         {            q=image->pixels;           red=q->red;            green=q->green;            blue=q->blue; ,           for (i=0; i < image->packets; i++)           {              q->index=Opaque;             q++;           } #           image->class=DirectClass;            image->matte=True;	         } "       if (!composite_image->matte)	         { $           p=composite_image->pixels;           red=p->red;            green=p->green;            blue=p->blue; 6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;L             if ((p->red == red) && (p->green == green) && (p->blue == blue))#               p->index=Transparent;              p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      } $   if (compose == BumpmapCompositeOp)     {        /*!         Compute the light vector.        */,       if (!UncompressImage(composite_image))         return; :       light.x=(long) (MaxRGB*cos(Azimuth)*cos(Elevation));:       light.y=(long) (MaxRGB*sin(Azimuth)*cos(Elevation));-       light.z=(long) (MaxRGB*sin(Elevation)); J       normal.z=(6*MaxRGB)/3;  /* constant Z component of surface normal */     }    /*      Initialize composited image.   */   p=composite_image->pixels;)   composite_image->runlength=p->length+1; +   for (y=0; y < composite_image->rows; y++)    { <     if (((y_offset+y) < 0) || ((y_offset+y) >= image->rows))       continue; 9     q=image->pixels+(y_offset+y)*image->columns+x_offset; 0     for (x=0; x < composite_image->columns; x++)     { *       if (composite_image->runlength != 0)%         composite_image->runlength--; 
       else	         {            p++;/           composite_image->runlength=p->length; 	         } A       if (((x_offset+x) < 0) || ((x_offset+x) >= image->columns)) 	         {            q++;           continue; 	         }        switch (compose)       {          case OverCompositeOp:          default:	         { &           if (p->index == Transparent)
             {                red=q->red;                green=q->green;                blue=q->blue;                index=q->index; 
             }            else#             if (p->index == Opaque)                {                  red=p->red;                  green=p->green;                  blue=p->blue;                  index=p->index;                }              else               { K                 red=(long) (p->red*Opaque+q->red*(Opaque-p->index))/Opaque;                  green=(long)F                   (p->green*Opaque+q->green*(Opaque-p->index))/Opaque;N                 blue=(long) (p->blue*Opaque+q->blue*(Opaque-p->index))/Opaque;                 index=(long)F                   (p->index*Opaque+q->index*(Opaque-p->index))/Opaque;               }            break;	         }          case InCompositeOp: 	         { .           red=(long) (p->red*q->index)/Opaque;2           green=(long) (p->green*q->index)/Opaque;0           blue=(long) (p->blue*q->index)/Opaque;2           index=(long) (p->index*q->index)/Opaque;           break;	         }          case OutCompositeOp:	         { 7           red=(long) (p->red*(Opaque-q->index))/Opaque; ;           green=(long) (p->green*(Opaque-q->index))/Opaque; 9           blue=(long) (p->blue*(Opaque-q->index))/Opaque; ;           index=(long) (p->index*(Opaque-q->index))/Opaque;            break;	         }          case AtopCompositeOp: 	         { G           red=(long) (p->red*q->index+q->red*(Opaque-p->index))/Opaque; M           green=(long) (p->green*q->index+q->green*(Opaque-p->index))/Opaque; J           blue=(long) (p->blue*q->index+q->blue*(Opaque-p->index))/Opaque;M           index=(long) (p->index*q->index+q->index*(Opaque-p->index))/Opaque;            break;	         }          case XorCompositeOp:	         { P           red=(long) (p->red*(Opaque-q->index)+q->red*(Opaque-p->index))/Opaque;           green=(long)K             (p->green*(Opaque-q->index)+q->green*(Opaque-p->index))/Opaque;            blue=(long) I             (p->blue*(Opaque-q->index)+q->blue*(Opaque-p->index))/Opaque;            index=(long)K             (p->index*(Opaque-q->index)+q->index*(Opaque-p->index))/Opaque;            break;	         }          case PlusCompositeOp: 	         { *           red=(long) p->red+(long) q->red;0           green=(long) p->green+(long) q->green;-           blue=(long) p->blue+(long) q->blue; 0           index=(long) p->index+(long) q->index;           break;	         }          case MinusCompositeOp:	         { *           red=(long) p->red-(long) q->red;0           green=(long) p->green-(long) q->green;-           blue=(long) p->blue-(long) q->blue;            index=Opaque;            break;	         }          case AddCompositeOp:	         { *           red=(long) p->red+(long) q->red;           if (red > Opaque)              red-=(Opaque+1);0           green=(long) p->green+(long) q->green;           if (green > Opaque)              green-=(Opaque+1);-           blue=(long) p->blue+(long) q->blue;            if (blue > Opaque)             blue-=(Opaque+1); 0           index=(long) p->index+(long) q->index;           if (index > Opaque)              index-=(Opaque+1);           break;	         } !         case SubtractCompositeOp: 	         { *           red=(long) p->red-(long) q->red;           if (red < 0)             red+=(Opaque+1);0           green=(long) p->green-(long) q->green;           if (green < 0)             green+=(Opaque+1);-           blue=(long) p->blue-(long) q->blue;            if (blue < 0)              blue+=(Opaque+1); 0           index=(long) p->index-(long) q->index;           if (index < 0)             index+=(Opaque+1);           break;	         } #         case DifferenceCompositeOp: 	         { 9           red=AbsoluteValue((long) p->red-(long) q->red); ?           green=AbsoluteValue((long) p->green-(long) q->green); <           blue=AbsoluteValue((long) p->blue-(long) q->blue);?           index=AbsoluteValue((long) p->index-(long) q->index);            break;	         }           case BumpmapCompositeOp:	         { (           s0=p-composite_image->columns;           s1=p; (           s2=p+composite_image->columns;/           while (s0 <= composite_image->pixels)            { )             s0+=composite_image->columns; )             s1+=composite_image->columns; )             s2+=composite_image->columns;            } L           while (s2 >= (composite_image->pixels+composite_image->packets-1))           { )             s0-=composite_image->columns; )             s1-=composite_image->columns; )             s2-=composite_image->columns;            }            /*=             Determine the surface normal and compute shading.            */?           normal.x=(long) ((s0-1)->red+(s1-1)->red+(s2-1)->red- 1             (s0+1)->red-(s1+1)->red-(s2+1)->red); ;           normal.y=(long) ((s2-1)->red+s2->red+(s2+1)->red- -             (s0-1)->red-s0->red-(s0+1)->red); 1           if ((normal.x == 0) && (normal.y == 0)) $             shade=(Quantum) light.z;           else
             {                shade=0;J               distance=normal.x*light.x+normal.y*light.y+normal.z*light.z;               if (distance > 0) *                 shade=(Quantum) (distance/O                   sqrt(normal.x*normal.x+normal.y*normal.y+normal.z*normal.z)); 
             } M           red=(long) (q->red*shade+(1L << (QuantumDepth-1))) >> QuantumDepth; E           normal.x=(long) ((s0-1)->green+(s1-1)->green+(s2-1)->green- 7             (s0+1)->green-(s1+1)->green-(s2+1)->green); A           normal.y=(long) ((s2-1)->green+s2->green+(s2+1)->green- 3             (s0-1)->green-s0->green-(s0+1)->green); 1           if ((normal.x == 0) && (normal.y == 0)) $             shade=(Quantum) light.z;           else
             {                shade=0;J               distance=normal.x*light.x+normal.y*light.y+normal.z*light.z;               if (distance > 0) *                 shade=(Quantum) (distance/O                   sqrt(normal.x*normal.x+normal.y*normal.y+normal.z*normal.z)); 
             }            green=(long)F             (q->green*shade+(1L << (QuantumDepth-1))) >> QuantumDepth;B           normal.x=(long) ((s0-1)->blue+(s1-1)->blue+(s2-1)->blue-4             (s0+1)->blue-(s1+1)->blue-(s2+1)->blue);>           normal.y=(long) ((s2-1)->blue+s2->blue+(s2+1)->blue-0             (s0-1)->blue-s0->blue-(s0+1)->blue);1           if ((normal.x == 0) && (normal.y == 0)) $             shade=(Quantum) light.z;           else
             {                shade=0;J               distance=normal.x*light.x+normal.y*light.y+normal.z*light.z;               if (distance > 0) *                 shade=(Quantum) (distance/O                   sqrt(normal.x*normal.x+normal.y*normal.y+normal.z*normal.z)); 
             } O           blue=(long) (q->blue*shade+(1L << (QuantumDepth-1))) >> QuantumDepth; E           normal.x=(long) ((s0-1)->index+(s1-1)->index+(s2-1)->index- 7             (s0+1)->index-(s1+1)->index-(s2+1)->index); A           normal.y=(long) ((s2-1)->index+s2->index+(s2+1)->index- 3             (s0-1)->index-s0->index-(s0+1)->index); 1           if ((normal.x == 0) && (normal.y == 0)) $             shade=(Quantum) light.z;           else
             {                shade=0;J               distance=normal.x*light.x+normal.y*light.y+normal.z*light.z;                if (distance >= 0)*                 shade=(Quantum) (distance/O                   sqrt(normal.x*normal.x+normal.y*normal.y+normal.z*normal.z)); 
             } 7           index=(long) (q->index*shade+(1L << 7)) >> 8;            break;	         }           case ReplaceCompositeOp:	         {            red=p->red;            green=p->green;            blue=p->blue;            index=p->index;            break;	         } %         case MatteReplaceCompositeOp: 	         {            red=q->red;            green=q->green;            blue=q->blue;            index=p->index;            break;	         }          case BlendCompositeOp:	         { >           red=(long) (p->red*p->index+q->red*q->index)/Opaque;D           green=(long) (p->green*p->index+q->green*q->index)/Opaque;A           blue=(long) (p->blue*p->index+q->blue*q->index)/Opaque;            index=Opaque;            break;	         }        }        if (red > MaxRGB)          q->red=MaxRGB;
       else         if (red < 0)           q->red=0;          else           q->red=red;        if (green > MaxRGB)          q->green=MaxRGB;
       else         if (green < 0)           q->green=0;          else           q->green=green;        if (blue > MaxRGB)         q->blue=MaxRGB; 
       else         if (blue < 0)            q->blue=0;         else           q->blue=blue;        if (index > Opaque)          q->index=Opaque;
       else          if (index < Transparent)           q->index=Transparent;          else           q->index=index;        q->length=0;
       q++;     } @     ProgressMonitor(CompositeImageText,y,composite_image->rows);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C o n t r a s t I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ContrastImage enhances the intensity differences between the, %  lighter and darker elements of the image. % . %  The format of the ContrastImage routine is: % # %      ContrastImage(image,sharpen)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % C %    o sharpen: If True, the intensity is increased otherwise it is  %      decreased.  %  %  */  < static void HSLTransform(double hue,const double saturation,D   const double luminosity,Quantum *red,Quantum *green,Quantum *blue) {    double     b,     g,     r,     v,     x,     y,     z;     /*"     Convert HSL to RGB colorspace.   */9   v=(luminosity <= 0.5) ? (luminosity*(1.0+saturation)) : 2     (luminosity+saturation-luminosity*saturation);
   if (v <= 0)      { 
       *red=0;        *green=0;        *blue=0;
       return;      }    if (hue == 1.0)      hue=0.0;   hue*=6.0;    y=luminosity+luminosity-v;   x=y+(v-y)*(hue-(int) hue);   z=v-(v-y)*(hue-(int) hue);   switch ((int) hue)   { !     case 0: r=v; g=x; b=y; break; !     case 1: r=z; g=v; b=y; break; !     case 2: r=y; g=v; b=x; break; !     case 3: r=y; g=z; b=v; break; !     case 4: r=x; g=y; b=v; break; !     case 5: r=v; g=y; b=z; break;    } 0   *red=(Quantum) floor((r*(double) MaxRGB)+0.5);2   *green=(Quantum) floor((g*(double) MaxRGB)+0.5);1   *blue=(Quantum) floor((b*(double) MaxRGB)+0.5);  }   ? static void TransformHSL(const Quantum red,const Quantum green, G   const Quantum blue,double *hue,double *saturation,double *luminosity)  {    double     b,     g,     max,     min,     r;     /*"     Convert RGB to HSL colorspace.   */!   r=(double) red/(double) MaxRGB; #   g=(double) green/(double) MaxRGB; "   b=(double) blue/(double) MaxRGB;   max=Max(r,Max(g,b));   min=Min(r,Min(g,b));   *luminosity=(min+max)/2.0;   if (*luminosity <= 0.0)      return;    *saturation=max-min;   if (*saturation <= 0.0)      return; A   *saturation/=(*luminosity <= 0.5) ? (min+max) : (2.0-max-min) ;    if (r == max) D     *hue=(g == min ? 5.0+(max-b)/(max-min) : 1.0-(max-g)/(max-min));   else     if (g == max) F       *hue=(b == min ? 1.0+(max-r)/(max-min) : 3.0-(max-b)/(max-min));     elseF       *hue=(r == min ? 3.0+(max-g)/(max-min) : 5.0-(max-r)/(max-min));   *hue/=6.0; }   N static void Contrast(const int sign,Quantum *red,Quantum *green,Quantum *blue) {    double     brightness,      hue,     saturation, 
     theta;     /*K     Enhance contrast: dark color become darker, light color become lighter.    */?   TransformHSL(*red,*green,*blue,&hue,&saturation,&brightness);    theta=(brightness-0.5)*M_PI;?   brightness+=(((((sin(theta)+1.0))*0.5)-brightness)*sign)*0.5;    if (brightness > 1.0)      brightness=1.0;    else     if (brightness < 0)        brightness=0.0; 9   HSLTransform(hue,saturation,brightness,red,green,blue);  }   ; void ContrastImage(Image *image,const unsigned int sharpen)  { > #define DullContrastImageText  "  Dulling image contrast...  "D #define SharpenContrastImageText  "  Sharpening image contrast...  "     int 	     sign;      register int     i;     register RunlengthPacket     *p;      sign=sharpen ? 1 : -1;   switch (image->class)    {      case DirectClass:      {        /*+         Contrast enhance DirectClass image.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { 2         Contrast(sign,&p->red,&p->green,&p->blue);         p++;!         if (QuantumTick(i,image))            if (sharpen)G             ProgressMonitor(SharpenContrastImageText,i,image->packets);            elseD             ProgressMonitor(DullContrastImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        /*+         Contrast enhance PseudoClass image.        */'       for (i=0; i < image->colors; i++) H         Contrast(sign,&image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o p y I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function CopyImage returns a copy of all fields of the input image.  The B %  the pixel memory is allocated but the pixel data is not copied. % * %  The format of the CopyImage routine is: % ; %      copy_image=CopyImage(image,columns,rows,copy_pixels)  % + %  A description of each parameter follows:  % J %    o copy_image: Function CopyImage returns a pointer to the image afterH %      copying.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the copied 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the copied 
 %      image.  % H %    o copy_pixels: Specifies whether the pixel data is copied.  Must be %      either True or False; %  %  */9 Image *CopyImage(Image *image,const unsigned int columns, 9   const unsigned int rows,const unsigned int copy_pixels)  {    Image      *copy_image;     register int     i;     /*     Allocate image structure.    */-   copy_image=(Image *) malloc(sizeof(Image)); #   if (copy_image == (Image *) NULL)      return((Image *) NULL);    *copy_image=(*image); '   if (image->comments != (char *) NULL)      {        /*-         Allocate and copy the image comments.        */#       copy_image->comments=(char *) 9         malloc((unsigned int) strlen(image->comments)+1); 0       if (copy_image->comments == (char *) NULL)         return((Image *) NULL); :       (void) strcpy(copy_image->comments,image->comments);     } $   if (image->label != (char *) NULL)     {        /**         Allocate and copy the image label.       */O       copy_image->label=(char *) malloc((unsigned int) strlen(image->label)+1); -       if (copy_image->label == (char *) NULL)          return((Image *) NULL); 4       (void) strcpy(copy_image->label,image->label);     }    copy_image->columns=columns;   copy_image->rows=rows;$   copy_image->montage=(char *) NULL;&   copy_image->directory=(char *) NULL;.   if (image->colormap != (ColorPacket *) NULL)     {        /*-         Allocate and copy the image colormap.        */*       copy_image->colormap=(ColorPacket *)2         malloc(image->colors*sizeof(ColorPacket));7       if (copy_image->colormap == (ColorPacket *) NULL)          return((Image *) NULL); '       for (i=0; i < image->colors; i++) 3         copy_image->colormap[i]=image->colormap[i];      } (   if (image->signature != (char *) NULL)     {        /*.         Allocate and copy the image signature.       */$       copy_image->signature=(char *):         malloc((unsigned int) strlen(image->signature)+1);1       if (copy_image->signature == (char *) NULL)          return((Image *) NULL); <       (void) strcpy(copy_image->signature,image->signature);     }    /*     Allocate the image pixels.   */   if (copy_pixels)*     copy_image->pixels=(RunlengthPacket *)D       malloc((unsigned int) image->packets*sizeof(RunlengthPacket));   else     { ?       copy_image->packets=copy_image->columns*copy_image->rows; ,       copy_image->pixels=(RunlengthPacket *)K         malloc((unsigned int) copy_image->packets*sizeof(RunlengthPacket));      } 5   if (copy_image->pixels == (RunlengthPacket *) NULL)      return((Image *) NULL);    if (copy_pixels)     {        register RunlengthPacket         *p,          *q;          /*         Copy the image pixels.       */       p=image->pixels;       q=copy_image->pixels; (       for (i=0; i < image->packets; i++)       {          *q=(*p);         p++;         q++;       }      } #   if (image->page != (char *) NULL)      {        /*)         Allocate and copy the image page.        */M       copy_image->page=(char *) malloc((unsigned int) strlen(image->page)+1); ,       if (copy_image->page == (char *) NULL)         return((Image *) NULL); 2       (void) strcpy(copy_image->page,image->page);     } $   if (image->delay != (char *) NULL)     {        /**         Allocate and copy the image delay.       */O       copy_image->delay=(char *) malloc((unsigned int) strlen(image->delay)+1); -       if (copy_image->delay == (char *) NULL)          return((Image *) NULL); 4       (void) strcpy(copy_image->delay,image->delay);     }    if (image->orphan)     { %       copy_image->file=(FILE *) NULL; *       copy_image->previous=(Image *) NULL;&       copy_image->next=(Image *) NULL;     }    else     {        /*#         Link image into image list.        */1       if (copy_image->previous != (Image *) NULL) .         copy_image->previous->next=copy_image;-       if (copy_image->next != (Image *) NULL) .         copy_image->next->previous=copy_image;     }    copy_image->orphan=False;    return(copy_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C r o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function CropImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure andM %  returns a pointer to the new image.  This routine is optimized to perserve K %  the runlength encoding.  That is, the cropped image will always use less  %  memory than the original. % * %  The format of the CropImage routine is: % / %      cropped_image=CropImage(image,crop_info)  % + %  A description of each parameter follows:  % I %    o cropped_image: Function CropImage returns a pointer to the cropped J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o crop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */7 Image *CropImage(Image *image,RectangleInfo *crop_info)  { . #define CropImageText  "  Cropping image...  " #define DeltaX  16     Image      *cropped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check crop geometry.   */4   if (((crop_info->x+(int) crop_info->width) < 0) ||5       ((crop_info->y+(int) crop_info->height) < 0) || .       (crop_info->x > (int) image->columns) ||)       (crop_info->y > (int) image->rows))      { H       Warning("Unable to crop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((crop_info->x+(int) crop_info->width) > (int) image->columns) H     crop_info->width=(unsigned int) ((int) image->columns-crop_info->x);A   if ((crop_info->y+(int) crop_info->height) > (int) image->rows) F     crop_info->height=(unsigned int) ((int) image->rows-crop_info->y);   if (crop_info->x < 0)      { 7       crop_info->width-=(unsigned int) (-crop_info->x);        crop_info->x=0;      }    if (crop_info->y < 0)      { 8       crop_info->height-=(unsigned int) (-crop_info->y);       crop_info->y=0;      } :   if ((crop_info->width == 0) && (crop_info->height == 0))     {        register int
         i;         RunlengthPacket          corners[4];          /*1         Set bounding box to the image dimensions.        */       crop_info->width=0;        crop_info->height=0;"       crop_info->x=image->columns;       crop_info->y=image->rows;        p=image->pixels;#       image->runlength=p->length+1;        corners[0]=(*p);7       for (i=1; i <= (image->rows*image->columns); i++)        { "         if (image->runlength != 0)           image->runlength--;          else           {              p++;'             image->runlength=p->length;            }           if (i == image->columns)           corners[1]=(*p);?         if (i == (image->rows*image->columns-image->columns+1))            corners[2]=(*p);.         if (i == (image->rows*image->columns))           corners[3]=(*p);       }        p=image->pixels;#       image->runlength=p->length+1; %       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { $           if (image->runlength != 0)             image->runlength--;            else
             {                p++;)               image->runlength=p->length; 
             } @           if (((int) p->red >= (int) (corners[0].red+DeltaX)) ||@               ((int) p->red <= (int) (corners[0].red-DeltaX)) ||D               ((int) p->green >= (int) (corners[0].green+DeltaX)) ||D               ((int) p->green <= (int) (corners[0].green-DeltaX)) ||B               ((int) p->blue >= (int) (corners[0].blue+DeltaX)) ||@               ((int) p->blue <= (int) (corners[0].blue-DeltaX)))!             if (x < crop_info->x)                crop_info->x=x; @           if (((int) p->red >= (int) (corners[1].red+DeltaX)) ||@               ((int) p->red <= (int) (corners[1].red-DeltaX)) ||D               ((int) p->green >= (int) (corners[1].green+DeltaX)) ||D               ((int) p->green <= (int) (corners[1].green-DeltaX)) ||B               ((int) p->blue >= (int) (corners[1].blue+DeltaX)) ||@               ((int) p->blue <= (int) (corners[1].blue-DeltaX)))%             if (x > crop_info->width) !               crop_info->width=x; @           if (((int) p->red >= (int) (corners[0].red+DeltaX)) ||@               ((int) p->red <= (int) (corners[0].red-DeltaX)) ||D               ((int) p->green >= (int) (corners[0].green+DeltaX)) ||D               ((int) p->green <= (int) (corners[0].green-DeltaX)) ||B               ((int) p->blue >= (int) (corners[0].blue+DeltaX)) ||@               ((int) p->blue <= (int) (corners[0].blue-DeltaX)))!             if (y < crop_info->y)                crop_info->y=y; @           if (((int) p->red >= (int) (corners[2].red+DeltaX)) ||@               ((int) p->red <= (int) (corners[2].red-DeltaX)) ||D               ((int) p->green >= (int) (corners[2].green+DeltaX)) ||D               ((int) p->green <= (int) (corners[2].green-DeltaX)) ||B               ((int) p->blue >= (int) (corners[2].blue+DeltaX)) ||@               ((int) p->blue <= (int) (corners[2].blue-DeltaX)))&             if (y > crop_info->height)"               crop_info->height=y;	         }        } '       crop_info->width-=crop_info->x-1; (       crop_info->height-=crop_info->y-1;     } :   if ((crop_info->width == 0) || (crop_info->height == 0))     { E       Warning("Unable to crop image","geometry dimensions are zero");        return((Image *) NULL);      } -   if ((crop_info->width == image->columns) && B       (crop_info->height == image->rows) && (crop_info->x == 0) &&       (crop_info->y == 0))     return((Image *) NULL);    /*(     Initialize cropped image attributes.   */I   cropped_image=CopyImage(image,crop_info->width,crop_info->height,True); &   if (cropped_image == (Image *) NULL)     { A       Warning("Unable to crop image","Memory allocation failed");        return((Image *) NULL);      }    /*(     Skip pixels up to the cropped image.   */   p=image->pixels;   image->runlength=p->length+1; @   for (x=0; x < (crop_info->y*image->columns+crop_info->x); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract cropped image.   */   cropped_image->packets=0;    q=cropped_image->pixels;   q->red=0; 
   q->green=0;    q->blue=0;
   q->index=0;    q->length=MaxRunlength; -   for (y=0; y < (cropped_image->rows-1); y++)    {      /*       Transfer scanline.     */.     for (x=0; x < cropped_image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { *           if (cropped_image->packets != 0)             q++;#           cropped_image->packets++;            *q=(*p);           q->length=0;	         }      }      /*       Skip to next scanline.     */?     for (x=0; x < (image->columns-cropped_image->columns); x++)         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } ;     ProgressMonitor(CropImageText,y,cropped_image->rows-1);    }    /*     Transfer last scanline.    */,   for (x=0; x < cropped_image->columns; x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        } 7     if ((p->red == q->red) && (p->green == q->green) && 9         (p->blue == q->blue) && (p->index == q->index) && )         ((int) q->length < MaxRunlength))        q->length++;     else       { (         if (cropped_image->packets != 0)           q++;!         cropped_image->packets++;          *q=(*p);         q->length=0;       }    } <   cropped_image->pixels=(RunlengthPacket *) realloc((char *)J     cropped_image->pixels,cropped_image->packets*sizeof(RunlengthPacket));   return(cropped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s c r i b e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DescribeImage describes an image by printing its attributes to
 %  stderr. % . %  The format of the DescribeImage routine is: % ( %      DescribeImage(image,file,verbose) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 4 %    o file: send the image attributes to this file. % M %    o verbose: an unsigned value other than zero prints detailed information  %      about the image.  %  %  */F void DescribeImage(Image *image,FILE *file,const unsigned int verbose) {    char     **textlist;      Image      *p;      register int     i;     unsigned int
     count;     if (!verbose)      {        /*.         Display detailed info about the image.       */*       if (*image->magick_filename != '\0')@         if (strcmp(image->magick_filename,image->filename) != 0)=           (void) fprintf(file,"%s=>",image->magick_filename); 1        if ((image->previous == (Image *) NULL) && B            (image->next == (Image *) NULL) && (image->scene == 0))3         (void) fprintf(file,"%s ",image->filename); 
       elseD         (void) fprintf(file,"%s[%u] ",image->filename,image->scene);D       if ((image->magick_columns != 0) || (image->magick_rows != 0))8         if ((image->magick_columns != image->columns) ||0             (image->magick_rows != image->rows))>           (void) fprintf(file,"%ux%u=>",image->magick_columns,              image->magick_rows);'       if (image->page == (char *) NULL) A         (void) fprintf(file,"%ux%u ",image->columns,image->rows); 
       else	         { 
           int              x,             y;             unsigned int             sans;   ?           (void) XParseGeometry(image->page,&x,&y,&sans,&sans); M           (void) fprintf(file,"%ux%u%+d%+d ",image->columns,image->rows,x,y); 	         } &       if (image->class == DirectClass)	         { .           (void) fprintf(file,"DirectClass ");'           if (image->total_colors != 0) =             (void) fprintf(file,"%luc ",image->total_colors); 	         } 
       else1         if (image->total_colors <= image->colors) @           (void) fprintf(file,"PseudoClass %uc ",image->colors);         else           { L             (void) fprintf(file,"PseudoClass %lu=>%uc ",image->total_colors,               image->colors); M             (void) fprintf(file,"%u/%.6f/%.6fe ",image->mean_error_per_pixel, L               image->normalized_mean_error,image->normalized_maximum_error);           }        if (image->filesize != 0) 5         (void) fprintf(file,"%ldb ",image->filesize); J       (void) fprintf(file,"%s %lds\n",image->magick,time((time_t *) NULL)-         image->magick_time+1);
       return;      }    /*)     Display verbose info about the image.    */5   (void) fprintf(file,"Image: %s\n",image->filename); "   if (image->class == DirectClass)2     (void) fprintf(file,"  class: DirectClass\n");   else2     (void) fprintf(file,"  class: PseudoClass\n");"   if (image->class == DirectClass)     { "       if (image->total_colors > 0)C         (void) fprintf(file,"  colors: %lu\n",image->total_colors);      }    else-     if (image->total_colors <= image->colors) :       (void) fprintf(file,"  colors: %u\n",image->colors);     elseD       (void) fprintf(file,"  colors: %lu=>%u\n",image->total_colors,         image->colors); "   if (image->class == DirectClass)     { %       if (image->total_colors < 1024) !         NumberColors(image,file);      }    else     { 
       char         name[MaxTextLength];         ColorPacket          *p;          double         distance_squared,          min_distance;   	       int          distance;          register int
         i;         register XColorlist          *q;          /*         Display image colormap.        */       p=image->colormap;'       for (i=0; i < image->colors; i++)        { C         (void) fprintf(file,"    %d: (%3d,%3d,%3d)  #%02x%02x%02x", :           i,p->red,p->green,p->blue,(unsigned int) p->red,:           (unsigned int) p->green,(unsigned int) p->blue);)         min_distance=3.0*65536.0*65536.0; 8         for (q=Colorlist; q->name != (char *) NULL; q++)	         { 8           distance=(int) DownScale(p->red)-(int) q->red;>           distance_squared=(unsigned int) (distance*distance);<           distance=(int) DownScale(p->green)-(int) q->green;?           distance_squared+=(unsigned int) (distance*distance); :           distance=(int) DownScale(p->blue)-(int) q->blue;?           distance_squared+=(unsigned int) (distance*distance); .           if (distance_squared < min_distance)
             { ,               min_distance=distance_squared;*               (void) strcpy(name,q->name);
             } 	         } "         (void) fprintf(file,"  ");         if (min_distance < 16)           { !             if (min_distance > 0) '               (void) fprintf(file,"~"); +             (void) fprintf(file,"%s",name);            } "         (void) fprintf(file,"\n");         p++;       }      } (   if (image->signature != (char *) NULL)>     (void) fprintf(file,"  signature: %s\n",image->signature);   if (image->matte) +     (void) fprintf(file,"  matte: True\n");    else,     (void) fprintf(file,"  matte: False\n");   if (image->gamma != 0.0)6     (void) fprintf(file,"  depth: %f\n",image->gamma);4   if (image->packets < (image->columns*image->rows))I     (void) fprintf(file,"  runlength packets: %u of %u\n",image->packets, "       image->columns*image->rows);H   (void) fprintf(file,"  geometry: %ux%u\n",image->columns,image->rows);4   (void) fprintf(file,"  depth: %u\n",image->depth);   if (image->filesize != 0) :     (void) fprintf(file,"  bytes: %ld\n",image->filesize);   if (image->interlace) 0     (void) fprintf(file,"  interlaced: True\n");   else1     (void) fprintf(file,"  interlaced: False\n"); #   if (image->page != (char *) NULL) =     (void) fprintf(file,"  page geometry: %s\n",image->page); $   if (image->delay != (char *) NULL)6     (void) fprintf(file,"  delay: %s\n",image->delay);6   (void) fprintf(file,"  format: %s\n",image->magick);
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)B     (void) fprintf(file,"  scene: %u of %u\n",image->scene,count);   else     if (image->scene != 0)8       (void) fprintf(file,"  scene: %u\n",image->scene);$   if (image->label != (char *) NULL)6     (void) fprintf(file,"  label: %s\n",image->label);'   if (image->comments != (char *) NULL)      {        /*         Display image comment.       */+       (void) fprintf(file,"  comments:\n"); -       textlist=StringToList(image->comments); %       if (textlist != (char **) NULL) 	         { 6           for (i=0; textlist[i] != (char *) NULL; i++)           { 6             (void) fprintf(file,"  %s\n",textlist[i]);             free(textlist[i]);           } "           free((char *) textlist);	         }      } &   if (image->montage != (char *) NULL):     (void) fprintf(file,"  montage: %s\n",image->montage);(   if (image->directory != (char *) NULL)     { 
       char          filename[MaxTextLength];         Image          *tile;         ImageInfo          image_info;          register char          *p,          *q;          /*'         Display visual image directory.        */        GetImageInfo(&image_info);#       image_info.filename=filename;        image_info.size="64x64";,       (void) fprintf(file,"  directory:\n");/       for (p=image->directory; *p != '\0'; p++)        {          q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;2         (void) strncpy(image_info.filename,p,q-p);&         image_info.filename[q-p]='\0';         p=q;:         (void) fprintf(file,"    %s",image_info.filename);$         tile=ReadImage(&image_info);#         if (tile == (Image *) NULL)            { &             (void) fprintf(file,"\n");             continue;            } ?         (void) fprintf(file," %ux%u %s\n",tile->magick_columns, *           tile->magick_rows,tile->magick);,         if (tile->comments != (char *) NULL)           {              /*#               Display tile comment.              */2             textlist=StringToList(tile->comments);+             if (textlist != (char **) NULL)                { <                 for (i=0; textlist[i] != (char *) NULL; i++)                 { >                   (void) fprintf(file,"    %s\n",textlist[i]);$                   free(textlist[i]);                 } (                 free((char *) textlist);               }            }          DestroyImage(tile);        }      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     D e s p e c k l e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function DespeckleImage creates a new image that is a copy of an existingI %  one with the speckle noise minified.  It uses the eight hull algorithm O %  described in Applied Optics, Vol. 24, No. 10, 15 May 1985, "Geometric filter L %  for Speckle Reduction", by Thomas R Crimmins.  Each pixel in the image isN %  replaced by one of its eight of its surrounding pixels using a polarity andM %  negative hull function.  DespeckleImage allocates the memory necessary for B %  the new Image structure and returns a pointer to the new image. % / %  The format of the DespeckleImage routine is:  % - %      despeckled_image=DespeckleImage(image)  % + %  A description of each parameter follows:  % O %    o despeckled_image: Function DespeckleImage returns a pointer to the image M %      after it is despeckled.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  8 static void Hull(int x_offset,int y_offset,int polarity,?   unsigned int columns,unsigned int rows,Quantum *f,Quantum *g)  {    int      y;     register int     x;     register Quantum     *p,      *q,      *r,      *s;   	   Quantum      v;     p=f+(columns+2);   q=g+(columns+2);,   r=p+(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*p);          if (*r > v)            v++;
         *q=v;          p++;         q++;         r++;       }      else!       for (x=0; x < columns; x++)        {          v=(*p); !         if (v > (Quantum) (*r+1))            v--;
         *q=v;          p++;         q++;         r++;       }      p++;     q++;     r++;   }    p=f+(columns+2);   q=g+(columns+2);,   r=q+(y_offset*((int) columns+2)+x_offset);,   s=q-(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     s++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) > v) && (*r > v))            v++;
         *p=v;          p++;         q++;         r++;         s++;       }      else!       for (x=0; x < columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) < v) && (*r < v))            v--;
         *p=v;          p++;         q++;         r++;         s++;       }      p++;     q++;     r++;     s++;   }  }   # Image *DespeckleImage(Image *image)  { 6 #define DespeckleImageText  "  Despeckling image...  "     Image      *despeckled_image;     int      x;  	   Quantum      *blue_channel,     *buffer,     *green_channel,      *matte_channel,      *red_channel;      register int     i,     j;     register RunlengthPacket     *p,      *q;      static int     X[4]= {0, 1, 1,-1},      Y[4]= {1, 0, 1, 1};      unsigned int     packets;     /*     Allocate despeckled image.   */E   despeckled_image=CopyImage(image,image->columns,image->rows,False); )   if (despeckled_image == (Image *) NULL)      { F       Warning("Unable to despeckle image","Memory allocation failed");       return((Image *) NULL);      } &   despeckled_image->class=DirectClass;   /*     Allocate image buffers.    */-   packets=(image->columns+2)*(image->rows+2); :   red_channel=(Quantum *) malloc(packets*sizeof(Quantum));<   green_channel=(Quantum *) malloc(packets*sizeof(Quantum));;   blue_channel=(Quantum *) malloc(packets*sizeof(Quantum)); <   matte_channel=(Quantum *) malloc(packets*sizeof(Quantum));5   buffer=(Quantum *) malloc(packets*sizeof(Quantum)); *   if ((red_channel == (Quantum *) NULL) ||,       (green_channel == (Quantum *) NULL) ||+       (blue_channel == (Quantum *) NULL) || ,       (matte_channel == (Quantum *) NULL) ||>       (buffer == (Quantum *) NULL) || !UncompressImage(image))     { F       Warning("Unable to despeckle image","Memory allocation failed");%       DestroyImage(despeckled_image);        return((Image *) NULL);      }    /*     Zero image buffers.    */   for (i=0; i < packets; i++)    {      red_channel[i]=0;      green_channel[i]=0;      blue_channel[i]=0;     matte_channel[i]=0;      buffer[i]=0;   }    /*0     Copy image pixels to color component buffers   */   x=image->columns+2;    p=image->pixels;!   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        red_channel[x]=p->red;        green_channel[x]=p->green;       blue_channel[x]=p->blue;        matte_channel[x]=p->index;
       x++;
       p++;     }      x++;   }    /*"     Reduce speckle in red channel.   */   for (i=0; i < 4; i++)    { -     ProgressMonitor(DespeckleImageText,i,12); D     Hull(X[i],Y[i],1,image->columns,image->rows,red_channel,buffer);F     Hull(-X[i],-Y[i],1,image->columns,image->rows,red_channel,buffer);G     Hull(-X[i],-Y[i],-1,image->columns,image->rows,red_channel,buffer); E     Hull(X[i],Y[i],-1,image->columns,image->rows,red_channel,buffer);    }    /*$     Reduce speckle in green channel.   */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { /     ProgressMonitor(DespeckleImageText,i+4,12); F     Hull(X[i],Y[i],1,image->columns,image->rows,green_channel,buffer);H     Hull(-X[i],-Y[i],1,image->columns,image->rows,green_channel,buffer);I     Hull(-X[i],-Y[i],-1,image->columns,image->rows,green_channel,buffer); G     Hull(X[i],Y[i],-1,image->columns,image->rows,green_channel,buffer);    }    /*#     Reduce speckle in blue channel.    */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { /     ProgressMonitor(DespeckleImageText,i+8,12); E     Hull(X[i],Y[i],1,image->columns,image->rows,blue_channel,buffer); G     Hull(-X[i],-Y[i],1,image->columns,image->rows,blue_channel,buffer); H     Hull(-X[i],-Y[i],-1,image->columns,image->rows,blue_channel,buffer);F     Hull(X[i],Y[i],-1,image->columns,image->rows,blue_channel,buffer);   }    /*5     Copy color component buffers to despeckled image.    */   x=image->columns+2;    q=despeckled_image->pixels; !   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        q->red=red_channel[x];        q->green=green_channel[x];       q->blue=blue_channel[x];        q->index=matte_channel[x];       q->length=0;
       q++;
       x++;     }      x++;   }    /*     Free memory.   */   free((char *) buffer);   free((char *) blue_channel);   free((char *) green_channel);    free((char *) red_channel);    return(despeckled_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function DestroyImage deallocates memory associated with an image.  % - %  The format of the DestroyImage routine is:  %  %      DestroyImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DestroyImage(Image *image)  {    if (image == (Image *) NULL)     return;    /*     Close image.   */   CloseImage(image);   /*"     Deallocate the image comments.   */'   if (image->comments != (char *) NULL) #     free((char *) image->comments);    /*     Deallocate the image label.    */$   if (image->label != (char *) NULL)      free((char *) image->label);   /*+     Deallocate the image montage directory.    */&   if (image->montage != (char *) NULL)"     free((char *) image->montage);(   if (image->directory != (char *) NULL)$     free((char *) image->directory);   /*"     Deallocate the image colormap.   */.   if (image->colormap != (ColorPacket *) NULL)#     free((char *) image->colormap);    /*#     Deallocate the image signature.    */(   if (image->signature != (char *) NULL)$     free((char *) image->signature);   /*      Deallocate the image pixels.   */0   if (image->pixels != (RunlengthPacket *) NULL)!     free((char *) image->pixels); 5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);   /*'     Deallocate the image page geometry.    */#   if (image->page != (char *) NULL)      free((char *) image->page);    /*     Deallocate the image delay.    */$   if (image->delay != (char *) NULL)      free((char *) image->delay);   /*#     Deallocate the image structure.    */   free((char *) image);    image=(Image *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DestroyImages deallocates memory associated with a linked list
 %  of images.  % . %  The format of the DestroyImages routine is: %  %      DestroyImages(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */  void DestroyImages(Image *image) {    Image      *next_image;     if (image == (Image *) NULL)     return;    /*)     Proceed to the top of the image list.    */+   while (image->previous != (Image *) NULL)      image=image->previous;   do   {      /*       Destroy this image.      */     next_image=image->next;      DestroyImage(image);     image=next_image; $   } while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D r a w I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function DrawImage draws a primitive (line, rectangle, ellipse) on the 	 %  image.  % * %  The format of the DrawImage routine is: % % %      DrawImage(image,annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % : %    o annotate_info: The address of a DrawInfo structure. %  %  */  B static unsigned int InsidePrimitive(PrimitiveInfo *primitive_info,7   AnnotateInfo *annotate_info,int x,int y,Image *image)  {    register unsigned int      inside;      register PrimitiveInfo     *p,      *q;      inside=False;    p=primitive_info; ,   while (p->primitive != UndefinedPrimitive)   {      q=p+p->coordinates-1;      switch (p->primitive)      { "       case FillRectanglePrimitive:       default:       { H         inside=(x >= p->x) && (y >= p->y) && (x <= q->x) && (y <= q->y);         p+=p->coordinates;         break;       }         case FillEllipsePrimitive:       { ;         inside=(((p->y-y)*(p->y-y))+((p->x-x)*(p->x-x))) <= @           (((p->y-q->y)*(p->y-q->y))+((p->x-q->x)*(p->x-q->x)));         p+=p->coordinates;         break;       }         case FillPolygonPrimitive:       {          int            crossing,            crossings;           crossings=0;'         if ((q->y >= y) != (p->y >= y))            {              crossing=q->x >= x; (             if (crossing != (p->x >= x))F               crossings+=(q->x-(q->y-y)*(p->x-q->x)/(p->y-q->y)) >= x;             else               if (crossing)                  crossings++;           }          for (p++; p <= q; p++)	         {            if ((p-1)->y >= y)
             { -               while ((p <= q) && (p->y >= y))                  p++;               if (p > q)                 break;%               crossing=(p-1)->x >= x; *               if (crossing != (p->x >= x))                 crossings+= O                   ((p-1)->x-((p-1)->y-y)*(p->x-(p-1)->x)/(p->y-(p-1)->y)) >= x;                else                 if (crossing)                    crossings++;               continue; 
             } '          while ((p <= q) && (p->y < y))             p++;           if (p > q)             break;            crossing=(p-1)->x >= x;%          if (crossing != (p->x >= x))             crossings+=J              ((p-1)->x-((p-1)->y-y)*(p->x-(p-1)->x)/(p->y-(p-1)->y)) >= x;
          else             if (crossing)              crossings++; 	         }           inside=crossings & 0x01;         break;       }        case TextPrimitive:        case ImagePrimitive:       {          register char 
           *q;   '         if ((p->x != x) || (p->y != y))            {              p+=p->coordinates;             break;           }          q=p->text;         if (*q != '"')6           for (q++; (*q != ' ') && (*q != '\0'); q++);         else           {              p->text++;8             for (q++; (*q != '"') && (*q != '\0'); q++);           } >         (void) strncpy(annotate_info->text,p->text,q-p->text);,         annotate_info->text[q-p->text]='\0';*         if (p->primitive == TextPrimitive)           { G             (void) sprintf(annotate_info->geometry,"%+d%+d",p->x,p->y); /             AnnotateImage(image,annotate_info);            }          else           {              Image                *composite_image;                ImageInfo                composite_info;   *             GetImageInfo(&composite_info);G             (void) strcpy(composite_info.filename,annotate_info->text); 7             composite_image=ReadImage(&composite_info); 2             if (composite_image != (Image *) NULL)               { H                 CompositeImage(image,ReplaceCompositeOp,composite_image,                   p->x,p->y); .                 DestroyImage(composite_image);               }            }          p+=p->coordinates;         break;       }      }      if (inside)        return(True);    }    return(inside);  }   8 void DrawImage(Image *image,AnnotateInfo *annotate_info) { 0 #define DrawImageText  "  Drawing on image...  "     char
     *stop;     int      y;     PrimitiveInfo      *primitive_info;     register char      *p;      register int     i,     j,     x;     register RunlengthPacket     *q;      unsigned int     indirection,     length,      number_coordinates,      primitive;     XColor     pen_color;  0   if (annotate_info->primitive == (char *) NULL)     return;    if (!UncompressImage(image))     return; 1   indirection=(*annotate_info->primitive == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         register char          *q;          /*         Read text from a file.       */:       file=(FILE *) fopen(annotate_info->primitive+1,"r");        if (file == (FILE *) NULL)	         { N           Warning("Unable to read primitive file",annotate_info->primitive+1);           return; 	         }        length=MaxTextLength; 7       annotate_info->primitive=(char *) malloc(length); !       q=annotate_info->primitive; 7       while (annotate_info->primitive != (char *) NULL)        {          c=fgetc(file);         if (c == EOF)            break;5         if ((q-annotate_info->primitive+1) >= length)            {              *q='\0';             length<<=1; -             annotate_info->primitive=(char *) 7               realloc(annotate_info->primitive,length); :             if (annotate_info->primitive == (char *) NULL)               break;H             q=annotate_info->primitive+strlen(annotate_info->primitive);           }          *q++=(unsigned char) c;        }        (void) fclose(file);4       if (annotate_info->primitive == (char *) NULL)	         { E           Warning("Unable to draw image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*#     Allocate primitive info memory.    */   number_coordinates=2048;"   primitive_info=(PrimitiveInfo *)5     malloc(number_coordinates*sizeof(PrimitiveInfo)); F   annotate_info->geometry=(char *) malloc(MaxTextLength*sizeof(char));   annotate_info->text=(char *):     malloc(strlen(annotate_info->primitive)*sizeof(char));3   if ((primitive_info == (PrimitiveInfo *) NULL) || 3       (annotate_info->geometry == (char *) NULL) || -       (annotate_info->text == (char *) NULL))      {        if (indirection)0         free((char *) annotate_info->primitive);A       Warning("Unable to draw image","Memory allocation failed"); 
       return;      }    /*#     Parse the primitive attributes.    */<   (void) XQueryColorDatabase(annotate_info->pen,&pen_color);   image->class=DirectClass;    primitive=UndefinedPrimitive;    p=annotate_info->primitive;    for (i=0; *p != '\0'; )    {      while (isspace(*p)) 
       p++;!     primitive=UndefinedPrimitive; &     if (strncmp("rectangle",p,4) == 0)'       primitive=FillRectanglePrimitive; #     if (strncmp("circle",p,4) == 0) %       primitive=FillEllipsePrimitive; $     if (strncmp("polygon",p,4) == 0)%       primitive=FillPolygonPrimitive; !     if (strncmp("text",p,4) == 0)        primitive=TextPrimitive;"     if (strncmp("image",p,4) == 0)       primitive=ImagePrimitive; (     if (primitive == UndefinedPrimitive)       break;     while (isalpha(*p)) 
       p++;     j=i;     for (x=0; *p != '\0'; x++)     {        while (isspace(*p))          p++;       if (!isdigit(*p))          break;,       primitive_info[i].primitive=primitive;&       primitive_info[i].coordinates=0;,       primitive_info[i].x=strtol(p,&stop,0);
       p=stop; (       while (isspace(*p) || (*p == ','))         p++;       if (!isdigit(*p))          break;,       primitive_info[i].y=strtol(p,&stop,0);
       p=stop; 
       i++;&       if (i == (number_coordinates-1))	         { !           number_coordinates<<=1; *           primitive_info=(PrimitiveInfo *)M             realloc(primitive_info,number_coordinates*sizeof(PrimitiveInfo)); 7           if (primitive_info == (PrimitiveInfo *) NULL) 
             {                if (indirection)8                 free((char *) annotate_info->primitive);5               free((char *) annotate_info->geometry); 1               free((char *) annotate_info->text); I               Warning("Unable to draw image","Memory allocation failed");                return; 
             } 	         }      } $     primitive_info[j].coordinates=x;)     primitive_info[j].text=(char *) NULL; F     if ((primitive == TextPrimitive) || (primitive == ImagePrimitive))       { !         primitive_info[j].text=p;          if (*p == '"')6           for (p++; (*p != '"') && (*p != '\0'); p++);         else6           for (p++; (*p != ' ') && (*p != '\0'); p++);         if (*p != '\0')            p++;       }    } 1   primitive_info[i].primitive=UndefinedPrimitive; &   if (primitive == UndefinedPrimitive)     { ?       Warning("Non-conforming drawing primitive definition",p); $       free((char *) primitive_info);       if (indirection)0         free((char *) annotate_info->primitive);-       free((char *) annotate_info->geometry); )       free((char *) annotate_info->text); 
       return;      }    /*$     Draw the primitive on the image.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { B       if (InsidePrimitive(primitive_info,annotate_info,x,y,image))	         { +           q->red=XDownScale(pen_color.red); /           q->green=XDownScale(pen_color.green); -           q->blue=XDownScale(pen_color.blue); 	         } 
       q++;     } 1     ProgressMonitor(DrawImageText,y,image->rows);    }     free((char *) primitive_info);   if (indirection),     free((char *) annotate_info->primitive);)   free((char *) annotate_info->geometry); %   free((char *) annotate_info->text);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E m b o s s I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function EmbossImage creates a new image that is a copy of an existing L %  one with the edge highlighted.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % N %  EmbossImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -2  0 
 %    -2  0  2 
 %     0  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the EmbossImage routine is: % ( %      embossed_image=EmbossImage(image) % + %  A description of each parameter follows:  % J %    o embossed_image: Function EmbossImage returns a pointer to the imageK %      after it is embossed.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  Image *EmbossImage(Image *image) { 1 #define EmbossImageText  "  Embossing image...  "  #define Emboss(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *embossed_image;     long     total_blue,      total_green,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to emboss image","image size must exceed 3x3");        return((Image *) NULL);      }    /*)     Initialize embossed image attributes.    */C   embossed_image=CopyImage(image,image->columns,image->rows,False); '   if (embossed_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   embossed_image->class=DirectClass;   /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(embossed_image);        return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=embossed_image->pixels; $   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0; 
       s=s1+1;        s=s0; )       Emboss(-1); Emboss(-2); Emboss( 0);        s=s1; )       Emboss(-2); Emboss( 0); Emboss( 2);        s=s2; )       Emboss( 0); Emboss( 2); Emboss( 1); !       total_red+=(MaxRGB+1) >> 1;        if (total_red < 0)         total_red=0;
       else         if (total_red > MaxRGB)            total_red=MaxRGB; #       total_green+=(MaxRGB+1) >> 1;        if (total_green < 0)         total_green=0;
       else!         if (total_green > MaxRGB)            total_green=MaxRGB; "       total_blue+=(MaxRGB+1) >> 1;       if (total_blue < 0)          total_blue=0; 
       else          if (total_blue > MaxRGB)           total_blue=MaxRGB;!       q->red=(Quantum) total_red; %       q->green=(Quantum) total_green; #       q->blue=(Quantum) total_blue;        q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;5     ProgressMonitor(EmbossImageText,y,image->rows-1);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*-     Convert image to grayscale and normalize.    */$   embossed_image->class=DirectClass;%   (void) IsGrayImage(embossed_image); !   NormalizeImage(embossed_image);    return(embossed_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E d g e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function EdgeImage creates a new image that is a copy of an existing M %  one with the edges highlighted.  It allocates the memory necessary for the > %  new Image structure and returns a pointer to the new image. % L %  EdgeImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1  0 -1 
 %     0  W  0 
 %    -1  0 -1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the EdgeImage routine is: % * %      edged_image=EdgeImage(image,factor) % + %  A description of each parameter follows:  % E %    o edged_image: Function EdgeImage returns a pointer to the image H %      after it is edged.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */, Image *EdgeImage(Image *image,double factor) {  #define Edge(weight) \0   total_red+=(long) ((weight)*(int) (s->red)); \4   total_green+=(long) ((weight)*(int) (s->green)); \2   total_blue+=(long) ((weight)*(int) (s->blue)); \4   total_index+=(long) ((weight)*(int) (s->index)); \   s++;5 #define EdgeImageText  "  Detecting image edges...  "      double     weight;      Image      *edged_image;      long     total_blue,      total_green,     total_index,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to detect edges","image size must exceed 3x3");        return((Image *) NULL);      }    /*&     Initialize edged image attributes.   */@   edged_image=CopyImage(image,image->columns,image->rows,False);$   if (edged_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } !   edged_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");        DestroyImage(edged_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=edged_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */!   weight=((100.0-factor)/20)+1.5; %   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_index=0;
       s=s1+1;        s=s0; 1       Edge(-weight/4); Edge( 0); Edge(-weight/4);        s=s1; '       Edge( 0); Edge(weight); Edge( 0);        s=s2; 1       Edge(-weight/4); Edge( 0); Edge(-weight/4);        if (total_red < 0)         q->red=0; 
       else         if (total_red > MaxRGB)            q->red=MaxRGB;         else%           q->red=(Quantum) total_red;        if (total_green < 0)         q->green=0; 
       else!         if (total_green > MaxRGB)            q->green=MaxRGB;         else)           q->green=(Quantum) total_green;        if (total_blue < 0)          q->blue=0;
       else          if (total_blue > MaxRGB)           q->blue=MaxRGB;          else'           q->blue=(Quantum) total_blue;        if (total_index < 0)         q->index=0; 
       else!         if (total_index > MaxRGB)            q->index=MaxRGB;         else0           q->index=(unsigned short) total_index;       q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;3     ProgressMonitor(EdgeImageText,y,image->rows-1);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*     Normalize image.   */   NormalizeImage(edged_image);   return(edged_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E n h a n c e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EnhanceImage creates a new image that is a copy of an existingN %  one with the noise minified.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % K %  EnhanceImage does a weighted average of pixels in a 5x5 cell around each L %  target pixel.  Only pixels in the 5x5 cell that are within a RGB distance. %  threshold of the target pixel are averaged. % G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % - %  The format of the EnhanceImage routine is:  % ) %      enhanced_image=EnhanceImage(image)  % + %  A description of each parameter follows:  % K %    o enhanced_image: Function EnhanceImage returns a pointer to the image K %      after it is enhanced.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */! Image *EnhanceImage(Image *image)  {  #define Enhance(weight) \ $   distance=(int) s->red-(int) red; \'   distance_squared=squares[distance]; \ (   distance=(int) s->green-(int) green; \(   distance_squared+=squares[distance]; \&   distance=(int) s->blue-(int) blue; \(   distance_squared+=squares[distance]; \%   if (distance_squared < Threshold) \      { \ %       total_red+=(weight)*(s->red); \ )       total_green+=(weight)*(s->green); \ '       total_blue+=(weight)*(s->blue); \        total_weight+=(weight); \      } \    s++;2 #define EnhanceImageText  "  Enhancing image...  " #define Threshold  2500      double     distance_squared;      Image      *enhanced_image;     int 
     distance,      i;  	   Quantum 	     blue, 
     green,     red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned int 
     *squares;      RunlengthPacket      *scanline;     unsigned int     x,     y;     unsigned long%     total_blue,%     total_green,     total_red,     total_weight;   0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to enhance image","image size must exceed 4x4");       return((Image *) NULL);      }    /*)     Initialize enhanced image attributes.    */C   enhanced_image=CopyImage(image,image->columns,image->rows,False); '   if (enhanced_image == (Image *) NULL)E     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   enhanced_image->class=DirectClass;   /*6     Allocate scan line buffer for 5 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));J   squares=(unsigned int *) malloc((MaxRGB+MaxRGB+1)*sizeof(unsigned int));/   if ((scanline == (RunlengthPacket *) NULL) || )       (squares == (unsigned int *) NULL))i     {eD       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(enhanced_image);        return((Image *) NULL);      }    squares+=MaxRGB;%   for (i=(-MaxRGB); i <= MaxRGB; i++)      squares[i]=i*i;    /*'     Read the first 4 rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; (   for (x=0; x < (image->columns*4); x++)   {o     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*$     Dump first 2 scanlines of image.   */   q=enhanced_image->pixels; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)I   {P     *q=(*s);     q->length=0;     q++;     s++;   }    /*     Enhance each row.    */%   for (y=2; y < (image->rows-2); y++)    {P     /*)       Initialize sliding window pointers.l     */+     s0=scanline+image->columns*((y-2) % 5);y+     s1=scanline+image->columns*((y-1) % 5); '     s2=scanline+image->columns*(y % 5);g+     s3=scanline+image->columns*((y+1) % 5); +     s4=scanline+image->columns*((y+2) % 5);i     /*       Read another scan line.      */	     s=s4;t&     for (x=0; x < image->columns; x++)     {m        if (image->runlength != 0)         image->runlength--;i
       else	         {            p++;%           image->runlength=p->length; 	         }o       *s=(*p);
       s++;     }      /*.       Transfer first 2 pixels of the scanline.     */	     s=s2;t     for (x=0; x < 2; x++)w     {        *q=(*s);       q->length=0;
       q++;
       s++;     }m*     for (x=2; x < (image->columns-2); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;e       total_weight=0;f
       s=s2+2;g       red=s->red;t       green=s->green;        blue=s->blue;s       s=s0; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5);        s=s1;rE       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s2;mF       Enhance(10); Enhance(40); Enhance(80); Enhance(40); Enhance(10);       s=s3; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);t       s=s4;pE       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5); H       q->red=(Quantum) ((total_red+(total_weight >> 1)-1)/total_weight);M       q->green= (Quantum) ((total_green+(total_weight >> 1)-1)/total_weight); J       q->blue=(Quantum) ((total_blue+(total_weight >> 1)-1)/total_weight);       q->index=s2->index;e       q->length=0;
       q++;       s0++;o       s1++;*       s2++;%       s3++;%       s4++;%     }%     /*-       Transfer last 2 pixels of the scanline.      */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     } 6     ProgressMonitor(EnhanceImageText,y,image->rows-2);   }    /*$     Dump last 2 scanlines of pixels.   */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    squares-=MaxRGB;   free((char *) squares);    free((char *) scanline);   return(enhanced_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %     E q u a l i z e I m a g e                                               %lO %                                                                             % O %                                                                             %sO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %uJ %  Function EqualizeImage performs histogram equalization on the reference	 %  image.  %a. %  The format of the EqualizeImage routine is: %u %      EqualizeImage(image)= %a+ %  A description of each parameter follows:_ %gF %    o image: The address of a structure of type Image;  returned from %      ReadImage.a %d %  */  void EqualizeImage(Image *image) { 4 #define EqualizeImageText  "  Equalizing image...  "  	   Quantuml     *equalize_map;     register int     i,     j;     register RunlengthPacket     *p;a     unsigned int	     high,;     *histogram,g     low,	     *map;o     /*-     Allocate and initialize histogram arrays.g   */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int));m?   map=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int));;>   equalize_map=(Quantum *) malloc((MaxRGB+1)*sizeof(Quantum));O   if ((histogram == (unsigned int *) NULL) || (map == (unsigned int *) NULL) ||n)       (equalize_map == (Quantum *) NULL))g     {mE       Warning("Unable to equalize image","Memory allocation failed");t
       return;_     }i   /*     Form histogram.e   */   for (i=0; i <= MaxRGB; i++)-     histogram[i]=0;p   p=image->pixels;$   for (i=0; i < image->packets; i++)   {_,     histogram[Intensity(*p)]+=(p->length+1);     p++;   }*   /*8     Integrate the histogram to get the equalization map.   */   j=0;   for (i=0; i <= MaxRGB; i++)    {a     j+=histogram[i];
     map[i]=j;_   }-   free((char *) histogram);-   if (map[MaxRGB] == 0)_     {n"       free((char *) equalize_map);       free((char *) map);n
       return;      }e   /*
     Equalize.e   */
   low=map[0];e   high=map[MaxRGB];=   for (i=0; i <= MaxRGB; i++)e     equalize_map[i]=(Quantum)m9       ((((double) (map[i]-low))*MaxRGB)/Max(high-low,1));p   free((char *) map);*   /*     Stretch the histogram.   */   switch (image->class)e   {e     case DirectClass:-     {_       /*%         Equalize DirectClass packets.e       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {g$         p->red=equalize_map[p->red];(         p->green=equalize_map[p->green];&         p->blue=equalize_map[p->blue];         p++;!         if (QuantumTick(i,image))g>           ProgressMonitor(EqualizeImageText,i,image->packets);       }m       break;     }*     case PseudoClass:m     {s       /*%         Equalize PseudoClass packets.e       */'       for (i=0; i < image->colors; i++)        { D         image->colormap[i].red=equalize_map[image->colormap[i].red];H         image->colormap[i].green=equalize_map[image->colormap[i].green];F         image->colormap[i].blue=equalize_map[image->colormap[i].blue];       }G       SyncImage(image);)       break;     }n   }a   free((char *) equalize_map); }a _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %%O %                                                                             % O %                                                                             % O %   F l i p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlipImage creates a new image that reflects each scanline in theI %  vertical direction It allocates the memory necessary for the new ImageO4 %  structure and returns a pointer to the new image. %a* %  The format of the FlipImage routine is: %y% %      flipped_image=FlipImage(image)E %d+ %  A description of each parameter follows:w %hG %    o flipped_image: Function FlipImage returns a pointer to the imageeG %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.1 %n %e */ Image *FlipImage(Image *image) {A. #define FlipImageText  "  Flipping image...  "     Imagen     *flipped_image;A     register RunlengthPacket     *p,      *q,      *s;      register unsigned into     x,     y;     RunlengthPacketn     *scanline;     /*(     Initialize flipped image attributes.   */B   flipped_image=CopyImage(image,image->columns,image->rows,False);&   if (flipped_image == (Image *) NULL)     { A       Warning("Unable to flip image","Memory allocation failed");        return((Image *) NULL);r     }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)t     { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flipped_image);       return((Image *) NULL);t     }m   /*     Flip each row.   */   p=image->pixels;   image->runlength=p->length+1;t3   q=flipped_image->pixels+flipped_image->packets-1;t)   for (y=0; y < flipped_image->rows; y++)h   {      /*       Read a scan line.t     */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {t           p++;%           image->runlength=p->length;n	         }-       *s=(*p);
       s++;     }F     /*       Flip each column.      */     s=scanline+image->columns;.     for (x=0; x < flipped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q--;     }o9     ProgressMonitor(FlipImageText,y,flipped_image->rows);-   }    free((char *) scanline);   return(flipped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             %aO %                                                                             %oO %                                                                             %iO %   F l o p I m a g e                                                         %cO %                                                                             %*O %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %(L %  Function FlopImage creates a new image that reflects each scanline in theK %  horizontal direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %t* %  The format of the FlopImage routine is: %e% %      flopped_image=FlopImage(image)) %a+ %  A description of each parameter follows:f %mG %    o flopped_image: Function FlopImage returns a pointer to the imagelG %      after reflecting.  A null image is returned if there is a memoryn %      shortage. %f7 %    o image: The address of a structure of type Image.+ %n %  */ Image *FlopImage(Image *image) { . #define FlopImageText  "  Flopping image...  "     Image      *flopped_image;      register RunlengthPacket     *p,      *q,'     *s;      register unsigned intf     x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flopped image attributes.   */B   flopped_image=CopyImage(image,image->columns,image->rows,False);&   if (flopped_image == (Image *) NULL)     {tD       Warning("Unable to reflect image","Memory allocation failed");       return((Image *) NULL);m     }l   /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)_     { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flopped_image);       return((Image *) NULL);      }    /*     Flop each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=flopped_image->pixels;)   for (y=0; y < flopped_image->rows; y++)n   {e     /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {_        if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length;p	         }        *s=(*p);
       s++;     }f     /*       Flop each column.      */     s=scanline+image->columns;.     for (x=0; x < flopped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q++;     }h9     ProgressMonitor(FlopImageText,y,flopped_image->rows);-   })   free((char *) scanline);   return(flopped_image); }  ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0O %                                                                             % O %                                                                             % O %                                                                             %oO %   F r a m e I m a g e                                                       %;O %                                                                             %oO %                                                                             %rO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function FrameImage takes an image and puts a frame around it of a I %  particular color.  It allocates the memory necessary for the new Image/4 %  structure and returns a pointer to the new image. % + %  The format of the FrameImage routine is:v %n0 %      framed_image=FrameImage(image,frame_info) % + %  A description of each parameter follows:v % H %    o framed_image: Function FrameImage returns a pointer to the framedH %      image.  A null image is returned if there is a a memory shortage. %/7 %    o image: The address of a structure of type Image.y %iE %    o frame_info: Specifies a pointer to a FrameInfo structure whiche! %      defines the framed region.i %. %s */5 Image *FrameImage(Image *image,FrameInfo *frame_info)o {m6 #define FrameImageText  "  Adding frame to image...  "     Image      *framed_image;     intt     height, 
     width;     register int     x,     y;     register RunlengthPacket     *p,r     *q;r     RunlengthPacket      highlight,
     matte,     shadow;      unsigned int     bevel_width;     /*     Check frame geometry.;   */E   if ((frame_info->outer_bevel < 0) || (frame_info->inner_bevel < 0))t     {oA       Warning("Unable to frame image","bevel width is negative");l       return((Image *) NULL);      }i>   bevel_width=frame_info->outer_bevel+frame_info->inner_bevel;:   width=(int) frame_info->width-frame_info->x-bevel_width;<   height=(int) frame_info->height-frame_info->y-bevel_width;9   if ((width < image->columns) || (height < image->rows))a     {uG       Warning("Unable to frame image","frame is less than image size");        return((Image *) NULL);g     }g   /*'     Initialize framed image attributes.l   */K   framed_image=CopyImage(image,frame_info->width,frame_info->height,False); %   if (framed_image == (Image *) NULL),     {tB       Warning("Unable to frame image","Memory allocation failed");       return((Image *) NULL);u     },   image->class=DirectClass; (   matte.red=frame_info->matte_color.red;,   matte.green=frame_info->matte_color.green;*   matte.blue=frame_info->matte_color.blue;   matte.index=Opaque;f   matte.length=0; 0   highlight.red=frame_info->highlight_color.red;4   highlight.green=frame_info->highlight_color.green;2   highlight.blue=frame_info->highlight_color.blue;   highlight.index=Opaque;    highlight.length=0;=*   shadow.red=frame_info->shadow_color.red;.   shadow.green=frame_info->shadow_color.green;,   shadow.blue=frame_info->shadow_color.blue;   shadow.index=Opaque;   shadow.length=0;   /*.     Put an ornamental border around the image.   */   q=framed_image->pixels;o-   for (y=0; y < frame_info->outer_bevel; y++)=   {l1     for (x=0; x < (framed_image->columns-y); x++)(       *q++=highlight; +     for ( ; x < framed_image->columns; x++)        *q++=shadow;   }s1   for (y=0; y < (frame_info->y-bevel_width); y++);   { /     for (x=0; x < frame_info->outer_bevel; x++)e       *q++=highlight; N     for (x=0; x < (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte;m/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   }d-   for (y=0; y < frame_info->inner_bevel; y++)o   {o/     for (x=0; x < frame_info->outer_bevel; x++)v       *q++=highlight;b3     for (x=0; x < (frame_info->x-bevel_width); x++)i       *q++=matte;aI     for (x=0; x < (image->columns+(frame_info->inner_bevel << 1)-y); x++)t       *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)e       *q++=highlight;nE     width=frame_info->width-frame_info->x-image->columns-bevel_width;<     for (x=0; x < width; x++)a       *q++=matte;o/     for (x=0; x < frame_info->outer_bevel; x++)a       *q++=shadow;   };   p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)c   {s     /*,       Initialize scanline with border color.     *//     for (x=0; x < frame_info->outer_bevel; x++)t       *q++=highlight; 3     for (x=0; x < (frame_info->x-bevel_width); x++)t       *q++=matte; /     for (x=0; x < frame_info->inner_bevel; x++)>       *q++=shadow;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {,        if (image->runlength != 0)         image->runlength--;;
       else	         {n           p++;%           image->runlength=p->length;f	         }f       *q=(*p);       q->length=0;
       q++;     }i/     for (x=0; x < frame_info->inner_bevel; x++),       *q++=highlight;nE     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte;a/     for (x=0; x < frame_info->outer_bevel; x++)e       *q++=shadow;2     ProgressMonitor(FrameImageText,y,image->rows);   }i0   for (y=frame_info->inner_bevel-1; y >= 0; y--)   {e/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight;m3     for (x=0; x < (frame_info->x-bevel_width); x++)        *q++=matte;p     for (x=0; x < y; x++)        *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)(       *q++=highlight;eE     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)l       *q++=matte;"/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   }oB   height=frame_info->height-frame_info->y-image->rows-bevel_width;   for (y=0; y < height; y++)   {i/     for (x=0; x < frame_info->outer_bevel; x++)e       *q++=highlight; N     for (x=0; x < (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   }l0   for (y=frame_info->outer_bevel-1; y >= 0; y--)   {b     for (x=0; x < y; x++)        *q++=highlight; +     for ( ; x < framed_image->columns; x++)        *q++=shadow;   }    return(framed_image);l }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%XO %                                                                             % O %                                                                             %rO %     G a m m a I m a g e                                                     %mO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eN %  Function GammaImage converts the reference image to gamma corrected colors. %e+ %  The format of the GammaImage routine is:  %  %      GammaImage(image,gamma) % + %  A description of each parameter follows:h %nF %    o image: The address of a structure of type Image;  returned from %      ReadImage./ % J %    o gamma: A character string indicating the level of gamma correction. %U %  */) void GammaImage(Image *image,char *gamma)t { ; #define GammaImageText  "  Gamma correcting the image...  "   
   ColorPacket=     *gamma_map;N     double     blue_gamma,      green_gamma,     red_gamma;     int 
     count;     register int     i;     register RunlengthPacket     *p;e     red_gamma=1.0;   green_gamma=1.0;   blue_gamma=1.0;_H   count=sscanf(gamma,"%lf,%lf,%lf",&red_gamma,&green_gamma,&blue_gamma);   if (count == 1)h     {a       if (red_gamma == 1.0)-         return;-       green_gamma=red_gamma;       blue_gamma=red_gamma;n     }>   /*'     Allocate and initialize gamma maps.    */C   gamma_map=(ColorPacket *) malloc((MaxRGB+1)*sizeof(ColorPacket));s(   if (gamma_map == (ColorPacket *) NULL)     {iB       Warning("Unable to gamma image","Memory allocation failed");
       return;l     }    for (i=0; i <= MaxRGB; i++)o   {e     gamma_map[i].red=0;.     gamma_map[i].green=0;|     gamma_map[i].blue=0;   }n   /*     Initialize gamma table.*   */   for (i=0; i <= MaxRGB; i++)    {      if (red_gamma != 0.0)x        gamma_map[i].red=(Quantum)<         ((pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)+0.5);     if (green_gamma != 0.0))"       gamma_map[i].green=(Quantum)>         ((pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);     if (blue_gamma != 0.0)!       gamma_map[i].blue=(Quantum))=         ((pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);0   }t   switch (image->class)    {      case DirectClass:g     {m       /*(         Gamma-correct DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { %         p->red=gamma_map[p->red].red;;+         p->green=gamma_map[p->green].green; (         p->blue=gamma_map[p->blue].blue;         p++;!         if (QuantumTick(i,image))e;           ProgressMonitor(GammaImageText,i,image->packets);t       }d       break;     }      case PseudoClass:r     {t       /*(         Gamma-correct PseudoClass image.       */'       for (i=0; i < image->colors; i++)t       {;E         image->colormap[i].red=gamma_map[image->colormap[i].red].red;mK         image->colormap[i].green=gamma_map[image->colormap[i].green].green;xH         image->colormap[i].blue=gamma_map[image->colormap[i].blue].blue;       }a       SyncImage(image);n       break;     }t   }(   if (image->gamma != 0.0)9     image->gamma*=(red_gamma+green_gamma+blue_gamma)/3.0;e   free((char *) gamma_map);s }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %*O %                                                                             %oO %                                                                             % O %   G e t A n n o t a t e I n f o                                             %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function GetAnnotateInfo initializes the AnnotateInfo structure.  % 0 %  The format of the GetAnnotateInfo routine is: % % %      GetAnnotateInfo(annotate_info)  % + %  A description of each parameter follows:% %%F %    o annotate_info: Specifies a pointer to a AnnotateInfo structure. %e %  */1 void GetAnnotateInfo(AnnotateInfo *annotate_info)h {i+   annotate_info->server_name=(char *) NULL;a$   annotate_info->font=(char *) NULL;2   annotate_info->pointsize=atoi(DefaultPointSize);#   annotate_info->box=(char *) NULL;i#   annotate_info->pen=(char *) NULL;2(   annotate_info->geometry=(char *) NULL;$   annotate_info->text=(char *) NULL;)   annotate_info->primitive=(char *) NULL;i   annotate_info->center=False; }p s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %pO %                                                                             %tO %                                                                             %eO %   G e t I m a g e I n f o                                                   %cO %                                                                             %uO %                                                                             %eO %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %*= %  Function GetImageInfo initializes the ImageInfo structure.  % - %  The format of the GetImageInfo routine is:. %" %      GetImageInfo(image_info)  % + %  A description of each parameter follows:  %o@ %    o image_info: Specifies a pointer to a ImageInfo structure. %q %  */( void GetImageInfo(ImageInfo *image_info) {t   *image_info->magick='\0'; 6   image_info->filename=(char *) malloc(MaxTextLength);,   if (image_info->filename == (char *) NULL)A     Error("Unable to get image info","Memory allocation failed");n   *image_info->filename='\0';    image_info->assert=False;    image_info->subimage=0;    image_info->subrange=0;e(   image_info->server_name=(char *) NULL;!   image_info->font=(char *) NULL;m!   image_info->size=(char *) NULL;e!   image_info->tile=(char *) NULL; $   image_info->density=(char *) NULL;!   image_info->page=(char *) NULL; "   image_info->delay=(char *) NULL;$   image_info->texture=(char *) NULL;   image_info->adjoin=True;6   image_info->compression=RunlengthEncodedCompression;
 #ifdef HasPNGm)   image_info->compression=ZipCompression;e #endif   image_info->dispose=0;   image_info->dither=True;)   image_info->interlace=DefaultInterlace;r   image_info->iterations=0;    image_info->monochrome=False; /   image_info->pointsize=atoi(DefaultPointSize);d0   image_info->quality=atoi(DefaultImageQuality);   image_info->verbose=False;'   image_info->undercolor=(char *) NULL;0 }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             % O %                                                                             % O %     I m p l o d e I m a g e                                                 %bO %                                                                             %mO %                                                                             %;O %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ImplodeImage creates a new image that is a copy of an existingH %  one with the image pixels "imploded" by the specified percentage.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %o- %  The format of the ImplodeImage routine is:  %(0 %      imploded_image=ImplodeImage(image,factor) % + %  A description of each parameter follows:  % K %    o imploded_image: Function ImplodeImage returns a pointer to the image K %      after it is imploded.  A null image is returned if there is a memoryn %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.e % I %    o factor:  An double value that defines the extent of the implosion.r %= %  */  G static RunlengthPacket Interpolate(Image *image,RunlengthPacket *pixel,=   double x,double y) {(   register RunlengthPacket     *p,      *q,;     *r,;     *s;      RunlengthPacketu     interpolated_pixel;>  H   if ((x < 0) || (x >= image->columns) || (y < 0) || (y >= image->rows))     return(*pixel);Q1   p=image->pixels+image->columns*(int) y+(int) x;    q=p+1;+   if (q > (image->pixels+image->packets-1))      q=p;   r=p+image->columns; +   if (r > (image->pixels+image->packets-1))i     r=p;   s=q+image->columns; +   if (s > (image->pixels+image->packets-1))o     s=q;   x=fmod(x,1.0);   y=fmod(y,1.0);"   interpolated_pixel.red=(Quantum)D     ((1.0-y)*((1.0-x)*p->red+x*q->red)+y*((1.0-x)*r->red+x*s->red));$   interpolated_pixel.green=(Quantum)L     ((1.0-y)*((1.0-x)*p->green+x*q->green)+y*((1.0-x)*r->green+x*s->green));#   interpolated_pixel.blue=(Quantum)%H     ((1.0-y)*((1.0-x)*p->blue+x*q->blue)+y*((1.0-x)*r->blue+x*s->blue));+   interpolated_pixel.index=(unsigned short) L     ((1.0-y)*((1.0-x)*p->index+x*q->index)+y*((1.0-x)*r->index+x*s->index));&   interpolated_pixel.length=p->length;   return(interpolated_pixel);  }   / Image *ImplodeImage(Image *image,double factor)  { 2 #define ImplodeImageText  "  Imploding image...  "     double     amount, 
     distance,      radius, 
     x_center,      x_distance,      x_scale,
     y_center,      y_distance,      y_scale;     Image      *imploded_image;     register RunlengthPacket     *p,%     *q;%     register unsigned int%     x;     unsigned int     y;     if (!UncompressImage(image))     return((Image *) NULL);    /*)     Initialize imploded image attributes.m   */C   imploded_image=CopyImage(image,image->columns,image->rows,False);h'   if (imploded_image == (Image *) NULL)l     { D       Warning("Unable to implode image","Memory allocation failed");       return((Image *) NULL);b     }_$   imploded_image->class=DirectClass;   /*     Compute scaling factor.o   */   x_scale=1.0;   y_scale=1.0;'   x_center=(double) image->columns/2.0;u$   y_center=(double) image->rows/2.0;   radius=x_center;#   if (image->columns > image->rows)s'     y_scale=image->columns/image->rows;f   else%     if (image->columns < image->rows)_       {c+         x_scale=image->rows/image->columns;          radius=y_center;       }    amount=factor/10.0;i   if (amount >= 0)     amount/=10.0;e   /*     Implode each row.e   */   p=image->pixels;   q=imploded_image->pixels;r!   for (y=0; y < image->rows; y++)    {e&     for (x=0; x < image->columns; x++)     {f       /*4         Determine if the pixel is within an ellipse.       *//       x_distance=x_scale*((double) x-x_center); /       y_distance=y_scale*((double) y-y_center); C       distance=AbsoluteValue(x_distance)+AbsoluteValue(y_distance);g       if (distance >= radius)d         *q=(*p);
       else	         {r           /*             Implode the pixel.           */<           factor=pow(sin(M_PI*0.5*distance/radius),-amount);D           *q=Interpolate(image,p,factor*x_distance/x_scale+x_center,0             factor*y_distance/y_scale+y_center);	         }i
       p++;
       q++;     }r4     ProgressMonitor(ImplodeImageText,y,image->rows);   }n   return(imploded_image);l }> e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %rO %                                                                             %+O %     I s G e o m e t r y                                                     %mO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function IsGeometry returns True if the geometry specification is valid# %  as determined by XParseGeometry.  % + %  The format of the IsGeometry routine is:o %n" %      status=IsGeometry(geometry) % + %  A description of each parameter follows:  % J %    o status: Function IsGeometry returns True if the image is gray_scale# %      otherwise False is returned.> %g; %    o geometry: This string is the geometry specification.n %x %  */' unsigned int IsGeometry(char *geometry)) {    int      x,     y;     unsigned int
     flags,     height,%
     width;  6   flags=XParseGeometry(geometry,&x,&y,&width,&height);,   return(flags || sscanf(geometry,"%d",&x)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     I s G r a y I m a g e                                                   % O %                                                                             % O %                                                                             %%O %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %hI %  Function IsGrayImage returns True if the image is gray_scale otherwise P %  False is returned.  If the image is DirectClass and gray_scale, it is demoted %  to PseudoClass. %p, %  The format of the IsGrayImage routine is: %l  %      status=IsGrayImage(image) %o+ %  A description of each parameter follows:  % K %    o status: Function IsGrayImage returns True if the image is gray_scalei# %      otherwise False is returned.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %n %  */& unsigned int IsGrayImage(Image *image) {g   register int     i;     unsigned int     gray_scale;a     /*%     Determine if image is gray_scale.n   */   gray_scale=True;   switch (image->class)    {      case DirectClass:e     {i       register RunlengthPacket         *p;k         if (image->matte)          return(False);       p=image->pixels;(       for (i=0; i < image->packets; i++)       {_         if (!IsGray(*p))           {-             gray_scale=False;)             break;           }          p++;       }        if (gray_scale) 	         {)H           QuantizeImage(image,1 << QuantumDepth,8,False,GRAYColorspace);           SyncImage(image);g	         }        break;     }_     case PseudoClass:-     { '       for (i=0; i < image->colors; i++)w(         if (!IsGray(image->colormap[i]))           {;             gray_scale=False;p             break;           }s       break;     }i   }u   return(gray_scale);g }r - /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             %yO %                                                                             %=O %   L a b e l I m a g e                                                       %hO %                                                                             % O %                                                                             % O %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function LabelImage initializes an image label.  Optionally the labelJ %  can include the image filename, type, width, height, or scene number byF %  embedding special format characters.  Embed %f for filename, %m forD %  magick, %w for width, %h for height, or %s for scene number.  For %  example,  %  %     %f  %wx%h  %  %  produces an image label of  %  %     bird.miff  512x480 %pJ %  for an image titled bird.miff and whose width is 512 and height is 480. %f+ %  The format of the LabelImage routine is:g %- %      LabelImage(image,label) %;+ %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.s %hL %    o label: The address of a character string containing the label format. %  %  */) void LabelImage(Image *image,char *label)r {e   register char      *p,r     *q;-     unsigned int     indirection,     length;   $   if (image->label != (char *) NULL)      free((char *) image->label);   image->label=(char *) NULL;f   if (label == (char *) NULL)      return;    indirection=(*label == '@');   if (indirection)     { 
       FILE         *file;  	       intt
         c;         /*         Read label from a file.%       */'       file=(FILE *) fopen(label+1,"r");%        if (file == (FILE *) NULL)	         { 7           Warning("Unable to read label file",label+1);            return; 	         }        length=MaxTextLength; $       label=(char *) malloc(length);0       for (q=label; label != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;"         if ((q-label+1) >= length)           {              *q='\0';             length<<=1; :             label=(char *) realloc((char *) label,length);'             if (label == (char *) NULL)                break;"             q=label+strlen(label);           }%         *q=(unsigned char) c;%       }%       (void) fclose(file);!       if (label == (char *) NULL)e	         {sF           Warning("Unable to label image","Memory allocation failed");           return;e	         }C       *q='\0';     }a   /*(     Allocate and initialize image label.   */
   p=label;%   length=strlen(label)+MaxTextLength;l'   image->label=(char *) malloc(length);a:   for (q=image->label; image->label != (char *) NULL; p++)   {a     *q='\0';     if (*p == '\0')e       break;1     if ((q-image->label+MaxTextLength) >= length)g       {=         length<<=1; D         image->label=(char *) realloc((char *) image->label,length);*         if (image->label == (char *) NULL)           break;,         q=image->label+strlen(image->label);       }t     /*-       Process formatting characters in label.m     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;*       }      if (*p != '%')       {%         *q++=(*p);         continue;%       }%     p++;     switch (*p)      {        case 'b':        { 5         (void) sprintf(q,"%ld",image->filesize/1000); ,         q=image->label+strlen(image->label);         break;       }        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);,         q=image->label+strlen(image->label);         break;       }i       case 'm':g       {.'         (void) strcpy(q,image->magick);t!         q+=strlen(image->magick);g         break;       }y       case 's':l       {h,         (void) sprintf(q,"%u",image->scene);,         q=image->label+strlen(image->label);         break;       }r       case 'w':a       { 5         (void) sprintf(q,"%u",image->magick_columns); ,         q=image->label+strlen(image->label);         break;       }d       default:       {e         *q++='%';          *q++=(*p);         break;       }      }    }m$   if (image->label == (char *) NULL)     {iB       Warning("Unable to label image","Memory allocation failed");
       return;e     } 
   *q='\0';   if (indirection)     free((char *) label);n }n   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %-O %                                                                             % O %   M a g n i f y I m a g e                                                   % O %                                                                             %tO %                                                                             %iO %                                                                             %"O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %oL %  Function MagnifyImage creates a new image that is a integral size greaterM %  than an existing one.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % H %  MagnifyImage scans the reference image to create a magnified image byH %  bilinear interpolation.  The magnified image columns and rows become: %  %    number_columns << 1 %    number_rows << 1m %s- %  The format of the MagnifyImage routine is:n %n* %      magnified_image=MagnifyImage(image) %e+ %  A description of each parameter follows:  % L %    o magnified_image: Function MagnifyImage returns a pointer to the imageL %      after magnification.  A null image is returned if there is a a memory %      shortage. %o7 %    o image: The address of a structure of type Image.+ %T %L */! Image *MagnifyImage(Image *image)o {e7 #define MagnifyImageText  "  Magnifying the image...  "r     Image+     *magnified_image;      intp     y;     register int     x;     register RunlengthPacket     *p,n     *q,      *r;      /**     Initialize magnified image attributes.   */N   magnified_image=CopyImage(image,image->columns << 1,image->rows << 1,False);(   if (magnified_image == (Image *) NULL)     {tA       Warning("Unable to zoom image","Memory allocation failed");c       return((Image *) NULL);      }(%   magnified_image->class=DirectClass;    /*!     Initialize zoom image pixels.    */   p=image->pixels;   image->runlength=p->length+1;    q=magnified_image->pixels;!   for (y=0; y < image->rows; y++)h   { &     for (x=0; x < image->columns; x++)     {v        if (image->runlength != 0)         image->runlength--;c
       else	         {o           p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     }      q+=image->columns;   }    /*     Magnify each row.    */!   for (y=0; y < image->rows; y++)i   {eI     p=magnified_image->pixels+(image->rows-1-y)*magnified_image->columns+-       (image->columns-1);,P     q=magnified_image->pixels+((image->rows-1-y) << 1)*magnified_image->columns+        ((image->columns-1) << 1);     *q=(*p);     *(q+1)=(*(p));&     for (x=1; x < image->columns; x++)     {r
       p--;       q-=2;e       *q=(*p);<       (q+1)->red=(((int) p->red)+((int) (p+1)->red)+1) >> 1;B       (q+1)->green=(((int) p->green)+((int) (p+1)->green)+1) >> 1;?       (q+1)->blue=(((int) p->blue)+((int) (p+1)->blue)+1) >> 1;-B       (q+1)->index=(((int) p->index)+((int) (p+1)->index)+1) >> 1;       (q+1)->length=0;     }v   }s%   for (y=0; y < (image->rows-1); y++)    { @     p=magnified_image->pixels+(y << 1)*magnified_image->columns;!     q=p+magnified_image->columns; !     r=q+magnified_image->columns; *     for (x=0; x < (image->columns-1); x++)     {-4       q->red=(((int) p->red)+((int) r->red)+1) >> 1;:       q->green=(((int) p->green)+((int) r->green)+1) >> 1;7       q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;e:       q->index=(((int) p->index)+((int) r->index)+1) >> 1;       q->length=0;C       (q+1)->red=(((int) p->red)+((int) (p+2)->red)+((int) r->red)+ #         ((int) (r+2)->red)+2) >> 2; K       (q+1)->green=(((int) p->green)+((int) (p+2)->green)+((int) r->green)+ %         ((int) (r+2)->green)+2) >> 2; G       (q+1)->blue=(((int) p->blue)+((int) (p+2)->blue)+((int) r->blue)+ $         ((int) (r+2)->blue)+2) >> 2;K       (q+1)->index=(((int) p->index)+((int) (p+2)->index)+((int) r->index)+ %         ((int) (r+2)->index)+2) >> 2;        (q+1)->length=0;       q+=2;        p+=2;        r+=2;      } 2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1; 8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;f8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;4     ProgressMonitor(MagnifyImageText,y,image->rows);   } G   p=magnified_image->pixels+(2*image->rows-2)*magnified_image->columns; G   q=magnified_image->pixels+(2*image->rows-1)*magnified_image->columns; $   for (x=0; x < image->columns; x++)   {u     *q++=(*p++);     *q++=(*p++);   }o   return(magnified_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0O %                                                                             % O %                                                                             %rO %                                                                             % O %   M i n i f y I m a g e                                                     % O %                                                                             %eO %                                                                             %nO %                                                                             %=O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %(M %  Function MinifyImage creates a new image that is a integral size less than H %  an existing one.  It allocates the memory necessary for the new Image4 %  structure and returns a pointer to the new image. %dP %  MinifyImage scans the reference image to create a minified image by computingL %  the weighted average of a 4x4 cell centered at each reference pixel.  TheJ %  target pixel requires two columns and two rows of the reference pixels.8 %  Therefore the minified image columns and rows become: %% %    number_columns/2% %    number_rows/2 %%G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the MinifyImage routine is: % ( %      minified_image=MinifyImage(image) % + %  A description of each parameter follows:  % J %    o minified_image: Function MinifyImage returns a pointer to the imageG %      after reducing.  A null image is returned if there is a a memory%= %      shortage or if the image size is less than IconSize*2.o %o7 %    o image: The address of a structure of type Image.  %r %e */  Image *MinifyImage(Image *image) {  #define Minify(weight) \!   total_red+=(weight)*(s->red); \a%   total_green+=(weight)*(s->green); \m#   total_blue+=(weight)*(s->blue); \ %   total_matte+=(weight)*(s->index); \    s++;1 #define MinifyImageText  "  Minifying image...  "r     Image;     *minified_image;     register RunlengthPacket     *p,      *q,s     *s,      *s0,     *s1,     *s2,     *s3;     register unsigned intl     x;     RunlengthPacketg     *scanline;     unsigned int     y;     unsigned int	     blue,g
     green,     packets,     red;     unsigned longo     total_matte,     total_blue,      total_green,     total_red;     unsigned short
     index;  0   if ((image->columns < 4) || (image->rows < 4))     {gE       Warning("Unable to reduce image","image size must exceed 3x3");=       return((Image *) NULL);l     }-   /*)     Initialize minified image attributes.(   */%   packets=Max(image->packets >> 2,1);l2   minified_image=CopyImage(image,packets,1,False);'   if (minified_image == (Image *) NULL)      {gC       Warning("Unable to reduce image","Memory allocation failed");        return((Image *) NULL);      }a$   minified_image->class=DirectClass;.   minified_image->columns=image->columns >> 1;(   minified_image->rows=image->rows >> 1;   minified_image->packets=0;   /*F     Allocate image buffer and scanline buffer for 4 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(4*(image->columns+1)*sizeof(RunlengthPacket)); +   if (scanline == (RunlengthPacket *) NULL)      {mC       Warning("Unable to reduce image","Memory allocation failed"); #       DestroyImage(minified_image);=       return((Image *) NULL);-     }=   /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1; ,   for (x=0; x < (4*(image->columns+1)); x++)     scanline[x]=(*p); 
   s=scanline;g+   for (x=0; x < (image->columns << 1); x++)m   {p     if (image->runlength != 0)       image->runlength--;m     else       {C         p++;#         image->runlength=p->length;p       }      *s=(*p);     s++;   }    /*     Reduce each row.   */   p=image->pixels;   image->runlength=p->length+1;%   q=minified_image->pixels;%   q->red=0;%
   q->green=0;    q->blue=0;
   q->index=0;    q->length=MaxRunlength; &   for (y=0; y < (image->rows-1); y+=2)   {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y+0) % 4); +     s1=scanline+image->columns*((y+1) % 4); +     s2=scanline+image->columns*((y+2) % 4); +     s3=scanline+image->columns*((y+3) % 4);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length;%	         }%       *s=(*p);
       s++;     }      /*       Read another scan line.s     */	     s=s3;o&     for (x=0; x < image->columns; x++)     {f        if (image->runlength != 0)         image->runlength--; 
       else	         {(           p++;%           image->runlength=p->length; 	         }i       *s=(*p);
       s++;     } +     for (x=0; x < (image->columns-1); x+=2)y     {e       /*B         Compute weighted average of target pixel color components.  I         These particular coefficients total to 128.  Use 128/2-1 or 63 to:!         insure correct round off.m       */       total_red=0;       total_green=0;       total_blue=0;e       total_matte=0;       s=s0;t3       Minify(3); Minify(7);  Minify(7);  Minify(3);o       s=s1;g3       Minify(7); Minify(15); Minify(15); Minify(7);i       s=s2;t3       Minify(7); Minify(15); Minify(15); Minify(7);t       s=s3;a3       Minify(3); Minify(7);  Minify(7);  Minify(3);i       s0+=2;       s1+=2;       s2+=2;       s3+=2;*       red=(Quantum) ((total_red+63) >> 7);.       green=(Quantum) ((total_green+63) >> 7);,       blue=(Quantum) ((total_blue+63) >> 7);5       index=(unsigned short) ((total_matte+63) >> 7);iH       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         {o+           if (minified_image->packets != 0)              q++;$           minified_image->packets++;1           if (minified_image->packets == packets) 
             {t               packets<<=1;I               minified_image->pixels=(RunlengthPacket *) realloc((char *),H                 minified_image->pixels,packets*sizeof(RunlengthPacket));E               if (minified_image->pixels == (RunlengthPacket *) NULL)e                 {sO                   Warning("Unable to reduce image","Memory allocation failed");i/                   DestroyImage(minified_image);c)                   return((Image *) NULL);_                 }eA               q=minified_image->pixels+minified_image->packets-1; 
             }            q->red=red;e           q->green=green;            q->blue=blue;e           q->index=index;t           q->length=0;	         })     } 5     ProgressMonitor(MinifyImageText,y,image->rows-1);f   }c=   minified_image->pixels=(RunlengthPacket *) realloc((char *) L     minified_image->pixels,minified_image->packets*sizeof(RunlengthPacket));   free((char *) scanline);   return(minified_image);_ }g p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %cO %                                                                             % O %     M o d u l a t e I m a g e                                               %(O %                                                                             % O %                                                                             %-O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ModulateImage modulates the hue, saturation, and brightness of an-	 %  image.  % . %  The format of the ModulateImage routine is: % $ %      ModulateImage(image,modulate) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.l %=I %    o modulate: A character string indicating the percent change in hue, " %      saturation, and brightness. %r %C */  B static void Modulate(double percent_hue,double percent_saturation,F   double percent_brightness,Quantum *red,Quantum *green,Quantum *blue) {    double     brightness,f     hue,     saturation;e     /*>     Increase or decrease color brightness, saturation, or hue.   */?   TransformHSL(*red,*green,*blue,&hue,&saturation,&brightness);)'   brightness+=percent_brightness/100.0;a   if (brightness < 0.0)(     brightness=0.0;t   else     if (brightness > 1.0)/       brightness=1.0;t'   saturation+=percent_saturation/100.0;s   if (saturation < 0.0)p     saturation=0.0;h   else     if (saturation > 1.0)p       saturation=1.0;    if (hue != -1.0)     {y       hue+=percent_hue/100.0;e       if (hue < 0.0)         hue+=1.0;p
       else         if (hue > 1.0)           hue-=1.0;0     }o9   HSLTransform(hue,saturation,brightness,red,green,blue);m }-  / void ModulateImage(Image *image,char *modulate)h { 4 #define ModulateImageText  "  Modulating image...  "     double     percent_brightness,      percent_hue,     percent_saturation;      register int     i;     register RunlengthPacket     *p;      /*     Initialize gamma table.    */   percent_hue=0.0;   percent_brightness=0.0;e   percent_saturation=0.0; O   (void) sscanf(modulate,"%lf,%lf,%lf",&percent_brightness,&percent_saturation,=     &percent_hue);   switch (image->class)    {      case DirectClass:      {        /*3         Modulate the color for a DirectClass image.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { C         Modulate(percent_hue,percent_saturation,percent_brightness, &           &p->red,&p->green,&p->blue);         p++;!         if (QuantumTick(i,image))e>           ProgressMonitor(ModulateImageText,i,image->packets);       }        break;     }      case PseudoClass:p     {>       /*3         Modulate the color for a PseudoClass image.p       */'       for (i=0; i < image->colors; i++) C         Modulate(percent_hue,percent_saturation,percent_brightness,e<           &image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }d   }n }) a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             % O %                                                                             %nO %     M o g r i f y I m a g e                                                 %qO %                                                                             % O %                                                                             % O %                                                                             %qO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %+H %  Function MogrifyImage applies image processing options to an image as& %  prescribed by command line options. % - %  The format of the MogrifyImage routine is:( %q/ %      MogrifyImage(image_info,argc,argv,image)  % + %  A description of each parameter follows:  % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %uG %    o argc: Specifies a pointer to an integer describing the number ofe' %      elements in the argument vector.  %eL %    o argv: Specifies a pointer to a text array containing the command line %      arguments.n %=F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %a */  L void MogrifyImages(ImageInfo *image_info,int argc,char **argv,Image **image) {+   Image>     *next_image;  +   MogrifyImage(image_info,argc,argv,image);    next_image=(*image)->next;&   while (next_image != (Image *) NULL)   {)3     MogrifyImage(image_info,argc,argv,&next_image);e      next_image=next_image->next;   }  }e  K void MogrifyImage(ImageInfo *image_info,int argc,char **argv,Image **image); {    AnnotateInfo     annotate_info;  
   ColorPacket      border_color,      matte_color;     char     *option;     ImageO     *region_image;     int=
     flags,     x,     y;     register int     i;     unsigned int     colorspace,      height,e     number_colors,     tree_depth, 
     width;     XColor
     color;     if (*image == (Image *) NULL)      return;-   /*!     Initialize routine variables.e   */"   GetAnnotateInfo(&annotate_info);1   (void) XQueryColorDatabase(BorderColor,&color); )   border_color.red=XDownScale(color.red); -   border_color.green=XDownScale(color.green); +   border_color.blue=XDownScale(color.blue);    border_color.index=0;p0   (void) XQueryColorDatabase(MatteColor,&color);(   matte_color.red=XDownScale(color.red);,   matte_color.green=XDownScale(color.green);*   matte_color.blue=XDownScale(color.blue);   number_colors=0;   region_image=(Image *) NULL;   tree_depth=0;<   colorspace=RGBColorspace;u   if (image_info->monochrome)p8     if (!IsGrayImage(*image) || ((*image)->colors != 2))       {e         number_colors=2;         tree_depth=8; "         colorspace=GRAYColorspace;       }    /*     Transmogrify the image.p   */   for (i=1; i < argc; i++)   {=     option=argv[i];pN     if (((int) strlen(option) <= 1) || ((*option != '-') && (*option != '+')))       continue; '     if (strncmp("-blur",option,3) == 0)n       {e         double           factor;   
         Imagem           *blurred_image;   
         /*           Blur an image.
         */         factor=atof(argv[++i]);i/         blurred_image=BlurImage(*image,factor);i,         if (blurred_image != (Image *) NULL)           {g!             DestroyImage(*image);s!             *image=blurred_image;2           }m         continue;        } &     if (strcmp("-border",option) == 0)       {o
         Imagep           *bordered_image;           RectangleInfom           border_info;  
         /*6           Surround image with a border of solid color.
         */         border_info.width=0;         border_info.height=0;oE         flags=XParseGeometry(argv[++i],&border_info.x,&border_info.y,02           &border_info.width,&border_info.height);'         if ((flags & HeightValue) == 0) /           border_info.height=border_info.width;rF         bordered_image=BorderImage(*image,&border_info,&border_color);-         if (bordered_image != (Image *) NULL)h           { !             DestroyImage(*image); .             bordered_image->class=DirectClass;"             *image=bordered_image;           }i         continue;        }t.     if (strncmp("-bordercolor",option,8) == 0)       {          XColor           target_color;r  
         /*3           Determine RGB values of the border color.=
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);6         border_color.red=XDownScale(target_color.red);:         border_color.green=XDownScale(target_color.green);8         border_color.blue=XDownScale(target_color.blue);         continue;        }s&     if (strncmp("-box",option,3) == 0)       { $         annotate_info.box=argv[++i];         continue;d       }m*     if (strncmp("colors",option+1,7) == 0)       { &         number_colors=atoi(argv[++i]);         continue;l       }y-     if (strncmp("-colorspace",option,8) == 0)>       {          i++;         option=argv[i]; .         if (Latin1Compare("gray",option) == 0)           {r&             colorspace=GRAYColorspace;#             if (number_colors == 0)r                number_colors=256;             tree_depth=8;            }o.         if (Latin1Compare("ohta",option) == 0)$           colorspace=OHTAColorspace;-         if (Latin1Compare("rgb",option) == 0)-#           colorspace=RGBColorspace; 5         if (Latin1Compare("transparent",option) == 0)(+           colorspace=TransparentColorspace; -         if (Latin1Compare("xyz",option) == 0) #           colorspace=XYZColorspace; /         if (Latin1Compare("ycbcr",option) == 0)l%           colorspace=YCbCrColorspace; -         if (Latin1Compare("yiq",option) == 0)t#           colorspace=YIQColorspace;t/         if (Latin1Compare("ypbpr",option) == 0)m%           colorspace=YPbPrColorspace;e-         if (Latin1Compare("yuv",option) == 0))#           colorspace=YUVColorspace;x         continue;d       }-+     if (strncmp("comment",option+1,4) == 0)n       {)         if (*option == '-') )           CommentImage(*image,argv[++i]);d         else-           CommentImage(*image,(char *) NULL);)         continue;        }r,     if (strncmp("contrast",option+1,3) == 0)       {a>         ContrastImage(*image,(unsigned int) (*option == '-'));         continue;        }e'     if (strncmp("-crop",option,3) == 0).       {;6         TransformImage(image,argv[++i],(char *) NULL);         continue;c       } ,     if (strncmp("-despeckle",option,4) == 0)       {r
         Image)           *despeckled_image;  
         /*.           Reduce the speckles within an image.
         */0         despeckled_image=DespeckleImage(*image);/         if (despeckled_image != (Image *) NULL)            {l!             DestroyImage(*image);d$             *image=despeckled_image;           }t         continue;p       } *     if (strncmp("-display",option,4) == 0)       {n,         annotate_info.server_name=argv[++i];         continue;        } (     if (strncmp("draw",option+1,2) == 0)       { *         annotate_info.primitive=argv[++i];)         DrawImage(*image,&annotate_info);n         continue;e       }n'     if (strncmp("-edge",option,3) == 0)        {p         double           factor;   
         Imagep           *edged_image;   
         /*$           Detect edges in the image.
         */         factor=atof(argv[++i]);e-         edged_image=EdgeImage(*image,factor); *         if (edged_image != (Image *) NULL)           {-!             DestroyImage(*image);              *image=edged_image;n           }          continue;g       }n)     if (strncmp("-emboss",option,3) == 0)u       { 
         Image            *embossed_image;  
         /*           Emboss image. 
         */+         embossed_image=EmbossImage(*image);d-         if (embossed_image != (Image *) NULL)n           { !             DestroyImage(*image); "             *image=embossed_image;           }t         continue;        } *     if (strncmp("-enhance",option,3) == 0)       {>
         Image            *enhanced_image;  
         /*           Enhance image.
         */,         enhanced_image=EnhanceImage(*image);-         if (enhanced_image != (Image *) NULL)            { !             DestroyImage(*image); "             *image=enhanced_image;           }          continue;        } +     if (strncmp("-equalize",option,3) == 0)        {          EqualizeImage(*image);         continue;        } '     if (strncmp("-flip",option,4) == 0)        { 
         Image            *flipped_image;   
         /*           Flip image scanlines. 
         */(         flipped_image=FlipImage(*image);,         if (flipped_image != (Image *) NULL)           {o!             DestroyImage(*image);i!             *image=flipped_image;t           }          continue;g       } '     if (strncmp("-flop",option,4) == 0)i       { 
         Imagea           *flopped_image;A  
         /*           Flop image scanlines. 
         */(         flopped_image=FlopImage(*image);,         if (flopped_image != (Image *) NULL)           {T!             DestroyImage(*image);e!             *image=flopped_image;            }t         continue;o       } '     if (strncmp("-font",option,3) == 0)b       {s%         annotate_info.font=argv[++i];          continue;e       } %     if (strcmp("-frame",option) == 0)        { 
         Imager           *framed_image;           FrameInfo            frame_info;1  
         /*3           Surround image with an ornamental border.n
         */         frame_info.width=0;          frame_info.height=0;?         flags=XParseGeometry(argv[++i],&frame_info.outer_bevel, H           &frame_info.inner_bevel,&frame_info.width,&frame_info.height);'         if ((flags & HeightValue) == 0)t-           frame_info.height=frame_info.width; "         if ((flags & XValue) == 0);           frame_info.outer_bevel=(frame_info.width >> 2)+1;="         if ((flags & YValue) == 0)8           frame_info.inner_bevel=frame_info.outer_bevel;&         frame_info.x=frame_info.width;'         frame_info.y=frame_info.height;)C         frame_info.width=(*image)->columns+(frame_info.width << 1); B         frame_info.height=(*image)->rows+(frame_info.height << 1);+         frame_info.matte_color=matte_color;tJ         frame_info.highlight_color.red=(matte_color.red*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;N         frame_info.highlight_color.green=(matte_color.green*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;L         frame_info.highlight_color.blue=(matte_color.blue*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;$         frame_info.shadow_color.red=A           (unsigned int) (matte_color.red*ShadowModulate)/MaxRGB; &         frame_info.shadow_color.green=C           (unsigned int) (matte_color.green*ShadowModulate)/MaxRGB;m%         frame_info.shadow_color.blue=)B           (unsigned int) (matte_color.blue*ShadowModulate)/MaxRGB;4         framed_image=FrameImage(*image,&frame_info);+         if (framed_image != (Image *) NULL)i           {u!             DestroyImage(*image);),             framed_image->class=DirectClass;              *image=framed_image;           }          continue;r       }a(     if (strncmp("-gamma",option,3) == 0)       {r%         GammaImage(*image,argv[++i]);,         continue;h       }h+     if (strncmp("-geometry",option,4) == 0)a       {.6         TransformImage(image,(char *) NULL,argv[++i]);'         annotate_info.geometry=argv[i];t         continue;r       }0*     if (strncmp("-implode",option,4) == 0)       {e         double           amount;e  
         Images           *imploded_image;  
         /*           Implode image.
         */         amount=atof(argv[++i]);r3         imploded_image=ImplodeImage(*image,amount); -         if (imploded_image != (Image *) NULL)            {e!             DestroyImage(*image);p"             *image=imploded_image;           }          continue;        } -     if (strncmp("interlace",option+1,3) == 0)a       { ,         image_info->interlace=NoneInterlace;         if (*option == '-')            {              option=argv[++i];,2             if (Latin1Compare("none",option) == 0)2               image_info->interlace=NoneInterlace;2             if (Latin1Compare("line",option) == 0)2               image_info->interlace=LineInterlace;3             if (Latin1Compare("plane",option) == 0) 3               image_info->interlace=PlaneInterlace;            }o         continue;d       }a)     if (strncmp("label",option+1,2) == 0)c       {+         if (*option == '-')a'           LabelImage(*image,argv[++i]);r         else+           LabelImage(*image,(char *) NULL);(         continue;a       } &     if (strcmp("matte",option+1) == 0)       {%)         (*image)->matte=(*option == '-');%         continue;        } -     if (strncmp("-mattecolor",option,7) == 0)        {          XColor           target_color;   
         /*3           Determine RGB values of the border color. 
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);5         matte_color.red=XDownScale(target_color.red); 9         matte_color.green=XDownScale(target_color.green); 7         matte_color.blue=XDownScale(target_color.blue);          continue;        } +     if (strncmp("-modulate",option,4) == 0)        { (         ModulateImage(*image,argv[++i]);         continue;%       }%)     if (strncmp("-negate",option,4) == 0)%       {%         NegateImage(*image);         continue;        }s(     if (strncmp("-noise",option,4) == 0)       {a
         Imagee           *noisy_image;.  
         /*            Reduce noise in image.
         */'         noisy_image=NoisyImage(*image);c*         if (noisy_image != (Image *) NULL)           {o!             DestroyImage(*image);o             *image=noisy_image;t           }r         continue;A       }g,     if (strncmp("-normalize",option,4) == 0)       {o         NormalizeImage(*image);e         continue;        }c)     if (strncmp("-opaque",option,3) == 0)r       {n8         OpaqueImage(*image,argv[++i],annotate_info.pen);         continue;t       } (     if (strncmp("-paint",option,4) == 0)       {c
         Imagec           *painted_image;a  
         /*           Oil paint image.
         */<         painted_image=OilPaintImage(*image,atoi(argv[++i]));,         if (painted_image != (Image *) NULL)           {i!             DestroyImage(*image);g!             *image=painted_image;*           }e         continue;        }o&     if (strncmp("-pen",option,3) == 0)       {($         annotate_info.pen=argv[++i];         continue;)       }p,     if (strncmp("-pointsize",option,3) == 0)       {U0         annotate_info.pointsize=atoi(argv[++i]);         continue;        }/)     if (strncmp("raise",option+1,2) == 0)        {cC         RaiseImage(*image,*option == '-' ? 1 : -1,atoi(argv[++i]));o         continue;N       } *     if (strncmp("region",option+1,2) == 0)       {y+         if (region_image != (Image *) NULL)            {b             /*               Composite region.l             */H             XParseGeometry(region_image->geometry,&x,&y,&width,&height);G             CompositeImage(region_image,ReplaceCompositeOp,*image,x,y);*!             DestroyImage(*image);N              *image=region_image;           }m         if (*option == '+')i           continue;;M         region_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);>+         if (region_image == (Image *) NULL)a           continue;N)         region_image->geometry=argv[++i];dC         TransformImage(image,region_image->geometry,(char *) NULL);o         continue;        }a'     if (strncmp("-roll",option,4) == 0)f       {a
         Image            *rolled_image;           unsigned int           height,i           width;  
         /*           Roll image.m
         */         x=0;         y=0;=         flags=XParseGeometry(argv[++i],&x,&y,&width,&height); +         rolled_image=RollImage(*image,x,y); +         if (rolled_image != (Image *) NULL)            {n!             DestroyImage(*image);)              *image=rolled_image;           }*         continue;e       }g)     if (strncmp("-rotate",option,4) == 0)e       {r         double           degrees;  
         Imagei           *rotated_image;o  
         /*           Rotate image.l
         */          degrees=atof(argv[++i]);K         rotated_image=RotateImage(*image,degrees,&border_color,False,True);k,         if (rotated_image != (Image *) NULL)           {e!             DestroyImage(*image); !             *image=rotated_image;>           }f         continue;        } )     if (strncmp("-sample",option,3) == 0)t       { 
         Imagem           *sampled_image;p  
         /*.           Sample image with pixel replication.
         */          width=(*image)->columns;         height=(*image)->rows;5         ParseImageGeometry(argv[++i],&width,&height);i7         sampled_image=SampleImage(*image,width,height); ,         if (sampled_image != (Image *) NULL)           {p!             DestroyImage(*image); !             *image=sampled_image;            }          continue;y       }a)     if (strncmp("scene",option+1,3) == 0)a       {+(         (*image)->scene=atoi(argv[++i]);         continue;e       }g+     if (strncmp("segment",option+1,3) == 0)>       {eN         SegmentImage(*image,colorspace,image_info->verbose,SmoothingThreshold,           atof(argv[++i]));          SyncImage(*image);         continue;        }(*     if (strncmp("-sharpen",option,5) == 0)       {o         double           factor;   
         Imagem           *sharpened_image;s  
         /*           Sharpen an image. 
         */         factor=atof(argv[++i]);i4         sharpened_image=SharpenImage(*image,factor);.         if (sharpened_image != (Image *) NULL)           { !             DestroyImage(*image); #             *image=sharpened_image;            }(         continue;s       }e(     if (strncmp("-shear",option,4) == 0)       {_
         floatf           x_shear,           y_shear;  
         Imagee           *sheared_image;;  
         /*           Shear image.
         */         x_shear=0.0;         y_shear=0.0;;         (void) sscanf(argv[++i],"%fx%f",&x_shear,&y_shear); 9         sheared_image=ShearImage(*image,(double) x_shear, 0           (double) y_shear,&border_color,False);,         if (sheared_image != (Image *) NULL)           { !             DestroyImage(*image); -             sheared_image->class=DirectClass; !             *image=sheared_image;            }          continue;        } +     if (strncmp("-solarize",option,3) == 0)        { .         SolarizeImage(*image,atof(argv[++i]));         continue;        } )     if (strncmp("-spread",option,3) == 0)        {          unsigned int           amount;   
         Image%           *spread_image;  
         /*           Spread an image.
         */         amount=atoi(argv[++i]);e0         spread_image=SpreadImage(*image,amount);+         if (spread_image != (Image *) NULL)n           {c!             DestroyImage(*image);h              *image=spread_image;           }e         continue;g       }n)     if (strncmp("-spread",option,3) == 0)u       {          unsigned int           amount;f  
         ImageI           *spread_image;  
         /*           Spread an image.
         */         amount=atoi(argv[++i]);l0         spread_image=SpreadImage(*image,amount);+         if (spread_image != (Image *) NULL)i           { !             DestroyImage(*image);e              *image=spread_image;           }h         continue;        }a(     if (strncmp("-swirl",option,3) == 0)       {          double           degrees;  
         Imagen           *swirled_image;   
         /*           Swirl image.
         */          degrees=atof(argv[++i]);1         swirled_image=SwirlImage(*image,degrees);p,         if (swirled_image != (Image *) NULL)           {p!             DestroyImage(*image);,!             *image=swirled_image;k           }          continue;        }r/     if (strncmp("-transparency",option,4) == 0)o       {i+         TransparentImage(*image,argv[++i]);_         continue;|       } ,     if (strncmp("-treedepth",option,4) == 0)       {n#         tree_depth=atoi(argv[++i]);          continue;l       }    }"   if (number_colors != 0)      {;       /*1         Reduce the number of colors in the image.+       */-       if (((*image)->class == DirectClass) ||pO           ((*image)->colors > number_colors) || (colorspace == GRAYColorspace))oI         QuantizeImage(*image,number_colors,tree_depth,image_info->dither,u           colorspace);       /*#         Measure quantization error.        */       if (image_info->verbose)"         QuantizationError(*image);       SyncImage(*image);     }i%   if (region_image != (Image *) NULL)h     {(       /*         Composite region.        */B       XParseGeometry(region_image->geometry,&x,&y,&width,&height);A       CompositeImage(region_image,ReplaceCompositeOp,*image,x,y);c       DestroyImage(*image);        *image=region_image;     }t>   if ((*image)->packets == ((*image)->columns*(*image)->rows))     CompressImage(*image); }  r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %=O %                                                                             %)O %     N e g a t e I m a g e                                                   % O %                                                                             %uO %                                                                             %aO %                                                                             %-O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %-B %  Function NegateImage negates the colors in the reference image. % , %  The format of the NegateImage routine is: %  %      NegateImage(image)g %r+ %  A description of each parameter follows:- % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.h %  %  */ void NegateImage(Image *image) { ; #define NegateImageText  "  Negating the image colors...  ">     register int     i;     register RunlengthPacket     *p;>     switch (image->class)g   {D     case DirectClass:      {)       /*#         Negate DirectClass packets.|       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {(         p->red=(~p->red);e         p->green=(~p->green);          p->blue=(~p->blue);          p++;!         if (QuantumTick(i,image))p<           ProgressMonitor(NegateImageText,i,image->packets);       }        break;     }r     case PseudoClass:      {(       /*#         Negate PseudoClass packets.)       */'       for (i=0; i < image->colors; i++)r       {n9         image->colormap[i].red=(~image->colormap[i].red);s=         image->colormap[i].green=(~image->colormap[i].green);r;         image->colormap[i].blue=(~image->colormap[i].blue);        }        SyncImage(image);        break;     })   }e }= n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%DO %                                                                             % O %                                                                             % O %     N o i s y I m a g e                                                     %lO %                                                                             % O %                                                                             %lO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %pH %  Function NoisyImage creates a new image that is a copy of an existingH %  one with the noise minified with a noise peak elimination filter.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % K %  The principal function of noise peak elimination filter is to smooth the-F %  objects within an image without losing edge information and withoutJ %  creating undesired structures.  The central idea of the algorithm is toI %  replace a pixel with its next neighbor in value within a 3 x 3 window,oI %  if this pixel has been found to be noise.  A pixel is defined as noisewE %  if and only if this pixel is a maximum or minimum within the 3 x 3m
 %  window. % + %  The format of the NoisyImage routine is:. % $ %      noisy_image=NoisyImage(image) %i+ %  A description of each parameter follows:r %eL %    o noisy_image: Function NoisyImage returns a pointer to the image afterL %      the noise is minified.  A null image is returned if there is a memory %      shortage. %rF %    o image: The address of a structure of type Image;  returned from %      ReadImage.c %_ %o */4 static int NoisyCompare(const void *x,const void *y) {g
   ColorPacket 
     *color_1,h
     *color_2;      color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_1)-(int) Intensity(*color_2)); }p   Image *NoisyImage(Image *image)l { 9 #define NoisyImageText  "  Reducing the image noise...  "      Image=     *noisy_image;o     int      i;     register RunlengthPacket     *p,      *q,n     *s,l     *s0,     *s1,     *s2;     register unsigned int+     x;     RunlengthPacketr
     pixel,     *scanline,     window[9];     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { I       Warning("Unable to reduce noise","the image size must exceed 2x2");        return((Image *) NULL);n     }q   /*&     Initialize noisy image attributes.   */@   noisy_image=CopyImage(image,image->columns,image->rows,False);$   if (noisy_image == (Image *) NULL)     {+C       Warning("Unable to reduce noise","Memory allocation failed");        return((Image *) NULL);      }    /*5     Allocate scanline buffer for 3 rows of the image.i   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { C       Warning("Unable to reduce noise","Memory allocation failed");e        DestroyImage(noisy_image);       return((Image *) NULL);      }f   /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline;n+   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;=     else       {e         p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }n   /*!     Dump first scanline of image.l   */   q=noisy_image->pixels;
   s=scanline;e$   for (x=0; x < image->columns; x++)   {      *q=(*s);     q->length=0;     q++;     s++;   }    /*     Reduce noise in each row.e   */%   for (y=1; y < (image->rows-1); y++)c   {)     /*)       Initialize sliding window pointers.s     */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3);%+     s2=scanline+image->columns*((y+1) % 3);%     /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */	     s=s1;      *q=(*s);     q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*3         Sort window pixels by increasing intensity.        */       s=s0;        window[0]=(*s++);%       window[1]=(*s++);%       window[2]=(*s++);%       s=s1;%       window[3]=(*s++);o       window[4]=(*s++);        window[5]=(*s++);a       s=s2;        window[6]=(*s++);r       window[7]=(*s++);r       window[8]=(*s++);s       pixel=window[4];6       qsort((void *) window,9,sizeof(RunlengthPacket),<         (int (*)(const void *, const void *)) NoisyCompare);3       if (Intensity(pixel) == Intensity(window[0]))f	         {            /*H             Pixel is minimum noise; replace with next neighbor in value.           */           for (i=1; i < 8; i++)I=             if (Intensity(window[i]) != Intensity(window[0]))                break;           pixel=window[i];	         } 
       else5         if (Intensity(pixel) == Intensity(window[8]))            {i             /*J               Pixel is maximum noise; replace with next neighbor in value.             */!             for (i=7; i > 0; i--)l?               if (Intensity(window[i]) != Intensity(window[8]))f                 break;             pixel=window[i];           }        *q=pixel;x       q->length=0;
       q++;       s0++;        s1++;)       s2++;,     }m     /**       Transfer last pixel of the scanline.     */	     s=s1;g     *q=(*s);     q->length=0;     q++;4     ProgressMonitor(NoisyImageText,y,image->rows-1);   }    /*!     Dump last scanline of pixels.c   */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {f     *q=(*s);     q->length=0;     q++;     s++;   }m   free((char *) scanline);   return(noisy_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     N o r m a l i z e I m a g e                                             % O %                                                                             %rO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d %aG %  Function NormalizeImage normalizes the pixel values to span the fullfD %  range of color values.  This is a contrast enhancement technique. %m/ %  The format of the NormalizeImage routine is:% %. %      NormalizeImage(image) %p+ %  A description of each parameter follows:e %rF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %i %f */! void NormalizeImage(Image *image)  { 6 #define NormalizeImageText  "  Normalizing image...  "     intU     histogram[MaxRGB+1],     threshold_intensity;  	   Quantum*     gray_value,b     normalize_map[MaxRGB+1];     register int     i,     intensity;     register RunlengthPacket     *p;      unsigned int	     high,n     low;     /*     Form histogram.l   */   for (i=0; i <= MaxRGB; i++)      histogram[i]=0;f   p=image->pixels;$   for (i=0; i < image->packets; i++)   {c     gray_value=Intensity(*p);n'     histogram[gray_value]+=p->length+1;l     p++;   }    /*C     Find the histogram boundaries by locating the 1 percent levels.f   */7   threshold_intensity=(image->columns*image->rows)/100;f   intensity=0;"   for (low=0; low < MaxRGB; low++)   {      intensity+=histogram[low];(     if (intensity > threshold_intensity)       break;   }l   intensity=0;&   for (high=MaxRGB; high != 0; high--)   {l     intensity+=histogram[high];a(     if (intensity > threshold_intensity)       break;   }    if (low == high)     {s       /*K         Unreasonable contrast;  use zero threshold to determine boundaries.t       */       threshold_intensity=0;       intensity=0;&       for (low=0; low < MaxRGB; low++)       { "         intensity+=histogram[low];,         if (intensity > threshold_intensity)           break;       },       intensity=0;*       for (high=MaxRGB; high != 0; high--)       {b#         intensity+=histogram[high]; ,         if (intensity > threshold_intensity)           break;       }0       if (low == high)&         return;  /* zero span bound */     }    /*A     Stretch the histogram to create the normalized image mapping.;   */   for (i=0; i <= MaxRGB; i++)d     if (i < (int) low)       normalize_map[i]=0;)     else       if (i > (int) high) "         normalize_map[i]=MaxRGB-1;
       else7         normalize_map[i]=(MaxRGB-1)*(i-low)/(high-low);l   /*     Normalize the image.   */   switch (image->class)(   {n     case DirectClass:      {i       /*$         Normalize DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {e%         p->red=normalize_map[p->red]; )         p->green=normalize_map[p->green];_'         p->blue=normalize_map[p->blue];          p++;!         if (QuantumTick(i,image))n?           ProgressMonitor(NormalizeImageText,i,image->packets);        }        break;     }f     case PseudoClass:+     {        /*$         Normalize PseudoClass image.       */'       for (i=0; i < image->colors; i++),       {gE         image->colormap[i].red=normalize_map[image->colormap[i].red];nI         image->colormap[i].green=normalize_map[image->colormap[i].green];mG         image->colormap[i].blue=normalize_map[image->colormap[i].blue];(       }c       SyncImage(image);a       break;     })   }n }f , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %iO %                                                                             % O %     O p a g u e I m a g e                                                   % O %                                                                             %,O %                                                                             %nO %                                                                             %LO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%, %fN %  Function OpaqueImage changes the color of an opaque pixel to the pen color. % , %  The format of the OpaqueImage routine is: %m1 %      OpaqueImage(image,opaque_color,pen_colors)  %)+ %  A description of each parameter follows:n %mF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %n %    o opaque_color,G %      pen_colors: A character string that contain an X11 color string., %g %l */B void OpaqueImage(Image *image,char *opaque_color,char *pen_colors) { C #define OpaqueImageText  "  Setting opaque color in the image...  "t  	   Quantum 	     blue,S
     green,     red;     register int     i;     unsigned int     status;      XColor     target_color;t     /*-     Determine RGB values of the opaque color.v   */9   status=XQueryColorDatabase(opaque_color,&target_color);s   if (status == False)     return;(#   red=XDownScale(target_color.red); '   green=XDownScale(target_color.green); %   blue=XDownScale(target_color.blue);n7   status=XQueryColorDatabase(pen_colors,&target_color);L   if (status == False)     return;a   /*     Make image color opaque.   */   switch (image->class)f   {      case DirectClass:      {i       register RunlengthPacket         *p;          /*&         Make DirectClass image opaque.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {m2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           {f0             p->red=XDownScale(target_color.red);4             p->green=XDownScale(target_color.green);2             p->blue=XDownScale(target_color.blue);           }          p++;!         if (QuantumTick(i,image))f<           ProgressMonitor(OpaqueImageText,i,image->packets);       }k       break;     }      case PseudoClass:n     {c       register ColorPacket         *p;*         /*&         Make PseudoClass image opaque.       */       p=image->colormap;'       for (i=0; i < image->colors; i++)i       {a2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           {)0             p->red=XDownScale(target_color.red);4             p->green=XDownScale(target_color.green);2             p->blue=XDownScale(target_color.blue);           }          p++;!         if (QuantumTick(i,image)) <           ProgressMonitor(OpaqueImageText,i,image->packets);       }        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   O p e n I m a g e                                                         %tO %                                                                             %eO %                                                                             %9O %                                                                             %xO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n % L %  Function OpenImage open a file associated with the image.  A file name ofK %  '-' sets the file to stdin for type 'r' and stdout for type 'w'.  If themK %  filename suffix is '.gz' or '.Z', the image is decompressed for type 'r'kK %  and compressed for type 'w'.  If the filename prefix is '|', it is pipedo %  to or from a system command.: %n* %  The format of the OpenImage routine is: %m' %      OpenImage(image_info,image,type)u %i+ %  A description of each parameter follows:  %o@ %    o image_info: Specifies a pointer to a ImageInfo structure. %r7 %    o image: The address of a structure of type Image.i %u. %    o type: 'r' for reading; 'w' for writing. %n */I void OpenImage(const ImageInfo *image_info,Image *image,const char *type)  {e   char     filename[MaxTextLength];  *   (void) strcpy(filename,image->filename);   if (*filename != '|')='     if (((int) strlen(filename) > 3) &&+9         (strcmp(filename+strlen(filename)-3,".gz") == 0))s       { 
         /*E           Uncompress/compress image file with GNU compress utilities.n
         */         if (*type == 'r') A           (void) sprintf(filename,GunzipCommand,image->filename);          else?           (void) sprintf(filename,GzipCommand,image->filename);        }      else)       if (((int) strlen(filename) > 2) && :           (strcmp(filename+strlen(filename)-2,".Z") == 0))	         {+           /*H             Uncompress/compress image file with UNIX compress utilities.           */           if (*type == 'r')tG             (void) sprintf(filename,UncompressCommand,image->filename);+           elseE             (void) sprintf(filename,CompressCommand,image->filename);0	         }n   /*     Open image file.   */   image->pipe=False;    if (strcmp(filename,"-") == 0)0     image->file=(*type == 'r') ? stdin : stdout;   else) #if !defined(vms) && !defined(__MWERKS__)l     if (*filename == '|')u       {          char           mode[MaxTextLength];  
         /*1           Pipe image to or from a system command. 
         */         if (*type == 'w');)           (void) signal(SIGPIPE,SIG_IGN);;$         (void) strncpy(mode,type,1);4         image->file=(FILE *) popen(filename+1,mode);         image->pipe=True;i       }"     else #endif       {e2         if ((*type == 'w') && !image_info->adjoin)4           if ((image->previous != (Image *) NULL) ||.               (image->next != (Image *) NULL))
             {                /*4                 Form filename for multi-part images.               */D               (void) sprintf(filename,image->filename,image->scene);8               if (strcmp(filename,image->filename) == 0)N                 (void) sprintf(filename,"%s.%u",image->filename,image->scene);0               if (image->next != (Image *) NULL)A                 (void) strcpy(image->next->magick,image->magick); 6               (void) strcpy(image->filename,filename);
             }l #if defined(__MWERKS__)          if (*type == 'w')n           {r             OSType               filetype;c               Str255               name;a  2             (void) strcpy((char *) name,filename);#             CtoPstr((char *) name);Q             filetype='    ';A             (void) strncpy((char *) &filetype,image_info->magick,l1               Min(strlen(image_info->magick),4));=+             Create(name,0,'MgCK',filetype);=           }  #endif2         image->file=(FILE *) fopen(filename,type);)         if (image->file != (FILE *) NULL)            {=+             (void) fseek(image->file,0L,2);)/             image->filesize=ftell(image->file);e+             (void) fseek(image->file,0L,0);I           }e       }    image->status=False;   if (*type == 'r')*     {e!       image->next=(Image *) NULL;0%       image->previous=(Image *) NULL;n     }0 }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             %-O %                                                                             %+O %                                                                             % O %   P a r s e I m a g e G e o m e t r y                                       %nO %                                                                             %eO %                                                                             %oO %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u %rM %  Function ParseImageGeometry parse a geometry specification and returns the  %  width and height values.l %s3 %  The format of the ParseImageGeometry routine is:e %e6 %      ParseImageGeometry(image_geometry,width,height) %i+ %  A description of each parameter follows:+ % N %    o image_geometry:  Specifies a character string representing the geometry %      specification., %eL %    o width:  A pointer to an unsigned integer.  The width as determined by3 %      the geometry specification is returned here.s %aN %    o height:  A pointer to an unsigned integer.  The height as determined by3 %      the geometry specification is returned here.e %e %  */A void ParseImageGeometry(char *image_geometry,unsigned int *width,    unsigned int *height)  {    char     geometry[MaxTextLength];     int)
     flags,     x,     y;     register charr     *p;c     unsigned int     aspect_ratio,]     former_height,     former_width,n     greater,	     less,[     percentage;-     unsigned longs     scale_factor;r  &   if (image_geometry == (char *) NULL)     return;u   /*J     Remove whitespaces and % and ! characters from geometry specification.   */)   (void) strcpy(geometry,image_geometry);d   aspect_ratio=True;   greater=False;
   less=False;    percentage=False; 
   p=geometry;-   while ((int) strlen(p) > 0)-   {r     if (isspace(*p))       (void) strcpy(p,p+1);      else       switch (*p)        {i         case '%':x	         {-           percentage=True;           (void) strcpy(p,p+1);            break;	         }          case '!':r	         {(           aspect_ratio=False;(           (void) strcpy(p,p+1);(           break;	         }u         case '<':)	         {            less=True;           (void) strcpy(p,p+1);%           break;	         }          case '>': 	         {            greater=True;            (void) strcpy(p,p+1);            break;	         }          default:           p++;       }    }    /*(     Parse geometry using XParseGeometry.   */   former_width=(*width);   former_height=(*height);4   flags=XParseGeometry(geometry,&x,&y,width,height);@   if (((flags & WidthValue) != 0) && (flags & HeightValue) == 0)     *height=(*width);    if (percentage)      {        /*3         Geometry is a percentage of the image size.        */)       *width=(former_width*(*width))/100; ,       *height=(former_height*(*height))/100;       former_width=(*width);       former_height=(*height);     }d   if (aspect_ratio)o     {w       /**         Respect aspect ratio of the image.       */D       if (((flags & WidthValue) != 0) && (flags & HeightValue) != 0)	         {s4           scale_factor=UpShift(*width)/former_width;>           if (scale_factor > (UpShift(*height)/former_height))8             scale_factor=UpShift(*height)/former_height;	         } 
       else&         if ((flags & WidthValue) != 0)4           scale_factor=UpShift(*width)/former_width;         else6           scale_factor=UpShift(*height)/former_height;2       *width=DownShift(former_width*scale_factor);4       *height=DownShift(former_height*scale_factor);     }a   if (greater)=     if ((former_width < *width) && (former_height < *height))        {(         *width=former_width;         *height=former_height;       }    if (less) =     if ((former_width > *width) && (former_height > *height))        {(         *width=former_width;         *height=former_height;       }r })   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%NO %                                                                             %.O %                                                                             %-O %     O i l P a i n t I m a g e                                               %rO %                                                                             % O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %hK %  Function OilPaintImage creates a new image that is a copy of an existing%N %  one with each pixel component replaced with the color of greatest frequency %  in a circular neighborhood. % . %  The format of the OilPaintImage routine is: % 0 %      painted_image=OilPaintImage(image,radius) % + %  A description of each parameter follows:  % K %    o painted_image: Function OilPaintImage returns a pointer to the image L %      after it is `painted'.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % A %    o radius: An unsigned int that is the radius of the circular  %      neighborhood. %% %% */< Image *OilPaintImage(Image *image,const unsigned int radius) { 6 #define OilPaintImageText  "  Oil painting image...  "     Imagel     *painted_image;g     int 
     count,     k;     register int     i,     j;     register RunlengthPacket     *p,s     *q,o     *s;r     register unsigned into     x;     unsigned int     *histogram,I     y;  H   if ((image->columns < (radius << 1)) || (image->rows < (radius << 1)))     {fN       Warning("Unable to oil paint","the image size must exceed mask radius");       return((Image *) NULL);e     }o   if (!UncompressImage(image))     return((Image *) NULL);    /*(     Initialize painted image attributes.   */B   painted_image=CopyImage(image,image->columns,image->rows,False);&   if (painted_image == (Image *) NULL)     { @       Warning("Unable to oil paint","Memory allocation failed");       return((Image *) NULL);      }    /*$     Allocate histogram and scanline.   */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); )   if (histogram == (unsigned int *) NULL)      { @       Warning("Unable to oil paint","Memory allocation failed");"       DestroyImage(painted_image);       return((Image *) NULL);      }    /*      Paint each row of the image.   */   p=image->pixels;   q=painted_image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { 8       if ((y < radius) || (y >= (image->rows-radius)) ||9           (x < radius) || (x >= (image->columns-radius)))%	         {%           *q++=(*p++);           continue;m	         },       /*&         Determine most frequent color.       */       count=0;$       for (i=0; i < (MaxRGB+1); i++)         histogram[i]=0;         for (i=0; i < radius; i++)       { *         s=p-(radius-i)*image->columns-1-i;#         for (j=0; j < (i+i+1); j++)_	         {d           k=Intensity(*s);           histogram[k]++;s#           if (histogram[k] > count)f
             {f               *q=(*s);!               count=histogram[k]; 
             }r           s++;	         } *         s=p+(radius-i)*image->columns-1-i;#         for (j=0; j < (i+i+1); j++)v	         {            k=Intensity(*s);           histogram[k]++;=#           if (histogram[k] > count)p
             {                *q=(*s);!               count=histogram[k]; 
             }n           s++;	         }-       }        s=p-radius;-+       for (j=0; j < (radius+radius+1); j++)a       {          k=Intensity(*s);         histogram[k]++; !         if (histogram[k] > count)-           {)             *q=(*s);             count=histogram[k];x           })         s++;       }i
       q++;
       p++;     } 5     ProgressMonitor(OilPaintImageText,y,image->rows);n   }    free((char *) histogram);    return(painted_image); }g ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             %-O %                                                                             %gO %                                                                             % O %   R a i s e I m a g e                                                       %=O %                                                                             % O %                                                                             % O %                                                                             %-O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %rK %  Function RaiseImage lightens and darkens the edges of an image to give a  %  3-D raised or lower effect. %p+ %  The format of the RaiseImage routine is:> % + %      RaiseImage(image,raised,bevel_width)- %>+ %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.p %-L %    o raised: A value other than zero causes the image to have a 3-D raised1 %      effect, otherwise it has a lowered effect.e %oN %    o bevel_width: This unsigned integer defines the width of the 3-D effect. %a %r */M void RaiseImage(Image *image,const int raised,const unsigned int bevel_width)x {|# #define HighlightLeft  UpScale(160) " #define HighlightTop  UpScale(180). #define RaiseImageText  "  Raising image...  "! #define ShadowRight  UpScale(180)+" #define ShadowBottom  UpScale(160)  	   Quantume     foreground,      background;+     register int     x,     y;     register RunlengthPacket     *p;      unsigned int     height;t  .   if ((image->columns < (bevel_width << 1)) &&)       (image->rows < (bevel_width << 1)))-     {iL       Warning("Unable to raise image","image size must exceed bevel width");
       return;d     }p   if (!UncompressImage(image))     return;a   foreground=MaxRGB;   background=0;    if (!raised)     {        foreground=0;        background=MaxRGB;     }    image->class=DirectClass;o   p=image->pixels;!   for (y=0; y < bevel_width; y++)n   {      for (x=0; x < y; x++)o     {_       p->red=(unsigned int)tH         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int)gJ         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;;
       p++;     } 1     for (x=0; x < (image->columns-(y << 1)); x++)r     {        p->red=(unsigned int)eF         (p->red*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;       p->green=(unsigned int)oH         (p->green*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;       p->blue=(unsigned int)G         (p->blue*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB; 
       p++;     }      for (x=0; x < y; x++)e     {R       p->red=(unsigned int) D         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int) F         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;)
       p++;     }o   } (   height=image->rows-(bevel_width << 1);   for (y=0; y < height; y++)   {c#     for (x=0; x < bevel_width; x++)      {t       p->red=(unsigned int) H         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int) J         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;a
       p++;     } ;     for (x=0; x < (image->columns-(bevel_width << 1)); x++)r
       p++;#     for (x=0; x < bevel_width; x++)g     {e       p->red=(unsigned int) D         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int)'F         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;i
       p++;     }L-     ProgressMonitor(RaiseImageText,y,height);e   }-!   for (y=0; y < bevel_width; y++)i   {e'     for (x=0; x < (bevel_width-y); x++)c     {        p->red=(unsigned int)sH         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int)dJ         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;m
       p++;     }v?     for (x=0; x < (image->columns-((bevel_width-y) << 1)); x++)      {a       p->red=(unsigned int)lF         (p->red*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;       p->green=(unsigned int)iH         (p->green*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;       p->blue=(unsigned int)G         (p->blue*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB; 
       p++;     }n'     for (x=0; x < (bevel_width-y); x++)e     {p       p->red=(unsigned int)aD         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int)vF         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;i
       p++;     }p   }\	   return;  }  h /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %cO %                                                                             %gO %     R G B T r a n s f o r m I m a g e                                       %4O %                                                                             % O %                                                                             %aO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function RGBTransformImage converts the reference image from RGB toM %  an alternate colorspace.  The transformation matrices are not the standardpL %  ones: the weights are rescaled to normalized the range of the transformed %  values to be [0..MaxRGB]. %m2 %  The format of the RGBTransformImage routine is: % * %      RGBTransformImage(image,colorspace) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.a %*L %    o colorspace: An unsigned integer value that indicates which colorspace %      to transform the image. %  %( */B void RGBTransformImage(Image *image,const unsigned int colorspace) { A #define RGBTransformImageText  "  Transforming image colors...  "r #define X 0n #define Y (MaxRGB+1) #define Z (MaxRGB+1)*2     long     tx,"     ty,a     tz,      *x,      *y,      *z;u  	   Quantum      *range_table;      register int	     blue,.
     green,     i,     red;     register Quantum     *range_limit;i     register RunlengthPacket     *p;=  M   if ((colorspace == RGBColorspace) || (colorspace == TransparentColorspace))=     return; #   if (colorspace == GRAYColorspace)\     {+       /*2         Return if the image is already gray_scale.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {o:         if ((p->red != p->green) || (p->green != p->blue))           break;         p++;       }n       if (i == image->packets)         return;      }e   /*     Allocate the tables.   *//   x=(long *) malloc(3*(MaxRGB+1)*sizeof(long));-/   y=(long *) malloc(3*(MaxRGB+1)*sizeof(long));g/   z=(long *) malloc(3*(MaxRGB+1)*sizeof(long));x?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum)); 5   if ((x == (long *) NULL) || (y == (long *) NULL) ||-@       (z == (long *) NULL) || (range_table == (Quantum *) NULL))     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;o     }(   /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)-   {=     range_table[i]=0;u*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;)   } %   range_limit=range_table+(MaxRGB+1);    tx=0;e   ty=0;    tz=0;h   switch (colorspace)i   {e     case GRAYColorspace:     {-       /*         Initialize GRAY tables:-  +           G = 0.29900*R+0.58600*G+0.11400*B%       */!       for (i=0; i <= MaxRGB; i++)%       { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.29900)*i;$         y[i+Y]=UpShifted(0.58600)*i;$         z[i+Y]=UpShifted(0.11400)*i;$         x[i+Z]=UpShifted(0.29900)*i;$         y[i+Z]=UpShifted(0.58600)*i;$         z[i+Z]=UpShifted(0.11400)*i;       }        break;     }      case OHTAColorspace:     {        /*         Initialize OHTA tables:   ,           I1 = 0.33333*R+0.33334*G+0.33333*B,           I2 = 0.50000*R+0.00000*G-0.50000*B,           I3 =-0.25000*R+0.50000*G-0.25000*B  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.o       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)n       {e$         x[i+X]=UpShifted(0.33333)*i;$         y[i+X]=UpShifted(0.33334)*i;$         z[i+X]=UpShifted(0.33333)*i;$         x[i+Y]=UpShifted(0.50000)*i;         y[i+Y]=0;b'         z[i+Y]=(-UpShifted(0.50000))*i;,'         x[i+Z]=(-UpShifted(0.25000))*i;o$         y[i+Z]=UpShifted(0.50000)*i;'         z[i+Z]=(-UpShifted(0.25000))*i;        }e       break;     }m     case XYZColorspace:r     {o       /*"         Initialize CIE XYZ tables:  .           X = 0.412453*X+0.357580*Y+0.180423*Z.           Y = 0.212671*X+0.715160*Y+0.072169*Z.           Z = 0.019334*X+0.119193*Y+0.950227*Z       */!       for (i=0; i <= MaxRGB; i++)a       {e%         x[i+X]=UpShifted(0.412453)*i;R%         y[i+X]=UpShifted(0.357580)*i;a%         z[i+X]=UpShifted(0.180423)*i;g%         x[i+Y]=UpShifted(0.212671)*i;n%         y[i+Y]=UpShifted(0.715160)*i;t%         z[i+Y]=UpShifted(0.072169)*i;e%         x[i+Z]=UpShifted(0.019334)*i;e%         y[i+Z]=UpShifted(0.119193)*i; %         z[i+Z]=UpShifted(0.950227)*i;o       }o       break;     }_     case YCbCrColorspace:      {r       /*          Initialize YCbCr tables:  /           Y =  0.299000*R+0.586000*G+0.114000*Bg/           Cb= -0.172586*R-0.338828*G+0.511414*Br/           Cr=  0.511414*R-0.428246*G-0.083168*B   K         Cb and Cr, normally -0.5 through 0.5, are normalized to the range 0(         through MaxRGB."       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        {m%         x[i+X]=UpShifted(0.299000)*i;u%         y[i+X]=UpShifted(0.586000)*i;d%         z[i+X]=UpShifted(0.114000)*i; (         x[i+Y]=(-UpShifted(0.172586))*i;(         y[i+Y]=(-UpShifted(0.338828))*i;%         z[i+Y]=UpShifted(0.511414)*i;>%         x[i+Z]=UpShifted(0.511414)*i;s(         y[i+Z]=(-UpShifted(0.428246))*i;(         z[i+Z]=(-UpShifted(0.083168))*i;       }-       break;     }n     case YCCColorspace:i     {R       /*         Initialize YCC tables:  +           Y = 0.29900*R+0.58600*G+0.11400*Bi+           C1=-0.29900*R-0.58600*G+0.88600*Bg+           C2= 0.70100*R-0.58600*G+0.11400*B   B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */0       ty=UpShifted((unsigned int) UpScale(156));0       tz=UpShifted((unsigned int) UpScale(137));!       for (i=0; i <= MaxRGB; i++)        {n$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.29900))*i;o'         y[i+Y]=(-UpShifted(0.58600))*i; $         z[i+Y]=UpShifted(0.88600)*i;$         x[i+Z]=UpShifted(0.70100)*i;'         y[i+Z]=(-UpShifted(0.58600))*i;;'         z[i+Z]=(-UpShifted(0.11400))*i;0       }g       break;     }      case YIQColorspace:;     {+       /*         Initialize YIQ tables:  +           Y = 0.29900*R+0.58600*G+0.11400*B +           I = 0.50000*R-0.23000*G-0.27000*Bn+           Q = 0.20200*R-0.50000*G+0.29800*Bs  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0g         through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)g       {g$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.50000)*i;'         y[i+Y]=(-UpShifted(0.23000))*i;r'         z[i+Y]=(-UpShifted(0.27000))*i;q$         x[i+Z]=UpShifted(0.20200)*i;'         y[i+Z]=(-UpShifted(0.50000))*i; $         z[i+Z]=UpShifted(0.29800)*i;       }        break;     }m     case YPbPrColorspace:o     {=       /*          Initialize YPbPr tables:  /           Y =  0.299000*R+0.587000*G+0.114000*B /           Pb= -0.168736*R-0.331264*G+0.500000*Bo/           Pr=  0.500000*R-0.418688*G-0.081312*B   K         Pb and Pr, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)B       { %         x[i+X]=UpShifted(0.299000)*i;o%         y[i+X]=UpShifted(0.587000)*i;o%         z[i+X]=UpShifted(0.114000)*i;r(         x[i+Y]=(-UpShifted(0.168736))*i;(         y[i+Y]=(-UpShifted(0.331264))*i;%         z[i+Y]=UpShifted(0.500000)*i;f%         x[i+Z]=UpShifted(0.500000)*i;_(         y[i+Z]=(-UpShifted(0.418688))*i;(         z[i+Z]=(-UpShifted(0.081312))*i;       }        break;     }o     case YUVColorspace:x     default:     {-       /*         Initialize YUV tables:  ,           Y =  0.29900*R+0.58600*G+0.11400*B,           U = -0.14740*R-0.28950*G+0.43690*B,           V =  0.61500*R-0.51500*G-0.10000*B  I         U and V, normally -0.5 through 0.5, are normalized to the range 0eD         through MaxRGB.  Note that U = 0.493*(B-Y), V = 0.877*(R-Y).       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)/       {s$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.14740))*i;%'         y[i+Y]=(-UpShifted(0.28950))*i;%$         z[i+Y]=UpShifted(0.43690)*i;$         x[i+Z]=UpShifted(0.61500)*i;'         y[i+Z]=(-UpShifted(0.51500))*i; '         z[i+Z]=(-UpShifted(0.10000))*i;        }        break;     }    }    /*     Convert from RGB.    */   switch (image->class)    {      case DirectClass:      {        /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          red=p->red;          green=p->green;          blue=p->blue; H         p->red=range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];J         p->green=range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];I         p->blue=range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];t         p++;!         if (QuantumTick(i,image))rB           ProgressMonitor(RGBTransformImageText,i,image->packets);       }e       break;     }i     case PseudoClass:m     {        /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)        {t#         red=image->colormap[i].red;,'         green=image->colormap[i].green;d%         blue=image->colormap[i].blue;          image->colormap[i].red=aC           range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)]; !         image->colormap[i].green=lC           range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];t          image->colormap[i].blue=C           range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];.       }        SyncImage(image);a       break;     }a   }r   /*     Free allocated memory.   */   free((char *) range_table);e   free((char *) z);w   free((char *) y);    free((char *) x);f }e i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %gO %                                                                             %;O %                                                                             %gO %   R o l l I m a g e                                                         % O %                                                                             % O %                                                                             %,O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %nE %  Function RollImage rolls an image vertically and horizontally.  ItdK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %a* %  The format of the RollImage routine is: %,1 %      rolled_image=RollImage(image,columns,rows)g %=+ %  A description of each parameter follows:l %oL %    o rolled_image: Function RollImage returns a pointer to the image afterH %      rolling.  A null image is returned if there is a memory shortage. %e7 %    o image: The address of a structure of type Image.c % H %    o x_offset: An integer that specifies the number of columns to roll# %      in the horizontal direction.  %aL %    o y_offset: An integer that specifies the number of rows to roll in the %      vertical direction. %( %g */8 Image *RollImage(Image *image,int x_offset,int y_offset) {a- #define RollImageText  "  Rolling image...  "g     Imageh     *rolled_image;     register RunlengthPacket     *p,;     *q;      register unsigned inth     packets,     x;     unsigned int     y;     /*'     Initialize rolled image attributes.>   */A   rolled_image=CopyImage(image,image->columns,image->rows,False);a%   if (rolled_image == (Image *) NULL)x     {0A       Warning("Unable to roll image","Memory allocation failed");k       return((Image *) NULL);r     }x   /*     Roll image._   */   p=image->pixels;   image->runlength=p->length+1; %   packets=image->columns*image->rows; !   for (y=0; y < image->rows; y++)/   {e     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;+
       else	         {            p++;%           image->runlength=p->length;s	         }gD       q=rolled_image->pixels+(y_offset+y)*image->columns+x+x_offset;#       if (q < rolled_image->pixels)g         q+=packets; 
       else0         if (q >= (rolled_image->pixels+packets))           q-=packets;        *q=(*p);       q->length=0;     }e1     ProgressMonitor(RollImageText,y,image->rows);    }    return(rolled_image);n }r r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %oO %                                                                             %=O %                                                                             % O %   S a m p l e I m a g e                                                     %eO %                                                                             %/O %                                                                             %_O %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %fG %  Function SampleImage creates a new image that is a scaled size of an H %  existing one using pixel sampling.  It allocates the memory necessaryF %  for the new Image structure and returns a pointer to the new image. %=, %  The format of the SampleImage routine is: %m4 %      sampled_image=SampleImage(image,columns,rows) %d+ %  A description of each parameter follows:  %RO %    o sampled_image: Function SampleImage returns a pointer to the image aftertH %      scaling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.t %sN %    o columns: An integer that specifies the number of columns in the sampled
 %      image.- %wH %    o rows: An integer that specifies the number of rows in the sampled
 %      image.m %  %) */G Image *SampleImage(Image *image,unsigned int columns,unsigned int rows)  {*0 #define SampleImageText  "  Sampling image...  "     Image      *sampled_image;;     int      y;     register RunlengthPacket     *p,%     *q,%     *s;%     register int     x;     RunlengthPacket      *scanline;     unsigned int     *x_offset,     *y_offset;     unsigned long      scale_factor;   $   if ((columns == 0) || (rows == 0))     { D       Warning("Unable to sample image","image dimensions are zero");       return((Image *) NULL);      }    /*(     Initialize sampled image attributes.   */4   sampled_image=CopyImage(image,columns,rows,False);&   if (sampled_image == (Image *) NULL)     { C       Warning("Unable to sample image","Memory allocation failed");%       return((Image *) NULL);%     }%   /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));P   x_offset=(unsigned int *) malloc(sampled_image->columns*sizeof(unsigned int));M   y_offset=(unsigned int *) malloc(sampled_image->rows*sizeof(unsigned int));c/   if ((scanline == (RunlengthPacket *) NULL) || ,       (x_offset == (unsigned int *) NULL) ||*       (y_offset == (unsigned int *) NULL))     {sC       Warning("Unable to sample image","Memory allocation failed");t"       DestroyImage(sampled_image);       return((Image *) NULL);      }a   /*$     Initialize column pixel offsets.   */@   scale_factor=UpShift(image->columns-1)/sampled_image->columns;   columns=0;,   for (x=0; x < sampled_image->columns; x++)   {a<     x_offset[x]=DownShift((x+1)*scale_factor)-(int) columns;     columns+=x_offset[x];    }s   /*!     Initialize row pixel offsets.    */:   scale_factor=UpShift(image->rows-1)/sampled_image->rows;	   rows=0; )   for (y=0; y < sampled_image->rows; y++)i   {u9     y_offset[y]=DownShift((y+1)*scale_factor)-(int) rows;a     rows+=y_offset[y];   }e$   y_offset[sampled_image->rows-1]=0;   /*     Preload first scanline.h   */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline;s$   for (x=0; x < image->columns; x++)   {r     if (image->runlength != 0)       image->runlength--;      else       {=         p++;#         image->runlength=p->length;)       }      *s=(*p);     s->length=0;     s++;   }(   /*     Sample each row.   */   q=sampled_image->pixels;)   for (y=0; y < sampled_image->rows; y++)e   {*     /*       Sample each column.w     */     s=scanline; .     for (x=0; x < sampled_image->columns; x++)     {        *q=(*s);
       q++;       s+=x_offset[x];      }l     if (y_offset[y] != 0)i       {u
         /*           Skip a scan line. 
         */         if (y_offset[y] > 1)>           for (x=0; x < (image->columns*(y_offset[y]-1)); x++)&             if (image->runlength != 0)!               image->runlength--;              else               {                  p++;+                 image->runlength=p->length;d               } 
         /*           Read a scan line. 
         */         s=scanline; *         for (x=0; x < image->columns; x++)	         {a$           if (image->runlength != 0)             image->runlength--;s           else
             {e               p++;)               image->runlength=p->length;m
             }            *s=(*p);           s->length=0;           s++;	         }s       }f;     ProgressMonitor(SampleImageText,y,sampled_image->rows);U   }    free((char *) scanline);   free((char *) x_offset);   free((char *) y_offset);   return(sampled_image); }i t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %=O %                                                                             % O %                                                                             % O %   S c a l e I m a g e                                                       %eO %                                                                             %MO %                                                                             %eO %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %(F %  Function ScaleImage creates a new image that is a scaled size of anE %  existing one.  It allocates the memory necessary for the new ImagepI %  structure and returns a pointer to the new image.  To scale a scanlinenK %  from x pixels to y pixels, each new pixel represents x/y old pixels.  To;L %  read x/y pixels, read (x/y rounded up) pixels but only count the requiredH %  fraction of the last old pixel read in your new pixel.  The remainder: %  of the old pixel will be counted in the next new pixel. % K %  The scaling algorithm was suggested by rjohnson@shell.com and is adaptedy0 %  from pnmscale(1) of PBMPLUS by Jef Poskanzer. % + %  The format of the ScaleImage routine is:  % 2 %      scaled_image=ScaleImage(image,columns,rows) % + %  A description of each parameter follows:  % M %    o scaled_image: Function ScaleImage returns a pointer to the image after H %      scaling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the scaled 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the scaled;
 %      image.  %m %  */: Image *ScaleImage(Image *image,const unsigned int columns,   const unsigned int rows) { . #define ScaleImageText  "  Scaling image...  "     typedef struct ScaledPacket;   {      long
       red,       green,       blue,=       index;   } ScaledPacket;      Imagee     *scaled_image;     int 
     next_row,      number_rows;     long     x_scale,     x_span;n     register RunlengthPacket     *p,(     *q;n     register ScaledPackete     *s,a     *t;      register unsigned int(     x;     ScaledPacket     *scaled_scanline,c     *scanline,     *y_vector,     *x_vector;     unsigned int     packets,     y;     unsigned long 	     blue,c
     green,
     index,     red,     scale_factor;(  $   if ((columns == 0) || (rows == 0))     {_C       Warning("Unable to scale image","image dimensions are zero");e       return((Image *) NULL);w     }    /*'     Initialize scaled image attributes.e   */B   scale_factor=UpShift(columns*rows)/(image->columns*image->rows);8   packets=Max(DownShift(image->packets*scale_factor),1);0   scaled_image=CopyImage(image,packets,1,False);%   if (scaled_image == (Image *) NULL)      {/B       Warning("Unable to scale image","Memory allocation failed");       return((Image *) NULL);      };"   scaled_image->class=DirectClass;    scaled_image->columns=columns;   scaled_image->rows=rows;   scaled_image->packets=0;   /*     Allocate memory.   */H   x_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));   scanline=x_vector;(   if (scaled_image->rows != image->rows)J     scanline=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));"   scaled_scanline=(ScaledPacket *)7     malloc(scaled_image->columns*sizeof(ScaledPacket)); H   y_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));,   if ((x_vector == (ScaledPacket *) NULL) ||,       (scanline == (ScaledPacket *) NULL) ||3       (scaled_scanline == (ScaledPacket *) NULL) || *       (y_vector == (ScaledPacket *) NULL))     { B       Warning("Unable to scale image","Memory allocation failed");!       DestroyImage(scaled_image);        return((Image *) NULL);s     }    /*     Scale image.   */
   index=0;   number_rows=0;   next_row=True;2   x_scale=UpShift(scaled_image->rows)/image->rows;   x_span=UpShift(1);$   for (x=0; x < image->columns; x++)   {s     y_vector[x].red=0;     y_vector[x].green=0;     y_vector[x].blue=0;t     y_vector[x].index=0;   }u   p=image->pixels;   image->runlength=p->length+1;o   q=scaled_image->pixels;    q->red=0;a
   q->green=0;    q->blue=0;
   q->index=0;    q->length=MaxRunlength;I(   for (y=0; y < scaled_image->rows; y++)   {m*     if (scaled_image->rows == image->rows)(       for (x=0; x < image->columns; x++)       {;
         /*           Read a new scanline.
         */"         if (image->runlength != 0)           image->runlength--;          else           {*             p++;'             image->runlength=p->length;i           }g         x_vector[x].red=p->red;o#         x_vector[x].green=p->green;n!         x_vector[x].blue=p->blue;n#         x_vector[x].index=p->index;)       }M     else       {n
         /*           Scale Y direction.
         */          while (x_scale < x_span)	         {u6           if (next_row && (number_rows < image->rows))
             {l               /*$                 Read a new scanline.               */0               for (x=0; x < image->columns; x++)               {g*                 if (image->runlength != 0)%                   image->runlength--;t                 else                   {+                     p++;/                     image->runlength=p->length;                    }0'                 x_vector[x].red=p->red;r+                 x_vector[x].green=p->green; )                 x_vector[x].blue=p->blue; +                 x_vector[x].index=p->index;                })               number_rows++;
             }e,           for (x=0; x < image->columns; x++)           { 5             y_vector[x].red+=x_scale*x_vector[x].red; 9             y_vector[x].green+=x_scale*x_vector[x].green;r7             y_vector[x].blue+=x_scale*x_vector[x].blue;/9             y_vector[x].index+=x_scale*x_vector[x].index;            }*           x_span-=x_scale;:           x_scale=UpShift(scaled_image->rows)/image->rows;           next_row=True;	         }g4         if (next_row && (number_rows < image->rows))           {a             /*"               Read a new scanline.             */.             for (x=0; x < image->columns; x++)
             {q(               if (image->runlength != 0)#                 image->runlength--;e               else                 {q                   p++;-                   image->runlength=p->length;r                 } %               x_vector[x].red=p->red;_)               x_vector[x].green=p->green;-'               x_vector[x].blue=p->blue;l)               x_vector[x].index=p->index;]
             }m             number_rows++;             next_row=False;m           }          s=scanline; *         for (x=0; x < image->columns; x++)	         {%@           red=DownShift(y_vector[x].red+x_span*x_vector[x].red);F           green=DownShift(y_vector[x].green+x_span*x_vector[x].green);C           blue=DownShift(y_vector[x].blue+x_span*x_vector[x].blue); F           index=DownShift(y_vector[x].index+x_span*x_vector[x].index);-           s->red=red > MaxRGB ? MaxRGB : red; 3           s->green=green > MaxRGB ? MaxRGB : green; 0           s->blue=blue > MaxRGB ? MaxRGB : blue;E           s->index=index > MaxColormapSize ? MaxColormapSize : index;            s++;           y_vector[x].red=0;           y_vector[x].green=0;           y_vector[x].blue=0;            y_vector[x].index=0;	         }%         x_scale-=x_span;         if (x_scale == 0)%           { <             x_scale=UpShift(scaled_image->rows)/image->rows;             next_row=True;           }          x_span=UpShift(1);       } 0     if (scaled_image->columns == image->columns)       {e
         /*,           Transfer scanline to scaled image.
         */         s=scanline;e1         for (x=0; x < scaled_image->columns; x++)l	         { =           if ((s->red == q->red) && (s->green == q->green) &&h?               (s->blue == q->blue) && (s->index == q->index) &&h/               ((int) q->length < MaxRunlength))a             q->length++;           else
             {/-               if (scaled_image->packets != 0)l                 q++;&               scaled_image->packets++;3               if (scaled_image->packets == packets)                  {                    packets<<=1;K                   scaled_image->pixels=(RunlengthPacket *) realloc((char *)iJ                     scaled_image->pixels,packets*sizeof(RunlengthPacket));G                   if (scaled_image->pixels == (RunlengthPacket *) NULL)n                     {g6                       Warning("Unable to scale image",4                         "Memory allocation failed");1                       DestroyImage(scaled_image);n-                       return((Image *) NULL);n                     }nA                   q=scaled_image->pixels+scaled_image->packets-1;o                 }m               q->red=s->red;                q->green=s->green;               q->blue=s->blue;                q->index=s->index;               q->length=0;
             }p           s++;	         }m       }l     else       {c         into           next_column;           long           y_scale,           y_span;   
         /*           Scale X direction.
         */         red=0;         green=0;         blue=0;          next_column=False;         y_span=UpShift(1);         s=scanline;          t=scaled_scanline;*         for (x=0; x < image->columns; x++)	         { @           y_scale=UpShift(scaled_image->columns)/image->columns;#           while (y_scale >= y_span)c           {              if (next_column)               {n                 red=0;                 green=0;                 blue=0;g                 index=0;                 t++;               }a-             red=DownShift(red+y_span*s->red);%3             green=DownShift(green+y_span*s->green); 0             blue=DownShift(blue+y_span*s->blue);3             index=DownShift(index+y_span*s->index); /             t->red=red > MaxRGB ? MaxRGB : red; 5             t->green=green > MaxRGB ? MaxRGB : green; 2             t->blue=blue > MaxRGB ? MaxRGB : blue;G             t->index=index > MaxColormapSize ? MaxColormapSize : index;              y_scale-=y_span;             y_span=UpShift(1);             next_column=True;            }          if (y_scale > 0)           {              if (next_column)               {                  red=0;                 green=0;                 blue=0;%                 index=0;"                 next_column=False;                 t++;               }e              red+=y_scale*s->red;$             green+=y_scale*s->green;"             blue+=y_scale*s->blue;$             index+=y_scale*s->index;             y_span-=y_scale;           }a         s++;       }        if (y_span > 0)a	         {            s--;           red+=y_span*s->red;f!           green+=y_span*s->green;n           blue+=y_span*s->blue;h!           index+=y_span*s->index; 	         }e       if (!next_column)a	         {            red=DownShift(red);e!           green=DownShift(green);e           blue=DownShift(blue);I!           index=DownShift(index);p-           t->red=red > MaxRGB ? MaxRGB : red; 3           t->green=green > MaxRGB ? MaxRGB : green; 0           t->blue=blue > MaxRGB ? MaxRGB : blue;3           t->index=index > MaxRGB ? MaxRGB : index;l	         }*       /**         Transfer scanline to scaled image.       */       t=scaled_scanline;/       for (x=0; x < scaled_image->columns; x++)=       {);         if ((t->red == q->red) && (t->green == q->green) &&r=             (t->blue == q->blue) && (t->index == q->index) && -             ((int) q->length < MaxRunlength))o           q->length++;         else           {)+             if (scaled_image->packets != 0))               q++;$             scaled_image->packets++;1             if (scaled_image->packets == packets)o               {                  packets<<=1;I                 scaled_image->pixels=(RunlengthPacket *) realloc((char *)/H                   scaled_image->pixels,packets*sizeof(RunlengthPacket));E                 if (scaled_image->pixels == (RunlengthPacket *) NULL)                    { P                     Warning("Unable to scale image","Memory allocation failed");/                     DestroyImage(scaled_image);h+                     return((Image *) NULL);                    }e?                 q=scaled_image->pixels+scaled_image->packets-1;                }p             q->red=t->red;             q->green=t->green;             q->blue=t->blue;             q->index=t->index;             q->length=0;           }          t++;       }r     }o9     ProgressMonitor(ScaleImageText,y,scaled_image->rows);(   }*;   scaled_image->pixels=(RunlengthPacket *) realloc((char *)%H     scaled_image->pixels,scaled_image->packets*sizeof(RunlengthPacket));   /*     Free allocated memory.   */   free((char *) y_vector);!   free((char *) scaled_scanline);    if (scanline != x_vector)      free((char *) scanline);   free((char *) x_vector);   return(scaled_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t I m a g e I n f o                                                   %%O %                                                                             %tO %                                                                             %/O %                                                                             %FO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %AH %  Function SetImageInfo initializes the `magick' field of the ImageInfoI %  structure.  It is set to a type of image format based on the prefix orsI %  suffix of the filename.  For example, `ps:image' returns PS indicatingfH %  a Postscript image.  JPEG is returned for this filename: `image.jpg'.M %  The filename prefix has precedance over the suffix.  Use an optional index L %  enclosed in brackets after a file name to specify a desired subimage of aE %  multi-resolution image format like Photo CD (e.g. img0001.pcd[4]).  %n- %  The format of the SetImageInfo routine is:  %  %      SetImageInfo(image_info)h %k+ %  A description of each parameter follows:  % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %t %  */( void SetImageInfo(ImageInfo *image_info) {f   char     c,     magick[MaxTextLength];     register char      *p,      *q;n     register int     i;     /*(     Look for 'image.format' in filename.   */   *magick='\0';e8   p=image_info->filename+strlen(image_info->filename)-1;   if (*p == ']').     for (q=p-1; q > image_info->filename; q--)     {n       if (*q != '[')         continue;_;       image_info->tile=(char *) malloc((p-q)*sizeof(char));w,       if (image_info->tile == (char *) NULL)         break;1       (void) strncpy(image_info->tile,q+1,p-q-1);L#       image_info->tile[p-q-1]='\0';a(       if (!IsGeometry(image_info->tile))	         {e(           (void) free(image_info->tile);)           image_info->tile=(char *) NULL;            break;	         }(       /*2         Sub-image specified (e.g. img0001.pcd[4]).       */2       image_info->subimage=atoi(image_info->tile);2       image_info->subrange=atoi(image_info->tile);C       (void) sscanf(image_info->tile,"%u-%u",&image_info->subimage,l         &image_info->subrange); 3       image_info->subrange-=image_info->subimage-1;i       *q='\0';
       p=q;       break;     }h3   while ((*p != '.') && (p > image_info->filename))l     p--;6   if ((strcmp(p,".gz") == 0) || (strcmp(p,".Z") == 0))     do     {d
       p--;8     } while ((*p != '.') && (p > image_info->filename));2   if ((*p == '.') && (strlen(p) < sizeof(magick)))     {h       /*$         User specified image format.       */        (void) strcpy(magick,p+1);%       for (q=magick; *q != '\0'; q++)o       {          if (*q == '.')           {l             *q='\0';             break;           }          c=(*q);t         if (islower(c))d           *q=toupper(c);       }s9       for (i=0; ImageFormats[i][0] != (char *) NULL; i++)y3         if (strcmp(magick,ImageFormats[i][0]) == 0);           {              /*(               SGI and RGB are ambiguous.             */=             if ((strncmp(image_info->magick,"SGI",3) != 0) ||r8                 (strcmp(ImageFormats[i][0],"RGB") != 0))7               (void) strcpy(image_info->magick,magick);o             break;           }e     }v   /*1     Look for explicit 'format:image' in filename.x   */   image_info->assert=False;t   p=image_info->filename;a%   while ((*p != ':') && (*p != '\0'))      p++;A   if ((*p == ':') && ((p-image_info->filename) < sizeof(magick)))-     {b       /*$         User specified image format.       */I       (void) strncpy(magick,image_info->filename,p-image_info->filename); *       magick[p-image_info->filename]='\0';%       for (q=magick; *q != '\0'; q++)        {+         c=(*q);          if (islower(c))-           *q=toupper(c);       }09       for (i=0; ImageFormats[i][0] != (char *) NULL; i++)a3         if (strcmp(magick,ImageFormats[i][0]) == 0)r           {e             /*,               Strip off image format prefix.             */             p++;2             (void) strcpy(image_info->filename,p);5             (void) strcpy(image_info->magick,magick);f*             if (strcmp(magick,"TMP") != 0)&               image_info->assert=True;             break;           }-     }g }-   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             %-O %     S h a r p e n I m a g e                                                 % O %                                                                             %;O %                                                                             %iO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function SharpenImage creates a new image that is a copy of an existingL %  one with the pixels sharpened.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. %wK %  SharpenImage convolves the pixel neighborhood with this sharpening mask:  %m
 %    -1 -2 -1e
 %    -2  W -2 
 %    -1 -2 -1  %oL %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.t % - %  The format of the SharpenImage routine is:_ %o1 %      sharpened_image=SharpenImage(image,factor)  % + %  A description of each parameter follows:  %qL %    o sharpened_image: Function SharpenImage returns a pointer to the imageL %      after it is sharpened.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.% %%L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  *// Image *SharpenImage(Image *image,double factor)  {  #define Sharpen(weight) \ '   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \ +   total_index+=(weight)*(int) (s->index); \    s++;3 #define SharpenImageText  "  Sharpening image...  "      Image      *sharpened_image;      long     total_blue,      total_green,     total_index,     total_red,     weight;%     register RunlengthPacket     *p,      *q,      *s,e     *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacketa     *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     {oF       Warning("Unable to sharpen image","image size must exceed 3x3");       return((Image *) NULL);      }c   /**     Initialize sharpened image attributes.   */D   sharpened_image=CopyImage(image,image->columns,image->rows,False);(   if (sharpened_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } %   sharpened_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(3*(image->columns+1)*sizeof(RunlengthPacket));l+   if (scanline == (RunlengthPacket *) NULL)      {_D       Warning("Unable to enhance image","Memory allocation failed");$       DestroyImage(sharpened_image);       return((Image *) NULL);m     }    /*)     Read the first two rows of the image.B   */   p=image->pixels;   image->runlength=p->length+1; ,   for (x=0; x < (3*(image->columns+1)); x++)     scanline[x]=(*p);a
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)G   {+     if (image->runlength != 0)       image->runlength--;0     else       {]         p++;#         image->runlength=p->length;        }o     *s=(*p);     s++;   }    /*!     Dump first scanline of image.m   */   q=sharpened_image->pixels;
   s=scanline;x$   for (x=0; x < image->columns; x++)   {r     *q=(*s);     q->index=0;_     q->length=0;     q++;     s++;   }l   /*     Convolve each row.   */&   weight=(long) ((100.0-factor)/2+13);   quantum=Max(weight-12,1);)%   for (y=1; y < (image->rows-1); y++)l   {m     /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2;p&     for (x=0; x < image->columns; x++)     {e        if (image->runlength != 0)         image->runlength--;+
       else	         {T           p++;%           image->runlength=p->length;t	         }a       *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */
     *q=(*s1);l     q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_index=0;       s=s0;m,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       s=s1;g0       Sharpen(-2); Sharpen(weight); Sharpen(-2);       s=s2; ,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       if (total_red < 0)         q->red=0; 
       else)         if (total_red > (MaxRGB*quantum))%           q->red=MaxRGB;         else@           q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);       if (total_green < 0)         q->green=0; 
       else+         if (total_green > (MaxRGB*quantum))            q->green=MaxRGB;         elseD           q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);       if (total_blue < 0)          q->blue=0;
       else*         if (total_blue > (MaxRGB*quantum))           q->blue=MaxRGB;          elseB           q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       if (total_index < 0)         q->index=0; 
       else+         if (total_index > (MaxRGB*quantum))%           q->index=MaxRGB;         elseK           q->index=(unsigned short) ((total_index+(quantum >> 1))/quantum);        q->length=0;
       q++;       s0++;i       s1++;        s2++;n     }t     /**       Transfer last pixel of the scanline.     */	     s1++;o
     *q=(*s1);      q->length=0;     q++;6     ProgressMonitor(SharpenImageText,y,image->rows-1);   }t   /*!     Dump last scanline of pixels.f   */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {p     *q=(*s);     q->length=0;     q++;     s++;   }h   free((char *) scanline);   return(sharpened_image); }a i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %%O %                                                                             % O %     S o l a r i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function SolarizeImage produces a 'solarization' effect seen when exposing ? %  a photographic film to light during the development process.f %%. %  The format of the SolarizeImage routine is: %%" %      SolarizeImage(image,factor) %t+ %  A description of each parameter follows:r %uF %    o image: The address of a structure of type Image;  returned from %      ReadImage.o % L %    o factor:  An double value that defines the extent of the solarization. %s %p */4 void SolarizeImage(Image *image,const double factor) {f? #define SolarizeImageText  "  Solarizing the image colors...  "g     register int     i;     register RunlengthPacket     *p;o     unsigned int     threshold;  $   threshold=factor*(MaxRGB+1)/100.0;   switch (image->class)    {e     case DirectClass:      {_       /*%         Solarize DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {o;         p->red=p->red > threshold ? MaxRGB-p->red : p->red;gC         p->green=p->green > threshold ? MaxRGB-p->green : p->green; ?         p->blue=p->blue > threshold ? MaxRGB-p->blue : p->blue;L         p++;!         if (QuantumTick(i,image))_>           ProgressMonitor(SolarizeImageText,i,image->packets);       };       break;     }m     case PseudoClass:i     {s       /*%         Solarize PseudoClass packets._       */'       for (i=0; i < image->colors; i++)I       {rC         image->colormap[i].red=image->colormap[i].red > threshold ?mA           MaxRGB-image->colormap[i].red : image->colormap[i].red;=G         image->colormap[i].green=image->colormap[i].green > threshold ?nE           MaxRGB-image->colormap[i].green : image->colormap[i].green;%E         image->colormap[i].blue=image->colormap[i].blue > threshold ? C           MaxRGB-image->colormap[i].blue : image->colormap[i].blue;        }        SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     S p r e a d I m a g e                                                   %%O %                                                                             % O %                                                                             %wO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %mI %  Function SpreadImage creates a new image that is a copy of an existingeI %  one with the image pixels randomly displaced.  It allocates the memoryfI %  necessary for the new Image structure and returns a pointer to the newr	 %  image.g % , %  The format of the SpreadImage routine is: %u- %      spread_image=SpreadImage(image,amount)  % + %  A description of each parameter follows:e %aH %    o spread_image: Function SpreadImage returns a pointer to the imageI %      after it is spread.  A null image is returned if there is a memoryh %      shortage. %aF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %pK %    o amount:  An unsigned value constraining the "vicintity" for choosingl %      a random pixel to swap. %> %u */4 Image *SpreadImage(Image *image,unsigned int amount) { 1 #define SpreadImageText  "  Spreading image...  "      Image      *spread_image;     long     quantum,     x_distance,m     y_distance;      register RunlengthPacket     *p,)     *q;=     register unsigned int      x;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to spread image","image size must exceed 3x3");)       return((Image *) NULL);      }p   if (!UncompressImage(image))     return((Image *) NULL);x   /*'     Initialize spread image attributes.    */A   spread_image=CopyImage(image,image->columns,image->rows,False);u%   if (spread_image == (Image *) NULL)n     {tD       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);>     };"   spread_image->class=DirectClass;   /*     Convolve each row.   */   srand(time((time_t *) NULL));    amount++;    quantum=amount >> 1;   q=spread_image->pixels;g!   for (y=0; y < image->rows; y++)t   { &     for (x=0; x < image->columns; x++)     { +       x_distance=(rand() & amount)-quantum; +       y_distance=(rand() & amount)-quantum; C       p=image->pixels+(y+y_distance)*image->columns+(x+x_distance); F       if ((p > image->pixels) && (p < (image->pixels+image->packets)))         *q=(*p);
       q++;     }g3     ProgressMonitor(SpreadImageText,y,image->rows);r   }s   return(spread_image);e }p a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             % O %                                                                             % O %                                                                             %oO %   S o r t C o l o r m a p B y I n t e n t s i t y                           %eO %                                                                             %fO %                                                                             %-O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= %gM %  Function SortColormapByIntensity sorts the colormap of a PseudoClass image ! %  by decreasing color intensity.s %+8 %  The format of the SortColormapByIntensity routine is: %n% %      SortColormapByIntensity(image)e %s+ %  A description of each parameter follows:e %s- %    o image: A pointer to a Image structure.s %t %l */8 static int IntensityCompare(const void *x,const void *y) { 
   ColorPacket 
     *color_1, 
     *color_2;      color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }   * void SortColormapByIntensity(Image *image) {s   register int     i;     register RunlengthPacket     *p;;     register unsigned short 
     index;     unsigned short     *pixels;  "   if (image->class != PseudoClass)     return;g   /*&     Allocate memory for pixel indexes.   */I   pixels=(unsigned short *) malloc(image->colors*sizeof(unsigned short)); (   if (pixels == (unsigned short *) NULL)     { D       Warning("Unable to sort colormap","Memory allocation failed");
       return;      }    /*,     Assign index values to colormap entries.   */#   for (i=0; i < image->colors; i++) 0     image->colormap[i].index=(unsigned short) i;   /*7     Sort image colormap by decreasing color popularity.    */I   qsort((void *) image->colormap,(int) image->colors,sizeof(ColorPacket), <     (int (*)(const void *, const void *)) IntensityCompare);   /*;     Update image colormap indexes to sorted colormap order.e   */#   for (i=0; i < image->colors; i++)c8     pixels[image->colormap[i].index]=(unsigned short) i;   p=image->pixels;$   for (i=0; i < image->packets; i++)   {=     index=pixels[p->index];A&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p->index=index;      p++;   }    free((char *) pixels); }i h /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %gO %                                                                             %%O %   S t e r e o I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function StereoImage combines two images and produces a single image thatI %  is the composite of a left and right image of a stereo pair.  The left%I %  image is converted to gray_scale and written to the red channel of therO %  stereo image.  The right image is converted to gray_scale and written to theDL %  blue channel of the stereo image.  View the composite image with red-blue% %  glasses to create a stereo effect.  % , %  The format of the StereoImage routine is: %o7 %      stereo_image=StereoImage(left_image,right_image)s %y+ %  A description of each parameter follows:i % I %    o stereo_image: Function StereoImage returns a pointer to the stereocF %      image.  A null image is returned if there is a memory shortage. %d< %    o left_image: The address of a structure of type Image. %n= %    o right_image: The address of a structure of type Image.  %y %a */8 Image *StereoImage(Image *left_image,Image *right_image) { . #define StereoImageText  "  Stereo image...  "     Imaget     *stereo_image;     intm     y;     register int     x;     register RunlengthPacket     *p,i     *q,m     *r;e  6   if ((left_image->columns != right_image->columns) ||.       (left_image->rows != right_image->rows))     { .       Warning("Unable to create stereo image",-         "left and right image sizes differ");(       return((Image *) NULL);,     }o   /*'     Initialize stereo image attributes.    */P   stereo_image=CopyImage(left_image,left_image->columns,left_image->rows,False);%   if (stereo_image == (Image *) NULL)c     {[J       Warning("Unable to create stereo image","Memory allocation failed");       return((Image *) NULL);      } "   stereo_image->class=DirectClass;   /*C     Copy left image to red channel and right image to blue channel.%   */7   QuantizeImage(left_image,256,8,False,GRAYColorspace);    SyncImage(left_image);   p=left_image->pixels; $   left_image->runlength=p->length+1;8   QuantizeImage(right_image,256,8,False,GRAYColorspace);   SyncImage(right_image);    q=right_image->pixels;%   right_image->runlength=q->length+1;    r=stereo_image->pixels; (   for (y=0; y < stereo_image->rows; y++)   { -     for (x=0; x < stereo_image->columns; x++)      { %       if (left_image->runlength != 0)           left_image->runlength--;
       else	         {            p++;*           left_image->runlength=p->length;	         }%&       if (right_image->runlength != 0)!         right_image->runlength--;a
       else	         {            q++;+           right_image->runlength=q->length;m	         }d-       r->red=(unsigned int) (p->red*12) >> 4;e       r->green=0;e       r->blue=q->blue;       r->index=0;c       r->length=0;
       r++;     }o:     ProgressMonitor(StereoImageText,y,stereo_image->rows);   }p   return(stereo_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %bO %                                                                             %oO %     S w i r l I m a g e                                                     % O %                                                                             %mO %                                                                             %iO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%* %UH %  Function SwirlImage creates a new image that is a copy of an existingN %  one with the image pixels "swirled" at a specified angle.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.= %F+ %  The format of the SwirlImage routine is:U %l. %      swirled_image=SwirlImage(image,degrees) % + %  A description of each parameter follows:  % H %    o swirled_image: Function SwirlImage returns a pointer to the imageJ %      after it is swirled.  A null image is returned if there is a memory %      shortage. %qF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o degrees:  An double value that defines the tightness of the swirling. %  %L */. Image *SwirlImage(Image *image,double degrees) {b/ #define SwirlImageText  "  Swirling image...  "%     double     cosine,f
     distance,      factor,      radius,U	     sine, 
     x_center,      x_distance,o     x_scale,
     y_center,i     y_distance,      y_scale;     ImageC     *swirled_image;      register RunlengthPacket     *p,m     *q;.     register unsigned inth     x;     unsigned int     y;     if (!UncompressImage(image))     return((Image *) NULL);i   /*(     Initialize swirled image attributes.   */B   swirled_image=CopyImage(image,image->columns,image->rows,False);&   if (swirled_image == (Image *) NULL)     {<B       Warning("Unable to swirl image","Memory allocation failed");       return((Image *) NULL);l     }a#   swirled_image->class=DirectClass;    /*     Compute scaling factor.;   */   x_scale=1.0;   y_scale=1.0;'   x_center=(double) image->columns/2.0; $   y_center=(double) image->rows/2.0;   radius=x_center;#   if (image->columns > image->rows)n'     y_scale=image->columns/image->rows;    else%     if (image->columns < image->rows)        { +         x_scale=image->rows/image->columns;'         radius=y_center;       }f$   degrees=DegreesToRadians(degrees);   /*     Swirl each row.m   */   p=image->pixels;   q=swirled_image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {n       /*4         Determine if the pixel is within an ellipse.       *//       x_distance=x_scale*((double) x-x_center);-/       y_distance=y_scale*((double) y-y_center); C       distance=AbsoluteValue(x_distance)+AbsoluteValue(y_distance);        if (distance >= radius)          *q=(*p);
       else	         {m           /*             Swirl the pixel.           */%           factor=1.0-distance/radius;'           factor*=factor;i#           sine=sin(degrees*factor); %           cosine=cos(degrees*factor);a!           *q=Interpolate(image,p, A             (cosine*x_distance-sine*y_distance)/x_scale+x_center,-B             (sine*x_distance+cosine*y_distance)/y_scale+y_center);	         } 
       p++;
       q++;     }u2     ProgressMonitor(SwirlImageText,y,image->rows);   }(   return(swirled_image); };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %aO %                                                                             % O %                                                                             %%O %   S y n c I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function SyncImage initializes the red, green, and blue intensities of each* %  pixel as defined by the colormap index. % * %  The format of the SyncImage routine is: %  %      SyncImage(image)  % + %  A description of each parameter follows:% %%7 %    o image: The address of a structure of type Image.  %o %  */ void SyncImage(Image *image) {i   register int     i;     register RunlengthPacket     *p;      register unsigned shorts
     index;  "   if (image->class == DirectClass)     return;h#   for (i=0; i < image->colors; i++)n   {      image->colormap[i].index=0;f     image->colormap[i].flags=0;l   }.   p=image->pixels;$   for (i=0; i < image->packets; i++)   {_     index=p->index;m&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p++;   }a }p m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             %aO %     T e x t u r e I m a g e                                                 %tO %                                                                             % O %                                                                             % O %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_ %gJ %  Function TextureImage layers a texture onto the background of an image. %c- %  The format of the TextureImage routine is:  % # %      TextureImage(image,filename)C %s+ %  A description of each parameter follows:  %/F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %0K %    o filename: This file contains the texture to layer on the background.v %  %  */. void TextureImage(Image *image,char *filename) {c8 #define TextureImageText  "  Appling image texture...  "     Imagep     *texture_image;      ImageInfo;     texture_info;;     int+     x,     y;      if (filename == (char *) NULL)     return;r   /*     Read the texture image.r   */   GetImageInfo(&texture_info);0   (void) strcpy(texture_info.filename,filename);)   texture_image=ReadImage(&texture_info);n&   if (texture_image == (Image *) NULL)     return;d   /*+     Tile texture onto the image background.    */4   for (y=0; y < image->rows; y+=texture_image->rows)   {s<     for (x=0; x < image->columns; x+=texture_image->columns)A       CompositeImage(image,ReplaceCompositeOp,texture_image,x,y);14     ProgressMonitor(TextureImageText,y,image->rows);   }    DestroyImage(texture_image); }i   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%>O %                                                                             % O %                                                                             %+O %                                                                             % O %   T r a n s f o r m I m a g e                                               %>O %                                                                             %(O %                                                                             % O %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %(L %  Function TransformImage creates a new image that is a transformed size ofE %  of existing one as specified by the crop and image geometries.  ItuK %  allocates the memory necessary for the new Image structure and returns ax %  pointer to the new image. %iH %  If a crop geometry is specified a subregion of the image is obtained.M %  If the specified image size, as defined by the image and scale geometries,(K %  is smaller than the actual image size, the image is first minified to an-N %  integral of the specified image size with an antialias digital filter.  TheD %  image is then scaled to the exact specified image size with pixelM %  replication.  If the specified image size is greater than the actual image;J %  size, the image is first enlarged to an integral of the specified imageK %  size with bilinear interpolation.  The image is then scaled to the exact / %  specified image size with pixel replication.  %+/ %  The format of the TransformImage routine is:t %i9 %      TransformImage(image,crop_geometry,image_geometry)o %2+ %  A description of each parameter follows:m %-J %    o image: The address of an address of a structure of type Image.  The7 %      transformed image is returned as this parameter.  %oD %    o crop_geometry: Specifies a pointer to a crop geometry string.6 %      This geometry defines a subregion of the image. % F %    o image_geometry: Specifies a pointer to a image geometry string.K %      The specified width and height of this geometry string are absolute.  %  %  */K void TransformImage(Image **image,char *crop_geometry,char *image_geometry)  {    Image      *transformed_image;      int 
     flags;     unsigned int     height,      sharpen,
     width;     transformed_image=(*image); %   if (crop_geometry != (char *) NULL)      {        Image          *cropped_image;          RectangleInfo          crop_info;         /*,         Crop image to a user specified size.       */       crop_info.x=0;       crop_info.y=0;       flags=O         XParseGeometry(crop_geometry,&crop_info.x,&crop_info.y,&width,&height); $       if ((flags & WidthValue) == 0)L         width=(unsigned int) ((int) transformed_image->columns-crop_info.x);%       if ((flags & HeightValue) == 0)eJ         height=(unsigned int) ((int) transformed_image->rows-crop_info.y);#       if ((flags & XNegative) != 0)r6         crop_info.x+=transformed_image->columns-width;#       if ((flags & YNegative) != 0)l4         crop_info.y+=transformed_image->rows-height;5       if (strchr(crop_geometry,'%') != (char *) NULL) 	         {h           /*4             Crop geometry is relative to image size.           */;           ParseImageGeometry(crop_geometry,&width,&height); 1           if (width > transformed_image->columns)t-             width=transformed_image->columns;l/           if (height > transformed_image->rows)t+             height=transformed_image->rows;t!           crop_info.x=width >> 1; "           crop_info.y=height >> 1;1           width=transformed_image->columns-width; 0           height=transformed_image->rows-height;!           flags|=XValue | YValue; 	         }c       crop_info.width=width;       crop_info.height=height;*       if ((width == 0) || (height == 0) ||=           ((flags & XValue) != 0) || ((flags & YValue) != 0))y>         cropped_image=CropImage(transformed_image,&crop_info);
       else	         {            Imageg             *next_image;             register int             x,             y;             /*8             Crop repeatedly to create uniform subimages.           */$           next_image=(Image *) NULL;'           cropped_image=(Image *) NULL;h;           for (y=0; y < transformed_image->rows; y+=height)            {;?             for (x=0; x < transformed_image->columns; x+=width)s
             {n$               crop_info.width=width;&               crop_info.height=height;               crop_info.x=x;               crop_info.y=y;A               next_image=CropImage(transformed_image,&crop_info);;/               if (next_image == (Image *) NULL)4                 break;2               if (cropped_image == (Image *) NULL)                 {n+                   cropped_image=next_image;i                   continue;(                 }a-               cropped_image->next=next_image;p1               next_image->previous=cropped_image;e0               cropped_image=cropped_image->next;
             }g-             if (next_image == (Image *) NULL)(               break;           }d	         }s*       if (cropped_image != (Image *) NULL)	         {s*           DestroyImage(transformed_image);;           while (cropped_image->previous != (Image *) NULL)b2             cropped_image=cropped_image->previous;*           transformed_image=cropped_image;	         }g     }m   /*)     Scale image to a user specified size.=   */#   width=transformed_image->columns; !   height=transformed_image->rows;e4   ParseImageGeometry(image_geometry,&width,&height);P   sharpen=(width*height) < (transformed_image->rows*transformed_image->columns);.   if ((transformed_image->columns != width) ||*       (transformed_image->rows != height))     {(       Images         *zoomed_image;         /*         Zoom image.        */L       zoomed_image=ZoomImage(transformed_image,width,height,MitchellFilter);)       if (zoomed_image == (Image *) NULL) @         zoomed_image=ScaleImage(transformed_image,width,height);)       if (zoomed_image != (Image *) NULL)o	         { *           DestroyImage(transformed_image);)           transformed_image=zoomed_image;r	         }-     }0   if (sharpen)L     if ((transformed_image->columns >= 3) && (transformed_image->rows >= 3))       { 
         Image            *sharpened_image;o  
         /*           Sharpen image.
         */F         sharpened_image=SharpenImage(transformed_image,SharpenFactor);.         if (sharpened_image != (Image *) NULL)           {s,             DestroyImage(transformed_image);.             transformed_image=sharpened_image;           }s       }    *image=transformed_image;g }! ) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             % O %                                                                             %mO %     T r a n s f o r m R G B I m a g e                                       % O %                                                                             % O %                                                                             %)O %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %3L %  Function TransformRGBImage converts the reference image from an alternateK %  colorspace.  The transformation matrices are not the standard ones:  the L %  weights are rescaled to normalized the range of the transformed values to %  be [0..MaxRGB]. %52 %  The format of the TransformRGBImage routine is: %5* %      TransformRGBImage(image,colorspace) % + %  A description of each parameter follows:i % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.> %;J %    o colorspace: An unsigned integer value that indicates the colorspaceD %      the image is currently in.  On return the image is in the RGB %      color space.= %- %d */B void TransformRGBImage(Image *image,const unsigned int colorspace) {d #define B (MaxRGB+1)*2 #define G (MaxRGB+1) #define R 0+A #define TransformRGBImageText  "  Transforming image colors...  "=     static QuantumJ     PCDMap[348] =  /* Photo CD information beyond 100% white, Gamma 2.2 */     {pK         0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  11,  12,  13,  14,iK        15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,iK        29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,aK        43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  55, K        56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  66,  67,  68, K        69,  70,  71,  72,  73,  74,  75,  76,  76,  77,  78,  79,  80,  81,)K        82,  83,  84,  84,  85,  86,  87,  88,  89,  90,  91,  92,  92,  93,-K        94,  95,  96,  97,  98,  99,  99, 100, 101, 102, 103, 104, 105, 106,nK       106, 107, 108, 109, 110, 111, 112, 113, 114, 114, 115, 116, 117, 118,=K       119, 120, 121, 122, 122, 123, 124, 125, 126, 127, 128, 129, 129, 130,fK       131, 132, 133, 134, 135, 136, 136, 137, 138, 139, 140, 141, 142, 142,iK       143, 144, 145, 146, 147, 148, 148, 149, 150, 151, 152, 153, 153, 154,eK       155, 156, 157, 158, 158, 159, 160, 161, 162, 163, 164, 165, 165, 166,%K       167, 168, 169, 170, 171, 172, 173, 173, 174, 175, 176, 177, 178, 178, K       179, 180, 181, 182, 182, 183, 184, 185, 186, 186, 187, 188, 189, 190, K       191, 192, 193, 194, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, K       204, 205, 205, 206, 207, 208, 209, 210, 210, 211, 212, 213, 214, 215, K       216, 216, 217, 218, 219, 220, 221, 221, 222, 223, 224, 225, 225, 226, K       227, 228, 228, 229, 230, 230, 231, 232, 233, 233, 234, 235, 235, 236, K       237, 237, 238, 239, 239, 240, 241, 241, 242, 242, 243, 243, 244, 244, K       245, 245, 245, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249,%K       250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252,aK       253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254,iK       254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,h@       254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255     };     long
     *blue,     *green,I	     *red;   	   Quantumt     *range_table;n     register int     i,     x,     y,     z;     register Quantum     *range_limit;      register RunlengthPacket     *p;,  H   if ((colorspace == RGBColorspace) || (colorspace == GRAYColorspace) ||,       (colorspace == TransparentColorspace))     return;    /*     Allocate the tables.   */1   red=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); 3   green=(long *) malloc(3*(MaxRGB+1)*sizeof(long));t2   blue=(long *) malloc(3*(MaxRGB+1)*sizeof(long));?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum));l;   if ((red == (long *) NULL) || (green == (long *) NULL) ||uC       (blue == (long *) NULL) || (range_table == (Quantum *) NULL))u     {0L       Warning("Unable to transform color space","Memory allocation failed");
       return;      }u   /*     Initialize tables.   */   for (i=0; i <= MaxRGB; i++)    {l     range_table[i]=0;.*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;b   }m%   range_limit=range_table+(MaxRGB+1);,   switch (colorspace)d   {      case OHTAColorspace:     {i       /*         Initialize OHTA tables:e  &           R = I1+1.00000*I2-0.66668*I3&           G = I1+0.00000*I2+1.33333*I3&           B = I1-1.00000*I2-0.66668*I3  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 00         through MaxRGB.0       */!       for (i=0; i <= MaxRGB; i++)&       {r&         red[i+R]=UpShifted(1.00000)*i;;         green[i+R]=UpShifted(1.0000*0.5)*((i << 1)-MaxRGB);a>         blue[i+R]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);&         red[i+G]=UpShifted(1.00000)*i;         green[i+G]=0; ;         blue[i+G]=UpShifted(1.33333*0.5)*((i << 1)-MaxRGB);h&         red[i+B]=UpShifted(1.00000)*i;?         green[i+B]=(-UpShifted(1.00000*0.5))*((i << 1)-MaxRGB); >         blue[i+B]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);       },       break;     }      case XYZColorspace:      {a       /*"         Initialize CIE XYZ tables:  /           R =  3.240479*R-1.537150*G-0.498535*B//           G = -0.969256*R+1.875992*G+0.041556*B /           B =  0.055648*R-0.204043*G+1.057311*B_       */!       for (i=0; i <= MaxRGB; i++)e       {>'         red[i+R]=UpShifted(3.240479)*i;o,         green[i+R]=(-UpShifted(1.537150))*i;+         blue[i+R]=(-UpShifted(0.498535))*i;%*         red[i+G]=(-UpShifted(0.969256))*i;)         green[i+G]=UpShifted(1.875992)*i; (         blue[i+G]=UpShifted(0.041556)*i;'         red[i+B]=UpShifted(0.055648)*i; ,         green[i+B]=(-UpShifted(0.204043))*i;(         blue[i+B]=UpShifted(1.057311)*i;       }        break;     }      case YCbCrColorspace:      {        /*          Initialize YCbCr tables:  '           R = Y            +1.370707*Cr '           G = Y-0.336453*Cb-0.698195*Cr            B = Y+1.732445*Cb   O         Cb and Cr, normally -0.5 through 0.5, must be normalized to the range 0%         through MaxRGB.%       */!       for (i=0; i <= MaxRGB; i++)n       {F'         red[i+R]=UpShifted(1.000000)*i;s         green[i+R]=0; <         blue[i+R]=UpShifted(1.370707*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i; @         green[i+G]=(-UpShifted(0.336453*0.5))*((i << 1)-MaxRGB);?         blue[i+G]=(-UpShifted(0.698195*0.5))*((i << 1)-MaxRGB);p'         red[i+B]=UpShifted(1.000000)*i; =         green[i+B]=UpShifted(1.732445*0.5)*((i << 1)-MaxRGB);r         blue[i+B]=0;       }g       break;     }      case YCCColorspace:i     {        /*         Initialize YCC tables:  '           R = Y            +1.340762*C2d'           G = Y-0.317038*C1-0.682243*C2r           B = Y+1.632639*C1   B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */!       for (i=0; i <= MaxRGB; i++)_       { %         red[i+R]=UpShifted(1.3584)*i;g         green[i+R]=0;a5         blue[i+R]=UpShifted(1.8215)*(i-UpScale(137));)%         red[i+G]=UpShifted(1.3584)*i;,A         green[i+G]=(-(UpShifted(0.194*2.2179)*(i-UpScale(156))));M@         blue[i+G]=(-(UpShifted(0.509*1.8215)*(i-UpScale(137))));%         red[i+B]=UpShifted(1.3584)*i;i6         green[i+B]=UpShifted(2.2179)*(i-UpScale(156));         blue[i+B]=0;J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       }i$       for ( ; i < UpScale(348); i++)J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       break;     }o     case YIQColorspace:I     {        /*         Initialize YIQ tables:  +           R = 0.97087*Y+1.17782*I+0.59800*Qa+           G = 0.97087*Y-0.28626*I-0.72851*QB+           B = 0.97087*Y-1.27870*I+1.72801*Qn  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0r         through MaxRGB.u       */!       for (i=0; i <= MaxRGB; i++)r       {a&         red[i+R]=UpShifted(0.97087)*i;<         green[i+R]=UpShifted(1.17782*0.5)*((i << 1)-MaxRGB);;         blue[i+R]=UpShifted(0.59800*0.5)*((i << 1)-MaxRGB);b&         red[i+G]=UpShifted(0.97087)*i;?         green[i+G]=(-UpShifted(0.28626*0.5))*((i << 1)-MaxRGB);_>         blue[i+G]=(-UpShifted(0.72851*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(0.97087)*i;?         green[i+B]=(-UpShifted(1.27870*0.5))*((i << 1)-MaxRGB);c;         blue[i+B]=UpShifted(1.72801*0.5)*((i << 1)-MaxRGB);        }        break;     }      case YPbPrColorspace:(     {r       /*          Initialize YPbPr tables:  '           R = Y            +1.402000*C2('           G = Y-0.344136*C1+0.714136*C2e           B = Y+1.772000*C1a  O         Pb and Pr, normally -0.5 through 0.5, must be normalized to the range 0a         through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)_       {r'         red[i+R]=UpShifted(1.000000)*i;e         green[i+R]=0;L<         blue[i+R]=UpShifted(1.402000*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i; @         green[i+G]=(-UpShifted(0.344136*0.5))*((i << 1)-MaxRGB);<         blue[i+G]=UpShifted(0.714136*0.5)*((i << 1)-MaxRGB);'         red[i+B]=UpShifted(1.000000)*i;f=         green[i+B]=UpShifted(1.772000*0.5)*((i << 1)-MaxRGB);i         blue[i+B]=0;       }o       break;     }      case YUVColorspace:0     default:     {r       /*         Initialize YUV tables:  #           R = Y          +1.13980*Vh#           G = Y-0.39380*U-0.58050*Vf           B = Y+2.02790*U   M         U and V, normally -0.5 through 0.5, must be normalized to the range 0a         through MaxRGB.o       */!       for (i=0; i <= MaxRGB; i++)I       {U&         red[i+R]=UpShifted(1.00000)*i;         green[i+R]=0; ;         blue[i+R]=UpShifted(1.13980*0.5)*((i << 1)-MaxRGB);r&         red[i+G]=UpShifted(1.00000)*i;?         green[i+G]=(-UpShifted(0.39380*0.5))*((i << 1)-MaxRGB); >         blue[i+G]=(-UpShifted(0.58050*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(1.00000)*i;<         green[i+B]=UpShifted(2.02790*0.5)*((i << 1)-MaxRGB);         blue[i+B]=0;       }        break;     }X   }c   /*     Convert to RGB.    */   switch (image->class)l   {g     case DirectClass:      {r       /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          x=p->red;r         y=p->green;t         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];rG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];sF         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;!         if (QuantumTick(i,image)) B           ProgressMonitor(TransformRGBImageText,i,image->packets);       }c       break;     }      case PseudoClass:;     {        /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)o       {T!         x=image->colormap[i].red;p#         y=image->colormap[i].green;o"         z=image->colormap[i].blue;         image->colormap[i].red=i@           range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];!         image->colormap[i].green=0@           range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];          image->colormap[i].blue=@           range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];       }0       p=image->pixels;(       for (i=0; i < image->packets; i++)       {,         x=p->red;          y=p->green;r         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];sG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];4F         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;       }        break;     }    }n   /*     Free allocated memory.   */   free((char *) range_table);t   free((char *) blue);   free((char *) green);    free((char *) red);e }n n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %rO %     T r a n s p a r e n t I m a g e                                         %eO %                                                                             %iO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function TransparentImage creates a matte image associated with theF %  image.  All pixel locations are initially set to opaque.  Any pixel; %  that matches the specified color are set to transparent.) % 1 %  The format of the TransparentImage routine is:e %p$ %      TransparentImage(image,color) % + %  A description of each parameter follows:  %eF %    o image: The address of a structure of type Image;  returned from %      ReadImage.r %oB %    o color: A character string that contain an X11 color string. %  %( *// void TransparentImage(Image *image,char *color)  {  #define DeltaX  16M #define TransparentImageText  "  Setting transparent color in the image...  "n     register int     i;  	   Quantum=	     blue, 
     green,     red;     register RunlengthPacket     *p;      unsigned int     status;      XColor     target_color;b     /*2     Determine RGB values of the transparent color.   */2   status=XQueryColorDatabase(color,&target_color);   if (status == False)     return; #   red=XDownScale(target_color.red); '   green=XDownScale(target_color.green);=%   blue=XDownScale(target_color.blue);    /*!     Make image color transparent.    */   if (!image->matte)     {        /*)         Initialize image matte to opaque.n       */       image->class=DirectClass;        image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {t         p->index=Opaque;         p++;       }i     }=   p=image->pixels;$   for (i=0; i < image->packets; i++)   {e.     if (((int) p->red < (int) (red+DeltaX)) &&.         ((int) p->red > (int) (red-DeltaX)) &&2         ((int) p->green < (int) (green+DeltaX)) &&2         ((int) p->green > (int) (green-DeltaX)) &&0         ((int) p->blue < (int) (blue+DeltaX)) &&.         ((int) p->blue > (int) (blue-DeltaX)))       p->index=Transparent;f     p++;     if (QuantumTick(i,image))t=       ProgressMonitor(TransparentImageText,i,image->packets);    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %(O %                                                                             %aO %                                                                             %-O %   U n C o m p r e s s I m a g e                                             % O %                                                                             %mO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%y %gL %  Function UncompressImage uncompresses runlength-encoded pixels packets to! %  a rectangular array of pixels.  %f0 %  The format of the UncompressImage routine is: %h$ %      status=UncompressImage(image) %a+ %  A description of each parameter follows:r %vD %    o status: Function UncompressImage returns True if the image is$ %      uncompressed otherwise False. %.7 %    o image: The address of a structure of type Image.  %  %m */* unsigned int UncompressImage(Image *image) {d   register int     i,     j,     length;      register RunlengthPacket     *p,o     *q;_     RunlengthPacket      *uncompressed_pixels;r  5   if (image->packets == (image->columns*image->rows))a     return(True);i   /*)     Uncompress runlength-encoded packets.)   */I   uncompressed_pixels=(RunlengthPacket *) realloc((char *) image->pixels,h8     image->columns*image->rows*sizeof(RunlengthPacket));6   if (uncompressed_pixels == (RunlengthPacket *) NULL)     return(False);$   image->pixels=uncompressed_pixels;#   p=image->pixels+image->packets-1; 5   q=uncompressed_pixels+image->columns*image->rows-1;($   for (i=0; i < image->packets; i++)   {      length=p->length;_     for (j=0; j <= length; j++)      {a       *q=(*p);       q->length=0;
       q--;     }_     p--;   }o,   image->packets=image->columns*image->rows;   return(True);l }) x /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!O %                                                                             % O %                                                                             % O %                                                                             % O %   Z o o m I m a g e                                                         %nO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ZoomImage creates a new image that is a scaled size of anmE %  existing one.  It allocates the memory necessary for the new Image!L %  structure and returns a pointer to the new image.  The Point filter givesM %  fast pixel replication, Triangle is equivalent to bi-linear interpolation,(7 %  and Mitchel giver slower, very high-quality results.  %g* %  The format of the ZoomImage routine is: %o8 %      zoomed_image=ZoomImage(image,columns,rows,filter) % + %  A description of each parameter follows:= %)L %    o zoomed_image: Function ZoomImage returns a pointer to the image afterH %      scaling.  A null image is returned if there is a memory shortage. %;7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the zoomedd
 %      image.  %(G %    o rows: An integer that specifies the number of rows in the scaleda
 %      image.e %aG %    o filter: This unsigned integer is the filter type to used to zoom) %      the image.o %n %a */   static double Box(double x)o {o   if ((x > -0.5) && (x <= 0.5))m     return(1.0);   return(0.0); }     static double Mitchell(double x) {(   double     b,     c;     b=1.0/3.0;   c=1.0/3.0;   if (x < 0)     x=(-x);    if (x < 1.0)     { N       x=(((12.0-9.0*b-6.0*c)*(x*x*x))+((-18.0+12.0*b+6.0*c)*x*x)+(6.0-2.0*b))/         6.0;       return(x);     } 
  if (x < 2.0)o    {K      x=(((-1.0*b-6.0*c)*(x*x*x))+((6.0*b+30.0*c)*x*x)+((-12.0*b-48.0*c)*x)+o        (8.0*b+24.0*c))/6.0;o      return(x);l    }   return(0.0); }     static double Triangle(double x) {n   if (x < 0.0)     x=(-x);0   if (x < 1.0)     return(1.0-x);   return(0.0); }   9 Image *ZoomImage(Image *image,const unsigned int columns,n4   const unsigned int rows,const unsigned int filter) { - #define ZoomImageText  "  Zooming image...  ""  "   typedef struct _ContributionInfo   {      int        pixel;       long
       weight;e   } ContributionInfo;      ContributionInfo     *contribution_info;)     double     center,g     filter_width,)     scale_factor, 
     width,
     x_factor,)
     y_factor;      Imagey     *source_image,     *zoomed_image;     int      n,     y;     long     blue_weight,     green_weight,      index_weight,*     red_weight,      weight;   	   Quantumf     *range_table;,     register int     i,     j,     x;     register Quantum     *range_limit;;     register RunlengthPacket     *p,(     *q;-  $   if ((columns == 0) || (rows == 0))     {cB       Warning("Unable to zoom image","image dimensions are zero");       return((Image *) NULL);_     }i   /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return((Image *) NULL);    /*'     Initialize zoomed image attributes.i   */3   zoomed_image=CopyImage(image,columns,rows,False); %   if (zoomed_image == (Image *) NULL)      { A       Warning("Unable to zoom image","Memory allocation failed");        return((Image *) NULL);t     }="   zoomed_image->class=DirectClass;H   source_image=CopyImage(image,zoomed_image->columns,image->rows,False);%   if (source_image == (Image *) NULL)      { A       Warning("Unable to zoom image","Memory allocation failed"); !       DestroyImage(zoomed_image);n       return((Image *) NULL);      }y   /*     Allocate the range table.*   */?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum));l&   if (range_table == (Quantum *) NULL)     {gA       Warning("Unable to zoom image","Memory allocation failed");a!       DestroyImage(source_image);*!       DestroyImage(zoomed_image);a       return((Image *) NULL);e     }_   /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)    {i     range_table[i]=0;g*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;L   } %   range_limit=range_table+(MaxRGB+1);e   /*     Allocate filter info list.   */   switch (filter)g   {o     case BoxFilter:o     {        FilterFunction=Box;        filter_width=0.5;n       break;     }      case TriangleFilter:     {_       FilterFunction=Triangle;       filter_width=1.0;        break;     }      case MitchellFilter:     default:     {        FilterFunction=Mitchell;       filter_width=2.0;]       break;     })   } B   x_factor=(double) zoomed_image->columns/(double) image->columns;<   y_factor=(double) zoomed_image->rows/(double) image->rows;9   width=Max(filter_width/x_factor,filter_width/y_factor);    if (width < filter_width)      width=filter_width;p(   contribution_info=(ContributionInfo *)7     malloc((int) (width*2+1)*sizeof(ContributionInfo));i5   if (contribution_info == (ContributionInfo *) NULL)      { A       Warning("Unable to zoom image","Memory allocation failed");a!       free((char *) range_table);)!       DestroyImage(source_image);m!       DestroyImage(zoomed_image);        return((Image *) NULL);      }    /*;     Apply filter to zoom horizontally from image to source.    */   width=filter_width;i   scale_factor=1.0;    if (x_factor < 1.0)      {m       width/=x_factor;       scale_factor/=x_factor;      }e+   for (x=0; x < source_image->columns; x++))   {u     n=0;%     center=(double) (x+0.5)/x_factor;sG     for (i=(int) (center-width+0.5); i < (int) (center+width+0.5); i++)m     {a
       j=i;       if (j < 0)         j=(-j);=
       else          if (j >= image->columns)&           j=(image->columns << 1)-j-1;#       contribution_info[n].pixel=j; "       contribution_info[n].weight=O         UpShifted((*FilterFunction)((i-center+0.5)/scale_factor)/scale_factor);;
       n++;     }e     q=source_image->pixels+x;g*     for (y=0; y < source_image->rows; y++)     {I       red_weight=0;e       green_weight=0;o       blue_weight=0;       index_weight=0;        for (i=0; i < n; i++)        {o+         weight=contribution_info[i].weight;"F         p=image->pixels+(y*image->columns)+contribution_info[i].pixel;"         red_weight+=weight*p->red;&         green_weight+=weight*p->green;$         blue_weight+=weight*p->blue;&         index_weight+=weight*p->index;       }a0       q->red=range_limit[DownShift(red_weight)];4       q->green=range_limit[DownShift(green_weight)];2       q->blue=range_limit[DownShift(blue_weight)];4       q->index=range_limit[DownShift(index_weight)];       q->length=0;       q+=source_image->columns;a     } N     ProgressMonitor(ZoomImageText,x,source_image->columns+zoomed_image->rows);   }    /*?     Apply filter to zoom vertically from source to destination.    */   width=filter_width;i   scale_factor=1.0;%   if (y_factor < 1.0))     {        width/=y_factor;       scale_factor/=y_factor;      }    q=zoomed_image->pixels;c(   for (y=0; y < zoomed_image->rows; y++)   {g     n=0;%     center=(double) (y+0.5)/y_factor;eG     for (i=(int) (center-width+0.5); i < (int) (center+width+0.5); i++)i     {e
       j=i;       if (j < 0)         j=(-j); 
       else#        if (j >= source_image->rows)=)          j=(source_image->rows << 1)-j-1;e#       contribution_info[n].pixel=j; "       contribution_info[n].weight=O         UpShifted((*FilterFunction)((i-center+0.5)/scale_factor)/scale_factor); 
       n++;     }s-     for (x=0; x < zoomed_image->columns; x++)      {        red_weight=0;m       green_weight=0;        blue_weight=0;       index_weight=0;t       for (i=0; i < n; i++)!       {*+         weight=contribution_info[i].weight;a         p=source_image->pixels+s?           (contribution_info[i].pixel*source_image->columns)+x;("         red_weight+=weight*p->red;&         green_weight+=weight*p->green;$         blue_weight+=weight*p->blue;&         index_weight+=weight*p->index;       }a0       q->red=range_limit[DownShift(red_weight)];4       q->green=range_limit[DownShift(green_weight)];2       q->blue=range_limit[DownShift(blue_weight)];4       q->index=range_limit[DownShift(index_weight)];       q->length=0;
       q++;     } P     ProgressMonitor(ZoomImageText,y+x,source_image->columns+zoomed_image->rows);   }    /*     Free allocated memory.   */#   free((char *) contribution_info);    free((char *) range_table);g   DestroyImage(source_image);=   return(zoomed_image);  }r