 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                                   X   X                                     % O %                                    X X                                      % O %                                     X                                       % O %                                    X X                                      % O %                                   X   X                                     % O %                                                                             % O %                    X11 Utility Routines for ImageMagick.                    % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "Colorlist.h"   /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002    /*   Global declarations. */ static unsigned int    xerror_alert = False;    /*   Function prototypes. */ static void G   XMakeImageLSBFirst(const XResourceInfo *,const XWindowInfo *,Image *,      XImage *,XImage *), G   XMakeImageMSBFirst(const XResourceInfo *,const XWindowInfo *,Image *,      XImage *,XImage *);    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s T r u e                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function IsTrue returns True if the boolean is "true", "on", "yes" or "1".  % ' %  The format of the IsTrue routine is:  %  %      option=IsTrue(boolean)  % + %  A description of each parameter follows:  % G %    o option: either True or False depending on the boolean parameter.  % 9 %    o boolean: Specifies a pointer to a character array.  %  %  */( unsigned int IsTrue(const char *boolean) {    if (boolean == (char *) NULL)      return(False);)   if (Latin1Compare(boolean,"true") == 0)      return(True); '   if (Latin1Compare(boolean,"on") == 0)      return(True); (   if (Latin1Compare(boolean,"yes") == 0)     return(True); &   if (Latin1Compare(boolean,"1") == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a t i n 1 C o m p a r e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function Latin1Compare compares two null terminated Latin-1 strings, H %  ignoring case differences, and returns an integer greater than, equalF %  to, or less than 0, according to whether first is lexicographicallyD %  greater than, equal to, or less than second.  The two strings are* %  assumed to be encoded using ISO 8859-1. % . %  The format of the Latin1Compare routine is: % " %      Latin1Compare(first,second) % + %  A description of each parameter follows:  % B %    o first: A pointer to the string to convert to Latin1 string. % C %    o second: A pointer to the string to convert to Latin1 string.  %  %  */7 int Latin1Compare(const char *first,const char *second)  {    register unsigned char    *p,    *q;     p=(unsigned char *) first;   q=(unsigned char *) second; &   while ((*p != '\0') && (*q != '\0'))   {      register unsigned char       c,       d;       c=(*p);      d=(*q);      if (c != d)        { 
         /*(           Try lowercasing and try again.
         */'         if ((c >= XK_A) && (c <= XK_Z))            c+=(XK_a-XK_A);          else7           if ((c >= XK_Agrave) && (c <= XK_Odiaeresis)) %             c+=(XK_agrave-XK_Agrave);            else6             if ((c >= XK_Ooblique) && (c <= XK_Thorn)))               c+=(XK_oslash-XK_Ooblique); '         if ((d >= XK_A) && (d <= XK_Z))            d+=(XK_a-XK_A);          else7           if ((d >= XK_Agrave) && (d <= XK_Odiaeresis)) %             d+=(XK_agrave-XK_Agrave); 9           else if ((d >= XK_Ooblique) && (d <= XK_Thorn)) '             d+=(XK_oslash-XK_Ooblique);          if (c != d) &           return(((int) c)-((int) d));       }      p++;     q++;   }     return(((int) *p)-((int) *q)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a t i n 1 U p p e r                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function Latin1Upper copies a null terminated string from source toK %  destination (including the null), changing all Latin-1 lowercase letters G %  to uppercase.  The string is assumed to be encoded using ISO 8859-1.  % , %  The format of the Latin1Upper routine is: %  %      Latin1Upper(string) % + %  A description of each parameter follows:  % G %    o string: A pointer to the string to convert to upper-case Latin1.  %  %  */% static void Latin1Upper(char *string)  {    unsigned char      c;     c=(*string);   while (c != '\0')    { #     if ((c >= XK_a) && (c <= XK_z))        *string=c-(XK_a-XK_A);     else3       if ((c >= XK_agrave) && (c <= XK_odiaeresis)) (         *string=c-(XK_agrave-XK_Agrave);
       else0         if ((c >= XK_oslash) && (c <= XK_thorn)),           *string=c-(XK_oslash-XK_Ooblique);
     string++;      c=(*string);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Function XAnnotateImage annotates the image with text.  % / %  The format of the XAnnotateImage routine is:  % B %    status=XAnnotateImage(display,pixel_info,annotate_info,image) % + %  A description of each parameter follows:  % C %    o status: Function XAnnotateImage returns True if the image is I %      successfully annotated with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */J unsigned int XAnnotateImage(Display *display,const XPixelInfo *pixel_info,2   const XAnnotateInfo *annotate_info,Image *image) { 
   ColorPacket      background_color;      GC     annotate_context;      Image      *annotate_image;     int      x,     y;     Pixmap     annotate_pixmap;     register int     i;     register RunlengthPacket     *p;      unsigned int
     depth,     height, 
     matte,
     width;     Window     root_window;     XGCValues      context_values;      XImage     *annotate_ximage;      /*     Initialize annotated image.    */   if (!UncompressImage(image))     return(False);   /*      Initialize annotated pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); I   annotate_pixmap=XCreatePixmap(display,root_window,annotate_info->width, '     annotate_info->height,(int) depth); '   if (annotate_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */   context_values.background=0;1   context_values.foreground=(unsigned long) (~0); 4   context_values.font=annotate_info->font_info->fid;H   annotate_context=XCreateGC(display,root_window,GCBackground | GCFont |"     GCForeground,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*     Draw text to pixmap.   */>   XDrawImageString(display,annotate_pixmap,annotate_context,0,?     (int) annotate_info->font_info->ascent,annotate_info->text, !     strlen(annotate_info->text)); $   XFreeGC(display,annotate_context);   /*!     Initialize annotated X image.    */M   annotate_ximage=XGetImage(display,annotate_pixmap,0,0,annotate_info->width, -     annotate_info->height,AllPlanes,ZPixmap); )   if (annotate_ximage == (XImage *) NULL)      return(False);'   XFreePixmap(display,annotate_pixmap);    /*     Initialize annotated image.    */3   annotate_image=AllocateImage((ImageInfo *) NULL); '   if (annotate_image == (Image *) NULL)      return(False);/   annotate_image->columns=annotate_info->width; -   annotate_image->rows=annotate_info->height; G   annotate_image->packets=annotate_image->columns*annotate_image->rows; ,   annotate_image->pixels=(RunlengthPacket *)B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));9   if (annotate_image->pixels == (RunlengthPacket *) NULL)      { #       DestroyImage(annotate_image);        return(False);     }    /*(     Transfer annotated X image to image.   */F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);%   p=image->pixels+y*image->columns+x;    background_color.red=p->red;"   background_color.green=p->green;    background_color.blue=p->blue;%   background_color.index=Transparent;    annotate_image->matte=True;    p=annotate_image->pixels; *   for (y=0; y < annotate_image->rows; y++)/     for (x=0; x < annotate_image->columns; x++)      { ?       p->index=(unsigned short) XGetPixel(annotate_ximage,x,y);        if (p->index == 0)	         {            /*3             Set this pixel to the background color.            */7           p->red=XDownScale(pixel_info->box_color.red); ;           p->green=XDownScale(pixel_info->box_color.green); 9           p->blue=XDownScale(pixel_info->box_color.blue);            p->index=Opaque;:           if (annotate_info->stencil == ForegroundStencil)
             { *               p->red=background_color.red;.               p->green=background_color.green;,               p->blue=background_color.blue;#               p->index=Transparent; 
             } 	         } 
       else	         {            /*,             Set this pixel to the pen color.           */7           p->red=XDownScale(pixel_info->pen_color.red); ;           p->green=XDownScale(pixel_info->pen_color.green); 9           p->blue=XDownScale(pixel_info->pen_color.blue);            p->index=Opaque;:           if (annotate_info->stencil == BackgroundStencil)
             { *               p->red=background_color.red;.               p->green=background_color.green;,               p->blue=background_color.blue;#               p->index=Transparent; 
             } 	         }        p->length=0;
       p++;     } !   XDestroyImage(annotate_ximage);    /*      Determine annotate geometry.   */F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);M   if ((width != annotate_image->columns) || (height != annotate_image->rows))      { 
       char&         image_geometry[MaxTextLength];         /*         Scale image.       */:       (void) sprintf(image_geometry,"%ux%u",width,height);C       TransformImage(&annotate_image,(char *) NULL,image_geometry);      } $   if (annotate_info->degrees != 0.0)     {        double         normalized_degrees;          Image          *rotated_image;   	       int          rotations;         /*         Rotate image.        */F       rotated_image=RotateImage(annotate_image,annotate_info->degrees,&         &background_color,False,True);*       if (rotated_image == (Image *) NULL)         return(False);#       DestroyImage(annotate_image); #       annotate_image=rotated_image;        /*9         Annotation is relative to the degree of rotation.        */0       normalized_degrees=annotate_info->degrees;(       while (normalized_degrees < -45.0)"         normalized_degrees+=360.0;?       for (rotations=0; normalized_degrees > 45.0; rotations++) !         normalized_degrees-=90.0;        switch (rotations % 4)       {          default:         case 0:            break;         case 1: 	         {            /*             Rotate 90 degrees.           */*           x-=annotate_image->columns >> 1;*           y+=annotate_image->columns >> 1;           break;	         }          case 2: 	         {            /*             Rotate 180 degrees.            */%           x-=annotate_image->columns;            break;	         }          case 3: 	         {            /*             Rotate 270 degrees.            */*           x-=annotate_image->columns >> 1;A           y-=annotate_image->rows-(annotate_image->columns >> 1);            break;	         }        }      }    /*"     Composite text onto the image.   */   p=annotate_image->pixels; -   for (i=0; i < annotate_image->packets; i++)    {       if (p->index != Transparent)       p->index=Opaque;     p++;   }    matte=image->matte; ;   CompositeImage(image,OverCompositeOp,annotate_image,x,y);    image->matte=matte;    DestroyImage(annotate_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t F o n t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XBestFont returns the "best" font.  "Best" is defined as a font J %  specified in the X resource database or a font such that the text widthG %  displayed with the font does not exceed the specified maximum width.  % * %  The format of the XBestFont routine is: % 6 %      font=XBestFont(display,resource_info,text_font) % + %  A description of each parameter follows:  % D %    o font: XBestFont returns a pointer to a XFontStruct structure. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % I %    o text_font:  True is font should be mono-spaced (typewriter style).  %  %  */  $ static char **FontToList(char *font) {    char     **fontlist;      register char      *p,      *q;      register int     i;     unsigned int
     fonts;     if (font == (char *) NULL)     return((char **) NULL);    /*$     Convert string to an ASCII list.   */
   fonts=1;   for (p=font; *p != '\0'; p++)      if (*p == ':')       fonts++;6   fontlist=(char **) malloc((fonts+1)*sizeof(char *));!   if (fontlist == (char **) NULL)      { C       Warning("Unable to convert font","Memory allocation failed");        return((char **) NULL);      } 	   p=font;    for (i=0; i < fonts; i++)    {      for (q=p; *q != '\0'; q++)       if (*q == ':')         break;6     fontlist[i]=(char *) malloc((q-p+1)*sizeof(char));%     if (fontlist[i] == (char *) NULL)        { E         Warning("Unable to convert font","Memory allocation failed");          return((char **) NULL);        } &     (void) strncpy(fontlist[i],p,q-p);     fontlist[i][q-p]='\0';
     p=q+1;   }    fontlist[i]=(char *) NULL;   return(fontlist);  }   K XFontStruct *XBestFont(Display *display,const XResourceInfo *resource_info,    const unsigned int text_font)  { 
   static char 
     *Fonts[]=      { 0       "-adobe-helvetica-medium-r-normal-*-14-*",'       "-*-helvetica-medium-r-*-*-14-*", $       "-*-lucida-medium-r-*-*-14-*",
       "8x13", 
       "6x13",        "fixed",       "variable",        (char *) NULL      },     *TextFonts[]=      { )       "-adobe-courier-medium-r-*-*-14-*", (       "-*-fixed-medium-r-normal-*-14-*",#       "-*-fixed-medium-r-*-*-14-*", 
       "8x13", 
       "6x13",        "fixed",       (char *) NULL      };     char     *font_name,      **p;  
   XFontStruct      *font_info;   !   font_info=(XFontStruct *) NULL;     font_name=resource_info->font;   if (text_font)'     font_name=resource_info->text_font; !   if (font_name != (char *) NULL)      { 
       char         **fontlist;          register int
         i;         /*A         Load preferred font specified in the X resource database.        */%       fontlist=FontToList(font_name); %       if (fontlist != (char **) NULL) 	         { 6           for (i=0; fontlist[i] != (char *) NULL; i++)           { 2             if (font_info == (XFontStruct *) NULL)<               font_info=XLoadQueryFont(display,fontlist[i]);'             free((char *) fontlist[i]);            } "           free((char *) fontlist);	         } ,       if (font_info == (XFontStruct *) NULL)1         Warning("Unable to load font",font_name);      }    /*5     Load fonts from list of fonts until one is found.    */
   p=Fonts;   if (text_font)     p=TextFonts;   while (*p != (char *) NULL)    { *     if (font_info != (XFontStruct *) NULL)       break;)     font_info=XLoadQueryFont(display,*p);      p++;   }    return(font_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t I c o n S i z e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XBestIconSize returns the "best" icon size.  "Best" is defined as L %  an icon size that maintains the aspect ratio of the image.  If the windowH %  manager has preferred icon sizes, one of the preferred sizes is used. % . %  The format of the XBestIconSize routine is: % * %      XBestIconSize(display,window,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */E void XBestIconSize(Display *display,XWindowInfo *window,Image *image)  {  #define MaxIconSize  96      int      i,     number_sizes;      unsigned int     height,      icon_height,     icon_width, 
     width;     unsigned long      scale_factor;      Window     root_window;     XIconSize      *icon_size,      *size_list;      /*G     Determine if the window manager has specified preferred icon sizes.    */   window->width=MaxIconSize;   window->height=MaxIconSize;    icon_size=(XIconSize *) NULL;    number_sizes=0; 2   root_window=XRootWindow(display,window->screen);G   if (XGetIconSizes(display,root_window,&size_list,&number_sizes) != 0) @     if ((number_sizes > 0) && (size_list != (XIconSize *) NULL))       icon_size=size_list;&   if (icon_size == (XIconSize *) NULL)     {        /*3         Window manager does not restrict icon size.        */!       icon_size=XAllocIconSize(); *       if (icon_size == (XIconSize *) NULL)	         { P           Warning("Unable to choose best icon size","Memory allocation failed");           return; 	         }        icon_size->min_width=1; '       icon_size->max_width=MaxIconSize;        icon_size->min_height=1;(       icon_size->max_height=MaxIconSize;       icon_size->width_inc=1;        icon_size->height_inc=1;     }    /*$     Determine aspect ratio of image.   */   width=image->columns;    height=image->rows;    if (window->crop_geometry)F     (void) XParseGeometry(window->crop_geometry,&i,&i,&width,&height);   /*C     Look for an icon size that maintains the aspect ratio of image.    */3   scale_factor=UpShift(icon_size->max_width)/width; =   if (scale_factor > (UpShift(icon_size->max_height)/height)) 7     scale_factor=UpShift(icon_size->max_height)/height; "   icon_width=icon_size->min_width;+   while (icon_width < icon_size->max_width)    { 6     if (icon_width >= (DownShift(width*scale_factor)))       break;%     icon_width+=icon_size->width_inc;    } $   icon_height=icon_size->min_height;-   while (icon_height < icon_size->max_height)    { 8     if (icon_height >= (DownShift(height*scale_factor)))       break;'     icon_height+=icon_size->height_inc;    }    XFree((void *) icon_size);   window->width=icon_width;    window->height=icon_height;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t P i x e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBestPixel returns a pixel from an array of pixels that is closestO %  to the requested color.  If the color array is NULL, the colors are obtained  %  from the X server.  % + %  The format of the XBestPixel routine is:  % D %      pixel=XBestPixel(display,colormap,colors,number_colors,color) % + %  A description of each parameter follows:  % I %    o pixel: XBestPixel returns the pixel value closest to the requested 
 %      color.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o colormap: Specifies the ID of the X server colormap.  % 7 %    o colors: Specifies an array of XColor structures.  % F %    o number_colors: Specifies the number of XColor structures in the %      color definition array. % J %    o color: Specifies the desired RGB value to find in the colors array. %  %  */H void XBestPixel(Display *display,const Colormap colormap,XColor *colors,+   unsigned int number_colors,XColor *color)  {    double     distance_squared,      min_distance;      int 
     distance,      query_server,      status;      register int     i,     j;     /*<     Find closest representation for the requested RGB color.   */-   status=XAllocColor(display,colormap,color);    if (status != 0)     return; )   query_server=colors == (XColor *) NULL;    if (query_server)      {        /*         Read X server colormap.        */=       colors=(XColor *) malloc(number_colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)M         Error("Unable to read X server colormap","Memory allocation failed"); '       for (i=0; i < number_colors; i++) *         colors[i].pixel=(unsigned long) i;       if (number_colors > 256)         number_colors=256;:       XQueryColors(display,colormap,colors,number_colors);     } #   min_distance=3.0*65536.0*65536.0;    color->pixel=colors[0].pixel;    j=0;#   for (i=0; i < number_colors; i++)    { 2     distance=(int) colors[i].red-(int) color->red;8     distance_squared=(unsigned int) (distance*distance);6     distance=(int) colors[i].green-(int) color->green;9     distance_squared+=(unsigned int) (distance*distance); 4     distance=(int) colors[i].blue-(int) color->blue;9     distance_squared+=(unsigned int) (distance*distance); (     if (distance_squared < min_distance)       { &         min_distance=distance_squared;%         color->pixel=colors[i].pixel;          j=i;       }    } 2   (void) XAllocColor(display,colormap,&colors[j]);   if (query_server)      free((char *) colors); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t V i s u a l I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XBestVisualInfo returns visual information for a visual that is 9 %  the "best" the server supports.  "Best" is defined as:  % J %    1. Restrict the visual list to those supported by the default screen. % K %    2. If a visual type is specified, restrict the visual list to those of  %       that type. % I %    3. If a map type is specified, choose the visual that matches the id + %       specified by the Standard Colormap.  % F %    4  From the list of visuals, choose one that can display the mostJ %       simultaneous colors.  If more than one visual can display the sameF %       number of simultaneous colors, one is choosen based on a rank. % 0 %  The format of the XBestVisualInfo routine is: % B %      visual_info=XBestVisualInfo(display,map_info,resource_info) % + %  A description of each parameter follows:  % J %    o visual_info: XBestVisualInfo returns a pointer to a X11 XVisualInfo %      structure.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */J XVisualInfo *XBestVisualInfo(Display *display,XStandardColormap *map_info,   XResourceInfo *resource_info)  {  #define MaxStandardColormaps  7 / #define XVisualColormapSize(visual_info) Min( \ N   (visual_info->class == TrueColor) || (visual_info->class == DirectColor) ? \O    visual_info->red_mask | visual_info->green_mask | visual_info->blue_mask : \ 6    visual_info->colormap_size,1 << visual_info->depth)     char     *map_type,     *visual_type;      register int     i;     static int     number_visuals;      static XVisualInfo     visual_template;     unsigned int     visual_mask;  
   XVisualInfo      *visual_info,      *visual_list;      /*,     Restrict visual search by screen number.   */#   map_type=resource_info->map_type; )   visual_type=resource_info->visual_type;    visual_mask=VisualScreenMask; 1   visual_template.screen=XDefaultScreen(display); #   if (visual_type != (char *) NULL)      {        /*5         Restrict visual search by class or visual id.        */7       if (Latin1Compare("staticgray",visual_type) == 0) 	         { '           visual_mask|=VisualClassMask; +           visual_template.class=StaticGray; 	         } 
       else8         if (Latin1Compare("grayscale",visual_type) == 0)           { )             visual_mask|=VisualClassMask; ,             visual_template.class=GrayScale;           }          else<           if (Latin1Compare("staticcolor",visual_type) == 0)
             { +               visual_mask|=VisualClassMask; 0               visual_template.class=StaticColor;
             }            else>             if (Latin1Compare("pseudocolor",visual_type) == 0)               { -                 visual_mask|=VisualClassMask; 2                 visual_template.class=PseudoColor;               }              else>               if (Latin1Compare("truecolor",visual_type) == 0)                 { /                   visual_mask|=VisualClassMask; 2                   visual_template.class=TrueColor;                 }                elseB                 if (Latin1Compare("directcolor",visual_type) == 0)                   { 1                     visual_mask|=VisualClassMask; 6                     visual_template.class=DirectColor;                   }                  else@                   if (Latin1Compare("default",visual_type) == 0)                     { 0                       visual_mask|=VisualIDMask;C                       visual_template.visualid=XVisualIDFromVisual( I                         XDefaultVisual(display,XDefaultScreen(display)));                      }                    else.                     if (isdigit(*visual_type))                       { 2                         visual_mask|=VisualIDMask;1                         visual_template.visualid= ?                           strtol(visual_type,(char **) NULL,0);                        }                      elseF                       Warning("Invalid visual specifier",visual_type);     }    /*2     Get all visuals that meet our criteria so far.   */   number_visuals=0; B   visual_list=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); .   visual_mask=VisualScreenMask | VisualIDMask;E   if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL))      {        /*<         Failed to get visual;  try using the default visual.       */2       Warning("Unable to get visual",visual_type);       visual_template.visualid= M         XVisualIDFromVisual(XDefaultVisual(display,XDefaultScreen(display))); F       visual_list=XGetVisualInfo(display,visual_mask,&visual_template,         &number_visuals); I       if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL)) %         return((XVisualInfo *) NULL); K       Warning("Using default visual",XVisualClassName(visual_list->class));      } &   resource_info->color_recovery=False;N   if ((map_info != (XStandardColormap *) NULL) && (map_type != (char *) NULL))     { 
       Atom         map_property;   
       char          map_name[MaxTextLength];  	       int 
         j,         number_maps,         status;          Window         root_window;         XStandardColormap          *map_list;         /*<         Choose a visual associated with a standard colormap.       */?       root_window=XRootWindow(display,XDefaultScreen(display));        status=0; '       if (strcmp(map_type,"list") != 0) 	         {            /*-             User specified Standard Colormap.            */B           (void) sprintf((char *) map_name,"RGB_%s_MAP",map_type);            Latin1Upper(map_name);C           map_property=XInternAtom(display,(char *) map_name,True); *           if (map_property == (Atom) NULL)>             Error("Unable to get Standard Colormap",map_type);M           status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,              map_property);	         } 
       else	         {            static char              *colormap[]=
             { (               "_HP_RGB_SMOOTH_MAP_LIST",               "RGB_BEST_MAP",                 "RGB_DEFAULT_MAP",               "RGB_GRAY_MAP",                "RGB_RED_MAP",               "RGB_GREEN_MAP",               "RGB_BLUE_MAP",              };             /*3             Choose a standard colormap from a list.            */2           for (i=0; i < MaxStandardColormaps; i++)           { ?             map_property=XInternAtom(display,colormap[i],True); ,             if (map_property == (Atom) NULL)               continue; O             status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,                map_property);             if (status != 0)               break;           } P           resource_info->color_recovery=(i == 0);  /* _HP_RGB_SMOOTH_MAP_LIST */	         }        if (status == 0):         Error("Unable to get Standard Colormap",map_type);       /*E         Search all Standard Colormaps and visuals for ids that match.        */       *map_info=map_list[0]; #ifndef PRE_R4_ICCCMJ       visual_template.visualid=XVisualIDFromVisual(visual_list[0].visual);%       for (i=0; i < number_maps; i++) *         for (j=0; j < number_visuals; j++)%           if (map_list[i].visualid == 9               XVisualIDFromVisual(visual_list[j].visual)) 
             { $               *map_info=map_list[i];'               visual_template.visualid= ;                 XVisualIDFromVisual(visual_list[j].visual);                break;
             } 9       if (map_info->visualid != visual_template.visualid) F         Error("Unable to match visual to Standard Colormap",map_type); #endif0       if (map_info->colormap == (Colormap) NULL)?         Error("Standard Colormap is not initialized",map_type);        XFree((void *) map_list);      }    else     {        static unsigned int          rank[]=            {              StaticGray,              GrayScale,             StaticColor,             DirectColor,             TrueColor,             PseudoColor            };         XVisualInfo          *p;          /*C         Pick one visual that displays the most simultaneous colors.        */       visual_info=visual_list;       p=visual_list;(       for (i=1; i < number_visuals; i++)       {          p++;F         if (XVisualColormapSize(p) > XVisualColormapSize(visual_info))           visual_info=p;         elseI           if (XVisualColormapSize(p) == XVisualColormapSize(visual_info)) :             if (rank[p->class] > rank[visual_info->class])               visual_info=p;       } H       visual_template.visualid=XVisualIDFromVisual(visual_info->visual);     }    XFree((void *) visual_list);   /*7     Retrieve only one visual by its screen & id number.    */B   visual_info=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); E   if ((number_visuals == 0) || (visual_info == (XVisualInfo *) NULL)) !     return((XVisualInfo *) NULL);    return(visual_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h e c k R e f r e s h W i n d o w s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCheckRefreshWindows checks the X server for exposure events forL %  a particular window and updates the area associated withe exposure event. % 5 %  The format of the XCheckRefreshWindows routine is:  % , %      XCheckRefreshWindows(display,windows) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %  %  */= void XCheckRefreshWindows(Display *display,XWindows *windows)  {    XEvent
     event;     XDelay(display,SuspendTime);K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) A     (void) XCommandWidget(display,windows,(char **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event); #   XDelay(display,SuspendTime << 1); K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) A     (void) XCommandWidget(display,windows,(char **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t M e s s a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XClientMessage sends a message to a window with XSendEvent.  TheC %  message is initialized with a particular protocol type and atom.  % 0 %  The format of the XClientMessage function is: % @ %      XClientMessage(display,window,protocol,message,timestamp) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ) %    o protocol: Specifies an atom value.  % E %    o message: Specifies an atom value which is the message to send.  % 1 %    o timestamp: Specifies a value of type Time.  %  %  */M void XClientMessage(Display *display,const Window window,const Atom protocol, *   const Atom message,const Time timestamp) {    XClientMessageEvent      client_event;   "   client_event.type=ClientMessage;   client_event.window=window; %   client_event.message_type=protocol;    client_event.format=32; !   client_event.data.l[0]=message; #   client_event.data.l[1]=timestamp; H   XSendEvent(display,window,False,NoEventMask,(XEvent *) &client_event); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t W i n d o w                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XClientWindow finds a window, at or below the specified window, M %  which has a WM_STATE property.  If such a window is found, it is returned, - %  otherwise the argument window is returned.  % / %  The format of the XClientWindow function is:  % 9 %      client_window=XClientWindow(display,target_window)  % + %  A description of each parameter follows:  % O %    o client_window: XClientWindow returns a window, at or below the specified C %      window, which has a WM_STATE property otherwise the argument ! %      target_window is returned.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o target_window: Specifies the window to find a WM_STATE property.  %  %  */; Window XClientWindow(Display *display,Window target_window)  {    Atom
     state,	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     number_items;      Window     client_window;  -   state=XInternAtom(display,"WM_STATE",True);    if (state == (Atom) NULL)      return(target_window);   type=(Atom) NULL; D   status=XGetWindowProperty(display,target_window,state,0L,0L,False,E     (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data); 3   if ((status == Success) && (type != (Atom) NULL))      return(target_window);?   client_window=XWindowByProperty(display,target_window,state); %   if (client_window == (Window) NULL)      return(target_window);   return(client_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n s t r a i n W i n d o w P o s i t i o n                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XConstrainWindowPosition assures a window is positioned witin the  %  X server boundaries.  % 9 %  The format of the XConstrainWindowPosition routine is:  % 4 %      XConstrainWindowPosition(display,window_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowInfo structure.  %  %  */H void XConstrainWindowPosition(Display *display,XWindowInfo *window_info) {    unsigned int
     limit;  F   limit=XDisplayWidth(display,window_info->screen)-window_info->width;   if (window_info->x < 0)      window_info->x=0;    else     if (window_info->x > limit)        window_info->x=limit; H   limit=XDisplayHeight(display,window_info->screen)-window_info->height;   if (window_info->y < 0)      window_info->y=0;    else     if (window_info->y > limit)        window_info->y=limit;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e l a y                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDelay suspends program execution for the number of milliseconds
 %  specified.  % & %  The format of the Delay routine is: % # %      XDelay(display,milliseconds)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % I %    o milliseconds: Specifies the number of milliseconds to delay before  %      returning.  %  %  */> void XDelay(Display *display,const unsigned long milliseconds) {    (void) XFlush(display);    if (milliseconds == 0)     return; ) #if !defined(vms) && !defined(__MWERKS__)  #ifdef sysv    {  #include <sys/poll.h>   =     (void) poll((struct pollfd *) NULL,0,(int) milliseconds);    }  #else    {      struct timeval       timer;  #     timer.tv_sec=milliseconds/1000; -     timer.tv_usec=(milliseconds % 1000)*1000; O     (void) select(0,(XFD_SET *) NULL,(XFD_SET *) NULL,(XFD_SET *) NULL,&timer);    }  #endif #endif
 #ifdef vms   { 	     float        timer;       timer=milliseconds/1000.0;     lib$wait(&timer);    }  #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e s t r o y W i n d o w C o l o r s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XDestroyWindowColors frees X11 color resources previously saved on= %  a window by XRetainWindowColors or programs like xsetroot.  % 5 %  The format of the XDestroyWindowColors routine is:  % + %      XDestroyWindowColors(display,window)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  %  %  */9 void XDestroyWindowColors(Display *display,Window window)  {    Atom
     property, 	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     length;      /*E     If there are previous resources on the root window, destroy them.    */5   property=XInternAtom(display,"_XSETROOT_ID",False);    if (property == (Atom) NULL)     { <       Warning("Unable to create X property","_XSETROOT_ID");
       return;      } ?   status=XGetWindowProperty(display,window,property,0L,1L,True, ?     (Atom) AnyPropertyType,&type,&format,&length,&after,&data);    if (status != Success)     return; M   if ((type == XA_PIXMAP) && (format == 32) && (length == 1) && (after == 0))      { 6       XKillClient(display,(XID) (*((Pixmap *) data)));/       XDeleteProperty(display,window,property);      }    if (type != None)      XFree((void *) data);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y I m a g e I n f o                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XDisplayImageInfo displays information about an X image. % 2 %  The format of the XDisplayImageInfo routine is: % H %      XDisplayImageInfo(display,resource_info,windows,undo_image,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % K %    o undo_image: Specifies a pointer to a Image structure;  returned from  %      ReadImage.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */K void XDisplayImageInfo(Display *display,const XResourceInfo *resource_info, 3   XWindows *windows,Image *undo_image,Image *image)  {    char
     *text,     **textlist,      title[MaxTextLength];      int      length;      Image      *p;      register int     i;     unsigned int
     bytes,
     count,     levels;      /*@     Display information about the image in the Text View widget.   */   length=50*MaxTextLength;(   if (image->directory != (char *) NULL)%     length+=strlen(image->directory); '   if (image->comments != (char *) NULL) $     length+=strlen(image->comments);,   text=(char *) malloc(length*sizeof(char));   if (text == (char *) NULL)     { D       XNoticeWidget(display,windows,"Unable to display image info:",$         "Memory allocation failed");
       return;      } 
   *text='\0';    /*$     Display info about the X server.   */:   (void) sprintf(title," Image Info: %s",image->filename);#   if (resource_info->gamma_correct) 6     if (resource_info->display_gamma != (char *) NULL)<       (void) sprintf(text,"%sDisplay\n  gamma: %s\n\n",text,&         resource_info->display_gamma);   /*#     Display info about the X image.    */1   (void) sprintf(text,"%sX\n  visual: %s\n",text, ,     XVisualClassName(windows->image.class));K   (void) sprintf(text,"%s  depth: %d\n",text,windows->image.ximage->depth); 5   if (windows->image.visual_info->colormap_size != 0) 7     (void) sprintf(text,"%s  colormap size: %d\n",text, 1       windows->image.visual_info->colormap_size); /   if (resource_info->colormap== SharedColormap) 4     (void) strcat(text,"  colormap type: Shared\n");   else5     (void) strcat(text,"  colormap type: Private\n"); 3   (void) sprintf(text,"%s  geometry: %dx%d\n",text, @     windows->image.ximage->width,windows->image.ximage->height);4   if (windows->image.crop_geometry != (char *) NULL)7     (void) sprintf(text,"%s  crop geometry: %s\n",text, $       windows->image.crop_geometry);-   if (windows->image.pixmap == (Pixmap) NULL) ,     (void) strcat(text,"  type: X Image\n");   else+     (void) strcat(text,"  type: Pixmap\n"); #   if (windows->image.shared_memory) 2     (void) strcat(text,"  shared memory: True\n");   else3     (void) strcat(text,"  shared memory: False\n");    (void) strcat(text,"\n");    /*,     Display info about the undo image cache.   */
   bytes=0;8   for (levels=0; undo_image != (Image *) NULL; levels++)   { =     bytes+=undo_image->list->packets*sizeof(RunlengthPacket); $     undo_image=undo_image->previous;   } G   (void) sprintf(text,"%sUndo Edit Cache\n  levels: %u\n",text,levels); H   (void) sprintf(text,"%s  bytes: %umb\n",text,(bytes+(1 << 19)) >> 20);L   (void) sprintf(text,"%s  limit: %umb\n\n",text,resource_info->undo_cache);   /*!     Display info about the image.    */D   (void) sprintf(text,"%sImage\n  file: %s\n",text,image->filename);"   if (image->class == DirectClass)1     (void) strcat(text,"  class: DirectClass\n");    else1     (void) strcat(text,"  class: PseudoClass\n"); "   if (image->class == PseudoClass)     {        ColorPacket          *p;          register int
         i;         register XColorlist          *q;          /*         Display image colormap.        *//       if (image->total_colors <= image->colors) C         (void) sprintf(text,"%s  colors: %u\n",text,image->colors); 
       elseM         (void) sprintf(text,"%s  colors: %lu=>%u\n",text,image->total_colors,            image->colors);        p=image->colormap;'       for (i=0; i < image->colors; i++)        { E         (void) sprintf(text,"%s    %d: (%3d,%3d,%3d)  #%02x%02x%02x", ?           text,i,p->red,p->green,p->blue,(unsigned int) p->red, :           (unsigned int) p->green,(unsigned int) p->blue);8         for (q=Colorlist; q->name != (char *) NULL; q++).           if ((DownScale(p->red) == q->red) &&2               (DownScale(p->green) == q->green) &&.               (DownScale(p->blue) == q->blue))7             (void) sprintf(text,"%s  %s",text,q->name); !         (void) strcat(text,"\n");          p++;       }      } (   if (image->signature != (char *) NULL)E     (void) sprintf(text,"%s  signature: %s\n",text,image->signature);    if (image->matte) *     (void) strcat(text,"  matte: True\n");   else+     (void) strcat(text,"  matte: False\n");    if (image->gamma != 0.0)=     (void) sprintf(text,"%s  gamma: %f\n",text,image->gamma); 4   if (image->packets < (image->columns*image->rows))P     (void) sprintf(text,"%s  runlength packets: %u of %u\n",text,image->packets,"       image->columns*image->rows);3   (void) sprintf(text,"%s  geometry: %ux%u\n",text,       image->columns,image->rows);;   (void) sprintf(text,"%s  depth: %u\n",text,image->depth);    if (image->filesize != 0) A     (void) sprintf(text,"%s  bytes: %ld\n",text,image->filesize);    if (image->interlace) /     (void) strcat(text,"  interlaced: True\n");    else0     (void) strcat(text,"  interlaced: False\n");#   if (image->page != (char *) NULL) D     (void) sprintf(text,"%s  page geometry: %s\n",text,image->page);$   if (image->delay != (char *) NULL)=     (void) sprintf(text,"%s  delay: %s\n",text,image->delay); =   (void) sprintf(text,"%s  format: %s\n",text,image->magick); 
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)I     (void) sprintf(text,"%s  scene: %u of %u\n",text,image->scene,count);    else     if (image->scene != 0)?       (void) sprintf(text,"%s  scene: %u\n",text,image->scene); $   if (image->label != (char *) NULL)=     (void) sprintf(text,"%s  label: %s\n",text,image->label); '   if (image->comments != (char *) NULL)      {        /*         Display image comment.       */2       (void) sprintf(text,"%s  comments:\n",text);-       textlist=StringToList(image->comments); %       if (textlist != (char **) NULL) 	         { 6           for (i=0; textlist[i] != (char *) NULL; i++)           { =             (void) sprintf(text,"%s  %s\n",text,textlist[i]);              free(textlist[i]);           } "           free((char *) textlist);	         }      } &   if (image->montage != (char *) NULL)A     (void) sprintf(text,"%s  montage: %s\n",text,image->montage); (   if (image->directory != (char *) NULL)     {        /*          Display image directory.       */3       (void) sprintf(text,"%s  directory:\n",text); .       textlist=StringToList(image->directory);%       if (textlist != (char **) NULL) 	         { 6           for (i=0; textlist[i] != (char *) NULL; i++)           { ?             (void) sprintf(text,"%s    %s\n",text,textlist[i]);              free(textlist[i]);           } "           free((char *) textlist);	         }      }    textlist=StringToList(text);!   if (textlist != (char **) NULL)      {        register int
         i;  I       XTextViewWidget(display,resource_info,windows,True,title,textlist); 2       for (i=0; textlist[i] != (char *) NULL; i++)#         free((char *) textlist[i]);        free((char *) textlist);     }    free((char *) text); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     X D i t h e r I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDitherImage dithers the reference image as required by the HPM %  Color Recovery algorithm.  The color values are quantized to 3 bits of red J %  and green, and 2 bits of blue (3/3/2) and can be used as indices into a %  8-bit X standard colormap.  % - %  The format of the XDitherImage routine is:  % ! %      XDitherImage(image,ximage)  % + %  A description of each parameter follows:  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %  %  */5 static void XDitherImage(Image *image,XImage *ximage)  {    static short int     dither_red[2][16]=     { H       {-16,  4, -1, 11,-14,  6, -3,  9,-15,  5, -2, 10,-13,  7, -4,  8},G       { 15, -5,  0,-12, 13, -7,  2,-10, 14, -6,  1,-11, 12, -8,  3, -9}      },     dither_green[2][16]=     { H       { 11,-15,  7, -3,  8,-14,  4, -2, 10,-16,  6, -4,  9,-13,  5, -1},G       {-12, 14, -8,  2, -9, 13, -5,  1,-11, 15, -7,  3,-10, 12, -6,  0}      },     dither_blue[2][16]=      { H       { -3,  9,-13,  7, -1, 11,-15,  5, -4,  8,-14,  6, -2, 10,-16,  4},G       {  2,-10, 12, -8,  0,-12, 14, -6,  3, -9, 13, -7,  1,-11, 15, -5}      };  
   ColorPacket 
     color;     int 
     value,     y;     register char      *q;      register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned char      *blue_map[2][16],      *green_map[2][16],     *red_map[2][16];     unsigned int     scanline_pad;      register unsigned long
     pixel;     if (!UncompressImage(image))     return;    /*(     Allocate and initialize dither maps.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { H       red_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char));J       green_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char));I       blue_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char)); 6       if ((red_map[i][j] == (unsigned char *) NULL) ||8           (green_map[i][j] == (unsigned char *) NULL) ||5           (blue_map[i][j] == (unsigned char *) NULL)) 	         { G           Warning("Unable to dither image","Memory allocation failed");            return; 	         }      }    /*     Initialize dither tables.    */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)       for (x=0; x < 256; x++)        {          value=x-16;          if (x < 48)            value=x/2+8;          value+=dither_red[i][j];         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB;          red_map[i][j][x]=value;          value=x-16;          if (x < 48)            value=x/2+8;"         value+=dither_green[i][j];         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB; !         green_map[i][j][x]=value;          value=x-32;          if (x < 112)           value=x/2+24; (         value+=(dither_blue[i][j] << 1);         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB;           blue_map[i][j][x]=value;       }    /*     Dither image.    */&   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   i=0;   j=0;   p=image->pixels;   q=ximage->data; !   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { &       color.red=red_map[i][j][p->red];,       color.green=green_map[i][j][p->green];)       color.blue=blue_map[i][j][p->blue]; !       pixel=((color.red & 0xe0) | 5         ((unsigned char) (color.green & 0xe0) >> 3) | 4         ((unsigned char) (color.blue & 0xc0) >> 6));!       *q++=(unsigned char) pixel; 
       p++;
       j++;       if (j == 16)         j=0;     }      q+=scanline_pad;     i++;     if (i == 2) 
       i=0;   }    /*     Free allocated memory.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { %       free((char *) green_map[i][j]); $       free((char *) blue_map[i][j]);#       free((char *) red_map[i][j]);      }  }      /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 1 %  Function XDrawImage draws a line on the image.  % + %  The format of the XDrawImage routine is:  % : %    status=XDrawImage(display,pixel_info,draw_info,image) % + %  A description of each parameter follows:  % ? %    o status: Function XDrawImage returns True if the image is E %      successfully drawd with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % ? %    o draw_info: Specifies a pointer to a XDrawInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */F unsigned int XDrawImage(Display *display,const XPixelInfo *pixel_info,*   const XDrawInfo *draw_info,Image *image) { 
   ColorPacket      background_color;      GC     draw_context;      Image      *draw_image;     int      x,     y;     Pixmap     draw_pixmap;     register int     i;     register RunlengthPacket     *p,      *q;      unsigned int
     depth,     height, 
     matte,
     width;     Window     root_window;     XGCValues      context_values;      XImage     *draw_ximage;      /*     Initialize drawd image.    */   if (!UncompressImage(image))     return(False);   /*     Initialize drawd pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); A   draw_pixmap=XCreatePixmap(display,root_window,draw_info->width, #     draw_info->height,(int) depth); #   if (draw_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */1   context_values.background=(unsigned long) (~0);    context_values.foreground=0;2   context_values.line_width=draw_info->line_width;J   draw_context=XCreateGC(display,root_window,GCBackground | GCForeground |!     GCLineWidth,&context_values);     if (draw_context == (GC) NULL)     return(False);   /*     Clear pixmap.    */G   XFillRectangle(display,draw_pixmap,draw_context,0,0,draw_info->width,      draw_info->height);    /*     Draw line to pixmap.   */)   XSetBackground(display,draw_context,0); <   XSetForeground(display,draw_context,(unsigned long) (~0));9   XSetFillStyle(display,draw_context,FillOpaqueStippled); 7   XSetStipple(display,draw_context,draw_info->stipple);    switch (draw_info->primitive)    {      case PointPrimitive:     default:     { M       XDrawLines(display,draw_pixmap,draw_context,draw_info->coordinate_info, 7         draw_info->number_coordinates,CoordModeOrigin);        break;     }      case LinePrimitive:      { I       XDrawLine(display,draw_pixmap,draw_context,draw_info->line_info.x1, 8         draw_info->line_info.y1,draw_info->line_info.x2,!         draw_info->line_info.y2);        break;     }      case RectanglePrimitive:     { 6       XDrawRectangle(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,J         draw_info->rectangle_info.width,draw_info->rectangle_info.height);       break;     }       case FillRectanglePrimitive:     { 6       XFillRectangle(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,J         draw_info->rectangle_info.width,draw_info->rectangle_info.height);       break;     }      case EllipsePrimitive:     { 0       XDrawArc(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,I         draw_info->rectangle_info.width,draw_info->rectangle_info.height,          0,360*64);       break;     }      case FillEllipsePrimitive:     { 0       XFillArc(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,I         draw_info->rectangle_info.width,draw_info->rectangle_info.height,          0,360*64);       break;     }      case PolygonPrimitive:     {        XPoint         *coordinate_info;   1       coordinate_info=draw_info->coordinate_info; B       XDrawLines(display,draw_pixmap,draw_context,coordinate_info,7         draw_info->number_coordinates,CoordModeOrigin); 1       XDrawLine(display,draw_pixmap,draw_context, ;         coordinate_info[draw_info->number_coordinates-1].x, ;         coordinate_info[draw_info->number_coordinates-1].y, 3         coordinate_info[0].x,coordinate_info[0].y);        break;     }      case FillPolygonPrimitive:     { O       XFillPolygon(display,draw_pixmap,draw_context,draw_info->coordinate_info, ?         draw_info->number_coordinates,Complex,CoordModeOrigin);        break;     }    }     XFreeGC(display,draw_context);   /*     Initialize X image.    */A   draw_ximage=XGetImage(display,draw_pixmap,0,0,draw_info->width, )     draw_info->height,AllPlanes,ZPixmap); %   if (draw_ximage == (XImage *) NULL)      return(False);#   XFreePixmap(display,draw_pixmap);    /*     Initialize draw image.   *//   draw_image=AllocateImage((ImageInfo *) NULL); #   if (draw_image == (Image *) NULL)      return(False);'   draw_image->columns=draw_info->width; %   draw_image->rows=draw_info->height; ;   draw_image->packets=draw_image->columns*draw_image->rows; (   draw_image->pixels=(RunlengthPacket *)B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));5   if (draw_image->pixels == (RunlengthPacket *) NULL)      {        DestroyImage(draw_image);        return(False);     }    /*$     Transfer drawn X image to image.   */B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);%   q=image->pixels+y*image->columns+x;    background_color.red=q->red;"   background_color.green=q->green;    background_color.blue=q->blue;   background_color.index=0;    draw_image->matte=True;    p=draw_image->pixels; &   for (y=0; y < draw_image->rows; y++)+     for (x=0; x < draw_image->columns; x++)      { ;       p->index=(unsigned short) XGetPixel(draw_ximage,x,y);        if (p->index == 0)	         {            /*3             Set this pixel to the background color.            */&           p->red=background_color.red;*           p->green=background_color.green;(           p->blue=background_color.blue;N           p->index=draw_info->stencil == OpaqueStencil ? Transparent : Opaque;	         } 
       else	         {            /*,             Set this pixel to the pen color.           */7           p->red=XDownScale(pixel_info->pen_color.red); ;           p->green=XDownScale(pixel_info->pen_color.green); 9           p->blue=XDownScale(pixel_info->pen_color.blue); N           p->index=draw_info->stencil == OpaqueStencil ? Opaque : Transparent;	         }        p->length=0;
       p++;     }    XDestroyImage(draw_ximage);    /*     Determine draw geometry.   */B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);E   if ((width != draw_image->columns) || (height != draw_image->rows))      { 
       char&         image_geometry[MaxTextLength];         /*         Scale image.       */:       (void) sprintf(image_geometry,"%ux%u",width,height);?       TransformImage(&draw_image,(char *) NULL,image_geometry);      }     if (draw_info->degrees != 0.0)     {        double         normalized_degrees;          Image          *rotated_image;   	       int          rotations;         /*         Rotate image.        */>       rotated_image=RotateImage(draw_image,draw_info->degrees,&         &background_color,False,True);*       if (rotated_image == (Image *) NULL)         return(False);       DestroyImage(draw_image);        draw_image=rotated_image;        /*9         Annotation is relative to the degree of rotation.        */,       normalized_degrees=draw_info->degrees;(       while (normalized_degrees < -45.0)"         normalized_degrees+=360.0;?       for (rotations=0; normalized_degrees > 45.0; rotations++) !         normalized_degrees-=90.0;        switch (rotations % 4)       {          default:         case 0:            break;         case 1: 	         {            /*             Rotate 90 degrees.           */&           x-=draw_image->columns >> 1;&           y+=draw_image->columns >> 1;           break;	         }          case 2: 	         {            /*             Rotate 180 degrees.            */!           x-=draw_image->columns;            break;	         }          case 3: 	         {            /*             Rotate 270 degrees.            */&           x-=draw_image->columns >> 1;9           y-=draw_image->rows-(draw_image->columns >> 1);            break;	         }        }      }    /*"     Composite text onto the image.   */   p=draw_image->pixels; )   for (i=0; i < draw_image->packets; i++)    {       if (p->index != Transparent)       p->index=Opaque;     p++;   } /   if (draw_info->stencil == TransparentStencil) A     CompositeImage(image,MatteReplaceCompositeOp,draw_image,x,y);    else     {        matte=image->matte; ;       CompositeImage(image,OverCompositeOp,draw_image,x,y);        image->matte=matte;      }    DestroyImage(draw_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E r r o r                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function XError ignores BadWindow errors for XQueryTree andM %  XGetWindowAttributes, and ignores BadDrawable errors for XGetGeometry, and M %  ignores BadValue errors for XQueryColor.  It returns False in those cases.  %  Otherwise it returns True.  % ( %  The format of the XError function is: %  %      XError(display,error) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % ( %    o error: Specifies the error event. %  %  *// int XError(Display *display,XErrorEvent *error)  { "   if (display == (Display *) NULL)     return(True);    xerror_alert=True;   switch (error->request_code)   {      case X_GetGeometry:      { +       if (error->error_code == BadDrawable)          return(False);       break;     }      case X_GetWindowAttributes:      case X_QueryTree:      { )       if (error->error_code == BadWindow)          return(False);       break;     }      case X_QueryColors:      { (       if (error->error_code == BadValue)         return(False);       break;     }    }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e R e s o u r c e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % / %  Function XFreeResources frees X11 resources.  % / %  The format of the XFreeResources routine is:  % H %      XFreeResources(display,visual_info,map_info,pixel_info,font_info,# %        resource_info,window_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  %  %  */> void XFreeResources(Display *display,XVisualInfo *visual_info,L   XStandardColormap *map_info,XPixelInfo *pixel_info,XFontStruct *font_info,8   XResourceInfo *resource_info,XWindowInfo *window_info) { *   if (window_info != (XWindowInfo *) NULL)     {        /*         Free X image.        */1       if (window_info->ximage != (XImage *) NULL) +         XDestroyImage(window_info->ximage); +       if (window_info->id != (Window) NULL) 	         {            /*1             Free destroy window and free cursors.            */J           if (window_info->id != XRootWindow(display,visual_info->screen))4             XDestroyWindow(display,window_info->id);9           if (window_info->annotate_context != (GC) NULL) ;             XFreeGC(display,window_info->annotate_context); :           if (window_info->highlight_context != (GC) NULL)<             XFreeGC(display,window_info->highlight_context);7           if (window_info->widget_context != (GC) NULL) 9             XFreeGC(display,window_info->widget_context); 3           XFreeCursor(display,window_info->cursor); 8           XFreeCursor(display,window_info->busy_cursor);	         }      }    /*     Free font.   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info); -   if (map_info != (XStandardColormap *) NULL)      {        /*!         Free X Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL) G         XFreeStandardColormap(display,visual_info,map_info,pixel_info);        XFree((void *) map_info);      }    /*     Free X visual info.    */*   if (visual_info != (XVisualInfo *) NULL)      XFree((void *) visual_info);"   if (resource_info->close_server)     XCloseDisplay(display);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e S t a n d a r d C o l o r m a p                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 8 %  Function XFreeStandardColormap frees an X11 colormap. % 6 %  The format of the XFreeStandardColormap routine is: % E %      XFreeStandardColormap(display,visual_info,map_info,pixel_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */K void XFreeStandardColormap(Display *display,const XVisualInfo *visual_info, 5   XStandardColormap *map_info,XPixelInfo *pixel_info)  {    /*     Free colormap.   */   XFlush(display);,   if (map_info->colormap != (Colormap) NULL)L     if (map_info->colormap != XDefaultColormap(display,visual_info->screen))0       XFreeColormap(display,map_info->colormap);     else,       if (pixel_info != (XPixelInfo *) NULL)0         if ((visual_info->class != TrueColor) &&0             (visual_info->class != DirectColor))D           XFreeColors(display,map_info->colormap,pixel_info->pixels,(             (int) pixel_info->colors,0);%   map_info->colormap=(Colormap) NULL; (   if (pixel_info != (XPixelInfo *) NULL)     { 3       if (pixel_info->gamma_map != (XColor *) NULL) -         free((char *) pixel_info->gamma_map); ,       pixel_info->gamma_map=(XColor *) NULL;7       if (pixel_info->pixels != (unsigned long *) NULL) *         free((char *) pixel_info->pixels);0       pixel_info->pixels=(unsigned long *) NULL;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t A n n o t a t e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetAnnotateInfo initializes the AnnotateInfo structure. % 0 %  The format of the GetAnnotateInfo routine is: % # %      XGetAnnotateInfo(image_info)  % + %  A description of each parameter follows:  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  %  %  */3 void XGetAnnotateInfo(XAnnotateInfo *annotate_info)  {    /*"     Initialize annotate structure.   */   annotate_info->x=0;    annotate_info->y=0;    annotate_info->width=0;    annotate_info->height=0;+   annotate_info->stencil=ForegroundStencil;    annotate_info->degrees=0.0; 0   annotate_info->font_info=(XFontStruct *) NULL;$   annotate_info->text=(char *) NULL;    *annotate_info->geometry='\0';1   annotate_info->previous=(XAnnotateInfo *) NULL; -   annotate_info->next=(XAnnotateInfo *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M a p I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetMapInfo initializes the XStandardColormap structure. % 2 %  The format of the XStandardColormap routine is: % 1 %      XGetMapInfo(visual_info,colormap,map_info)  % + %  A description of each parameter follows:  % ; %    o colormap: Specifies the ID of the X server colormap.  % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % J %    o map_info: Specifies a pointer to a X11 XStandardColormap structure. %  %  */H void XGetMapInfo(const XVisualInfo *visual_info,const Colormap colormap,   XStandardColormap *map_info) {    /*     Initialize map info.   */   map_info->colormap=colormap;*   map_info->red_max=visual_info->red_mask;4   map_info->red_mult=map_info->red_max != 0 ? 1 : 0;   if (map_info->red_max != 0) +     while ((map_info->red_max & 0x01) == 0)      {        map_info->red_max>>=1;       map_info->red_mult<<=1;      } .   map_info->green_max=visual_info->green_mask;8   map_info->green_mult=map_info->green_max != 0 ? 1 : 0;   if (map_info->green_max != 0) -     while ((map_info->green_max & 0x01) == 0)      {        map_info->green_max>>=1;       map_info->green_mult<<=1;      } ,   map_info->blue_max=visual_info->blue_mask;6   map_info->blue_mult=map_info->blue_max != 0 ? 1 : 0;   if (map_info->blue_max != 0),     while ((map_info->blue_max & 0x01) == 0)     {        map_info->blue_max>>=1;        map_info->blue_mult<<=1;     }    map_info->base_pixel=0;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M o n t a g e I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Function XGetMontageInfo initializes the MontageInfo structure. % / %  The format of the GetMontageInfo routine is:  % $ %      XGetMontageInfo(montage_info) % + %  A description of each parameter follows:  % D %    o montage_info: Specifies a pointer to a MontageInfo structure. %  %  */0 void XGetMontageInfo(XMontageInfo *montage_info) {    montage_info->number_tiles=0;    montage_info->frame=True;    montage_info->shadow=True;+   montage_info->compose=ReplaceCompositeOp; 1   montage_info->pointsize=atoi(DefaultPointSize);    montage_info->tile="5x4"; &   montage_info->texture=(char *) NULL; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t P i x e l I n f o                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function XGetPixelInfo initializes the PixelInfo structure. % . %  The format of the XGetPixelInfo routine is: % F %      XGetPixelInfo(display,visual_info,map_info,resource_info,image, %        pixel_info) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */C void XGetPixelInfo(Display *display,const XVisualInfo *visual_info, G   const XStandardColormap *map_info,const XResourceInfo *resource_info, &   Image *image,XPixelInfo *pixel_info) { 
   static char      *PenColors[MaxNumberPens]=     {        Pen1Color,       Pen2Color,       Pen3Color,       Pen4Color,       Pen5Color,       Pen6Color,       Pen7Color,       Pen8Color,       Pen9Color,       Pen0Color,       Pen0Color      };  
   Colormap
     colormap;      int      status;      register int     i;     unsigned int     packets;     /*     Initialize pixel info.   */   pixel_info->colors=0;    if (image != (Image *) NULL)$     if (image->class == PseudoClass)'       pixel_info->colors=image->colors; K   packets=Max(pixel_info->colors,visual_info->colormap_size)+MaxNumberPens; 3   if (pixel_info->pixels != (unsigned long *) NULL) &     free((char *) pixel_info->pixels);M   pixel_info->pixels=(unsigned long *) malloc(packets*sizeof(unsigned long)); 3   if (pixel_info->pixels == (unsigned long *) NULL) A     Error("Unable to get pixel info","Memory allocation failed");    /*     Set foreground color.    */   colormap=map_info->colormap;6   (void) XParseColor(display,colormap,ForegroundColor,#     &pixel_info->foreground_color); F   status=XParseColor(display,colormap,resource_info->foreground_color,#     &pixel_info->foreground_color);    if (status == 0)N     Warning("Color is not known to X server",resource_info->foreground_color);%   pixel_info->foreground_color.pixel= =     XStandardPixel(map_info,pixel_info->foreground_color,16); >   pixel_info->foreground_color.flags=DoRed | DoGreen | DoBlue;   /*     Set background color.    */6   (void) XParseColor(display,colormap,BackgroundColor,#     &pixel_info->background_color); F   status=XParseColor(display,colormap,resource_info->background_color,#     &pixel_info->background_color);    if (status == 0)N     Warning("Color is not known to X server",resource_info->background_color);%   pixel_info->background_color.pixel= =     XStandardPixel(map_info,pixel_info->background_color,16); >   pixel_info->background_color.flags=DoRed | DoGreen | DoBlue;   /*     Set border color.    */M   (void) XParseColor(display,colormap,BorderColor,&pixel_info->border_color); B   status=XParseColor(display,colormap,resource_info->border_color,     &pixel_info->border_color);    if (status == 0)J     Warning("Color is not known to X server",resource_info->border_color);!   pixel_info->border_color.pixel= 9     XStandardPixel(map_info,pixel_info->border_color,16); :   pixel_info->border_color.flags=DoRed | DoGreen | DoBlue;   /*     Set matte color.   */7   pixel_info->matte_color=pixel_info->background_color; 2   if (resource_info->matte_color != (char *) NULL)     {        /*J         Matte color is specified as a X resource or command line argument.       */E       status=XParseColor(display,colormap,resource_info->matte_color, "         &pixel_info->matte_color);       if (status == 0)M         Warning("Color is not known to X server",resource_info->matte_color); $       pixel_info->matte_color.pixel=<         XStandardPixel(map_info,pixel_info->matte_color,16);=       pixel_info->matte_color.flags=DoRed | DoGreen | DoBlue;      }    /*     Set highlight color.   */?   pixel_info->highlight_color.red=(pixel_info->matte_color.red* @     HighlightModulate+(MaxRGB-HighlightModulate)*65535L)/MaxRGB;C   pixel_info->highlight_color.green=(pixel_info->matte_color.green* @     HighlightModulate+(MaxRGB-HighlightModulate)*65535L)/MaxRGB;A   pixel_info->highlight_color.blue=(pixel_info->matte_color.blue* @     HighlightModulate+(MaxRGB-HighlightModulate)*65535L)/MaxRGB;$   pixel_info->highlight_color.pixel=<     XStandardPixel(map_info,pixel_info->highlight_color,16);=   pixel_info->highlight_color.flags=DoRed | DoGreen | DoBlue;    /*     Set shadow color.    */-   pixel_info->shadow_color.red=(unsigned int) 8     (pixel_info->matte_color.red*ShadowModulate)/MaxRGB;/   pixel_info->shadow_color.green=(unsigned int) :     (pixel_info->matte_color.green*ShadowModulate)/MaxRGB;.   pixel_info->shadow_color.blue=(unsigned int)9     (pixel_info->matte_color.blue*ShadowModulate)/MaxRGB; !   pixel_info->shadow_color.pixel= 9     XStandardPixel(map_info,pixel_info->shadow_color,16); :   pixel_info->shadow_color.flags=DoRed | DoGreen | DoBlue;   /*     Set depth color.   */,   pixel_info->depth_color.red=(unsigned int)7     (pixel_info->matte_color.red*DepthModulate)/MaxRGB; .   pixel_info->depth_color.green=(unsigned int)9     (pixel_info->matte_color.green*DepthModulate)/MaxRGB; -   pixel_info->depth_color.blue=(unsigned int) 8     (pixel_info->matte_color.blue*DepthModulate)/MaxRGB;    pixel_info->depth_color.pixel=8     XStandardPixel(map_info,pixel_info->depth_color,16);9   pixel_info->depth_color.flags=DoRed | DoGreen | DoBlue;    /*     Set trough color.    */-   pixel_info->trough_color.red=(unsigned int) 8     (pixel_info->matte_color.red*TroughModulate)/MaxRGB;/   pixel_info->trough_color.green=(unsigned int) :     (pixel_info->matte_color.green*TroughModulate)/MaxRGB;.   pixel_info->trough_color.blue=(unsigned int)9     (pixel_info->matte_color.blue*TroughModulate)/MaxRGB; !   pixel_info->trough_color.pixel= 9     XStandardPixel(map_info,pixel_info->trough_color,16); :   pixel_info->trough_color.flags=DoRed | DoGreen | DoBlue;   /*     Set pen color.   */#   for (i=0; i < MaxNumberPens; i++)    { 5     (void) XParseColor(display,colormap,PenColors[i], "       &pixel_info->pen_colors[i]);E     status=XParseColor(display,colormap,resource_info->pen_colors[i], "       &pixel_info->pen_colors[i]);     if (status == 0)M       Warning("Color is not known to X server",resource_info->pen_colors[i]); $     pixel_info->pen_colors[i].pixel=<       XStandardPixel(map_info,pixel_info->pen_colors[i],16);=     pixel_info->pen_colors[i].flags=DoRed | DoGreen | DoBlue;    } 5   pixel_info->box_color=pixel_info->background_color; 5   pixel_info->pen_color=pixel_info->foreground_color;    pixel_info->box_index=0;   pixel_info->pen_index=1;   /*.     Initialize gamma map to linear brightness.   *//   if (pixel_info->gamma_map != (XColor *) NULL) )     free((char *) pixel_info->gamma_map); E   pixel_info->gamma_map=(XColor *) malloc((MaxRGB+1)*sizeof(XColor)); /   if (pixel_info->gamma_map == (XColor *) NULL) A     Error("Unable to get pixel info","Memory allocation failed");    for (i=0; i <= MaxRGB; i++)    { #     pixel_info->gamma_map[i].red=i; %     pixel_info->gamma_map[i].green=i; $     pixel_info->gamma_map[i].blue=i;   }    if (image != (Image *) NULL)     { @       if (resource_info->gamma_correct && (image->gamma != 0.0))	         {            double             blue_gamma,              green_gamma,             red_gamma;  
           int              count;             /*?             Initialize map relative to display and image gamma.            */           red_gamma=1.0;           green_gamma=1.0;           blue_gamma=1.0; B           count=sscanf(resource_info->display_gamma,"%lf,%lf,%lf",1             &red_gamma,&green_gamma,&blue_gamma);            if (count == 1) 
             { $               green_gamma=red_gamma;#               blue_gamma=red_gamma; 
             } "           red_gamma*=image->gamma;$           green_gamma*=image->gamma;#           blue_gamma*=image->gamma; %           for (i=0; i <= MaxRGB; i++)            { =             pixel_info->gamma_map[i].red=(short unsigned int) B               ((pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)+0.5);?             pixel_info->gamma_map[i].green=(short unsigned int) D               ((pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);>             pixel_info->gamma_map[i].blue=(short unsigned int)C               ((pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);            } 	         } &       if (image->class == PseudoClass)	         {            register XColor              *gamma_map;              /*B             Initialize pixel array for images of type PseudoClass.           */*           gamma_map=pixel_info->gamma_map;+           for (i=0; i < image->colors; i++) "             pixel_info->pixels[i]=M               XGammaPixel(map_info,gamma_map,image->colormap+i,QuantumDepth); +           for (i=0; i < MaxNumberPens; i++) P             pixel_info->pixels[image->colors+i]=pixel_info->pen_colors[i].pixel;,           pixel_info->colors+=MaxNumberPens;	         }      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e C l a s s                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XGetResourceClass queries the X server for the specified resource F %  name or class.  If the resource name or class is not defined in the4 %  database, the supplied default value is returned. % 2 %  The format of the XGetResourceClass routine is: % M %      value=XGetResourceClass(database,client_name,keyword,resource_default)  % + %  A description of each parameter follows:  % N %    o value: Function XGetResourceClass returns the resource value associatedO %      with the name or class.  If none is found, the supplied default value is  %      returned. % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */E char *XGetResourceClass(XrmDatabase database,const char *client_name, -   const char *keyword,char *resource_default)  {    char"     resource_class[MaxTextLength],!     resource_name[MaxTextLength];      int      status;   
   static char      *resource_type;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   *resource_class='\0';    if (keyword != (char *) NULL)      {        unsigned char 
         c,
         k;         /*.         Initialize resource keyword and class.       */@       (void) sprintf(resource_name,"%s.%s",client_name,keyword);       c=(*client_name); %       if ((c >= XK_a) && (c <= XK_z))          c-=(XK_a-XK_A); 
       else5         if ((c >= XK_agrave) && (c <= XK_odiaeresis)) #           c-=(XK_agrave-XK_Agrave);          else2           if ((c >= XK_oslash) && (c <= XK_thorn))'             c-=(XK_oslash-XK_Ooblique);        k=(*keyword); %       if ((k >= XK_a) && (k <= XK_z))          k-=(XK_a-XK_A); 
       else5         if ((k >= XK_agrave) && (k <= XK_odiaeresis)) #           k-=(XK_agrave-XK_Agrave);          else2           if ((k >= XK_oslash) && (k <= XK_thorn))'             k-=(XK_oslash-XK_Ooblique); M       (void) sprintf(resource_class,"%c%s.%c%s",c,client_name+1,k,keyword+1);      } M   status=XrmGetResource(database,resource_name,resource_class,&resource_type,      &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e D a t a b a s e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetResourceDatabase creates a new resource database and %  initializes it. % 5 %  The format of the XGetResourceDatabase routine is:  % 9 %      database=XGetResourceDatabase(display,client_name)  % + %  A description of each parameter follows:  % I %    o database: Function XGetResourceDatabase returns the database after  %      it is initialized.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  %  %  */D XrmDatabase XGetResourceDatabase(Display *display,char *client_name) {    char     filename[MaxTextLength];     register char      *p;      unsigned char      c;  
   XrmDatabase      resource_database,     server_database;     /*!     Initialize resource database.    */   XrmInitialize();+   XGetDefault(display,client_name,"dummy"); ,   resource_database=XrmGetDatabase(display);   /*!     Combine application database.    */#   if (client_name != (char *) NULL)      {        /*         Get basename of client.        */,       p=client_name+(strlen(client_name)-1);.       while ((p > client_name) && (*p != '/'))         p--;       if (*p == '/')         client_name=p+1;     }    c=(*client_name); !   if ((c >= XK_a) && (c <= XK_z))      c-=(XK_a-XK_A);    else1     if ((c >= XK_agrave) && (c <= XK_odiaeresis))        c-=(XK_agrave-XK_Agrave);      else.       if ((c >= XK_oslash) && (c <= XK_thorn))#         c-=(XK_oslash-XK_Ooblique); H   (void) sprintf(filename,"%s%c%s",ApplicationDefaults,c,client_name+1);<   XrmCombineFileDatabase(filename,&resource_database,False);7   if (XResourceManagerString(display) != (char *) NULL)      {        /*          Combine server database.       */L       server_database=XrmGetStringDatabase(XResourceManagerString(display));C       XrmCombineDatabase(server_database,&resource_database,False);      }    /*$     Merge user preferences database.   */D   (void) sprintf(filename,"%s%src",PreferencesDefaults,client_name);   ExpandFilename(filename); <   XrmCombineFileDatabase(filename,&resource_database,False);   return(resource_database); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetResourceInfo initializes the ResourceInfo structure. % 1 %  The format of the XGetResourceInfo routine is:  % D %      XGetResourceInfo(resource_database,client_name,resource_info) % + %  A description of each parameter follows:  % F %    o resource_database: Specifies a resource database; returned from %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */F void XGetResourceInfo(XrmDatabase resource_database,char *client_name,   XResourceInfo *resource_info)  {    char     *resource_value;     register char      *p;   #   if (client_name != (char *) NULL)      {        /*         Get basename of client.        */,       p=client_name+(strlen(client_name)-1);.       while ((p > client_name) && (*p != '/'))         p--;       if (*p == '/')         client_name=p+1;     }    /*$     Initialize resource info fields.   */5   resource_info->resource_database=resource_database; #   resource_info->close_server=True;    resource_value= H     XGetResourceClass(resource_database,client_name,"backdrop","False");1   resource_info->backdrop=IsTrue(resource_value); I   resource_info->background_color=XGetResourceInstance(resource_database, .     client_name,"background",BackgroundColor);E   resource_info->border_color=XGetResourceInstance(resource_database, +     client_name,"borderColor",BorderColor);    resource_value= G     XGetResourceClass(resource_database,client_name,"borderWidth","2"); 3   resource_info->border_width=atoi(resource_value); P   resource_info->browse_command=XGetResourceClass(resource_database,client_name,#     "browseCommand",BrowseCommand);    resource_value= I     XGetResourceClass(resource_database,client_name,"colormap","shared"); ,   resource_info->colormap=UndefinedColormap;3   if (Latin1Compare("private",resource_value) == 0) ,     resource_info->colormap=PrivateColormap;2   if (Latin1Compare("shared",resource_value) == 0)+     resource_info->colormap=SharedColormap; 3   if (resource_info->colormap == UndefinedColormap) 9     Warning("Unrecognized colormap type",resource_value);    resource_value= M     XGetResourceClass(resource_database,client_name,"colorRecovery","False"); 7   resource_info->color_recovery=IsTrue(resource_value);    resource_value= H     XGetResourceClass(resource_database,client_name,"colorspace","rgb");0   resource_info->colorspace=UndefinedColorspace;0   if (Latin1Compare("gray",resource_value) == 0)-     resource_info->colorspace=GRAYColorspace; /   if (Latin1Compare("rgb",resource_value) == 0) ,     resource_info->colorspace=RGBColorspace;0   if (Latin1Compare("ohta",resource_value) == 0)-     resource_info->colorspace=OHTAColorspace; /   if (Latin1Compare("xyz",resource_value) == 0) ,     resource_info->colorspace=XYZColorspace;/   if (Latin1Compare("yiq",resource_value) == 0) ,     resource_info->colorspace=YIQColorspace;/   if (Latin1Compare("yuv",resource_value) == 0) ,     resource_info->colorspace=YUVColorspace;7   if (resource_info->colorspace == UndefinedColorspace) ;     Warning("Unrecognized colorspace type",resource_value);    resource_value= K     XGetResourceClass(resource_database,client_name,"confirmExit","False"); 5   resource_info->confirm_exit=IsTrue(resource_value);    resource_value= E     XGetResourceClass(resource_database,client_name,"debug","False"); .   resource_info->debug=IsTrue(resource_value);N   resource_value=XGetResourceClass(resource_database,client_name,"delay","0");,   resource_info->delay=atoi(resource_value);O   resource_info->display_gamma=XGetResourceClass(resource_database,client_name, (     "displayGamma",DefaultDisplayGamma);   resource_value= N     XGetResourceClass(resource_database,client_name,"displayWarnings","True");9   resource_info->display_warnings=IsTrue(resource_value);    resource_value= E     XGetResourceClass(resource_database,client_name,"dither","True"); /   resource_info->dither=IsTrue(resource_value); P   resource_info->editor_command=XGetResourceClass(resource_database,client_name,#     "editorCommand",EditorCommand);    resource_info->font=J     XGetResourceClass(resource_database,client_name,"font",(char *) NULL);F   resource_info->font=XGetResourceClass(resource_database,client_name,$     "fontList",resource_info->font);   resource_info->font_name[0]=E     XGetResourceClass(resource_database,client_name,"font1","fixed");    resource_info->font_name[1]=H     XGetResourceClass(resource_database,client_name,"font2","variable");   resource_info->font_name[2]=C     XGetResourceClass(resource_database,client_name,"font3","5x8");    resource_info->font_name[3]=D     XGetResourceClass(resource_database,client_name,"font4","6x10");   resource_info->font_name[4]=H     XGetResourceClass(resource_database,client_name,"font5","7x13bold");   resource_info->font_name[5]=H     XGetResourceClass(resource_database,client_name,"font6","8x13bold");   resource_info->font_name[6]=H     XGetResourceClass(resource_database,client_name,"font7","9x15bold");   resource_info->font_name[7]=E     XGetResourceClass(resource_database,client_name,"font8","10x20");    resource_info->font_name[8]=E     XGetResourceClass(resource_database,client_name,"font9","12x24");    resource_info->font_name[9]=E     XGetResourceClass(resource_database,client_name,"font0","fixed");    resource_info->font_name[10]= E     XGetResourceClass(resource_database,client_name,"font0","fixed"); I   resource_info->foreground_color=XGetResourceInstance(resource_database, .     client_name,"foreground",ForegroundColor);   resource_value= K     XGetResourceClass(resource_database,client_name,"gammaCorrect","True"); 6   resource_info->gamma_correct=IsTrue(resource_value);   resource_value= G     XGetResourceClass(resource_database,client_name,"gravity","North");    resource_info->gravity=(-1);2   if (Latin1Compare("Forget",resource_value) == 0))     resource_info->gravity=ForgetGravity; 5   if (Latin1Compare("NorthWest",resource_value) == 0) ,     resource_info->gravity=NorthWestGravity;1   if (Latin1Compare("North",resource_value) == 0) (     resource_info->gravity=NorthGravity;5   if (Latin1Compare("NorthEast",resource_value) == 0) ,     resource_info->gravity=NorthEastGravity;0   if (Latin1Compare("West",resource_value) == 0)'     resource_info->gravity=WestGravity; 2   if (Latin1Compare("Center",resource_value) == 0))     resource_info->gravity=CenterGravity; 0   if (Latin1Compare("East",resource_value) == 0)'     resource_info->gravity=EastGravity; 5   if (Latin1Compare("SouthWest",resource_value) == 0) ,     resource_info->gravity=SouthWestGravity;1   if (Latin1Compare("South",resource_value) == 0) (     resource_info->gravity=SouthGravity;5   if (Latin1Compare("SouthEast",resource_value) == 0) ,     resource_info->gravity=SouthEastGravity;2   if (Latin1Compare("Static",resource_value) == 0))     resource_info->gravity=StaticGravity; %   if (resource_info->gravity == (-1))      { :       Warning("Unrecognized gravity type",resource_value);+       resource_info->gravity=CenterGravity;      } ?   (void) getcwd(resource_info->home_directory,MaxTextLength-1); O   resource_info->icon_geometry=XGetResourceClass(resource_database,client_name, "     "iconGeometry",(char *) NULL);   resource_value= F     XGetResourceClass(resource_database,client_name,"iconic","False");/   resource_info->iconic=IsTrue(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"immutable","False"); 2   resource_info->immutable=IsTrue(resource_value);D   resource_info->image_geometry=XGetResourceClass(resource_database,*     client_name,"geometry",(char *) NULL);P   resource_value=XGetResourceClass(resource_database,client_name,"magnify","3");.   resource_info->magnify=atoi(resource_value);   resource_info->map_type=I     XGetResourceClass(resource_database,client_name,"map",(char *) NULL); D   resource_info->matte_color=XGetResourceInstance(resource_database,,     client_name,"mattecolor",(char *) NULL);   resource_value= J     XGetResourceClass(resource_database,client_name,"monochrome","False");3   resource_info->monochrome=IsTrue(resource_value);    resource_info->name=J     XGetResourceClass(resource_database,client_name,"name",(char *) NULL);O   resource_value=XGetResourceClass(resource_database,client_name,"colors","0"); 4   resource_info->number_colors=atoi(resource_value);   resource_info->pen_colors[0]= D     XGetResourceClass(resource_database,client_name,"pen1","black");   resource_info->pen_colors[1]= C     XGetResourceClass(resource_database,client_name,"pen2","blue");    resource_info->pen_colors[2]= C     XGetResourceClass(resource_database,client_name,"pen3","cyan");    resource_info->pen_colors[3]= D     XGetResourceClass(resource_database,client_name,"pen4","green");   resource_info->pen_colors[4]= C     XGetResourceClass(resource_database,client_name,"pen5","gray");    resource_info->pen_colors[5]= B     XGetResourceClass(resource_database,client_name,"pen6","red");   resource_info->pen_colors[6]= F     XGetResourceClass(resource_database,client_name,"pen7","magenta");   resource_info->pen_colors[7]= E     XGetResourceClass(resource_database,client_name,"pen8","yellow");    resource_info->pen_colors[8]= D     XGetResourceClass(resource_database,client_name,"pen9","white");   resource_info->pen_colors[9]= C     XGetResourceClass(resource_database,client_name,"pen0","gray");     resource_info->pen_colors[10]=C     XGetResourceClass(resource_database,client_name,"pen0","gray"); O   resource_info->print_command=XGetResourceClass(resource_database,client_name, !     "printCommand",PrintCommand); P   resource_value=XGetResourceClass(resource_database,client_name,"quantum","1");.   resource_info->quantum=atoi(resource_value);   resource_info->server_name= P     XGetResourceClass(resource_database,client_name,"serverName",(char *) NULL);   resource_info->text_font= J     XGetResourceClass(resource_database,client_name,"font",(char *) NULL);K   resource_info->text_font=XGetResourceClass(resource_database,client_name, -     "textFontList",resource_info->text_font);    resource_info->title= K     XGetResourceClass(resource_database,client_name,"title",(char *) NULL);    resource_value= E     XGetResourceClass(resource_database,client_name,"treeDepth","0"); 1   resource_info->tree_depth=atoi(resource_value);    resource_value= K     XGetResourceClass(resource_database,client_name,"undoCache",UndoCache); 1   resource_info->undo_cache=atoi(resource_value);    resource_value= F     XGetResourceClass(resource_database,client_name,"update","False");/   resource_info->update=IsTrue(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"usePixmap","False"); 3   resource_info->use_pixmap=IsTrue(resource_value);    resource_value= K     XGetResourceClass(resource_database,client_name,"sharedMemory","True"); :   resource_info->use_shared_memory=IsTrue(resource_value);   resource_info->visual_type= L     XGetResourceClass(resource_database,client_name,"visual",(char *) NULL);N   resource_info->window_group=XGetResourceClass(resource_database,client_name,!     "windowGroup",(char *) NULL);    resource_info->window_id= L     XGetResourceClass(resource_database,client_name,"window",(char *) NULL);D   resource_info->write_filename=XGetResourceClass(resource_database,/     client_name,"writeFilename",(char *) NULL);    /*     Handle side-effects.   */    if (resource_info->monochrome)     { %       resource_info->number_colors=2; "       resource_info->tree_depth=8;!       resource_info->dither=True; /       resource_info->colorspace=GRAYColorspace;      } 2   if (resource_info->colorspace == GRAYColorspace)     { '       resource_info->number_colors=256; "       resource_info->tree_depth=8;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n s t a n c e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XGetResourceInstance queries the X server for the specified K %  resource name.  If the resource name is not defined in the database, the & %  supplied default value is returned. % 5 %  The format of the XGetResourceInstance routine is:  % P %      value=XGetResourceInstance(database,client_name,keyword,resource_default) % + %  A description of each parameter follows:  % F %    o value: Function XGetResourceInstance returns the resource valueI %      associated with the name or class.  If none is found, the supplied ! %      default value is returned.  % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */H char *XGetResourceInstance(XrmDatabase database,const char *client_name,-   const char *keyword,char *resource_default)  {    char     *resource_type, !     resource_name[MaxTextLength];      int      status;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   if (keyword != (char *) NULL) >     (void) sprintf(resource_name,"%s.%s",client_name,keyword);L   status=XrmGetResource(database,resource_name,"ImageMagick",&resource_type,     &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t S u b w i n d o w                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XGetSubwindow returns the subwindow of a window choosen the , %  user with the pointer and a button press. % . %  The format of the XGetSubwindow routine is: % 2 %      subwindow=XGetSubwindow(display,window,x,y) % + %  A description of each parameter follows:  % N %    o subwindow: Function XGetSubwindow returns NULL if no subwindow is found+ %      otherwise the subwindow is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % / %    o window: Specifies a pointer to a Window.  % G %    o x: the x coordinate of the pointer relative to the origin of the  %      window. % G %    o y: the y coordinate of the pointer relative to the origin of the  %      window. %  %  */@ Window XGetSubwindow(Display *display,Window window,int x,int y) {    Window     source_window,     target_window;     int      status, 
     x_offset, 
     y_offset;   =   source_window=XRootWindow(display,XDefaultScreen(display));    if (window == (Window) NULL)     return(source_window);   target_window=window; 
   for ( ; ; )    { B     status=XTranslateCoordinates(display,source_window,window,x,y,*       &x_offset,&y_offset,&target_window);     if (status != True)        break;'     if (target_window == (Window) NULL)        break;     source_window=window;      window=target_window;      x=x_offset;      y=y_offset;    } %   if (target_window == (Window) NULL)      target_window=window;    return(target_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w C o l o r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XGetWindowColor returns the color of a pixel interactively choosen %  from the X server.  % 0 %  The format of the XGetWindowColor routine is: % + %      status=XGetWindowColor(display,name)  % + %  A description of each parameter follows:  % M %    o status: Function XGetWindowColor returns True if the color is obtained B %      from the X server.  False is returned if any errors occurs. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % I %    o name: The name of of the color if found in the X Color Database is ) %      returned in this character string.  %  %  */9 unsigned int XGetWindowColor(Display *display,char *name)  {    FILE     *database;     int      x,     y;     RectangleInfo      crop_info;     unsigned int     status;      Window
     child,     client_window,     root_window,     target_window;     XColor
     color;     XImage     *ximage;     XWindowAttributes      window_attributes;     /*%     Choose a pixel from the X server.    */2   target_window=XSelectWindow(display,&crop_info);;   root_window=XRootWindow(display,XDefaultScreen(display));    client_window=target_window;#   if (target_window != root_window)      {        unsigned int
         d;         /*         Get client window.       */P       status=XGetGeometry(display,target_window,&root_window,&x,&x,&d,&d,&d,&d);       if (status != 0)	         { =           client_window=XClientWindow(display,target_window); &           target_window=client_window;	         }      }    /*     Verify window is viewable.   */H   status=XGetWindowAttributes(display,target_window,&window_attributes);G   if ((status == False) || (window_attributes.map_state != IsViewable))      return(False);   /*     Get window X image.    */F   XTranslateCoordinates(display,root_window,target_window,crop_info.x,     crop_info.y,&x,&y,&child);D   ximage=XGetImage(display,target_window,x,y,1,1,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return(False);$   color.pixel=XGetPixel(ximage,0,0);   XDestroyImage(ximage);   /*#     Query X server for pixel color.    */9   XQueryColor(display,window_attributes.colormap,&color); <   (void) sprintf(name,"#%02x%02x%02x",XDownScale(color.red),4     XDownScale(color.green),XDownScale(color.blue));'   database=fopen(RGBColorDatabase,"r");     if (database != (FILE *) NULL)     { 
       char!         colorname[MaxTextLength],          text[MaxTextLength];  	       int 
         blue,          count,         green,         red;         /*1         Match color against the X color database.        */C       while (fgets(text,MaxTextLength-1,database) != (char *) NULL)        { K         count=sscanf(text,"%d %d %d %[^\n]\n",&red,&green,&blue,colorname);          if (count != 4)            continue; -         if ((red == XDownScale(color.red)) && 1             (green == XDownScale(color.green)) && -             (blue == XDownScale(color.blue)))            { *             (void) strcpy(name,colorname);             break;           }        }        (void) fclose(database);     }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XGetWindowImage reads an image from the target X window and returns M %  it.  XGetWindowImage optionally descends the window hierarchy and overlays . %  the target image with each subwindow image. % 0 %  The format of the XGetWindowImage routine is: % : %      image=XGetWindowImage(display,window,borders,level) % + %  A description of each parameter follows:  % H %    o image: Function XGetWindowImage returns a MIFF image if it can beH %      successfully read from the X window.  A null image is returned if %      any errors occurs.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % = %    o window: Specifies the window to obtain the image from.  % E %    o borders: Specifies whether borders pixels are to be saved with  %      the image.  % E %    o level: Specifies an unsigned integer representing the level of I %      decent in the window hierarchy.  This value must be zero or one on J %      the initial call to XGetWindowImage.  A value of zero returns afterJ %      one call.  A value of one causes the function to descend the windowI %      hierarchy and overlays the target image with each subwindow image.  %  %  */< Image *XGetWindowImage(Display *display,const Window window,6   const unsigned int borders,const unsigned int level) { - #define LoadImageText  "  Loading image...  "      typedef struct _ColormapList   {      Colormap       colormap;   
     XColor       *colors;       struct _ColormapList       *next;   } ColormapList;      GC     annotate_context;      Image      *image;      int      display_height,      display_width,     number_colors,     status, 
     x_offset, 
     y_offset;      RectangleInfo      crop_info;     register int     i,     x,     y;     register RunlengthPacket     *p;      register unsigned long
     pixel;     static ColormapList +     *colormap_list = (ColormapList *) NULL;      Window
     child,     root_window;     XColor     *colors;     XGCValues      context_values;      XImage     *ximage;     XWindowAttributes      window_attributes;     /*     Verify window is viewable.   */A   status=XGetWindowAttributes(display,window,&window_attributes); G   if ((status == False) || (window_attributes.map_state != IsViewable))      return((Image *) NULL);    /*2     Cropping rectangle is relative to root window.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); K   XTranslateCoordinates(display,window,root_window,0,0,&x_offset,&y_offset,      &child);   crop_info.x=x_offset;    crop_info.y=y_offset; *   crop_info.width=window_attributes.width;,   crop_info.height=window_attributes.height;   if (borders)     {        /*          Include border in image.       */2       crop_info.x-=window_attributes.border_width;2       crop_info.y-=window_attributes.border_width;;       crop_info.width+=window_attributes.border_width << 1; <       crop_info.height+=window_attributes.border_width << 1;     }    /*     Crop to root window.   */   if (crop_info.x < 0)     { 2       if ((crop_info.x+(int) crop_info.width) < 0)         return((Image *) NULL); #       crop_info.width+=crop_info.x;        crop_info.x=0;     }    if (crop_info.y < 0)     { 3       if ((crop_info.y+(int) crop_info.height) < 0)          return((Image *) NULL); $       crop_info.height+=crop_info.y;       crop_info.y=0;     } ?   display_width=XDisplayWidth(display,XDefaultScreen(display)); :   if ((crop_info.x+(int) crop_info.width) > display_width)     { '       if (crop_info.x >= display_width)          return((Image *) NULL); 0       crop_info.width=display_width-crop_info.x;     } A   display_height=XDisplayHeight(display,XDefaultScreen(display)); <   if ((crop_info.y+(int) crop_info.height) > display_height)     { (       if (crop_info.y >= display_height)         return((Image *) NULL); 2       crop_info.height=display_height-crop_info.y;     }    crop_info.x-=x_offset;   crop_info.y-=y_offset;   /*D     Alert user we are about to get an X region by flashing a border.   */I   context_values.background=XBlackPixel(display,XDefaultScreen(display)); I   context_values.foreground=XWhitePixel(display,XDefaultScreen(display)); #   context_values.function=GXinvert;    context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors; I   annotate_context=XCreateGC(display,window,GCBackground | GCForeground | @     GCFunction | GCPlaneMask | GCSubwindowMode,&context_values);$   if (annotate_context != (GC) NULL)     { F       XHighlightRectangle(display,window,annotate_context,&crop_info);9       XDelay(display,(unsigned long) (SuspendTime << 2)); F       XHighlightRectangle(display,window,annotate_context,&crop_info);     }    /*     Get window X image.    */J   ximage=XGetImage(display,window,crop_info.x,crop_info.y,crop_info.width,(     crop_info.height,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return((Image *) NULL);    number_colors=0;   colors=(XColor *) NULL; 4   if (window_attributes.colormap != (Colormap) NULL)     {        ColormapList         *p;          /*1         Search colormap list for window colormap.        */:       number_colors=window_attributes.visual->map_entries;B       for (p=colormap_list; p != (ColormapList *) NULL; p=p->next)6         if (p->colormap == window_attributes.colormap)           break;%       if (p == (ColormapList *) NULL) 	         {            /*$             Get the window colormap.           */A           colors=(XColor *) malloc(number_colors*sizeof(XColor)); (           if (colors == (XColor *) NULL)
             { $               XDestroyImage(ximage);%               return((Image *) NULL); 
             } A           if ((window_attributes.visual->class != DirectColor) && =               (window_attributes.visual->class != TrueColor)) -             for (i=0; i < number_colors; i++) 
             {                 colors[i].pixel=i;               colors[i].pad=0;
             }            else
             {                unsigned long                  blue,                  blue_bit,                  green,                 green_bit,                 red,                 red_bit;                 /*0                 DirectColor or TrueColor visual.               */               red=0;               green=0;               blue=0; :               red_bit=window_attributes.visual->red_mask &:                 (~(window_attributes.visual->red_mask)+1);>               green_bit=window_attributes.visual->green_mask &<                 (~(window_attributes.visual->green_mask)+1);<               blue_bit=window_attributes.visual->blue_mask &;                 (~(window_attributes.visual->blue_mask)+1); /               for (i=0; i < number_colors; i++)                {l3                 colors[i].pixel=red | green | blue;                   colors[i].pad=0;                 red+=red_bit; =                 if (red > window_attributes.visual->red_mask)                    red=0;!                 green+=green_bit;mA                 if (green > window_attributes.visual->green_mask)                    green=0;                 blue+=blue_bit;P?                 if (blue > window_attributes.visual->blue_mask)e                   blue=0;a               }o
             }aA           XQueryColors(display,window_attributes.colormap,colors,t             (int) number_colors);           /*-             Append colormap to colormap list.            */:           p=(ColormapList *) malloc(sizeof(ColormapList));1           p->colormap=window_attributes.colormap;a           p->colors=colors;             p->next=colormap_list;           colormap_list=p;	         }i       colors=p->colors;r     }    /*     Allocate image structure.u   */*   image=AllocateImage((ImageInfo *) NULL);   if (image == (Image *) NULL)     {s       XDestroyImage(ximage);       return((Image *) NULL);w     }e   /*#     Convert X image to MIFF format.    */7   if ((window_attributes.visual->class != TrueColor) && 7       (window_attributes.visual->class != DirectColor))e     image->class=PseudoClass;    image->columns=ximage->width;    image->rows=ximage->height;p,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)     {        XDestroyImage(ximage);       DestroyImage(image);       return((Image *) NULL);a     }f   p=image->pixels;   switch (image->class)n   {s     case DirectClass:r     {n       register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,%         green_shift,         red_mask,%         red_shift;         /*:         Determine shift and mask for red, green, and blue.       */2       red_mask=window_attributes.visual->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {0         red_mask>>=1;0         red_shift++;       }a6       green_mask=window_attributes.visual->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {r         green_mask>>=1;c         green_shift++;       } 4       blue_mask=window_attributes.visual->blue_mask;       blue_shift=0;d%       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;%       }%       /*/         Convert X image to DirectClass packets.        */        if ((number_colors > 0) &&;           (window_attributes.visual->class == DirectColor)) '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);%             p->index=0;%             p->length=0;             p++;           }o	         }u
       else'         for (y=0; y < image->rows; y++)T	         { ,           for (x=0; x < image->columns; x++)           {i(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;7             p->red=XDownScale((color*65535L)/red_mask);o6             color=(pixel >> green_shift) & green_mask;;             p->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             p->blue=XDownScale((color*65535L)/blue_mask);              p->index=0;              p->length=0;             p++;           }u	         }(       break;     },     case PseudoClass:T     {        /*         Create colormap.       */"       image->colors=number_colors;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {             XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green); I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.%       */%       for (y=0; y < image->rows; y++)%       {%*         for (x=0; x < image->columns; x++)	         {t&           pixel=XGetPixel(ximage,x,y);*           p->index=(unsigned short) pixel;           p->length=0;           p++;	         }a       }t       SyncImage(image);g       break;     }r   },   XDestroyImage(ximage);$   if (annotate_context != (GC) NULL)     {e       /*<         Alert user we got the X region by flashing a border.       */F       XHighlightRectangle(display,window,annotate_context,&crop_info);       XFlush(display);F       XHighlightRectangle(display,window,annotate_context,&crop_info);(       XFreeGC(display,annotate_context);     }t   if (level != 0)      {n       unsigned int         number_children;         Window         *children,         parent;;         /*K         Descend the window hierarchy and overlay with each subwindow image.&       */F       status=XQueryTree(display,window,&root_window,&parent,&children,         &number_children);5       if ((status == True) && (number_children != 0)) 	         {i           Image              *child_image;              /*:             Composite any children in back-to-front order.           */-           for (i=0; i < number_children; i++)-           { K             child_image=XGetWindowImage(display,children[i],False,level+1); .             if (child_image != (Image *) NULL)               {(                 /*/                   Composite child window image.(                 */O                 XTranslateCoordinates(display,children[i],window,0,0,&x_offset, $                   &y_offset,&child);&                 x_offset-=crop_info.x;!                 if (x_offset < 0)                    x_offset=0; &                 y_offset-=crop_info.y;!                 if (y_offset < 0)                    y_offset=0;%M                 CompositeImage(image,ReplaceCompositeOp,child_image,x_offset,                    y_offset);*                 DestroyImage(child_image);               }            } #           XFree((void *) children); 	         }      }    if (level <= 1)      {        ColormapList         *next;         /*         Free resources.        */4       while (colormap_list != (ColormapList *) NULL)       { !         next=colormap_list->next; -         free((char *) colormap_list->colors); %         free((char *) colormap_list);          colormap_list=next;        } &       if (image->class == PseudoClass)          CompressColormap(image);     }%   return(image); }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %tO %                                                                             % O %                                                                             % O %   X G e t W i n d o w I n f o                                               %hO %                                                                             %hO %                                                                             % O %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %eA %  Function XGetWindowInfo initializes the XWindowInfo structure.t %n/ %  The format of the XGetWindowInfo routine is:  % H %      XGetWindowInfo(display,visual_info,map_info,pixel_info,font_info, %        resource_info,window) %%+ %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.% %% %% */> void XGetWindowInfo(Display *display,XVisualInfo *visual_info,L   XStandardColormap *map_info,XPixelInfo *pixel_info,XFontStruct *font_info,3   XResourceInfo *resource_info,XWindowInfo *window)t {I   /*     Initialize window info.f   */"   if (window->id != (Window) NULL)     {f*       XFreeCursor(display,window->cursor);/       XFreeCursor(display,window->busy_cursor);c5       if (window->highlight_stipple != (Pixmap) NULL)e7         XFreePixmap(display,window->highlight_stipple);p2       if (window->shadow_stipple != (Pixmap) NULL)4         XFreePixmap(display,window->shadow_stipple);     }i   else     {l       window->id=(Window) NULL;t@       window->x=XDisplayWidth(display,visual_info->screen) >> 1;@       window->y=XDisplayWidth(display,visual_info->screen) >> 1;%       window->ximage=(XImage *) NULL;n*       window->matte_image=(XImage *) NULL;#       window->pixmap=(Pixmap) NULL; )       window->matte_pixmap=(Pixmap) NULL;        window->mapped=False;r       window->stasis=False;o"       window->shared_memory=False; #ifdef HasSharedMemory"       window->shared_memory=False;+       if (resource_info->use_shared_memory)e:         window->shared_memory=XShmQueryExtension(display);)       window->segment_info[0].shmid=(-1); )       window->segment_info[1].shmid=(-1); )       window->segment_info[2].shmid=(-1);t)       window->segment_info[3].shmid=(-1);t #endif     }/%   window->screen=visual_info->screen;e8   window->root=XRootWindow(display,visual_info->screen);%   window->visual=visual_info->visual;f#   window->class=visual_info->class;u#   window->depth=visual_info->depth;y"   window->visual_info=visual_info;   window->map_info=map_info;    window->pixel_info=pixel_info;   window->font_info=font_info;8   window->cursor=XCreateFontCursor(display,XC_left_ptr);:   window->busy_cursor=XCreateFontCursor(display,XC_watch);   window->name="\0";!   window->geometry=(char *) NULL;~   window->icon_name="\0";=5   window->icon_geometry=resource_info->icon_geometry;a&   window->crop_geometry=(char *) NULL;   window->flags=PSize;   window->width=1;   window->height=1;e   window->min_width=1;   window->min_height=1;r   window->width_inc=1;   window->height_inc=1;l3   window->border_width=resource_info->border_width;o8   window->annotate_context=pixel_info->annotate_context;:   window->highlight_context=pixel_info->highlight_context;4   window->widget_context=pixel_info->widget_context;'   window->shadow_stipple=(Pixmap) NULL;o*   window->highlight_stipple=(Pixmap) NULL;   window->immutable=False;   window->data=0;fK   window->mask=CWBackingStore | CWBackPixel | CWBackPixmap | CWBitGravity |pK     CWBorderPixel | CWColormap | CWCursor | CWDontPropagate | CWEventMask |a4     CWOverrideRedirect | CWSaveUnder | CWWinGravity;I   window->attributes.background_pixel=pixel_info->background_color.pixel;u5   window->attributes.background_pixmap=(Pixmap) NULL;t-   window->attributes.backing_store=NotUseful;n/   window->attributes.bit_gravity=ForgetGravity;nA   window->attributes.border_pixel=pixel_info->border_color.pixel; 1   window->attributes.colormap=map_info->colormap;o+   window->attributes.cursor=window->cursor;L7   window->attributes.do_not_propagate_mask=NoEventMask;e,   window->attributes.event_mask=NoEventMask;-   window->attributes.override_redirect=False;o&   window->attributes.save_under=False;2   window->attributes.win_gravity=NorthWestGravity;   window->orphan=False;p }e   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %sO %                                                                             %>O %                                                                             %,O %   X H i g h l i g h t E l l i p s e                                         %pO %                                                                             %nO %                                                                             % O %                                                                             %OO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XHighlightEllipse puts a border on the X server around a regiono %  defined by highlight_info.u %a2 %  The format of the XHighlightEllipse routine is: %tF %    XHighlightEllipse(display,window,annotate_context,highlight_info) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %e9 %    o window: Specifies a pointer to a Window structure.x %i? %    o annotate_context: Specifies a pointer to a GC structure.( %oL %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %. %e */J void XHighlightEllipse(Display *display,Window window,GC annotate_context,&   const RectangleInfo *highlight_info) {-B   if ((highlight_info->width < 4) || (highlight_info->height < 4))     return;e=   XDrawArc(display,window,annotate_context,highlight_info->x,eG     highlight_info->y,highlight_info->width-1,highlight_info->height-1,o     0,360*64);?   XDrawArc(display,window,annotate_context,highlight_info->x+1,eI     highlight_info->y+1,highlight_info->width-3,highlight_info->height-3,v     0,360*64); }g e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             % O %                                                                             % O %                                                                             %_O %   X H i g h l i g h t L i n e                                               %oO %                                                                             %;O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%. % H %  Function XHighlightLine puts a border on the X server around a region %  defined by highlight_info.  % / %  The format of the XHighlightLine routine is:n % C %    XHighlightLine(display,window,annotate_context,highlight_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %t9 %    o window: Specifies a pointer to a Window structure.  % ? %    o annotate_context: Specifies a pointer to a GC structure.s % L %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %o %e */G void XHighlightLine(Display *display,Window window,GC annotate_context, !   const XSegment *highlight_info)t {_?   XDrawLine(display,window,annotate_context,highlight_info->x1, >     highlight_info->y1,highlight_info->x2,highlight_info->y2); }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %oO %                                                                             % O %                                                                             %%O %   X H i g h l i g h t R e c t a n g l e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XHighlightRectangle puts a border on the X server around a region  %  defined by highlight_info.  % 4 %  The format of the XHighlightRectangle routine is: % H %    XHighlightRectangle(display,window,annotate_context,highlight_info) %%+ %  A description of each parameter follows:% %%D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %i9 %    o window: Specifies a pointer to a Window structure.w %h? %    o annotate_context: Specifies a pointer to a GC structure.m %dL %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %h %r */L void XHighlightRectangle(Display *display,Window window,GC annotate_context,&   const RectangleInfo *highlight_info) {oB   if ((highlight_info->width < 4) || (highlight_info->height < 4))     return;cC   XDrawRectangle(display,window,annotate_context,highlight_info->x, H     highlight_info->y,highlight_info->width-1,highlight_info->height-1);E   XDrawRectangle(display,window,annotate_context,highlight_info->x+1,oJ     highlight_info->y+1,highlight_info->width-3,highlight_info->height-3); }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %'O %                                                                             %sO %                                                                             %UO %   X M a k e C u r s o r                                                     %)O %                                                                             %\O %                                                                             %qO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %)8 %  Function XMakeCursor creates a crosshairs X11 cursor. % , %  The format of the XMakeCursor routine is: %tM %      XMakeCursor(display,window,colormap,background_color,foreground_color)l %*+ %  A description of each parameter follows:  %oE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %-E %    o window: Specifies the ID of the window for which the cursor is  %      assigned. %-K %    o colormap: Specifies the ID of the colormap from which the background . %      and foreground color will be retrieved. % N %    o background_color: Specifies the color to use for the cursor background. %-N %    o foreground_color: Specifies the color to use for the cursor foreground. %  %f */D Cursor XMakeCursor(Display *display,Window window,Colormap colormap,0   char *background_color,char *foreground_color) {X #define scope_height 17o #define scope_x_hot 8f #define scope_y_hot 8  #define scope_width 17     static unsigned char     scope_bits[] =     { G       0x80, 0x03, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02,;G       0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x7f,aG       0xfc, 0x01, 0x01, 0x00, 0x01, 0x7f, 0xfc, 0x01, 0x80, 0x02, 0x00,iG       0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02,h.       0x00, 0x80, 0x02, 0x00, 0x80, 0x03, 0x00     };     static unsigned char     scope_mask_bits[] ==     {eG       0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, G       0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xff, 0xfe, 0x01, 0x7f,tG       0xfc, 0x01, 0x03, 0x80, 0x01, 0x7f, 0xfc, 0x01, 0xff, 0xfe, 0x01,tG       0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06,u.       0x00, 0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00     };     Cursor     cursor;*     Pixmap	     mask,(     source;(     XColor     background,r     foreground;f  N   source=XCreateBitmapFromData(display,window,(char *) scope_bits,scope_width,     scope_height);E   mask=XCreateBitmapFromData(display,window,(char *) scope_mask_bits,      scope_width,scope_height);;   if ((source == (Pixmap) NULL) || (mask == (Pixmap) NULL)) 3     Error("Unable to create pixmap",(char *) NULL); =   XParseColor(display,colormap,background_color,&background); =   XParseColor(display,colormap,foreground_color,&foreground); I   cursor=XCreatePixmapCursor(display,source,mask,&foreground,&background,      scope_x_hot,scope_y_hot);    XFreePixmap(display,source);   XFreePixmap(display,mask);   return(cursor);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %dO %                                                                             %wO %   X M a k e I m a g e                                                       % O %                                                                             %nO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %aL %  Function XMakeImage creates an X11 image.  If the image size differs from2 %  the X11 image size, the image is first resized. % + %  The format of the XMakeImage routine is:  %gI %      status=XMakeImage(display,resource_info,window,image,width,height)  %c+ %  A description of each parameter follows:  %IA %    o status: Function XMakeImage returns True if the X image is N %      successfully created.  False is returned is there is a memory shortage. %aD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.p %,> %    o window: Specifies a pointer to a XWindowInfo structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.( %oF %    o width: Specifies the width in pixels of the rectangular area to %      display.  % H %    o height: Specifies the height in pixels of the rectangular area to %      display.  %  %  */L unsigned int XMakeImage(Display *display,const XResourceInfo *resource_info,J   XWindowInfo *window,Image *image,unsigned int width,unsigned int height) {x   Imagex     *transformed_image;z     inti
     depth,     format;m     Pixmap     matte_pixmap;c     XImage     *matte_image,c     *ximage;  4   if ((window->width == 0) || (window->height == 0))     return(False);   if (image == (Image *) NULL)     return(False);   /*'     Apply user transforms to the image.i   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   transformed_image=image;   if (window->crop_geometry)     {i       Image_         *cropped_image;l         RectangleInfon         crop_info;         /*         Crop image.t       */L       (void) XParseGeometry(window->crop_geometry,&crop_info.x,&crop_info.y,,         &crop_info.width,&crop_info.height);%       transformed_image->orphan=True;)<       cropped_image=CropImage(transformed_image,&crop_info);&       transformed_image->orphan=False;*       if (cropped_image != (Image *) NULL)	         { )           if (transformed_image != image)e,             DestroyImage(transformed_image);*           transformed_image=cropped_image;	         };     }d.   if ((width != transformed_image->columns) ||*       (height != transformed_image->rows))     {%       Image%         *zoomed_image;         /*         Scale image.       */%       transformed_image->orphan=True; H       if ((window->pixel_info->colors != 0) || transformed_image->matte)A         zoomed_image=SampleImage(transformed_image,width,height); 
       else@         zoomed_image=ScaleImage(transformed_image,width,height);)       if (zoomed_image != (Image *) NULL) 	         { )           if (transformed_image != image) ,             DestroyImage(transformed_image);)           transformed_image=zoomed_image; 	         } &       transformed_image->orphan=False;     }    /*     Create X image.    */   depth=window->depth;+   format=(depth == 1) ? XYBitmap : ZPixmap;%#   width=transformed_image->columns;r!   height=transformed_image->rows;e #ifdef HasSharedMemory   if (window->shared_memory)     {aC       ximage=XShmCreateImage(display,window->visual,depth,format,0, /         &window->segment_info[2],width,height); N       window->segment_info[2].shmid=shmget(IPC_PRIVATE,ximage->bytes_per_line*)         ximage->height,IPC_CREAT | 0777); ?       window->shared_memory=window->segment_info[2].shmid >= 0;u        if (window->shared_memory)0         window->segment_info[2].shmaddr=(char *)3           shmat(window->segment_info[2].shmid,0,0);r     }e #endif   if (!window->shared_memory) L     ximage=XCreateImage(display,window->visual,depth,format,0,(char *) NULL,*       width,height,XBitmapPad(display),0);    if (ximage == (XImage *) NULL)     {        /*!         Unable to create X image.e       */%       if (transformed_image != image) (         DestroyImage(transformed_image);7       XDefineCursor(display,window->id,window->cursor);_       return(False);     }    if (resource_info->debug)      {i)       (void) fprintf(stderr,"XImage:\n"); E       (void) fprintf(stderr,"  width, height: %dx%d\n",ximage->width,          ximage->height);=       (void) fprintf(stderr,"  format: %d\n",ximage->format);dE       (void) fprintf(stderr,"  byte order: %d\n",ximage->byte_order);vH       (void) fprintf(stderr,"  bitmap unit, bit order, pad: %d %d %d\n",I         ximage->bitmap_unit,ximage->bitmap_bit_order,ximage->bitmap_pad);m;       (void) fprintf(stderr,"  depth: %d\n",ximage->depth);NM       (void) fprintf(stderr,"  bytes per line: %d\n",ximage->bytes_per_line);dM       (void) fprintf(stderr,"  bits per pixel: %d\n",ximage->bits_per_pixel);eL       (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",?         ximage->red_mask,ximage->green_mask,ximage->blue_mask);i     }n   /*      Allocate X image pixel data.   */ #ifdef HasSharedMemory   if (window->shared_memory)     {        xerror_alert=False;r-       window->segment_info[2].readOnly=False;d3       XShmAttach(display,&window->segment_info[2]);n       XSync(display,False);r7       shmctl(window->segment_info[2].shmid,IPC_RMID,0);d3       ximage->data=window->segment_info[2].shmaddr;o       if (xerror_alert)s	         {s&           window->shared_memory=False;           xerror_alert=False;c	         }      }  #endif   if (!window->shared_memory) #     if (ximage->format == XYBitmap)        ximage->data=(char *)vD         malloc(ximage->bytes_per_line*ximage->height*ximage->depth);     elseJ       ximage->data=(char *) malloc(ximage->bytes_per_line*ximage->height);$   if (ximage->data == (char *) NULL)     {        /*&         Unable to allocate pixel data.       */%       if (transformed_image != image) (         DestroyImage(transformed_image);       XDestroyImage(ximage);7       XDefineCursor(display,window->id,window->cursor);        return(False);     } (   if (window->ximage != (XImage *) NULL)     {  #ifdef HasSharedMemory        if (window->shared_memory)	         { 7           XShmDetach(display,&window->segment_info[0]); (           XDestroyImage(window->ximage);1           shmdt(window->segment_info[0].shmaddr); 	         }  #endif!       if (!window->shared_memory)%&         XDestroyImage(window->ximage);     }% #ifdef HasSharedMemory2   window->segment_info[0]=window->segment_info[2]; #endif   window->ximage=ximage;   matte_image=(XImage *) NULL;*   if (transformed_image != (Image *) NULL)!     if (transformed_image->matte)t       { 
         /*           Create matte image.r
         */E         matte_image=XCreateImage(display,window->visual,1,XYBitmap,0, <           (char *) NULL,width,height,XBitmapPad(display),0);!         if (resource_info->debug)            { 4             (void) fprintf(stderr,"Matte Image:\n");P             (void) fprintf(stderr,"  width, height: %dx%d\n",matte_image->width,#               matte_image->height);l           }h+         if (matte_image != (XImage *) NULL)t           {l             /*.               Allocate matte image pixel data.             */J             matte_image->data=(char *) malloc(matte_image->bytes_per_line*6               matte_image->height*matte_image->depth);3             if (matte_image->data == (char *) NULL)f               {t+                 XDestroyImage(matte_image);i,                 matte_image=(XImage *) NULL;               }u           }i       } -   if (window->matte_image != (XImage *) NULL) '     XDestroyImage(window->matte_image); "   window->matte_image=matte_image;   window->stasis=False;X   /*5     Convert runlength-encoded pixels to X image data.    */)   if ((ximage->byte_order == LSBFirst) ||SO       ((ximage->format == XYBitmap) && (ximage->bitmap_bit_order == LSBFirst)))_E     XMakeImageLSBFirst(resource_info,window,transformed_image,ximage,        matte_image);k   elseE     XMakeImageMSBFirst(resource_info,window,transformed_image,ximage,m       matte_image);n$   matte_pixmap=window->matte_pixmap;,   if (window->matte_pixmap != (Pixmap) NULL).     XFreePixmap(display,window->matte_pixmap);%   window->matte_pixmap=(Pixmap) NULL; -   if (window->matte_image != (XImage *) NULL)      {v       /*         Create matte pixmap.       */L       window->matte_pixmap=XCreatePixmap(display,window->id,width,height,1);0       if (window->matte_pixmap != (Pixmap) NULL)	         {=           GC             graphics_context;X             XGCValues              context_values;*             /*-             Copy matte image to matte pixmap.l           */&           context_values.background=1;&           context_values.foreground=0;P           graphics_context=XCreateGC(display,window->matte_pixmap,GCBackground |*             GCForeground,&context_values);B           XPutImage(display,window->matte_pixmap,graphics_context,6             window->matte_image,0,0,0,0,width,height);,           XFreeGC(display,graphics_context);	         }      }  #ifdef HasShaper+   if (window->matte_pixmap != matte_pixmap) ;     XShapeCombineMask(display,window->id,ShapeBounding,0,0, %       window->matte_pixmap,ShapeSet);  #endif!   if (transformed_image != image) $     DestroyImage(transformed_image);   /*     Restore cursor.    */3   XDefineCursor(display,window->id,window->cursor);    return(True);m }t l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %|O %                                                                             % O %                                                                             %uO %   X M a k e I m a g e L S B F i r s t                                       %sO %                                                                             % O %                                                                             %pO %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XMakeImageLSBFirst initializes the pixel data of an X11 Image.H %  The X image pixels are copied in least-significant bit and byte firstL %  order.  The server's scanline pad is respected.  Rather than using one orL %  two general cases, many special cases are found here to help speed up the %  image conversion. %e3 %  The format of the XMakeImageLSBFirst routine is:  % H %      XMakeImageLSBFirst(resource_info,window,image,ximage,matte_image) %a+ %  A description of each parameter follows:h %mK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.l %o> %    o window: Specifies a pointer to a XWindowInfo structure. %iF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.( %sH %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. % M %    o matte_image: Specifies a pointer to a XImage structure;  returned froml %      XCreateImage. %V */B static void XMakeImageLSBFirst(const XResourceInfo *resource_info,L   const XWindowInfo *window,Image *image,XImage *ximage,XImage *matte_image) {m   register int     i,     j,     x;     register RunlengthPacket     *p;      register unsigned char     bit,	     byte,      *q;a     register unsigned long
     pixel;     register XColora     *gamma_map;      unsigned int     scanline_pad;      unsigned long(     *pixels;     XStandardColormapp     *map_info;  &   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;*   gamma_map=window->pixel_info->gamma_map;   p=image->pixels;#   q=(unsigned char *) ximage->data;    x=0;!   if (ximage->format == XYBitmap)n     {l       register unsigned shortn         polarity;p         unsigned charl         background,0         foreground;m         /*+         Convert image to big-endian bitmap.        */C       background=(Intensity(window->pixel_info->foreground_color) <(G         Intensity(window->pixel_info->background_color) ? 0x80 : 0x00);;C       foreground=(Intensity(window->pixel_info->background_color) < G         Intensity(window->pixel_info->foreground_color) ? 0x80 : 0x00);oM       polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);o       bit=0;
       byte=0;a(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {r           byte>>=1; #           if (p->index == polarity)I             byte|=foreground;A           else             byte|=background;            bit++;           if (bit == 8)R
             {                *q++=byte;               bit=0;               byte=0;;
             }*           x++;!           if (x == ximage->width)t
             {/               /*-                 Advance to the next scanline.                */               if (bit != 0)c#                 *q=byte >> (8-bit);a               q+=scanline_pad;               bit=0;               byte=0;R               x=0;
             }p	         }e         p++;       }      }p   else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)r       {c         case 2:=	         {H           register unsigned int              nibble;=             /*2             Convert to 2 bit color-mapped X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf;M2             for (j=0; j <= ((int) p->length); j++)
             {.               switch (nibble)u               {                  case 0:b                 { +                   *q=(unsigned char) pixel;                    nibble++;u                   break;                 }                  case 1:i                 {i3                   *q|=(unsigned char) (pixel << 2);o                   nibble++;)                   break;                 }                  case 2:!                 {i3                   *q|=(unsigned char) (pixel << 4);a                   nibble++;e                   break;                 }a                 case 3:S                 { 3                   *q|=(unsigned char) (pixel << 6);p                   q++;                   nibble=0;e                   break;                 }                }                x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }e             p++;           }s           break;	         }/         case 4:f	         {s           register unsigned into             nibble;s             /*2             Convert to 4 bit color-mapped X image.           */           nibble=0;o,           for (i=0; i < image->packets; i++)           {V)             pixel=pixels[p->index] & 0xf;(2             for (j=0; j <= ((int) p->length); j++)
             {c               switch (nibble)f               {                  case 0:l                 {u+                   *q=(unsigned char) pixel;i                   nibble++;                    break;                 }u                 case 1:f                 {s3                   *q|=(unsigned char) (pixel << 4);l                   q++;                   nibble=0;(                   break;                 }f               }e               x++;%               if (x == ximage->width)%                 {%                   x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }              p++;           }            break;	         }          case 6:          case 8: 	         {            /*2             Convert to 8 bit color-mapped X image.           */E           if (resource_info->color_recovery && resource_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             } ,           for (i=0; i < image->packets; i++)           { #             pixel=pixels[p->index]; 2             for (j=0; j <= ((int) p->length); j++)
             {%)               *q++=(unsigned char) pixel;                x++;%               if (x == ximage->width)s                 {a                   x=0;"                   q+=scanline_pad;                 } 
             }t             p++;           }            break;	         }h         default:	         {            register int             k;             register unsigned int              bytes_per_pixel;             unsigned charn+             channel[sizeof(unsigned long)];n             /*7             Convert to multi-byte color-mapped X image.a           */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;,           for (i=0; i < image->packets; i++)           {a#             pixel=pixels[p->index]; /             for (k=0; k < bytes_per_pixel; k++) 
             {)/               channel[k]=(unsigned char) pixel;w               pixel>>=8;
             }h2             for (j=0; j <= ((int) p->length); j++)
             {i1               for (k=0; k < bytes_per_pixel; k++),                  *q++=channel[k];               x++;%               if (x == ximage->width)L                 {                    x=0;"                   q+=scanline_pad;                 }h
             }&             p++;           }            break;	         }%       }%     else%       switch (ximage->bits_per_pixel)        {          case 2: 	         {            register unsigned int              nibble;              /*@             Convert to contiguous 2 bit continuous-tone X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           { A             pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);              pixel&=0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {                  case 0:                  { +                   *q=(unsigned char) pixel;%                   nibble++;%                   break;                 }                  case 1:s                 {e3                   *q|=(unsigned char) (pixel << 2);t                   nibble++;t                   break;                 }e                 case 2:i                 {e3                   *q|=(unsigned char) (pixel << 4);                    nibble++;p                   break;                 }f                 case 3:l                 {r3                   *q|=(unsigned char) (pixel << 6);e                   q++;                   nibble=0;p                   break;                 }o               }e               x++;%               if (x == ximage->width)t                 {                    x=0;                   nibble=0;g"                   q+=scanline_pad;                 }c
             }t             p++;           })           break;	         }          case 4: 	         {t           register unsigned inte             nibble;w             /*@             Convert to contiguous 4 bit continuous-tone X image.           */           nibble=0;e,           for (i=0; i < image->packets; i++)           {sA             pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);%             pixel&=0xf;%2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {                  case 0:                  { +                   *q=(unsigned char) pixel;                    nibble++;                    break;                 }                  case 1:                  { 3                   *q|=(unsigned char) (pixel << 4);                    q++;                   nibble=0;                    break;                 }                }                x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0;%"                   q+=scanline_pad;                 }%
             }t             p++;           }w           break;	         }i         case 6:h         case 8:p	         {u           /*@             Convert to contiguous 8 bit continuous-tone X image.           */E           if (resource_info->color_recovery && resource_info->dither)w
             {d)               XDitherImage(image,ximage);n               break;
             } ,           for (i=0; i < image->packets; i++)           {oA             pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);r2             for (j=0; j <= ((int) p->length); j++)
             {d)               *q++=(unsigned char) pixel;s               x++;%               if (x == ximage->width)t                 {f                   x=0;"                   q+=scanline_pad;                 }D
             },             p++;           }t           break;	         }          default:	         {tM           if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) &&rL               (map_info->green_max == 255) && (map_info->blue_max == 255) &&O               (map_info->red_mult == 65536) && (map_info->green_mult == 256) &&t)               (map_info->blue_mult == 1))p
             {o               /*:                 Convert to 32 bit continuous-tone X image.               */0               for (i=0; i < image->packets; i++)               {e6                 for (j=0; j <= ((int) p->length); j++)                 { :                   *q++=DownScale(gamma_map[p->blue].blue);<                   *q++=DownScale(gamma_map[p->green].green);8                   *q++=DownScale(gamma_map[p->red].red);                   *q++=0;                  }                  p++;               } 
             }            elseO             if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) && N                 (map_info->green_max == 255) && (map_info->blue_max == 255) &&M                 (map_info->red_mult == 1) && (map_info->green_mult == 256) && /                 (map_info->blue_mult == 65536))                {                  /*<                   Convert to 32 bit continuous-tone X image.                 */2                 for (i=0; i < image->packets; i++)                 {%8                   for (j=0; j <= ((int) p->length); j++)                   {C:                     *q++=DownScale(gamma_map[p->red].red);>                     *q++=DownScale(gamma_map[p->green].green);<                     *q++=DownScale(gamma_map[p->blue].blue);                     *q++=0;                    }                    p++;                 }y               }n             else               {r                 register int                   k;  %                 register unsigned ints"                   bytes_per_pixel;                   unsigned chary1                   channel[sizeof(unsigned long)];                    /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;2                 for (i=0; i < image->packets; i++)                 {oG                   pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);d5                   for (k=0; k < bytes_per_pixel; k++)                    {y5                     channel[k]=(unsigned char) pixel;%                     pixel>>=8;                   } 8                   for (j=0; j <= ((int) p->length); j++)                   { 7                     for (k=0; k < bytes_per_pixel; k++) &                       *q++=channel[k];                     x++;+                     if (x == ximage->width)                        {                          x=0;(                         q+=scanline_pad;                       }                    }                    p++;                 }                }            break;	         }        } %   if (matte_image != (XImage *) NULL)      {        /*         Initialize matte image.%       *//       scanline_pad=matte_image->bytes_per_line- @         ((matte_image->width*matte_image->bits_per_pixel) >> 3);       p=image->pixels;,       q=(unsigned char *) matte_image->data;       bit=0;
       byte=0;a(       for (i=0; i < image->packets; i++)       {m.         for (j=0; j <= ((int) p->length); j++)	         {t           byte>>=1; &           if (p->index == Transparent)             byte|=0x01;e           bit++;           if (bit == 8)b
             {r               *q++=byte;               bit=0;               byte=0;g
             }            x++;&           if (x == matte_image->width)
             {                /*-                 Advance to the next scanline.i               */               if (bit != 0) #                 *q=byte >> (8-bit);                q+=scanline_pad;               bit=0;               byte=0;l               x=0;
             }=	         }d         p++;       }v     }l }( X /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %$O %                                                                             %%O %                                                                             % O %   X M a k e I m a g e M S B F i r s t                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XMakeImageMSBFirst initializes the pixel data of an X11 Image.N %  The X image pixels are copied in most-significant bit and byte first order.M %  The server's scanline pad is also resprected. Rather than using one or twooN %  general cases, many special cases are found here to help speed up the image %  conversion. %k3 %  The format of the XMakeImageMSBFirst routine is:C %rH %      XMakeImageMSBFirst(resource_info,window,image,ximage,matte_image) %s+ %  A description of each parameter follows:  %dK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.p %.> %    o window: Specifies a pointer to a XWindowInfo structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.r % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %nM %    o matte_image: Specifies a pointer to a XImage structure;  returned frome %      XCreateImage. %m %  */B static void XMakeImageMSBFirst(const XResourceInfo *resource_info,L   const XWindowInfo *window,Image *image,XImage *ximage,XImage *matte_image) {O   register int     i,     j,     x;     register RunlengthPacket     *p;o     register unsigned char     bit,	     byte,y     *q;t     register unsigned long
     pixel;     register XColorn     *gamma_map;=     unsigned int     scanline_pad;g     unsigned long=     *pixels;     XStandardColormapp     *map_info;  &   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;*   gamma_map=window->pixel_info->gamma_map;   p=image->pixels;#   q=(unsigned char *) ximage->data;    x=0;!   if (ximage->format == XYBitmap)      {        register unsigned short          polarity;          unsigned char          background,          foreground;          /*+         Convert image to big-endian bitmap.        */C       background=(Intensity(window->pixel_info->foreground_color) < G         Intensity(window->pixel_info->background_color) ? 0x01 : 0x00); C       foreground=(Intensity(window->pixel_info->background_color) < G         Intensity(window->pixel_info->foreground_color) ? 0x01 : 0x00); M       polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);%       bit=0;
       byte=0;m(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1;d#           if (p->index == polarity)g             byte|=foreground;o           else             byte|=background;            bit++;           if (bit == 8)u
             {                *q++=byte;               bit=0;               byte=0;1
             }s           x++;!           if (x == ximage->width) 
             {t               /*-                 Advance to the next scanline.t               */               if (bit != 0) #                 *q=byte << (8-bit);o               q+=scanline_pad;               bit=0;               byte=0;p               x=0;
             } 	         }f         p++;       }W     }*   else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)i       {x         case 2:n	         {g           register unsigned inte             nibble;              /*2             Convert to 2 bit color-mapped X image.           */           nibble=0;n,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {*               switch (nibble)a               {                  case 0:t                 { 2                   *q=(unsigned char) (pixel << 6);                   nibble++;o                   break;                 }a                 case 1:u                 {x3                   *q|=(unsigned char) (pixel << 4);                    nibble++;"                   break;                 }o                 case 2:                  {i3                   *q|=(unsigned char) (pixel << 2);r                   nibble++;:                   break;                 }y                 case 3:a                 {i,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;g                   break;                 }                }s               x++;%               if (x == ximage->width)>                 {                    x=0;                   nibble=0;e"                   q+=scanline_pad;                 } 
             }e             p++;           }p           break;	         }          case 4:a	         {            register unsigned into             nibble;n             /*2             Convert to 4 bit color-mapped X image.           */           nibble=0;m,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)(               {                  case 0:y                 { 2                   *q=(unsigned char) (pixel << 4);                   nibble++;e                   break;                 }r                 case 1:                  {",                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;m                   break;                 };               }m               x++;%               if (x == ximage->width)p                 {n                   x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }l             p++;           }            break;	         }1         case 6:          case 8:t	         {m           /*2             Convert to 8 bit color-mapped X image.           */E           if (resource_info->color_recovery && resource_info->dither)e
             { )               XDitherImage(image,ximage);)               break;
             }),           for (i=0; i < image->packets; i++)           {)#             pixel=pixels[p->index];)2             for (j=0; j <= ((int) p->length); j++)
             { )               *q++=(unsigned char) pixel;                x++;%               if (x == ximage->width)                  {g                   x=0;"                   q+=scanline_pad;                 }\
             }c             p++;           }v           break;	         }:         default:	         {_           register int             k;             register unsigned inti             bytes_per_pixel;             unsigned charr+             channel[sizeof(unsigned long)];%             /*2             Convert to 8 bit color-mapped X image.           */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;,           for (i=0; i < image->packets; i++)           { #             pixel=pixels[p->index]; 2             for (k=bytes_per_pixel-1; k >= 0; k--)
             { /               channel[k]=(unsigned char) pixel;v               pixel>>=8;
             } 2             for (j=0; j <= ((int) p->length); j++)
             { 1               for (k=0; k < bytes_per_pixel; k++)i                  *q++=channel[k];               x++;%               if (x == ximage->width)i                 {a                   x=0;"                   q+=scanline_pad;                 }g
             })             p++;           }g           break;	         })       }(     else%       switch (ximage->bits_per_pixel)        {s         case 2:r	         {c           register unsigned intk             nibble;l             /*5             Convert to 4 bit continuous-tone X image.            */           nibble=0; ,           for (i=0; i < image->packets; i++)           { A             pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);              pixel&=0xf;z2             for (j=0; j <= ((int) p->length); j++)
             {d               switch (nibble))               {n                 case 0:f                 {h2                   *q=(unsigned char) (pixel << 6);                   nibble++;;                   break;                 }v                 case 1:l                 {e3                   *q|=(unsigned char) (pixel << 4);t                   nibble++;g                   break;                 }                  case 2:                  {=3                   *q|=(unsigned char) (pixel << 2);n                   nibble++;x                   break;                 }o                 case 3:m                 { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;)                   break;                 }e               }                x++;%               if (x == ximage->width)*                 {m                   x=0;                   nibble=0; "                   q+=scanline_pad;                 }-
             }              p++;           }U           break;	         }o         case 4:i	         {*           register unsigned int              nibble;t             /*5             Convert to 4 bit continuous-tone X image.            */           nibble=0;e,           for (i=0; i < image->packets; i++)           { A             pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth);o             pixel&=0xf;r2             for (j=0; j <= ((int) p->length); j++)
             {i               switch (nibble))               {                  case 0:                  {T2                   *q=(unsigned char) (pixel << 4);                   nibble++;                    break;                 }                  case 1:                  {f,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;e                   break;                 }e               }s               x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0;i"                   q+=scanline_pad;                 }i
             }U             p++;           }            break;	         }h         case 6:          case 8:h	         {;           /*5             Convert to 8 bit continuous-tone X image.%           */E           if (resource_info->color_recovery && resource_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             } ,           for (i=0; i < image->packets; i++)           { A             pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth); 2             for (j=0; j <= ((int) p->length); j++)
             { )               *q++=(unsigned char) pixel;                x++;%               if (x == ximage->width)                  {                    x=0;"                   q+=scanline_pad;                 }%
             }              p++;           }t           break;	         }e         default:	         {cM           if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) &&nL               (map_info->green_max == 255) && (map_info->blue_max == 255) &&O               (map_info->red_mult == 65536) && (map_info->green_mult == 256) &&X)               (map_info->blue_mult == 1))p
             {r               /*:                 Convert to 32 bit continuous-tone X image.               */0               for (i=0; i < image->packets; i++)               {e6                 for (j=0; j <= ((int) p->length); j++)                 {D                   *q++=0;a8                   *q++=DownScale(gamma_map[p->red].red);<                   *q++=DownScale(gamma_map[p->green].green);:                   *q++=DownScale(gamma_map[p->blue].blue);                 }                  p++;               }e
             }            elseO             if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) && N                 (map_info->green_max == 255) && (map_info->blue_max == 255) &&M                 (map_info->red_mult == 1) && (map_info->green_mult == 256) &&-/                 (map_info->blue_mult == 65536))                {1                 /*<                   Convert to 32 bit continuous-tone X image.                 */2                 for (i=0; i < image->packets; i++)                 {e8                   for (j=0; j <= ((int) p->length); j++)                   {p                     *q++=0;;<                     *q++=DownScale(gamma_map[p->blue].blue);>                     *q++=DownScale(gamma_map[p->green].green);:                     *q++=DownScale(gamma_map[p->red].red);                   }                    p++;                 }e               }g             else               {n                 register int                   k;  %                 register unsigned int "                   bytes_per_pixel;                   unsigned char 1                   channel[sizeof(unsigned long)];                    /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;2                 for (i=0; i < image->packets; i++)                 { G                   pixel=XGammaPixel(map_info,gamma_map,p,QuantumDepth); 8                   for (k=bytes_per_pixel-1; k >= 0; k--)                   {u5                     channel[k]=(unsigned char) pixel;                      pixel>>=8;                   } 8                   for (j=0; j <= ((int) p->length); j++)                   { 7                     for (k=0; k < bytes_per_pixel; k++) &                       *q++=channel[k];                     x++;+                     if (x == ximage->width)a                       {=                         x=0;(                         q+=scanline_pad;                       }]                   }                    p++;                 }                }            break;	         }[       }1%   if (matte_image != (XImage *) NULL)a     {        /*         Initialize matte image.        *//       scanline_pad=matte_image->bytes_per_line-u@         ((matte_image->width*matte_image->bits_per_pixel) >> 3);       p=image->pixels;,       q=(unsigned char *) matte_image->data;       bit=0;
       byte=0;p(       for (i=0; i < image->packets; i++)       {r.         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1;=&           if (p->index == Transparent)             byte|=0x01;n           bit++;           if (bit == 8)]
             {=               *q++=byte;               bit=0;               byte=0;>
             }            x++;&           if (x == matte_image->width)
             {)               /*-                 Advance to the next scanline.;               */               if (bit != 0)f#                 *q=byte << (8-bit);                q+=scanline_pad;               bit=0;               byte=0;6               x=0;
             } 	         }]         p++;       }r     }e }p [ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %   X M a k e M a g n i f y I m a g e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%O %  Function XMakeMagnifyImage magnifies a region of an X image and displays it.a %d2 %  The format of the XMakeMagnifyImage routine is: %r) %      XMakeMagnifyImage(display,windows)I %e+ %  A description of each parameter follows:A %sE %    o display: Specifies a connection to an X server;  returned fromI %      XOpenDisplay. %i< %    o windows: Specifies a pointer to a XWindows structure. %  %t */: void XMakeMagnifyImage(Display *display,XWindows *windows) { 0 #define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))     register int     x,     y;     register unsigned char     *p,l     *q;c     register unsigned into     j,     k,     l;  
   static charc     text[MaxTextLength];     static unsigned intI     previous_magnify=0;      static XWindowInfo     magnify_window;d     unsigned int     height,y     i,     magnify,     scanline_pad,D
     width;     XColor
     color;     XImage     *ximage;     /*     Check boundry conditions.t   */   magnify=1;+   for (i=1; i < windows->magnify.data; i++)i     magnify<<=1;I   while ((magnify*windows->image.ximage->width) < windows->magnify.width)      magnify<<=1;K   while ((magnify*windows->image.ximage->height) < windows->magnify.height)w     magnify<<=1;*   while (magnify > windows->magnify.width)     magnify>>=1;+   while (magnify > windows->magnify.height)f     magnify>>=1;"   if (magnify != previous_magnify)     {t       unsigned int         status;n         XTextProperty,         window_name;         /*8         New magnify factor:  update magnify window name.       */
       i=0;!       while ((1 << i) <= magnify)h         i++;<       (void) sprintf(windows->magnify.name,"Magnify %uX",i);N       status=XStringListToTextProperty(&windows->magnify.name,1,&window_name);       if (status != 0)	         {)?           XSetWMName(display,windows->magnify.id,&window_name);rC           XSetWMIconName(display,windows->magnify.id,&window_name);B,           XFree((void *) window_name.value);	         }e     }    previous_magnify=magnify;)   ximage=windows->image.ximage;l'   width=windows->magnify.ximage->width;l)   height=windows->magnify.ximage->height;w.   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0)     x=0;   else,     if (x > (ximage->width-(width/magnify)))$       x=ximage->width-width/magnify;/   y=windows->magnify.y-((height/magnify) >> 1);t   if (y < 0)     y=0;   else.     if (y > (ximage->height-(height/magnify)))&       y=ximage->height-height/magnify;4   q=(unsigned char *) windows->magnify.ximage->data;7   scanline_pad=windows->magnify.ximage->bytes_per_line-c;     ((width*windows->magnify.ximage->bits_per_pixel) >> 3);M!   if (ximage->bits_per_pixel < 8)      {e       register unsigned char         background,r
         byte,c         foreground,e         p_bit,         q_bit;         register unsigned into         plane;         XPixelInfo         *pixel_info;  -       pixel_info=windows->magnify.pixel_info; '       switch (ximage->bitmap_bit_order)o       {          case LSBFirst:	         {r           /*)             Magnify little-endian bitmap.i           */           background=0x00;           foreground=0x80;)           if (ximage->format == XYBitmap) 
             {eC               background=(Intensity(pixel_info->foreground_color) <.G                 Intensity(pixel_info->background_color) ? 0x80 : 0x00);rC               foreground=(Intensity(pixel_info->background_color) <pG                 Intensity(pixel_info->foreground_color) ? 0x80 : 0x00); -               if (windows->magnify.depth > 1)c,                 Swap(background,foreground);
             }i+           for (i=0; i < height; i+=magnify)4           {a             /*+               Propogate pixel magnify rows.l             */'             for (j=0; j < magnify; j++)-
             {.H               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0; .               for (k=0; k < width; k+=magnify)               {n                 /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)r                 {e                   /*-                     Propogate each bit plane.                    */H                   for (plane=0; plane < ximage->bits_per_pixel; plane++)                   {                      byte>>=1;P5                     if (*p & (0x01 << (p_bit+plane)))a'                       byte|=foreground;t                     else'                       byte|=background;i                     q_bit++;#                     if (q_bit == 8);                       {i"                         *q++=byte;                          q_bit=0;                         byte=0;,                       }f                   }a                 }e.                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)g                   {e                     p++;                     p_bit=0;                   }                  if (q_bit != 0)o'                   *q=byte >> (8-q_bit);o                  q+=scanline_pad;               }i
             }r             y++;           }>           break;	         }          case MSBFirst:         default:	         {t           /*&             Magnify big-endian bitmap.           */           background=0x00;           foreground=0x01;)           if (ximage->format == XYBitmap)i
             { C               background=(Intensity(pixel_info->foreground_color) <tG                 Intensity(pixel_info->background_color) ? 0x01 : 0x00);;C               foreground=(Intensity(pixel_info->background_color) <;G                 Intensity(pixel_info->foreground_color) ? 0x01 : 0x00);e-               if (windows->magnify.depth > 1)+,                 Swap(background,foreground);
             } +           for (i=0; i < height; i+=magnify)m           {              /*+               Propogate pixel magnify rows.              */'             for (j=0; j < magnify; j++) 
             {bH               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0; .               for (k=0; k < width; k+=magnify)               {/                 /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)u                 {i                   /*-                     Propogate each bit plane.u                   */H                   for (plane=0; plane < ximage->bits_per_pixel; plane++)                   {                      byte<<=1;r5                     if (*p & (0x80 >> (p_bit+plane)))x'                       byte|=foreground;w                     else'                       byte|=background;h                     q_bit++;#                     if (q_bit == 8)l                       { "                         *q++=byte;                          q_bit=0;                         byte=0;a                       }                    }s                 } .                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)                    {                      p++;                     p_bit=0;                   }g                 if (q_bit != 0)o'                   *q=byte << (8-q_bit);s                  q+=scanline_pad;               })
             }n             y++;           }a           break;	         }r       }a     }    else#     switch (ximage->bits_per_pixel)      {o
       case 6: 
       case 8:o       {d
         /*            Magnify 8 bit X image.
         */)         for (i=0; i < height; i+=magnify).	         {o           /*)             Propogate pixel magnify rows.            */%           for (j=0; j < magnify; j++)a           { F             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {s               /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)                  *q++=(*p);               p++;
             }-             q+=scanline_pad;           }            y++;	         }          break;       }        default:       {          register unsigned intg           bytes_per_pixel,           m;  
         /*%           Magnify multi-byte X image. 
         */4         bytes_per_pixel=ximage->bits_per_pixel >> 3;)         for (i=0; i < height; i+=magnify) 	         {r           /*)             Propogate pixel magnify rows.p           */%           for (j=0; j < magnify; j++)(           {eF             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {p               /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)%3                 for (m=0; m < bytes_per_pixel; m++)%                    *q++=(*(p+m));!               p+=bytes_per_pixel; 
             }              q+=scanline_pad;           }            y++;	         }          break;       }      }    /*#     Copy X image to magnify pixmap.    */.   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0).     x=(width >> 1)-windows->magnify.x*magnify;   else,     if (x > (ximage->width-(width/magnify)))@       x=(ximage->width-windows->magnify.x)*magnify-(width >> 1);     else
       x=0;/   y=windows->magnify.y-((height/magnify) >> 1);    if (y < 0)/     y=(height >> 1)-windows->magnify.y*magnify;%   else.     if (y > (ximage->height-(height/magnify)))B       y=(ximage->height-windows->magnify.y)*magnify-(height >> 1);     else
       y=0;   if ((x != 0) || (y != 0))b3     XFillRectangle(display,windows->magnify.pixmap, :       windows->magnify.annotate_context,0,0,width,height);N   XPutImage(display,windows->magnify.pixmap,windows->magnify.annotate_context,6     windows->magnify.ximage,0,0,x,y,width-x,height-y);4   if ((magnify > 1) && ((magnify <= (width >> 1)) &&"       (magnify <= (height >> 1))))     {r       RectangleInfon         highlight_info;r         /*         Highlight center pixel.        */3       highlight_info.x=windows->magnify.width >> 1; 4       highlight_info.y=windows->magnify.height >> 1;#       highlight_info.width=magnify;d$       highlight_info.height=magnify;5       XDrawRectangle(display,windows->magnify.pixmap, M         windows->magnify.highlight_context,highlight_info.x,highlight_info.y, 8         highlight_info.width-1,highlight_info.height-1);       if (magnify > 2)7         XDrawRectangle(display,windows->magnify.pixmap,s?           windows->magnify.annotate_context,highlight_info.x+1,uM           highlight_info.y+1,highlight_info.width-3,highlight_info.height-3);%     }%   /*     Show center pixel color.   */   color.pixel=K     XGetPixel(windows->image.ximage,windows->magnify.x,windows->magnify.y); @   XQueryColor(display,windows->image.map_info->colormap,&color);"   if (windows->magnify.depth > 12)2     (void) sprintf(text," %+d%+d  (%3u,%3u,%3u) ",B       windows->magnify.x,windows->magnify.y,XDownScale(color.red),6       XDownScale(color.green),XDownScale(color.blue));   else6     (void) sprintf(text," %+d%+d  (%3u,%3u,%3u) %lu ",B       windows->magnify.x,windows->magnify.y,XDownScale(color.red),B       XDownScale(color.green),XDownScale(color.blue),color.pixel);P   height=windows->magnify.font_info->ascent+windows->magnify.font_info->descent;6   x=windows->magnify.font_info->max_bounds.width >> 1;5   y=windows->magnify.font_info->ascent+(height >> 2);o3   XDrawImageString(display,windows->magnify.pixmap,,=     windows->magnify.annotate_context,x,y,text,strlen(text));n>   (void) sprintf(text," #%02x%02x%02x ",XDownScale(color.red),4     XDownScale(color.green),XDownScale(color.blue));   y+=height;3   XDrawImageString(display,windows->magnify.pixmap,o=     windows->magnify.annotate_context,x,y,text,strlen(text));r   /*     Refresh magnify window.    */"   magnify_window=windows->magnify;   magnify_window.x=0;l   magnify_window.y=0;f:   XRefreshWindow(display,&magnify_window,(XEvent *) NULL); }p t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %eO %                                                                             %oO %                                                                             %lO %   X M a k e P i x m a p                                                     %fO %                                                                             %fO %                                                                             % O %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Function XMakePixmap creates an X11 pixmap. % , %  The format of the XMakePixmap routine is: %o7 %      status=XMakePixmap(display,resource_info,window)r %i+ %  A description of each parameter follows:( %dC %    o status: Function XMakePixmap returns True if the X pixmap is,N %      successfully created.  False is returned is there is a memory shortage. %GK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %_> %    o window: Specifies a pointer to a XWindowInfo structure. %  %  */M unsigned int XMakePixmap(Display *display,const XResourceInfo *resource_info,r   XWindowInfo *window) {i   unsigned int     height, 
     width;  (   if (window->ximage == (XImage *) NULL)     return(False);   /*     Display busy cursor.   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   /*     Create pixmap.   */&   if (window->pixmap != (Pixmap) NULL)     {)*       XFreePixmap(display,window->pixmap);#       window->pixmap=(Pixmap) NULL;/ #ifdef HasSharedMemory        if (window->shared_memory)/         if (window->segment_info[1].shmid >= 0)s           {C9             XShmDetach(display,&window->segment_info[1]);%!             XSync(display,False);%3             shmdt(window->segment_info[1].shmaddr); /             window->segment_info[1].shmid=(-1);            }  #endif     }    width=window->ximage->width;    height=window->ximage->height; #ifdef HasSharedMemory   if (window->shared_memory)     { =       window->segment_info[3].shmid=(int) shmget(IPC_PRIVATE, @         window->ximage->bytes_per_line*height,IPC_CREAT | 0777);-       if (window->segment_info[3].shmid >= 0) 	         {            xerror_alert=False; 2           window->segment_info[3].shmaddr=(char *)5             shmat(window->segment_info[3].shmid,0,0); 1           window->segment_info[3].readOnly=False;%7           XShmAttach(display,&window->segment_info[3]);a=           window->pixmap=XShmCreatePixmap(display,window->id,XE             window->segment_info[3].shmaddr,&window->segment_info[3],l(             width,height,window->depth);.           if (window->pixmap != (Pixmap) NULL)<             window->segment_info[1]=window->segment_info[3];           else
             { 5               shmdt(window->segment_info[3].shmaddr);i;               XShmDetach(display,&window->segment_info[3]); 
             }f           XSync(display,False); ;           shmctl(window->segment_info[3].shmid,IPC_RMID,0);C           if (xerror_alert)f
             {p+               window->pixmap=(Pixmap) NULL;/!               xerror_alert=False;y
             } 	         }      }_ #endif&   if (window->pixmap == (Pixmap) NULL)P     window->pixmap=XCreatePixmap(display,window->id,width,height,window->depth);&   if (window->pixmap == (Pixmap) NULL)     {_       /*"         Unable to allocate pixmap.       */7       XDefineCursor(display,window->id,window->cursor);;       return(False);     }n   /*     Copy X image to pixmap.    */ #ifdef HasSharedMemory   if (window->shared_memory)P     XShmPutImage(display,window->pixmap,window->annotate_context,window->ximage,!       0,0,0,0,width,height,True);t #endif   if (!window->shared_memory)oM     XPutImage(display,window->pixmap,window->annotate_context,window->ximage,        0,0,0,0,width,height);   if (resource_info->debug)r     {r)       (void) fprintf(stderr,"Pixmap:\n");nE       (void) fprintf(stderr,"  width, height: %ux%u\n",width,height);e     }*   /*     Restore cursor.r   */3   XDefineCursor(display,window->id,window->cursor);d   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %   X M a k e S t a n d a r d C o l o r m a p                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% % C %  Function XMakeStandardColormap creates an X11 Standard Colormap.t %.6 %  The format of the XMakeStandardColormap routine is: % E %      XMakeStandardColormap(display,visual_info,resource_info,image,m %        map_info,pixel_info)t %_+ %  A description of each parameter follows:s %cD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %iG %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure;0$ %      returned from XGetVisualInfo. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.f %dF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %NL %    o map_info: If a Standard Colormap type is specified, this structure is8 %      initialized with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.% %% %% */  8 static int IntensityCompare(const void *x,const void *y) {    DiversityPacket 
     *color_1, 
     *color_2;       color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }   9 static int PopularityCompare(const void *x,const void *y)  {    DiversityPacket 
     *color_1, 
     *color_2;       color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;4   return((int) color_2->count-(int) color_1->count); }   E void XMakeStandardColormap(Display *display,XVisualInfo *visual_info, H   XResourceInfo *resource_info,Image *image,XStandardColormap *map_info,   XPixelInfo *pixel_info)  {n
   Colormap
     colormap;e     inta     status;      register int     i;     register XColoro     *gamma_map;:     unsigned int     number_colors,     retain_colors;     unsigned short     gray_value;r     XColor
     color,     *colors,     *p;I  /   if (resource_info->map_type != (char *) NULL)o     {f       /*=         Standard Colormap is already defined (i.e. xstdcmap).V       */E       XGetPixelInfo(display,visual_info,map_info,resource_info,image,t         pixel_info);)       number_colors=map_info->base_pixel+iM         (map_info->red_max+1)*(map_info->green_max+1)*(map_info->blue_max+1);tJ       if ((map_info->red_max*map_info->green_max*map_info->blue_max) != 0)F         if (resource_info->dither && !resource_info->color_recovery &&?             (number_colors < MaxColormapSize) && !image->matte)a           {0             Imagea               *map_image;   $             register RunlengthPacket               *p;u               /*<               Improve image appearance with error diffusion.             */8             map_image=AllocateImage((ImageInfo *) NULL);,             if (map_image == (Image *) NULL)I               Error("Unable to dither image","Memory allocation failed");o-             map_image->columns=number_colors;l             map_image->rows=1;B             map_image->packets=map_image->columns*map_image->rows;1             map_image->pixels=(RunlengthPacket *)nA               malloc(map_image->packets*sizeof(RunlengthPacket)); >             if (map_image->pixels == (RunlengthPacket *) NULL)I               Error("Unable to dither image","Memory allocation failed");              /*(               Initialize colormap image.             */              p=map_image->pixels;-             for (i=0; i < number_colors; i++) 
             {                p->red=0; )               if (map_info->red_max != 0)                   p->red=(Quantum)F                   (((i/map_info->red_mult)*MaxRGB)/map_info->red_max);               p->green=0; +               if (map_info->green_max != 0) @                 p->green=(Quantum) ((((i/map_info->green_mult) %H                   (map_info->green_max+1))*MaxRGB)/map_info->green_max);               p->blue=0;*               if (map_info->blue_max != 0)!                 p->blue=(Quantum).K                   (((i % map_info->green_mult)*MaxRGB)/map_info->blue_max);e               p->index=0;A               p->length=0;               p++;
             }f+             MapImage(image,map_image,True);tK             XGetPixelInfo(display,visual_info,map_info,resource_info,image,t               pixel_info);%             image->class=DirectClass;_$             DestroyImage(map_image);           }C       if (resource_info->debug)n	         {D8           (void) fprintf(stderr,"Standard Colormap:\n");M           (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap);%H           (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",F             map_info->red_max,map_info->green_max,map_info->blue_max);I           (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n", I             map_info->red_mult,map_info->green_mult,map_info->blue_mult); 	         } 
       return;      } O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor)) (     if ((image->class == DirectClass) ||5         (image->colors > visual_info->colormap_size))        { 
         /*9           Image has more colors than the visual supports. 
         */         if (image->matte)%           {%$             register RunlengthPacket               *p;                /*%               Fake matte information.r             */B             Warning("This visual does not support an image matte",4               XVisualClassName(visual_info->class));             p=image->pixels;.             for (i=0; i < image->packets; i++)
             {e*               if (p->index == Transparent)                 {aF                   p->red=XDownScale(pixel_info->background_color.red);J                   p->green=XDownScale(pixel_info->background_color.green);H                   p->blue=XDownScale(pixel_info->background_color.blue);                 }.               p++;
             }e           }oF         QuantizeImage(image,(unsigned int) visual_info->colormap_size,:           resource_info->tree_depth,resource_info->dither,%           resource_info->colorspace);r?         image->class=DirectClass;  /* promote to DirectClass */l       }a   /**     Free previous and create new colormap.   */A   XFreeStandardColormap(display,visual_info,map_info,pixel_info);e9   colormap=XDefaultColormap(display,visual_info->screen);sI   if (visual_info->visual != XDefaultVisual(display,visual_info->screen))oN     colormap=XCreateColormap(display,XRootWindow(display,visual_info->screen),=       visual_info->visual,visual_info->class == DirectColor ?o       AllocAll : AllocNone);"   if (colormap == (Colormap) NULL)5     Error("Unable to create colormap",(char *) NULL);;   /*1     Initialize the map and pixel info structures.>   */-   XGetMapInfo(visual_info,colormap,map_info);mM   XGetPixelInfo(display,visual_info,map_info,resource_info,image,pixel_info);="   gamma_map=pixel_info->gamma_map;   /*B     Allocating colors in server colormap is based on visual class.   */   switch (visual_info->class)n   {i     case StaticGray:     case StaticColor:)     {(       /*F         Define Standard Colormap for StaticGray or StaticColor visual.       */"       number_colors=image->colors;J       colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       p=colors;X+       color.flags=DoRed | DoGreen | DoBlue;r,       if (visual_info->class == StaticColor))         for (i=0; i < image->colors; i++)l	         {nD           color.red=XUpScale(gamma_map[image->colormap[i].red].red);J           color.green=XUpScale(gamma_map[image->colormap[i].green].green);G           color.blue=XUpScale(gamma_map[image->colormap[i].blue].blue); 6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             { >               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color);i
             }_,           pixel_info->pixels[i]=color.pixel;           *p++=color;r	         }c
       else)         for (i=0; i < image->colors; i++)l	         { I           gray_value=Intensity(gamma_map[Intensity(image->colormap[i])]);o)           color.red=XUpScale(gray_value);D+           color.green=XUpScale(gray_value); *           color.blue=XUpScale(gray_value);6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             {,>               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color);o
             } ,           pixel_info->pixels[i]=color.pixel;           *p++=color;n	         }c       break;     }n     case GrayScale:s     case PseudoColor:u     {*       unsigned int         colormap_type;         /*E         Define Standard Colormap for GrayScale or PseudoColor visual.a       */"       number_colors=image->colors;J       colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       /*#         Preallocate our GUI colors.n       */I       (void) XAllocColor(display,colormap,&pixel_info->foreground_color); I       (void) XAllocColor(display,colormap,&pixel_info->background_color);nE       (void) XAllocColor(display,colormap,&pixel_info->border_color); D       (void) XAllocColor(display,colormap,&pixel_info->matte_color);H       (void) XAllocColor(display,colormap,&pixel_info->highlight_color);E       (void) XAllocColor(display,colormap,&pixel_info->shadow_color);rD       (void) XAllocColor(display,colormap,&pixel_info->depth_color);E       (void) XAllocColor(display,colormap,&pixel_info->trough_color); '       for (i=0; i < MaxNumberPens; i++)MH         (void) XAllocColor(display,colormap,&pixel_info->pen_colors[i]);       /*D         Determine if image colors will "fit" into X server colormap.       */,       colormap_type=resource_info->colormap;N       status=XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,*         pixel_info->pixels,image->colors);       if (status != 0)&         colormap_type=PrivateColormap;*       if (colormap_type == SharedColormap)	         {o           DiversityPackete             *diversity;m  "           register RunlengthPacket             *q;>             unsigned short             index;             /*P             Define Standard colormap for shared GrayScale or PseudoColor visual:           */'           diversity=(DiversityPacket *).:             malloc(image->colors*sizeof(DiversityPacket));4           if (diversity == (DiversityPacket *) NULL)J             Error("Unable to create colormap","Memory allocation failed");+           for (i=0; i < image->colors; i++)            {-4             diversity[i].red=image->colormap[i].red;8             diversity[i].green=image->colormap[i].green;6             diversity[i].blue=image->colormap[i].blue;2             diversity[i].index=(unsigned short) i;!             diversity[i].count=0;r           }d           q=image->pixels;,           for (i=0; i < image->packets; i++)           {c5             diversity[q->index].count+=(q->length+1);r             q++;           }            /*0             Sort colors by decreasing intensity.           */I           qsort((void *) diversity,image->colors,sizeof(DiversityPacket),dD             (int (*)(const void *, const void *)) IntensityCompare);D           for (i=0; i < image->colors; i+=Max(image->colors >> 4,2))J             diversity[i].count<<=4;  /* increase this colors popularity *//           diversity[image->colors-1].count<<=4;cI           qsort((void *) diversity,image->colors,sizeof(DiversityPacket),rE             (int (*)(const void *, const void *)) PopularityCompare);            /*             Allocate colors.           */           p=colors;i/           color.flags=DoRed | DoGreen | DoBlue;x0           if (visual_info->class == PseudoColor)-             for (i=0; i < image->colors; i++) 
             { '               index=diversity[i].index;rL               color.red=XUpScale(gamma_map[image->colormap[index].red].red);               color.green=H                 XUpScale(gamma_map[image->colormap[index].green].green);O               color.blue=XUpScale(gamma_map[image->colormap[index].blue].blue);n:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;4               pixel_info->pixels[index]=color.pixel;               *p++=color;a
             }            else-             for (i=0; i < image->colors; i++)d
             {_'               index=diversity[i].index;n               gray_value= H                 Intensity(gamma_map[Intensity(image->colormap[index])]);-               color.red=XUpScale(gray_value); /               color.green=XUpScale(gray_value); .               color.blue=XUpScale(gray_value);:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;4               pixel_info->pixels[index]=color.pixel;               *p++=color;e
             }             if (i < image->colors)
             {,               register int                 j;                 XColor                 *server_colors;                  /*'                 Read X server colormap.e               */&               server_colors=(XColor *)B                 malloc(visual_info->colormap_size*sizeof(XColor));3               if (server_colors == (XColor *) NULL);N                 Error("Unable to create colormap","Memory allocation failed");<               for (j=0; j < visual_info->colormap_size; j++)9                 server_colors[j].pixel=(unsigned long) j;r:               XQueryColors(display,colormap,server_colors,;                 (int) Min(visual_info->colormap_size,256));[               /*?                 Select remaining colors from X server colormap.*               */4               if (visual_info->class == PseudoColor).                 for (; i < image->colors; i++)                 {a+                   index=diversity[i].index;eP                   color.red=XUpScale(gamma_map[image->colormap[index].red].red);                   color.green=L                     XUpScale(gamma_map[image->colormap[index].green].green);                   color.blue=mJ                     XUpScale(gamma_map[image->colormap[index].blue].blue);<                   XBestPixel(display,colormap,server_colors,F                     (unsigned int) visual_info->colormap_size,&color);8                   pixel_info->pixels[index]=color.pixel;                   *p++=color;%                 }%               else.                 for (; i < image->colors; i++)                 { +                   index=diversity[i].index;                    gray_value= L                     Intensity(gamma_map[Intensity(image->colormap[index])]);1                   color.red=XUpScale(gray_value); 3                   color.green=XUpScale(gray_value); 2                   color.blue=XUpScale(gray_value);<                   XBestPixel(display,colormap,server_colors,F                     (unsigned int) visual_info->colormap_size,&color);8                   pixel_info->pixels[index]=color.pixel;                   *p++=color;%                 }%=               if (image->colors < visual_info->colormap_size)h                 {s                   /*G                     Fill up colors array-- more choices for pen colors.d                   */                    retain_colors=F                     Min(visual_info->colormap_size-image->colors,256);3                   for (i=0; i < retain_colors; i++)f*                     *p++=server_colors[i];/                   number_colors+=retain_colors;u                 }e+               free((char *) server_colors);a
             }f#           free((char *) diversity);v           break;	         }        /*M         Define Standard colormap for private GrayScale or PseudoColor visual.b       */       if (status == 0)	         {a           /*P             Not enough colormap entries in the colormap-- Create a new colormap.           */+           colormap=XCreateColormap(display,dI             XRootWindow(display,visual_info->screen),visual_info->visual,h             AllocNone); *           if (colormap == (Colormap) NULL)=             Error("Unable to create colormap",(char *) NULL);i&           map_info->colormap=colormap;9           if (image->colors < visual_info->colormap_size)e
             {o               /*K                 Retain colors from the default colormap to help lessens the -                 effects of colormap flashing.e               */N               retain_colors=Min(visual_info->colormap_size-image->colors,256);%               p=colors+image->colors;L/               for (i=0; i < retain_colors; i++)                {*+                 p->pixel=(unsigned long) i;s                 p++;               }u#               XQueryColors(display,;>                 XDefaultColormap(display,visual_info->screen),:                 colors+image->colors,(int) retain_colors);               /*A                 Transfer colors from default to private colormap.l               */O               XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0, 2                 pixel_info->pixels,retain_colors);%               p=colors+image->colors; /               for (i=0; i < retain_colors; i++)i               { /                 p->pixel=pixel_info->pixels[i];                  p++;               }tP               XStoreColors(display,colormap,colors+image->colors,retain_colors);+               number_colors+=retain_colors; 
             }tK           XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0, .             pixel_info->pixels,image->colors);	         }u       /*!         Store the image colormap.;       */       p=colors;%+       color.flags=DoRed | DoGreen | DoBlue;%,       if (visual_info->class == PseudoColor))         for (i=0; i < image->colors; i++) 	         { D           color.red=XUpScale(gamma_map[image->colormap[i].red].red);J           color.green=XUpScale(gamma_map[image->colormap[i].green].green);G           color.blue=XUpScale(gamma_map[image->colormap[i].blue].blue); ,           color.pixel=pixel_info->pixels[i];           *p++=color; 	         } 
       else)         for (i=0; i < image->colors; i++) 	         { I           gray_value=Intensity(gamma_map[Intensity(image->colormap[i])]); )           color.red=XUpScale(gray_value); +           color.green=XUpScale(gray_value);%*           color.blue=XUpScale(gray_value);,           color.pixel=pixel_info->pixels[i];           *p++=color; 	         }z:       XStoreColors(display,colormap,colors,image->colors);       break;     }t     case TrueColor:a     case DirectColor:e     default:     {i       unsigned int         linear_colormap;         /*E         Define Standard Colormap for TrueColor or DirectColor visual.i       */K       number_colors=(unsigned int) ((map_info->red_max*map_info->red_mult)+ 3         (map_info->green_max*map_info->green_mult)+s4         (map_info->blue_max*map_info->blue_mult)+1);/       linear_colormap=(number_colors > 4096) || A         (((map_info->red_max+1) == visual_info->colormap_size) &&)C          ((map_info->green_max+1) == visual_info->colormap_size) &&pA          ((map_info->blue_max+1) == visual_info->colormap_size));b       if (linear_colormap)1         number_colors=visual_info->colormap_size;        /*         Allocate color array.l       */=       colors=(XColor *) malloc(number_colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       /*%         Initialize linear color ramp.m       */       p=colors; +       color.flags=DoRed | DoGreen | DoBlue;)       if (linear_colormap))         for (i=0; i < number_colors; i++) 	         {t(           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=(unsigned short))G               (((i % map_info->green_mult)*65535L)/map_info->blue_max);)!           color.green=color.blue;K           color.red=color.blue;s8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;a	         }n
       else)         for (i=0; i < number_colors; i++)t	         {y'           color.red=(unsigned short) 0; %           if (map_info->red_max != 0)/&             color.red=(unsigned short)B               (((i/map_info->red_mult)*65535L)/map_info->red_max);)           color.green=(unsigned short) 0; '           if (map_info->green_max != 0)tF             color.green=(unsigned short) ((((i/map_info->green_mult) %D               (map_info->green_max+1))*65535L)/map_info->green_max);(           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=(unsigned short)%G               (((i % map_info->green_mult)*65535L)/map_info->blue_max); 8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color; 	         } 0       if ((visual_info->class == DirectColor) &&F           (colormap != XDefaultColormap(display,visual_info->screen)))<         XStoreColors(display,colormap,colors,number_colors);
       else)         for (i=0; i < number_colors; i++) 3           XAllocColor(display,colormap,&colors[i]);        break;     }    } O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))      {        /*8         Set foreground, background, border, etc. pixels.       */7       XBestPixel(display,colormap,colors,number_colors,r'         &pixel_info->foreground_color);t7       XBestPixel(display,colormap,colors,number_colors,s'         &pixel_info->background_color);d/       if (pixel_info->background_color.pixel ==r-           pixel_info->foreground_color.pixel)r	         {a           /*9             Foreground and background colors must differ.t           */O           pixel_info->background_color.red=(~pixel_info->foreground_color.red);c-           pixel_info->background_color.green=r2             (~pixel_info->foreground_color.green);,           pixel_info->background_color.blue=1             (~pixel_info->foreground_color.blue);m;           XBestPixel(display,colormap,colors,number_colors,c+             &pixel_info->background_color);f	         }m7       XBestPixel(display,colormap,colors,number_colors,a#         &pixel_info->border_color);e7       XBestPixel(display,colormap,colors,number_colors,t"         &pixel_info->matte_color);7       XBestPixel(display,colormap,colors,number_colors, &         &pixel_info->highlight_color);7       XBestPixel(display,colormap,colors,number_colors,a#         &pixel_info->shadow_color);=7       XBestPixel(display,colormap,colors,number_colors,e"         &pixel_info->depth_color);7       XBestPixel(display,colormap,colors,number_colors, #         &pixel_info->trough_color);G'       for (i=0; i < MaxNumberPens; i++)        {n9         XBestPixel(display,colormap,colors,number_colors,_&           &pixel_info->pen_colors[i]);L         pixel_info->pixels[image->colors+i]=pixel_info->pen_colors[i].pixel;       }r5       pixel_info->colors=image->colors+MaxNumberPens;)     }e   free((char *) colors);   if (resource_info->debug)o     {f4       (void) fprintf(stderr,"Standard Colormap:\n");I       (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap); D       (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",B         map_info->red_max,map_info->green_max,map_info->blue_max);E       (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n",lE         map_info->red_mult,map_info->green_mult,map_info->blue_mult);e     }c }r = /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%UO %                                                                             %eO %                                                                             %cO %                                                                             %(O %   X M a k e W i n d o w                                                     %nO %                                                                             %eO %                                                                             %0O %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %(. %  Function XMakeWindow creates an X11 window. %l, %  The format of the XMakeWindow routine is: %,E %      XMakeWindow(display,parent,argv,argc,class_hint,manager_hints,  %        window_info), %o+ %  A description of each parameter follows:p %=D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %i0 %    o parent: Specifies the parent window_info. %l7 %    o argv: Specifies the application's argument list., %n/ %    o argc: Specifies the number of arguments.i %sE %    o class_hint: Specifies a pointer to a X11 XClassHint structure.r %dF %    o manager_hints: Specifies a pointer to a X11 XWMHints structure. %rG %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.a %" %a */E void XMakeWindow(Display *display,Window parent,char **argv,int argc,sJ   XClassHint *class_hint,XWMHints *manager_hints,XWindowInfo *window_info) {" #define MinWindowSize  64e     Atom     atom_list[2];r     inte     gravity,     status;,     static XTextProperty     icon_name,     window_name;     XSizeHints     *size_hints;     /*     Set window info hints.   */   size_hints=XAllocSizeHints();"(   if (size_hints == (XSizeHints *) NULL)@     Error("Unable to make X window","Memory allocation failed");'   size_hints->flags=window_info->flags;i   size_hints->x=window_info->x;e   size_hints->y=window_info->y;r'   size_hints->width=window_info->width;n)   size_hints->height=window_info->height;G   if (window_info->immutable)s     {t       /*&         Window size cannot be changed.       */.       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;"       size_hints->flags|=PMinSize;"       size_hints->flags|=PMaxSize;     }n   else     {8       /*#         Window size can be changed.e       */3       size_hints->min_width=window_info->min_width;e5       size_hints->min_height=window_info->min_height;r$       size_hints->flags|=PResizeInc;3       size_hints->width_inc=window_info->width_inc;r5       size_hints->height_inc=window_info->height_inc;" #ifndef PRE_R4_ICCCM#       size_hints->flags|=PBaseSize;e3       size_hints->base_width=size_hints->width_inc;e5       size_hints->base_height=size_hints->height_inc;r #endif     }e   gravity=NorthWestGravity; -   if (window_info->geometry != (char *) NULL)l     {o
       char(         default_geometry[MaxTextLength],          geometry[MaxTextLength];  	       inte         flags;         register charx         *p;o         /*          User specified geometry.       */@       (void) sprintf(default_geometry,"%dx%d",size_hints->width,         size_hints->height);4       (void) strcpy(geometry,window_info->geometry);       p=geometry; !       while ((int) strlen(p) > 0)l       {r(         if (!isspace(*p) && (*p != '%'))           p++;         else           (void) strcpy(p,p+1);        }eN       flags=XWMGeometry(display,window_info->screen,geometry,default_geometry,K         window_info->border_width,size_hints,&size_hints->x,&size_hints->y,u9         &size_hints->width,&size_hints->height,&gravity);(8       if ((flags & WidthValue) && (flags & HeightValue))"         size_hints->flags|=USSize;/       if ((flags & XValue) && (flags & YValue))0	         {o(           size_hints->flags|=USPosition;'           window_info->x=size_hints->x;='           window_info->y=size_hints->y;t	         }      }i #ifndef PRE_R4_ICCCM"   size_hints->win_gravity=gravity;!   size_hints->flags|=PWinGravity;1 #endif'   if (window_info->id == (Window) NULL)rO     window_info->id=XCreateWindow(display,parent,window_info->x,window_info->y,)G       window_info->width,window_info->height,window_info->border_width,tK       window_info->depth,InputOutput,window_info->visual,window_info->mask,(        &window_info->attributes);   else     {        unsigned int
         mask;;         XEvent         sans_event;o         XWindowChanges         window_changes;u         /*;         Window already exists;  change relevant attributes.e       */H       XChangeWindowAttributes(display,window_info->id,window_info->mask,"         &window_info->attributes);       mask=ConfigureNotify; O       while (XCheckTypedWindowEvent(display,window_info->id,mask,&sans_event));h&       window_changes.x=window_info->x;&       window_changes.y=window_info->y;.       window_changes.width=window_info->width;0       window_changes.height=window_info->height;       mask=CWWidth | CWHeight;*       if (window_info->flags & USPosition)         mask|=CWX | CWY;L       XReconfigureWMWindow(display,window_info->id,window_info->screen,mask,         &window_changes);)     }e'   if (window_info->id == (Window) NULL)l7     Error("Unable to create window",window_info->name);eF   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status == 0)>     Error("Unable to create text property",window_info->name);I   status=XStringListToTextProperty(&window_info->icon_name,1,&icon_name);o   if (status == 0)C     Error("Unable to create text property",window_info->icon_name);l2   if (window_info->icon_geometry != (char *) NULL)     {,	       int"         flags,         gravity,         height,r         width;         /*%         User specified icon geometry.o       */$       size_hints->flags|=USPosition;O       flags=XWMGeometry(display,window_info->screen,window_info->icon_geometry,":         (char *) NULL,0,size_hints,&manager_hints->icon_x,8         &manager_hints->icon_y,&width,&height,&gravity);/       if ((flags & XValue) && (flags & YValue))f/         manager_hints->flags|=IconPositionHint;e     }sM   XSetWMProperties(display,window_info->id,&window_name,&icon_name,argv,argc,r)     size_hints,manager_hints,class_hint);"   if (window_name.nitems != 0)&     XFree((void *) window_name.value);   if (icon_name.nitems != 0)$     XFree((void *) icon_name.value);=   atom_list[0]=XInternAtom(display,"WM_DELETE_WINDOW",False);p:   atom_list[1]=XInternAtom(display,"WM_TAKE_FOCUS",False);7   XSetWMProtocols(display,window_info->id,atom_list,2);    XFree((void *) size_hints);] }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %;O %                                                                             %tO %                                                                             %(O %   X M o n t a g e I m a g e                                                 % O %                                                                             %iO %                                                                             %"O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %uH %  Function XMontageImage creates a composite image by combining several %  separate images.o %e- %  The format of the MontageImage routine is:o %e@ %      XMontageImage(images,resource_info,montage_info,filename) %t+ %  A description of each parameter follows:t %sB %    o image: Specifies a pointer to an array of Image structures. %sK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.> %tE %    o montage_info: Specifies a pointer to a XMontageInfo structure.b %,9 %    o filename: Specifies the name of the montage image.  %G %e */  ; static void FormatLabel(XFontStruct *font_info,char *label,o   const unsigned int width)s {c   register charo     *p,e     *q;G     if (label == (char *) NULL),     return;u*   if (strchr(label,'\n') != (char *) NULL)     return;r   /*1     Format label to fit within a specified width.s   */
   p=label;   for (q=p; *q != '\0'; q++),     if (XTextWidth(font_info,p,q-p) > width)       { &         while ((*q != ' ') && (q > p))           q--;         if (q == p)m           break;         *q='\n';         p=q+1;       }a })  ) static int NumberLines(const char *label)( {o   intt     number_lines;s     if (label == (char *) NULL)e     return(0);   /*4     Determine the number of lines within this label.   *//   for (number_lines=1; *label != '\0'; label++)m     if (*label == '\n');       number_lines++;o   return(number_lines);( }o  4 static int SceneCompare(const void *x,const void *y) {)   Imageo     **image_1,     **image_2;     image_1=(Image **) x;b   image_2=(Image **) y;(:   return((int) (*image_1)->scene-(int) (*image_2)->scene); }s  G Image *XMontageImage(Image **images,const XResourceInfo *resource_info,*2   XMontageInfo *montage_info,const char *filename) {mB #define MontageImageText  "  Creating visual image directory...  "     AnnotateInfo     annotate_info;     char     geometry[MaxTextLength];  
   ColorPacket=     background_color,      border_color,f     highlight_color,     matte_color,     shadow_color;f  	   Displayo
     *display;      Imagef     *image,=     *montage_image;*     int%
     flags,     x,
     x_offset,%     y,
     y_offset;%     MonitorHandler     handler;     register int     i;     register RunlengthPacket     *p;      RectangleInfo      bounding_box,      tile_info;     unsigned int     border_width,      bevel_width,     concatenate,
     count,     font_height,     height,      max_height,      number_images,     number_lines,      number_tiles, 	     tile, 
     tiles,     tiles_per_column,      tiles_per_row,     title_offset,      total_tiles,
     width;     XColor
     color;     /**     Sort images by increasing tile number.   */*   number_tiles=montage_info->number_tiles;
   count=0;+   for (tile=0; tile < number_tiles; tile++)%     count+=images[tile]->scene;G   if (count != 0)q7     qsort((void *) images,number_tiles,sizeof(Image *), :       (int (*)(const void *, const void *)) SceneCompare);   /*'     Determine tiles per row and column.T   */   tiles_per_row=1;   tiles_per_column=1; 9   while ((tiles_per_row*tiles_per_column) < number_tiles)e   {o     tiles_per_row++;     tiles_per_column++;a   }r*   if (montage_info->tile != (char *) NULL)     {s2       tiles_per_column=montage_info->number_tiles;P       XParseGeometry(montage_info->tile,&x,&y,&tiles_per_row,&tiles_per_column);     }    /*     Determine tile sizes.S   */+   border_width=resource_info->border_width;    bevel_width=0;   if (montage_info->frame)     {i(       bevel_width=(border_width >> 2)+1;%       border_width+=bevel_width << 1;r     }s*   tile_info.x=resource_info->border_width;*   tile_info.y=resource_info->border_width;   flags=NoValue;5   if (resource_info->image_geometry != (char *) NULL)      {iF       flags=XParseGeometry(resource_info->image_geometry,&tile_info.x,9         &tile_info.y,&tile_info.width,&tile_info.height);o       if (tile_info.x < 0)         tile_info.x=0;       if (tile_info.y < 0)         tile_info.y=0;     } ?   concatenate=!((flags & WidthValue) || (flags & HeightValue)); %   tile_info.width=images[0]->columns; #   tile_info.height=images[0]->rows;u9   for (tile=1; tile < montage_info->number_tiles; tile++))   {n0     if (images[tile]->columns > tile_info.width),       tile_info.width=images[tile]->columns;.     if (images[tile]->rows > tile_info.height)*       tile_info.height=images[tile]->rows;   }_   /*     Initialize tile colors..   */E   (void) XQueryColorDatabase(resource_info->background_color,&color);%-   background_color.red=XDownScale(color.red); 1   background_color.green=XDownScale(color.green); /   background_color.blue=XDownScale(color.blue);    background_color.index=0; A   (void) XQueryColorDatabase(resource_info->border_color,&color); )   border_color.red=XDownScale(color.red); -   border_color.green=XDownScale(color.green); +   border_color.blue=XDownScale(color.blue);    border_color.index=0; @   (void) XQueryColorDatabase(resource_info->matte_color,&color);(   matte_color.red=XDownScale(color.red);,   matte_color.green=XDownScale(color.green);*   matte_color.blue=XDownScale(color.blue);   matte_color.index=0;?   highlight_color.red=(XDownScale(color.red)*HighlightModulate+t=     (unsigned int) (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB;eC   highlight_color.green=(XDownScale(color.green)*HighlightModulate+S=     (unsigned int) (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB;yA   highlight_color.blue=(XDownScale(color.blue)*HighlightModulate+ =     (unsigned int) (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB;w   highlight_color.index=0;@   (void) XQueryColorDatabase(resource_info->matte_color,&color);!   shadow_color.red=(unsigned int)d2     (XDownScale(color.red)*ShadowModulate)/MaxRGB;#   shadow_color.green=(unsigned int) 4     (XDownScale(color.green)*ShadowModulate)/MaxRGB;"   shadow_color.blue=(unsigned int)3     (XDownScale(color.blue)*ShadowModulate)/MaxRGB;t   shadow_color.index=0;    /*     Initialize annotate info.b   */"   GetAnnotateInfo(&annotate_info);7   annotate_info.server_name=resource_info->server_name;n)   annotate_info.font=resource_info->font; 4   annotate_info.pen=resource_info->foreground_color;2   annotate_info.pointsize=montage_info->pointsize;"   annotate_info.geometry=geometry;   annotate_info.center=True;&   font_height=montage_info->pointsize;3   display=XOpenDisplay(resource_info->server_name); "   if (display != (Display *) NULL)     {f       XFontStruct          *font_info;(         /*         Initialize font info.a       */7       font_info=XBestFont(display,resource_info,False);_,       if (font_info == (XFontStruct *) NULL)	         {(I           Warning("Unable to montage images","Memory allocation failed"); !           return((Image *) NULL);%	         }%C       FormatLabel(font_info,resource_info->title,((tile_info.width+ G         (border_width << 1))*Min(number_tiles,tiles_per_column)) >> 1); /       for (tile=0; tile < number_tiles; tile++) B         FormatLabel(font_info,images[tile]->label,tile_info.width+           (border_width << 1)); 7       font_height=font_info->ascent+font_info->descent; #       XFreeFont(display,font_info);        XCloseDisplay(display);      }    /*4     Determine the number of lines in an image label.   */   title_offset=0; ,   if (resource_info->title != (char *) NULL)     title_offset= P       ((font_height*NumberLines(resource_info->title)) << 1)+(tile_info.y << 1);   number_lines=0;%+   for (tile=0; tile < number_tiles; tile++)u8     if (NumberLines(images[tile]->label) > number_lines)4       number_lines=NumberLines(images[tile]->label);   /*     Allocate image structure.i   */2   montage_image=AllocateImage((ImageInfo *) NULL);&   if (montage_image == (Image *) NULL)     {GE       Warning("Unable to montage images","Memory allocation failed");        return((Image *) NULL);n     }s   montage_image->scene=1;y   number_images=F     (montage_info->number_tiles-1)/(tiles_per_row*tiles_per_column)+1;
   tiles=0;)   total_tiles=montage_info->number_tiles; #   for (i=0; i < number_images; i++)    {c     /*       Determine bounding box.X     */P     number_tiles=Min(montage_info->number_tiles,tiles_per_row*tiles_per_column);     x_offset=0;t     y_offset=title_offset;     max_height=0;      bounding_box.width=0;      bounding_box.height=0;-     for (tile=0; tile < number_tiles; tile++)r     {oB       width=concatenate ? images[tile]->columns : tile_info.width;3       x_offset+=width+(tile_info.x+border_width)*2;v(       if (x_offset > bounding_box.width)$         bounding_box.width=x_offset;*       if (images[tile]->rows > max_height)&         max_height=images[tile]->rows;J       if (((tile+1) == number_tiles) || (((tile+1) % tiles_per_row) == 0))	         {            x_offset=0; =           height=concatenate ? max_height : tile_info.height;_           y_offset+=M             height+(tile_info.y+border_width)*2+(font_height+2)*number_lines;(-           if (y_offset > bounding_box.height)o)             bounding_box.height=y_offset;            max_height=0;a	         }      }s     /*!       Initialize Image structure.,     */"     if (filename != (char *) NULL)6       (void) strcpy(montage_image->filename,filename);.     montage_image->columns=bounding_box.width;,     montage_image->rows=bounding_box.height;F     montage_image->packets=montage_image->columns*montage_image->rows;-     montage_image->pixels=(RunlengthPacket *)nL       malloc((unsigned int) montage_image->packets*sizeof(RunlengthPacket));:     if (montage_image->pixels == (RunlengthPacket *) NULL)       { G         Warning("Unable to montage images","Memory allocation failed");.%         DestroyImages(montage_image);m         return((Image *) NULL);r       }      if (!concatenate)n       {a
         /*           Set montage geometry.t
         */K         montage_image->montage=(char *) malloc(MaxTextLength*sizeof(char));T         count=1;1         for (tile=0; tile < number_tiles; tile++)e2           count+=strlen(images[tile]->filename)+1;E         montage_image->directory=(char *) malloc(count*sizeof(char)); 8         if ((montage_image->montage == (char *) NULL) ||8             (montage_image->directory == (char *) NULL))           {dK             Warning("Unable to montage images","Memory allocation failed"); )             DestroyImages(montage_image); #             return((Image *) NULL);l           }          x_offset=0;=         y_offset=title_offset;<         (void) sprintf(montage_image->montage,"%dx%d%+d%+d",?           (int) (tile_info.width+(tile_info.x+border_width)*2),;O           (int) (tile_info.height+(tile_info.y+border_width)*2+(font_height+2)*%+           number_lines),x_offset,y_offset); '         *montage_image->directory='\0'; 1         for (tile=0; tile < number_tiles; tile++) 	         { I           (void) strcat(montage_image->directory,images[tile]->filename); 7           (void) strcat(montage_image->directory,"\n"); 	         }        }      /*3       Initialize montage image to background color.      */     p=montage_image->pixels;.     for (x=0; x < montage_image->packets; x++)     { "       p->red=background_color.red;&       p->green=background_color.green;$       p->blue=background_color.blue;       p->index=0;        p->length=0;
       p++;     }%/     if (montage_info->texture != (char *) NULL)%8       TextureImage(montage_image,montage_info->texture);.     if (resource_info->title != (char *) NULL)       {g
         /*.           Annotate composite image with title.
         */<         (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",C           montage_image->columns,font_height << 1,0,tile_info.y+4);n0         annotate_info.text=resource_info->title;4         AnnotateImage(montage_image,&annotate_info);       }r     /*.       Copy tile images to the composite image.     */     x_offset=tile_info.x; &     y_offset=title_offset+tile_info.y;     max_height=0;l-     for (tile=0; tile < number_tiles; tile++)u     {o       /*.         Copy this tile to the composite image.       */7       handler=SetMonitorHandler((MonitorHandler) NULL);h       image=images[tile]; ;       width=concatenate ? image->columns : tile_info.width;e#       if (image->rows > max_height)e         max_height=image->rows;w9       height=concatenate ? max_height : tile_info.height;        if (border_width != 0)	         {v           Imager             *bordered_image;             RectangleInfoc             border_info;             /**             Put a border around the image.           */)           border_info.width=border_width;l*           border_info.height=border_width;"           if (montage_info->frame)
             {d>               border_info.width=(width-image->columns+1) >> 1;=               border_info.height=(height-image->rows+1) >> 1;l
             }rG           bordered_image=BorderImage(image,&border_info,&border_color); /           if (bordered_image != (Image *) NULL) 
             {i"               DestroyImage(image);#               image=bordered_image; 
             } 	         }        /*9         Gravitate image as specified by the tile gravity.        */%       switch (resource_info->gravity)        {r         case NorthWestGravity:	         {r           x=0;           y=0;           break;	         }i         case NorthGravity:	         { >           x=((width+(border_width << 1))-image->columns) >> 1;           y=0;           break;	         }          case NorthEastGravity:	         {w7           x=(width+(border_width << 1))-image->columns;i           y=0;           break;	         }a         case WestGravity:t	         {_           x=0;<           y=((height+(border_width << 1))-image->rows) >> 1;           break;	         }o         case ForgetGravity:W         case StaticGravity:d         case CenterGravity:i         default:	         {d>           x=((width+(border_width << 1))-image->columns) >> 1;<           y=((height+(border_width << 1))-image->rows) >> 1;           break;	         }g         case EastGravity:;	         {d7           x=(width+(border_width << 1))-image->columns; <           y=((height+(border_width << 1))-image->rows) >> 1;           break;	         }r         case SouthWestGravity:	         {+           x=0;5           y=(height+(border_width << 1))-image->rows;a           break;	         }          case SouthGravity:	         { >           x=((width+(border_width << 1))-image->columns) >> 1;5           y=(height+(border_width << 1))-image->rows;)           break;	         }o         case SouthEastGravity:	         { 7           x=(width+(border_width << 1))-image->columns;)5           y=(height+(border_width << 1))-image->rows;)           break;	         }r       };4       if (montage_info->frame && (bevel_width != 0))	         {p           FrameInfos             frame_info;o             Imagew             *framed_image;             /*6             Put an ornamental border around this tile.           */-           frame_info.matte_color=matte_color; 5           frame_info.highlight_color=highlight_color;e/           frame_info.shadow_color=shadow_color;o5           frame_info.width=width+(border_width << 1);.7           frame_info.height=height+(border_width << 1); G           frame_info.height+=(font_height+2)*NumberLines(image->label);x2           frame_info.x=(x > 0 ? x : border_width);2           frame_info.y=(y > 0 ? y : border_width);-           frame_info.inner_bevel=bevel_width;k-           frame_info.outer_bevel=bevel_width;t5           framed_image=FrameImage(image,&frame_info);n-           if (framed_image != (Image *) NULL)t
             {a"               DestroyImage(image);!               image=framed_image;o
             }_           x=0;           y=0;	         }        /*3         Composite background image with tile image.g       */?       CompositeImage(montage_image,montage_info->compose,image,          x_offset+x,y_offset+y);L       if (montage_info->shadow)n	         {,           ColorPacket,             shadow_color,d             trough_color;p             register int             columns,             rows;_             /*6             Put a shadow under the tile to show depth.           */M           (void) XQueryColorDatabase(resource_info->background_color,&color);A)           shadow_color.red=(unsigned int) :             (XDownScale(color.red)*ShadowModulate)/MaxRGB;+           shadow_color.green=(unsigned int)i<             (XDownScale(color.green)*ShadowModulate)/MaxRGB;*           shadow_color.blue=(unsigned int);             (XDownScale(color.blue)*ShadowModulate)/MaxRGB;lM           (void) XQueryColorDatabase(resource_info->background_color,&color);o)           trough_color.red=(unsigned int)(:             (XDownScale(color.red)*TroughModulate)/MaxRGB;+           trough_color.green=(unsigned int) <             (XDownScale(color.green)*TroughModulate)/MaxRGB;*           trough_color.blue=(unsigned int);             (XDownScale(color.blue)*TroughModulate)/MaxRGB;X2           for (rows=0; rows < image->rows; rows++)           {eO             p=montage_image->pixels+montage_image->columns*(y_offset+y+rows+4)+_(               x_offset+x+image->columns;D             for (columns=0; columns < Min(tile_info.x,4); columns++)
             {iF               if (p >= (montage_image->pixels+montage_image->packets))                 continue;s,               if (((columns+rows) % 2) == 0)                 { *                   p->red=shadow_color.red;.                   p->green=shadow_color.green;,                   p->blue=shadow_color.blue;                 }                else                 { *                   p->red=trough_color.red;.                   p->green=trough_color.green;,                   p->blue=trough_color.blue;                 }=               p++;
             }&           } 9           for (rows=0; rows < Min(tile_info.y,4); rows++)            {i;             p=montage_image->pixels+montage_image->columns*o9               (y_offset+y+image->rows+rows)+x_offset+x+4;t@             for (columns=0; columns < image->columns; columns++)
             {aF               if (p >= (montage_image->pixels+montage_image->packets))                 continue; ,               if (((columns+rows) % 2) == 0)                 {i*                   p->red=shadow_color.red;.                   p->green=shadow_color.green;,                   p->blue=shadow_color.blue;                 }e               else                 {i*                   p->red=trough_color.red;.                   p->green=trough_color.green;,                   p->blue=trough_color.blue;                 }_               p++;
             }            } 	         } (       if (image->label != (char *) NULL)	         {t           /*5             Annotate composite image tile with label.            */>           (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",O             (montage_info->frame ? image->columns : width)-(border_width << 1),e;             font_height,(int) (x_offset+border_width),(int)=G             (montage_info->frame ? y_offset+height+(border_width << 1)-oC             bevel_width-2 : y_offset+y+tile_info.y+image->rows+2));l*           annotate_info.text=image->label;6           AnnotateImage(montage_image,&annotate_info);	         }e3       x_offset+=width+(tile_info.x+border_width)*2;mJ       if (((tile+1) == number_tiles) || (((tile+1) % tiles_per_row) == 0))	         {            x_offset=tile_info.x;a           y_offset+=M             height+(tile_info.y+border_width)*2+(font_height+2)*number_lines;=           max_height=0;-	         }a       DestroyImage(image);(       (void) SetMonitorHandler(handler);:       ProgressMonitor(MontageImageText,tiles,total_tiles);       tiles++;     }=!     CompressImage(montage_image);      if ((i+1) < number_images)       {o
         /*(           Allocate next image structure.
         */>         montage_image->next=AllocateImage((ImageInfo *) NULL);2         if (montage_image->next == (Image *) NULL)           {n)             DestroyImages(montage_image);m#             return((Image *) NULL);r           } >         (void) strcpy(montage_image->next->filename,filename);6         montage_image->next->file=montage_image->file;:         montage_image->next->scene=montage_image->scene+1;4         montage_image->next->previous=montage_image;*         montage_image=montage_image->next;         images+=number_tiles; 1         montage_info->number_tiles-=number_tiles;g       };   } 3   while (montage_image->previous != (Image *) NULL) *     montage_image=montage_image->previous;   return(montage_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %%O %                                                                             % O %                                                                             %iO %   X Q u e r y C o l o r D a t a b a s e                                     % O %                                                                             %xO %                                                                             %nO %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l % N %  Function XQueryColorDatabase looks up a RGB values for a color given in the %  target string.x %%4 %  The format of the XQueryColorDatabase routine is: %o- %    status=XQueryColorDatabase(target,color)  %g+ %  A description of each parameter follows:0 % K %    o status:  Function XQueryColorDatabase returns True if the RGB values;C %      of the target color is defined, otherwise False is returned.r %XE %    o target: Specifies the color to lookup in the X color database._ %fL %    o color: A pointer to an XColor structure.  The RGB value of the target' %      color is returned as this value.  %l %m */B unsigned int XQueryColorDatabase(const char *target,XColor *color) {    char     colorname[MaxTextLength],;     text[MaxTextLength];  
   Colormap
     colormap;a     FILE     *database;     int 	     blue, 
     count,
     green,     red,     status;      register XColorlistr     *p;      static Display      *display = (Display *) NULL;     /*"     Initialize color return value.   */   color->red=0;N   color->green=0;    color->blue=0;(   color->flags=DoRed | DoGreen | DoBlue;   if (target == (char *) NULL)     target=BackgroundColor;    if (*target == '#');     { 
       char
         c;         register int
         i,
         n;         /*          Parse RGB specification.       */       target++;o       n=strlen(target); 8       if ((n != 3) && (n != 6) && (n != 9) && (n != 12))         return(False);       n/=3;        green=0;
       blue=0;p       do       {          red=green;         green=blue;          blue=0;o          for (i=n-1; i >= 0; i--)	         {            c=(*target++);           blue<<=4; '           if ((c >= '0') && (c <= '9'))              blue|=c-'0';           else)             if ((c >= 'A') && (c <= 'F'))                blue|=c-('A'-10);y             else+               if ((c >= 'a') && (c <= 'f')) !                 blue|=c-('a'-10);h               else                 return(False);
          }        } while (*target != '\0');       n<<=2;
       n=16-n;h       color->red=red << n;       color->green=green << n;       color->blue=blue << n;       return(True);a     }e'   database=fopen(RGBColorDatabase,"r");     if (database != (FILE *) NULL)     {e       /*1         Match color against the X color database.        */C       while (fgets(text,MaxTextLength-1,database) != (char *) NULL)a       { K         count=sscanf(text,"%d %d %d %[^\n]\n",&red,&green,&blue,colorname);          if (count != 4);           continue;=1         if (Latin1Compare(colorname,target) == 0)            {               color->red=red << 8;$             color->green=green << 8;"             color->blue=blue << 8;             return(True);0           }c       }i       (void) fclose(database);     }m   /*'     Search our internal color database.e   */2   for (p=Colorlist; p->name != (char *) NULL; p++)+     if (Latin1Compare(p->name,target) == 0)        {          color->red=p->red << 8; #         color->green=p->green << 8;a!         color->blue=p->blue << 8;i         return(True);        }    /*-     Let the X server define the color for us.t   */"   if (display == (Display *) NULL)(     display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     { 7       Warning("Color is not known to X server",target);t       return(False);     }t=   colormap=XDefaultColormap(display,XDefaultScreen(display)); 4   status=XParseColor(display,colormap,target,color);   if (status == False)5     Warning("Color is not known to X server",target);    return(status != 0); }( e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             % O %                                                                             % O %                                                                             % O %   X Q u e r y P o s i t i o n                                               % O %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XQueryPosition gets the pointer coodinates relative to a window. % / %  The format of the XQueryPosition routine is:  % ' %    XQueryPosition(display,window,x,y)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % / %    o window: Specifies a pointer to a Window.% %%N %    o x: Return the x coordinate of the pointer relative to the origin of the %      window. %iN %    o y: Return the y coordinate of the pointer relative to the origin of the %      window. %f %i */G void XQueryPosition(Display *display,const Window window,int *x,int *y)o {    intA     x_root,o     y_root;t     unsigned int	     mask;l     Window     root_window;  P   (void) XQueryPointer(display,window,&root_window,&root_window,&x_root,&y_root,     x,y,&mask);1 }i l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%yO %                                                                             %dO %                                                                             % O %                                                                             % O %   X R e f r e s h W i n d o w                                               % O %                                                                             %lO %                                                                             %rO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %;< %  Function XRefreshWindow refreshes an image in a X window. %d/ %  The format of the XRefreshWindow routine is:  %e+ %      XRefreshWindow(display,window,event)  % + %  A description of each parameter follows:) % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %d> %    o window: Specifies a pointer to a XWindowInfo structure. %eH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.n %  %  */? void XRefreshWindow(Display *display,const XWindowInfo *window,U   const XEvent *event) {i   inti     x,     y;     unsigned int     height, 
     width;     if (event != (XEvent *) NULL)m     {a       /*-         Determine geometry from expose event.=       */       x=event->xexpose.x;s       y=event->xexpose.y;d!       width=event->xexpose.width;n#       height=event->xexpose.height;o     }i   else     {        XEvent         sans_event;          /*A         Refresh entire window; discard outstanding expose events.i       */
       x=0;
       y=0;       width=window->width;       height=window->height;L       while (XCheckTypedWindowEvent(display,window->id,Expose,&sans_event));     }s   /*     Check boundary conditions.   */4   if ((window->ximage->width-(x+window->x)) < width).     width=window->ximage->width-(x+window->x);6   if ((window->ximage->height-(y+window->y)) < height)0     height=window->ximage->height-(y+window->y);   /*     Refresh image.   */F   XSetClipMask(display,window->annotate_context,window->matte_pixmap);&   if (window->pixmap != (Pixmap) NULL)     {d       if (window->depth > 1)M         XCopyArea(display,window->pixmap,window->id,window->annotate_context,z4           x+window->x,y+window->y,width,height,x,y);
       elseO         XCopyPlane(display,window->pixmap,window->id,window->highlight_context, 7           x+window->x,y+window->y,width,height,x,y,1L);d     }o   else     {x #ifdef HasSharedMemory        if (window->shared_memory)	         {iC           XShmPutImage(display,window->id,window->annotate_context,;J             window->ximage,x+window->x,y+window->y,x,y,width,height,True);           XSync(display,False);a	         }d #endif!       if (!window->shared_memory) M         XPutImage(display,window->id,window->annotate_context,window->ximage,|4           x+window->x,y+window->y,x,y,width,height);     }e6   XSetClipMask(display,window->annotate_context,None); }b g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %rO %                                                                             %>O %                                                                             %wO %   X R e t a i n W i n d o w C o l o r s                                     %NO %                                                                             %oO %                                                                             %bO %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XRetainWindowColors sets X11 color resources on a window.  This I %  perserves the colors associated with an image displayed on the window.  % 4 %  The format of the XRetainWindowColors routine is: % * %      XRetainWindowColors(display,window) % + %  A description of each parameter follows:  %pD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % > %    o window: Specifies a pointer to a XWindowInfo structure. %  %  */> void XRetainWindowColors(Display *display,const Window window) {    Atom
     property;%     Pixmap     pixmap;%     /*     Put property on the window.    */5   property=XInternAtom(display,"_XSETROOT_ID",False);    if (property == (Atom) NULL)     {h<       Warning("Unable to create X property","_XSETROOT_ID");
       return;i     }E-   pixmap=XCreatePixmap(display,window,1,1,1);t   if (pixmap == (Pixmap) NULL)     {r9       Warning("Unable to create X pixmap",(char *) NULL);n
       return;;     }eG   XChangeProperty(display,window,property,XA_PIXMAP,32,PropModeReplace, !     (unsigned char *) &pixmap,1);t-   XSetCloseDownMode(display,RetainPermanent);u }( o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %EO %                                                                             % O %                                                                             %tO %   X S e l e c t W i n d o w                                                 %xO %                                                                             % O %                                                                             % O %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%O %  Function XSelectWindow allows a user to select a window using the mouse.  If H %  the mouse moves, a cropping rectangle is drawn and the extents of the4 %  rectangle is returned in the crop_info structure. % / %  The format of the XSelectWindow function is:  % 5 %      target_window=XSelectWindow(display,crop_info)  % + %  A description of each parameter follows:  % 3 %    o window: XSelectWindow returns the window id.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o crop_info: Specifies a pointer to a RectangleInfo structure.  It%6 %      contains the extents of any cropping rectangle. %  %F */? Window XSelectWindow(Display *display,RectangleInfo *crop_info)  {d) #define MinimumCropArea  (unsigned int) 9a     Cursor     target_cursor;     GC     annotate_context;i     intd     presses,     status,h
     x_offset, 
     y_offset;o     Window     root_window,     target_window;     XEvent
     event;     XGCValuest     context_values;p     /*     Initialize graphic context.a   */;   root_window=XRootWindow(display,XDefaultScreen(display));iI   context_values.background=XBlackPixel(display,XDefaultScreen(display));pI   context_values.foreground=XWhitePixel(display,XDefaultScreen(display));y#   context_values.function=GXinvert;    context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors;aN   annotate_context=XCreateGC(display,root_window,GCBackground | GCForeground |@     GCFunction | GCPlaneMask | GCSubwindowMode,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*)     Grab the pointer using target cursor.    */0   target_cursor=XMakeCursor(display,root_window,G     XDefaultColormap(display,XDefaultScreen(display)),"white","black"); >   status=XGrabPointer(display,root_window,False,(unsigned int)J     (ButtonPressMask | ButtonReleaseMask | ButtonMotionMask),GrabModeSync,9     GrabModeAsync,root_window,target_cursor,CurrentTime);    if (status != GrabSuccess)4     Error("Unable to grab the mouse",(char *) NULL);   /*     Select a window.   */   crop_info->width=0;    crop_info->height=0;   presses=0;   target_window=(Window) NULL;
   x_offset=0;%
   y_offset=0;%   do   {%@     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x,f=         crop_info->y,crop_info->width-1,crop_info->height-1);h     /*       Allow another event.     */2     XAllowEvents(display,SyncPointer,CurrentTime);J     XWindowEvent(display,root_window,ButtonPressMask | ButtonReleaseMask |       ButtonMotionMask,&event); @     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x, =         crop_info->y,crop_info->width-1,crop_info->height-1);u     switch (event.type)n     {x       case ButtonPress:        {.D         target_window=XGetSubwindow(display,event.xbutton.subwindow,+           event.xbutton.x,event.xbutton.y);h+         if (target_window == (Window) NULL)d$           target_window=root_window;&         x_offset=event.xbutton.x_root;&         y_offset=event.xbutton.y_root;         crop_info->x=x_offset;         crop_info->y=y_offset;         crop_info->width=0;a         crop_info->height=0;         presses++;         break;       }n       case ButtonRelease:t       {i         presses--;         break;       }%       case MotionNotify:       {%
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); %         crop_info->x=event.xmotion.x; %         crop_info->y=event.xmotion.y; 
         /*$           Check boundary conditions.
         */$         if (crop_info->x < x_offset)B           crop_info->width=(unsigned int) (x_offset-crop_info->x);         else           { D             crop_info->width=(unsigned int) (crop_info->x-x_offset);"             crop_info->x=x_offset;           } $         if (crop_info->y < y_offset)C           crop_info->height=(unsigned int) (y_offset-crop_info->y);%         else           {%E             crop_info->height=(unsigned int) (crop_info->y-y_offset);r"             crop_info->y=y_offset;           }e       }        default:         break;     }m   }c<   while ((target_window == (Window) NULL) || (presses > 0));&   XUngrabPointer(display,CurrentTime);%   XFreeCursor(display,target_cursor);;$   XFreeGC(display,annotate_context);=   if ((crop_info->width*crop_info->height) < MinimumCropArea)h     {r       crop_info->width=0;        crop_info->height=0;     }f:   if ((crop_info->width != 0) && (crop_info->height != 0))     target_window=root_window;   return(target_window); }e i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %lO %                                                                             %gO %                                                                             %_O %   X S e t C u r s o r S t a t e                                             % O %                                                                             % O %                                                                             %cO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%x % I %  Function XSetCursorState sets the  cursor state to busy, otherwise the=% %  cursor are reset to their default.  %71 %  The format of the XXSetCursorState routine is:  %0- %      XSetCursorState(display,windows,state)1 %x+ %  A description of each parameter follows:f %xE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %x< %    o windows: Specifies a pointer to a XWindows structure. % F %    o state: An unsigned integer greater than 0 sets the cursor state@ %      to busy, otherwise the cursor are reset to their default. %d %l */8 void XSetCursorState(Display *display,XWindows *windows,   const unsigned int state)a {s   if (state)     {sJ       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);F       XDefineCursor(display,windows->pan.id,windows->pan.busy_cursor);N       XDefineCursor(display,windows->magnify.id,windows->magnify.busy_cursor);N       XDefineCursor(display,windows->command.id,windows->command.busy_cursor);     }p   else     {sE       XDefineCursor(display,windows->image.id,windows->image.cursor); A       XDefineCursor(display,windows->pan.id,windows->pan.cursor);nI       XDefineCursor(display,windows->magnify.id,windows->magnify.cursor);%I       XDefineCursor(display,windows->command.id,windows->command.cursor); H       XDefineCursor(display,windows->command.id,windows->widget.cursor);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);      }    windows->info.mapped=False;  }  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X U s e r P r e f e r e n c e s                                           %%O %                                                                             % O %                                                                             %eO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %sM %  Function XUserPreferences saves the preferences in a configuration file in  %  the users' home directory.t %e1 %  The format of the XUserPreferences routine is:e % & %      XUserPreferences(resource_info) % + %  A description of each parameter follows:  %cK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.i %a %i */3 void XUserPreferences(XResourceInfo *resource_info)f {    char     cache[MaxTextLength],t     filename[MaxTextLength],     specifier[MaxTextLength],h     *value;x  
   XrmDatabaseg     preferences_database;y     /*;     Save user preferences to the client configuration file.l   */0   preferences_database=XrmGetStringDatabase("");6   (void) sprintf(specifier,"%s.backdrop",client_name);3   value=resource_info->backdrop ? "True" : "False";n>   XrmPutStringResource(&preferences_database,specifier,value);;   (void) sprintf(specifier,"%s.browseCommand",client_name);t&   value=resource_info->browse_command;>   XrmPutStringResource(&preferences_database,specifier,value);6   (void) sprintf(specifier,"%s.colormap",client_name);I   value=resource_info->colormap == SharedColormap ? "Shared" : "Private"; >   XrmPutStringResource(&preferences_database,specifier,value);9   (void) sprintf(specifier,"%s.confirmExit",client_name);>7   value=resource_info->confirm_exit ? "True" : "False";a>   XrmPutStringResource(&preferences_database,specifier,value);=   (void) sprintf(specifier,"%s.displayWarnings",client_name);w;   value=resource_info->display_warnings ? "True" : "False";o>   XrmPutStringResource(&preferences_database,specifier,value);4   (void) sprintf(specifier,"%s.dither",client_name);1   value=resource_info->dither ? "True" : "False"; >   XrmPutStringResource(&preferences_database,specifier,value);;   (void) sprintf(specifier,"%s.editorCommand",client_name);t&   value=resource_info->editor_command;>   XrmPutStringResource(&preferences_database,specifier,value);:   (void) sprintf(specifier,"%s.gammaCorrect",client_name);8   value=resource_info->gamma_correct ? "True" : "False";>   XrmPutStringResource(&preferences_database,specifier,value);:   (void) sprintf(specifier,"%s.printCommand",client_name);%   value=resource_info->print_command; >   XrmPutStringResource(&preferences_database,specifier,value);7   (void) sprintf(specifier,"%s.undoCache",client_name);g7   (void) sprintf(cache,"%u",resource_info->undo_cache);L>   XrmPutStringResource(&preferences_database,specifier,cache);7   (void) sprintf(specifier,"%s.usePixmap",client_name);f5   value=resource_info->use_pixmap ? "True" : "False";e>   XrmPutStringResource(&preferences_database,specifier,value);D   (void) sprintf(filename,"%s%src",PreferencesDefaults,client_name);   ExpandFilename(filename);c4   XrmPutFileDatabase(preferences_database,filename); }h d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             % O %                                                                             %nO %   X V i s u a l C l a s s N a m e                                           %_O %                                                                             % O %                                                                             %dO %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%X %aI %  Function XVisualClassName returns the visual class name as a charactere
 %  string. %a1 %  The format of the XVisualClassName routine is:- %r* %      visual_type=XVisualClassName(class) %o+ %  A description of each parameter follows:n %sL %    o visual_type: XVisualClassName returns the visual class as a character %      string. % ) %    o class: Specifies the visual class.s %r %  */' char *XVisualClassName(const int class)) {r   switch (class)   {e*     case StaticGray: return("StaticGray");(     case GrayScale: return("GrayScale");,     case StaticColor: return("StaticColor");,     case PseudoColor: return("PseudoColor");(     case TrueColor: return("TrueColor");,     case DirectColor: return("DirectColor");   },!   return("unknown visual class");t }p l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             % O %                                                                             %mO %   X W i n d o w B y I D                                                     %yO %                                                                             %aO %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XWindowByID locates a child window with a given ID.  If not windowK %  with the given name is found, 0 is returned.   Only the window specified># %  and its subwindows are searched.  %i- %  The format of the XWindowByID function is:n %i+ %      child=XWindowByID(display,window,id)) %L+ %  A description of each parameter follows:a %p? %    o child: XWindowByID returns the window with the specified ; %      id.  If no windows are found, XWindowByID returns 0.a %;L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %>4 %    o id: Specifies the id of the window to locate. %y %  */= Window XWindowByID(Display *display,const Window root_window,s   const unsigned long id)0 {    RectangleInfor     rectangle_info;e     register int     i;     unsigned int     number_children;     Window
     child,     *children,     window;      if (id == 0)3     return(XSelectWindow(display,&rectangle_info));w   if (root_window == id)     return(id); P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL;-%   for (i=0; i < number_children; i++)    {a     /*+       Search each child and their children.e     *//     window=XWindowByID(display,children[i],id);       if (window != (Window) NULL)       break;   } "   if (children != (Window *) NULL)     XFree((void *) children);f   return(window);e }a \ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,O %                                                                             %(O %                                                                             %eO %                                                                             %_O %   X W i n d o w B y N a m e                                                 % O %                                                                             % O %                                                                             % O %                                                                             %UO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % J %  Function XWindowByName locates a window with a given name on a display.I %  If no window with the given name is found, 0 is returned. If more than>K %  one window has the given name, the first one is returned.  Only root anda %  its children are searched., %n/ %  The format of the XWindowByName function is:l % 5 %      window=XWindowByName(display,root_window,name)_ %g+ %  A description of each parameter follows:m %w3 %    o window: XWindowByName returns the window id.P %aL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %(8 %    o root_window: Specifies the id of the root window. % 8 %    o name: Specifies the name of the window to locate. %m %X */P Window XWindowByName(Display *display,const Window root_window,const char *name) {a   register int     i;     unsigned int     number_children;     Window     *children,
     child,     window;s     XTextProperty      window_name;  8   if (XGetWMName(display,root_window,&window_name) != 0)5     if (strcmp((char *) window_name.value,name) == 0)o       return(root_window);P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL;i%   for (i=0; i < number_children; i++)    {      /*+       Search each child and their children.      */3     window=XWindowByName(display,children[i],name);i      if (window != (Window) NULL)       break;   }i"   if (children != (Window *) NULL)     XFree((void *) children);    return(window);t }i p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %nO %                                                                             %%O %                                                                             % O %   X W i n d o w B y P r o p e r y                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XWindowByProperty locates a child window with a given property. J %  If no window with the given name is found, 0 is returned.  If more thanJ %  one window has the given property, the first one is returned.  Only the4 %  window specified and its subwindows are searched. % 3 %  The format of the XWindowByProperty function is:i %n7 %      child=XWindowByProperty(display,window,property)p %e+ %  A description of each parameter follows:c %sH %    o child: XWindowByProperty returns the window id with the specifiedG %      property.  If no windows are found, XWindowByProperty returns 0.  %aL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %f@ %    o property: Specifies the property of the window to locate. %o %e */> Window XWindowByProperty(Display *display,const Window window,   const Atom property) {o   Atom	     type;      into     format,c     status;e     unsigned charI
     *data;     unsigned int     i,     number_children;     unsigned long 
     after,     number_items;      Window
     child,     *children,     parent,t	     root;e  M   status=XQueryTree(display,window,&root,&parent,&children,&number_children);X   if (status == 0)     return((Window) NULL);   type=(Atom) NULL;e   child=(Window) NULL;C   for (i=0; (i < number_children) && (child == (Window) NULL); i++)r   {eG     status=XGetWindowProperty(display,children[i],property,0L,0L,False, G       (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data);      if (data != NULL)n       XFree((void *) data); 5     if ((status == Success) && (type != (Atom) NULL))        child=children[i];   }dC   for (i=0; (i < number_children) && (child == (Window) NULL); i++) :     child=XWindowByProperty(display,children[i],property);"   if (children != (Window *) NULL)     XFree((void *) children);g   return(child); }g