. /* Evaluates the diode nonlinear equations. */ #include <stdio.h> #include <math.h>  #include "simconst.h"6 #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"2 #include "ipstruct.h"6 #include "mstruct.h"   #define ZREV -5.0 $ #define ZCOND 0.00673794699908546650  H /* Note the dc current has a slight twist.  I know that No reasonable */H /* currents over MAXCRNT should exist.  Therefore, if vd exceeds what */: /* generate such a current, a linearized model is used. */ double dccrnt(dptr, vd) 
 double vd; struct diode *dptr;2 {  double id, exp(); !   if(dptr->isat == 0.0) id = 0.0;=9   else if( vd >= dptr->vmax ) /* Linearize after vmax. */1C     id = dptr->imax + (dptr->imax * dptr->nvt) * (vd - dptr->vmax);=&   else if ( vd >= (ZREV / dptr->nvt) )6     id = dptr->isat * ( exp( vd * dptr->nvt ) - 1.0 );0   else if ( dptr->bv == 0.0 || vd >= -dptr->bv) 6 		id = dptr->isat * ( vd * ZCOND * dptr->nvt  - 1.0 );<   else id = ( dptr->isat * ( (dptr->bv/dptr->vt) - 1.0 ) ) -7 			( dptr->isat * exp( -(dptr->bv + vd) / dptr->vt ) ); 
   return(id);= }8  ' /* Dc current and derivatives macro. */  ddccnrt(dptr, vd, pid, pgd)= double vd, *pid, *pgd; struct diode *dptr;  {  double temp, exp(); 3   if(dptr->isat == 0.0) { *pid = 0.0; *pgd = 0.0; }    else if( vd >= dptr->vmax)	{"     *pgd = dptr->imax * dptr->nvt;1     *pid = dptr->imax + *pgd * (vd - dptr->vmax);0   }5)   else if( vd >= ( ZREV / dptr->nvt ) ) { .     temp = dptr->isat * exp( vd * dptr->nvt );     *pid  = temp - dptr->isat;     *pgd  = temp * dptr->nvt;6   } 1   else if ( dptr->bv == 0.0 || vd >= -dptr->bv) { ,       *pgd = dptr->isat * dptr->nvt * ZCOND;<       *pid = dptr->isat * ( vd * ZCOND * dptr->nvt  - 1.0 );   }    else {=       temp = dptr->isat * exp( -(dptr->bv + vd) / dptr->vt );7C       *pid = ( dptr->isat * ( (dptr->bv/dptr->vt) - 1.0 ) ) - temp;        *pgd = temp/dptr->vt;=   }6 }   B /* Just rhs side diode routine with m=0.5 -> sqrt optimization. */- srhsputdiode(dptr, nodevolt, current, charge) $ double *charge, *current, *nodevolt; struct diode *dptr;4 { @ double vd, qd, id, temp1, temp2, log(), exp(), sqrt(), dccrnt();  5   vd = nodevolt[dptr->anode] - nodevolt[dptr->cnode];7   /* Compute dc current */   id = dccrnt(dptr, vd);   /* Compute charge. */2   if(dptr->cjo != 0.0) {     if ( vd < dptr->fcphi ) {0#       temp1 = 1.0 - (vd/dptr->phi); C       temp2 = 1.0/sqrt(temp1);  /* exp( -dptr->m * log(temp1) ); */ D       qd = (dptr->tt * id) + ( dptr->cjp1 * (1 - (temp1 * temp2)) );     } else {*       qd = (dptr->tt * id) + dptr->cjp2 +    	(dptr->cjp3 * (*   	    (dptr->f3 * (vd - dptr->fcphi))  + N        (dptr->m *0.5* ( (vd * vd) - (dptr->fcphi * dptr->fcphi) ) / dptr->phi)	   		 ) );=     } <   /* Put the diode charge and current values the vectors. */     if(dptr->anode > 0) { 9 	current[dptr->anode] += id; charge[dptr->anode] += qd; }.     if(dptr->cnode > 0) {4>       current[dptr->cnode] -= id; charge[dptr->cnode] -= qd; }   } =   else { /* Cjo is zero, so no charge.  Load only current. */ 4     if(dptr->anode > 0) current[dptr->anode] += id; 3     if(dptr->cnode > 0) current[dptr->cnode] -= id;0   }6 }   2 sputdiode(dptr, nodevolt, current, charge, alpha0), double *charge, *current, *nodevolt, alpha0; struct diode *dptr;1 {7> double vd, cd, qd, id, gd, temp1, temp2, log(), exp(), sqrt();  5   vd = nodevolt[dptr->anode] - nodevolt[dptr->cnode];   ( /* Compute dc current and derivatives */   ddccnrt(dptr, vd, &id, &gd);  % /* Compute charge and capacitance. */    if(dptr->cjo != 0.0) {     if ( vd < dptr->fcphi ) {6#       temp1 = 1.0 - (vd/dptr->phi); C       temp2 = 1.0/sqrt(temp1);  /* exp( -dptr->m * log(temp1) ); */ D       qd = (dptr->tt * id) + ( dptr->cjp1 * (1 - (temp1 * temp2)) );1       cd = (dptr->tt * gd) + (dptr->cjo * temp2);=     } else {*       qd = (dptr->tt * id) + dptr->cjp2 +    	(dptr->cjp3 * (*   	    (dptr->f3 * (vd - dptr->fcphi))  + M        (dptr->m*0.5* ( (vd * vd) - (dptr->fcphi * dptr->fcphi) ) / dptr->phi)  		 ) );6       cd = (dptr->tt * gd) + *:   	(dptr->cjp3 * ( dptr->f3 + (dptr->m * vd/dptr->phi) ));     }iM   /* Put the diode currents, charges, conds and caps into matrix and vect. */g     if(dptr->anode > 0) {h+       *(dptr->mataa) += gd + (alpha0 * cd);.!       current[dptr->anode] += id;C        charge[dptr->anode] += qd;       if(dptr->cnode > 0) {h-         *(dptr->matcc) += gd + (alpha0 * cd);e#         current[dptr->cnode] -= id;f"         charge[dptr->cnode] -= qd;-         *(dptr->matac) -= gd + (alpha0 * cd); -         *(dptr->matca) -= gd + (alpha0 * cd);v       }u      } else if(dptr->cnode > 0) {+       *(dptr->matcc) += gd + (alpha0 * cd);c!       current[dptr->cnode] -= id;d        charge[dptr->cnode] -= qd;     }e   }u: /* Otherwise, just stuff the currents and conductances. */   else {     if(dptr->anode > 0) {v       *(dptr->mataa) += gd;e!       current[dptr->anode] += id;        if(dptr->cnode > 0) {e         *(dptr->matcc) += gd; #         current[dptr->cnode] -= id;-         *(dptr->matac) -= gd;;         *(dptr->matca) -= gd;r       })      } else if(dptr->cnode > 0) {       *(dptr->matcc) += gd;d!       current[dptr->cnode] -= id;0     }v   }d }   , rhsputdiode(dptr, nodevolt, current, charge)$ double *charge, *current, *nodevolt; struct diode *dptr;s {e8 double vd, qd, id, temp1, temp2, log(), exp(), dccrnt();  5   vd = nodevolt[dptr->anode] - nodevolt[dptr->cnode];c   /* Compute dc current */   id = dccrnt(dptr, vd);   /* Compute charge. */    if(dptr->cjo != 0.0) {     if ( vd < dptr->fcphi ) {r#       temp1 = 1.0 - (vd/dptr->phi);r+       temp2 = exp( -dptr->m * log(temp1) );>D       qd = (dptr->tt * id) + ( dptr->cjp1 * (1 - (temp1 * temp2)) );     } else {*       qd = (dptr->tt * id) + dptr->cjp2 +    	(dptr->cjp3 * (*   	    (dptr->f3 * (vd - dptr->fcphi))  + M        (dptr->m*0.5* ( (vd * vd) - (dptr->fcphi * dptr->fcphi) ) / dptr->phi)v	   		 ) );n     } <   /* Put the diode charge and current values the vectors. */     if(dptr->anode > 0) { 9 	current[dptr->anode] += id; charge[dptr->anode] += qd; }f     if(dptr->cnode > 0) { >       current[dptr->cnode] -= id; charge[dptr->cnode] -= qd; }   }*=   else { /* Cjo is zero, so no charge.  Load only current. */+4     if(dptr->anode > 0) current[dptr->anode] += id; 3     if(dptr->cnode > 0) current[dptr->cnode] -= id;    }  }=  1 putdiode(dptr, nodevolt, current, charge, alpha0) , double *charge, *current, *nodevolt, alpha0; struct diode *dptr;( {*6 double vd, cd, qd, id, gd, temp1, temp2, log(), exp();  5   vd = nodevolt[dptr->anode] - nodevolt[dptr->cnode];d  ( /* Compute dc current and derivatives */   ddccnrt(dptr, vd, &id, &gd);   % /* Compute charge and capacitance. */c   if(dptr->cjo != 0.0) {     if ( vd < dptr->fcphi ) {+#       temp1 = 1.0 - (vd/dptr->phi);[+       temp2 = exp( -dptr->m * log(temp1) );eD       qd = (dptr->tt * id) + ( dptr->cjp1 * (1 - (temp1 * temp2)) );1       cd = (dptr->tt * gd) + (dptr->cjo * temp2);d     } else {*       qd = (dptr->tt * id) + dptr->cjp2 +    	(dptr->cjp3 * (*   	    (dptr->f3 * (vd - dptr->fcphi))  + N        (dptr->m *0.5* ( (vd * vd) - (dptr->fcphi * dptr->fcphi) ) / dptr->phi)	   		 ) );l       cd = (dptr->tt * gd) + n:   	(dptr->cjp3 * ( dptr->f3 + (dptr->m * vd/dptr->phi) ));     }v9   /* Put the diode values into the matrix and vectors. */v     if(dptr->anode > 0) { +       *(dptr->mataa) += gd + (alpha0 * cd); !       current[dptr->anode] += id;         charge[dptr->anode] += qd;       if(dptr->cnode > 0) {e-         *(dptr->matcc) += gd + (alpha0 * cd);0#         current[dptr->cnode] -= id;-"         charge[dptr->cnode] -= qd;-         *(dptr->matac) -= gd + (alpha0 * cd);r-         *(dptr->matca) -= gd + (alpha0 * cd);,       }g      } else if(dptr->cnode > 0) {+       *(dptr->matcc) += gd + (alpha0 * cd);p!       current[dptr->cnode] -= id;(        charge[dptr->cnode] -= qd;     }a   }p@ /* No charges, so just load up the currents and conductances. */   else {     if(dptr->anode > 0) {        *(dptr->mataa) += gd; !       current[dptr->anode] += id;        if(dptr->cnode > 0) {d         *(dptr->matcc) += gd; #         current[dptr->cnode] -= id;p         *(dptr->matac) -= gd;i         *(dptr->matca) -= gd;        }t     }      else if(dptr->cnode > 0) {       *(dptr->matcc) += gd;e!       current[dptr->cnode] -= id;      }p   }t }7  & dcrhsputdiode(dptr, nodevolt, current) double *current, *nodevolt;  struct diode *dptr;r {t double vd, id, exp(), dccrnt();d  5   vd = nodevolt[dptr->anode] - nodevolt[dptr->cnode];d   /* Compute dc current */   id = dccrnt(dptr, vd);  ' /* Put the diode values the vectors. */(1   if(dptr->anode > 0) current[dptr->anode] += id;l1   if(dptr->cnode > 0) current[dptr->cnode] -= id;  }   # dcputdiode(dptr, nodevolt, current)u double *current, *nodevolt;e struct diode *dptr;a {s double vd, id, gd, exp();-  5   vd = nodevolt[dptr->anode] - nodevolt[dptr->cnode];n  ( /* Compute dc current and derivatives */   ddccnrt(dptr, vd, &id, &gd);  7 /* Put the diode values into the matrix and vectors. */p   if(dptr->anode > 0) {      *(dptr->mataa) += gd;d     current[dptr->anode] += id;i     if(dptr->cnode > 0) {        *(dptr->matcc) += gd;e!       current[dptr->cnode] -= id;d       *(dptr->matac) -= gd;v       *(dptr->matca) -= gd;e     }.   } else if(dptr->cnode > 0) {     *(dptr->matcc) += gd;p     current[dptr->cnode] -= id;)   }d }-  ? /* Diodes are added in a special way.  The list of device	   */rE /* entries for the anode or cnode (whichever is not a user source) */ @ /* to find out if there is a diode of the same model already 	*/D /* in the circuit.  If so, the two diodes are collapsed into one. */ stuffdiode(devptr) struct device *devptr; {g struct deventry *pdevent;d struct diode *dptr, *olddptr;h int nodenum;  )   dptr = (struct diode *) devptr->devptr;n  G   if(dptr->anode == dptr->cnode) return(OKAY); /* Meaningless diode. */l  M /* Get node of diode not connected to a src.  If both are, drop the diode. */;M   if((dptr->anode == 0) || (waves[dptr->anode].present->wavetype==USERSRC)) {      if((dptr->cnode == 0) ||  9        (waves[dptr->cnode].present->wavetype==USERSRC)) {aN           return(OKAY); /* If two nodes of diode on srcs or ground drop it. */     } F     nodenum = dptr->cnode;  /* Search the list of devices on cnode. */   }pH   else nodenum = dptr->anode; /* Search the list of devices on anode. */  M /* Look through the list of devices at  selected node for a matching diode */l-   for(pdevent = devarray[nodenum].deventptr; >. 			pdevent != NULL; pdevent = pdevent->next) {>     if(pdevent->devptr->utype == DIODE) { /* Found a diode. */9       olddptr = (struct diode *) pdevent->devptr->devptr;a  D       if( (dptr->pmodel == olddptr->pmodel) && /* Matched models. */: 	  (dptr->anode == olddptr->anode)   && /* Match anode. */? 	  (dptr->cnode == olddptr->cnode) ) {     /* Matched cnode. */r  D         /* Matched diode. Just pump up the already stuffed diode. */! 	  	olddptr->isat += dptr->isat; ) 		olddptr->cjo +=  dptr->cjo;d,                 olddptr->cjp1 += dptr->cjp1; 		olddptr->cjp2 += dptr->cjp2;,                 olddptr->cjp3 += dptr->cjp3;- 	  	return(OKAY); /* This diode's history. */+       }      }-   }e  = /* Still here?  No diode match then.  Stuff the usual way. */l"   adddevarray(devptr,dptr->anode);"   adddevarray(devptr,dptr->cnode);   return(OKAY);e })    H /* Initialize the diode for simulation.  This includes replacing the  */C /* global node numbers with subcircuit numbers, initializing the */tD /* matrix pointers, and deciding on the functions to evaluate the */ /* diode. */) struct device *initdiode(subptr, extdptr)r struct subcircuit *subptr; struct diode *extdptr; {r struct diode *dptr;d struct device *devptr; double *getmat();o int disdiode();c   /* Allocate the device. */>   devptr = (struct device *) ralloc(1, sizeof(struct device));   devptr->utype = DIODE;<   devptr->devptr = (char *) ralloc(1, sizeof(struct diode));)   dptr = (struct diode *) devptr->devptr;c   /* Copy the external device. */.-   bcopy(dptr, extdptr, sizeof(struct diode));p  , /* Replace global nodes with local nodes. *//   dptr->anode = chksubnode(subptr,dptr->anode);>/   dptr->cnode = chksubnode(subptr,dptr->cnode);-   /* Get the matrix pointers. */7   dptr->mataa = getmat(dptr->anode,dptr->anode,subptr);j7   dptr->matcc = getmat(dptr->cnode,dptr->cnode,subptr); 7   dptr->matac = getmat(dptr->anode,dptr->cnode,subptr);)7   dptr->matca = getmat(dptr->cnode,dptr->anode,subptr);a  ! /* Debugging Display function. *//   devptr->display = disdiode;c  ' /* Get the model evalution routines. */d   if(dcflag == FALSE) {-,     if(dabs(dptr->m - 0.5) < 0.5 * nrvrel) {F            devptr->eval = sputdiode; devptr->rhseval = srhsputdiode; }D     else { devptr->eval = putdiode; devptr->rhseval = rhsputdiode; }   }     F   else { devptr->eval = dcputdiode; devptr->rhseval = dcrhsputdiode; }  ' /* Return the pointer to the device. */l   return(devptr);r }    finishdmod(modptr) struct indmodel *modptr; {  double log(), exp();,   if(modptr->vt == 0.0) modptr->vt = VTHERM;1   modptr->nvt = 1.0 / ( modptr->n * modptr->vt ); +   modptr->isat = modptr->area * modptr->is;c   if(modptr->isat != 0) G 	modptr->vmax = (log((modptr->imax/modptr->isat) + 1.0)) / modptr->nvt;)+   modptr->fcphi = modptr->fc * modptr->phi;.?   modptr->cjp1 = (modptr->cjo * modptr->phi) / (1 - modptr->m);    modptr->cjp2 = modptr->cjp1 : 		   * (1 - exp( (1 - modptr->m) * log(1 - modptr->fc) ));   modptr->cjp3 = e@ 	(modptr->cjo) / (exp( (1 + modptr->m) * log(1 - modptr->fc) ));4   modptr->f3 = 1 - ( modptr->fc * (1 + modptr->m) ); }   1 /* Copy the diode model into the diode device. */u modtodiode(dptr, modelptr) struct diode *dptr;  struct indmodel *modelptr; { #   dptr->pmodel = (char *) modelptr;    dptr->cjo = modelptr->cjo;   dptr->n = modelptr->n;   dptr->m = modelptr->m;   dptr->fc = modelptr->fc;   dptr->phi = modelptr->phi;   dptr->tt = modelptr->tt;   dptr->bv = modelptr->bv;   dptr->vt = modelptr->vt;   dptr->nvt = modelptr->nvt;   dptr->isat = modelptr->isat;    dptr->fcphi = modelptr->fcphi;   dptr->cjp1 = modelptr->cjp1;   dptr->cjp2 = modelptr->cjp2;   dptr->cjp3 = modelptr->cjp3;   dptr->f3 = modelptr->f3;   dptr->vmax = modelptr->vmax;   dptr->imax = modelptr->imax; }o    A struct device *iprd(nextdev,netlist,numparams,paramlist,modelptr)o struct device *nextdev;) int netlist[], numparams;; ip_param paramlist[];h struct indmodel *modelptr; {i struct device *initdiode();e struct diode *dptr;  int stuffdiode();n double area;   /* Allocate the device. */   nextdev->utype = DIODE;p   nextdev->initdev = initdiode;s!   nextdev->stuffdev = stuffdiode;b=   nextdev->devptr = (char *) ralloc(1, sizeof(struct diode));d*   dptr = (struct diode *) nextdev->devptr;E   nextdev->next = (struct device *) ralloc(1, sizeof(struct device));e   nextdev = nextdev->next;   nextdev->next = NULL;      modtodiode(dptr, modelptr);s  ! /* Get the diode node numbers. */-   dptr->anode = netlist[0];    dptr->cnode = netlist[1];o  ' /* Get the area parameter, if given. */*   if(numparams > 0) {n!     area = pareval(paramlist[0]);E'     dptr->isat = (area * modelptr->is);n(     dptr->cjo =  (area * modelptr->cjo);)     dptr->cjp1 = (area * modelptr->cjp1); )     dptr->cjp2 = (area * modelptr->cjp2);e)     dptr->cjp3 = (area * modelptr->cjp3);v     if(dptr->isat != 0.0) N         dptr->vmax = (log((modelptr->imax/dptr->isat) + 1.0)) / modelptr->nvt;   }d   return(nextdev); }m       disdiode(dptr) struct diode *dptr;o {eF   printf("model =%d, anode=%d, cnode=%d\n", dptr->anode, dptr->cnode);M   printf("cjo=%g, cjp1=%g, cjp2=%g, cjp3=%g, f3=%g\n", dptr->cjo, dptr->cjp1,r& 				dptr->cjp2, dptr->cjp3, dptr->f3);C   printf("isat=%g, nvt=%g, vt=%g, tt=%g\n", dptr->isat, dptr->nvt,   							dptr->vt, dptr->tt);mG   printf("fc=%g, fcphi=%g, m=%g, n=%g, bv=%g\n", dptr->fc, dptr->fcphi,>" 						dptr->m, dptr->n, dptr->bv); }	  