> /* The routines in this section solve for the mosfet device */C /* drain current and small signal parameters (e.g. the Jacobian) */d #include <stdio.h> #include <math.h>r #include "simconst.h"m #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"c #include "mstruct.h" #include "ipstruct.h"   ? /* Compute the MOS currents and charges, but no derivatives. */n# rpm1N(fptr, nvolt, current, charge) ! double *current, *charge, *nvolt;e register struct fet1 *fptr;s {i& double vgst, vds, vgs, vbs, justid ();  $ /* Compute the terminal voltages. */6     vds = nvolt[fptr -> dnode] - nvolt[fptr -> snode];E     if (vds < 0.0) { /* If vds < 0.0 swap drain and source  nodes. */=       fet1swapds (fptr);8       vds = nvolt[fptr -> dnode] - nvolt[fptr -> snode];     }!6     vgs = nvolt[fptr -> gnode] - nvolt[fptr -> snode];6     vbs = nvolt[fptr -> bnode] - nvolt[fptr -> snode];    /* Compute the drain current. */K     vgst = justid (fptr, vgs, vbs, vds, current, fptr->dnode, fptr->snode);(+ /* Compute the gate charge if necessary. */ F     if (fptr -> cox != 0.0) justq (fptr, vgs, vbs, vds, vgst, charge); }p  , /* PMOS case. Notice everything inverted. */# rpm1P(fptr, nvolt, current, charge)u! double *charge, *current, *nvolt;( register struct fet1 *fptr;  { % double vgst, vds, vbs, vgs, justid(); 0   vds = nvolt[fptr->snode] - nvolt[fptr->dnode];B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */     fet1swapds(fptr);a2     vds = nvolt[fptr->snode] - nvolt[fptr->dnode];   }r2   vbs = (nvolt[fptr->snode] - nvolt[fptr->bnode]);2   vgs = (nvolt[fptr->snode] - nvolt[fptr->gnode]);  /* Compute the drain current. */H   vgst = justid(fptr, vgs, vbs, vds, current, fptr->snode, fptr->dnode); /* Compute the gate charge. */@   if(fptr->cox != 0.0) justq(fptr, vgs, vbs, vds, vgst, charge); }z   /* NMOS case. */, putm1N(fptr, nvolt, current, charge, alpha0)) double *charge, *current, *nvolt, alpha0;H register struct fet1 *fptr;  {r/ double vds, vgs, vbs, vgst, ndvtdvbs, compid();   0   vds = nvolt[fptr->dnode] - nvolt[fptr->snode];B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      fet1swapds(fptr);3      vds = nvolt[fptr->dnode] - nvolt[fptr->snode];s   }d0   vgs = nvolt[fptr->gnode] - nvolt[fptr->snode];0   vbs = nvolt[fptr->bnode] - nvolt[fptr->snode];  9   vgst = compid(fptr, vgs, vbs, vds, &ndvtdvbs, current);      if(fptr->cox != 0.0) {8     compq(fptr,vgs,vbs,vds,vgst,ndvtdvbs,charge,alpha0);   })   }o    . /* PMOS case, Notice everything is inverted */, putm1P(fptr, nvolt, current, charge, alpha0)) double *charge, *current, *nvolt, alpha0;  struct fet1 *fptr; {s, double vds,vbs,vgs,vgst, ndvtdvbs, compid();  0   vds = nvolt[fptr->snode] - nvolt[fptr->dnode];B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      fet1swapds(fptr);3      vds = nvolt[fptr->snode] - nvolt[fptr->dnode];    } 2   vbs = (nvolt[fptr->snode] - nvolt[fptr->bnode]);2   vgs = (nvolt[fptr->snode] - nvolt[fptr->gnode]);  9   vgst = compid(fptr, vgs, vbs, vds, &ndvtdvbs, current);,K   if(fptr->cox != 0.0) compq(fptr,vgs,vbs,vds,vgst,ndvtdvbs,charge,alpha0);p }!   dcrpm1N(fptr, nvolt, current)t double *current, *nvolt; register struct fet1 *fptr;  {  double vds, vbs, vgs, justid();e  0   vds = nvolt[fptr->dnode] - nvolt[fptr->snode];B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */     fet1swapds(fptr);P2     vds = nvolt[fptr->dnode] - nvolt[fptr->snode];   } 0   vbs = nvolt[fptr->bnode] - nvolt[fptr->snode];0   vgs = nvolt[fptr->gnode] - nvolt[fptr->snode];A   justid(fptr, vgs, vbs, vds, current, fptr->dnode, fptr->snode);r }f  , /* PMOS case. Notice everything inverted. */ dcrpm1P(fptr, nvolt, current)L double *current, *nvolt; register struct fet1 *fptr;1 {  double vgs, vbs, vds, justid();   0   vds = nvolt[fptr->snode] - nvolt[fptr->dnode];B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */     fet1swapds(fptr);m2     vds = nvolt[fptr->snode] - nvolt[fptr->dnode];   } 2   vbs = (nvolt[fptr->snode] - nvolt[fptr->bnode]);0   vgs = (nvolt[fptr->snode]-nvolt[fptr->gnode]);A   justid(fptr, vgs, vbs, vds, current, fptr->snode, fptr->dnode);J }b   /* NMOS case. */ dcptm1N(fptr, nvolt, current)i double *current, *nvolt; register struct fet1 *fptr;" {g% double vgs,vds,vbs,ndvtdvbs,compid();e  0   vds = nvolt[fptr->dnode] - nvolt[fptr->snode];B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      fet1swapds(fptr);3      vds = nvolt[fptr->dnode] - nvolt[fptr->snode];e   }p0   vbs = nvolt[fptr->bnode] - nvolt[fptr->snode];0   vgs = nvolt[fptr->gnode] - nvolt[fptr->snode];  2   compid(fptr, vgs, vbs, vds, &ndvtdvbs, current); }a    . /* PMOS case, Notice everything is inverted */ dcptm1P(fptr, nvolt, current)l double *current, *nvolt; struct fet1 *fptr; {l) double vgs, vds, vbs, ndvtdvbs, compid();g  0   vds = nvolt[fptr->snode] - nvolt[fptr->dnode];B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      fet1swapds(fptr);3      vds = nvolt[fptr->snode] - nvolt[fptr->dnode];r   }/2   vbs = (nvolt[fptr->snode] - nvolt[fptr->bnode]);2   vgs = (nvolt[fptr->snode] - nvolt[fptr->gnode]);2   compid(fptr, vgs, vbs, vds, &ndvtdvbs, current); };  G /* Routine for swapping drain and source node when vds changes sign. */  fet1swapds(fptr) struct fet1 *fptr; {  int tmp; double *ptmpd;A  tmp = fptr->dnode; fptr->dnode = fptr->snode; fptr->snode = tmp; E  ptmpd = fptr->matdd; fptr->matdd = fptr->matss; fptr->matss = ptmpd;eE  ptmpd = fptr->matds; fptr->matds = fptr->matsd; fptr->matsd = ptmpd;vE  ptmpd = fptr->matdg; fptr->matdg = fptr->matsg; fptr->matsg = ptmpd;dE  ptmpd = fptr->matdb; fptr->matdb = fptr->matsb; fptr->matsb = ptmpd;rE  ptmpd = fptr->matgs; fptr->matgs = fptr->matgd; fptr->matgd = ptmpd;uE  ptmpd = fptr->matbs; fptr->matbs = fptr->matbd; fptr->matbd = ptmpd;< }     3 /* Routine for computing just the drain current. */ 9 double justid(fptr, vgs, vbs, vds, current, dnode, snode)t struct fet1 *fptr; double vgs, vbs, vds, *current;f int dnode, snode;  {v double vgst, id;&   if(vbs==0.0) vgst = vgs - fptr->vto;   else {     vgst = fptr->phi - vbs;>B     if(vgst < nrvabs) vgst = sqrt(nrvabs); else vgst = sqrt(vgst);7     vgst = vgs - (fptr->fixvto + (fptr->gamma * vgst));t   }r /* Compute drain current. */%   if(vgst > 0.0 ) { /* Not cutoff. */l     if(vgst < vds)G         id = 0.5 * fptr->beta * vgst * vgst * (1.0 + fptr->lambda*vds);eG     else id = fptr->beta*vds*(vgst - 0.5*vds)*(1.0 + fptr->lambda*vds);f<     if(dnode > 0) current[dnode] += id;  /* load up crnt. */'     if(snode > 0) current[snode] -= id;l   }r   return(vgst);t }f  * /* Routine to compute just the charges. */( justq(fptr, vgs, vbs, vds, vgst, charge) register struct fet1 *fptr;b$ double vgs, vbs, vds, vgst, *charge; {1 double qg, temp1;e  +   if(vgst < 0.0) { /* Subthresh or Accum */l2     if( (fptr->gnode > 0) || (fptr->bnode > 0) ) {       temp1 = vgs - vbs;J       if(((fptr->gamma>0.0)&&(temp1 >= fptr->vfb)) || (temp1<fptr->vfb)) {C         if(temp1 < fptr->vfb) qg = fptr->cox * (temp1 - fptr->vfb);s1         else qg = 0.5 * fptr->gamma * fptr->cox */E           ( sqrt(fptr->gamma * fptr->gamma + 4.0*(temp1 - fptr->vfb))  						        - fptr->gamma );E           if(fptr->gnode > 0) charge[fptr->gnode] += fptr->type * qg;pE           if(fptr->bnode > 0) charge[fptr->bnode] -= fptr->type * qg;n	         }t     }>   }e0   else if(vgst < vds) { /* Saturation region. */=       if(fptr->snode > 0) charge[fptr->snode] -= fptr->type *  			fptr->cox * vgst/1.5;=       if(fptr->gnode > 0) charge[fptr->gnode] += fptr->type * / 			fptr->cox * (vgs - fptr->fixvto - vgst/3.0); =       if(fptr->bnode > 0) charge[fptr->bnode] += fptr->type *e+ 			fptr->cox * (vgst - vgs + fptr->fixvto);c   }t   else { /* Linear Region. */r8       temp1 = (vds * vds) / (vgst + vgst - vds + 1e-12);=       if(fptr->snode > 0) charge[fptr->snode] += fptr->type *o@          fptr->cox * ( (temp1/12.0) - (0.25*vds) - (0.5*vgst) );=       if(fptr->gnode > 0) charge[fptr->gnode] += fptr->type *rF          fptr->cox * ( vgs - fptr->fixvto - (0.5*vds) + (temp1/6.0) );=       if(fptr->dnode > 0) charge[fptr->dnode] += fptr->type *d9 	 fptr->cox * ( (0.75*vds) - (0.5*vgst) - (0.25*temp1) );r=       if(fptr->bnode > 0) charge[fptr->bnode] += fptr->type *e- 	    fptr->cox * (vgst - vgs + fptr->fixvto);s   }t }v    B /* Routine for computing the drain current and its derivatives. */1 double compid(fptr,vgs,vbs,vds,pndvtdvbs,current)t register struct fet1 *fptr;s+ double vgs, vbs, vds, *pndvtdvbs, *current;  {t( double id,vgst, gmgs,gmbs,gmds,ndvtdvbs;  $ /* Threshold voltage computation. */   if(vbs == 0.0) {     vgst = vgs - fptr->vto; =     ndvtdvbs = fptr->gamma / (fptr->sqrtphi + fptr->sqrtphi);s
   } else {     ndvtdvbs = fptr->phi - vbs;      if(ndvtdvbs < nrvabs) {uA       vgst = vgs - (fptr->fixvto + (fptr->gamma * sqrt(nrvabs)));        ndvtdvbs = 0.0;]     } else {!       ndvtdvbs =  sqrt(ndvtdvbs);v=       vgst = vgs - (fptr->fixvto + (fptr->gamma * ndvtdvbs));;5       ndvtdvbs = fptr->gamma / (ndvtdvbs + ndvtdvbs);      }    }o   *pndvtdvbs = ndvtdvbs;    /* Compute the drain current. */B   if( ((fptr->dnode > 0) || (fptr->snode > 0)) && (vgst > 0.0 )) {&     if(vgst < vds) { /* Saturation. */=       gmgs =  fptr->beta * (1 + (fptr->lambda * vds)) * vgst;m       id = 0.5 * gmgs * vgst;u       gmbs = ndvtdvbs * gmgs;f;       gmds = 0.5 * fptr->beta * vgst * vgst * fptr->lambda;      }      else {  /* Linear region */ 4       gmgs =  fptr->beta * (1 + fptr->lambda * vds);,       id = gmgs * vds * (vgst - 0.50 * vds);$       gmds = (gmgs * (vgst - vds)) +< 	    (fptr->beta * fptr->lambda * vds * (vgst - 0.5 * vds));       gmgs *= vds;       gmbs = ndvtdvbs * gmgs;p     }mB     if(fptr->dnode > 0) { /* Put the drain row into the matrix. */       *(fptr->matdd) += gmds;o.       current[fptr->dnode] += fptr->type * id;/       if(fptr->bnode>0) *(fptr->matdb) += gmbs; /       if(fptr->gnode>0) *(fptr->matdg) += gmgs;>;       if(fptr->snode>0) *(fptr->matds) -= (gmgs+gmbs+gmds);/     } C     if(fptr->snode > 0) { /* Put the source row into the matrix. */-+       *(fptr->matss) += gmds + gmbs + gmgs; .       current[fptr->snode] -= fptr->type * id;/       if(fptr->bnode>0) *(fptr->matsb) -= gmbs;x/       if(fptr->gnode>0) *(fptr->matsg) -= gmgs; /       if(fptr->dnode>0) *(fptr->matsd) -= gmds;2     }    }f   return(vgst);h }e  3 compq(fptr,vgs,vbs,vds,vgst,ndvtdvbs,charge,alpha0)( struct fet1 *fptr;6 double vgs, vbs, vds, vgst, ndvtdvbs, alpha0, *charge; {-0 double qg, dqdvds, dqdvgst, temp1, temp2, temp3;  4   if(vgst < 0.0) { /* Subthresh or Accum region.  */2     if( (fptr->gnode > 0) || (fptr->bnode > 0) ) {+       temp1 = vgs - vbs; /* compute vgb. */ J       if(((fptr->gamma>0.0)&&(temp1 >= fptr->vfb)) || (temp1<fptr->vfb)) {7         if(temp1 <= fptr->vfb) {    /* Accumulation. */t<           qg = fptr->type * fptr->cox * (temp1 - fptr->vfb);%           temp1 = fptr->cox * alpha0;v	         }t&         else {		      /* Subthresh. */L           temp1 = sqrt(fptr->gamma * fptr->gamma + 4.0*(temp1 - fptr->vfb));           qg = fptr->type * 8 		0.5 * fptr->gamma * fptr->cox * (temp1 - fptr->gamma);=           temp1 = (alpha0 * fptr->gamma * fptr->cox) / temp1;h	         }q         if(fptr->gnode > 0) {v=           charge[fptr->gnode] += qg; *(fptr->matgg) += temp1;t           if(fptr->bnode > 0) {aB               charge[fptr->bnode] -= qg;  *(fptr->matbb) += temp1;?               *(fptr->matgb) -= temp1; *(fptr->matbg) -= temp1;(           } 	         };D         else { charge[fptr->bnode] -= qg; *(fptr->matbb) += temp1; }       }t     }e   }v  0   else if(vgst < vds) { /* Saturation region. */       temp1 = fptr->cox/1.5;       temp2 = alpha0 * temp1;c.       if(fptr->gnode > 0) { /* Gate charge. */+         charge[fptr->gnode] += fptr->type *1/ 			fptr->cox*(vgs - fptr->fixvto - (vgst/3.0));o          *(fptr->matgg) += temp2;A         if(fptr->bnode > 0) *(fptr->matgb) -= 0.5*temp2*ndvtdvbs;dI         if(fptr->snode > 0) *(fptr->matgs) += 0.5*temp2*ndvtdvbs - temp2;p       }        if(fptr->snode > 0) {p;         charge[fptr->snode] -= fptr->type * (temp1 * vgst);-5         *(fptr->matss) += (temp2 + temp2 * ndvtdvbs);p4         if(fptr->gnode > 0) *(fptr->matsg) -= temp2;A         if(fptr->bnode > 0) *(fptr->matsb) -= (temp2 * ndvtdvbs);m       }r       if(fptr->bnode > 0) {m+         charge[fptr->bnode] += fptr->type *i* 		fptr->cox * (vgst - vgs + fptr->fixvto);1         *(fptr->matbb) += 1.5 * temp2 * ndvtdvbs;uE         if(fptr->snode > 0) *(fptr->matbs) -= 1.5 * temp2 * ndvtdvbs;v       }	     };      else { /* Linear Region. */	0       temp1 = 1.0 / (vgst + vgst - vds + 1e-12);       temp2 = temp1*temp1*vds;       temp3 = vds*vds*temp1;!       temp1 = alpha0 * fptr->cox;+.       if(fptr->gnode > 0) { /* Gate charge. */+         charge[fptr->gnode] += fptr->type *f@ 	   fptr->cox * (vgs - fptr->fixvto - (0.5*vds) + (temp3/6.0) );:         dqdvds = temp1*((temp2*(4.0*vgst-vds)/6.0) - 0.5);)         dqdvgst = -temp1*(vds*temp2/3.0);d,         *(fptr->matgg) += (temp1 + dqdvgst);5         if(fptr->dnode > 0) *(fptr->matgd) += dqdvds;bA         if(fptr->bnode > 0) *(fptr->matgb) += dqdvgst * ndvtdvbs; -         if(fptr->snode > 0) *(fptr->matgs) -=v/ 			(temp1 + dqdvds + dqdvgst*(1.0 + ndvtdvbs));r       }(/       if(fptr->dnode > 0) { /* Drain charge. */5+         charge[fptr->dnode] += fptr->type *s9 		fptr->cox * ( (0.75*vds) - (0.5*vgst) - (0.25*temp3) );bB         dqdvds = temp1 * ( 0.75 - 0.25 * (temp2*(4.0*vgst-vds)) );0         dqdvgst = temp1 * (0.5*vds*temp2 - 0.5);!         *(fptr->matdd) += dqdvds; L         if(fptr->snode > 0) *(fptr->matds) -= dqdvds+dqdvgst*(1.0+ndvtdvbs);6         if(fptr->gnode > 0) *(fptr->matdg) += dqdvgst;A         if(fptr->bnode > 0) *(fptr->matdb) += dqdvgst * ndvtdvbs;r       }g0       if(fptr->snode > 0) { /* Source charge. */+         charge[fptr->snode] += fptr->type *f@ 	    fptr->cox * ( (temp3/12.0) - (0.25 * vds) - (0.5 * vgst) );@         dqdvds = temp1 * ( (temp2*(4.0*vgst-vds)/12.0) - 0.25 );4         dqdvgst = temp1 * ( (vds*temp2)/6.0 - 0.5 );<         *(fptr->matss) -= dqdvgst*(1.0 + ndvtdvbs) + dqdvds;6         if(fptr->gnode > 0) *(fptr->matsg) += dqdvgst;5         if(fptr->dnode > 0) *(fptr->matsd) += dqdvds;-A         if(fptr->bnode > 0) *(fptr->matsb) += dqdvgst * ndvtdvbs;t       }1.       if(fptr->bnode > 0) { /* Bulk charge. */+         charge[fptr->bnode] += fptr->type * * 		fptr->cox * (vgst - vgs + fptr->fixvto);,         *(fptr->matbb) +=  temp1 * ndvtdvbs;?         if(fptr->snode > 0) *(fptr->matbs) -= temp1 * ndvtdvbs;f       }e    } }    stuffm1(devptr)- struct device *devptr; {m struct fet1 *fptr; double temp;  (   fptr = (struct fet1 *) devptr->devptr;  #   adddevarray(devptr, fptr->dnode);e  B   if(fptr->gnode != fptr->dnode) adddevarray(devptr, fptr->gnode);  &   if( (fptr->snode != fptr->dnode) && G       (fptr->snode != fptr->gnode) )  adddevarray(devptr, fptr->snode);   &   if( (fptr->bnode != fptr->dnode) && %       (fptr->bnode != fptr->gnode) &&fG       (fptr->bnode != fptr->snode) )  adddevarray(devptr, fptr->bnode);    }   F /* Initialize the fet for simulation.  This includes converting the */F /* node numbers, deciding the evaluation function, and initializing */ /* the matrix pointers. */( struct device *fet1init(subptr, extfptr) struct fet1 *extfptr;r struct subcircuit *subptr; {f struct device *devptr; struct fet1 *fptr; double *getmat();  int j, disfet1();=  C /* Only copy the FET model if it has more than a gate in subckt. */d" /* or cox is not equal to zero. */1   if( (extfptr->cox == 0.0) || (dcflag == TRUE) )0/     if( (nomapchk(subptr,extfptr->snode) <= 0) o: 	&& (nomapchk(subptr,extfptr->dnode) <= 0) ) return(NULL);  H /* Otherwise allocate a device, copy the external fet, map the nodes. */>   devptr = (struct device *) ralloc(1, sizeof(struct device));   devptr->utype = FET1;-;   devptr->devptr = (char *) ralloc(1, sizeof(struct fet1));g(   fptr = (struct fet1 *) devptr->devptr;  - /* Copy the external fet to the local fet. */ ,    bcopy(fptr, extfptr,sizeof(struct fet1));  L /* Do the node conversion from global node numbers to subcircuit numbers. *//   fptr->dnode = chksubnode(subptr,fptr->dnode);;/   fptr->snode = chksubnode(subptr,fptr->snode);s/   fptr->gnode = chksubnode(subptr,fptr->gnode);d/   fptr->bnode = chksubnode(subptr,fptr->bnode);)  ! /* Debugging Display function. */]   devptr->display = disfet1;  ( /* Decide on the evaluation function. */   if(fptr->type == NMOS) {K     if(dcflag == FALSE) { devptr->eval = putm1N; devptr->rhseval = rpm1N; })?     else { devptr->eval = dcptm1N; devptr->rhseval = dcrpm1N; }t   }t	   else {  K     if(dcflag == FALSE) { devptr->eval = putm1P; devptr->rhseval = rpm1P; }r?     else { devptr->eval = dcptm1P; devptr->rhseval = dcrpm1P; }    }f% /* Initialize the matrix pointers. */ 7   fptr->matdd = getmat(fptr->dnode,fptr->dnode,subptr); 7   fptr->matdg = getmat(fptr->dnode,fptr->gnode,subptr);s7   fptr->matds = getmat(fptr->dnode,fptr->snode,subptr);s7   fptr->matdb = getmat(fptr->dnode,fptr->bnode,subptr);q  7   fptr->matss = getmat(fptr->snode,fptr->snode,subptr);)7   fptr->matsd = getmat(fptr->snode,fptr->dnode,subptr);e7   fptr->matsg = getmat(fptr->snode,fptr->gnode,subptr);/7   fptr->matsb = getmat(fptr->snode,fptr->bnode,subptr);=  /   if( (fptr->cox != 0) && (dcflag == FALSE) ) {m9     fptr->matgg = getmat(fptr->gnode,fptr->gnode,subptr);f9     fptr->matgs = getmat(fptr->gnode,fptr->snode,subptr);p9     fptr->matgd = getmat(fptr->gnode,fptr->dnode,subptr); 9     fptr->matgb = getmat(fptr->gnode,fptr->bnode,subptr);-  9     fptr->matbb = getmat(fptr->bnode,fptr->bnode,subptr);-9     fptr->matbg = getmat(fptr->bnode,fptr->gnode,subptr);;9     fptr->matbs = getmat(fptr->bnode,fptr->snode,subptr); 9     fptr->matbd = getmat(fptr->bnode,fptr->dnode,subptr);v   }      return(devptr);t }s   finishmod1(modptr) struct inm1model *modptr;f {- double sqrt();&   modptr->sqrtphi = sqrt(modptr->phi);0   if(modptr->type == PMOS) modptr->vto *= -1.0; C   modptr->fixvto = modptr->vto - (modptr->gamma * modptr->sqrtphi); -   modptr->vfb = modptr->fixvto - modptr->phi;  }    m1m2i(fetptr,modelptr) struct inm1model *modelptr;n struct fet1 *fetptr; {n    fetptr->type = modelptr->type;%   fetptr->pmodel = (char *) modelptr;t$   fetptr->length = modelptr->length;"   fetptr->width = modelptr->width;   fetptr->vto = modelptr->vto;"   fetptr->gamma = modelptr->gamma;   fetptr->phi = modelptr->phi;$   fetptr->lambda = modelptr->lambda;&   fetptr->sqrtphi = modelptr->sqrtphi;$   fetptr->fixvto = modelptr->fixvto;   fetptr->vfb = modelptr->vfb;E   fetptr->beta = ( modelptr->kp * (fetptr->width / fetptr->length) );s }/    B struct device *iprm1(nextdev,netlist,numparams,paramlist,modelptr) struct device *nextdev;) int netlist[], numparams;o ip_param paramlist[];d struct inm1model *modelptr;s {t3 struct device *fet1init(), *initlcap(), **lpdevptr;] struct fet1 *fptr; struct lcap *cptr;' int tempint, i, stuffm1(), stufflcap();f double as,ad,ps,pd,cox,tempd;f   /* Allocate the device. */   nextdev->utype = FET1;   nextdev->initdev = fet1init;   nextdev->stuffdev = stuffm1;<   nextdev->devptr = (char *) ralloc(1, sizeof(struct fet1));)   fptr = (struct fet1 *) nextdev->devptr; E   nextdev->next = (struct device *) ralloc(1, sizeof(struct device));    nextdev = nextdev->next;   nextdev->next = NULL;a  A   m1m2i(fptr,modelptr);  /* Copy the model params to instance. */t   /* Get the node numbers. */)   fptr->dnode = netlist[0];t   fptr->gnode = netlist[1];s   fptr->snode = netlist[2];-   fptr->bnode = netlist[3];   = /* Get the length, width, as, ad, ps, pd params, if given. */r    for(i=0; i < numparams; i++) {      switch(paramlist[i].id[0]) {=       case 'a'  : fptr->width = pareval(paramlist[i]); break;t>       case 'b'  : fptr->length = pareval(paramlist[i]); break;4       case 'c'  : as = pareval(paramlist[i]); break;4       case 'd'  : ad = pareval(paramlist[i]); break;4       case 'e'  : ps = pareval(paramlist[i]); break;4       case 'f'  : pd = pareval(paramlist[i]); break;E       default   : printf("Nonexist param spec'ed for m1\n"); exit(0);m     }-   }e   /* Precompute Beta. */   if(fptr->length > FUZZ) 9 		fptr->beta = modelptr->kp * fptr->width / fptr->length;-  5 /* Precompute the capacitance for the meyer model. */t   if(modelptr->tox != 0.0) {I     tempd = (fptr->width * fptr->length) * (EOX * 100.0) / modelptr->tox;o     fptr->cox = tempd; ;   }o   else fptr->cox =0.0;  - /* Generate the linear overlap capacitors. */o	 /* CGS */ ?   if( (modelptr->cgso != 0) && (fptr->snode != fptr->gnode) ) {)     nextdev->utype = LCAP;      nextdev->initdev = initlcap;"     nextdev->stuffdev = stufflcap;>     nextdev->devptr = (char *) ralloc(1, sizeof(struct lcap));+     cptr = (struct lcap *) nextdev->devptr;sG     nextdev->next = (struct device *) ralloc(1, sizeof(struct device));      nextdev = nextdev->next;     nextdev->next = NULL;      cptr->node1 = fptr->gnode;     cptr->node2 = fptr->snode;.     cptr->capval = modelptr->cgso*fptr->width;   }m
 /* CGDO */?   if( (modelptr->cgdo != 0) && (fptr->dnode != fptr->gnode) ) {s     nextdev->utype = LCAP;      nextdev->initdev = initlcap;"     nextdev->stuffdev = stufflcap;>     nextdev->devptr = (char *) ralloc(1, sizeof(struct lcap));+     cptr = (struct lcap *) nextdev->devptr;eG     nextdev->next = (struct device *) ralloc(1, sizeof(struct device));!     nextdev = nextdev->next;     nextdev->next = NULL;      cptr->node1 = fptr->gnode;     cptr->node2 = fptr->dnode;.     cptr->capval = modelptr->cgdo*fptr->width;   } 
 /* CGBO */?   if( (modelptr->cgbo != 0) && (fptr->bnode != fptr->gnode) ) {      nextdev->utype = LCAP;      nextdev->initdev = initlcap;"     nextdev->stuffdev = stufflcap;>     nextdev->devptr = (char *) ralloc(1, sizeof(struct lcap));+     cptr = (struct lcap *) nextdev->devptr; G     nextdev->next = (struct device *) ralloc(1, sizeof(struct device));d     nextdev = nextdev->next;     nextdev->next = NULL;n     cptr->node1 = fptr->gnode;     cptr->node2 = fptr->bnode;/     cptr->capval = modelptr->cgbo*fptr->length;t   }o: /* Return the pointer to the pointer to the next entry. */   return(nextdev); })     disfet1(fetptr)o struct fet1 *fetptr; {t%   printf("d=%d, g=%d, s=%d, b=%d\n", p: 	fetptr->dnode,fetptr->gnode,fetptr->snode,fetptr->bnode);)   printf("type=%d,d=%d,g=%d,s=%d,b=%d ", eL      fetptr->type,fetptr->dnode,fetptr->gnode, fetptr->snode,fetptr->bnode);*   printf("l=%g, w=%g, beta=%g, vto=%g\n", < 		fetptr->length, fetptr->width, fetptr->beta, fetptr->vto);*   printf("fixvto = %g  ", fetptr->fixvto);&   printf("beta = %g\n", fetptr->beta);(   printf("gamma = %g  ", fetptr->gamma);$   printf("phi = %g  ", fetptr->phi);*   printf("lambda = %g  ", fetptr->lambda);,   printf("sqrtphi = %g\n", fetptr->sqrtphi);$   printf("cox = %g\n", fetptr->cox); }t