 #include "ipintern.h"o   char *ip_call_id();t char *eval_expr(); char *sprintf();   extern cell_def *ip_root_def;p extern int ip_num_globals;   static int *global_values; static int offset; static sm_desc *flat_stack;a int ip_num_nets = 0;   ip_flatten() {i
     int i;       offset = 0;n       flat_stack = sm_init(0);       global_values = B 	(int *) sm_alloc(flat_stack,ip_root_def->num_locals*sizeof(int));  2     for(i = 0; i < ip_root_def->num_locals; i++) { 	global_values[i] = offset++;n     }l5     do_flatten(ip_root_def, nil(int), nil(ip_param));b     ip_num_nets = offset;w     sm_release_all(flat_stack);  }u  . static do_flatten(def, net_stack, param_stack) cell_def *def; int net_stack[]; ip_param param_stack[];  { 
     int i;       if (def->flags & OPEN) {C 	ip_error(ERR_FATAL, "Recursive cell call loop found involving %s",f 	    def->name); 	return;     }i       def->flags |= OPEN;   )     for(i = 0; i < def->num_cells; i++) {e. 	flatten_call(def, i, net_stack, param_stack);     }r       def->flags &= ~OPEN; }e  C static flatten_call(super_def, call_number, net_stack, param_stack). cell_def *super_def; int call_number; int *net_stack;i ip_param *param_stack; {/
     int j;     int *ptr, *sub_net_stack;i     char *retval;o     cell_def *def;     cell_call *call;=     ip_param *actual, *formal, *end, *copy, *sub_param_stack;I  (     call = super_def->body[call_number];       def = call->master_def;   -     if (call->num_args != def->num_formals) {  	ip_error(ERR_FATAL,> 	    "%s:Wrong number of arguments to %s at subcell %d of %s",A 	    super_def->file, def->name, call_number+1, super_def->name);a 	return;     }   6     ptr = sub_net_stack = (int *) sm_alloc(flat_stack,1 	(def->num_locals+def->num_formals)*sizeof(int));   ,     for (j = 0; j < def->num_formals; j++) {: 	*ptr++ =  rel_to_global(call->net_indices[j], net_stack);     }   +     for (j = 0; j < def->num_locals; j++) {  	*ptr++ = offset++;=     }        if (def->flags & MODEL) {( 	copy = sub_param_stack = I 	    (ip_param *)sm_alloc(flat_stack, call->num_params*sizeof(ip_param));t 	actual = call->params;{( 	for(j = 0; j < call->num_params; j++) { 	    copy->name = actual->name;  	    copy->id = actual->id;p/ 	    if (actual->value->type == IP_PARAMETER) {a) 		    /* evaluate the formal parameter */r
 		copy->valuei: 		    = param_stack[actual->value->val.parameter-1].value;1 	    } else if (actual->value->type == IP_EXPR) {e
 		retval =6 		    eval_expr(actual->value->val.pexpr, param_stack, 			    &copy->value);e 		if (retval != nil(char)) {< 		    ip_error(ERR_FATAL, "%s: %s.%s : %s", super_def->file,9 			super_def->name, ip_call_id(call_number, call->label),b 			retval);, 		}i
 	    } else {e 		copy->value = actual->value; 	    } 	    copy++;actual++;n 	}C 	retval = ip_instantiate_primitive(def->model_ident, sub_net_stack,o8 	    call->num_params, sub_param_stack, &call->call_id); 	if (retval != nil(char)) {i; 	    ip_error(ERR_FATAL, "%s: %s.%s : %s", super_def->file,rA 		super_def->name, ip_call_id(call_number, call->label), retval);r 	}     } else { 	copy = sub_param_stack = H 	    (ip_param *)sm_alloc(flat_stack, def->num_params*sizeof(ip_param)); 	actual = call->params; ! 	end = actual + call->num_params;  	formal = def->params;  ' 	for(j = 0; j < def->num_params; j++) {> 	    copy->name = formal->name;< 	    copy->id = formal->id;n8 	    if (actual < end && actual->name == formal->name) {, 		if (actual->value->type == IP_PARAMETER) {& 			/* evaluate the formal parameter */ 		    copy->value = 5 			param_stack[actual->value->val.parameter-1].value;c. 		} else if (actual->value->type == IP_EXPR) { 		    retval =3 			eval_expr(actual->value->val.pexpr, param_stack,; 				&copy->value);  		    if (retval != nil(char)) {9 			ip_error(ERR_FATAL, "%s: %s.%s : %s", super_def->file,r 			    super_def->name, 5 			    ip_call_id(call_number, call->label), retval);i 		    }s
 		} else {" 		    copy->value = actual->value; 		}k 		actual++;s
 	    } else {o 		copy->value = formal->value; 	    } 	    copy++; formal++; 	}   	if (actual != end) {;G 	    ip_error(ERR_PANIC, "do_flatten: parameter %s not found in stack",l 		actual->name); 	    exit(-1); 	}  1 	do_flatten(def, sub_net_stack, sub_param_stack);        }t  1     sm_free(flat_stack,(char *) sub_param_stack);=/     sm_free(flat_stack,(char *) sub_net_stack);l }l  " static rel_to_global(index, stack)
 int index; int *stack;z {(     if (index < 0) {" 	return global_values[-index - 1];     } else {* 	return stack[index - ip_num_globals - 1];     }s }l   static char ev_buf[40];a  % char * eval_expr(cexp, stack, pvalue)> char *cexp;r ip_param *stack; ip_pvalue **pvalue;  {c     expr *exp;       exp = (expr *) cexp;       *pvalue = new(ip_pvalue);l      (*pvalue)->type = IP_NUMBER;>     if (!do_eval_expr(exp, stack, &((*pvalue)->val.number))) { 	return ev_buf;l     } else { 	return nil(char);     }e }   & static do_eval_expr(exp, stack, value)
 expr *exp; ip_param *stack; double *value; {r     ip_param *param;     double left, right;e       if (exp == nil(expr)) {e 	*value = 0;
 	return 1;     }        switch (exp->op) {     case IP_PARAMETER :l 	param =8 	    &stack[((ip_pvalue *) exp->left)->val.parameter-1];' 	if (param->value->type == IP_NUMBER) {p' 	    *value = param->value->val.number;a 	    return 1;- 	} else if (param->value->type == IP_UNDEF) {p 	    sprintf(ev_buf,> 		"The parameter %s is used, but no value was assigned to it", 		param->name);s 	    return 0;	 	} else {rD 	    sprintf(ev_buf, "PANIC, unexpected type of %d to do_eval_expr", 		param->value->type); 	    return 0; 	}     case IP_NUMBER :0 	*value = ((ip_pvalue *) exp->left)->val.number;
 	return 1;
     default : . 	if (!do_eval_expr(exp->left, stack, &left)) { 	    return 0; 	}0 	if (!do_eval_expr(exp->right, stack, &right)) { 	    return 0; 	} 	switch (exp->op) {m 	case '-' :  	    *value = left - right;n 	    return 1; 	case '+' :( 	    *value = left + right;A 	    return 1; 	case '*' :f 	    *value = left * right;y 	    return 1; 	case '/' :t 	    *value = left / right;v 	    return 1;
 	default : 	    sprintf(ev_buf,A 		"PANIC, undefined operator %d found in do_eval_expr", exp->op);s 	    return 0; 	}     }  } 