 #include <stdio.h> #include <math.h>o #include "simconst.h"i #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"s #include "mstruct.h"  - /* A number used to uniqueify subcircuits. */c static int subnum = 0;  K /*Tempconarray is used as temporary space for subcircuit node conversion.*/p static int *tempconarray;b   initmakesub(maxnode) int maxnode; {iI /* Init the tempconarray which is used as temporary space for conarray.*/iJ   tempconarray = /* Allow the subcircuit to be as big as whole circuit. */- 	(int *) ralloc((2*(maxnode+2)),sizeof(int)); J   tempconarray = &(tempconarray[maxnode+1]); /* Offset for neg indices. */   tempconarray[0] = 0; }o   struct subcircuit *wholesub()  {o& struct subcircuit *subptr, *makesub();4 struct nodedevlist *nextptr, *firstptr, *nodeentptr; struct deventry *nextdev;i
 int i, count;p struct fetti *pmti;u struct fet1 *pm1;l  5 /* Find the first node which is not a source node. */    for(i=1; i <= maxnode; i++)t*     if(   (devarray[i].deventptr != NULL) 2        && (waves[i].present->wavetype != USERSRC) L        && ((dcflag == FALSE) || (waves[i].present->wavetype != ICGIVEN )) ){     firstptr = &(devarray[i]);     devarray[i].prev = NULL;     nextptr = firstptr;n
     break;   }"0 /* Tie all the nodes in the circuit together. */   for(i++; i <= maxnode; i++)[*     if(   (devarray[i].deventptr != NULL) 2        && (waves[i].present->wavetype != USERSRC) L        && ((dcflag == FALSE) || (waves[i].present->wavetype != ICGIVEN )) ){#     nextptr->next = &(devarray[i]);2     devarray[i].prev = nextptr;p     nextptr = &(devarray[i]);t   }t" /* Check out for singularities. */E   for(nextptr = firstptr; nextptr != NULL; nextptr = nextptr->next) {c1     for(count = 0 , nextdev = nextptr->deventptr; B                        nextdev != NULL; nextdev = nextdev->next) {&       switch(nextdev->devptr->utype) {"         case LRES: count++; break;#         case DIODE: count++; break;,"         case FET1: count++; break;#         case FETTI: count++; break;         case LCAP: break;          case ISRC: break;tA         default: printf("Unknown device in wholesub\n"); exit(0);*       }c     } 0 /*    printf("Num of devices = %d\n", count); */   }t   /* Make the subcircuit. */   subptr = makesub(firstptr);z /* Unconnect the nodes. */   for(i=1; i <= maxnode; i++) {r7     devarray[i].prev = NULL;   devarray[i].next = NULL;    }r- /* And return a pointer to the subcircuit. */o   return(subptr);a }t  & struct subcircuit *makesub(nodeentptr) struct nodedevlist *nodeentptr;v {d double *getmat();  struct nodedevlist *nextptr; struct subcircuit *subptr; struct nodewave *wavealloc();e" struct device *devptr, *copymap(); int i; int numobj;d  4 /* Unique number associated with this subcircuit. */   subnum++;s /* Map node zero to zero. */5   devarray[0].flag = subnum; devarray[0].newnode = 0;p    /* Catch a programming error. */!   if(nodeentptr->prev != NULL) { s*     printf("Subcircuit building error.");      exit(0);   }   7 /* Allocate space for and initialize the subcircuit. */iF   subptr = (struct subcircuit *) ralloc(1, sizeof(struct subcircuit));   subptr->external = 0;    subptr->offset = 0;e   subptr->next = NULL;   subptr->ltestep = maxstep;   subptr->lteratio = 1.0;u   subptr->savelteratio = 1.0;oL   subptr->size = 0; /* Get size, assign sequential internal node numbers. */  F /* Get the number of internal nodes in the subcircuit and map them. */G   for(nextptr = nodeentptr; nextptr != NULL; nextptr = nextptr->next) {t     (subptr->size)++; 2     tempconarray[subptr->size] = nextptr->nodenum;-     devarray[nextptr->nodenum].flag = subnum;-6     devarray[nextptr->nodenum].newnode = subptr->size;   }p  ) /* Allocate a matrix and some vectors. */    allocmat(subptr);"L   subptr->predictor = (double *) ralloc((subptr->size + 1), sizeof(double));F   subptr->rhs = (double *) ralloc((subptr->size + 1), sizeof(double));K   subptr->oldstuff = (double *) ralloc((subptr->size + 1), sizeof(double));g  . /* Get all the devices into the subcircuit. */4   subptr->subdevlist = copymap(nodeentptr, subptr); -   subptr->waveptrarray = (struct nodewave **)"L     ralloc((1 + subptr->size - subptr->external),sizeof(struct nodewave *));+   subptr->waveptrarray -= subptr->external;*  2 /* Then get pointers to the external waveforms  */3   for(i=subptr->external; i <= subptr->size; i++) {n     subptr->waveptrarray[i] = % 			wavealloc(tempconarray[i],NOCHNG);    }a    /* Get the node capacitances. */K   subptr->sumcap = (double *) ralloc( (subptr->size + 1), sizeof(double) );AN   subptr->summatptr = (double **) ralloc((subptr->size + 1),sizeof(double *));$   for(i=1; i <= subptr->size; i++) {9     subptr->sumcap[i] = devarray[tempconarray[i]].sumcap; .     subptr->summatptr[i] = getmat(i,i,subptr);   }f  /* Initialize the timepoints. */'   subptr->old2 = &(subptr->tpttemp1);   $   subptr->old = &(subptr->tpttemp2);(   subptr->present = &(subptr->tpttemp3);(   subptr->newtime = &(subptr->tpttemp4);?   inittimept(subptr->present,subptr->size, subptr->external);  d:   inittimept(subptr->old2,subptr->size, subptr->external);9   inittimept(subptr->old,subptr->size, subptr->external); =   inittimept(subptr->newtime,subptr->size, subptr->external);   $ /* Initialize the save old times. */B   inittimept( &(subptr->saveold2),subptr->size, subptr->external);A   inittimept( &(subptr->saveold),subptr->size, subptr->external);hB   inittimept( &(subptr->savepres),subptr->size, subptr->external);A   inittimept( &(subptr->savenew),subptr->size, subptr->external);c   return(subptr);n }a    M /* Checks whether a global node has been mapped to a local subcircuit node */s9 /* and if not, maps it. Returns the local node number. */0 chksubnode(subptr, nodenum)  int nodenum; struct subcircuit *subptr; {o int j;. /* First see if its an already mapped node. */I   if(devarray[nodenum].flag == subnum) return(devarray[nodenum].newnode);e /* Otherwise map the node. */e   (subptr->external)--; +   tempconarray[subptr->external] = nodenum;L"   devarray[nodenum].flag = subnum;/   devarray[nodenum].newnode = subptr->external;]   return(subptr->external);a }y  5 /* Same a chksubnode but do not map unknown nodes. */> nomapchk(subptr, nodenum)s int nodenum; struct subcircuit *subptr; {e int j;. /* First see if its an already mapped node. */I   if(devarray[nodenum].flag == subnum) return(devarray[nodenum].newnode);u /* Otherwise return 0. */    return(0); }l  E /* Chase down device entry list, get the number of external nodes, */o. /* and make a map of local to global nodes. */- /* This map is stored in the tempconarray. */e' struct device *copymap(firstptr,subptr)= struct nodedevlist *firstptr;l struct subcircuit *subptr; {e7 struct device *pdevlist, *pdev, **pnextdev, *initdev();r% struct deventry *entryptr,*pchkentry; ' struct nodedevlist *nextptr, *pchknext;     @ /* Get a pointer to the top of the to be created device list. */   pdevlist = NULL; a   pnextdev = &(pdevlist);)  D /* Chase down the list of devices, and copy, map nodes, and init. */C   for(nextptr = firstptr; nextptr != NULL; nextptr = nextptr->next)a8     for(entryptr = nextptr->deventptr; entryptr != NULL;" 					 entryptr = entryptr->next) {     pdev = entryptr->devptr;D   /* If the flag is not = to subnum this sub hasn't got this dev. */     if(pdev->flag != subnum) { *       pdev->flag = subnum;9       *pnextdev = (*pdev->initdev)(subptr, pdev->devptr);t       if(*pnextdev != NULL) { @ 		(*pnextdev)->next = NULL; pnextdev = &( (*pnextdev)->next ); }     }    }d   return(pdevlist);d }r  & inittimept(timeptr, subsize, external) struct timepoint *timeptr; int subsize, external; {g int numobj; $   numobj = 1 + (subsize - external);A   timeptr->nodevolt = (double *) ralloc( numobj, sizeof(double));;    timeptr->nodevolt -= external;>   timeptr->nodevolt[0] = 0.0;  /* Ground is zero is ground. */   numobj = 1 + subsize;+@   timeptr->current = (double *) ralloc( numobj, sizeof(double));   timeptr->current[0] = 0.0;?   timeptr->charge = (double *) ralloc( numobj, sizeof(double));=   timeptr->charge[0] = 0.0;n   timeptr->time = 0; }    /* Does a byte copy. */r bcopy(to, from, size)a register char *to, *from;o register int size; {/7   for(size--; size >= 0; size--) to[size] = from[size];x }r